// Last edited on 2012-09-24 02:17:28 by stolfilocal
// Frame of a spinning irrotational vortex.

#include "vortex.inc"

#macro frame(tt)
  // A frame of the movie at time {tt} (0 to 1).
  
  global_settings{ max_trace_level 30 }
  background{ color rgb < 1.000, 1.000, 1.000 > }

  #local R = 6.00;        // Radius of curvature of axis.
  #local ra = 0.01;       // Radius of axis.
  #local rc = 0.00;       // Radius of core.
  #local dr = 0.2;        // Spacing between layers. 
  #local nlayers = 4;     // Number of layers.
  #local ang = 12;        // Innermost layer extends from {-ang} to {+ang}.
  #local max_nr = 8;      // Particle rings in innermost layer above and below midplane.
  #local top_nro = 4;     // Particle rings to omit from top in each layer.
  #local bot_nro = 0;     // Particle rings to omit from bot in each layer.
  #local np_min = 3;      // Number of particles per ring in innner layer.
  #local ph = tt/np_min;  // Phase of rotation (0 to 1 for a full turn).
  
  #debug concat("FRAME - CLOCK = ", str(tt,6,4), " PHASE = ", str(ph,6,4), "\n")

  object{ vortex_all(R,ra,rc,dr,ang,max_nr,top_nro,bot_nro,np_min,nlayers,ph) }
  
  #declare vlen = R*2*radians(ang);
  
  #declare cam_rad = 0.83*vlen; 
  #declare cam_ctr = < 0, 0, +0.00*vlen >; 
  #declare cam_dir = <2,3,2>; 
#end
