// Cmeras e luzes padronizadas
// Last edited on 2011-02-16 23:03:10 by stolfilocal

#macro camlight(ctr,rad,cav,dst,upp,lux,lnr,lar)
  // {ctr} = center of interest in scene.
  // {rad} = approx radius of scene.
  // {cav} = vector pointing from {ctr} to camera; only its direction matters.
  // {dst} = the distance from camera to {ctr}.
  // {upp} = the scene's vertical axis ({sky} parameter), usually {z} or {y}.
  // {lux} = a scaling factor for the intensity of standard light sources.
  // {lnr} = number of rings in light cluster.
  // {lar} = angular radius of light cluster.
  #local dir = vnormalize(cav);
  #local len = (dst);
  #local swh = sqrt(image_width/image_height);
  #local ape = 1.41*(rad)/(len);  // Camera aperture.
  camera {
    location (ctr) + len*dir
    right  -swh*ape*x
    up     1.0/swh*ape*y
    sky    (upp)
    look_at (ctr)
  }
  #if (lux > 0)
    #local cam_elev = degrees(atan2(dir.z,sqrt(dir.x*dir.x + dir.y*dir.y)));
    #local cam_azim = degrees(atan2(dir.y,dir.x));
    object{ lamp_array(lnr,lar,lux)
      rotate 360*(sqrt(5)-1)/2*x
      scale 10*len
      rotate -(90 - 0.667*(90 - cam_elev))*y 
      rotate (cam_azim + 15)*z
      translate ctr 
    }
  #end
#end
