// Last edited on 2011-08-11 00:26:45 by stolfilocal
// COORDINATE AXIS

#macro axis_arrow(tip,rad,cor,name)
  #local ctudo = vlength(tip);
  #local cseta = 10*rad;
  #local bseta = ((ctudo - cseta)/ctudo)*tip;
  union{
    sphere{ <0,0,0>, rad }
    cylinder{ <0,0,0>, 1.01*bseta, rad }
    cone{ bseta, 3*rad, tip, 0.00 }
    texture{ pigment{ color rgb cor } finish{ ambient 0.5 diffuse 0.5 } }
  }
#end

#macro axes(len)
  #local rad = 0.005*len;
  union{ 
    object{ axis_arrow( <len,0,0>, rad, <1.0,0.2,0.2>, "X") }
    object{ axis_arrow( <0,len,0>, rad, <0.0,0.8,0.0>, "Y") }
    object{ axis_arrow( <0,0,len>, rad, <0.3,0.3,1.0>, "Z") }
  }
#end

