/* -------------------------------------------- 
     THIS FILE WAS GENERATED BY intl/mapgen4.c
     mapgen4 -condense asia/OTHER/BIG5.TXT 

    Unicode mapping table generated from file asia/OTHER/BIG5.TXT 

#
#	Name:             BIG5 to Unicode table (complete)
#	Unicode version:  1.1
#	Table version:    0.0d3
#	Table format:     Format A
#	Date:             11 February 1994
#	Authors:          Glenn Adams <glenn@metis.com>
#                     John H. Jenkins <John_Jenkins@taligent.com>
#
#
#	This file is provided as-is by Unicode, Inc. (The Unicode Consortium).
#	No claims are made as to fitness for any particular purpose.  No
#	warranties of any kind are expressed or implied.  The recipient
#	agrees to determine applicability of information provided.  If this
#	file has been provided on magnetic media by Unicode, Inc., the sole
#	remedy for any claim will be exchange of defective media within 90
#	days of receipt.
#
#	Recipient is granted the right to make copies in any form for
#	internal distribution and to freely use the information supplied
#	in the creation of products supporting Unicode.  Unicode, Inc.
#	specifically excludes the right to re-distribute this file directly
#	to third parties or other organizations whether for profit or not.
#
#	General notes:
#
#	This table contains the data Metis and Taligent currently have on how
#       BIG5 characters map into Unicode.
#
#	WARNING!  It is currently impossible to provide round-trip compatibility
#		between BIG5 and Unicode.  
#
#	A number of characters are not currently mapped because
#		of conflicts with other mappings.  They are as follows:
#
#       BIG5        Description                    Comments
#
#       0xA15A      SPACING UNDERSCORE             duplicates A1C4
#       0xA1C3      SPACING HEAVY OVERSCORE        not in Unicode
#       0xA1C5      SPACING HEAVY UNDERSCORE       not in Unicode
#       0xA1FE      LT DIAG UP RIGHT TO LOW LEFT   duplicates A2AC
#       0xA240      LT DIAG UP LEFT TO LOW RIGHT   duplicates A2AD
#       0xA2CC      HANGZHOU NUMERAL TEN           conflicts with A451 mapping
#       0xA2CE      HANGZHOU NUMERAL THIRTY        conflicts with A4CA mapping
#
#	We currently map all of these characters to U+FFFD REPLACEMENT CHARACTER.
#		It is also possible to map these characters to their duplicates, or to
#		the user zone.  
#	
#	Notes:
#
#	1. In addition to the above, there is some uncertainty about the
#       mappings in the range C6A1 - C8FE, and F9DD - F9FE.  The ETEN
#		version of BIG5 organizes the former range differently, and adds
#		additional characters in the latter range.  The correct mappings
#		these ranges need to be determined.
#
#	2.  There is an uncertainty in the mapping of the Big Five character
#		0xA3BC.  This character occurs within the Big Five block of tone marks
#		for bopomofo and is intended to be the tone mark for the first tone in
#		Mandarin Chinese.  We have selected the mapping U+02C9 MODIFIER LETTER
#		MACRON (Mandarin Chinese first tone) to reflect this semantic.  
#		However, because bopomofo uses the absense of a tone mark to indicate
#		the first Mandarin tone, most implementations of Big Five represent
#		this character with a blank space, and so a mapping such as U+2003 EM SPACE
#		might be preferred.  
#		
#			
#
#	Format:  Three tab-separated columns
#		 Column #1 is the BIG5 code (in hex as 0xXXXX)
#		 Column #2 is the Unicode (in hex as 0xXXXX)
#		 Column #3  is the Unicode name (follows a comment sign, '#')
#					The official names for Unicode characters U+4E00
#					to U+9FA5, inclusive, is "CJK UNIFIED IDEOGRAPH-XXXX",
#					where XXXX is the code point.  Including all these
#					names in this file increases its size substantially
#					and needlessly.  The token "<CJK>" is used for the
#					name of these characters.  If necessary, it can be
#					expanded algorithmically by a parser or editor.
#
#	The entries are in BIG5 order
#
#	Any comments or problems, contact <John_Jenkins@taligent.com>
#
#
0xA140	0x3000	# IDEOGRAPHIC SPACE
0xA141	0xFF0C	# FULLWIDTH COMMA
0xA142	0x3001	# IDEOGRAPHIC COMMA
0xA143	0x3002	# IDEOGRAPHIC FULL STOP
0xA144	0xFF0E	# FULLWIDTH FULL STOP
0xA145	0x2022	# BULLET
0xA146	0xFF1B	# FULLWIDTH SEMICOLON
0xA147	0xFF1A	# FULLWIDTH COLON
0xA148	0xFF1F	# FULLWIDTH QUESTION MARK
0xA149	0xFF01	# FULLWIDTH EXCLAMATION MARK
0xA14A	0xFE30	# PRESENTATION FORM FOR VERTICAL TWO DOT LEADER
0xA14B	0x2026	# HORIZONTAL ELLIPSIS
0xA14C	0x2025	# TWO DOT LEADER
0xA14D	0xFE50	# SMALL COMMA
0xA14E	0xFF64	# HALFWIDTH IDEOGRAPHIC COMMA
0xA14F	0xFE52	# SMALL FULL STOP
0xA150	0x00B7	# MIDDLE DOT
0xA151	0xFE54	# SMALL SEMICOLON
0xA152	0xFE55	# SMALL COLON
0xA153	0xFE56	# SMALL QUESTION MARK
0xA154	0xFE57	# SMALL EXCLAMATION MARK
0xA155	0xFF5C	# FULLWIDTH VERTICAL BAR
0xA156	0x2013	# EN DASH
0xA157	0xFE31	# PRESENTATION FORM FOR VERTICAL EM DASH
0xA158	0x2014	# EM DASH
0xA159	0xFE33	# PRESENTATION FORM FOR VERTICAL LOW LINE
0xA15A	0xFFFD	# *** NO MAPPING ***
0xA15B	0xFE34	# PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
0xA15C	0xFE4F	# WAVY LOW LINE
0xA15D	0xFF08	# FULLWIDTH LEFT PARENTHESIS
0xA15E	0xFF09	# FULLWIDTH RIGHT PARENTHESIS
0xA15F	0xFE35	# PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS
0xA160	0xFE36	# PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS
0xA161	0xFF5B	# FULLWIDTH LEFT CURLY BRACKET
0xA162	0xFF5D	# FULLWIDTH RIGHT CURLY BRACKET
0xA163	0xFE37	# PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET
0xA164	0xFE38	# PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET
0xA165	0x3014	# LEFT TORTOISE SHELL BRACKET
0xA166	0x3015	# RIGHT TORTOISE SHELL BRACKET
0xA167	0xFE39	# PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET
0xA168	0xFE3A	# PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET
0xA169	0x3010	# LEFT BLACK LENTICULAR BRACKET
0xA16A	0x3011	# RIGHT BLACK LENTICULAR BRACKET
0xA16B	0xFE3B	# PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET
0xA16C	0xFE3C	# PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET
0xA16D	0x300A	# LEFT DOUBLE ANGLE BRACKET
0xA16E	0x300B	# RIGHT DOUBLE ANGLE BRACKET
0xA16F	0xFE3D	# PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET
0xA170	0xFE3E	# PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET
0xA171	0x3008	# LEFT ANGLE BRACKET
0xA172	0x3009	# RIGHT ANGLE BRACKET
0xA173	0xFE3F	# PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET
0xA174	0xFE40	# PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET
0xA175	0x300C	# LEFT CORNER BRACKET
0xA176	0x300D	# RIGHT CORNER BRACKET
0xA177	0xFE41	# PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET
0xA178	0xFE42	# PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET
0xA179	0x300E	# LEFT WHITE CORNER BRACKET
0xA17A	0x300F	# RIGHT WHITE CORNER BRACKET
0xA17B	0xFE43	# PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET
0xA17C	0xFE44	# PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET
0xA17D	0xFE59	# SMALL LEFT PARENTHESIS
0xA17E	0xFE5A	# SMALL RIGHT PARENTHESIS
0xA1A1	0xFE5B	# SMALL LEFT CURLY BRACKET
0xA1A2	0xFE5C	# SMALL RIGHT CURLY BRACKET
0xA1A3	0xFE5D	# SMALL LEFT TORTOISE SHELL BRACKET
0xA1A4	0xFE5E	# SMALL RIGHT TORTOISE SHELL BRACKET
0xA1A5	0x2018	# LEFT SINGLE QUOTATION MARK
0xA1A6	0x2019	# RIGHT SINGLE QUOTATION MARK
0xA1A7	0x201C	# LEFT DOUBLE QUOTATION MARK
0xA1A8	0x201D	# RIGHT DOUBLE QUOTATION MARK
0xA1A9	0x301D	# REVERSED DOUBLE PRIME QUOTATION MARK
0xA1AA	0x301E	# DOUBLE PRIME QUOTATION MARK
0xA1AB	0x2035	# REVERSED PRIME
0xA1AC	0x2032	# PRIME
0xA1AD	0xFF03	# FULLWIDTH NUMBER SIGN
0xA1AE	0xFF06	# FULLWIDTH AMPERSAND
0xA1AF	0xFF0A	# FULLWIDTH ASTERISK
0xA1B0	0x203B	# REFERENCE MARK
0xA1B1	0x00A7	# SECTION SIGN
0xA1B2	0x3003	# DITTO MARK
0xA1B3	0x25CB	# WHITE CIRCLE
0xA1B4	0x25CF	# BLACK CIRCLE
0xA1B5	0x25B3	# WHITE UP-POINTING TRIANGLE
0xA1B6	0x25B2	# BLACK UP-POINTING TRIANGLE
0xA1B7	0x25CE	# BULLSEYE
0xA1B8	0x2606	# WHITE STAR
0xA1B9	0x2605	# BLACK STAR
0xA1BA	0x25C7	# WHITE DIAMOND
0xA1BB	0x25C6	# BLACK DIAMOND
0xA1BC	0x25A1	# WHITE SQUARE
0xA1BD	0x25A0	# BLACK SQUARE
0xA1BE	0x25BD	# WHITE DOWN-POINTING TRIANGLE
0xA1BF	0x25BC	# BLACK DOWN-POINTING TRIANGLE
0xA1C0	0x32A3	# CIRCLED IDEOGRAPH CORRECT
0xA1C1	0x2105	# CARE OF
0xA1C2	0x203E	# OVERLINE
0xA1C3	0xFFFD	# *** NO MAPPING ***
0xA1C4	0xFF3F	# FULLWIDTH LOW LINE
0xA1C5	0xFFFD	# *** NO MAPPING ***
0xA1C6	0xFE49	# DASHED OVERLINE
0xA1C7	0xFE4A	# CENTRELINE OVERLINE
0xA1C8	0xFE4D	# DASHED LOW LINE
0xA1C9	0xFE4E	# CENTRELINE LOW LINE
0xA1CA	0xFE4B	# WAVY OVERLINE
0xA1CB	0xFE4C	# DOUBLE WAVY OVERLINE
0xA1CC	0xFE5F	# SMALL NUMBER SIGN
0xA1CD	0xFE60	# SMALL AMPERSAND
0xA1CE	0xFE61	# SMALL ASTERISK
0xA1CF	0xFF0B	# FULLWIDTH PLUS SIGN
0xA1D0	0xFF0D	# FULLWIDTH HYPHEN-MINUS
0xA1D1	0x00D7	# MULTIPLICATION SIGN
0xA1D2	0x00F7	# DIVISION SIGN
0xA1D3	0x00B1	# PLUS-MINUS SIGN
0xA1D4	0x221A	# SQUARE ROOT
0xA1D5	0xFF1C	# FULLWIDTH LESS-THAN SIGN
0xA1D6	0xFF1E	# FULLWIDTH GREATER-THAN SIGN
0xA1D7	0xFF1D	# FULLWIDTH EQUALS SIGN
0xA1D8	0x2266	# LESS THAN OVER EQUAL TO
0xA1D9	0x2267	# GREATER THAN OVER EQUAL TO
0xA1DA	0x2260	# NOT EQUAL TO
0xA1DB	0x221E	# INFINITY
0xA1DC	0x2252	# APPROXIMATELY EQUAL TO OR THE IMAGE OF
0xA1DD	0x2261	# IDENTICAL TO
0xA1DE	0xFE62	# SMALL PLUS SIGN
0xA1DF	0xFE63	# SMALL HYPHEN-MINUS
0xA1E0	0xFE64	# SMALL LESS-THAN SIGN
0xA1E1	0xFE65	# SMALL GREATER-THAN SIGN
0xA1E2	0xFE66	# SMALL EQUALS SIGN
0xA1E3	0x223C	# TILDE OPERATOR
0xA1E4	0x2229	# INTERSECTION
0xA1E5	0x222A	# UNION
0xA1E6	0x22A5	# UP TACK
0xA1E7	0x2220	# ANGLE
0xA1E8	0x221F	# RIGHT ANGLE
0xA1E9	0x22BF	# RIGHT TRIANGLE
0xA1EA	0x33D2	# SQUARE LOG
0xA1EB	0x33D1	# SQUARE LN
0xA1EC	0x222B	# INTEGRAL
0xA1ED	0x222E	# CONTOUR INTEGRAL
0xA1EE	0x2235	# BECAUSE
0xA1EF	0x2234	# THEREFORE
0xA1F0	0x2640	# FEMALE SIGN
0xA1F1	0x2642	# MALE SIGN
0xA1F2	0x2641	# EARTH
0xA1F3	0x2609	# SUN
0xA1F4	0x2191	# UPWARDS ARROW
0xA1F5	0x2193	# DOWNWARDS ARROW
0xA1F6	0x2190	# LEFTWARDS ARROW
0xA1F7	0x2192	# RIGHTWARDS ARROW
0xA1F8	0x2196	# NORTH WEST ARROW
0xA1F9	0x2197	# NORTH EAST ARROW
0xA1FA	0x2199	# SOUTH WEST ARROW
0xA1FB	0x2198	# SOUTH EAST ARROW
0xA1FC	0x2225	# PARALLEL TO
0xA1FD	0x2223	# DIVIDES
0xA1FE	0xFFFD	# *** NO MAPPING ***
0xA240	0xFFFD	# *** NO MAPPING ***
0xA241	0xFF0F	# FULLWIDTH SOLIDUS
0xA242	0xFF3C	# FULLWIDTH REVERSE SOLIDUS
0xA243	0xFF04	# FULLWIDTH DOLLAR SIGN
0xA244	0x00A5	# YEN SIGN
0xA245	0x3012	# POSTAL MARK
0xA246	0x00A2	# CENT SIGN
0xA247	0x00A3	# POUND SIGN
0xA248	0xFF05	# FULLWIDTH PERCENT SIGN
0xA249	0xFF20	# FULLWIDTH COMMERCIAL AT
0xA24A	0x2103	# DEGREE CELSIUS
0xA24B	0x2109	# DEGREE FAHRENHEIT
0xA24C	0xFE69	# SMALL DOLLAR SIGN
0xA24D	0xFE6A	# SMALL PERCENT SIGN
0xA24E	0xFE6B	# SMALL COMMERCIAL AT
0xA24F	0x33D5	# SQUARE MIL
0xA250	0x339C	# SQUARE MM
0xA251	0x339D	# SQUARE CM
0xA252	0x339E	# SQUARE KM
0xA253	0x33CE	# SQUARE KM CAPITAL
0xA254	0x33A1	# SQUARE M SQUARED
0xA255	0x338E	# SQUARE MG
0xA256	0x338F	# SQUARE KG
0xA257	0x33C4	# SQUARE CC
0xA258	0x00B0	# DEGREE SIGN
0xA259	0x5159	# <CJK>
0xA25A	0x515B	# <CJK>
0xA25B	0x515E	# <CJK>
0xA25C	0x515D	# <CJK>
0xA25D	0x5161	# <CJK>
0xA25E	0x5163	# <CJK>
0xA25F	0x55E7	# <CJK>
0xA260	0x74E9	# <CJK>
0xA261	0x7CCE	# <CJK>
0xA262	0x2581	# LOWER ONE EIGHTH BLOCK
0xA263	0x2582	# LOWER ONE QUARTER BLOCK
0xA264	0x2583	# LOWER THREE EIGHTHS BLOCK
0xA265	0x2584	# LOWER HALF BLOCK
0xA266	0x2585	# LOWER FIVE EIGHTHS BLOCK
0xA267	0x2586	# LOWER THREE QUARTERS BLOCK
0xA268	0x2587	# LOWER SEVEN EIGHTHS BLOCK
0xA269	0x2588	# FULL BLOCK
0xA26A	0x258F	# LEFT ONE EIGHTH BLOCK
0xA26B	0x258E	# LEFT ONE QUARTER BLOCK
0xA26C	0x258D	# LEFT THREE EIGHTHS BLOCK
0xA26D	0x258C	# LEFT HALF BLOCK
0xA26E	0x258B	# LEFT FIVE EIGHTHS BLOCK
0xA26F	0x258A	# LEFT THREE QUARTERS BLOCK
0xA270	0x2589	# LEFT SEVEN EIGHTHS BLOCK
0xA271	0x253C	# BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
0xA272	0x2534	# BOX DRAWINGS LIGHT UP AND HORIZONTAL
0xA273	0x252C	# BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
0xA274	0x2524	# BOX DRAWINGS LIGHT VERTICAL AND LEFT
0xA275	0x251C	# BOX DRAWINGS LIGHT VERTICAL AND RIGHT
0xA276	0x2594	# UPPER ONE EIGHTH BLOCK
0xA277	0x2500	# BOX DRAWINGS LIGHT HORIZONTAL
0xA278	0x2502	# BOX DRAWINGS LIGHT VERTICAL
0xA279	0x2595	# RIGHT ONE EIGHTH BLOCK
0xA27A	0x250C	# BOX DRAWINGS LIGHT DOWN AND RIGHT
0xA27B	0x2510	# BOX DRAWINGS LIGHT DOWN AND LEFT
0xA27C	0x2514	# BOX DRAWINGS LIGHT UP AND RIGHT
0xA27D	0x2518	# BOX DRAWINGS LIGHT UP AND LEFT
0xA27E	0x256D	# BOX DRAWINGS LIGHT ARC DOWN AND RIGHT
0xA2A1	0x256E	# BOX DRAWINGS LIGHT ARC DOWN AND LEFT
0xA2A2	0x2570	# BOX DRAWINGS LIGHT ARC UP AND RIGHT
0xA2A3	0x256F	# BOX DRAWINGS LIGHT ARC UP AND LEFT
0xA2A4	0x2550	# BOX DRAWINGS DOUBLE HORIZONTAL
0xA2A5	0x255E	# BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE
0xA2A6	0x256A	# BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE
0xA2A7	0x2561	# BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE
0xA2A8	0x25E2	# BLACK LOWER RIGHT TRIANGLE
0xA2A9	0x25E3	# BLACK LOWER LEFT TRIANGLE
0xA2AA	0x25E5	# BLACK UPPER RIGHT TRIANGLE
0xA2AB	0x25E4	# BLACK UPPER LEFT TRIANGLE
0xA2AC	0x2571	# BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT
0xA2AD	0x2572	# BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT
0xA2AE	0x2573	# BOX DRAWINGS LIGHT DIAGONAL CROSS
0xA2AF	0xFF10	# FULLWIDTH DIGIT ZERO
0xA2B0	0xFF11	# FULLWIDTH DIGIT ONE
0xA2B1	0xFF12	# FULLWIDTH DIGIT TWO
0xA2B2	0xFF13	# FULLWIDTH DIGIT THREE
0xA2B3	0xFF14	# FULLWIDTH DIGIT FOUR
0xA2B4	0xFF15	# FULLWIDTH DIGIT FIVE
0xA2B5	0xFF16	# FULLWIDTH DIGIT SIX
0xA2B6	0xFF17	# FULLWIDTH DIGIT SEVEN
0xA2B7	0xFF18	# FULLWIDTH DIGIT EIGHT
0xA2B8	0xFF19	# FULLWIDTH DIGIT NINE
0xA2B9	0x2160	# ROMAN NUMERAL ONE
0xA2BA	0x2161	# ROMAN NUMERAL TWO
0xA2BB	0x2162	# ROMAN NUMERAL THREE
0xA2BC	0x2163	# ROMAN NUMERAL FOUR
0xA2BD	0x2164	# ROMAN NUMERAL FIVE
0xA2BE	0x2165	# ROMAN NUMERAL SIX
0xA2BF	0x2166	# ROMAN NUMERAL SEVEN
0xA2C0	0x2167	# ROMAN NUMERAL EIGHT
0xA2C1	0x2168	# ROMAN NUMERAL NINE
0xA2C2	0x2169	# ROMAN NUMERAL TEN
0xA2C3	0x3021	# HANGZHOU NUMERAL ONE
0xA2C4	0x3022	# HANGZHOU NUMERAL TWO
0xA2C5	0x3023	# HANGZHOU NUMERAL THREE
0xA2C6	0x3024	# HANGZHOU NUMERAL FOUR
0xA2C7	0x3025	# HANGZHOU NUMERAL FIVE
0xA2C8	0x3026	# HANGZHOU NUMERAL SIX
0xA2C9	0x3027	# HANGZHOU NUMERAL SEVEN
0xA2CA	0x3028	# HANGZHOU NUMERAL EIGHT
0xA2CB	0x3029	# HANGZHOU NUMERAL NINE
0xA2CC	0xFFFD	# *** NO MAPPING ***
0xA2CD	0x5344	# <CJK>
0xA2CE	0xFFFD	# *** NO MAPPING ***
0xA2CF	0xFF21	# FULLWIDTH LATIN CAPITAL LETTER A
0xA2D0	0xFF22	# FULLWIDTH LATIN CAPITAL LETTER B
0xA2D1	0xFF23	# FULLWIDTH LATIN CAPITAL LETTER C
0xA2D2	0xFF24	# FULLWIDTH LATIN CAPITAL LETTER D
0xA2D3	0xFF25	# FULLWIDTH LATIN CAPITAL LETTER E
0xA2D4	0xFF26	# FULLWIDTH LATIN CAPITAL LETTER F
0xA2D5	0xFF27	# FULLWIDTH LATIN CAPITAL LETTER G
0xA2D6	0xFF28	# FULLWIDTH LATIN CAPITAL LETTER H
0xA2D7	0xFF29	# FULLWIDTH LATIN CAPITAL LETTER I
0xA2D8	0xFF2A	# FULLWIDTH LATIN CAPITAL LETTER J
0xA2D9	0xFF2B	# FULLWIDTH LATIN CAPITAL LETTER K
0xA2DA	0xFF2C	# FULLWIDTH LATIN CAPITAL LETTER L
0xA2DB	0xFF2D	# FULLWIDTH LATIN CAPITAL LETTER M
0xA2DC	0xFF2E	# FULLWIDTH LATIN CAPITAL LETTER N
0xA2DD	0xFF2F	# FULLWIDTH LATIN CAPITAL LETTER O
0xA2DE	0xFF30	# FULLWIDTH LATIN CAPITAL LETTER P
0xA2DF	0xFF31	# FULLWIDTH LATIN CAPITAL LETTER Q
0xA2E0	0xFF32	# FULLWIDTH LATIN CAPITAL LETTER R
0xA2E1	0xFF33	# FULLWIDTH LATIN CAPITAL LETTER S
0xA2E2	0xFF34	# FULLWIDTH LATIN CAPITAL LETTER T
0xA2E3	0xFF35	# FULLWIDTH LATIN CAPITAL LETTER U
0xA2E4	0xFF36	# FULLWIDTH LATIN CAPITAL LETTER V
0xA2E5	0xFF37	# FULLWIDTH LATIN CAPITAL LETTER W
0xA2E6	0xFF38	# FULLWIDTH LATIN CAPITAL LETTER X
0xA2E7	0xFF39	# FULLWIDTH LATIN CAPITAL LETTER Y
0xA2E8	0xFF3A	# FULLWIDTH LATIN CAPITAL LETTER Z
0xA2E9	0xFF41	# FULLWIDTH LATIN SMALL LETTER A
0xA2EA	0xFF42	# FULLWIDTH LATIN SMALL LETTER B
0xA2EB	0xFF43	# FULLWIDTH LATIN SMALL LETTER C
0xA2EC	0xFF44	# FULLWIDTH LATIN SMALL LETTER D
0xA2ED	0xFF45	# FULLWIDTH LATIN SMALL LETTER E
0xA2EE	0xFF46	# FULLWIDTH LATIN SMALL LETTER F
0xA2EF	0xFF47	# FULLWIDTH LATIN SMALL LETTER G
0xA2F0	0xFF48	# FULLWIDTH LATIN SMALL LETTER H
0xA2F1	0xFF49	# FULLWIDTH LATIN SMALL LETTER I
0xA2F2	0xFF4A	# FULLWIDTH LATIN SMALL LETTER J
0xA2F3	0xFF4B	# FULLWIDTH LATIN SMALL LETTER K
0xA2F4	0xFF4C	# FULLWIDTH LATIN SMALL LETTER L
0xA2F5	0xFF4D	# FULLWIDTH LATIN SMALL LETTER M
0xA2F6	0xFF4E	# FULLWIDTH LATIN SMALL LETTER N
0xA2F7	0xFF4F	# FULLWIDTH LATIN SMALL LETTER O
0xA2F8	0xFF50	# FULLWIDTH LATIN SMALL LETTER P
0xA2F9	0xFF51	# FULLWIDTH LATIN SMALL LETTER Q
0xA2FA	0xFF52	# FULLWIDTH LATIN SMALL LETTER R
0xA2FB	0xFF53	# FULLWIDTH LATIN SMALL LETTER S
0xA2FC	0xFF54	# FULLWIDTH LATIN SMALL LETTER T
0xA2FD	0xFF55	# FULLWIDTH LATIN SMALL LETTER U
0xA2FE	0xFF56	# FULLWIDTH LATIN SMALL LETTER V
0xA340	0xFF57	# FULLWIDTH LATIN SMALL LETTER W
0xA341	0xFF58	# FULLWIDTH LATIN SMALL LETTER X
0xA342	0xFF59	# FULLWIDTH LATIN SMALL LETTER Y
0xA343	0xFF5A	# FULLWIDTH LATIN SMALL LETTER Z
0xA344	0x0391	# GREEK CAPITAL LETTER ALPHA
0xA345	0x0392	# GREEK CAPITAL LETTER BETA
0xA346	0x0393	# GREEK CAPITAL LETTER GAMMA
0xA347	0x0394	# GREEK CAPITAL LETTER DELTA
0xA348	0x0395	# GREEK CAPITAL LETTER EPSILON
0xA349	0x0396	# GREEK CAPITAL LETTER ZETA
0xA34A	0x0397	# GREEK CAPITAL LETTER ETA
0xA34B	0x0398	# GREEK CAPITAL LETTER THETA
0xA34C	0x0399	# GREEK CAPITAL LETTER IOTA
0xA34D	0x039A	# GREEK CAPITAL LETTER KAPPA
0xA34E	0x039B	# GREEK CAPITAL LETTER LAMDA
0xA34F	0x039C	# GREEK CAPITAL LETTER MU
0xA350	0x039D	# GREEK CAPITAL LETTER NU
0xA351	0x039E	# GREEK CAPITAL LETTER XI
0xA352	0x039F	# GREEK CAPITAL LETTER OMICRON
0xA353	0x03A0	# GREEK CAPITAL LETTER PI
0xA354	0x03A1	# GREEK CAPITAL LETTER RHO
0xA355	0x03A3	# GREEK CAPITAL LETTER SIGMA
0xA356	0x03A4	# GREEK CAPITAL LETTER TAU
0xA357	0x03A5	# GREEK CAPITAL LETTER UPSILON
0xA358	0x03A6	# GREEK CAPITAL LETTER PHI
0xA359	0x03A7	# GREEK CAPITAL LETTER CHI
0xA35A	0x03A8	# GREEK CAPITAL LETTER PSI
0xA35B	0x03A9	# GREEK CAPITAL LETTER OMEGA
0xA35C	0x03B1	# GREEK SMALL LETTER ALPHA
0xA35D	0x03B2	# GREEK SMALL LETTER BETA
0xA35E	0x03B3	# GREEK SMALL LETTER GAMMA
0xA35F	0x03B4	# GREEK SMALL LETTER DELTA
0xA360	0x03B5	# GREEK SMALL LETTER EPSILON
0xA361	0x03B6	# GREEK SMALL LETTER ZETA
0xA362	0x03B7	# GREEK SMALL LETTER ETA
0xA363	0x03B8	# GREEK SMALL LETTER THETA
0xA364	0x03B9	# GREEK SMALL LETTER IOTA
0xA365	0x03BA	# GREEK SMALL LETTER KAPPA
0xA366	0x03BB	# GREEK SMALL LETTER LAMDA
0xA367	0x03BC	# GREEK SMALL LETTER MU
0xA368	0x03BD	# GREEK SMALL LETTER NU
0xA369	0x03BE	# GREEK SMALL LETTER XI
0xA36A	0x03BF	# GREEK SMALL LETTER OMICRON
0xA36B	0x03C0	# GREEK SMALL LETTER PI
0xA36C	0x03C1	# GREEK SMALL LETTER RHO
0xA36D	0x03C3	# GREEK SMALL LETTER SIGMA
0xA36E	0x03C4	# GREEK SMALL LETTER TAU
0xA36F	0x03C5	# GREEK SMALL LETTER UPSILON
0xA370	0x03C6	# GREEK SMALL LETTER PHI
0xA371	0x03C7	# GREEK SMALL LETTER CHI
0xA372	0x03C8	# GREEK SMALL LETTER PSI
0xA373	0x03C9	# GREEK SMALL LETTER OMEGA
0xA374	0x3105	# BOPOMOFO LETTER B
0xA375	0x3106	# BOPOMOFO LETTER P
0xA376	0x3107	# BOPOMOFO LETTER M
0xA377	0x3108	# BOPOMOFO LETTER F
0xA378	0x3109	# BOPOMOFO LETTER D
0xA379	0x310A	# BOPOMOFO LETTER T
0xA37A	0x310B	# BOPOMOFO LETTER N
0xA37B	0x310C	# BOPOMOFO LETTER L
0xA37C	0x310D	# BOPOMOFO LETTER G
0xA37D	0x310E	# BOPOMOFO LETTER K
0xA37E	0x310F	# BOPOMOFO LETTER H
0xA3A1	0x3110	# BOPOMOFO LETTER J
0xA3A2	0x3111	# BOPOMOFO LETTER Q
0xA3A3	0x3112	# BOPOMOFO LETTER X
0xA3A4	0x3113	# BOPOMOFO LETTER ZH
0xA3A5	0x3114	# BOPOMOFO LETTER CH
0xA3A6	0x3115	# BOPOMOFO LETTER SH
0xA3A7	0x3116	# BOPOMOFO LETTER R
0xA3A8	0x3117	# BOPOMOFO LETTER Z
0xA3A9	0x3118	# BOPOMOFO LETTER C
0xA3AA	0x3119	# BOPOMOFO LETTER S
0xA3AB	0x311A	# BOPOMOFO LETTER A
0xA3AC	0x311B	# BOPOMOFO LETTER O
0xA3AD	0x311C	# BOPOMOFO LETTER E
0xA3AE	0x311D	# BOPOMOFO LETTER EH
0xA3AF	0x311E	# BOPOMOFO LETTER AI
0xA3B0	0x311F	# BOPOMOFO LETTER EI
0xA3B1	0x3120	# BOPOMOFO LETTER AU
0xA3B2	0x3121	# BOPOMOFO LETTER OU
0xA3B3	0x3122	# BOPOMOFO LETTER AN
0xA3B4	0x3123	# BOPOMOFO LETTER EN
0xA3B5	0x3124	# BOPOMOFO LETTER ANG
0xA3B6	0x3125	# BOPOMOFO LETTER ENG
0xA3B7	0x3126	# BOPOMOFO LETTER ER
0xA3B8	0x3127	# BOPOMOFO LETTER I
0xA3B9	0x3128	# BOPOMOFO LETTER U
0xA3BA	0x3129	# BOPOMOFO LETTER IU
0xA3BB	0x02D9	# DOT ABOVE (Mandarin Chinese light tone)
0xA3BC	0x02C9	# MODIFIER LETTER MACRON (Mandarin Chinese first tone)
0xA3BD	0x02CA	# MODIFIER LETTER ACUTE ACCENT (Mandarin Chinese second tone)
0xA3BE	0x02C7	# CARON (Mandarin Chinese third tone)
0xA3BF	0x02CB	# MODIFIER LETTER GRAVE ACCENT (Mandarin Chinese fourth tone)
0xA440	0x4E00	# <CJK>
0xA441	0x4E59	# <CJK>
0xA442	0x4E01	# <CJK>
0xA443	0x4E03	# <CJK>
0xA444	0x4E43	# <CJK>
0xA445	0x4E5D	# <CJK>
0xA446	0x4E86	# <CJK>
0xA447	0x4E8C	# <CJK>
0xA448	0x4EBA	# <CJK>
0xA449	0x513F	# <CJK>
0xA44A	0x5165	# <CJK>
0xA44B	0x516B	# <CJK>
0xA44C	0x51E0	# <CJK>
0xA44D	0x5200	# <CJK>
0xA44E	0x5201	# <CJK>
0xA44F	0x529B	# <CJK>
0xA450	0x5315	# <CJK>
0xA451	0x5341	# <CJK>
0xA452	0x535C	# <CJK>
0xA453	0x53C8	# <CJK>
0xA454	0x4E09	# <CJK>
0xA455	0x4E0B	# <CJK>
0xA456	0x4E08	# <CJK>
0xA457	0x4E0A	# <CJK>
0xA458	0x4E2B	# <CJK>
0xA459	0x4E38	# <CJK>
0xA45A	0x51E1	# <CJK>
0xA45B	0x4E45	# <CJK>
0xA45C	0x4E48	# <CJK>
0xA45D	0x4E5F	# <CJK>
0xA45E	0x4E5E	# <CJK>
0xA45F	0x4E8E	# <CJK>
0xA460	0x4EA1	# <CJK>
0xA461	0x5140	# <CJK>
0xA462	0x5203	# <CJK>
0xA463	0x52FA	# <CJK>
0xA464	0x5343	# <CJK>
0xA465	0x53C9	# <CJK>
0xA466	0x53E3	# <CJK>
0xA467	0x571F	# <CJK>
0xA468	0x58EB	# <CJK>
0xA469	0x5915	# <CJK>
0xA46A	0x5927	# <CJK>
0xA46B	0x5973	# <CJK>
0xA46C	0x5B50	# <CJK>
0xA46D	0x5B51	# <CJK>
0xA46E	0x5B53	# <CJK>
0xA46F	0x5BF8	# <CJK>
0xA470	0x5C0F	# <CJK>
0xA471	0x5C22	# <CJK>
0xA472	0x5C38	# <CJK>
0xA473	0x5C71	# <CJK>
0xA474	0x5DDD	# <CJK>
0xA475	0x5DE5	# <CJK>
0xA476	0x5DF1	# <CJK>
0xA477	0x5DF2	# <CJK>
0xA478	0x5DF3	# <CJK>
0xA479	0x5DFE	# <CJK>
0xA47A	0x5E72	# <CJK>
0xA47B	0x5EFE	# <CJK>
0xA47C	0x5F0B	# <CJK>
0xA47D	0x5F13	# <CJK>
0xA47E	0x624D	# <CJK>
0xA4A1	0x4E11	# <CJK>
0xA4A2	0x4E10	# <CJK>
0xA4A3	0x4E0D	# <CJK>
0xA4A4	0x4E2D	# <CJK>
0xA4A5	0x4E30	# <CJK>
0xA4A6	0x4E39	# <CJK>
0xA4A7	0x4E4B	# <CJK>
0xA4A8	0x5C39	# <CJK>
0xA4A9	0x4E88	# <CJK>
0xA4AA	0x4E91	# <CJK>
0xA4AB	0x4E95	# <CJK>
0xA4AC	0x4E92	# <CJK>
0xA4AD	0x4E94	# <CJK>
0xA4AE	0x4EA2	# <CJK>
0xA4AF	0x4EC1	# <CJK>
0xA4B0	0x4EC0	# <CJK>
0xA4B1	0x4EC3	# <CJK>
0xA4B2	0x4EC6	# <CJK>
0xA4B3	0x4EC7	# <CJK>
0xA4B4	0x4ECD	# <CJK>
0xA4B5	0x4ECA	# <CJK>
0xA4B6	0x4ECB	# <CJK>
0xA4B7	0x4EC4	# <CJK>
0xA4B8	0x5143	# <CJK>
0xA4B9	0x5141	# <CJK>
0xA4BA	0x5167	# <CJK>
0xA4BB	0x516D	# <CJK>
0xA4BC	0x516E	# <CJK>
0xA4BD	0x516C	# <CJK>
0xA4BE	0x5197	# <CJK>
0xA4BF	0x51F6	# <CJK>
0xA4C0	0x5206	# <CJK>
0xA4C1	0x5207	# <CJK>
0xA4C2	0x5208	# <CJK>
0xA4C3	0x52FB	# <CJK>
0xA4C4	0x52FE	# <CJK>
0xA4C5	0x52FF	# <CJK>
0xA4C6	0x5316	# <CJK>
0xA4C7	0x5339	# <CJK>
0xA4C8	0x5348	# <CJK>
0xA4C9	0x5347	# <CJK>
0xA4CA	0x5345	# <CJK>
0xA4CB	0x535E	# <CJK>
0xA4CC	0x5384	# <CJK>
0xA4CD	0x53CB	# <CJK>
0xA4CE	0x53CA	# <CJK>
0xA4CF	0x53CD	# <CJK>
0xA4D0	0x58EC	# <CJK>
0xA4D1	0x5929	# <CJK>
0xA4D2	0x592B	# <CJK>
0xA4D3	0x592A	# <CJK>
0xA4D4	0x592D	# <CJK>
0xA4D5	0x5B54	# <CJK>
0xA4D6	0x5C11	# <CJK>
0xA4D7	0x5C24	# <CJK>
0xA4D8	0x5C3A	# <CJK>
0xA4D9	0x5C6F	# <CJK>
0xA4DA	0x5DF4	# <CJK>
0xA4DB	0x5E7B	# <CJK>
0xA4DC	0x5EFF	# <CJK>
0xA4DD	0x5F14	# <CJK>
0xA4DE	0x5F15	# <CJK>
0xA4DF	0x5FC3	# <CJK>
0xA4E0	0x6208	# <CJK>
0xA4E1	0x6236	# <CJK>
0xA4E2	0x624B	# <CJK>
0xA4E3	0x624E	# <CJK>
0xA4E4	0x652F	# <CJK>
0xA4E5	0x6587	# <CJK>
0xA4E6	0x6597	# <CJK>
0xA4E7	0x65A4	# <CJK>
0xA4E8	0x65B9	# <CJK>
0xA4E9	0x65E5	# <CJK>
0xA4EA	0x66F0	# <CJK>
0xA4EB	0x6708	# <CJK>
0xA4EC	0x6728	# <CJK>
0xA4ED	0x6B20	# <CJK>
0xA4EE	0x6B62	# <CJK>
0xA4EF	0x6B79	# <CJK>
0xA4F0	0x6BCB	# <CJK>
0xA4F1	0x6BD4	# <CJK>
0xA4F2	0x6BDB	# <CJK>
0xA4F3	0x6C0F	# <CJK>
0xA4F4	0x6C34	# <CJK>
0xA4F5	0x706B	# <CJK>
0xA4F6	0x722A	# <CJK>
0xA4F7	0x7236	# <CJK>
0xA4F8	0x723B	# <CJK>
0xA4F9	0x7247	# <CJK>
0xA4FA	0x7259	# <CJK>
0xA4FB	0x725B	# <CJK>
0xA4FC	0x72AC	# <CJK>
0xA4FD	0x738B	# <CJK>
0xA4FE	0x4E19	# <CJK>
0xA540	0x4E16	# <CJK>
0xA541	0x4E15	# <CJK>
0xA542	0x4E14	# <CJK>
0xA543	0x4E18	# <CJK>
0xA544	0x4E3B	# <CJK>
0xA545	0x4E4D	# <CJK>
0xA546	0x4E4F	# <CJK>
0xA547	0x4E4E	# <CJK>
0xA548	0x4EE5	# <CJK>
0xA549	0x4ED8	# <CJK>
0xA54A	0x4ED4	# <CJK>
0xA54B	0x4ED5	# <CJK>
0xA54C	0x4ED6	# <CJK>
0xA54D	0x4ED7	# <CJK>
0xA54E	0x4EE3	# <CJK>
0xA54F	0x4EE4	# <CJK>
0xA550	0x4ED9	# <CJK>
0xA551	0x4EDE	# <CJK>
0xA552	0x5145	# <CJK>
0xA553	0x5144	# <CJK>
0xA554	0x5189	# <CJK>
0xA555	0x518A	# <CJK>
0xA556	0x51AC	# <CJK>
0xA557	0x51F9	# <CJK>
0xA558	0x51FA	# <CJK>
0xA559	0x51F8	# <CJK>
0xA55A	0x520A	# <CJK>
0xA55B	0x52A0	# <CJK>
0xA55C	0x529F	# <CJK>
0xA55D	0x5305	# <CJK>
0xA55E	0x5306	# <CJK>
0xA55F	0x5317	# <CJK>
0xA560	0x531D	# <CJK>
0xA561	0x4EDF	# <CJK>
0xA562	0x534A	# <CJK>
0xA563	0x5349	# <CJK>
0xA564	0x5361	# <CJK>
0xA565	0x5360	# <CJK>
0xA566	0x536F	# <CJK>
0xA567	0x536E	# <CJK>
0xA568	0x53BB	# <CJK>
0xA569	0x53EF	# <CJK>
0xA56A	0x53E4	# <CJK>
0xA56B	0x53F3	# <CJK>
0xA56C	0x53EC	# <CJK>
0xA56D	0x53EE	# <CJK>
0xA56E	0x53E9	# <CJK>
0xA56F	0x53E8	# <CJK>
0xA570	0x53FC	# <CJK>
0xA571	0x53F8	# <CJK>
0xA572	0x53F5	# <CJK>
0xA573	0x53EB	# <CJK>
0xA574	0x53E6	# <CJK>
0xA575	0x53EA	# <CJK>
0xA576	0x53F2	# <CJK>
0xA577	0x53F1	# <CJK>
0xA578	0x53F0	# <CJK>
0xA579	0x53E5	# <CJK>
0xA57A	0x53ED	# <CJK>
0xA57B	0x53FB	# <CJK>
0xA57C	0x56DB	# <CJK>
0xA57D	0x56DA	# <CJK>
0xA57E	0x5916	# <CJK>
0xA5A1	0x592E	# <CJK>
0xA5A2	0x5931	# <CJK>
0xA5A3	0x5974	# <CJK>
0xA5A4	0x5976	# <CJK>
0xA5A5	0x5B55	# <CJK>
0xA5A6	0x5B83	# <CJK>
0xA5A7	0x5C3C	# <CJK>
0xA5A8	0x5DE8	# <CJK>
0xA5A9	0x5DE7	# <CJK>
0xA5AA	0x5DE6	# <CJK>
0xA5AB	0x5E02	# <CJK>
0xA5AC	0x5E03	# <CJK>
0xA5AD	0x5E73	# <CJK>
0xA5AE	0x5E7C	# <CJK>
0xA5AF	0x5F01	# <CJK>
0xA5B0	0x5F18	# <CJK>
0xA5B1	0x5F17	# <CJK>
0xA5B2	0x5FC5	# <CJK>
0xA5B3	0x620A	# <CJK>
0xA5B4	0x6253	# <CJK>
0xA5B5	0x6254	# <CJK>
0xA5B6	0x6252	# <CJK>
0xA5B7	0x6251	# <CJK>
0xA5B8	0x65A5	# <CJK>
0xA5B9	0x65E6	# <CJK>
0xA5BA	0x672E	# <CJK>
0xA5BB	0x672C	# <CJK>
0xA5BC	0x672A	# <CJK>
0xA5BD	0x672B	# <CJK>
0xA5BE	0x672D	# <CJK>
0xA5BF	0x6B63	# <CJK>
0xA5C0	0x6BCD	# <CJK>
0xA5C1	0x6C11	# <CJK>
0xA5C2	0x6C10	# <CJK>
0xA5C3	0x6C38	# <CJK>
0xA5C4	0x6C41	# <CJK>
0xA5C5	0x6C40	# <CJK>
0xA5C6	0x6C3E	# <CJK>
0xA5C7	0x72AF	# <CJK>
0xA5C8	0x7384	# <CJK>
0xA5C9	0x7389	# <CJK>
0xA5CA	0x74DC	# <CJK>
0xA5CB	0x74E6	# <CJK>
0xA5CC	0x7518	# <CJK>
0xA5CD	0x751F	# <CJK>
0xA5CE	0x7528	# <CJK>
0xA5CF	0x7529	# <CJK>
0xA5D0	0x7530	# <CJK>
0xA5D1	0x7531	# <CJK>
0xA5D2	0x7532	# <CJK>
0xA5D3	0x7533	# <CJK>
0xA5D4	0x758B	# <CJK>
0xA5D5	0x767D	# <CJK>
0xA5D6	0x76AE	# <CJK>
0xA5D7	0x76BF	# <CJK>
0xA5D8	0x76EE	# <CJK>
0xA5D9	0x77DB	# <CJK>
0xA5DA	0x77E2	# <CJK>
0xA5DB	0x77F3	# <CJK>
0xA5DC	0x793A	# <CJK>
0xA5DD	0x79BE	# <CJK>
0xA5DE	0x7A74	# <CJK>
0xA5DF	0x7ACB	# <CJK>
0xA5E0	0x4E1E	# <CJK>
0xA5E1	0x4E1F	# <CJK>
0xA5E2	0x4E52	# <CJK>
0xA5E3	0x4E53	# <CJK>
0xA5E4	0x4E69	# <CJK>
0xA5E5	0x4E99	# <CJK>
0xA5E6	0x4EA4	# <CJK>
0xA5E7	0x4EA6	# <CJK>
0xA5E8	0x4EA5	# <CJK>
0xA5E9	0x4EFF	# <CJK>
0xA5EA	0x4F09	# <CJK>
0xA5EB	0x4F19	# <CJK>
0xA5EC	0x4F0A	# <CJK>
0xA5ED	0x4F15	# <CJK>
0xA5EE	0x4F0D	# <CJK>
0xA5EF	0x4F10	# <CJK>
0xA5F0	0x4F11	# <CJK>
0xA5F1	0x4F0F	# <CJK>
0xA5F2	0x4EF2	# <CJK>
0xA5F3	0x4EF6	# <CJK>
0xA5F4	0x4EFB	# <CJK>
0xA5F5	0x4EF0	# <CJK>
0xA5F6	0x4EF3	# <CJK>
0xA5F7	0x4EFD	# <CJK>
0xA5F8	0x4F01	# <CJK>
0xA5F9	0x4F0B	# <CJK>
0xA5FA	0x5149	# <CJK>
0xA5FB	0x5147	# <CJK>
0xA5FC	0x5146	# <CJK>
0xA5FD	0x5148	# <CJK>
0xA5FE	0x5168	# <CJK>
0xA640	0x5171	# <CJK>
0xA641	0x518D	# <CJK>
0xA642	0x51B0	# <CJK>
0xA643	0x5217	# <CJK>
0xA644	0x5211	# <CJK>
0xA645	0x5212	# <CJK>
0xA646	0x520E	# <CJK>
0xA647	0x5216	# <CJK>
0xA648	0x52A3	# <CJK>
0xA649	0x5308	# <CJK>
0xA64A	0x5321	# <CJK>
0xA64B	0x5320	# <CJK>
0xA64C	0x5370	# <CJK>
0xA64D	0x5371	# <CJK>
0xA64E	0x5409	# <CJK>
0xA64F	0x540F	# <CJK>
0xA650	0x540C	# <CJK>
0xA651	0x540A	# <CJK>
0xA652	0x5410	# <CJK>
0xA653	0x5401	# <CJK>
0xA654	0x540B	# <CJK>
0xA655	0x5404	# <CJK>
0xA656	0x5411	# <CJK>
0xA657	0x540D	# <CJK>
0xA658	0x5408	# <CJK>
0xA659	0x5403	# <CJK>
0xA65A	0x540E	# <CJK>
0xA65B	0x5406	# <CJK>
0xA65C	0x5412	# <CJK>
0xA65D	0x56E0	# <CJK>
0xA65E	0x56DE	# <CJK>
0xA65F	0x56DD	# <CJK>
0xA660	0x5733	# <CJK>
0xA661	0x5730	# <CJK>
0xA662	0x5728	# <CJK>
0xA663	0x572D	# <CJK>
0xA664	0x572C	# <CJK>
0xA665	0x572F	# <CJK>
0xA666	0x5729	# <CJK>
0xA667	0x5919	# <CJK>
0xA668	0x591A	# <CJK>
0xA669	0x5937	# <CJK>
0xA66A	0x5938	# <CJK>
0xA66B	0x5984	# <CJK>
0xA66C	0x5978	# <CJK>
0xA66D	0x5983	# <CJK>
0xA66E	0x597D	# <CJK>
0xA66F	0x5979	# <CJK>
0xA670	0x5982	# <CJK>
0xA671	0x5981	# <CJK>
0xA672	0x5B57	# <CJK>
0xA673	0x5B58	# <CJK>
0xA674	0x5B87	# <CJK>
0xA675	0x5B88	# <CJK>
0xA676	0x5B85	# <CJK>
0xA677	0x5B89	# <CJK>
0xA678	0x5BFA	# <CJK>
0xA679	0x5C16	# <CJK>
0xA67A	0x5C79	# <CJK>
0xA67B	0x5DDE	# <CJK>
0xA67C	0x5E06	# <CJK>
0xA67D	0x5E76	# <CJK>
0xA67E	0x5E74	# <CJK>
0xA6A1	0x5F0F	# <CJK>
0xA6A2	0x5F1B	# <CJK>
0xA6A3	0x5FD9	# <CJK>
0xA6A4	0x5FD6	# <CJK>
0xA6A5	0x620E	# <CJK>
0xA6A6	0x620C	# <CJK>
0xA6A7	0x620D	# <CJK>
0xA6A8	0x6210	# <CJK>
0xA6A9	0x6263	# <CJK>
0xA6AA	0x625B	# <CJK>
0xA6AB	0x6258	# <CJK>
0xA6AC	0x6536	# <CJK>
0xA6AD	0x65E9	# <CJK>
0xA6AE	0x65E8	# <CJK>
0xA6AF	0x65EC	# <CJK>
0xA6B0	0x65ED	# <CJK>
0xA6B1	0x66F2	# <CJK>
0xA6B2	0x66F3	# <CJK>
0xA6B3	0x6709	# <CJK>
0xA6B4	0x673D	# <CJK>
0xA6B5	0x6734	# <CJK>
0xA6B6	0x6731	# <CJK>
0xA6B7	0x6735	# <CJK>
0xA6B8	0x6B21	# <CJK>
0xA6B9	0x6B64	# <CJK>
0xA6BA	0x6B7B	# <CJK>
0xA6BB	0x6C16	# <CJK>
0xA6BC	0x6C5D	# <CJK>
0xA6BD	0x6C57	# <CJK>
0xA6BE	0x6C59	# <CJK>
0xA6BF	0x6C5F	# <CJK>
0xA6C0	0x6C60	# <CJK>
0xA6C1	0x6C50	# <CJK>
0xA6C2	0x6C55	# <CJK>
0xA6C3	0x6C61	# <CJK>
0xA6C4	0x6C5B	# <CJK>
0xA6C5	0x6C4D	# <CJK>
0xA6C6	0x6C4E	# <CJK>
0xA6C7	0x7070	# <CJK>
0xA6C8	0x725F	# <CJK>
0xA6C9	0x725D	# <CJK>
0xA6CA	0x767E	# <CJK>
0xA6CB	0x7AF9	# <CJK>
0xA6CC	0x7C73	# <CJK>
0xA6CD	0x7CF8	# <CJK>
0xA6CE	0x7F36	# <CJK>
0xA6CF	0x7F8A	# <CJK>
0xA6D0	0x7FBD	# <CJK>
0xA6D1	0x8001	# <CJK>
0xA6D2	0x8003	# <CJK>
0xA6D3	0x800C	# <CJK>
0xA6D4	0x8012	# <CJK>
0xA6D5	0x8033	# <CJK>
0xA6D6	0x807F	# <CJK>
0xA6D7	0x8089	# <CJK>
0xA6D8	0x808B	# <CJK>
0xA6D9	0x808C	# <CJK>
0xA6DA	0x81E3	# <CJK>
0xA6DB	0x81EA	# <CJK>
0xA6DC	0x81F3	# <CJK>
0xA6DD	0x81FC	# <CJK>
0xA6DE	0x820C	# <CJK>
0xA6DF	0x821B	# <CJK>
0xA6E0	0x821F	# <CJK>
0xA6E1	0x826E	# <CJK>
0xA6E2	0x8272	# <CJK>
0xA6E3	0x827E	# <CJK>
0xA6E4	0x866B	# <CJK>
0xA6E5	0x8840	# <CJK>
0xA6E6	0x884C	# <CJK>
0xA6E7	0x8863	# <CJK>
0xA6E8	0x897F	# <CJK>
0xA6E9	0x9621	# <CJK>
0xA6EA	0x4E32	# <CJK>
0xA6EB	0x4EA8	# <CJK>
0xA6EC	0x4F4D	# <CJK>
0xA6ED	0x4F4F	# <CJK>
0xA6EE	0x4F47	# <CJK>
0xA6EF	0x4F57	# <CJK>
0xA6F0	0x4F5E	# <CJK>
0xA6F1	0x4F34	# <CJK>
0xA6F2	0x4F5B	# <CJK>
0xA6F3	0x4F55	# <CJK>
0xA6F4	0x4F30	# <CJK>
0xA6F5	0x4F50	# <CJK>
0xA6F6	0x4F51	# <CJK>
0xA6F7	0x4F3D	# <CJK>
0xA6F8	0x4F3A	# <CJK>
0xA6F9	0x4F38	# <CJK>
0xA6FA	0x4F43	# <CJK>
0xA6FB	0x4F54	# <CJK>
0xA6FC	0x4F3C	# <CJK>
0xA6FD	0x4F46	# <CJK>
0xA6FE	0x4F63	# <CJK>
0xA740	0x4F5C	# <CJK>
0xA741	0x4F60	# <CJK>
0xA742	0x4F2F	# <CJK>
0xA743	0x4F4E	# <CJK>
0xA744	0x4F36	# <CJK>
0xA745	0x4F59	# <CJK>
0xA746	0x4F5D	# <CJK>
0xA747	0x4F48	# <CJK>
0xA748	0x4F5A	# <CJK>
0xA749	0x514C	# <CJK>
0xA74A	0x514B	# <CJK>
0xA74B	0x514D	# <CJK>
0xA74C	0x5175	# <CJK>
0xA74D	0x51B6	# <CJK>
0xA74E	0x51B7	# <CJK>
0xA74F	0x5225	# <CJK>
0xA750	0x5224	# <CJK>
0xA751	0x5229	# <CJK>
0xA752	0x522A	# <CJK>
0xA753	0x5228	# <CJK>
0xA754	0x52AB	# <CJK>
0xA755	0x52A9	# <CJK>
0xA756	0x52AA	# <CJK>
0xA757	0x52AC	# <CJK>
0xA758	0x5323	# <CJK>
0xA759	0x5373	# <CJK>
0xA75A	0x5375	# <CJK>
0xA75B	0x541D	# <CJK>
0xA75C	0x542D	# <CJK>
0xA75D	0x541E	# <CJK>
0xA75E	0x543E	# <CJK>
0xA75F	0x5426	# <CJK>
0xA760	0x544E	# <CJK>
0xA761	0x5427	# <CJK>
0xA762	0x5446	# <CJK>
0xA763	0x5443	# <CJK>
0xA764	0x5433	# <CJK>
0xA765	0x5448	# <CJK>
0xA766	0x5442	# <CJK>
0xA767	0x541B	# <CJK>
0xA768	0x5429	# <CJK>
0xA769	0x544A	# <CJK>
0xA76A	0x5439	# <CJK>
0xA76B	0x543B	# <CJK>
0xA76C	0x5438	# <CJK>
0xA76D	0x542E	# <CJK>
0xA76E	0x5435	# <CJK>
0xA76F	0x5436	# <CJK>
0xA770	0x5420	# <CJK>
0xA771	0x543C	# <CJK>
0xA772	0x5440	# <CJK>
0xA773	0x5431	# <CJK>
0xA774	0x542B	# <CJK>
0xA775	0x541F	# <CJK>
0xA776	0x542C	# <CJK>
0xA777	0x56EA	# <CJK>
0xA778	0x56F0	# <CJK>
0xA779	0x56E4	# <CJK>
0xA77A	0x56EB	# <CJK>
0xA77B	0x574A	# <CJK>
0xA77C	0x5751	# <CJK>
0xA77D	0x5740	# <CJK>
0xA77E	0x574D	# <CJK>
0xA7A1	0x5747	# <CJK>
0xA7A2	0x574E	# <CJK>
0xA7A3	0x573E	# <CJK>
0xA7A4	0x5750	# <CJK>
0xA7A5	0x574F	# <CJK>
0xA7A6	0x573B	# <CJK>
0xA7A7	0x58EF	# <CJK>
0xA7A8	0x593E	# <CJK>
0xA7A9	0x599D	# <CJK>
0xA7AA	0x5992	# <CJK>
0xA7AB	0x59A8	# <CJK>
0xA7AC	0x599E	# <CJK>
0xA7AD	0x59A3	# <CJK>
0xA7AE	0x5999	# <CJK>
0xA7AF	0x5996	# <CJK>
0xA7B0	0x598D	# <CJK>
0xA7B1	0x59A4	# <CJK>
0xA7B2	0x5993	# <CJK>
0xA7B3	0x598A	# <CJK>
0xA7B4	0x59A5	# <CJK>
0xA7B5	0x5B5D	# <CJK>
0xA7B6	0x5B5C	# <CJK>
0xA7B7	0x5B5A	# <CJK>
0xA7B8	0x5B5B	# <CJK>
0xA7B9	0x5B8C	# <CJK>
0xA7BA	0x5B8B	# <CJK>
0xA7BB	0x5B8F	# <CJK>
0xA7BC	0x5C2C	# <CJK>
0xA7BD	0x5C40	# <CJK>
0xA7BE	0x5C41	# <CJK>
0xA7BF	0x5C3F	# <CJK>
0xA7C0	0x5C3E	# <CJK>
0xA7C1	0x5C90	# <CJK>
0xA7C2	0x5C91	# <CJK>
0xA7C3	0x5C94	# <CJK>
0xA7C4	0x5C8C	# <CJK>
0xA7C5	0x5DEB	# <CJK>
0xA7C6	0x5E0C	# <CJK>
0xA7C7	0x5E8F	# <CJK>
0xA7C8	0x5E87	# <CJK>
0xA7C9	0x5E8A	# <CJK>
0xA7CA	0x5EF7	# <CJK>
0xA7CB	0x5F04	# <CJK>
0xA7CC	0x5F1F	# <CJK>
0xA7CD	0x5F64	# <CJK>
0xA7CE	0x5F62	# <CJK>
0xA7CF	0x5F77	# <CJK>
0xA7D0	0x5F79	# <CJK>
0xA7D1	0x5FD8	# <CJK>
0xA7D2	0x5FCC	# <CJK>
0xA7D3	0x5FD7	# <CJK>
0xA7D4	0x5FCD	# <CJK>
0xA7D5	0x5FF1	# <CJK>
0xA7D6	0x5FEB	# <CJK>
0xA7D7	0x5FF8	# <CJK>
0xA7D8	0x5FEA	# <CJK>
0xA7D9	0x6212	# <CJK>
0xA7DA	0x6211	# <CJK>
0xA7DB	0x6284	# <CJK>
0xA7DC	0x6297	# <CJK>
0xA7DD	0x6296	# <CJK>
0xA7DE	0x6280	# <CJK>
0xA7DF	0x6276	# <CJK>
0xA7E0	0x6289	# <CJK>
0xA7E1	0x626D	# <CJK>
0xA7E2	0x628A	# <CJK>
0xA7E3	0x627C	# <CJK>
0xA7E4	0x627E	# <CJK>
0xA7E5	0x6279	# <CJK>
0xA7E6	0x6273	# <CJK>
0xA7E7	0x6292	# <CJK>
0xA7E8	0x626F	# <CJK>
0xA7E9	0x6298	# <CJK>
0xA7EA	0x626E	# <CJK>
0xA7EB	0x6295	# <CJK>
0xA7EC	0x6293	# <CJK>
0xA7ED	0x6291	# <CJK>
0xA7EE	0x6286	# <CJK>
0xA7EF	0x6539	# <CJK>
0xA7F0	0x653B	# <CJK>
0xA7F1	0x6538	# <CJK>
0xA7F2	0x65F1	# <CJK>
0xA7F3	0x66F4	# <CJK>
0xA7F4	0x675F	# <CJK>
0xA7F5	0x674E	# <CJK>
0xA7F6	0x674F	# <CJK>
0xA7F7	0x6750	# <CJK>
0xA7F8	0x6751	# <CJK>
0xA7F9	0x675C	# <CJK>
0xA7FA	0x6756	# <CJK>
0xA7FB	0x675E	# <CJK>
0xA7FC	0x6749	# <CJK>
0xA7FD	0x6746	# <CJK>
0xA7FE	0x6760	# <CJK>
0xA840	0x6753	# <CJK>
0xA841	0x6757	# <CJK>
0xA842	0x6B65	# <CJK>
0xA843	0x6BCF	# <CJK>
0xA844	0x6C42	# <CJK>
0xA845	0x6C5E	# <CJK>
0xA846	0x6C99	# <CJK>
0xA847	0x6C81	# <CJK>
0xA848	0x6C88	# <CJK>
0xA849	0x6C89	# <CJK>
0xA84A	0x6C85	# <CJK>
0xA84B	0x6C9B	# <CJK>
0xA84C	0x6C6A	# <CJK>
0xA84D	0x6C7A	# <CJK>
0xA84E	0x6C90	# <CJK>
0xA84F	0x6C70	# <CJK>
0xA850	0x6C8C	# <CJK>
0xA851	0x6C68	# <CJK>
0xA852	0x6C96	# <CJK>
0xA853	0x6C92	# <CJK>
0xA854	0x6C7D	# <CJK>
0xA855	0x6C83	# <CJK>
0xA856	0x6C72	# <CJK>
0xA857	0x6C7E	# <CJK>
0xA858	0x6C74	# <CJK>
0xA859	0x6C86	# <CJK>
0xA85A	0x6C76	# <CJK>
0xA85B	0x6C8D	# <CJK>
0xA85C	0x6C94	# <CJK>
0xA85D	0x6C98	# <CJK>
0xA85E	0x6C82	# <CJK>
0xA85F	0x7076	# <CJK>
0xA860	0x707C	# <CJK>
0xA861	0x707D	# <CJK>
0xA862	0x7078	# <CJK>
0xA863	0x7262	# <CJK>
0xA864	0x7261	# <CJK>
0xA865	0x7260	# <CJK>
0xA866	0x72C4	# <CJK>
0xA867	0x72C2	# <CJK>
0xA868	0x7396	# <CJK>
0xA869	0x752C	# <CJK>
0xA86A	0x752B	# <CJK>
0xA86B	0x7537	# <CJK>
0xA86C	0x7538	# <CJK>
0xA86D	0x7682	# <CJK>
0xA86E	0x76EF	# <CJK>
0xA86F	0x77E3	# <CJK>
0xA870	0x79C1	# <CJK>
0xA871	0x79C0	# <CJK>
0xA872	0x79BF	# <CJK>
0xA873	0x7A76	# <CJK>
0xA874	0x7CFB	# <CJK>
0xA875	0x7F55	# <CJK>
0xA876	0x8096	# <CJK>
0xA877	0x8093	# <CJK>
0xA878	0x809D	# <CJK>
0xA879	0x8098	# <CJK>
0xA87A	0x809B	# <CJK>
0xA87B	0x809A	# <CJK>
0xA87C	0x80B2	# <CJK>
0xA87D	0x826F	# <CJK>
0xA87E	0x8292	# <CJK>
0xA8A1	0x828B	# <CJK>
0xA8A2	0x828D	# <CJK>
0xA8A3	0x898B	# <CJK>
0xA8A4	0x89D2	# <CJK>
0xA8A5	0x8A00	# <CJK>
0xA8A6	0x8C37	# <CJK>
0xA8A7	0x8C46	# <CJK>
0xA8A8	0x8C55	# <CJK>
0xA8A9	0x8C9D	# <CJK>
0xA8AA	0x8D64	# <CJK>
0xA8AB	0x8D70	# <CJK>
0xA8AC	0x8DB3	# <CJK>
0xA8AD	0x8EAB	# <CJK>
0xA8AE	0x8ECA	# <CJK>
0xA8AF	0x8F9B	# <CJK>
0xA8B0	0x8FB0	# <CJK>
0xA8B1	0x8FC2	# <CJK>
0xA8B2	0x8FC6	# <CJK>
0xA8B3	0x8FC5	# <CJK>
0xA8B4	0x8FC4	# <CJK>
0xA8B5	0x5DE1	# <CJK>
0xA8B6	0x9091	# <CJK>
0xA8B7	0x90A2	# <CJK>
0xA8B8	0x90AA	# <CJK>
0xA8B9	0x90A6	# <CJK>
0xA8BA	0x90A3	# <CJK>
0xA8BB	0x9149	# <CJK>
0xA8BC	0x91C6	# <CJK>
0xA8BD	0x91CC	# <CJK>
0xA8BE	0x9632	# <CJK>
0xA8BF	0x962E	# <CJK>
0xA8C0	0x9631	# <CJK>
0xA8C1	0x962A	# <CJK>
0xA8C2	0x962C	# <CJK>
0xA8C3	0x4E26	# <CJK>
0xA8C4	0x4E56	# <CJK>
0xA8C5	0x4E73	# <CJK>
0xA8C6	0x4E8B	# <CJK>
0xA8C7	0x4E9B	# <CJK>
0xA8C8	0x4E9E	# <CJK>
0xA8C9	0x4EAB	# <CJK>
0xA8CA	0x4EAC	# <CJK>
0xA8CB	0x4F6F	# <CJK>
0xA8CC	0x4F9D	# <CJK>
0xA8CD	0x4F8D	# <CJK>
0xA8CE	0x4F73	# <CJK>
0xA8CF	0x4F7F	# <CJK>
0xA8D0	0x4F6C	# <CJK>
0xA8D1	0x4F9B	# <CJK>
0xA8D2	0x4F8B	# <CJK>
0xA8D3	0x4F86	# <CJK>
0xA8D4	0x4F83	# <CJK>
0xA8D5	0x4F70	# <CJK>
0xA8D6	0x4F75	# <CJK>
0xA8D7	0x4F88	# <CJK>
0xA8D8	0x4F69	# <CJK>
0xA8D9	0x4F7B	# <CJK>
0xA8DA	0x4F96	# <CJK>
0xA8DB	0x4F7E	# <CJK>
0xA8DC	0x4F8F	# <CJK>
0xA8DD	0x4F91	# <CJK>
0xA8DE	0x4F7A	# <CJK>
0xA8DF	0x5154	# <CJK>
0xA8E0	0x5152	# <CJK>
0xA8E1	0x5155	# <CJK>
0xA8E2	0x5169	# <CJK>
0xA8E3	0x5177	# <CJK>
0xA8E4	0x5176	# <CJK>
0xA8E5	0x5178	# <CJK>
0xA8E6	0x51BD	# <CJK>
0xA8E7	0x51FD	# <CJK>
0xA8E8	0x523B	# <CJK>
0xA8E9	0x5238	# <CJK>
0xA8EA	0x5237	# <CJK>
0xA8EB	0x523A	# <CJK>
0xA8EC	0x5230	# <CJK>
0xA8ED	0x522E	# <CJK>
0xA8EE	0x5236	# <CJK>
0xA8EF	0x5241	# <CJK>
0xA8F0	0x52BE	# <CJK>
0xA8F1	0x52BB	# <CJK>
0xA8F2	0x5352	# <CJK>
0xA8F3	0x5354	# <CJK>
0xA8F4	0x5353	# <CJK>
0xA8F5	0x5351	# <CJK>
0xA8F6	0x5366	# <CJK>
0xA8F7	0x5377	# <CJK>
0xA8F8	0x5378	# <CJK>
0xA8F9	0x5379	# <CJK>
0xA8FA	0x53D6	# <CJK>
0xA8FB	0x53D4	# <CJK>
0xA8FC	0x53D7	# <CJK>
0xA8FD	0x5473	# <CJK>
0xA8FE	0x5475	# <CJK>
0xA940	0x5496	# <CJK>
0xA941	0x5478	# <CJK>
0xA942	0x5495	# <CJK>
0xA943	0x5480	# <CJK>
0xA944	0x547B	# <CJK>
0xA945	0x5477	# <CJK>
0xA946	0x5484	# <CJK>
0xA947	0x5492	# <CJK>
0xA948	0x5486	# <CJK>
0xA949	0x547C	# <CJK>
0xA94A	0x5490	# <CJK>
0xA94B	0x5471	# <CJK>
0xA94C	0x5476	# <CJK>
0xA94D	0x548C	# <CJK>
0xA94E	0x549A	# <CJK>
0xA94F	0x5462	# <CJK>
0xA950	0x5468	# <CJK>
0xA951	0x548B	# <CJK>
0xA952	0x547D	# <CJK>
0xA953	0x548E	# <CJK>
0xA954	0x56FA	# <CJK>
0xA955	0x5783	# <CJK>
0xA956	0x5777	# <CJK>
0xA957	0x576A	# <CJK>
0xA958	0x5769	# <CJK>
0xA959	0x5761	# <CJK>
0xA95A	0x5766	# <CJK>
0xA95B	0x5764	# <CJK>
0xA95C	0x577C	# <CJK>
0xA95D	0x591C	# <CJK>
0xA95E	0x5949	# <CJK>
0xA95F	0x5947	# <CJK>
0xA960	0x5948	# <CJK>
0xA961	0x5944	# <CJK>
0xA962	0x5954	# <CJK>
0xA963	0x59BE	# <CJK>
0xA964	0x59BB	# <CJK>
0xA965	0x59D4	# <CJK>
0xA966	0x59B9	# <CJK>
0xA967	0x59AE	# <CJK>
0xA968	0x59D1	# <CJK>
0xA969	0x59C6	# <CJK>
0xA96A	0x59D0	# <CJK>
0xA96B	0x59CD	# <CJK>
0xA96C	0x59CB	# <CJK>
0xA96D	0x59D3	# <CJK>
0xA96E	0x59CA	# <CJK>
0xA96F	0x59AF	# <CJK>
0xA970	0x59B3	# <CJK>
0xA971	0x59D2	# <CJK>
0xA972	0x59C5	# <CJK>
0xA973	0x5B5F	# <CJK>
0xA974	0x5B64	# <CJK>
0xA975	0x5B63	# <CJK>
0xA976	0x5B97	# <CJK>
0xA977	0x5B9A	# <CJK>
0xA978	0x5B98	# <CJK>
0xA979	0x5B9C	# <CJK>
0xA97A	0x5B99	# <CJK>
0xA97B	0x5B9B	# <CJK>
0xA97C	0x5C1A	# <CJK>
0xA97D	0x5C48	# <CJK>
0xA97E	0x5C45	# <CJK>
0xA9A1	0x5C46	# <CJK>
0xA9A2	0x5CB7	# <CJK>
0xA9A3	0x5CA1	# <CJK>
0xA9A4	0x5CB8	# <CJK>
0xA9A5	0x5CA9	# <CJK>
0xA9A6	0x5CAB	# <CJK>
0xA9A7	0x5CB1	# <CJK>
0xA9A8	0x5CB3	# <CJK>
0xA9A9	0x5E18	# <CJK>
0xA9AA	0x5E1A	# <CJK>
0xA9AB	0x5E16	# <CJK>
0xA9AC	0x5E15	# <CJK>
0xA9AD	0x5E1B	# <CJK>
0xA9AE	0x5E11	# <CJK>
0xA9AF	0x5E78	# <CJK>
0xA9B0	0x5E9A	# <CJK>
0xA9B1	0x5E97	# <CJK>
0xA9B2	0x5E9C	# <CJK>
0xA9B3	0x5E95	# <CJK>
0xA9B4	0x5E96	# <CJK>
0xA9B5	0x5EF6	# <CJK>
0xA9B6	0x5F26	# <CJK>
0xA9B7	0x5F27	# <CJK>
0xA9B8	0x5F29	# <CJK>
0xA9B9	0x5F80	# <CJK>
0xA9BA	0x5F81	# <CJK>
0xA9BB	0x5F7F	# <CJK>
0xA9BC	0x5F7C	# <CJK>
0xA9BD	0x5FDD	# <CJK>
0xA9BE	0x5FE0	# <CJK>
0xA9BF	0x5FFD	# <CJK>
0xA9C0	0x5FF5	# <CJK>
0xA9C1	0x5FFF	# <CJK>
0xA9C2	0x600F	# <CJK>
0xA9C3	0x6014	# <CJK>
0xA9C4	0x602F	# <CJK>
0xA9C5	0x6035	# <CJK>
0xA9C6	0x6016	# <CJK>
0xA9C7	0x602A	# <CJK>
0xA9C8	0x6015	# <CJK>
0xA9C9	0x6021	# <CJK>
0xA9CA	0x6027	# <CJK>
0xA9CB	0x6029	# <CJK>
0xA9CC	0x602B	# <CJK>
0xA9CD	0x601B	# <CJK>
0xA9CE	0x6216	# <CJK>
0xA9CF	0x6215	# <CJK>
0xA9D0	0x623F	# <CJK>
0xA9D1	0x623E	# <CJK>
0xA9D2	0x6240	# <CJK>
0xA9D3	0x627F	# <CJK>
0xA9D4	0x62C9	# <CJK>
0xA9D5	0x62CC	# <CJK>
0xA9D6	0x62C4	# <CJK>
0xA9D7	0x62BF	# <CJK>
0xA9D8	0x62C2	# <CJK>
0xA9D9	0x62B9	# <CJK>
0xA9DA	0x62D2	# <CJK>
0xA9DB	0x62DB	# <CJK>
0xA9DC	0x62AB	# <CJK>
0xA9DD	0x62D3	# <CJK>
0xA9DE	0x62D4	# <CJK>
0xA9DF	0x62CB	# <CJK>
0xA9E0	0x62C8	# <CJK>
0xA9E1	0x62A8	# <CJK>
0xA9E2	0x62BD	# <CJK>
0xA9E3	0x62BC	# <CJK>
0xA9E4	0x62D0	# <CJK>
0xA9E5	0x62D9	# <CJK>
0xA9E6	0x62C7	# <CJK>
0xA9E7	0x62CD	# <CJK>
0xA9E8	0x62B5	# <CJK>
0xA9E9	0x62DA	# <CJK>
0xA9EA	0x62B1	# <CJK>
0xA9EB	0x62D8	# <CJK>
0xA9EC	0x62D6	# <CJK>
0xA9ED	0x62D7	# <CJK>
0xA9EE	0x62C6	# <CJK>
0xA9EF	0x62AC	# <CJK>
0xA9F0	0x62CE	# <CJK>
0xA9F1	0x653E	# <CJK>
0xA9F2	0x65A7	# <CJK>
0xA9F3	0x65BC	# <CJK>
0xA9F4	0x65FA	# <CJK>
0xA9F5	0x6614	# <CJK>
0xA9F6	0x6613	# <CJK>
0xA9F7	0x660C	# <CJK>
0xA9F8	0x6606	# <CJK>
0xA9F9	0x6602	# <CJK>
0xA9FA	0x660E	# <CJK>
0xA9FB	0x6600	# <CJK>
0xA9FC	0x660F	# <CJK>
0xA9FD	0x6615	# <CJK>
0xA9FE	0x660A	# <CJK>
0xAA40	0x6607	# <CJK>
0xAA41	0x670D	# <CJK>
0xAA42	0x670B	# <CJK>
0xAA43	0x676D	# <CJK>
0xAA44	0x678B	# <CJK>
0xAA45	0x6795	# <CJK>
0xAA46	0x6771	# <CJK>
0xAA47	0x679C	# <CJK>
0xAA48	0x6773	# <CJK>
0xAA49	0x6777	# <CJK>
0xAA4A	0x6787	# <CJK>
0xAA4B	0x679D	# <CJK>
0xAA4C	0x6797	# <CJK>
0xAA4D	0x676F	# <CJK>
0xAA4E	0x6770	# <CJK>
0xAA4F	0x677F	# <CJK>
0xAA50	0x6789	# <CJK>
0xAA51	0x677E	# <CJK>
0xAA52	0x6790	# <CJK>
0xAA53	0x6775	# <CJK>
0xAA54	0x679A	# <CJK>
0xAA55	0x6793	# <CJK>
0xAA56	0x677C	# <CJK>
0xAA57	0x676A	# <CJK>
0xAA58	0x6772	# <CJK>
0xAA59	0x6B23	# <CJK>
0xAA5A	0x6B66	# <CJK>
0xAA5B	0x6B67	# <CJK>
0xAA5C	0x6B7F	# <CJK>
0xAA5D	0x6C13	# <CJK>
0xAA5E	0x6C1B	# <CJK>
0xAA5F	0x6CE3	# <CJK>
0xAA60	0x6CE8	# <CJK>
0xAA61	0x6CF3	# <CJK>
0xAA62	0x6CB1	# <CJK>
0xAA63	0x6CCC	# <CJK>
0xAA64	0x6CE5	# <CJK>
0xAA65	0x6CB3	# <CJK>
0xAA66	0x6CBD	# <CJK>
0xAA67	0x6CBE	# <CJK>
0xAA68	0x6CBC	# <CJK>
0xAA69	0x6CE2	# <CJK>
0xAA6A	0x6CAB	# <CJK>
0xAA6B	0x6CD5	# <CJK>
0xAA6C	0x6CD3	# <CJK>
0xAA6D	0x6CB8	# <CJK>
0xAA6E	0x6CC4	# <CJK>
0xAA6F	0x6CB9	# <CJK>
0xAA70	0x6CC1	# <CJK>
0xAA71	0x6CAE	# <CJK>
0xAA72	0x6CD7	# <CJK>
0xAA73	0x6CC5	# <CJK>
0xAA74	0x6CF1	# <CJK>
0xAA75	0x6CBF	# <CJK>
0xAA76	0x6CBB	# <CJK>
0xAA77	0x6CE1	# <CJK>
0xAA78	0x6CDB	# <CJK>
0xAA79	0x6CCA	# <CJK>
0xAA7A	0x6CAC	# <CJK>
0xAA7B	0x6CEF	# <CJK>
0xAA7C	0x6CDC	# <CJK>
0xAA7D	0x6CD6	# <CJK>
0xAA7E	0x6CE0	# <CJK>
0xAAA1	0x7095	# <CJK>
0xAAA2	0x708E	# <CJK>
0xAAA3	0x7092	# <CJK>
0xAAA4	0x708A	# <CJK>
0xAAA5	0x7099	# <CJK>
0xAAA6	0x722C	# <CJK>
0xAAA7	0x722D	# <CJK>
0xAAA8	0x7238	# <CJK>
0xAAA9	0x7248	# <CJK>
0xAAAA	0x7267	# <CJK>
0xAAAB	0x7269	# <CJK>
0xAAAC	0x72C0	# <CJK>
0xAAAD	0x72CE	# <CJK>
0xAAAE	0x72D9	# <CJK>
0xAAAF	0x72D7	# <CJK>
0xAAB0	0x72D0	# <CJK>
0xAAB1	0x73A9	# <CJK>
0xAAB2	0x73A8	# <CJK>
0xAAB3	0x739F	# <CJK>
0xAAB4	0x73AB	# <CJK>
0xAAB5	0x73A5	# <CJK>
0xAAB6	0x753D	# <CJK>
0xAAB7	0x759D	# <CJK>
0xAAB8	0x7599	# <CJK>
0xAAB9	0x759A	# <CJK>
0xAABA	0x7684	# <CJK>
0xAABB	0x76C2	# <CJK>
0xAABC	0x76F2	# <CJK>
0xAABD	0x76F4	# <CJK>
0xAABE	0x77E5	# <CJK>
0xAABF	0x77FD	# <CJK>
0xAAC0	0x793E	# <CJK>
0xAAC1	0x7940	# <CJK>
0xAAC2	0x7941	# <CJK>
0xAAC3	0x79C9	# <CJK>
0xAAC4	0x79C8	# <CJK>
0xAAC5	0x7A7A	# <CJK>
0xAAC6	0x7A79	# <CJK>
0xAAC7	0x7AFA	# <CJK>
0xAAC8	0x7CFE	# <CJK>
0xAAC9	0x7F54	# <CJK>
0xAACA	0x7F8C	# <CJK>
0xAACB	0x7F8B	# <CJK>
0xAACC	0x8005	# <CJK>
0xAACD	0x80BA	# <CJK>
0xAACE	0x80A5	# <CJK>
0xAACF	0x80A2	# <CJK>
0xAAD0	0x80B1	# <CJK>
0xAAD1	0x80A1	# <CJK>
0xAAD2	0x80AB	# <CJK>
0xAAD3	0x80A9	# <CJK>
0xAAD4	0x80B4	# <CJK>
0xAAD5	0x80AA	# <CJK>
0xAAD6	0x80AF	# <CJK>
0xAAD7	0x81E5	# <CJK>
0xAAD8	0x81FE	# <CJK>
0xAAD9	0x820D	# <CJK>
0xAADA	0x82B3	# <CJK>
0xAADB	0x829D	# <CJK>
0xAADC	0x8299	# <CJK>
0xAADD	0x82AD	# <CJK>
0xAADE	0x82BD	# <CJK>
0xAADF	0x829F	# <CJK>
0xAAE0	0x82B9	# <CJK>
0xAAE1	0x82B1	# <CJK>
0xAAE2	0x82AC	# <CJK>
0xAAE3	0x82A5	# <CJK>
0xAAE4	0x82AF	# <CJK>
0xAAE5	0x82B8	# <CJK>
0xAAE6	0x82A3	# <CJK>
0xAAE7	0x82B0	# <CJK>
0xAAE8	0x82BE	# <CJK>
0xAAE9	0x82B7	# <CJK>
0xAAEA	0x864E	# <CJK>
0xAAEB	0x8671	# <CJK>
0xAAEC	0x521D	# <CJK>
0xAAED	0x8868	# <CJK>
0xAAEE	0x8ECB	# <CJK>
0xAAEF	0x8FCE	# <CJK>
0xAAF0	0x8FD4	# <CJK>
0xAAF1	0x8FD1	# <CJK>
0xAAF2	0x90B5	# <CJK>
0xAAF3	0x90B8	# <CJK>
0xAAF4	0x90B1	# <CJK>
0xAAF5	0x90B6	# <CJK>
0xAAF6	0x91C7	# <CJK>
0xAAF7	0x91D1	# <CJK>
0xAAF8	0x9577	# <CJK>
0xAAF9	0x9580	# <CJK>
0xAAFA	0x961C	# <CJK>
0xAAFB	0x9640	# <CJK>
0xAAFC	0x963F	# <CJK>
0xAAFD	0x963B	# <CJK>
0xAAFE	0x9644	# <CJK>
0xAB40	0x9642	# <CJK>
0xAB41	0x96B9	# <CJK>
0xAB42	0x96E8	# <CJK>
0xAB43	0x9752	# <CJK>
0xAB44	0x975E	# <CJK>
0xAB45	0x4E9F	# <CJK>
0xAB46	0x4EAD	# <CJK>
0xAB47	0x4EAE	# <CJK>
0xAB48	0x4FE1	# <CJK>
0xAB49	0x4FB5	# <CJK>
0xAB4A	0x4FAF	# <CJK>
0xAB4B	0x4FBF	# <CJK>
0xAB4C	0x4FE0	# <CJK>
0xAB4D	0x4FD1	# <CJK>
0xAB4E	0x4FCF	# <CJK>
0xAB4F	0x4FDD	# <CJK>
0xAB50	0x4FC3	# <CJK>
0xAB51	0x4FB6	# <CJK>
0xAB52	0x4FD8	# <CJK>
0xAB53	0x4FDF	# <CJK>
0xAB54	0x4FCA	# <CJK>
0xAB55	0x4FD7	# <CJK>
0xAB56	0x4FAE	# <CJK>
0xAB57	0x4FD0	# <CJK>
0xAB58	0x4FC4	# <CJK>
0xAB59	0x4FC2	# <CJK>
0xAB5A	0x4FDA	# <CJK>
0xAB5B	0x4FCE	# <CJK>
0xAB5C	0x4FDE	# <CJK>
0xAB5D	0x4FB7	# <CJK>
0xAB5E	0x5157	# <CJK>
0xAB5F	0x5192	# <CJK>
0xAB60	0x5191	# <CJK>
0xAB61	0x51A0	# <CJK>
0xAB62	0x524E	# <CJK>
0xAB63	0x5243	# <CJK>
0xAB64	0x524A	# <CJK>
0xAB65	0x524D	# <CJK>
0xAB66	0x524C	# <CJK>
0xAB67	0x524B	# <CJK>
0xAB68	0x5247	# <CJK>
0xAB69	0x52C7	# <CJK>
0xAB6A	0x52C9	# <CJK>
0xAB6B	0x52C3	# <CJK>
0xAB6C	0x52C1	# <CJK>
0xAB6D	0x530D	# <CJK>
0xAB6E	0x5357	# <CJK>
0xAB6F	0x537B	# <CJK>
0xAB70	0x539A	# <CJK>
0xAB71	0x53DB	# <CJK>
0xAB72	0x54AC	# <CJK>
0xAB73	0x54C0	# <CJK>
0xAB74	0x54A8	# <CJK>
0xAB75	0x54CE	# <CJK>
0xAB76	0x54C9	# <CJK>
0xAB77	0x54B8	# <CJK>
0xAB78	0x54A6	# <CJK>
0xAB79	0x54B3	# <CJK>
0xAB7A	0x54C7	# <CJK>
0xAB7B	0x54C2	# <CJK>
0xAB7C	0x54BD	# <CJK>
0xAB7D	0x54AA	# <CJK>
0xAB7E	0x54C1	# <CJK>
0xABA1	0x54C4	# <CJK>
0xABA2	0x54C8	# <CJK>
0xABA3	0x54AF	# <CJK>
0xABA4	0x54AB	# <CJK>
0xABA5	0x54B1	# <CJK>
0xABA6	0x54BB	# <CJK>
0xABA7	0x54A9	# <CJK>
0xABA8	0x54A7	# <CJK>
0xABA9	0x54BF	# <CJK>
0xABAA	0x56FF	# <CJK>
0xABAB	0x5782	# <CJK>
0xABAC	0x578B	# <CJK>
0xABAD	0x57A0	# <CJK>
0xABAE	0x57A3	# <CJK>
0xABAF	0x57A2	# <CJK>
0xABB0	0x57CE	# <CJK>
0xABB1	0x57AE	# <CJK>
0xABB2	0x5793	# <CJK>
0xABB3	0x5955	# <CJK>
0xABB4	0x5951	# <CJK>
0xABB5	0x594F	# <CJK>
0xABB6	0x594E	# <CJK>
0xABB7	0x5950	# <CJK>
0xABB8	0x59DC	# <CJK>
0xABB9	0x59D8	# <CJK>
0xABBA	0x59FF	# <CJK>
0xABBB	0x59E3	# <CJK>
0xABBC	0x59E8	# <CJK>
0xABBD	0x5A03	# <CJK>
0xABBE	0x59E5	# <CJK>
0xABBF	0x59EA	# <CJK>
0xABC0	0x59DA	# <CJK>
0xABC1	0x59E6	# <CJK>
0xABC2	0x5A01	# <CJK>
0xABC3	0x59FB	# <CJK>
0xABC4	0x5B69	# <CJK>
0xABC5	0x5BA3	# <CJK>
0xABC6	0x5BA6	# <CJK>
0xABC7	0x5BA4	# <CJK>
0xABC8	0x5BA2	# <CJK>
0xABC9	0x5BA5	# <CJK>
0xABCA	0x5C01	# <CJK>
0xABCB	0x5C4E	# <CJK>
0xABCC	0x5C4F	# <CJK>
0xABCD	0x5C4D	# <CJK>
0xABCE	0x5C4B	# <CJK>
0xABCF	0x5CD9	# <CJK>
0xABD0	0x5CD2	# <CJK>
0xABD1	0x5DF7	# <CJK>
0xABD2	0x5E1D	# <CJK>
0xABD3	0x5E25	# <CJK>
0xABD4	0x5E1F	# <CJK>
0xABD5	0x5E7D	# <CJK>
0xABD6	0x5EA0	# <CJK>
0xABD7	0x5EA6	# <CJK>
0xABD8	0x5EFA	# <CJK>
0xABD9	0x5F08	# <CJK>
0xABDA	0x5F2D	# <CJK>
0xABDB	0x5F65	# <CJK>
0xABDC	0x5F88	# <CJK>
0xABDD	0x5F85	# <CJK>
0xABDE	0x5F8A	# <CJK>
0xABDF	0x5F8B	# <CJK>
0xABE0	0x5F87	# <CJK>
0xABE1	0x5F8C	# <CJK>
0xABE2	0x5F89	# <CJK>
0xABE3	0x6012	# <CJK>
0xABE4	0x601D	# <CJK>
0xABE5	0x6020	# <CJK>
0xABE6	0x6025	# <CJK>
0xABE7	0x600E	# <CJK>
0xABE8	0x6028	# <CJK>
0xABE9	0x604D	# <CJK>
0xABEA	0x6070	# <CJK>
0xABEB	0x6068	# <CJK>
0xABEC	0x6062	# <CJK>
0xABED	0x6046	# <CJK>
0xABEE	0x6043	# <CJK>
0xABEF	0x606C	# <CJK>
0xABF0	0x606B	# <CJK>
0xABF1	0x606A	# <CJK>
0xABF2	0x6064	# <CJK>
0xABF3	0x6241	# <CJK>
0xABF4	0x62DC	# <CJK>
0xABF5	0x6316	# <CJK>
0xABF6	0x6309	# <CJK>
0xABF7	0x62FC	# <CJK>
0xABF8	0x62ED	# <CJK>
0xABF9	0x6301	# <CJK>
0xABFA	0x62EE	# <CJK>
0xABFB	0x62FD	# <CJK>
0xABFC	0x6307	# <CJK>
0xABFD	0x62F1	# <CJK>
0xABFE	0x62F7	# <CJK>
0xAC40	0x62EF	# <CJK>
0xAC41	0x62EC	# <CJK>
0xAC42	0x62FE	# <CJK>
0xAC43	0x62F4	# <CJK>
0xAC44	0x6311	# <CJK>
0xAC45	0x6302	# <CJK>
0xAC46	0x653F	# <CJK>
0xAC47	0x6545	# <CJK>
0xAC48	0x65AB	# <CJK>
0xAC49	0x65BD	# <CJK>
0xAC4A	0x65E2	# <CJK>
0xAC4B	0x6625	# <CJK>
0xAC4C	0x662D	# <CJK>
0xAC4D	0x6620	# <CJK>
0xAC4E	0x6627	# <CJK>
0xAC4F	0x662F	# <CJK>
0xAC50	0x661F	# <CJK>
0xAC51	0x6628	# <CJK>
0xAC52	0x6631	# <CJK>
0xAC53	0x6624	# <CJK>
0xAC54	0x66F7	# <CJK>
0xAC55	0x67FF	# <CJK>
0xAC56	0x67D3	# <CJK>
0xAC57	0x67F1	# <CJK>
0xAC58	0x67D4	# <CJK>
0xAC59	0x67D0	# <CJK>
0xAC5A	0x67EC	# <CJK>
0xAC5B	0x67B6	# <CJK>
0xAC5C	0x67AF	# <CJK>
0xAC5D	0x67F5	# <CJK>
0xAC5E	0x67E9	# <CJK>
0xAC5F	0x67EF	# <CJK>
0xAC60	0x67C4	# <CJK>
0xAC61	0x67D1	# <CJK>
0xAC62	0x67B4	# <CJK>
0xAC63	0x67DA	# <CJK>
0xAC64	0x67E5	# <CJK>
0xAC65	0x67B8	# <CJK>
0xAC66	0x67CF	# <CJK>
0xAC67	0x67DE	# <CJK>
0xAC68	0x67F3	# <CJK>
0xAC69	0x67B0	# <CJK>
0xAC6A	0x67D9	# <CJK>
0xAC6B	0x67E2	# <CJK>
0xAC6C	0x67DD	# <CJK>
0xAC6D	0x67D2	# <CJK>
0xAC6E	0x6B6A	# <CJK>
0xAC6F	0x6B83	# <CJK>
0xAC70	0x6B86	# <CJK>
0xAC71	0x6BB5	# <CJK>
0xAC72	0x6BD2	# <CJK>
0xAC73	0x6BD7	# <CJK>
0xAC74	0x6C1F	# <CJK>
0xAC75	0x6CC9	# <CJK>
0xAC76	0x6D0B	# <CJK>
0xAC77	0x6D32	# <CJK>
0xAC78	0x6D2A	# <CJK>
0xAC79	0x6D41	# <CJK>
0xAC7A	0x6D25	# <CJK>
0xAC7B	0x6D0C	# <CJK>
0xAC7C	0x6D31	# <CJK>
0xAC7D	0x6D1E	# <CJK>
0xAC7E	0x6D17	# <CJK>
0xACA1	0x6D3B	# <CJK>
0xACA2	0x6D3D	# <CJK>
0xACA3	0x6D3E	# <CJK>
0xACA4	0x6D36	# <CJK>
0xACA5	0x6D1B	# <CJK>
0xACA6	0x6CF5	# <CJK>
0xACA7	0x6D39	# <CJK>
0xACA8	0x6D27	# <CJK>
0xACA9	0x6D38	# <CJK>
0xACAA	0x6D29	# <CJK>
0xACAB	0x6D2E	# <CJK>
0xACAC	0x6D35	# <CJK>
0xACAD	0x6D0E	# <CJK>
0xACAE	0x6D2B	# <CJK>
0xACAF	0x70AB	# <CJK>
0xACB0	0x70BA	# <CJK>
0xACB1	0x70B3	# <CJK>
0xACB2	0x70AC	# <CJK>
0xACB3	0x70AF	# <CJK>
0xACB4	0x70AD	# <CJK>
0xACB5	0x70B8	# <CJK>
0xACB6	0x70AE	# <CJK>
0xACB7	0x70A4	# <CJK>
0xACB8	0x7230	# <CJK>
0xACB9	0x7272	# <CJK>
0xACBA	0x726F	# <CJK>
0xACBB	0x7274	# <CJK>
0xACBC	0x72E9	# <CJK>
0xACBD	0x72E0	# <CJK>
0xACBE	0x72E1	# <CJK>
0xACBF	0x73B7	# <CJK>
0xACC0	0x73CA	# <CJK>
0xACC1	0x73BB	# <CJK>
0xACC2	0x73B2	# <CJK>
0xACC3	0x73CD	# <CJK>
0xACC4	0x73C0	# <CJK>
0xACC5	0x73B3	# <CJK>
0xACC6	0x751A	# <CJK>
0xACC7	0x752D	# <CJK>
0xACC8	0x754F	# <CJK>
0xACC9	0x754C	# <CJK>
0xACCA	0x754E	# <CJK>
0xACCB	0x754B	# <CJK>
0xACCC	0x75AB	# <CJK>
0xACCD	0x75A4	# <CJK>
0xACCE	0x75A5	# <CJK>
0xACCF	0x75A2	# <CJK>
0xACD0	0x75A3	# <CJK>
0xACD1	0x7678	# <CJK>
0xACD2	0x7686	# <CJK>
0xACD3	0x7687	# <CJK>
0xACD4	0x7688	# <CJK>
0xACD5	0x76C8	# <CJK>
0xACD6	0x76C6	# <CJK>
0xACD7	0x76C3	# <CJK>
0xACD8	0x76C5	# <CJK>
0xACD9	0x7701	# <CJK>
0xACDA	0x76F9	# <CJK>
0xACDB	0x76F8	# <CJK>
0xACDC	0x7709	# <CJK>
0xACDD	0x770B	# <CJK>
0xACDE	0x76FE	# <CJK>
0xACDF	0x76FC	# <CJK>
0xACE0	0x7707	# <CJK>
0xACE1	0x77DC	# <CJK>
0xACE2	0x7802	# <CJK>
0xACE3	0x7814	# <CJK>
0xACE4	0x780C	# <CJK>
0xACE5	0x780D	# <CJK>
0xACE6	0x7946	# <CJK>
0xACE7	0x7949	# <CJK>
0xACE8	0x7948	# <CJK>
0xACE9	0x7947	# <CJK>
0xACEA	0x79B9	# <CJK>
0xACEB	0x79BA	# <CJK>
0xACEC	0x79D1	# <CJK>
0xACED	0x79D2	# <CJK>
0xACEE	0x79CB	# <CJK>
0xACEF	0x7A7F	# <CJK>
0xACF0	0x7A81	# <CJK>
0xACF1	0x7AFF	# <CJK>
0xACF2	0x7AFD	# <CJK>
0xACF3	0x7C7D	# <CJK>
0xACF4	0x7D02	# <CJK>
0xACF5	0x7D05	# <CJK>
0xACF6	0x7D00	# <CJK>
0xACF7	0x7D09	# <CJK>
0xACF8	0x7D07	# <CJK>
0xACF9	0x7D04	# <CJK>
0xACFA	0x7D06	# <CJK>
0xACFB	0x7F38	# <CJK>
0xACFC	0x7F8E	# <CJK>
0xACFD	0x7FBF	# <CJK>
0xACFE	0x8004	# <CJK>
0xAD40	0x8010	# <CJK>
0xAD41	0x800D	# <CJK>
0xAD42	0x8011	# <CJK>
0xAD43	0x8036	# <CJK>
0xAD44	0x80D6	# <CJK>
0xAD45	0x80E5	# <CJK>
0xAD46	0x80DA	# <CJK>
0xAD47	0x80C3	# <CJK>
0xAD48	0x80C4	# <CJK>
0xAD49	0x80CC	# <CJK>
0xAD4A	0x80E1	# <CJK>
0xAD4B	0x80DB	# <CJK>
0xAD4C	0x80CE	# <CJK>
0xAD4D	0x80DE	# <CJK>
0xAD4E	0x80E4	# <CJK>
0xAD4F	0x80DD	# <CJK>
0xAD50	0x81F4	# <CJK>
0xAD51	0x8222	# <CJK>
0xAD52	0x82E7	# <CJK>
0xAD53	0x8303	# <CJK>
0xAD54	0x8305	# <CJK>
0xAD55	0x82E3	# <CJK>
0xAD56	0x82DB	# <CJK>
0xAD57	0x82E6	# <CJK>
0xAD58	0x8304	# <CJK>
0xAD59	0x82E5	# <CJK>
0xAD5A	0x8302	# <CJK>
0xAD5B	0x8309	# <CJK>
0xAD5C	0x82D2	# <CJK>
0xAD5D	0x82D7	# <CJK>
0xAD5E	0x82F1	# <CJK>
0xAD5F	0x8301	# <CJK>
0xAD60	0x82DC	# <CJK>
0xAD61	0x82D4	# <CJK>
0xAD62	0x82D1	# <CJK>
0xAD63	0x82DE	# <CJK>
0xAD64	0x82D3	# <CJK>
0xAD65	0x82DF	# <CJK>
0xAD66	0x82EF	# <CJK>
0xAD67	0x8306	# <CJK>
0xAD68	0x8650	# <CJK>
0xAD69	0x8679	# <CJK>
0xAD6A	0x867B	# <CJK>
0xAD6B	0x867A	# <CJK>
0xAD6C	0x884D	# <CJK>
0xAD6D	0x886B	# <CJK>
0xAD6E	0x8981	# <CJK>
0xAD6F	0x89D4	# <CJK>
0xAD70	0x8A08	# <CJK>
0xAD71	0x8A02	# <CJK>
0xAD72	0x8A03	# <CJK>
0xAD73	0x8C9E	# <CJK>
0xAD74	0x8CA0	# <CJK>
0xAD75	0x8D74	# <CJK>
0xAD76	0x8D73	# <CJK>
0xAD77	0x8DB4	# <CJK>
0xAD78	0x8ECD	# <CJK>
0xAD79	0x8ECC	# <CJK>
0xAD7A	0x8FF0	# <CJK>
0xAD7B	0x8FE6	# <CJK>
0xAD7C	0x8FE2	# <CJK>
0xAD7D	0x8FEA	# <CJK>
0xAD7E	0x8FE5	# <CJK>
0xADA1	0x8FED	# <CJK>
0xADA2	0x8FEB	# <CJK>
0xADA3	0x8FE4	# <CJK>
0xADA4	0x8FE8	# <CJK>
0xADA5	0x90CA	# <CJK>
0xADA6	0x90CE	# <CJK>
0xADA7	0x90C1	# <CJK>
0xADA8	0x90C3	# <CJK>
0xADA9	0x914B	# <CJK>
0xADAA	0x914A	# <CJK>
0xADAB	0x91CD	# <CJK>
0xADAC	0x9582	# <CJK>
0xADAD	0x9650	# <CJK>
0xADAE	0x964B	# <CJK>
0xADAF	0x964C	# <CJK>
0xADB0	0x964D	# <CJK>
0xADB1	0x9762	# <CJK>
0xADB2	0x9769	# <CJK>
0xADB3	0x97CB	# <CJK>
0xADB4	0x97ED	# <CJK>
0xADB5	0x97F3	# <CJK>
0xADB6	0x9801	# <CJK>
0xADB7	0x98A8	# <CJK>
0xADB8	0x98DB	# <CJK>
0xADB9	0x98DF	# <CJK>
0xADBA	0x9996	# <CJK>
0xADBB	0x9999	# <CJK>
0xADBC	0x4E58	# <CJK>
0xADBD	0x4EB3	# <CJK>
0xADBE	0x500C	# <CJK>
0xADBF	0x500D	# <CJK>
0xADC0	0x5023	# <CJK>
0xADC1	0x4FEF	# <CJK>
0xADC2	0x5026	# <CJK>
0xADC3	0x5025	# <CJK>
0xADC4	0x4FF8	# <CJK>
0xADC5	0x5029	# <CJK>
0xADC6	0x5016	# <CJK>
0xADC7	0x5006	# <CJK>
0xADC8	0x503C	# <CJK>
0xADC9	0x501F	# <CJK>
0xADCA	0x501A	# <CJK>
0xADCB	0x5012	# <CJK>
0xADCC	0x5011	# <CJK>
0xADCD	0x4FFA	# <CJK>
0xADCE	0x5000	# <CJK>
0xADCF	0x5014	# <CJK>
0xADD0	0x5028	# <CJK>
0xADD1	0x4FF1	# <CJK>
0xADD2	0x5021	# <CJK>
0xADD3	0x500B	# <CJK>
0xADD4	0x5019	# <CJK>
0xADD5	0x5018	# <CJK>
0xADD6	0x4FF3	# <CJK>
0xADD7	0x4FEE	# <CJK>
0xADD8	0x502D	# <CJK>
0xADD9	0x502A	# <CJK>
0xADDA	0x4FFE	# <CJK>
0xADDB	0x502B	# <CJK>
0xADDC	0x5009	# <CJK>
0xADDD	0x517C	# <CJK>
0xADDE	0x51A4	# <CJK>
0xADDF	0x51A5	# <CJK>
0xADE0	0x51A2	# <CJK>
0xADE1	0x51CD	# <CJK>
0xADE2	0x51CC	# <CJK>
0xADE3	0x51C6	# <CJK>
0xADE4	0x51CB	# <CJK>
0xADE5	0x5256	# <CJK>
0xADE6	0x525C	# <CJK>
0xADE7	0x5254	# <CJK>
0xADE8	0x525B	# <CJK>
0xADE9	0x525D	# <CJK>
0xADEA	0x532A	# <CJK>
0xADEB	0x537F	# <CJK>
0xADEC	0x539F	# <CJK>
0xADED	0x539D	# <CJK>
0xADEE	0x53DF	# <CJK>
0xADEF	0x54E8	# <CJK>
0xADF0	0x5510	# <CJK>
0xADF1	0x5501	# <CJK>
0xADF2	0x5537	# <CJK>
0xADF3	0x54FC	# <CJK>
0xADF4	0x54E5	# <CJK>
0xADF5	0x54F2	# <CJK>
0xADF6	0x5506	# <CJK>
0xADF7	0x54FA	# <CJK>
0xADF8	0x5514	# <CJK>
0xADF9	0x54E9	# <CJK>
0xADFA	0x54ED	# <CJK>
0xADFB	0x54E1	# <CJK>
0xADFC	0x5509	# <CJK>
0xADFD	0x54EE	# <CJK>
0xADFE	0x54EA	# <CJK>
0xAE40	0x54E6	# <CJK>
0xAE41	0x5527	# <CJK>
0xAE42	0x5507	# <CJK>
0xAE43	0x54FD	# <CJK>
0xAE44	0x550F	# <CJK>
0xAE45	0x5703	# <CJK>
0xAE46	0x5704	# <CJK>
0xAE47	0x57C2	# <CJK>
0xAE48	0x57D4	# <CJK>
0xAE49	0x57CB	# <CJK>
0xAE4A	0x57C3	# <CJK>
0xAE4B	0x5809	# <CJK>
0xAE4C	0x590F	# <CJK>
0xAE4D	0x5957	# <CJK>
0xAE4E	0x5958	# <CJK>
0xAE4F	0x595A	# <CJK>
0xAE50	0x5A11	# <CJK>
0xAE51	0x5A18	# <CJK>
0xAE52	0x5A1C	# <CJK>
0xAE53	0x5A1F	# <CJK>
0xAE54	0x5A1B	# <CJK>
0xAE55	0x5A13	# <CJK>
0xAE56	0x59EC	# <CJK>
0xAE57	0x5A20	# <CJK>
0xAE58	0x5A23	# <CJK>
0xAE59	0x5A29	# <CJK>
0xAE5A	0x5A25	# <CJK>
0xAE5B	0x5A0C	# <CJK>
0xAE5C	0x5A09	# <CJK>
0xAE5D	0x5B6B	# <CJK>
0xAE5E	0x5C58	# <CJK>
0xAE5F	0x5BB0	# <CJK>
0xAE60	0x5BB3	# <CJK>
0xAE61	0x5BB6	# <CJK>
0xAE62	0x5BB4	# <CJK>
0xAE63	0x5BAE	# <CJK>
0xAE64	0x5BB5	# <CJK>
0xAE65	0x5BB9	# <CJK>
0xAE66	0x5BB8	# <CJK>
0xAE67	0x5C04	# <CJK>
0xAE68	0x5C51	# <CJK>
0xAE69	0x5C55	# <CJK>
0xAE6A	0x5C50	# <CJK>
0xAE6B	0x5CED	# <CJK>
0xAE6C	0x5CFD	# <CJK>
0xAE6D	0x5CFB	# <CJK>
0xAE6E	0x5CEA	# <CJK>
0xAE6F	0x5CE8	# <CJK>
0xAE70	0x5CF0	# <CJK>
0xAE71	0x5CF6	# <CJK>
0xAE72	0x5D01	# <CJK>
0xAE73	0x5CF4	# <CJK>
0xAE74	0x5DEE	# <CJK>
0xAE75	0x5E2D	# <CJK>
0xAE76	0x5E2B	# <CJK>
0xAE77	0x5EAB	# <CJK>
0xAE78	0x5EAD	# <CJK>
0xAE79	0x5EA7	# <CJK>
0xAE7A	0x5F31	# <CJK>
0xAE7B	0x5F92	# <CJK>
0xAE7C	0x5F91	# <CJK>
0xAE7D	0x5F90	# <CJK>
0xAE7E	0x6059	# <CJK>
0xAEA1	0x6063	# <CJK>
0xAEA2	0x6065	# <CJK>
0xAEA3	0x6050	# <CJK>
0xAEA4	0x6055	# <CJK>
0xAEA5	0x606D	# <CJK>
0xAEA6	0x6069	# <CJK>
0xAEA7	0x606F	# <CJK>
0xAEA8	0x6084	# <CJK>
0xAEA9	0x609F	# <CJK>
0xAEAA	0x609A	# <CJK>
0xAEAB	0x608D	# <CJK>
0xAEAC	0x6094	# <CJK>
0xAEAD	0x608C	# <CJK>
0xAEAE	0x6085	# <CJK>
0xAEAF	0x6096	# <CJK>
0xAEB0	0x6247	# <CJK>
0xAEB1	0x62F3	# <CJK>
0xAEB2	0x6308	# <CJK>
0xAEB3	0x62FF	# <CJK>
0xAEB4	0x634E	# <CJK>
0xAEB5	0x633E	# <CJK>
0xAEB6	0x632F	# <CJK>
0xAEB7	0x6355	# <CJK>
0xAEB8	0x6342	# <CJK>
0xAEB9	0x6346	# <CJK>
0xAEBA	0x634F	# <CJK>
0xAEBB	0x6349	# <CJK>
0xAEBC	0x633A	# <CJK>
0xAEBD	0x6350	# <CJK>
0xAEBE	0x633D	# <CJK>
0xAEBF	0x632A	# <CJK>
0xAEC0	0x632B	# <CJK>
0xAEC1	0x6328	# <CJK>
0xAEC2	0x634D	# <CJK>
0xAEC3	0x634C	# <CJK>
0xAEC4	0x6548	# <CJK>
0xAEC5	0x6549	# <CJK>
0xAEC6	0x6599	# <CJK>
0xAEC7	0x65C1	# <CJK>
0xAEC8	0x65C5	# <CJK>
0xAEC9	0x6642	# <CJK>
0xAECA	0x6649	# <CJK>
0xAECB	0x664F	# <CJK>
0xAECC	0x6643	# <CJK>
0xAECD	0x6652	# <CJK>
0xAECE	0x664C	# <CJK>
0xAECF	0x6645	# <CJK>
0xAED0	0x6641	# <CJK>
0xAED1	0x66F8	# <CJK>
0xAED2	0x6714	# <CJK>
0xAED3	0x6715	# <CJK>
0xAED4	0x6717	# <CJK>
0xAED5	0x6821	# <CJK>
0xAED6	0x6838	# <CJK>
0xAED7	0x6848	# <CJK>
0xAED8	0x6846	# <CJK>
0xAED9	0x6853	# <CJK>
0xAEDA	0x6839	# <CJK>
0xAEDB	0x6842	# <CJK>
0xAEDC	0x6854	# <CJK>
0xAEDD	0x6829	# <CJK>
0xAEDE	0x68B3	# <CJK>
0xAEDF	0x6817	# <CJK>
0xAEE0	0x684C	# <CJK>
0xAEE1	0x6851	# <CJK>
0xAEE2	0x683D	# <CJK>
0xAEE3	0x67F4	# <CJK>
0xAEE4	0x6850	# <CJK>
0xAEE5	0x6840	# <CJK>
0xAEE6	0x683C	# <CJK>
0xAEE7	0x6843	# <CJK>
0xAEE8	0x682A	# <CJK>
0xAEE9	0x6845	# <CJK>
0xAEEA	0x6813	# <CJK>
0xAEEB	0x6818	# <CJK>
0xAEEC	0x6841	# <CJK>
0xAEED	0x6B8A	# <CJK>
0xAEEE	0x6B89	# <CJK>
0xAEEF	0x6BB7	# <CJK>
0xAEF0	0x6C23	# <CJK>
0xAEF1	0x6C27	# <CJK>
0xAEF2	0x6C28	# <CJK>
0xAEF3	0x6C26	# <CJK>
0xAEF4	0x6C24	# <CJK>
0xAEF5	0x6CF0	# <CJK>
0xAEF6	0x6D6A	# <CJK>
0xAEF7	0x6D95	# <CJK>
0xAEF8	0x6D88	# <CJK>
0xAEF9	0x6D87	# <CJK>
0xAEFA	0x6D66	# <CJK>
0xAEFB	0x6D78	# <CJK>
0xAEFC	0x6D77	# <CJK>
0xAEFD	0x6D59	# <CJK>
0xAEFE	0x6D93	# <CJK>
0xAF40	0x6D6C	# <CJK>
0xAF41	0x6D89	# <CJK>
0xAF42	0x6D6E	# <CJK>
0xAF43	0x6D5A	# <CJK>
0xAF44	0x6D74	# <CJK>
0xAF45	0x6D69	# <CJK>
0xAF46	0x6D8C	# <CJK>
0xAF47	0x6D8A	# <CJK>
0xAF48	0x6D79	# <CJK>
0xAF49	0x6D85	# <CJK>
0xAF4A	0x6D65	# <CJK>
0xAF4B	0x6D94	# <CJK>
0xAF4C	0x70CA	# <CJK>
0xAF4D	0x70D8	# <CJK>
0xAF4E	0x70E4	# <CJK>
0xAF4F	0x70D9	# <CJK>
0xAF50	0x70C8	# <CJK>
0xAF51	0x70CF	# <CJK>
0xAF52	0x7239	# <CJK>
0xAF53	0x7279	# <CJK>
0xAF54	0x72FC	# <CJK>
0xAF55	0x72F9	# <CJK>
0xAF56	0x72FD	# <CJK>
0xAF57	0x72F8	# <CJK>
0xAF58	0x72F7	# <CJK>
0xAF59	0x7386	# <CJK>
0xAF5A	0x73ED	# <CJK>
0xAF5B	0x7409	# <CJK>
0xAF5C	0x73EE	# <CJK>
0xAF5D	0x73E0	# <CJK>
0xAF5E	0x73EA	# <CJK>
0xAF5F	0x73DE	# <CJK>
0xAF60	0x7554	# <CJK>
0xAF61	0x755D	# <CJK>
0xAF62	0x755C	# <CJK>
0xAF63	0x755A	# <CJK>
0xAF64	0x7559	# <CJK>
0xAF65	0x75BE	# <CJK>
0xAF66	0x75C5	# <CJK>
0xAF67	0x75C7	# <CJK>
0xAF68	0x75B2	# <CJK>
0xAF69	0x75B3	# <CJK>
0xAF6A	0x75BD	# <CJK>
0xAF6B	0x75BC	# <CJK>
0xAF6C	0x75B9	# <CJK>
0xAF6D	0x75C2	# <CJK>
0xAF6E	0x75B8	# <CJK>
0xAF6F	0x768B	# <CJK>
0xAF70	0x76B0	# <CJK>
0xAF71	0x76CA	# <CJK>
0xAF72	0x76CD	# <CJK>
0xAF73	0x76CE	# <CJK>
0xAF74	0x7729	# <CJK>
0xAF75	0x771F	# <CJK>
0xAF76	0x7720	# <CJK>
0xAF77	0x7728	# <CJK>
0xAF78	0x77E9	# <CJK>
0xAF79	0x7830	# <CJK>
0xAF7A	0x7827	# <CJK>
0xAF7B	0x7838	# <CJK>
0xAF7C	0x781D	# <CJK>
0xAF7D	0x7834	# <CJK>
0xAF7E	0x7837	# <CJK>
0xAFA1	0x7825	# <CJK>
0xAFA2	0x782D	# <CJK>
0xAFA3	0x7820	# <CJK>
0xAFA4	0x781F	# <CJK>
0xAFA5	0x7832	# <CJK>
0xAFA6	0x7955	# <CJK>
0xAFA7	0x7950	# <CJK>
0xAFA8	0x7960	# <CJK>
0xAFA9	0x795F	# <CJK>
0xAFAA	0x7956	# <CJK>
0xAFAB	0x795E	# <CJK>
0xAFAC	0x795D	# <CJK>
0xAFAD	0x7957	# <CJK>
0xAFAE	0x795A	# <CJK>
0xAFAF	0x79E4	# <CJK>
0xAFB0	0x79E3	# <CJK>
0xAFB1	0x79E7	# <CJK>
0xAFB2	0x79DF	# <CJK>
0xAFB3	0x79E6	# <CJK>
0xAFB4	0x79E9	# <CJK>
0xAFB5	0x79D8	# <CJK>
0xAFB6	0x7A84	# <CJK>
0xAFB7	0x7A88	# <CJK>
0xAFB8	0x7AD9	# <CJK>
0xAFB9	0x7B06	# <CJK>
0xAFBA	0x7B11	# <CJK>
0xAFBB	0x7C89	# <CJK>
0xAFBC	0x7D21	# <CJK>
0xAFBD	0x7D17	# <CJK>
0xAFBE	0x7D0B	# <CJK>
0xAFBF	0x7D0A	# <CJK>
0xAFC0	0x7D20	# <CJK>
0xAFC1	0x7D22	# <CJK>
0xAFC2	0x7D14	# <CJK>
0xAFC3	0x7D10	# <CJK>
0xAFC4	0x7D15	# <CJK>
0xAFC5	0x7D1A	# <CJK>
0xAFC6	0x7D1C	# <CJK>
0xAFC7	0x7D0D	# <CJK>
0xAFC8	0x7D19	# <CJK>
0xAFC9	0x7D1B	# <CJK>
0xAFCA	0x7F3A	# <CJK>
0xAFCB	0x7F5F	# <CJK>
0xAFCC	0x7F94	# <CJK>
0xAFCD	0x7FC5	# <CJK>
0xAFCE	0x7FC1	# <CJK>
0xAFCF	0x8006	# <CJK>
0xAFD0	0x8018	# <CJK>
0xAFD1	0x8015	# <CJK>
0xAFD2	0x8019	# <CJK>
0xAFD3	0x8017	# <CJK>
0xAFD4	0x803D	# <CJK>
0xAFD5	0x803F	# <CJK>
0xAFD6	0x80F1	# <CJK>
0xAFD7	0x8102	# <CJK>
0xAFD8	0x80F0	# <CJK>
0xAFD9	0x8105	# <CJK>
0xAFDA	0x80ED	# <CJK>
0xAFDB	0x80F4	# <CJK>
0xAFDC	0x8106	# <CJK>
0xAFDD	0x80F8	# <CJK>
0xAFDE	0x80F3	# <CJK>
0xAFDF	0x8108	# <CJK>
0xAFE0	0x80FD	# <CJK>
0xAFE1	0x810A	# <CJK>
0xAFE2	0x80FC	# <CJK>
0xAFE3	0x80EF	# <CJK>
0xAFE4	0x81ED	# <CJK>
0xAFE5	0x81EC	# <CJK>
0xAFE6	0x8200	# <CJK>
0xAFE7	0x8210	# <CJK>
0xAFE8	0x822A	# <CJK>
0xAFE9	0x822B	# <CJK>
0xAFEA	0x8228	# <CJK>
0xAFEB	0x822C	# <CJK>
0xAFEC	0x82BB	# <CJK>
0xAFED	0x832B	# <CJK>
0xAFEE	0x8352	# <CJK>
0xAFEF	0x8354	# <CJK>
0xAFF0	0x834A	# <CJK>
0xAFF1	0x8338	# <CJK>
0xAFF2	0x8350	# <CJK>
0xAFF3	0x8349	# <CJK>
0xAFF4	0x8335	# <CJK>
0xAFF5	0x8334	# <CJK>
0xAFF6	0x834F	# <CJK>
0xAFF7	0x8332	# <CJK>
0xAFF8	0x8339	# <CJK>
0xAFF9	0x8336	# <CJK>
0xAFFA	0x8317	# <CJK>
0xAFFB	0x8340	# <CJK>
0xAFFC	0x8331	# <CJK>
0xAFFD	0x8328	# <CJK>
0xAFFE	0x8343	# <CJK>
0xB040	0x8654	# <CJK>
0xB041	0x868A	# <CJK>
0xB042	0x86AA	# <CJK>
0xB043	0x8693	# <CJK>
0xB044	0x86A4	# <CJK>
0xB045	0x86A9	# <CJK>
0xB046	0x868C	# <CJK>
0xB047	0x86A3	# <CJK>
0xB048	0x869C	# <CJK>
0xB049	0x8870	# <CJK>
0xB04A	0x8877	# <CJK>
0xB04B	0x8881	# <CJK>
0xB04C	0x8882	# <CJK>
0xB04D	0x887D	# <CJK>
0xB04E	0x8879	# <CJK>
0xB04F	0x8A18	# <CJK>
0xB050	0x8A10	# <CJK>
0xB051	0x8A0E	# <CJK>
0xB052	0x8A0C	# <CJK>
0xB053	0x8A15	# <CJK>
0xB054	0x8A0A	# <CJK>
0xB055	0x8A17	# <CJK>
0xB056	0x8A13	# <CJK>
0xB057	0x8A16	# <CJK>
0xB058	0x8A0F	# <CJK>
0xB059	0x8A11	# <CJK>
0xB05A	0x8C48	# <CJK>
0xB05B	0x8C7A	# <CJK>
0xB05C	0x8C79	# <CJK>
0xB05D	0x8CA1	# <CJK>
0xB05E	0x8CA2	# <CJK>
0xB05F	0x8D77	# <CJK>
0xB060	0x8EAC	# <CJK>
0xB061	0x8ED2	# <CJK>
0xB062	0x8ED4	# <CJK>
0xB063	0x8ECF	# <CJK>
0xB064	0x8FB1	# <CJK>
0xB065	0x9001	# <CJK>
0xB066	0x9006	# <CJK>
0xB067	0x8FF7	# <CJK>
0xB068	0x9000	# <CJK>
0xB069	0x8FFA	# <CJK>
0xB06A	0x8FF4	# <CJK>
0xB06B	0x9003	# <CJK>
0xB06C	0x8FFD	# <CJK>
0xB06D	0x9005	# <CJK>
0xB06E	0x8FF8	# <CJK>
0xB06F	0x9095	# <CJK>
0xB070	0x90E1	# <CJK>
0xB071	0x90DD	# <CJK>
0xB072	0x90E2	# <CJK>
0xB073	0x9152	# <CJK>
0xB074	0x914D	# <CJK>
0xB075	0x914C	# <CJK>
0xB076	0x91D8	# <CJK>
0xB077	0x91DD	# <CJK>
0xB078	0x91D7	# <CJK>
0xB079	0x91DC	# <CJK>
0xB07A	0x91D9	# <CJK>
0xB07B	0x9583	# <CJK>
0xB07C	0x9662	# <CJK>
0xB07D	0x9663	# <CJK>
0xB07E	0x9661	# <CJK>
0xB0A1	0x965B	# <CJK>
0xB0A2	0x965D	# <CJK>
0xB0A3	0x9664	# <CJK>
0xB0A4	0x9658	# <CJK>
0xB0A5	0x965E	# <CJK>
0xB0A6	0x96BB	# <CJK>
0xB0A7	0x98E2	# <CJK>
0xB0A8	0x99AC	# <CJK>
0xB0A9	0x9AA8	# <CJK>
0xB0AA	0x9AD8	# <CJK>
0xB0AB	0x9B25	# <CJK>
0xB0AC	0x9B32	# <CJK>
0xB0AD	0x9B3C	# <CJK>
0xB0AE	0x4E7E	# <CJK>
0xB0AF	0x507A	# <CJK>
0xB0B0	0x507D	# <CJK>
0xB0B1	0x505C	# <CJK>
0xB0B2	0x5047	# <CJK>
0xB0B3	0x5043	# <CJK>
0xB0B4	0x504C	# <CJK>
0xB0B5	0x505A	# <CJK>
0xB0B6	0x5049	# <CJK>
0xB0B7	0x5065	# <CJK>
0xB0B8	0x5076	# <CJK>
0xB0B9	0x504E	# <CJK>
0xB0BA	0x5055	# <CJK>
0xB0BB	0x5075	# <CJK>
0xB0BC	0x5074	# <CJK>
0xB0BD	0x5077	# <CJK>
0xB0BE	0x504F	# <CJK>
0xB0BF	0x500F	# <CJK>
0xB0C0	0x506F	# <CJK>
0xB0C1	0x506D	# <CJK>
0xB0C2	0x515C	# <CJK>
0xB0C3	0x5195	# <CJK>
0xB0C4	0x51F0	# <CJK>
0xB0C5	0x526A	# <CJK>
0xB0C6	0x526F	# <CJK>
0xB0C7	0x52D2	# <CJK>
0xB0C8	0x52D9	# <CJK>
0xB0C9	0x52D8	# <CJK>
0xB0CA	0x52D5	# <CJK>
0xB0CB	0x5310	# <CJK>
0xB0CC	0x530F	# <CJK>
0xB0CD	0x5319	# <CJK>
0xB0CE	0x533F	# <CJK>
0xB0CF	0x5340	# <CJK>
0xB0D0	0x533E	# <CJK>
0xB0D1	0x53C3	# <CJK>
0xB0D2	0x66FC	# <CJK>
0xB0D3	0x5546	# <CJK>
0xB0D4	0x556A	# <CJK>
0xB0D5	0x5566	# <CJK>
0xB0D6	0x5544	# <CJK>
0xB0D7	0x555E	# <CJK>
0xB0D8	0x5561	# <CJK>
0xB0D9	0x5543	# <CJK>
0xB0DA	0x554A	# <CJK>
0xB0DB	0x5531	# <CJK>
0xB0DC	0x5556	# <CJK>
0xB0DD	0x554F	# <CJK>
0xB0DE	0x5555	# <CJK>
0xB0DF	0x552F	# <CJK>
0xB0E0	0x5564	# <CJK>
0xB0E1	0x5538	# <CJK>
0xB0E2	0x552E	# <CJK>
0xB0E3	0x555C	# <CJK>
0xB0E4	0x552C	# <CJK>
0xB0E5	0x5563	# <CJK>
0xB0E6	0x5533	# <CJK>
0xB0E7	0x5541	# <CJK>
0xB0E8	0x5557	# <CJK>
0xB0E9	0x5708	# <CJK>
0xB0EA	0x570B	# <CJK>
0xB0EB	0x5709	# <CJK>
0xB0EC	0x57DF	# <CJK>
0xB0ED	0x5805	# <CJK>
0xB0EE	0x580A	# <CJK>
0xB0EF	0x5806	# <CJK>
0xB0F0	0x57E0	# <CJK>
0xB0F1	0x57E4	# <CJK>
0xB0F2	0x57FA	# <CJK>
0xB0F3	0x5802	# <CJK>
0xB0F4	0x5835	# <CJK>
0xB0F5	0x57F7	# <CJK>
0xB0F6	0x57F9	# <CJK>
0xB0F7	0x5920	# <CJK>
0xB0F8	0x5962	# <CJK>
0xB0F9	0x5A36	# <CJK>
0xB0FA	0x5A41	# <CJK>
0xB0FB	0x5A49	# <CJK>
0xB0FC	0x5A66	# <CJK>
0xB0FD	0x5A6A	# <CJK>
0xB0FE	0x5A40	# <CJK>
0xB140	0x5A3C	# <CJK>
0xB141	0x5A62	# <CJK>
0xB142	0x5A5A	# <CJK>
0xB143	0x5A46	# <CJK>
0xB144	0x5A4A	# <CJK>
0xB145	0x5B70	# <CJK>
0xB146	0x5BC7	# <CJK>
0xB147	0x5BC5	# <CJK>
0xB148	0x5BC4	# <CJK>
0xB149	0x5BC2	# <CJK>
0xB14A	0x5BBF	# <CJK>
0xB14B	0x5BC6	# <CJK>
0xB14C	0x5C09	# <CJK>
0xB14D	0x5C08	# <CJK>
0xB14E	0x5C07	# <CJK>
0xB14F	0x5C60	# <CJK>
0xB150	0x5C5C	# <CJK>
0xB151	0x5C5D	# <CJK>
0xB152	0x5D07	# <CJK>
0xB153	0x5D06	# <CJK>
0xB154	0x5D0E	# <CJK>
0xB155	0x5D1B	# <CJK>
0xB156	0x5D16	# <CJK>
0xB157	0x5D22	# <CJK>
0xB158	0x5D11	# <CJK>
0xB159	0x5D29	# <CJK>
0xB15A	0x5D14	# <CJK>
0xB15B	0x5D19	# <CJK>
0xB15C	0x5D24	# <CJK>
0xB15D	0x5D27	# <CJK>
0xB15E	0x5D17	# <CJK>
0xB15F	0x5DE2	# <CJK>
0xB160	0x5E38	# <CJK>
0xB161	0x5E36	# <CJK>
0xB162	0x5E33	# <CJK>
0xB163	0x5E37	# <CJK>
0xB164	0x5EB7	# <CJK>
0xB165	0x5EB8	# <CJK>
0xB166	0x5EB6	# <CJK>
0xB167	0x5EB5	# <CJK>
0xB168	0x5EBE	# <CJK>
0xB169	0x5F35	# <CJK>
0xB16A	0x5F37	# <CJK>
0xB16B	0x5F57	# <CJK>
0xB16C	0x5F6C	# <CJK>
0xB16D	0x5F69	# <CJK>
0xB16E	0x5F6B	# <CJK>
0xB16F	0x5F97	# <CJK>
0xB170	0x5F99	# <CJK>
0xB171	0x5F9E	# <CJK>
0xB172	0x5F98	# <CJK>
0xB173	0x5FA1	# <CJK>
0xB174	0x5FA0	# <CJK>
0xB175	0x5F9C	# <CJK>
0xB176	0x607F	# <CJK>
0xB177	0x60A3	# <CJK>
0xB178	0x6089	# <CJK>
0xB179	0x60A0	# <CJK>
0xB17A	0x60A8	# <CJK>
0xB17B	0x60CB	# <CJK>
0xB17C	0x60B4	# <CJK>
0xB17D	0x60E6	# <CJK>
0xB17E	0x60BD	# <CJK>
0xB1A1	0x60C5	# <CJK>
0xB1A2	0x60BB	# <CJK>
0xB1A3	0x60B5	# <CJK>
0xB1A4	0x60DC	# <CJK>
0xB1A5	0x60BC	# <CJK>
0xB1A6	0x60D8	# <CJK>
0xB1A7	0x60D5	# <CJK>
0xB1A8	0x60C6	# <CJK>
0xB1A9	0x60DF	# <CJK>
0xB1AA	0x60B8	# <CJK>
0xB1AB	0x60DA	# <CJK>
0xB1AC	0x60C7	# <CJK>
0xB1AD	0x621A	# <CJK>
0xB1AE	0x621B	# <CJK>
0xB1AF	0x6248	# <CJK>
0xB1B0	0x63A0	# <CJK>
0xB1B1	0x63A7	# <CJK>
0xB1B2	0x6372	# <CJK>
0xB1B3	0x6396	# <CJK>
0xB1B4	0x63A2	# <CJK>
0xB1B5	0x63A5	# <CJK>
0xB1B6	0x6377	# <CJK>
0xB1B7	0x6367	# <CJK>
0xB1B8	0x6398	# <CJK>
0xB1B9	0x63AA	# <CJK>
0xB1BA	0x6371	# <CJK>
0xB1BB	0x63A9	# <CJK>
0xB1BC	0x6389	# <CJK>
0xB1BD	0x6383	# <CJK>
0xB1BE	0x639B	# <CJK>
0xB1BF	0x636B	# <CJK>
0xB1C0	0x63A8	# <CJK>
0xB1C1	0x6384	# <CJK>
0xB1C2	0x6388	# <CJK>
0xB1C3	0x6399	# <CJK>
0xB1C4	0x63A1	# <CJK>
0xB1C5	0x63AC	# <CJK>
0xB1C6	0x6392	# <CJK>
0xB1C7	0x638F	# <CJK>
0xB1C8	0x6380	# <CJK>
0xB1C9	0x637B	# <CJK>
0xB1CA	0x6369	# <CJK>
0xB1CB	0x6368	# <CJK>
0xB1CC	0x637A	# <CJK>
0xB1CD	0x655D	# <CJK>
0xB1CE	0x6556	# <CJK>
0xB1CF	0x6551	# <CJK>
0xB1D0	0x6559	# <CJK>
0xB1D1	0x6557	# <CJK>
0xB1D2	0x555F	# <CJK>
0xB1D3	0x654F	# <CJK>
0xB1D4	0x6558	# <CJK>
0xB1D5	0x6555	# <CJK>
0xB1D6	0x6554	# <CJK>
0xB1D7	0x659C	# <CJK>
0xB1D8	0x659B	# <CJK>
0xB1D9	0x65AC	# <CJK>
0xB1DA	0x65CF	# <CJK>
0xB1DB	0x65CB	# <CJK>
0xB1DC	0x65CC	# <CJK>
0xB1DD	0x65CE	# <CJK>
0xB1DE	0x665D	# <CJK>
0xB1DF	0x665A	# <CJK>
0xB1E0	0x6664	# <CJK>
0xB1E1	0x6668	# <CJK>
0xB1E2	0x6666	# <CJK>
0xB1E3	0x665E	# <CJK>
0xB1E4	0x66F9	# <CJK>
0xB1E5	0x52D7	# <CJK>
0xB1E6	0x671B	# <CJK>
0xB1E7	0x6881	# <CJK>
0xB1E8	0x68AF	# <CJK>
0xB1E9	0x68A2	# <CJK>
0xB1EA	0x6893	# <CJK>
0xB1EB	0x68B5	# <CJK>
0xB1EC	0x687F	# <CJK>
0xB1ED	0x6876	# <CJK>
0xB1EE	0x68B1	# <CJK>
0xB1EF	0x68A7	# <CJK>
0xB1F0	0x6897	# <CJK>
0xB1F1	0x68B0	# <CJK>
0xB1F2	0x6883	# <CJK>
0xB1F3	0x68C4	# <CJK>
0xB1F4	0x68AD	# <CJK>
0xB1F5	0x6886	# <CJK>
0xB1F6	0x6885	# <CJK>
0xB1F7	0x6894	# <CJK>
0xB1F8	0x689D	# <CJK>
0xB1F9	0x68A8	# <CJK>
0xB1FA	0x689F	# <CJK>
0xB1FB	0x68A1	# <CJK>
0xB1FC	0x6882	# <CJK>
0xB1FD	0x6B32	# <CJK>
0xB1FE	0x6BBA	# <CJK>
0xB240	0x6BEB	# <CJK>
0xB241	0x6BEC	# <CJK>
0xB242	0x6C2B	# <CJK>
0xB243	0x6D8E	# <CJK>
0xB244	0x6DBC	# <CJK>
0xB245	0x6DF3	# <CJK>
0xB246	0x6DD9	# <CJK>
0xB247	0x6DB2	# <CJK>
0xB248	0x6DE1	# <CJK>
0xB249	0x6DCC	# <CJK>
0xB24A	0x6DE4	# <CJK>
0xB24B	0x6DFB	# <CJK>
0xB24C	0x6DFA	# <CJK>
0xB24D	0x6E05	# <CJK>
0xB24E	0x6DC7	# <CJK>
0xB24F	0x6DCB	# <CJK>
0xB250	0x6DAF	# <CJK>
0xB251	0x6DD1	# <CJK>
0xB252	0x6DAE	# <CJK>
0xB253	0x6DDE	# <CJK>
0xB254	0x6DF9	# <CJK>
0xB255	0x6DB8	# <CJK>
0xB256	0x6DF7	# <CJK>
0xB257	0x6DF5	# <CJK>
0xB258	0x6DC5	# <CJK>
0xB259	0x6DD2	# <CJK>
0xB25A	0x6E1A	# <CJK>
0xB25B	0x6DB5	# <CJK>
0xB25C	0x6DDA	# <CJK>
0xB25D	0x6DEB	# <CJK>
0xB25E	0x6DD8	# <CJK>
0xB25F	0x6DEA	# <CJK>
0xB260	0x6DF1	# <CJK>
0xB261	0x6DEE	# <CJK>
0xB262	0x6DE8	# <CJK>
0xB263	0x6DC6	# <CJK>
0xB264	0x6DC4	# <CJK>
0xB265	0x6DAA	# <CJK>
0xB266	0x6DEC	# <CJK>
0xB267	0x6DBF	# <CJK>
0xB268	0x6DE6	# <CJK>
0xB269	0x70F9	# <CJK>
0xB26A	0x7109	# <CJK>
0xB26B	0x710A	# <CJK>
0xB26C	0x70FD	# <CJK>
0xB26D	0x70EF	# <CJK>
0xB26E	0x723D	# <CJK>
0xB26F	0x727D	# <CJK>
0xB270	0x7281	# <CJK>
0xB271	0x731C	# <CJK>
0xB272	0x731B	# <CJK>
0xB273	0x7316	# <CJK>
0xB274	0x7313	# <CJK>
0xB275	0x7319	# <CJK>
0xB276	0x7387	# <CJK>
0xB277	0x7405	# <CJK>
0xB278	0x740A	# <CJK>
0xB279	0x7403	# <CJK>
0xB27A	0x7406	# <CJK>
0xB27B	0x73FE	# <CJK>
0xB27C	0x740D	# <CJK>
0xB27D	0x74E0	# <CJK>
0xB27E	0x74F6	# <CJK>
0xB2A1	0x74F7	# <CJK>
0xB2A2	0x751C	# <CJK>
0xB2A3	0x7522	# <CJK>
0xB2A4	0x7565	# <CJK>
0xB2A5	0x7566	# <CJK>
0xB2A6	0x7562	# <CJK>
0xB2A7	0x7570	# <CJK>
0xB2A8	0x758F	# <CJK>
0xB2A9	0x75D4	# <CJK>
0xB2AA	0x75D5	# <CJK>
0xB2AB	0x75B5	# <CJK>
0xB2AC	0x75CA	# <CJK>
0xB2AD	0x75CD	# <CJK>
0xB2AE	0x768E	# <CJK>
0xB2AF	0x76D4	# <CJK>
0xB2B0	0x76D2	# <CJK>
0xB2B1	0x76DB	# <CJK>
0xB2B2	0x7737	# <CJK>
0xB2B3	0x773E	# <CJK>
0xB2B4	0x773C	# <CJK>
0xB2B5	0x7736	# <CJK>
0xB2B6	0x7738	# <CJK>
0xB2B7	0x773A	# <CJK>
0xB2B8	0x786B	# <CJK>
0xB2B9	0x7843	# <CJK>
0xB2BA	0x784E	# <CJK>
0xB2BB	0x7965	# <CJK>
0xB2BC	0x7968	# <CJK>
0xB2BD	0x796D	# <CJK>
0xB2BE	0x79FB	# <CJK>
0xB2BF	0x7A92	# <CJK>
0xB2C0	0x7A95	# <CJK>
0xB2C1	0x7B20	# <CJK>
0xB2C2	0x7B28	# <CJK>
0xB2C3	0x7B1B	# <CJK>
0xB2C4	0x7B2C	# <CJK>
0xB2C5	0x7B26	# <CJK>
0xB2C6	0x7B19	# <CJK>
0xB2C7	0x7B1E	# <CJK>
0xB2C8	0x7B2E	# <CJK>
0xB2C9	0x7C92	# <CJK>
0xB2CA	0x7C97	# <CJK>
0xB2CB	0x7C95	# <CJK>
0xB2CC	0x7D46	# <CJK>
0xB2CD	0x7D43	# <CJK>
0xB2CE	0x7D71	# <CJK>
0xB2CF	0x7D2E	# <CJK>
0xB2D0	0x7D39	# <CJK>
0xB2D1	0x7D3C	# <CJK>
0xB2D2	0x7D40	# <CJK>
0xB2D3	0x7D30	# <CJK>
0xB2D4	0x7D33	# <CJK>
0xB2D5	0x7D44	# <CJK>
0xB2D6	0x7D2F	# <CJK>
0xB2D7	0x7D42	# <CJK>
0xB2D8	0x7D32	# <CJK>
0xB2D9	0x7D31	# <CJK>
0xB2DA	0x7F3D	# <CJK>
0xB2DB	0x7F9E	# <CJK>
0xB2DC	0x7F9A	# <CJK>
0xB2DD	0x7FCC	# <CJK>
0xB2DE	0x7FCE	# <CJK>
0xB2DF	0x7FD2	# <CJK>
0xB2E0	0x801C	# <CJK>
0xB2E1	0x804A	# <CJK>
0xB2E2	0x8046	# <CJK>
0xB2E3	0x812F	# <CJK>
0xB2E4	0x8116	# <CJK>
0xB2E5	0x8123	# <CJK>
0xB2E6	0x812B	# <CJK>
0xB2E7	0x8129	# <CJK>
0xB2E8	0x8130	# <CJK>
0xB2E9	0x8124	# <CJK>
0xB2EA	0x8202	# <CJK>
0xB2EB	0x8235	# <CJK>
0xB2EC	0x8237	# <CJK>
0xB2ED	0x8236	# <CJK>
0xB2EE	0x8239	# <CJK>
0xB2EF	0x838E	# <CJK>
0xB2F0	0x839E	# <CJK>
0xB2F1	0x8398	# <CJK>
0xB2F2	0x8378	# <CJK>
0xB2F3	0x83A2	# <CJK>
0xB2F4	0x8396	# <CJK>
0xB2F5	0x83BD	# <CJK>
0xB2F6	0x83AB	# <CJK>
0xB2F7	0x8392	# <CJK>
0xB2F8	0x838A	# <CJK>
0xB2F9	0x8393	# <CJK>
0xB2FA	0x8389	# <CJK>
0xB2FB	0x83A0	# <CJK>
0xB2FC	0x8377	# <CJK>
0xB2FD	0x837B	# <CJK>
0xB2FE	0x837C	# <CJK>
0xB340	0x8386	# <CJK>
0xB341	0x83A7	# <CJK>
0xB342	0x8655	# <CJK>
0xB343	0x5F6A	# <CJK>
0xB344	0x86C7	# <CJK>
0xB345	0x86C0	# <CJK>
0xB346	0x86B6	# <CJK>
0xB347	0x86C4	# <CJK>
0xB348	0x86B5	# <CJK>
0xB349	0x86C6	# <CJK>
0xB34A	0x86CB	# <CJK>
0xB34B	0x86B1	# <CJK>
0xB34C	0x86AF	# <CJK>
0xB34D	0x86C9	# <CJK>
0xB34E	0x8853	# <CJK>
0xB34F	0x889E	# <CJK>
0xB350	0x8888	# <CJK>
0xB351	0x88AB	# <CJK>
0xB352	0x8892	# <CJK>
0xB353	0x8896	# <CJK>
0xB354	0x888D	# <CJK>
0xB355	0x888B	# <CJK>
0xB356	0x8993	# <CJK>
0xB357	0x898F	# <CJK>
0xB358	0x8A2A	# <CJK>
0xB359	0x8A1D	# <CJK>
0xB35A	0x8A23	# <CJK>
0xB35B	0x8A25	# <CJK>
0xB35C	0x8A31	# <CJK>
0xB35D	0x8A2D	# <CJK>
0xB35E	0x8A1F	# <CJK>
0xB35F	0x8A1B	# <CJK>
0xB360	0x8A22	# <CJK>
0xB361	0x8C49	# <CJK>
0xB362	0x8C5A	# <CJK>
0xB363	0x8CA9	# <CJK>
0xB364	0x8CAC	# <CJK>
0xB365	0x8CAB	# <CJK>
0xB366	0x8CA8	# <CJK>
0xB367	0x8CAA	# <CJK>
0xB368	0x8CA7	# <CJK>
0xB369	0x8D67	# <CJK>
0xB36A	0x8D66	# <CJK>
0xB36B	0x8DBE	# <CJK>
0xB36C	0x8DBA	# <CJK>
0xB36D	0x8EDB	# <CJK>
0xB36E	0x8EDF	# <CJK>
0xB36F	0x9019	# <CJK>
0xB370	0x900D	# <CJK>
0xB371	0x901A	# <CJK>
0xB372	0x9017	# <CJK>
0xB373	0x9023	# <CJK>
0xB374	0x901F	# <CJK>
0xB375	0x901D	# <CJK>
0xB376	0x9010	# <CJK>
0xB377	0x9015	# <CJK>
0xB378	0x901E	# <CJK>
0xB379	0x9020	# <CJK>
0xB37A	0x900F	# <CJK>
0xB37B	0x9022	# <CJK>
0xB37C	0x9016	# <CJK>
0xB37D	0x901B	# <CJK>
0xB37E	0x9014	# <CJK>
0xB3A1	0x90E8	# <CJK>
0xB3A2	0x90ED	# <CJK>
0xB3A3	0x90FD	# <CJK>
0xB3A4	0x9157	# <CJK>
0xB3A5	0x91CE	# <CJK>
0xB3A6	0x91F5	# <CJK>
0xB3A7	0x91E6	# <CJK>
0xB3A8	0x91E3	# <CJK>
0xB3A9	0x91E7	# <CJK>
0xB3AA	0x91ED	# <CJK>
0xB3AB	0x91E9	# <CJK>
0xB3AC	0x9589	# <CJK>
0xB3AD	0x966A	# <CJK>
0xB3AE	0x9675	# <CJK>
0xB3AF	0x9673	# <CJK>
0xB3B0	0x9678	# <CJK>
0xB3B1	0x9670	# <CJK>
0xB3B2	0x9674	# <CJK>
0xB3B3	0x9676	# <CJK>
0xB3B4	0x9677	# <CJK>
0xB3B5	0x966C	# <CJK>
0xB3B6	0x96C0	# <CJK>
0xB3B7	0x96EA	# <CJK>
0xB3B8	0x96E9	# <CJK>
0xB3B9	0x7AE0	# <CJK>
0xB3BA	0x7ADF	# <CJK>
0xB3BB	0x9802	# <CJK>
0xB3BC	0x9803	# <CJK>
0xB3BD	0x9B5A	# <CJK>
0xB3BE	0x9CE5	# <CJK>
0xB3BF	0x9E75	# <CJK>
0xB3C0	0x9E7F	# <CJK>
0xB3C1	0x9EA5	# <CJK>
0xB3C2	0x9EBB	# <CJK>
0xB3C3	0x50A2	# <CJK>
0xB3C4	0x508D	# <CJK>
0xB3C5	0x5085	# <CJK>
0xB3C6	0x5099	# <CJK>
0xB3C7	0x5091	# <CJK>
0xB3C8	0x5080	# <CJK>
0xB3C9	0x5096	# <CJK>
0xB3CA	0x5098	# <CJK>
0xB3CB	0x509A	# <CJK>
0xB3CC	0x6700	# <CJK>
0xB3CD	0x51F1	# <CJK>
0xB3CE	0x5272	# <CJK>
0xB3CF	0x5274	# <CJK>
0xB3D0	0x5275	# <CJK>
0xB3D1	0x5269	# <CJK>
0xB3D2	0x52DE	# <CJK>
0xB3D3	0x52DD	# <CJK>
0xB3D4	0x52DB	# <CJK>
0xB3D5	0x535A	# <CJK>
0xB3D6	0x53A5	# <CJK>
0xB3D7	0x557B	# <CJK>
0xB3D8	0x5580	# <CJK>
0xB3D9	0x55A7	# <CJK>
0xB3DA	0x557C	# <CJK>
0xB3DB	0x558A	# <CJK>
0xB3DC	0x559D	# <CJK>
0xB3DD	0x5598	# <CJK>
0xB3DE	0x5582	# <CJK>
0xB3DF	0x559C	# <CJK>
0xB3E0	0x55AA	# <CJK>
0xB3E1	0x5594	# <CJK>
0xB3E2	0x5587	# <CJK>
0xB3E3	0x558B	# <CJK>
0xB3E4	0x5583	# <CJK>
0xB3E5	0x55B3	# <CJK>
0xB3E6	0x55AE	# <CJK>
0xB3E7	0x559F	# <CJK>
0xB3E8	0x553E	# <CJK>
0xB3E9	0x55B2	# <CJK>
0xB3EA	0x559A	# <CJK>
0xB3EB	0x55BB	# <CJK>
0xB3EC	0x55AC	# <CJK>
0xB3ED	0x55B1	# <CJK>
0xB3EE	0x557E	# <CJK>
0xB3EF	0x5589	# <CJK>
0xB3F0	0x55AB	# <CJK>
0xB3F1	0x5599	# <CJK>
0xB3F2	0x570D	# <CJK>
0xB3F3	0x582F	# <CJK>
0xB3F4	0x582A	# <CJK>
0xB3F5	0x5834	# <CJK>
0xB3F6	0x5824	# <CJK>
0xB3F7	0x5830	# <CJK>
0xB3F8	0x5831	# <CJK>
0xB3F9	0x5821	# <CJK>
0xB3FA	0x581D	# <CJK>
0xB3FB	0x5820	# <CJK>
0xB3FC	0x58F9	# <CJK>
0xB3FD	0x58FA	# <CJK>
0xB3FE	0x5960	# <CJK>
0xB440	0x5A77	# <CJK>
0xB441	0x5A9A	# <CJK>
0xB442	0x5A7F	# <CJK>
0xB443	0x5A92	# <CJK>
0xB444	0x5A9B	# <CJK>
0xB445	0x5AA7	# <CJK>
0xB446	0x5B73	# <CJK>
0xB447	0x5B71	# <CJK>
0xB448	0x5BD2	# <CJK>
0xB449	0x5BCC	# <CJK>
0xB44A	0x5BD3	# <CJK>
0xB44B	0x5BD0	# <CJK>
0xB44C	0x5C0A	# <CJK>
0xB44D	0x5C0B	# <CJK>
0xB44E	0x5C31	# <CJK>
0xB44F	0x5D4C	# <CJK>
0xB450	0x5D50	# <CJK>
0xB451	0x5D34	# <CJK>
0xB452	0x5D47	# <CJK>
0xB453	0x5DFD	# <CJK>
0xB454	0x5E45	# <CJK>
0xB455	0x5E3D	# <CJK>
0xB456	0x5E40	# <CJK>
0xB457	0x5E43	# <CJK>
0xB458	0x5E7E	# <CJK>
0xB459	0x5ECA	# <CJK>
0xB45A	0x5EC1	# <CJK>
0xB45B	0x5EC2	# <CJK>
0xB45C	0x5EC4	# <CJK>
0xB45D	0x5F3C	# <CJK>
0xB45E	0x5F6D	# <CJK>
0xB45F	0x5FA9	# <CJK>
0xB460	0x5FAA	# <CJK>
0xB461	0x5FA8	# <CJK>
0xB462	0x60D1	# <CJK>
0xB463	0x60E1	# <CJK>
0xB464	0x60B2	# <CJK>
0xB465	0x60B6	# <CJK>
0xB466	0x60E0	# <CJK>
0xB467	0x611C	# <CJK>
0xB468	0x6123	# <CJK>
0xB469	0x60FA	# <CJK>
0xB46A	0x6115	# <CJK>
0xB46B	0x60F0	# <CJK>
0xB46C	0x60FB	# <CJK>
0xB46D	0x60F4	# <CJK>
0xB46E	0x6168	# <CJK>
0xB46F	0x60F1	# <CJK>
0xB470	0x610E	# <CJK>
0xB471	0x60F6	# <CJK>
0xB472	0x6109	# <CJK>
0xB473	0x6100	# <CJK>
0xB474	0x6112	# <CJK>
0xB475	0x621F	# <CJK>
0xB476	0x6249	# <CJK>
0xB477	0x63A3	# <CJK>
0xB478	0x638C	# <CJK>
0xB479	0x63CF	# <CJK>
0xB47A	0x63C0	# <CJK>
0xB47B	0x63E9	# <CJK>
0xB47C	0x63C9	# <CJK>
0xB47D	0x63C6	# <CJK>
0xB47E	0x63CD	# <CJK>
0xB4A1	0x63D2	# <CJK>
0xB4A2	0x63E3	# <CJK>
0xB4A3	0x63D0	# <CJK>
0xB4A4	0x63E1	# <CJK>
0xB4A5	0x63D6	# <CJK>
0xB4A6	0x63ED	# <CJK>
0xB4A7	0x63EE	# <CJK>
0xB4A8	0x6376	# <CJK>
0xB4A9	0x63F4	# <CJK>
0xB4AA	0x63EA	# <CJK>
0xB4AB	0x63DB	# <CJK>
0xB4AC	0x6452	# <CJK>
0xB4AD	0x63DA	# <CJK>
0xB4AE	0x63F9	# <CJK>
0xB4AF	0x655E	# <CJK>
0xB4B0	0x6566	# <CJK>
0xB4B1	0x6562	# <CJK>
0xB4B2	0x6563	# <CJK>
0xB4B3	0x6591	# <CJK>
0xB4B4	0x6590	# <CJK>
0xB4B5	0x65AF	# <CJK>
0xB4B6	0x666E	# <CJK>
0xB4B7	0x6670	# <CJK>
0xB4B8	0x6674	# <CJK>
0xB4B9	0x6676	# <CJK>
0xB4BA	0x666F	# <CJK>
0xB4BB	0x6691	# <CJK>
0xB4BC	0x667A	# <CJK>
0xB4BD	0x667E	# <CJK>
0xB4BE	0x6677	# <CJK>
0xB4BF	0x66FE	# <CJK>
0xB4C0	0x66FF	# <CJK>
0xB4C1	0x671F	# <CJK>
0xB4C2	0x671D	# <CJK>
0xB4C3	0x68FA	# <CJK>
0xB4C4	0x68D5	# <CJK>
0xB4C5	0x68E0	# <CJK>
0xB4C6	0x68D8	# <CJK>
0xB4C7	0x68D7	# <CJK>
0xB4C8	0x6905	# <CJK>
0xB4C9	0x68DF	# <CJK>
0xB4CA	0x68F5	# <CJK>
0xB4CB	0x68EE	# <CJK>
0xB4CC	0x68E7	# <CJK>
0xB4CD	0x68F9	# <CJK>
0xB4CE	0x68D2	# <CJK>
0xB4CF	0x68F2	# <CJK>
0xB4D0	0x68E3	# <CJK>
0xB4D1	0x68CB	# <CJK>
0xB4D2	0x68CD	# <CJK>
0xB4D3	0x690D	# <CJK>
0xB4D4	0x6912	# <CJK>
0xB4D5	0x690E	# <CJK>
0xB4D6	0x68C9	# <CJK>
0xB4D7	0x68DA	# <CJK>
0xB4D8	0x696E	# <CJK>
0xB4D9	0x68FB	# <CJK>
0xB4DA	0x6B3E	# <CJK>
0xB4DB	0x6B3A	# <CJK>
0xB4DC	0x6B3D	# <CJK>
0xB4DD	0x6B98	# <CJK>
0xB4DE	0x6B96	# <CJK>
0xB4DF	0x6BBC	# <CJK>
0xB4E0	0x6BEF	# <CJK>
0xB4E1	0x6C2E	# <CJK>
0xB4E2	0x6C2F	# <CJK>
0xB4E3	0x6C2C	# <CJK>
0xB4E4	0x6E2F	# <CJK>
0xB4E5	0x6E38	# <CJK>
0xB4E6	0x6E54	# <CJK>
0xB4E7	0x6E21	# <CJK>
0xB4E8	0x6E32	# <CJK>
0xB4E9	0x6E67	# <CJK>
0xB4EA	0x6E4A	# <CJK>
0xB4EB	0x6E20	# <CJK>
0xB4EC	0x6E25	# <CJK>
0xB4ED	0x6E23	# <CJK>
0xB4EE	0x6E1B	# <CJK>
0xB4EF	0x6E5B	# <CJK>
0xB4F0	0x6E58	# <CJK>
0xB4F1	0x6E24	# <CJK>
0xB4F2	0x6E56	# <CJK>
0xB4F3	0x6E6E	# <CJK>
0xB4F4	0x6E2D	# <CJK>
0xB4F5	0x6E26	# <CJK>
0xB4F6	0x6E6F	# <CJK>
0xB4F7	0x6E34	# <CJK>
0xB4F8	0x6E4D	# <CJK>
0xB4F9	0x6E3A	# <CJK>
0xB4FA	0x6E2C	# <CJK>
0xB4FB	0x6E43	# <CJK>
0xB4FC	0x6E1D	# <CJK>
0xB4FD	0x6E3E	# <CJK>
0xB4FE	0x6ECB	# <CJK>
0xB540	0x6E89	# <CJK>
0xB541	0x6E19	# <CJK>
0xB542	0x6E4E	# <CJK>
0xB543	0x6E63	# <CJK>
0xB544	0x6E44	# <CJK>
0xB545	0x6E72	# <CJK>
0xB546	0x6E69	# <CJK>
0xB547	0x6E5F	# <CJK>
0xB548	0x7119	# <CJK>
0xB549	0x711A	# <CJK>
0xB54A	0x7126	# <CJK>
0xB54B	0x7130	# <CJK>
0xB54C	0x7121	# <CJK>
0xB54D	0x7136	# <CJK>
0xB54E	0x716E	# <CJK>
0xB54F	0x711C	# <CJK>
0xB550	0x724C	# <CJK>
0xB551	0x7284	# <CJK>
0xB552	0x7280	# <CJK>
0xB553	0x7336	# <CJK>
0xB554	0x7325	# <CJK>
0xB555	0x7334	# <CJK>
0xB556	0x7329	# <CJK>
0xB557	0x743A	# <CJK>
0xB558	0x742A	# <CJK>
0xB559	0x7433	# <CJK>
0xB55A	0x7422	# <CJK>
0xB55B	0x7425	# <CJK>
0xB55C	0x7435	# <CJK>
0xB55D	0x7436	# <CJK>
0xB55E	0x7434	# <CJK>
0xB55F	0x742F	# <CJK>
0xB560	0x741B	# <CJK>
0xB561	0x7426	# <CJK>
0xB562	0x7428	# <CJK>
0xB563	0x7525	# <CJK>
0xB564	0x7526	# <CJK>
0xB565	0x756B	# <CJK>
0xB566	0x756A	# <CJK>
0xB567	0x75E2	# <CJK>
0xB568	0x75DB	# <CJK>
0xB569	0x75E3	# <CJK>
0xB56A	0x75D9	# <CJK>
0xB56B	0x75D8	# <CJK>
0xB56C	0x75DE	# <CJK>
0xB56D	0x75E0	# <CJK>
0xB56E	0x767B	# <CJK>
0xB56F	0x767C	# <CJK>
0xB570	0x7696	# <CJK>
0xB571	0x7693	# <CJK>
0xB572	0x76B4	# <CJK>
0xB573	0x76DC	# <CJK>
0xB574	0x774F	# <CJK>
0xB575	0x77ED	# <CJK>
0xB576	0x785D	# <CJK>
0xB577	0x786C	# <CJK>
0xB578	0x786F	# <CJK>
0xB579	0x7A0D	# <CJK>
0xB57A	0x7A08	# <CJK>
0xB57B	0x7A0B	# <CJK>
0xB57C	0x7A05	# <CJK>
0xB57D	0x7A00	# <CJK>
0xB57E	0x7A98	# <CJK>
0xB5A1	0x7A97	# <CJK>
0xB5A2	0x7A96	# <CJK>
0xB5A3	0x7AE5	# <CJK>
0xB5A4	0x7AE3	# <CJK>
0xB5A5	0x7B49	# <CJK>
0xB5A6	0x7B56	# <CJK>
0xB5A7	0x7B46	# <CJK>
0xB5A8	0x7B50	# <CJK>
0xB5A9	0x7B52	# <CJK>
0xB5AA	0x7B54	# <CJK>
0xB5AB	0x7B4D	# <CJK>
0xB5AC	0x7B4B	# <CJK>
0xB5AD	0x7B4F	# <CJK>
0xB5AE	0x7B51	# <CJK>
0xB5AF	0x7C9F	# <CJK>
0xB5B0	0x7CA5	# <CJK>
0xB5B1	0x7D5E	# <CJK>
0xB5B2	0x7D50	# <CJK>
0xB5B3	0x7D68	# <CJK>
0xB5B4	0x7D55	# <CJK>
0xB5B5	0x7D2B	# <CJK>
0xB5B6	0x7D6E	# <CJK>
0xB5B7	0x7D72	# <CJK>
0xB5B8	0x7D61	# <CJK>
0xB5B9	0x7D66	# <CJK>
0xB5BA	0x7D62	# <CJK>
0xB5BB	0x7D70	# <CJK>
0xB5BC	0x7D73	# <CJK>
0xB5BD	0x5584	# <CJK>
0xB5BE	0x7FD4	# <CJK>
0xB5BF	0x7FD5	# <CJK>
0xB5C0	0x800B	# <CJK>
0xB5C1	0x8052	# <CJK>
0xB5C2	0x8085	# <CJK>
0xB5C3	0x8155	# <CJK>
0xB5C4	0x8154	# <CJK>
0xB5C5	0x814B	# <CJK>
0xB5C6	0x8151	# <CJK>
0xB5C7	0x814E	# <CJK>
0xB5C8	0x8139	# <CJK>
0xB5C9	0x8146	# <CJK>
0xB5CA	0x813E	# <CJK>
0xB5CB	0x814C	# <CJK>
0xB5CC	0x8153	# <CJK>
0xB5CD	0x8174	# <CJK>
0xB5CE	0x8212	# <CJK>
0xB5CF	0x821C	# <CJK>
0xB5D0	0x83E9	# <CJK>
0xB5D1	0x8403	# <CJK>
0xB5D2	0x83F8	# <CJK>
0xB5D3	0x840D	# <CJK>
0xB5D4	0x83E0	# <CJK>
0xB5D5	0x83C5	# <CJK>
0xB5D6	0x840B	# <CJK>
0xB5D7	0x83C1	# <CJK>
0xB5D8	0x83EF	# <CJK>
0xB5D9	0x83F1	# <CJK>
0xB5DA	0x83F4	# <CJK>
0xB5DB	0x8457	# <CJK>
0xB5DC	0x840A	# <CJK>
0xB5DD	0x83F0	# <CJK>
0xB5DE	0x840C	# <CJK>
0xB5DF	0x83CC	# <CJK>
0xB5E0	0x83FD	# <CJK>
0xB5E1	0x83F2	# <CJK>
0xB5E2	0x83CA	# <CJK>
0xB5E3	0x8438	# <CJK>
0xB5E4	0x840E	# <CJK>
0xB5E5	0x8404	# <CJK>
0xB5E6	0x83DC	# <CJK>
0xB5E7	0x8407	# <CJK>
0xB5E8	0x83D4	# <CJK>
0xB5E9	0x83DF	# <CJK>
0xB5EA	0x865B	# <CJK>
0xB5EB	0x86DF	# <CJK>
0xB5EC	0x86D9	# <CJK>
0xB5ED	0x86ED	# <CJK>
0xB5EE	0x86D4	# <CJK>
0xB5EF	0x86DB	# <CJK>
0xB5F0	0x86E4	# <CJK>
0xB5F1	0x86D0	# <CJK>
0xB5F2	0x86DE	# <CJK>
0xB5F3	0x8857	# <CJK>
0xB5F4	0x88C1	# <CJK>
0xB5F5	0x88C2	# <CJK>
0xB5F6	0x88B1	# <CJK>
0xB5F7	0x8983	# <CJK>
0xB5F8	0x8996	# <CJK>
0xB5F9	0x8A3B	# <CJK>
0xB5FA	0x8A60	# <CJK>
0xB5FB	0x8A55	# <CJK>
0xB5FC	0x8A5E	# <CJK>
0xB5FD	0x8A3C	# <CJK>
0xB5FE	0x8A41	# <CJK>
0xB640	0x8A54	# <CJK>
0xB641	0x8A5B	# <CJK>
0xB642	0x8A50	# <CJK>
0xB643	0x8A46	# <CJK>
0xB644	0x8A34	# <CJK>
0xB645	0x8A3A	# <CJK>
0xB646	0x8A36	# <CJK>
0xB647	0x8A56	# <CJK>
0xB648	0x8C61	# <CJK>
0xB649	0x8C82	# <CJK>
0xB64A	0x8CAF	# <CJK>
0xB64B	0x8CBC	# <CJK>
0xB64C	0x8CB3	# <CJK>
0xB64D	0x8CBD	# <CJK>
0xB64E	0x8CC1	# <CJK>
0xB64F	0x8CBB	# <CJK>
0xB650	0x8CC0	# <CJK>
0xB651	0x8CB4	# <CJK>
0xB652	0x8CB7	# <CJK>
0xB653	0x8CB6	# <CJK>
0xB654	0x8CBF	# <CJK>
0xB655	0x8CB8	# <CJK>
0xB656	0x8D8A	# <CJK>
0xB657	0x8D85	# <CJK>
0xB658	0x8D81	# <CJK>
0xB659	0x8DCE	# <CJK>
0xB65A	0x8DDD	# <CJK>
0xB65B	0x8DCB	# <CJK>
0xB65C	0x8DDA	# <CJK>
0xB65D	0x8DD1	# <CJK>
0xB65E	0x8DCC	# <CJK>
0xB65F	0x8DDB	# <CJK>
0xB660	0x8DC6	# <CJK>
0xB661	0x8EFB	# <CJK>
0xB662	0x8EF8	# <CJK>
0xB663	0x8EFC	# <CJK>
0xB664	0x8F9C	# <CJK>
0xB665	0x902E	# <CJK>
0xB666	0x9035	# <CJK>
0xB667	0x9031	# <CJK>
0xB668	0x9038	# <CJK>
0xB669	0x9032	# <CJK>
0xB66A	0x9036	# <CJK>
0xB66B	0x9102	# <CJK>
0xB66C	0x90F5	# <CJK>
0xB66D	0x9109	# <CJK>
0xB66E	0x90FE	# <CJK>
0xB66F	0x9163	# <CJK>
0xB670	0x9165	# <CJK>
0xB671	0x91CF	# <CJK>
0xB672	0x9214	# <CJK>
0xB673	0x9215	# <CJK>
0xB674	0x9223	# <CJK>
0xB675	0x9209	# <CJK>
0xB676	0x921E	# <CJK>
0xB677	0x920D	# <CJK>
0xB678	0x9210	# <CJK>
0xB679	0x9207	# <CJK>
0xB67A	0x9211	# <CJK>
0xB67B	0x9594	# <CJK>
0xB67C	0x958F	# <CJK>
0xB67D	0x958B	# <CJK>
0xB67E	0x9591	# <CJK>
0xB6A1	0x9593	# <CJK>
0xB6A2	0x9592	# <CJK>
0xB6A3	0x958E	# <CJK>
0xB6A4	0x968A	# <CJK>
0xB6A5	0x968E	# <CJK>
0xB6A6	0x968B	# <CJK>
0xB6A7	0x967D	# <CJK>
0xB6A8	0x9685	# <CJK>
0xB6A9	0x9686	# <CJK>
0xB6AA	0x968D	# <CJK>
0xB6AB	0x9672	# <CJK>
0xB6AC	0x9684	# <CJK>
0xB6AD	0x96C1	# <CJK>
0xB6AE	0x96C5	# <CJK>
0xB6AF	0x96C4	# <CJK>
0xB6B0	0x96C6	# <CJK>
0xB6B1	0x96C7	# <CJK>
0xB6B2	0x96EF	# <CJK>
0xB6B3	0x96F2	# <CJK>
0xB6B4	0x97CC	# <CJK>
0xB6B5	0x9805	# <CJK>
0xB6B6	0x9806	# <CJK>
0xB6B7	0x9808	# <CJK>
0xB6B8	0x98E7	# <CJK>
0xB6B9	0x98EA	# <CJK>
0xB6BA	0x98EF	# <CJK>
0xB6BB	0x98E9	# <CJK>
0xB6BC	0x98F2	# <CJK>
0xB6BD	0x98ED	# <CJK>
0xB6BE	0x99AE	# <CJK>
0xB6BF	0x99AD	# <CJK>
0xB6C0	0x9EC3	# <CJK>
0xB6C1	0x9ECD	# <CJK>
0xB6C2	0x9ED1	# <CJK>
0xB6C3	0x4E82	# <CJK>
0xB6C4	0x50AD	# <CJK>
0xB6C5	0x50B5	# <CJK>
0xB6C6	0x50B2	# <CJK>
0xB6C7	0x50B3	# <CJK>
0xB6C8	0x50C5	# <CJK>
0xB6C9	0x50BE	# <CJK>
0xB6CA	0x50AC	# <CJK>
0xB6CB	0x50B7	# <CJK>
0xB6CC	0x50BB	# <CJK>
0xB6CD	0x50AF	# <CJK>
0xB6CE	0x50C7	# <CJK>
0xB6CF	0x527F	# <CJK>
0xB6D0	0x5277	# <CJK>
0xB6D1	0x527D	# <CJK>
0xB6D2	0x52DF	# <CJK>
0xB6D3	0x52E6	# <CJK>
0xB6D4	0x52E4	# <CJK>
0xB6D5	0x52E2	# <CJK>
0xB6D6	0x52E3	# <CJK>
0xB6D7	0x532F	# <CJK>
0xB6D8	0x55DF	# <CJK>
0xB6D9	0x55E8	# <CJK>
0xB6DA	0x55D3	# <CJK>
0xB6DB	0x55E6	# <CJK>
0xB6DC	0x55CE	# <CJK>
0xB6DD	0x55DC	# <CJK>
0xB6DE	0x55C7	# <CJK>
0xB6DF	0x55D1	# <CJK>
0xB6E0	0x55E3	# <CJK>
0xB6E1	0x55E4	# <CJK>
0xB6E2	0x55EF	# <CJK>
0xB6E3	0x55DA	# <CJK>
0xB6E4	0x55E1	# <CJK>
0xB6E5	0x55C5	# <CJK>
0xB6E6	0x55C6	# <CJK>
0xB6E7	0x55E5	# <CJK>
0xB6E8	0x55C9	# <CJK>
0xB6E9	0x5712	# <CJK>
0xB6EA	0x5713	# <CJK>
0xB6EB	0x585E	# <CJK>
0xB6EC	0x5851	# <CJK>
0xB6ED	0x5858	# <CJK>
0xB6EE	0x5857	# <CJK>
0xB6EF	0x585A	# <CJK>
0xB6F0	0x5854	# <CJK>
0xB6F1	0x586B	# <CJK>
0xB6F2	0x584C	# <CJK>
0xB6F3	0x586D	# <CJK>
0xB6F4	0x584A	# <CJK>
0xB6F5	0x5862	# <CJK>
0xB6F6	0x5852	# <CJK>
0xB6F7	0x584B	# <CJK>
0xB6F8	0x5967	# <CJK>
0xB6F9	0x5AC1	# <CJK>
0xB6FA	0x5AC9	# <CJK>
0xB6FB	0x5ACC	# <CJK>
0xB6FC	0x5ABE	# <CJK>
0xB6FD	0x5ABD	# <CJK>
0xB6FE	0x5ABC	# <CJK>
0xB740	0x5AB3	# <CJK>
0xB741	0x5AC2	# <CJK>
0xB742	0x5AB2	# <CJK>
0xB743	0x5D69	# <CJK>
0xB744	0x5D6F	# <CJK>
0xB745	0x5E4C	# <CJK>
0xB746	0x5E79	# <CJK>
0xB747	0x5EC9	# <CJK>
0xB748	0x5EC8	# <CJK>
0xB749	0x5F12	# <CJK>
0xB74A	0x5F59	# <CJK>
0xB74B	0x5FAC	# <CJK>
0xB74C	0x5FAE	# <CJK>
0xB74D	0x611A	# <CJK>
0xB74E	0x610F	# <CJK>
0xB74F	0x6148	# <CJK>
0xB750	0x611F	# <CJK>
0xB751	0x60F3	# <CJK>
0xB752	0x611B	# <CJK>
0xB753	0x60F9	# <CJK>
0xB754	0x6101	# <CJK>
0xB755	0x6108	# <CJK>
0xB756	0x614E	# <CJK>
0xB757	0x614C	# <CJK>
0xB758	0x6144	# <CJK>
0xB759	0x614D	# <CJK>
0xB75A	0x613E	# <CJK>
0xB75B	0x6134	# <CJK>
0xB75C	0x6127	# <CJK>
0xB75D	0x610D	# <CJK>
0xB75E	0x6106	# <CJK>
0xB75F	0x6137	# <CJK>
0xB760	0x6221	# <CJK>
0xB761	0x6222	# <CJK>
0xB762	0x6413	# <CJK>
0xB763	0x643E	# <CJK>
0xB764	0x641E	# <CJK>
0xB765	0x642A	# <CJK>
0xB766	0x642D	# <CJK>
0xB767	0x643D	# <CJK>
0xB768	0x642C	# <CJK>
0xB769	0x640F	# <CJK>
0xB76A	0x641C	# <CJK>
0xB76B	0x6414	# <CJK>
0xB76C	0x640D	# <CJK>
0xB76D	0x6436	# <CJK>
0xB76E	0x6416	# <CJK>
0xB76F	0x6417	# <CJK>
0xB770	0x6406	# <CJK>
0xB771	0x656C	# <CJK>
0xB772	0x659F	# <CJK>
0xB773	0x65B0	# <CJK>
0xB774	0x6697	# <CJK>
0xB775	0x6689	# <CJK>
0xB776	0x6687	# <CJK>
0xB777	0x6688	# <CJK>
0xB778	0x6696	# <CJK>
0xB779	0x6684	# <CJK>
0xB77A	0x6698	# <CJK>
0xB77B	0x668D	# <CJK>
0xB77C	0x6703	# <CJK>
0xB77D	0x6994	# <CJK>
0xB77E	0x696D	# <CJK>
0xB7A1	0x695A	# <CJK>
0xB7A2	0x6977	# <CJK>
0xB7A3	0x6960	# <CJK>
0xB7A4	0x6954	# <CJK>
0xB7A5	0x6975	# <CJK>
0xB7A6	0x6930	# <CJK>
0xB7A7	0x6982	# <CJK>
0xB7A8	0x694A	# <CJK>
0xB7A9	0x6968	# <CJK>
0xB7AA	0x696B	# <CJK>
0xB7AB	0x695E	# <CJK>
0xB7AC	0x6953	# <CJK>
0xB7AD	0x6979	# <CJK>
0xB7AE	0x6986	# <CJK>
0xB7AF	0x695D	# <CJK>
0xB7B0	0x6963	# <CJK>
0xB7B1	0x695B	# <CJK>
0xB7B2	0x6B47	# <CJK>
0xB7B3	0x6B72	# <CJK>
0xB7B4	0x6BC0	# <CJK>
0xB7B5	0x6BBF	# <CJK>
0xB7B6	0x6BD3	# <CJK>
0xB7B7	0x6BFD	# <CJK>
0xB7B8	0x6EA2	# <CJK>
0xB7B9	0x6EAF	# <CJK>
0xB7BA	0x6ED3	# <CJK>
0xB7BB	0x6EB6	# <CJK>
0xB7BC	0x6EC2	# <CJK>
0xB7BD	0x6E90	# <CJK>
0xB7BE	0x6E9D	# <CJK>
0xB7BF	0x6EC7	# <CJK>
0xB7C0	0x6EC5	# <CJK>
0xB7C1	0x6EA5	# <CJK>
0xB7C2	0x6E98	# <CJK>
0xB7C3	0x6EBC	# <CJK>
0xB7C4	0x6EBA	# <CJK>
0xB7C5	0x6EAB	# <CJK>
0xB7C6	0x6ED1	# <CJK>
0xB7C7	0x6E96	# <CJK>
0xB7C8	0x6E9C	# <CJK>
0xB7C9	0x6EC4	# <CJK>
0xB7CA	0x6ED4	# <CJK>
0xB7CB	0x6EAA	# <CJK>
0xB7CC	0x6EA7	# <CJK>
0xB7CD	0x6EB4	# <CJK>
0xB7CE	0x714E	# <CJK>
0xB7CF	0x7159	# <CJK>
0xB7D0	0x7169	# <CJK>
0xB7D1	0x7164	# <CJK>
0xB7D2	0x7149	# <CJK>
0xB7D3	0x7167	# <CJK>
0xB7D4	0x715C	# <CJK>
0xB7D5	0x716C	# <CJK>
0xB7D6	0x7166	# <CJK>
0xB7D7	0x714C	# <CJK>
0xB7D8	0x7165	# <CJK>
0xB7D9	0x715E	# <CJK>
0xB7DA	0x7146	# <CJK>
0xB7DB	0x7168	# <CJK>
0xB7DC	0x7156	# <CJK>
0xB7DD	0x723A	# <CJK>
0xB7DE	0x7252	# <CJK>
0xB7DF	0x7337	# <CJK>
0xB7E0	0x7345	# <CJK>
0xB7E1	0x733F	# <CJK>
0xB7E2	0x733E	# <CJK>
0xB7E3	0x746F	# <CJK>
0xB7E4	0x745A	# <CJK>
0xB7E5	0x7455	# <CJK>
0xB7E6	0x745F	# <CJK>
0xB7E7	0x745E	# <CJK>
0xB7E8	0x7441	# <CJK>
0xB7E9	0x743F	# <CJK>
0xB7EA	0x7459	# <CJK>
0xB7EB	0x745B	# <CJK>
0xB7EC	0x745C	# <CJK>
0xB7ED	0x7576	# <CJK>
0xB7EE	0x7578	# <CJK>
0xB7EF	0x7600	# <CJK>
0xB7F0	0x75F0	# <CJK>
0xB7F1	0x7601	# <CJK>
0xB7F2	0x75F2	# <CJK>
0xB7F3	0x75F1	# <CJK>
0xB7F4	0x75FA	# <CJK>
0xB7F5	0x75FF	# <CJK>
0xB7F6	0x75F4	# <CJK>
0xB7F7	0x75F3	# <CJK>
0xB7F8	0x76DE	# <CJK>
0xB7F9	0x76DF	# <CJK>
0xB7FA	0x775B	# <CJK>
0xB7FB	0x776B	# <CJK>
0xB7FC	0x7766	# <CJK>
0xB7FD	0x775E	# <CJK>
0xB7FE	0x7763	# <CJK>
0xB840	0x7779	# <CJK>
0xB841	0x776A	# <CJK>
0xB842	0x776C	# <CJK>
0xB843	0x775C	# <CJK>
0xB844	0x7765	# <CJK>
0xB845	0x7768	# <CJK>
0xB846	0x7762	# <CJK>
0xB847	0x77EE	# <CJK>
0xB848	0x788E	# <CJK>
0xB849	0x78B0	# <CJK>
0xB84A	0x7897	# <CJK>
0xB84B	0x7898	# <CJK>
0xB84C	0x788C	# <CJK>
0xB84D	0x7889	# <CJK>
0xB84E	0x787C	# <CJK>
0xB84F	0x7891	# <CJK>
0xB850	0x7893	# <CJK>
0xB851	0x787F	# <CJK>
0xB852	0x797A	# <CJK>
0xB853	0x797F	# <CJK>
0xB854	0x7981	# <CJK>
0xB855	0x842C	# <CJK>
0xB856	0x79BD	# <CJK>
0xB857	0x7A1C	# <CJK>
0xB858	0x7A1A	# <CJK>
0xB859	0x7A20	# <CJK>
0xB85A	0x7A14	# <CJK>
0xB85B	0x7A1F	# <CJK>
0xB85C	0x7A1E	# <CJK>
0xB85D	0x7A9F	# <CJK>
0xB85E	0x7AA0	# <CJK>
0xB85F	0x7B77	# <CJK>
0xB860	0x7BC0	# <CJK>
0xB861	0x7B60	# <CJK>
0xB862	0x7B6E	# <CJK>
0xB863	0x7B67	# <CJK>
0xB864	0x7CB1	# <CJK>
0xB865	0x7CB3	# <CJK>
0xB866	0x7CB5	# <CJK>
0xB867	0x7D93	# <CJK>
0xB868	0x7D79	# <CJK>
0xB869	0x7D91	# <CJK>
0xB86A	0x7D81	# <CJK>
0xB86B	0x7D8F	# <CJK>
0xB86C	0x7D5B	# <CJK>
0xB86D	0x7F6E	# <CJK>
0xB86E	0x7F69	# <CJK>
0xB86F	0x7F6A	# <CJK>
0xB870	0x7F72	# <CJK>
0xB871	0x7FA9	# <CJK>
0xB872	0x7FA8	# <CJK>
0xB873	0x7FA4	# <CJK>
0xB874	0x8056	# <CJK>
0xB875	0x8058	# <CJK>
0xB876	0x8086	# <CJK>
0xB877	0x8084	# <CJK>
0xB878	0x8171	# <CJK>
0xB879	0x8170	# <CJK>
0xB87A	0x8178	# <CJK>
0xB87B	0x8165	# <CJK>
0xB87C	0x816E	# <CJK>
0xB87D	0x8173	# <CJK>
0xB87E	0x816B	# <CJK>
0xB8A1	0x8179	# <CJK>
0xB8A2	0x817A	# <CJK>
0xB8A3	0x8166	# <CJK>
0xB8A4	0x8205	# <CJK>
0xB8A5	0x8247	# <CJK>
0xB8A6	0x8482	# <CJK>
0xB8A7	0x8477	# <CJK>
0xB8A8	0x843D	# <CJK>
0xB8A9	0x8431	# <CJK>
0xB8AA	0x8475	# <CJK>
0xB8AB	0x8466	# <CJK>
0xB8AC	0x846B	# <CJK>
0xB8AD	0x8449	# <CJK>
0xB8AE	0x846C	# <CJK>
0xB8AF	0x845B	# <CJK>
0xB8B0	0x843C	# <CJK>
0xB8B1	0x8435	# <CJK>
0xB8B2	0x8461	# <CJK>
0xB8B3	0x8463	# <CJK>
0xB8B4	0x8469	# <CJK>
0xB8B5	0x846D	# <CJK>
0xB8B6	0x8446	# <CJK>
0xB8B7	0x865E	# <CJK>
0xB8B8	0x865C	# <CJK>
0xB8B9	0x865F	# <CJK>
0xB8BA	0x86F9	# <CJK>
0xB8BB	0x8713	# <CJK>
0xB8BC	0x8708	# <CJK>
0xB8BD	0x8707	# <CJK>
0xB8BE	0x8700	# <CJK>
0xB8BF	0x86FE	# <CJK>
0xB8C0	0x86FB	# <CJK>
0xB8C1	0x8702	# <CJK>
0xB8C2	0x8703	# <CJK>
0xB8C3	0x8706	# <CJK>
0xB8C4	0x870A	# <CJK>
0xB8C5	0x8859	# <CJK>
0xB8C6	0x88DF	# <CJK>
0xB8C7	0x88D4	# <CJK>
0xB8C8	0x88D9	# <CJK>
0xB8C9	0x88DC	# <CJK>
0xB8CA	0x88D8	# <CJK>
0xB8CB	0x88DD	# <CJK>
0xB8CC	0x88E1	# <CJK>
0xB8CD	0x88CA	# <CJK>
0xB8CE	0x88D5	# <CJK>
0xB8CF	0x88D2	# <CJK>
0xB8D0	0x899C	# <CJK>
0xB8D1	0x89E3	# <CJK>
0xB8D2	0x8A6B	# <CJK>
0xB8D3	0x8A72	# <CJK>
0xB8D4	0x8A73	# <CJK>
0xB8D5	0x8A66	# <CJK>
0xB8D6	0x8A69	# <CJK>
0xB8D7	0x8A70	# <CJK>
0xB8D8	0x8A87	# <CJK>
0xB8D9	0x8A7C	# <CJK>
0xB8DA	0x8A63	# <CJK>
0xB8DB	0x8AA0	# <CJK>
0xB8DC	0x8A71	# <CJK>
0xB8DD	0x8A85	# <CJK>
0xB8DE	0x8A6D	# <CJK>
0xB8DF	0x8A62	# <CJK>
0xB8E0	0x8A6E	# <CJK>
0xB8E1	0x8A6C	# <CJK>
0xB8E2	0x8A79	# <CJK>
0xB8E3	0x8A7B	# <CJK>
0xB8E4	0x8A3E	# <CJK>
0xB8E5	0x8A68	# <CJK>
0xB8E6	0x8C62	# <CJK>
0xB8E7	0x8C8A	# <CJK>
0xB8E8	0x8C89	# <CJK>
0xB8E9	0x8CCA	# <CJK>
0xB8EA	0x8CC7	# <CJK>
0xB8EB	0x8CC8	# <CJK>
0xB8EC	0x8CC4	# <CJK>
0xB8ED	0x8CB2	# <CJK>
0xB8EE	0x8CC3	# <CJK>
0xB8EF	0x8CC2	# <CJK>
0xB8F0	0x8CC5	# <CJK>
0xB8F1	0x8DE1	# <CJK>
0xB8F2	0x8DDF	# <CJK>
0xB8F3	0x8DE8	# <CJK>
0xB8F4	0x8DEF	# <CJK>
0xB8F5	0x8DF3	# <CJK>
0xB8F6	0x8DFA	# <CJK>
0xB8F7	0x8DEA	# <CJK>
0xB8F8	0x8DE4	# <CJK>
0xB8F9	0x8DE6	# <CJK>
0xB8FA	0x8EB2	# <CJK>
0xB8FB	0x8F03	# <CJK>
0xB8FC	0x8F09	# <CJK>
0xB8FD	0x8EFE	# <CJK>
0xB8FE	0x8F0A	# <CJK>
0xB940	0x8F9F	# <CJK>
0xB941	0x8FB2	# <CJK>
0xB942	0x904B	# <CJK>
0xB943	0x904A	# <CJK>
0xB944	0x9053	# <CJK>
0xB945	0x9042	# <CJK>
0xB946	0x9054	# <CJK>
0xB947	0x903C	# <CJK>
0xB948	0x9055	# <CJK>
0xB949	0x9050	# <CJK>
0xB94A	0x9047	# <CJK>
0xB94B	0x904F	# <CJK>
0xB94C	0x904E	# <CJK>
0xB94D	0x904D	# <CJK>
0xB94E	0x9051	# <CJK>
0xB94F	0x903E	# <CJK>
0xB950	0x9041	# <CJK>
0xB951	0x9112	# <CJK>
0xB952	0x9117	# <CJK>
0xB953	0x916C	# <CJK>
0xB954	0x916A	# <CJK>
0xB955	0x9169	# <CJK>
0xB956	0x91C9	# <CJK>
0xB957	0x9237	# <CJK>
0xB958	0x9257	# <CJK>
0xB959	0x9238	# <CJK>
0xB95A	0x923D	# <CJK>
0xB95B	0x9240	# <CJK>
0xB95C	0x923E	# <CJK>
0xB95D	0x925B	# <CJK>
0xB95E	0x924B	# <CJK>
0xB95F	0x9264	# <CJK>
0xB960	0x9251	# <CJK>
0xB961	0x9234	# <CJK>
0xB962	0x9249	# <CJK>
0xB963	0x924D	# <CJK>
0xB964	0x9245	# <CJK>
0xB965	0x9239	# <CJK>
0xB966	0x923F	# <CJK>
0xB967	0x925A	# <CJK>
0xB968	0x9598	# <CJK>
0xB969	0x9698	# <CJK>
0xB96A	0x9694	# <CJK>
0xB96B	0x9695	# <CJK>
0xB96C	0x96CD	# <CJK>
0xB96D	0x96CB	# <CJK>
0xB96E	0x96C9	# <CJK>
0xB96F	0x96CA	# <CJK>
0xB970	0x96F7	# <CJK>
0xB971	0x96FB	# <CJK>
0xB972	0x96F9	# <CJK>
0xB973	0x96F6	# <CJK>
0xB974	0x9756	# <CJK>
0xB975	0x9774	# <CJK>
0xB976	0x9776	# <CJK>
0xB977	0x9810	# <CJK>
0xB978	0x9811	# <CJK>
0xB979	0x9813	# <CJK>
0xB97A	0x980A	# <CJK>
0xB97B	0x9812	# <CJK>
0xB97C	0x980C	# <CJK>
0xB97D	0x98FC	# <CJK>
0xB97E	0x98F4	# <CJK>
0xB9A1	0x98FD	# <CJK>
0xB9A2	0x98FE	# <CJK>
0xB9A3	0x99B3	# <CJK>
0xB9A4	0x99B1	# <CJK>
0xB9A5	0x99B4	# <CJK>
0xB9A6	0x9AE1	# <CJK>
0xB9A7	0x9CE9	# <CJK>
0xB9A8	0x9E82	# <CJK>
0xB9A9	0x9F0E	# <CJK>
0xB9AA	0x9F13	# <CJK>
0xB9AB	0x9F20	# <CJK>
0xB9AC	0x50E7	# <CJK>
0xB9AD	0x50EE	# <CJK>
0xB9AE	0x50E5	# <CJK>
0xB9AF	0x50D6	# <CJK>
0xB9B0	0x50ED	# <CJK>
0xB9B1	0x50DA	# <CJK>
0xB9B2	0x50D5	# <CJK>
0xB9B3	0x50CF	# <CJK>
0xB9B4	0x50D1	# <CJK>
0xB9B5	0x50F1	# <CJK>
0xB9B6	0x50CE	# <CJK>
0xB9B7	0x50E9	# <CJK>
0xB9B8	0x5162	# <CJK>
0xB9B9	0x51F3	# <CJK>
0xB9BA	0x5283	# <CJK>
0xB9BB	0x5282	# <CJK>
0xB9BC	0x5331	# <CJK>
0xB9BD	0x53AD	# <CJK>
0xB9BE	0x55FE	# <CJK>
0xB9BF	0x5600	# <CJK>
0xB9C0	0x561B	# <CJK>
0xB9C1	0x5617	# <CJK>
0xB9C2	0x55FD	# <CJK>
0xB9C3	0x5614	# <CJK>
0xB9C4	0x5606	# <CJK>
0xB9C5	0x5609	# <CJK>
0xB9C6	0x560D	# <CJK>
0xB9C7	0x560E	# <CJK>
0xB9C8	0x55F7	# <CJK>
0xB9C9	0x5616	# <CJK>
0xB9CA	0x561F	# <CJK>
0xB9CB	0x5608	# <CJK>
0xB9CC	0x5610	# <CJK>
0xB9CD	0x55F6	# <CJK>
0xB9CE	0x5718	# <CJK>
0xB9CF	0x5716	# <CJK>
0xB9D0	0x5875	# <CJK>
0xB9D1	0x587E	# <CJK>
0xB9D2	0x5883	# <CJK>
0xB9D3	0x5893	# <CJK>
0xB9D4	0x588A	# <CJK>
0xB9D5	0x5879	# <CJK>
0xB9D6	0x5885	# <CJK>
0xB9D7	0x587D	# <CJK>
0xB9D8	0x58FD	# <CJK>
0xB9D9	0x5925	# <CJK>
0xB9DA	0x5922	# <CJK>
0xB9DB	0x5924	# <CJK>
0xB9DC	0x596A	# <CJK>
0xB9DD	0x5969	# <CJK>
0xB9DE	0x5AE1	# <CJK>
0xB9DF	0x5AE6	# <CJK>
0xB9E0	0x5AE9	# <CJK>
0xB9E1	0x5AD7	# <CJK>
0xB9E2	0x5AD6	# <CJK>
0xB9E3	0x5AD8	# <CJK>
0xB9E4	0x5AE3	# <CJK>
0xB9E5	0x5B75	# <CJK>
0xB9E6	0x5BDE	# <CJK>
0xB9E7	0x5BE7	# <CJK>
0xB9E8	0x5BE1	# <CJK>
0xB9E9	0x5BE5	# <CJK>
0xB9EA	0x5BE6	# <CJK>
0xB9EB	0x5BE8	# <CJK>
0xB9EC	0x5BE2	# <CJK>
0xB9ED	0x5BE4	# <CJK>
0xB9EE	0x5BDF	# <CJK>
0xB9EF	0x5C0D	# <CJK>
0xB9F0	0x5C62	# <CJK>
0xB9F1	0x5D84	# <CJK>
0xB9F2	0x5D87	# <CJK>
0xB9F3	0x5E5B	# <CJK>
0xB9F4	0x5E63	# <CJK>
0xB9F5	0x5E55	# <CJK>
0xB9F6	0x5E57	# <CJK>
0xB9F7	0x5E54	# <CJK>
0xB9F8	0x5ED3	# <CJK>
0xB9F9	0x5ED6	# <CJK>
0xB9FA	0x5F0A	# <CJK>
0xB9FB	0x5F46	# <CJK>
0xB9FC	0x5F70	# <CJK>
0xB9FD	0x5FB9	# <CJK>
0xB9FE	0x6147	# <CJK>
0xBA40	0x613F	# <CJK>
0xBA41	0x614B	# <CJK>
0xBA42	0x6177	# <CJK>
0xBA43	0x6162	# <CJK>
0xBA44	0x6163	# <CJK>
0xBA45	0x615F	# <CJK>
0xBA46	0x615A	# <CJK>
0xBA47	0x6158	# <CJK>
0xBA48	0x6175	# <CJK>
0xBA49	0x622A	# <CJK>
0xBA4A	0x6487	# <CJK>
0xBA4B	0x6458	# <CJK>
0xBA4C	0x6454	# <CJK>
0xBA4D	0x64A4	# <CJK>
0xBA4E	0x6478	# <CJK>
0xBA4F	0x645F	# <CJK>
0xBA50	0x647A	# <CJK>
0xBA51	0x6451	# <CJK>
0xBA52	0x6467	# <CJK>
0xBA53	0x6434	# <CJK>
0xBA54	0x646D	# <CJK>
0xBA55	0x647B	# <CJK>
0xBA56	0x6572	# <CJK>
0xBA57	0x65A1	# <CJK>
0xBA58	0x65D7	# <CJK>
0xBA59	0x65D6	# <CJK>
0xBA5A	0x66A2	# <CJK>
0xBA5B	0x66A8	# <CJK>
0xBA5C	0x669D	# <CJK>
0xBA5D	0x699C	# <CJK>
0xBA5E	0x69A8	# <CJK>
0xBA5F	0x6995	# <CJK>
0xBA60	0x69C1	# <CJK>
0xBA61	0x69AE	# <CJK>
0xBA62	0x69D3	# <CJK>
0xBA63	0x69CB	# <CJK>
0xBA64	0x699B	# <CJK>
0xBA65	0x69B7	# <CJK>
0xBA66	0x69BB	# <CJK>
0xBA67	0x69AB	# <CJK>
0xBA68	0x69B4	# <CJK>
0xBA69	0x69D0	# <CJK>
0xBA6A	0x69CD	# <CJK>
0xBA6B	0x69AD	# <CJK>
0xBA6C	0x69CC	# <CJK>
0xBA6D	0x69A6	# <CJK>
0xBA6E	0x69C3	# <CJK>
0xBA6F	0x69A3	# <CJK>
0xBA70	0x6B49	# <CJK>
0xBA71	0x6B4C	# <CJK>
0xBA72	0x6C33	# <CJK>
0xBA73	0x6F33	# <CJK>
0xBA74	0x6F14	# <CJK>
0xBA75	0x6EFE	# <CJK>
0xBA76	0x6F13	# <CJK>
0xBA77	0x6EF4	# <CJK>
0xBA78	0x6F29	# <CJK>
0xBA79	0x6F3E	# <CJK>
0xBA7A	0x6F20	# <CJK>
0xBA7B	0x6F2C	# <CJK>
0xBA7C	0x6F0F	# <CJK>
0xBA7D	0x6F02	# <CJK>
0xBA7E	0x6F22	# <CJK>
0xBAA1	0x6EFF	# <CJK>
0xBAA2	0x6EEF	# <CJK>
0xBAA3	0x6F06	# <CJK>
0xBAA4	0x6F31	# <CJK>
0xBAA5	0x6F38	# <CJK>
0xBAA6	0x6F32	# <CJK>
0xBAA7	0x6F23	# <CJK>
0xBAA8	0x6F15	# <CJK>
0xBAA9	0x6F2B	# <CJK>
0xBAAA	0x6F2F	# <CJK>
0xBAAB	0x6F88	# <CJK>
0xBAAC	0x6F2A	# <CJK>
0xBAAD	0x6EEC	# <CJK>
0xBAAE	0x6F01	# <CJK>
0xBAAF	0x6EF2	# <CJK>
0xBAB0	0x6ECC	# <CJK>
0xBAB1	0x6EF7	# <CJK>
0xBAB2	0x7194	# <CJK>
0xBAB3	0x7199	# <CJK>
0xBAB4	0x717D	# <CJK>
0xBAB5	0x718A	# <CJK>
0xBAB6	0x7184	# <CJK>
0xBAB7	0x7192	# <CJK>
0xBAB8	0x723E	# <CJK>
0xBAB9	0x7292	# <CJK>
0xBABA	0x7296	# <CJK>
0xBABB	0x7344	# <CJK>
0xBABC	0x7350	# <CJK>
0xBABD	0x7464	# <CJK>
0xBABE	0x7463	# <CJK>
0xBABF	0x746A	# <CJK>
0xBAC0	0x7470	# <CJK>
0xBAC1	0x746D	# <CJK>
0xBAC2	0x7504	# <CJK>
0xBAC3	0x7591	# <CJK>
0xBAC4	0x7627	# <CJK>
0xBAC5	0x760D	# <CJK>
0xBAC6	0x760B	# <CJK>
0xBAC7	0x7609	# <CJK>
0xBAC8	0x7613	# <CJK>
0xBAC9	0x76E1	# <CJK>
0xBACA	0x76E3	# <CJK>
0xBACB	0x7784	# <CJK>
0xBACC	0x777D	# <CJK>
0xBACD	0x777F	# <CJK>
0xBACE	0x7761	# <CJK>
0xBACF	0x78C1	# <CJK>
0xBAD0	0x789F	# <CJK>
0xBAD1	0x78A7	# <CJK>
0xBAD2	0x78B3	# <CJK>
0xBAD3	0x78A9	# <CJK>
0xBAD4	0x78A3	# <CJK>
0xBAD5	0x798E	# <CJK>
0xBAD6	0x798F	# <CJK>
0xBAD7	0x798D	# <CJK>
0xBAD8	0x7A2E	# <CJK>
0xBAD9	0x7A31	# <CJK>
0xBADA	0x7AAA	# <CJK>
0xBADB	0x7AA9	# <CJK>
0xBADC	0x7AED	# <CJK>
0xBADD	0x7AEF	# <CJK>
0xBADE	0x7BA1	# <CJK>
0xBADF	0x7B95	# <CJK>
0xBAE0	0x7B8B	# <CJK>
0xBAE1	0x7B75	# <CJK>
0xBAE2	0x7B97	# <CJK>
0xBAE3	0x7B9D	# <CJK>
0xBAE4	0x7B94	# <CJK>
0xBAE5	0x7B8F	# <CJK>
0xBAE6	0x7BB8	# <CJK>
0xBAE7	0x7B87	# <CJK>
0xBAE8	0x7B84	# <CJK>
0xBAE9	0x7CB9	# <CJK>
0xBAEA	0x7CBD	# <CJK>
0xBAEB	0x7CBE	# <CJK>
0xBAEC	0x7DBB	# <CJK>
0xBAED	0x7DB0	# <CJK>
0xBAEE	0x7D9C	# <CJK>
0xBAEF	0x7DBD	# <CJK>
0xBAF0	0x7DBE	# <CJK>
0xBAF1	0x7DA0	# <CJK>
0xBAF2	0x7DCA	# <CJK>
0xBAF3	0x7DB4	# <CJK>
0xBAF4	0x7DB2	# <CJK>
0xBAF5	0x7DB1	# <CJK>
0xBAF6	0x7DBA	# <CJK>
0xBAF7	0x7DA2	# <CJK>
0xBAF8	0x7DBF	# <CJK>
0xBAF9	0x7DB5	# <CJK>
0xBAFA	0x7DB8	# <CJK>
0xBAFB	0x7DAD	# <CJK>
0xBAFC	0x7DD2	# <CJK>
0xBAFD	0x7DC7	# <CJK>
0xBAFE	0x7DAC	# <CJK>
0xBB40	0x7F70	# <CJK>
0xBB41	0x7FE0	# <CJK>
0xBB42	0x7FE1	# <CJK>
0xBB43	0x7FDF	# <CJK>
0xBB44	0x805E	# <CJK>
0xBB45	0x805A	# <CJK>
0xBB46	0x8087	# <CJK>
0xBB47	0x8150	# <CJK>
0xBB48	0x8180	# <CJK>
0xBB49	0x818F	# <CJK>
0xBB4A	0x8188	# <CJK>
0xBB4B	0x818A	# <CJK>
0xBB4C	0x817F	# <CJK>
0xBB4D	0x8182	# <CJK>
0xBB4E	0x81E7	# <CJK>
0xBB4F	0x81FA	# <CJK>
0xBB50	0x8207	# <CJK>
0xBB51	0x8214	# <CJK>
0xBB52	0x821E	# <CJK>
0xBB53	0x824B	# <CJK>
0xBB54	0x84C9	# <CJK>
0xBB55	0x84BF	# <CJK>
0xBB56	0x84C6	# <CJK>
0xBB57	0x84C4	# <CJK>
0xBB58	0x8499	# <CJK>
0xBB59	0x849E	# <CJK>
0xBB5A	0x84B2	# <CJK>
0xBB5B	0x849C	# <CJK>
0xBB5C	0x84CB	# <CJK>
0xBB5D	0x84B8	# <CJK>
0xBB5E	0x84C0	# <CJK>
0xBB5F	0x84D3	# <CJK>
0xBB60	0x8490	# <CJK>
0xBB61	0x84BC	# <CJK>
0xBB62	0x84D1	# <CJK>
0xBB63	0x84CA	# <CJK>
0xBB64	0x873F	# <CJK>
0xBB65	0x871C	# <CJK>
0xBB66	0x873B	# <CJK>
0xBB67	0x8722	# <CJK>
0xBB68	0x8725	# <CJK>
0xBB69	0x8734	# <CJK>
0xBB6A	0x8718	# <CJK>
0xBB6B	0x8755	# <CJK>
0xBB6C	0x8737	# <CJK>
0xBB6D	0x8729	# <CJK>
0xBB6E	0x88F3	# <CJK>
0xBB6F	0x8902	# <CJK>
0xBB70	0x88F4	# <CJK>
0xBB71	0x88F9	# <CJK>
0xBB72	0x88F8	# <CJK>
0xBB73	0x88FD	# <CJK>
0xBB74	0x88E8	# <CJK>
0xBB75	0x891A	# <CJK>
0xBB76	0x88EF	# <CJK>
0xBB77	0x8AA6	# <CJK>
0xBB78	0x8A8C	# <CJK>
0xBB79	0x8A9E	# <CJK>
0xBB7A	0x8AA3	# <CJK>
0xBB7B	0x8A8D	# <CJK>
0xBB7C	0x8AA1	# <CJK>
0xBB7D	0x8A93	# <CJK>
0xBB7E	0x8AA4	# <CJK>
0xBBA1	0x8AAA	# <CJK>
0xBBA2	0x8AA5	# <CJK>
0xBBA3	0x8AA8	# <CJK>
0xBBA4	0x8A98	# <CJK>
0xBBA5	0x8A91	# <CJK>
0xBBA6	0x8A9A	# <CJK>
0xBBA7	0x8AA7	# <CJK>
0xBBA8	0x8C6A	# <CJK>
0xBBA9	0x8C8D	# <CJK>
0xBBAA	0x8C8C	# <CJK>
0xBBAB	0x8CD3	# <CJK>
0xBBAC	0x8CD1	# <CJK>
0xBBAD	0x8CD2	# <CJK>
0xBBAE	0x8D6B	# <CJK>
0xBBAF	0x8D99	# <CJK>
0xBBB0	0x8D95	# <CJK>
0xBBB1	0x8DFC	# <CJK>
0xBBB2	0x8F14	# <CJK>
0xBBB3	0x8F12	# <CJK>
0xBBB4	0x8F15	# <CJK>
0xBBB5	0x8F13	# <CJK>
0xBBB6	0x8FA3	# <CJK>
0xBBB7	0x9060	# <CJK>
0xBBB8	0x9058	# <CJK>
0xBBB9	0x905C	# <CJK>
0xBBBA	0x9063	# <CJK>
0xBBBB	0x9059	# <CJK>
0xBBBC	0x905E	# <CJK>
0xBBBD	0x9062	# <CJK>
0xBBBE	0x905D	# <CJK>
0xBBBF	0x905B	# <CJK>
0xBBC0	0x9119	# <CJK>
0xBBC1	0x9118	# <CJK>
0xBBC2	0x911E	# <CJK>
0xBBC3	0x9175	# <CJK>
0xBBC4	0x9178	# <CJK>
0xBBC5	0x9177	# <CJK>
0xBBC6	0x9174	# <CJK>
0xBBC7	0x9278	# <CJK>
0xBBC8	0x9280	# <CJK>
0xBBC9	0x9285	# <CJK>
0xBBCA	0x9298	# <CJK>
0xBBCB	0x9296	# <CJK>
0xBBCC	0x927B	# <CJK>
0xBBCD	0x9293	# <CJK>
0xBBCE	0x929C	# <CJK>
0xBBCF	0x92A8	# <CJK>
0xBBD0	0x927C	# <CJK>
0xBBD1	0x9291	# <CJK>
0xBBD2	0x95A1	# <CJK>
0xBBD3	0x95A8	# <CJK>
0xBBD4	0x95A9	# <CJK>
0xBBD5	0x95A3	# <CJK>
0xBBD6	0x95A5	# <CJK>
0xBBD7	0x95A4	# <CJK>
0xBBD8	0x9699	# <CJK>
0xBBD9	0x969C	# <CJK>
0xBBDA	0x969B	# <CJK>
0xBBDB	0x96CC	# <CJK>
0xBBDC	0x96D2	# <CJK>
0xBBDD	0x9700	# <CJK>
0xBBDE	0x977C	# <CJK>
0xBBDF	0x9785	# <CJK>
0xBBE0	0x97F6	# <CJK>
0xBBE1	0x9817	# <CJK>
0xBBE2	0x9818	# <CJK>
0xBBE3	0x98AF	# <CJK>
0xBBE4	0x98B1	# <CJK>
0xBBE5	0x9903	# <CJK>
0xBBE6	0x9905	# <CJK>
0xBBE7	0x990C	# <CJK>
0xBBE8	0x9909	# <CJK>
0xBBE9	0x99C1	# <CJK>
0xBBEA	0x9AAF	# <CJK>
0xBBEB	0x9AB0	# <CJK>
0xBBEC	0x9AE6	# <CJK>
0xBBED	0x9B41	# <CJK>
0xBBEE	0x9B42	# <CJK>
0xBBEF	0x9CF4	# <CJK>
0xBBF0	0x9CF6	# <CJK>
0xBBF1	0x9CF3	# <CJK>
0xBBF2	0x9EBC	# <CJK>
0xBBF3	0x9F3B	# <CJK>
0xBBF4	0x9F4A	# <CJK>
0xBBF5	0x5104	# <CJK>
0xBBF6	0x5100	# <CJK>
0xBBF7	0x50FB	# <CJK>
0xBBF8	0x50F5	# <CJK>
0xBBF9	0x50F9	# <CJK>
0xBBFA	0x5102	# <CJK>
0xBBFB	0x5108	# <CJK>
0xBBFC	0x5109	# <CJK>
0xBBFD	0x5105	# <CJK>
0xBBFE	0x51DC	# <CJK>
0xBC40	0x5287	# <CJK>
0xBC41	0x5288	# <CJK>
0xBC42	0x5289	# <CJK>
0xBC43	0x528D	# <CJK>
0xBC44	0x528A	# <CJK>
0xBC45	0x52F0	# <CJK>
0xBC46	0x53B2	# <CJK>
0xBC47	0x562E	# <CJK>
0xBC48	0x563B	# <CJK>
0xBC49	0x5639	# <CJK>
0xBC4A	0x5632	# <CJK>
0xBC4B	0x563F	# <CJK>
0xBC4C	0x5634	# <CJK>
0xBC4D	0x5629	# <CJK>
0xBC4E	0x5653	# <CJK>
0xBC4F	0x564E	# <CJK>
0xBC50	0x5657	# <CJK>
0xBC51	0x5674	# <CJK>
0xBC52	0x5636	# <CJK>
0xBC53	0x562F	# <CJK>
0xBC54	0x5630	# <CJK>
0xBC55	0x5880	# <CJK>
0xBC56	0x589F	# <CJK>
0xBC57	0x589E	# <CJK>
0xBC58	0x58B3	# <CJK>
0xBC59	0x589C	# <CJK>
0xBC5A	0x58AE	# <CJK>
0xBC5B	0x58A9	# <CJK>
0xBC5C	0x58A6	# <CJK>
0xBC5D	0x596D	# <CJK>
0xBC5E	0x5B09	# <CJK>
0xBC5F	0x5AFB	# <CJK>
0xBC60	0x5B0B	# <CJK>
0xBC61	0x5AF5	# <CJK>
0xBC62	0x5B0C	# <CJK>
0xBC63	0x5B08	# <CJK>
0xBC64	0x5BEE	# <CJK>
0xBC65	0x5BEC	# <CJK>
0xBC66	0x5BE9	# <CJK>
0xBC67	0x5BEB	# <CJK>
0xBC68	0x5C64	# <CJK>
0xBC69	0x5C65	# <CJK>
0xBC6A	0x5D9D	# <CJK>
0xBC6B	0x5D94	# <CJK>
0xBC6C	0x5E62	# <CJK>
0xBC6D	0x5E5F	# <CJK>
0xBC6E	0x5E61	# <CJK>
0xBC6F	0x5EE2	# <CJK>
0xBC70	0x5EDA	# <CJK>
0xBC71	0x5EDF	# <CJK>
0xBC72	0x5EDD	# <CJK>
0xBC73	0x5EE3	# <CJK>
0xBC74	0x5EE0	# <CJK>
0xBC75	0x5F48	# <CJK>
0xBC76	0x5F71	# <CJK>
0xBC77	0x5FB7	# <CJK>
0xBC78	0x5FB5	# <CJK>
0xBC79	0x6176	# <CJK>
0xBC7A	0x6167	# <CJK>
0xBC7B	0x616E	# <CJK>
0xBC7C	0x615D	# <CJK>
0xBC7D	0x6155	# <CJK>
0xBC7E	0x6182	# <CJK>
0xBCA1	0x617C	# <CJK>
0xBCA2	0x6170	# <CJK>
0xBCA3	0x616B	# <CJK>
0xBCA4	0x617E	# <CJK>
0xBCA5	0x61A7	# <CJK>
0xBCA6	0x6190	# <CJK>
0xBCA7	0x61AB	# <CJK>
0xBCA8	0x618E	# <CJK>
0xBCA9	0x61AC	# <CJK>
0xBCAA	0x619A	# <CJK>
0xBCAB	0x61A4	# <CJK>
0xBCAC	0x6194	# <CJK>
0xBCAD	0x61AE	# <CJK>
0xBCAE	0x622E	# <CJK>
0xBCAF	0x6469	# <CJK>
0xBCB0	0x646F	# <CJK>
0xBCB1	0x6479	# <CJK>
0xBCB2	0x649E	# <CJK>
0xBCB3	0x64B2	# <CJK>
0xBCB4	0x6488	# <CJK>
0xBCB5	0x6490	# <CJK>
0xBCB6	0x64B0	# <CJK>
0xBCB7	0x64A5	# <CJK>
0xBCB8	0x6493	# <CJK>
0xBCB9	0x6495	# <CJK>
0xBCBA	0x64A9	# <CJK>
0xBCBB	0x6492	# <CJK>
0xBCBC	0x64AE	# <CJK>
0xBCBD	0x64AD	# <CJK>
0xBCBE	0x64AB	# <CJK>
0xBCBF	0x649A	# <CJK>
0xBCC0	0x64AC	# <CJK>
0xBCC1	0x6499	# <CJK>
0xBCC2	0x64A2	# <CJK>
0xBCC3	0x64B3	# <CJK>
0xBCC4	0x6575	# <CJK>
0xBCC5	0x6577	# <CJK>
0xBCC6	0x6578	# <CJK>
0xBCC7	0x66AE	# <CJK>
0xBCC8	0x66AB	# <CJK>
0xBCC9	0x66B4	# <CJK>
0xBCCA	0x66B1	# <CJK>
0xBCCB	0x6A23	# <CJK>
0xBCCC	0x6A1F	# <CJK>
0xBCCD	0x69E8	# <CJK>
0xBCCE	0x6A01	# <CJK>
0xBCCF	0x6A1E	# <CJK>
0xBCD0	0x6A19	# <CJK>
0xBCD1	0x69FD	# <CJK>
0xBCD2	0x6A21	# <CJK>
0xBCD3	0x6A13	# <CJK>
0xBCD4	0x6A0A	# <CJK>
0xBCD5	0x69F3	# <CJK>
0xBCD6	0x6A02	# <CJK>
0xBCD7	0x6A05	# <CJK>
0xBCD8	0x69ED	# <CJK>
0xBCD9	0x6A11	# <CJK>
0xBCDA	0x6B50	# <CJK>
0xBCDB	0x6B4E	# <CJK>
0xBCDC	0x6BA4	# <CJK>
0xBCDD	0x6BC5	# <CJK>
0xBCDE	0x6BC6	# <CJK>
0xBCDF	0x6F3F	# <CJK>
0xBCE0	0x6F7C	# <CJK>
0xBCE1	0x6F84	# <CJK>
0xBCE2	0x6F51	# <CJK>
0xBCE3	0x6F66	# <CJK>
0xBCE4	0x6F54	# <CJK>
0xBCE5	0x6F86	# <CJK>
0xBCE6	0x6F6D	# <CJK>
0xBCE7	0x6F5B	# <CJK>
0xBCE8	0x6F78	# <CJK>
0xBCE9	0x6F6E	# <CJK>
0xBCEA	0x6F8E	# <CJK>
0xBCEB	0x6F7A	# <CJK>
0xBCEC	0x6F70	# <CJK>
0xBCED	0x6F64	# <CJK>
0xBCEE	0x6F97	# <CJK>
0xBCEF	0x6F58	# <CJK>
0xBCF0	0x6ED5	# <CJK>
0xBCF1	0x6F6F	# <CJK>
0xBCF2	0x6F60	# <CJK>
0xBCF3	0x6F5F	# <CJK>
0xBCF4	0x719F	# <CJK>
0xBCF5	0x71AC	# <CJK>
0xBCF6	0x71B1	# <CJK>
0xBCF7	0x71A8	# <CJK>
0xBCF8	0x7256	# <CJK>
0xBCF9	0x729B	# <CJK>
0xBCFA	0x734E	# <CJK>
0xBCFB	0x7357	# <CJK>
0xBCFC	0x7469	# <CJK>
0xBCFD	0x748B	# <CJK>
0xBCFE	0x7483	# <CJK>
0xBD40	0x747E	# <CJK>
0xBD41	0x7480	# <CJK>
0xBD42	0x757F	# <CJK>
0xBD43	0x7620	# <CJK>
0xBD44	0x7629	# <CJK>
0xBD45	0x761F	# <CJK>
0xBD46	0x7624	# <CJK>
0xBD47	0x7626	# <CJK>
0xBD48	0x7621	# <CJK>
0xBD49	0x7622	# <CJK>
0xBD4A	0x769A	# <CJK>
0xBD4B	0x76BA	# <CJK>
0xBD4C	0x76E4	# <CJK>
0xBD4D	0x778E	# <CJK>
0xBD4E	0x7787	# <CJK>
0xBD4F	0x778C	# <CJK>
0xBD50	0x7791	# <CJK>
0xBD51	0x778B	# <CJK>
0xBD52	0x78CB	# <CJK>
0xBD53	0x78C5	# <CJK>
0xBD54	0x78BA	# <CJK>
0xBD55	0x78CA	# <CJK>
0xBD56	0x78BE	# <CJK>
0xBD57	0x78D5	# <CJK>
0xBD58	0x78BC	# <CJK>
0xBD59	0x78D0	# <CJK>
0xBD5A	0x7A3F	# <CJK>
0xBD5B	0x7A3C	# <CJK>
0xBD5C	0x7A40	# <CJK>
0xBD5D	0x7A3D	# <CJK>
0xBD5E	0x7A37	# <CJK>
0xBD5F	0x7A3B	# <CJK>
0xBD60	0x7AAF	# <CJK>
0xBD61	0x7AAE	# <CJK>
0xBD62	0x7BAD	# <CJK>
0xBD63	0x7BB1	# <CJK>
0xBD64	0x7BC4	# <CJK>
0xBD65	0x7BB4	# <CJK>
0xBD66	0x7BC6	# <CJK>
0xBD67	0x7BC7	# <CJK>
0xBD68	0x7BC1	# <CJK>
0xBD69	0x7BA0	# <CJK>
0xBD6A	0x7BCC	# <CJK>
0xBD6B	0x7CCA	# <CJK>
0xBD6C	0x7DE0	# <CJK>
0xBD6D	0x7DF4	# <CJK>
0xBD6E	0x7DEF	# <CJK>
0xBD6F	0x7DFB	# <CJK>
0xBD70	0x7DD8	# <CJK>
0xBD71	0x7DEC	# <CJK>
0xBD72	0x7DDD	# <CJK>
0xBD73	0x7DE8	# <CJK>
0xBD74	0x7DE3	# <CJK>
0xBD75	0x7DDA	# <CJK>
0xBD76	0x7DDE	# <CJK>
0xBD77	0x7DE9	# <CJK>
0xBD78	0x7D9E	# <CJK>
0xBD79	0x7DD9	# <CJK>
0xBD7A	0x7DF2	# <CJK>
0xBD7B	0x7DF9	# <CJK>
0xBD7C	0x7F75	# <CJK>
0xBD7D	0x7F77	# <CJK>
0xBD7E	0x7FAF	# <CJK>
0xBDA1	0x7FE9	# <CJK>
0xBDA2	0x8026	# <CJK>
0xBDA3	0x819B	# <CJK>
0xBDA4	0x819C	# <CJK>
0xBDA5	0x819D	# <CJK>
0xBDA6	0x81A0	# <CJK>
0xBDA7	0x819A	# <CJK>
0xBDA8	0x8198	# <CJK>
0xBDA9	0x8517	# <CJK>
0xBDAA	0x853D	# <CJK>
0xBDAB	0x851A	# <CJK>
0xBDAC	0x84EE	# <CJK>
0xBDAD	0x852C	# <CJK>
0xBDAE	0x852D	# <CJK>
0xBDAF	0x8513	# <CJK>
0xBDB0	0x8511	# <CJK>
0xBDB1	0x8523	# <CJK>
0xBDB2	0x8521	# <CJK>
0xBDB3	0x8514	# <CJK>
0xBDB4	0x84EC	# <CJK>
0xBDB5	0x8525	# <CJK>
0xBDB6	0x84FF	# <CJK>
0xBDB7	0x8506	# <CJK>
0xBDB8	0x8782	# <CJK>
0xBDB9	0x8774	# <CJK>
0xBDBA	0x8776	# <CJK>
0xBDBB	0x8760	# <CJK>
0xBDBC	0x8766	# <CJK>
0xBDBD	0x8778	# <CJK>
0xBDBE	0x8768	# <CJK>
0xBDBF	0x8759	# <CJK>
0xBDC0	0x8757	# <CJK>
0xBDC1	0x874C	# <CJK>
0xBDC2	0x8753	# <CJK>
0xBDC3	0x885B	# <CJK>
0xBDC4	0x885D	# <CJK>
0xBDC5	0x8910	# <CJK>
0xBDC6	0x8907	# <CJK>
0xBDC7	0x8912	# <CJK>
0xBDC8	0x8913	# <CJK>
0xBDC9	0x8915	# <CJK>
0xBDCA	0x890A	# <CJK>
0xBDCB	0x8ABC	# <CJK>
0xBDCC	0x8AD2	# <CJK>
0xBDCD	0x8AC7	# <CJK>
0xBDCE	0x8AC4	# <CJK>
0xBDCF	0x8A95	# <CJK>
0xBDD0	0x8ACB	# <CJK>
0xBDD1	0x8AF8	# <CJK>
0xBDD2	0x8AB2	# <CJK>
0xBDD3	0x8AC9	# <CJK>
0xBDD4	0x8AC2	# <CJK>
0xBDD5	0x8ABF	# <CJK>
0xBDD6	0x8AB0	# <CJK>
0xBDD7	0x8AD6	# <CJK>
0xBDD8	0x8ACD	# <CJK>
0xBDD9	0x8AB6	# <CJK>
0xBDDA	0x8AB9	# <CJK>
0xBDDB	0x8ADB	# <CJK>
0xBDDC	0x8C4C	# <CJK>
0xBDDD	0x8C4E	# <CJK>
0xBDDE	0x8C6C	# <CJK>
0xBDDF	0x8CE0	# <CJK>
0xBDE0	0x8CDE	# <CJK>
0xBDE1	0x8CE6	# <CJK>
0xBDE2	0x8CE4	# <CJK>
0xBDE3	0x8CEC	# <CJK>
0xBDE4	0x8CED	# <CJK>
0xBDE5	0x8CE2	# <CJK>
0xBDE6	0x8CE3	# <CJK>
0xBDE7	0x8CDC	# <CJK>
0xBDE8	0x8CEA	# <CJK>
0xBDE9	0x8CE1	# <CJK>
0xBDEA	0x8D6D	# <CJK>
0xBDEB	0x8D9F	# <CJK>
0xBDEC	0x8DA3	# <CJK>
0xBDED	0x8E2B	# <CJK>
0xBDEE	0x8E10	# <CJK>
0xBDEF	0x8E1D	# <CJK>
0xBDF0	0x8E22	# <CJK>
0xBDF1	0x8E0F	# <CJK>
0xBDF2	0x8E29	# <CJK>
0xBDF3	0x8E1F	# <CJK>
0xBDF4	0x8E21	# <CJK>
0xBDF5	0x8E1E	# <CJK>
0xBDF6	0x8EBA	# <CJK>
0xBDF7	0x8F1D	# <CJK>
0xBDF8	0x8F1B	# <CJK>
0xBDF9	0x8F1F	# <CJK>
0xBDFA	0x8F29	# <CJK>
0xBDFB	0x8F26	# <CJK>
0xBDFC	0x8F2A	# <CJK>
0xBDFD	0x8F1C	# <CJK>
0xBDFE	0x8F1E	# <CJK>
0xBE40	0x8F25	# <CJK>
0xBE41	0x9069	# <CJK>
0xBE42	0x906E	# <CJK>
0xBE43	0x9068	# <CJK>
0xBE44	0x906D	# <CJK>
0xBE45	0x9077	# <CJK>
0xBE46	0x9130	# <CJK>
0xBE47	0x912D	# <CJK>
0xBE48	0x9127	# <CJK>
0xBE49	0x9131	# <CJK>
0xBE4A	0x9187	# <CJK>
0xBE4B	0x9189	# <CJK>
0xBE4C	0x918B	# <CJK>
0xBE4D	0x9183	# <CJK>
0xBE4E	0x92C5	# <CJK>
0xBE4F	0x92BB	# <CJK>
0xBE50	0x92B7	# <CJK>
0xBE51	0x92EA	# <CJK>
0xBE52	0x92AC	# <CJK>
0xBE53	0x92E4	# <CJK>
0xBE54	0x92C1	# <CJK>
0xBE55	0x92B3	# <CJK>
0xBE56	0x92BC	# <CJK>
0xBE57	0x92D2	# <CJK>
0xBE58	0x92C7	# <CJK>
0xBE59	0x92F0	# <CJK>
0xBE5A	0x92B2	# <CJK>
0xBE5B	0x95AD	# <CJK>
0xBE5C	0x95B1	# <CJK>
0xBE5D	0x9704	# <CJK>
0xBE5E	0x9706	# <CJK>
0xBE5F	0x9707	# <CJK>
0xBE60	0x9709	# <CJK>
0xBE61	0x9760	# <CJK>
0xBE62	0x978D	# <CJK>
0xBE63	0x978B	# <CJK>
0xBE64	0x978F	# <CJK>
0xBE65	0x9821	# <CJK>
0xBE66	0x982B	# <CJK>
0xBE67	0x981C	# <CJK>
0xBE68	0x98B3	# <CJK>
0xBE69	0x990A	# <CJK>
0xBE6A	0x9913	# <CJK>
0xBE6B	0x9912	# <CJK>
0xBE6C	0x9918	# <CJK>
0xBE6D	0x99DD	# <CJK>
0xBE6E	0x99D0	# <CJK>
0xBE6F	0x99DF	# <CJK>
0xBE70	0x99DB	# <CJK>
0xBE71	0x99D1	# <CJK>
0xBE72	0x99D5	# <CJK>
0xBE73	0x99D2	# <CJK>
0xBE74	0x99D9	# <CJK>
0xBE75	0x9AB7	# <CJK>
0xBE76	0x9AEE	# <CJK>
0xBE77	0x9AEF	# <CJK>
0xBE78	0x9B27	# <CJK>
0xBE79	0x9B45	# <CJK>
0xBE7A	0x9B44	# <CJK>
0xBE7B	0x9B77	# <CJK>
0xBE7C	0x9B6F	# <CJK>
0xBE7D	0x9D06	# <CJK>
0xBE7E	0x9D09	# <CJK>
0xBEA1	0x9D03	# <CJK>
0xBEA2	0x9EA9	# <CJK>
0xBEA3	0x9EBE	# <CJK>
0xBEA4	0x9ECE	# <CJK>
0xBEA5	0x58A8	# <CJK>
0xBEA6	0x9F52	# <CJK>
0xBEA7	0x5112	# <CJK>
0xBEA8	0x5118	# <CJK>
0xBEA9	0x5114	# <CJK>
0xBEAA	0x5110	# <CJK>
0xBEAB	0x5115	# <CJK>
0xBEAC	0x5180	# <CJK>
0xBEAD	0x51AA	# <CJK>
0xBEAE	0x51DD	# <CJK>
0xBEAF	0x5291	# <CJK>
0xBEB0	0x5293	# <CJK>
0xBEB1	0x52F3	# <CJK>
0xBEB2	0x5659	# <CJK>
0xBEB3	0x566B	# <CJK>
0xBEB4	0x5679	# <CJK>
0xBEB5	0x5669	# <CJK>
0xBEB6	0x5664	# <CJK>
0xBEB7	0x5678	# <CJK>
0xBEB8	0x566A	# <CJK>
0xBEB9	0x5668	# <CJK>
0xBEBA	0x5665	# <CJK>
0xBEBB	0x5671	# <CJK>
0xBEBC	0x566F	# <CJK>
0xBEBD	0x566C	# <CJK>
0xBEBE	0x5662	# <CJK>
0xBEBF	0x5676	# <CJK>
0xBEC0	0x58C1	# <CJK>
0xBEC1	0x58BE	# <CJK>
0xBEC2	0x58C7	# <CJK>
0xBEC3	0x58C5	# <CJK>
0xBEC4	0x596E	# <CJK>
0xBEC5	0x5B1D	# <CJK>
0xBEC6	0x5B34	# <CJK>
0xBEC7	0x5B78	# <CJK>
0xBEC8	0x5BF0	# <CJK>
0xBEC9	0x5C0E	# <CJK>
0xBECA	0x5F4A	# <CJK>
0xBECB	0x61B2	# <CJK>
0xBECC	0x6191	# <CJK>
0xBECD	0x61A9	# <CJK>
0xBECE	0x618A	# <CJK>
0xBECF	0x61CD	# <CJK>
0xBED0	0x61B6	# <CJK>
0xBED1	0x61BE	# <CJK>
0xBED2	0x61CA	# <CJK>
0xBED3	0x61C8	# <CJK>
0xBED4	0x6230	# <CJK>
0xBED5	0x64C5	# <CJK>
0xBED6	0x64C1	# <CJK>
0xBED7	0x64CB	# <CJK>
0xBED8	0x64BB	# <CJK>
0xBED9	0x64BC	# <CJK>
0xBEDA	0x64DA	# <CJK>
0xBEDB	0x64C4	# <CJK>
0xBEDC	0x64C7	# <CJK>
0xBEDD	0x64C2	# <CJK>
0xBEDE	0x64CD	# <CJK>
0xBEDF	0x64BF	# <CJK>
0xBEE0	0x64D2	# <CJK>
0xBEE1	0x64D4	# <CJK>
0xBEE2	0x64BE	# <CJK>
0xBEE3	0x6574	# <CJK>
0xBEE4	0x66C6	# <CJK>
0xBEE5	0x66C9	# <CJK>
0xBEE6	0x66B9	# <CJK>
0xBEE7	0x66C4	# <CJK>
0xBEE8	0x66C7	# <CJK>
0xBEE9	0x66B8	# <CJK>
0xBEEA	0x6A3D	# <CJK>
0xBEEB	0x6A38	# <CJK>
0xBEEC	0x6A3A	# <CJK>
0xBEED	0x6A59	# <CJK>
0xBEEE	0x6A6B	# <CJK>
0xBEEF	0x6A58	# <CJK>
0xBEF0	0x6A39	# <CJK>
0xBEF1	0x6A44	# <CJK>
0xBEF2	0x6A62	# <CJK>
0xBEF3	0x6A61	# <CJK>
0xBEF4	0x6A4B	# <CJK>
0xBEF5	0x6A47	# <CJK>
0xBEF6	0x6A35	# <CJK>
0xBEF7	0x6A5F	# <CJK>
0xBEF8	0x6A48	# <CJK>
0xBEF9	0x6B59	# <CJK>
0xBEFA	0x6B77	# <CJK>
0xBEFB	0x6C05	# <CJK>
0xBEFC	0x6FC2	# <CJK>
0xBEFD	0x6FB1	# <CJK>
0xBEFE	0x6FA1	# <CJK>
0xBF40	0x6FC3	# <CJK>
0xBF41	0x6FA4	# <CJK>
0xBF42	0x6FC1	# <CJK>
0xBF43	0x6FA7	# <CJK>
0xBF44	0x6FB3	# <CJK>
0xBF45	0x6FC0	# <CJK>
0xBF46	0x6FB9	# <CJK>
0xBF47	0x6FB6	# <CJK>
0xBF48	0x6FA6	# <CJK>
0xBF49	0x6FA0	# <CJK>
0xBF4A	0x6FB4	# <CJK>
0xBF4B	0x71BE	# <CJK>
0xBF4C	0x71C9	# <CJK>
0xBF4D	0x71D0	# <CJK>
0xBF4E	0x71D2	# <CJK>
0xBF4F	0x71C8	# <CJK>
0xBF50	0x71D5	# <CJK>
0xBF51	0x71B9	# <CJK>
0xBF52	0x71CE	# <CJK>
0xBF53	0x71D9	# <CJK>
0xBF54	0x71DC	# <CJK>
0xBF55	0x71C3	# <CJK>
0xBF56	0x71C4	# <CJK>
0xBF57	0x7368	# <CJK>
0xBF58	0x749C	# <CJK>
0xBF59	0x74A3	# <CJK>
0xBF5A	0x7498	# <CJK>
0xBF5B	0x749F	# <CJK>
0xBF5C	0x749E	# <CJK>
0xBF5D	0x74E2	# <CJK>
0xBF5E	0x750C	# <CJK>
0xBF5F	0x750D	# <CJK>
0xBF60	0x7634	# <CJK>
0xBF61	0x7638	# <CJK>
0xBF62	0x763A	# <CJK>
0xBF63	0x76E7	# <CJK>
0xBF64	0x76E5	# <CJK>
0xBF65	0x77A0	# <CJK>
0xBF66	0x779E	# <CJK>
0xBF67	0x779F	# <CJK>
0xBF68	0x77A5	# <CJK>
0xBF69	0x78E8	# <CJK>
0xBF6A	0x78DA	# <CJK>
0xBF6B	0x78EC	# <CJK>
0xBF6C	0x78E7	# <CJK>
0xBF6D	0x79A6	# <CJK>
0xBF6E	0x7A4D	# <CJK>
0xBF6F	0x7A4E	# <CJK>
0xBF70	0x7A46	# <CJK>
0xBF71	0x7A4C	# <CJK>
0xBF72	0x7A4B	# <CJK>
0xBF73	0x7ABA	# <CJK>
0xBF74	0x7BD9	# <CJK>
0xBF75	0x7C11	# <CJK>
0xBF76	0x7BC9	# <CJK>
0xBF77	0x7BE4	# <CJK>
0xBF78	0x7BDB	# <CJK>
0xBF79	0x7BE1	# <CJK>
0xBF7A	0x7BE9	# <CJK>
0xBF7B	0x7BE6	# <CJK>
0xBF7C	0x7CD5	# <CJK>
0xBF7D	0x7CD6	# <CJK>
0xBF7E	0x7E0A	# <CJK>
0xBFA1	0x7E11	# <CJK>
0xBFA2	0x7E08	# <CJK>
0xBFA3	0x7E1B	# <CJK>
0xBFA4	0x7E23	# <CJK>
0xBFA5	0x7E1E	# <CJK>
0xBFA6	0x7E1D	# <CJK>
0xBFA7	0x7E09	# <CJK>
0xBFA8	0x7E10	# <CJK>
0xBFA9	0x7F79	# <CJK>
0xBFAA	0x7FB2	# <CJK>
0xBFAB	0x7FF0	# <CJK>
0xBFAC	0x7FF1	# <CJK>
0xBFAD	0x7FEE	# <CJK>
0xBFAE	0x8028	# <CJK>
0xBFAF	0x81B3	# <CJK>
0xBFB0	0x81A9	# <CJK>
0xBFB1	0x81A8	# <CJK>
0xBFB2	0x81FB	# <CJK>
0xBFB3	0x8208	# <CJK>
0xBFB4	0x8258	# <CJK>
0xBFB5	0x8259	# <CJK>
0xBFB6	0x854A	# <CJK>
0xBFB7	0x8559	# <CJK>
0xBFB8	0x8548	# <CJK>
0xBFB9	0x8568	# <CJK>
0xBFBA	0x8569	# <CJK>
0xBFBB	0x8543	# <CJK>
0xBFBC	0x8549	# <CJK>
0xBFBD	0x856D	# <CJK>
0xBFBE	0x856A	# <CJK>
0xBFBF	0x855E	# <CJK>
0xBFC0	0x8783	# <CJK>
0xBFC1	0x879F	# <CJK>
0xBFC2	0x879E	# <CJK>
0xBFC3	0x87A2	# <CJK>
0xBFC4	0x878D	# <CJK>
0xBFC5	0x8861	# <CJK>
0xBFC6	0x892A	# <CJK>
0xBFC7	0x8932	# <CJK>
0xBFC8	0x8925	# <CJK>
0xBFC9	0x892B	# <CJK>
0xBFCA	0x8921	# <CJK>
0xBFCB	0x89AA	# <CJK>
0xBFCC	0x89A6	# <CJK>
0xBFCD	0x8AE6	# <CJK>
0xBFCE	0x8AFA	# <CJK>
0xBFCF	0x8AEB	# <CJK>
0xBFD0	0x8AF1	# <CJK>
0xBFD1	0x8B00	# <CJK>
0xBFD2	0x8ADC	# <CJK>
0xBFD3	0x8AE7	# <CJK>
0xBFD4	0x8AEE	# <CJK>
0xBFD5	0x8AFE	# <CJK>
0xBFD6	0x8B01	# <CJK>
0xBFD7	0x8B02	# <CJK>
0xBFD8	0x8AF7	# <CJK>
0xBFD9	0x8AED	# <CJK>
0xBFDA	0x8AF3	# <CJK>
0xBFDB	0x8AF6	# <CJK>
0xBFDC	0x8AFC	# <CJK>
0xBFDD	0x8C6B	# <CJK>
0xBFDE	0x8C6D	# <CJK>
0xBFDF	0x8C93	# <CJK>
0xBFE0	0x8CF4	# <CJK>
0xBFE1	0x8E44	# <CJK>
0xBFE2	0x8E31	# <CJK>
0xBFE3	0x8E34	# <CJK>
0xBFE4	0x8E42	# <CJK>
0xBFE5	0x8E39	# <CJK>
0xBFE6	0x8E35	# <CJK>
0xBFE7	0x8F3B	# <CJK>
0xBFE8	0x8F2F	# <CJK>
0xBFE9	0x8F38	# <CJK>
0xBFEA	0x8F33	# <CJK>
0xBFEB	0x8FA8	# <CJK>
0xBFEC	0x8FA6	# <CJK>
0xBFED	0x9075	# <CJK>
0xBFEE	0x9074	# <CJK>
0xBFEF	0x9078	# <CJK>
0xBFF0	0x9072	# <CJK>
0xBFF1	0x907C	# <CJK>
0xBFF2	0x907A	# <CJK>
0xBFF3	0x9134	# <CJK>
0xBFF4	0x9192	# <CJK>
0xBFF5	0x9320	# <CJK>
0xBFF6	0x9336	# <CJK>
0xBFF7	0x92F8	# <CJK>
0xBFF8	0x9333	# <CJK>
0xBFF9	0x932F	# <CJK>
0xBFFA	0x9322	# <CJK>
0xBFFB	0x92FC	# <CJK>
0xBFFC	0x932B	# <CJK>
0xBFFD	0x9304	# <CJK>
0xBFFE	0x931A	# <CJK>
0xC040	0x9310	# <CJK>
0xC041	0x9326	# <CJK>
0xC042	0x9321	# <CJK>
0xC043	0x9315	# <CJK>
0xC044	0x932E	# <CJK>
0xC045	0x9319	# <CJK>
0xC046	0x95BB	# <CJK>
0xC047	0x96A7	# <CJK>
0xC048	0x96A8	# <CJK>
0xC049	0x96AA	# <CJK>
0xC04A	0x96D5	# <CJK>
0xC04B	0x970E	# <CJK>
0xC04C	0x9711	# <CJK>
0xC04D	0x9716	# <CJK>
0xC04E	0x970D	# <CJK>
0xC04F	0x9713	# <CJK>
0xC050	0x970F	# <CJK>
0xC051	0x975B	# <CJK>
0xC052	0x975C	# <CJK>
0xC053	0x9766	# <CJK>
0xC054	0x9798	# <CJK>
0xC055	0x9830	# <CJK>
0xC056	0x9838	# <CJK>
0xC057	0x983B	# <CJK>
0xC058	0x9837	# <CJK>
0xC059	0x982D	# <CJK>
0xC05A	0x9839	# <CJK>
0xC05B	0x9824	# <CJK>
0xC05C	0x9910	# <CJK>
0xC05D	0x9928	# <CJK>
0xC05E	0x991E	# <CJK>
0xC05F	0x991B	# <CJK>
0xC060	0x9921	# <CJK>
0xC061	0x991A	# <CJK>
0xC062	0x99ED	# <CJK>
0xC063	0x99E2	# <CJK>
0xC064	0x99F1	# <CJK>
0xC065	0x9AB8	# <CJK>
0xC066	0x9ABC	# <CJK>
0xC067	0x9AFB	# <CJK>
0xC068	0x9AED	# <CJK>
0xC069	0x9B28	# <CJK>
0xC06A	0x9B91	# <CJK>
0xC06B	0x9D15	# <CJK>
0xC06C	0x9D23	# <CJK>
0xC06D	0x9D26	# <CJK>
0xC06E	0x9D28	# <CJK>
0xC06F	0x9D12	# <CJK>
0xC070	0x9D1B	# <CJK>
0xC071	0x9ED8	# <CJK>
0xC072	0x9ED4	# <CJK>
0xC073	0x9F8D	# <CJK>
0xC074	0x9F9C	# <CJK>
0xC075	0x512A	# <CJK>
0xC076	0x511F	# <CJK>
0xC077	0x5121	# <CJK>
0xC078	0x5132	# <CJK>
0xC079	0x52F5	# <CJK>
0xC07A	0x568E	# <CJK>
0xC07B	0x5680	# <CJK>
0xC07C	0x5690	# <CJK>
0xC07D	0x5685	# <CJK>
0xC07E	0x5687	# <CJK>
0xC0A1	0x568F	# <CJK>
0xC0A2	0x58D5	# <CJK>
0xC0A3	0x58D3	# <CJK>
0xC0A4	0x58D1	# <CJK>
0xC0A5	0x58CE	# <CJK>
0xC0A6	0x5B30	# <CJK>
0xC0A7	0x5B2A	# <CJK>
0xC0A8	0x5B24	# <CJK>
0xC0A9	0x5B7A	# <CJK>
0xC0AA	0x5C37	# <CJK>
0xC0AB	0x5C68	# <CJK>
0xC0AC	0x5DBC	# <CJK>
0xC0AD	0x5DBA	# <CJK>
0xC0AE	0x5DBD	# <CJK>
0xC0AF	0x5DB8	# <CJK>
0xC0B0	0x5E6B	# <CJK>
0xC0B1	0x5F4C	# <CJK>
0xC0B2	0x5FBD	# <CJK>
0xC0B3	0x61C9	# <CJK>
0xC0B4	0x61C2	# <CJK>
0xC0B5	0x61C7	# <CJK>
0xC0B6	0x61E6	# <CJK>
0xC0B7	0x61CB	# <CJK>
0xC0B8	0x6232	# <CJK>
0xC0B9	0x6234	# <CJK>
0xC0BA	0x64CE	# <CJK>
0xC0BB	0x64CA	# <CJK>
0xC0BC	0x64D8	# <CJK>
0xC0BD	0x64E0	# <CJK>
0xC0BE	0x64F0	# <CJK>
0xC0BF	0x64E6	# <CJK>
0xC0C0	0x64EC	# <CJK>
0xC0C1	0x64F1	# <CJK>
0xC0C2	0x64E2	# <CJK>
0xC0C3	0x64ED	# <CJK>
0xC0C4	0x6582	# <CJK>
0xC0C5	0x6583	# <CJK>
0xC0C6	0x66D9	# <CJK>
0xC0C7	0x66D6	# <CJK>
0xC0C8	0x6A80	# <CJK>
0xC0C9	0x6A94	# <CJK>
0xC0CA	0x6A84	# <CJK>
0xC0CB	0x6AA2	# <CJK>
0xC0CC	0x6A9C	# <CJK>
0xC0CD	0x6ADB	# <CJK>
0xC0CE	0x6AA3	# <CJK>
0xC0CF	0x6A7E	# <CJK>
0xC0D0	0x6A97	# <CJK>
0xC0D1	0x6A90	# <CJK>
0xC0D2	0x6AA0	# <CJK>
0xC0D3	0x6B5C	# <CJK>
0xC0D4	0x6BAE	# <CJK>
0xC0D5	0x6BDA	# <CJK>
0xC0D6	0x6C08	# <CJK>
0xC0D7	0x6FD8	# <CJK>
0xC0D8	0x6FF1	# <CJK>
0xC0D9	0x6FDF	# <CJK>
0xC0DA	0x6FE0	# <CJK>
0xC0DB	0x6FDB	# <CJK>
0xC0DC	0x6FE4	# <CJK>
0xC0DD	0x6FEB	# <CJK>
0xC0DE	0x6FEF	# <CJK>
0xC0DF	0x6F80	# <CJK>
0xC0E0	0x6FEC	# <CJK>
0xC0E1	0x6FE1	# <CJK>
0xC0E2	0x6FE9	# <CJK>
0xC0E3	0x6FD5	# <CJK>
0xC0E4	0x6FEE	# <CJK>
0xC0E5	0x6FF0	# <CJK>
0xC0E6	0x71E7	# <CJK>
0xC0E7	0x71DF	# <CJK>
0xC0E8	0x71EE	# <CJK>
0xC0E9	0x71E6	# <CJK>
0xC0EA	0x71E5	# <CJK>
0xC0EB	0x71ED	# <CJK>
0xC0EC	0x71EC	# <CJK>
0xC0ED	0x71F4	# <CJK>
0xC0EE	0x71E0	# <CJK>
0xC0EF	0x7235	# <CJK>
0xC0F0	0x7246	# <CJK>
0xC0F1	0x7370	# <CJK>
0xC0F2	0x7372	# <CJK>
0xC0F3	0x74A9	# <CJK>
0xC0F4	0x74B0	# <CJK>
0xC0F5	0x74A6	# <CJK>
0xC0F6	0x74A8	# <CJK>
0xC0F7	0x7646	# <CJK>
0xC0F8	0x7642	# <CJK>
0xC0F9	0x764C	# <CJK>
0xC0FA	0x76EA	# <CJK>
0xC0FB	0x77B3	# <CJK>
0xC0FC	0x77AA	# <CJK>
0xC0FD	0x77B0	# <CJK>
0xC0FE	0x77AC	# <CJK>
0xC140	0x77A7	# <CJK>
0xC141	0x77AD	# <CJK>
0xC142	0x77EF	# <CJK>
0xC143	0x78F7	# <CJK>
0xC144	0x78FA	# <CJK>
0xC145	0x78F4	# <CJK>
0xC146	0x78EF	# <CJK>
0xC147	0x7901	# <CJK>
0xC148	0x79A7	# <CJK>
0xC149	0x79AA	# <CJK>
0xC14A	0x7A57	# <CJK>
0xC14B	0x7ABF	# <CJK>
0xC14C	0x7C07	# <CJK>
0xC14D	0x7C0D	# <CJK>
0xC14E	0x7BFE	# <CJK>
0xC14F	0x7BF7	# <CJK>
0xC150	0x7C0C	# <CJK>
0xC151	0x7BE0	# <CJK>
0xC152	0x7CE0	# <CJK>
0xC153	0x7CDC	# <CJK>
0xC154	0x7CDE	# <CJK>
0xC155	0x7CE2	# <CJK>
0xC156	0x7CDF	# <CJK>
0xC157	0x7CD9	# <CJK>
0xC158	0x7CDD	# <CJK>
0xC159	0x7E2E	# <CJK>
0xC15A	0x7E3E	# <CJK>
0xC15B	0x7E46	# <CJK>
0xC15C	0x7E37	# <CJK>
0xC15D	0x7E32	# <CJK>
0xC15E	0x7E43	# <CJK>
0xC15F	0x7E2B	# <CJK>
0xC160	0x7E3D	# <CJK>
0xC161	0x7E31	# <CJK>
0xC162	0x7E45	# <CJK>
0xC163	0x7E41	# <CJK>
0xC164	0x7E34	# <CJK>
0xC165	0x7E39	# <CJK>
0xC166	0x7E48	# <CJK>
0xC167	0x7E35	# <CJK>
0xC168	0x7E3F	# <CJK>
0xC169	0x7E2F	# <CJK>
0xC16A	0x7F44	# <CJK>
0xC16B	0x7FF3	# <CJK>
0xC16C	0x7FFC	# <CJK>
0xC16D	0x8071	# <CJK>
0xC16E	0x8072	# <CJK>
0xC16F	0x8070	# <CJK>
0xC170	0x806F	# <CJK>
0xC171	0x8073	# <CJK>
0xC172	0x81C6	# <CJK>
0xC173	0x81C3	# <CJK>
0xC174	0x81BA	# <CJK>
0xC175	0x81C2	# <CJK>
0xC176	0x81C0	# <CJK>
0xC177	0x81BF	# <CJK>
0xC178	0x81BD	# <CJK>
0xC179	0x81C9	# <CJK>
0xC17A	0x81BE	# <CJK>
0xC17B	0x81E8	# <CJK>
0xC17C	0x8209	# <CJK>
0xC17D	0x8271	# <CJK>
0xC17E	0x85AA	# <CJK>
0xC1A1	0x8584	# <CJK>
0xC1A2	0x857E	# <CJK>
0xC1A3	0x859C	# <CJK>
0xC1A4	0x8591	# <CJK>
0xC1A5	0x8594	# <CJK>
0xC1A6	0x85AF	# <CJK>
0xC1A7	0x859B	# <CJK>
0xC1A8	0x8587	# <CJK>
0xC1A9	0x85A8	# <CJK>
0xC1AA	0x858A	# <CJK>
0xC1AB	0x8667	# <CJK>
0xC1AC	0x87C0	# <CJK>
0xC1AD	0x87D1	# <CJK>
0xC1AE	0x87B3	# <CJK>
0xC1AF	0x87D2	# <CJK>
0xC1B0	0x87C6	# <CJK>
0xC1B1	0x87AB	# <CJK>
0xC1B2	0x87BB	# <CJK>
0xC1B3	0x87BA	# <CJK>
0xC1B4	0x87C8	# <CJK>
0xC1B5	0x87CB	# <CJK>
0xC1B6	0x893B	# <CJK>
0xC1B7	0x8936	# <CJK>
0xC1B8	0x8944	# <CJK>
0xC1B9	0x8938	# <CJK>
0xC1BA	0x893D	# <CJK>
0xC1BB	0x89AC	# <CJK>
0xC1BC	0x8B0E	# <CJK>
0xC1BD	0x8B17	# <CJK>
0xC1BE	0x8B19	# <CJK>
0xC1BF	0x8B1B	# <CJK>
0xC1C0	0x8B0A	# <CJK>
0xC1C1	0x8B20	# <CJK>
0xC1C2	0x8B1D	# <CJK>
0xC1C3	0x8B04	# <CJK>
0xC1C4	0x8B10	# <CJK>
0xC1C5	0x8C41	# <CJK>
0xC1C6	0x8C3F	# <CJK>
0xC1C7	0x8C73	# <CJK>
0xC1C8	0x8CFA	# <CJK>
0xC1C9	0x8CFD	# <CJK>
0xC1CA	0x8CFC	# <CJK>
0xC1CB	0x8CF8	# <CJK>
0xC1CC	0x8CFB	# <CJK>
0xC1CD	0x8DA8	# <CJK>
0xC1CE	0x8E49	# <CJK>
0xC1CF	0x8E4B	# <CJK>
0xC1D0	0x8E48	# <CJK>
0xC1D1	0x8E4A	# <CJK>
0xC1D2	0x8F44	# <CJK>
0xC1D3	0x8F3E	# <CJK>
0xC1D4	0x8F42	# <CJK>
0xC1D5	0x8F45	# <CJK>
0xC1D6	0x8F3F	# <CJK>
0xC1D7	0x907F	# <CJK>
0xC1D8	0x907D	# <CJK>
0xC1D9	0x9084	# <CJK>
0xC1DA	0x9081	# <CJK>
0xC1DB	0x9082	# <CJK>
0xC1DC	0x9080	# <CJK>
0xC1DD	0x9139	# <CJK>
0xC1DE	0x91A3	# <CJK>
0xC1DF	0x919E	# <CJK>
0xC1E0	0x919C	# <CJK>
0xC1E1	0x934D	# <CJK>
0xC1E2	0x9382	# <CJK>
0xC1E3	0x9328	# <CJK>
0xC1E4	0x9375	# <CJK>
0xC1E5	0x934A	# <CJK>
0xC1E6	0x9365	# <CJK>
0xC1E7	0x934B	# <CJK>
0xC1E8	0x9318	# <CJK>
0xC1E9	0x937E	# <CJK>
0xC1EA	0x936C	# <CJK>
0xC1EB	0x935B	# <CJK>
0xC1EC	0x9370	# <CJK>
0xC1ED	0x935A	# <CJK>
0xC1EE	0x9354	# <CJK>
0xC1EF	0x95CA	# <CJK>
0xC1F0	0x95CB	# <CJK>
0xC1F1	0x95CC	# <CJK>
0xC1F2	0x95C8	# <CJK>
0xC1F3	0x95C6	# <CJK>
0xC1F4	0x96B1	# <CJK>
0xC1F5	0x96B8	# <CJK>
0xC1F6	0x96D6	# <CJK>
0xC1F7	0x971C	# <CJK>
0xC1F8	0x971E	# <CJK>
0xC1F9	0x97A0	# <CJK>
0xC1FA	0x97D3	# <CJK>
0xC1FB	0x9846	# <CJK>
0xC1FC	0x98B6	# <CJK>
0xC1FD	0x9935	# <CJK>
0xC1FE	0x9A01	# <CJK>
0xC240	0x99FF	# <CJK>
0xC241	0x9BAE	# <CJK>
0xC242	0x9BAB	# <CJK>
0xC243	0x9BAA	# <CJK>
0xC244	0x9BAD	# <CJK>
0xC245	0x9D3B	# <CJK>
0xC246	0x9D3F	# <CJK>
0xC247	0x9E8B	# <CJK>
0xC248	0x9ECF	# <CJK>
0xC249	0x9EDE	# <CJK>
0xC24A	0x9EDC	# <CJK>
0xC24B	0x9EDD	# <CJK>
0xC24C	0x9EDB	# <CJK>
0xC24D	0x9F3E	# <CJK>
0xC24E	0x9F4B	# <CJK>
0xC24F	0x53E2	# <CJK>
0xC250	0x5695	# <CJK>
0xC251	0x56AE	# <CJK>
0xC252	0x58D9	# <CJK>
0xC253	0x58D8	# <CJK>
0xC254	0x5B38	# <CJK>
0xC255	0x5F5D	# <CJK>
0xC256	0x61E3	# <CJK>
0xC257	0x6233	# <CJK>
0xC258	0x64F4	# <CJK>
0xC259	0x64F2	# <CJK>
0xC25A	0x64FE	# <CJK>
0xC25B	0x6506	# <CJK>
0xC25C	0x64FA	# <CJK>
0xC25D	0x64FB	# <CJK>
0xC25E	0x64F7	# <CJK>
0xC25F	0x65B7	# <CJK>
0xC260	0x66DC	# <CJK>
0xC261	0x6726	# <CJK>
0xC262	0x6AB3	# <CJK>
0xC263	0x6AAC	# <CJK>
0xC264	0x6AC3	# <CJK>
0xC265	0x6ABB	# <CJK>
0xC266	0x6AB8	# <CJK>
0xC267	0x6AC2	# <CJK>
0xC268	0x6AAE	# <CJK>
0xC269	0x6AAF	# <CJK>
0xC26A	0x6B5F	# <CJK>
0xC26B	0x6B78	# <CJK>
0xC26C	0x6BAF	# <CJK>
0xC26D	0x7009	# <CJK>
0xC26E	0x700B	# <CJK>
0xC26F	0x6FFE	# <CJK>
0xC270	0x7006	# <CJK>
0xC271	0x6FFA	# <CJK>
0xC272	0x7011	# <CJK>
0xC273	0x700F	# <CJK>
0xC274	0x71FB	# <CJK>
0xC275	0x71FC	# <CJK>
0xC276	0x71FE	# <CJK>
0xC277	0x71F8	# <CJK>
0xC278	0x7377	# <CJK>
0xC279	0x7375	# <CJK>
0xC27A	0x74A7	# <CJK>
0xC27B	0x74BF	# <CJK>
0xC27C	0x7515	# <CJK>
0xC27D	0x7656	# <CJK>
0xC27E	0x7658	# <CJK>
0xC2A1	0x7652	# <CJK>
0xC2A2	0x77BD	# <CJK>
0xC2A3	0x77BF	# <CJK>
0xC2A4	0x77BB	# <CJK>
0xC2A5	0x77BC	# <CJK>
0xC2A6	0x790E	# <CJK>
0xC2A7	0x79AE	# <CJK>
0xC2A8	0x7A61	# <CJK>
0xC2A9	0x7A62	# <CJK>
0xC2AA	0x7A60	# <CJK>
0xC2AB	0x7AC4	# <CJK>
0xC2AC	0x7AC5	# <CJK>
0xC2AD	0x7C2B	# <CJK>
0xC2AE	0x7C27	# <CJK>
0xC2AF	0x7C2A	# <CJK>
0xC2B0	0x7C1E	# <CJK>
0xC2B1	0x7C23	# <CJK>
0xC2B2	0x7C21	# <CJK>
0xC2B3	0x7CE7	# <CJK>
0xC2B4	0x7E54	# <CJK>
0xC2B5	0x7E55	# <CJK>
0xC2B6	0x7E5E	# <CJK>
0xC2B7	0x7E5A	# <CJK>
0xC2B8	0x7E61	# <CJK>
0xC2B9	0x7E52	# <CJK>
0xC2BA	0x7E59	# <CJK>
0xC2BB	0x7F48	# <CJK>
0xC2BC	0x7FF9	# <CJK>
0xC2BD	0x7FFB	# <CJK>
0xC2BE	0x8077	# <CJK>
0xC2BF	0x8076	# <CJK>
0xC2C0	0x81CD	# <CJK>
0xC2C1	0x81CF	# <CJK>
0xC2C2	0x820A	# <CJK>
0xC2C3	0x85CF	# <CJK>
0xC2C4	0x85A9	# <CJK>
0xC2C5	0x85CD	# <CJK>
0xC2C6	0x85D0	# <CJK>
0xC2C7	0x85C9	# <CJK>
0xC2C8	0x85B0	# <CJK>
0xC2C9	0x85BA	# <CJK>
0xC2CA	0x85B9	# <CJK>
0xC2CB	0x85A6	# <CJK>
0xC2CC	0x87EF	# <CJK>
0xC2CD	0x87EC	# <CJK>
0xC2CE	0x87F2	# <CJK>
0xC2CF	0x87E0	# <CJK>
0xC2D0	0x8986	# <CJK>
0xC2D1	0x89B2	# <CJK>
0xC2D2	0x89F4	# <CJK>
0xC2D3	0x8B28	# <CJK>
0xC2D4	0x8B39	# <CJK>
0xC2D5	0x8B2C	# <CJK>
0xC2D6	0x8B2B	# <CJK>
0xC2D7	0x8C50	# <CJK>
0xC2D8	0x8D05	# <CJK>
0xC2D9	0x8E59	# <CJK>
0xC2DA	0x8E63	# <CJK>
0xC2DB	0x8E66	# <CJK>
0xC2DC	0x8E64	# <CJK>
0xC2DD	0x8E5F	# <CJK>
0xC2DE	0x8E55	# <CJK>
0xC2DF	0x8EC0	# <CJK>
0xC2E0	0x8F49	# <CJK>
0xC2E1	0x8F4D	# <CJK>
0xC2E2	0x9087	# <CJK>
0xC2E3	0x9083	# <CJK>
0xC2E4	0x9088	# <CJK>
0xC2E5	0x91AB	# <CJK>
0xC2E6	0x91AC	# <CJK>
0xC2E7	0x91D0	# <CJK>
0xC2E8	0x9394	# <CJK>
0xC2E9	0x938A	# <CJK>
0xC2EA	0x9396	# <CJK>
0xC2EB	0x93A2	# <CJK>
0xC2EC	0x93B3	# <CJK>
0xC2ED	0x93AE	# <CJK>
0xC2EE	0x93AC	# <CJK>
0xC2EF	0x93B0	# <CJK>
0xC2F0	0x9398	# <CJK>
0xC2F1	0x939A	# <CJK>
0xC2F2	0x9397	# <CJK>
0xC2F3	0x95D4	# <CJK>
0xC2F4	0x95D6	# <CJK>
0xC2F5	0x95D0	# <CJK>
0xC2F6	0x95D5	# <CJK>
0xC2F7	0x96E2	# <CJK>
0xC2F8	0x96DC	# <CJK>
0xC2F9	0x96D9	# <CJK>
0xC2FA	0x96DB	# <CJK>
0xC2FB	0x96DE	# <CJK>
0xC2FC	0x9724	# <CJK>
0xC2FD	0x97A3	# <CJK>
0xC2FE	0x97A6	# <CJK>
0xC340	0x97AD	# <CJK>
0xC341	0x97F9	# <CJK>
0xC342	0x984D	# <CJK>
0xC343	0x984F	# <CJK>
0xC344	0x984C	# <CJK>
0xC345	0x984E	# <CJK>
0xC346	0x9853	# <CJK>
0xC347	0x98BA	# <CJK>
0xC348	0x993E	# <CJK>
0xC349	0x993F	# <CJK>
0xC34A	0x993D	# <CJK>
0xC34B	0x992E	# <CJK>
0xC34C	0x99A5	# <CJK>
0xC34D	0x9A0E	# <CJK>
0xC34E	0x9AC1	# <CJK>
0xC34F	0x9B03	# <CJK>
0xC350	0x9B06	# <CJK>
0xC351	0x9B4F	# <CJK>
0xC352	0x9B4E	# <CJK>
0xC353	0x9B4D	# <CJK>
0xC354	0x9BCA	# <CJK>
0xC355	0x9BC9	# <CJK>
0xC356	0x9BFD	# <CJK>
0xC357	0x9BC8	# <CJK>
0xC358	0x9BC0	# <CJK>
0xC359	0x9D51	# <CJK>
0xC35A	0x9D5D	# <CJK>
0xC35B	0x9D60	# <CJK>
0xC35C	0x9EE0	# <CJK>
0xC35D	0x9F15	# <CJK>
0xC35E	0x9F2C	# <CJK>
0xC35F	0x5133	# <CJK>
0xC360	0x56A5	# <CJK>
0xC361	0x58DE	# <CJK>
0xC362	0x58DF	# <CJK>
0xC363	0x58E2	# <CJK>
0xC364	0x5BF5	# <CJK>
0xC365	0x9F90	# <CJK>
0xC366	0x5EEC	# <CJK>
0xC367	0x61F2	# <CJK>
0xC368	0x61F7	# <CJK>
0xC369	0x61F6	# <CJK>
0xC36A	0x61F5	# <CJK>
0xC36B	0x6500	# <CJK>
0xC36C	0x650F	# <CJK>
0xC36D	0x66E0	# <CJK>
0xC36E	0x66DD	# <CJK>
0xC36F	0x6AE5	# <CJK>
0xC370	0x6ADD	# <CJK>
0xC371	0x6ADA	# <CJK>
0xC372	0x6AD3	# <CJK>
0xC373	0x701B	# <CJK>
0xC374	0x701F	# <CJK>
0xC375	0x7028	# <CJK>
0xC376	0x701A	# <CJK>
0xC377	0x701D	# <CJK>
0xC378	0x7015	# <CJK>
0xC379	0x7018	# <CJK>
0xC37A	0x7206	# <CJK>
0xC37B	0x720D	# <CJK>
0xC37C	0x7258	# <CJK>
0xC37D	0x72A2	# <CJK>
0xC37E	0x7378	# <CJK>
0xC3A1	0x737A	# <CJK>
0xC3A2	0x74BD	# <CJK>
0xC3A3	0x74CA	# <CJK>
0xC3A4	0x74E3	# <CJK>
0xC3A5	0x7587	# <CJK>
0xC3A6	0x7586	# <CJK>
0xC3A7	0x765F	# <CJK>
0xC3A8	0x7661	# <CJK>
0xC3A9	0x77C7	# <CJK>
0xC3AA	0x7919	# <CJK>
0xC3AB	0x79B1	# <CJK>
0xC3AC	0x7A6B	# <CJK>
0xC3AD	0x7A69	# <CJK>
0xC3AE	0x7C3E	# <CJK>
0xC3AF	0x7C3F	# <CJK>
0xC3B0	0x7C38	# <CJK>
0xC3B1	0x7C3D	# <CJK>
0xC3B2	0x7C37	# <CJK>
0xC3B3	0x7C40	# <CJK>
0xC3B4	0x7E6B	# <CJK>
0xC3B5	0x7E6D	# <CJK>
0xC3B6	0x7E79	# <CJK>
0xC3B7	0x7E69	# <CJK>
0xC3B8	0x7E6A	# <CJK>
0xC3B9	0x7F85	# <CJK>
0xC3BA	0x7E73	# <CJK>
0xC3BB	0x7FB6	# <CJK>
0xC3BC	0x7FB9	# <CJK>
0xC3BD	0x7FB8	# <CJK>
0xC3BE	0x81D8	# <CJK>
0xC3BF	0x85E9	# <CJK>
0xC3C0	0x85DD	# <CJK>
0xC3C1	0x85EA	# <CJK>
0xC3C2	0x85D5	# <CJK>
0xC3C3	0x85E4	# <CJK>
0xC3C4	0x85E5	# <CJK>
0xC3C5	0x85F7	# <CJK>
0xC3C6	0x87FB	# <CJK>
0xC3C7	0x8805	# <CJK>
0xC3C8	0x880D	# <CJK>
0xC3C9	0x87F9	# <CJK>
0xC3CA	0x87FE	# <CJK>
0xC3CB	0x8960	# <CJK>
0xC3CC	0x895F	# <CJK>
0xC3CD	0x8956	# <CJK>
0xC3CE	0x895E	# <CJK>
0xC3CF	0x8B41	# <CJK>
0xC3D0	0x8B5C	# <CJK>
0xC3D1	0x8B58	# <CJK>
0xC3D2	0x8B49	# <CJK>
0xC3D3	0x8B5A	# <CJK>
0xC3D4	0x8B4E	# <CJK>
0xC3D5	0x8B4F	# <CJK>
0xC3D6	0x8B46	# <CJK>
0xC3D7	0x8B59	# <CJK>
0xC3D8	0x8D08	# <CJK>
0xC3D9	0x8D0A	# <CJK>
0xC3DA	0x8E7C	# <CJK>
0xC3DB	0x8E72	# <CJK>
0xC3DC	0x8E87	# <CJK>
0xC3DD	0x8E76	# <CJK>
0xC3DE	0x8E6C	# <CJK>
0xC3DF	0x8E7A	# <CJK>
0xC3E0	0x8E74	# <CJK>
0xC3E1	0x8F54	# <CJK>
0xC3E2	0x8F4E	# <CJK>
0xC3E3	0x8FAD	# <CJK>
0xC3E4	0x908A	# <CJK>
0xC3E5	0x908B	# <CJK>
0xC3E6	0x91B1	# <CJK>
0xC3E7	0x91AE	# <CJK>
0xC3E8	0x93E1	# <CJK>
0xC3E9	0x93D1	# <CJK>
0xC3EA	0x93DF	# <CJK>
0xC3EB	0x93C3	# <CJK>
0xC3EC	0x93C8	# <CJK>
0xC3ED	0x93DC	# <CJK>
0xC3EE	0x93DD	# <CJK>
0xC3EF	0x93D6	# <CJK>
0xC3F0	0x93E2	# <CJK>
0xC3F1	0x93CD	# <CJK>
0xC3F2	0x93D8	# <CJK>
0xC3F3	0x93E4	# <CJK>
0xC3F4	0x93D7	# <CJK>
0xC3F5	0x93E8	# <CJK>
0xC3F6	0x95DC	# <CJK>
0xC3F7	0x96B4	# <CJK>
0xC3F8	0x96E3	# <CJK>
0xC3F9	0x972A	# <CJK>
0xC3FA	0x9727	# <CJK>
0xC3FB	0x9761	# <CJK>
0xC3FC	0x97DC	# <CJK>
0xC3FD	0x97FB	# <CJK>
0xC3FE	0x985E	# <CJK>
0xC440	0x9858	# <CJK>
0xC441	0x985B	# <CJK>
0xC442	0x98BC	# <CJK>
0xC443	0x9945	# <CJK>
0xC444	0x9949	# <CJK>
0xC445	0x9A16	# <CJK>
0xC446	0x9A19	# <CJK>
0xC447	0x9B0D	# <CJK>
0xC448	0x9BE8	# <CJK>
0xC449	0x9BE7	# <CJK>
0xC44A	0x9BD6	# <CJK>
0xC44B	0x9BDB	# <CJK>
0xC44C	0x9D89	# <CJK>
0xC44D	0x9D61	# <CJK>
0xC44E	0x9D72	# <CJK>
0xC44F	0x9D6A	# <CJK>
0xC450	0x9D6C	# <CJK>
0xC451	0x9E92	# <CJK>
0xC452	0x9E97	# <CJK>
0xC453	0x9E93	# <CJK>
0xC454	0x9EB4	# <CJK>
0xC455	0x52F8	# <CJK>
0xC456	0x56A8	# <CJK>
0xC457	0x56B7	# <CJK>
0xC458	0x56B6	# <CJK>
0xC459	0x56B4	# <CJK>
0xC45A	0x56BC	# <CJK>
0xC45B	0x58E4	# <CJK>
0xC45C	0x5B40	# <CJK>
0xC45D	0x5B43	# <CJK>
0xC45E	0x5B7D	# <CJK>
0xC45F	0x5BF6	# <CJK>
0xC460	0x5DC9	# <CJK>
0xC461	0x61F8	# <CJK>
0xC462	0x61FA	# <CJK>
0xC463	0x6518	# <CJK>
0xC464	0x6514	# <CJK>
0xC465	0x6519	# <CJK>
0xC466	0x66E6	# <CJK>
0xC467	0x6727	# <CJK>
0xC468	0x6AEC	# <CJK>
0xC469	0x703E	# <CJK>
0xC46A	0x7030	# <CJK>
0xC46B	0x7032	# <CJK>
0xC46C	0x7210	# <CJK>
0xC46D	0x737B	# <CJK>
0xC46E	0x74CF	# <CJK>
0xC46F	0x7662	# <CJK>
0xC470	0x7665	# <CJK>
0xC471	0x7926	# <CJK>
0xC472	0x792A	# <CJK>
0xC473	0x792C	# <CJK>
0xC474	0x792B	# <CJK>
0xC475	0x7AC7	# <CJK>
0xC476	0x7AF6	# <CJK>
0xC477	0x7C4C	# <CJK>
0xC478	0x7C43	# <CJK>
0xC479	0x7C4D	# <CJK>
0xC47A	0x7CEF	# <CJK>
0xC47B	0x7CF0	# <CJK>
0xC47C	0x8FAE	# <CJK>
0xC47D	0x7E7D	# <CJK>
0xC47E	0x7E7C	# <CJK>
0xC4A1	0x7E82	# <CJK>
0xC4A2	0x7F4C	# <CJK>
0xC4A3	0x8000	# <CJK>
0xC4A4	0x81DA	# <CJK>
0xC4A5	0x8266	# <CJK>
0xC4A6	0x85FB	# <CJK>
0xC4A7	0x85F9	# <CJK>
0xC4A8	0x8611	# <CJK>
0xC4A9	0x85FA	# <CJK>
0xC4AA	0x8606	# <CJK>
0xC4AB	0x860B	# <CJK>
0xC4AC	0x8607	# <CJK>
0xC4AD	0x860A	# <CJK>
0xC4AE	0x8814	# <CJK>
0xC4AF	0x8815	# <CJK>
0xC4B0	0x8964	# <CJK>
0xC4B1	0x89BA	# <CJK>
0xC4B2	0x89F8	# <CJK>
0xC4B3	0x8B70	# <CJK>
0xC4B4	0x8B6C	# <CJK>
0xC4B5	0x8B66	# <CJK>
0xC4B6	0x8B6F	# <CJK>
0xC4B7	0x8B5F	# <CJK>
0xC4B8	0x8B6B	# <CJK>
0xC4B9	0x8D0F	# <CJK>
0xC4BA	0x8D0D	# <CJK>
0xC4BB	0x8E89	# <CJK>
0xC4BC	0x8E81	# <CJK>
0xC4BD	0x8E85	# <CJK>
0xC4BE	0x8E82	# <CJK>
0xC4BF	0x91B4	# <CJK>
0xC4C0	0x91CB	# <CJK>
0xC4C1	0x9418	# <CJK>
0xC4C2	0x9403	# <CJK>
0xC4C3	0x93FD	# <CJK>
0xC4C4	0x95E1	# <CJK>
0xC4C5	0x9730	# <CJK>
0xC4C6	0x98C4	# <CJK>
0xC4C7	0x9952	# <CJK>
0xC4C8	0x9951	# <CJK>
0xC4C9	0x99A8	# <CJK>
0xC4CA	0x9A2B	# <CJK>
0xC4CB	0x9A30	# <CJK>
0xC4CC	0x9A37	# <CJK>
0xC4CD	0x9A35	# <CJK>
0xC4CE	0x9C13	# <CJK>
0xC4CF	0x9C0D	# <CJK>
0xC4D0	0x9E79	# <CJK>
0xC4D1	0x9EB5	# <CJK>
0xC4D2	0x9EE8	# <CJK>
0xC4D3	0x9F2F	# <CJK>
0xC4D4	0x9F5F	# <CJK>
0xC4D5	0x9F63	# <CJK>
0xC4D6	0x9F61	# <CJK>
0xC4D7	0x5137	# <CJK>
0xC4D8	0x5138	# <CJK>
0xC4D9	0x56C1	# <CJK>
0xC4DA	0x56C0	# <CJK>
0xC4DB	0x56C2	# <CJK>
0xC4DC	0x5914	# <CJK>
0xC4DD	0x5C6C	# <CJK>
0xC4DE	0x5DCD	# <CJK>
0xC4DF	0x61FC	# <CJK>
0xC4E0	0x61FE	# <CJK>
0xC4E1	0x651D	# <CJK>
0xC4E2	0x651C	# <CJK>
0xC4E3	0x6595	# <CJK>
0xC4E4	0x66E9	# <CJK>
0xC4E5	0x6AFB	# <CJK>
0xC4E6	0x6B04	# <CJK>
0xC4E7	0x6AFA	# <CJK>
0xC4E8	0x6BB2	# <CJK>
0xC4E9	0x704C	# <CJK>
0xC4EA	0x721B	# <CJK>
0xC4EB	0x72A7	# <CJK>
0xC4EC	0x74D6	# <CJK>
0xC4ED	0x74D4	# <CJK>
0xC4EE	0x7669	# <CJK>
0xC4EF	0x77D3	# <CJK>
0xC4F0	0x7C50	# <CJK>
0xC4F1	0x7E8F	# <CJK>
0xC4F2	0x7E8C	# <CJK>
0xC4F3	0x7FBC	# <CJK>
0xC4F4	0x8617	# <CJK>
0xC4F5	0x862D	# <CJK>
0xC4F6	0x861A	# <CJK>
0xC4F7	0x8823	# <CJK>
0xC4F8	0x8822	# <CJK>
0xC4F9	0x8821	# <CJK>
0xC4FA	0x881F	# <CJK>
0xC4FB	0x896A	# <CJK>
0xC4FC	0x896C	# <CJK>
0xC4FD	0x89BD	# <CJK>
0xC4FE	0x8B74	# <CJK>
0xC540	0x8B77	# <CJK>
0xC541	0x8B7D	# <CJK>
0xC542	0x8D13	# <CJK>
0xC543	0x8E8A	# <CJK>
0xC544	0x8E8D	# <CJK>
0xC545	0x8E8B	# <CJK>
0xC546	0x8F5F	# <CJK>
0xC547	0x8FAF	# <CJK>
0xC548	0x91BA	# <CJK>
0xC549	0x942E	# <CJK>
0xC54A	0x9433	# <CJK>
0xC54B	0x9435	# <CJK>
0xC54C	0x943A	# <CJK>
0xC54D	0x9438	# <CJK>
0xC54E	0x9432	# <CJK>
0xC54F	0x942B	# <CJK>
0xC550	0x95E2	# <CJK>
0xC551	0x9738	# <CJK>
0xC552	0x9739	# <CJK>
0xC553	0x9732	# <CJK>
0xC554	0x97FF	# <CJK>
0xC555	0x9867	# <CJK>
0xC556	0x9865	# <CJK>
0xC557	0x9957	# <CJK>
0xC558	0x9A45	# <CJK>
0xC559	0x9A43	# <CJK>
0xC55A	0x9A40	# <CJK>
0xC55B	0x9A3E	# <CJK>
0xC55C	0x9ACF	# <CJK>
0xC55D	0x9B54	# <CJK>
0xC55E	0x9B51	# <CJK>
0xC55F	0x9C2D	# <CJK>
0xC560	0x9C25	# <CJK>
0xC561	0x9DAF	# <CJK>
0xC562	0x9DB4	# <CJK>
0xC563	0x9DC2	# <CJK>
0xC564	0x9DB8	# <CJK>
0xC565	0x9E9D	# <CJK>
0xC566	0x9EEF	# <CJK>
0xC567	0x9F19	# <CJK>
0xC568	0x9F5C	# <CJK>
0xC569	0x9F66	# <CJK>
0xC56A	0x9F67	# <CJK>
0xC56B	0x513C	# <CJK>
0xC56C	0x513B	# <CJK>
0xC56D	0x56C8	# <CJK>
0xC56E	0x56CA	# <CJK>
0xC56F	0x56C9	# <CJK>
0xC570	0x5B7F	# <CJK>
0xC571	0x5DD4	# <CJK>
0xC572	0x5DD2	# <CJK>
0xC573	0x5F4E	# <CJK>
0xC574	0x61FF	# <CJK>
0xC575	0x6524	# <CJK>
0xC576	0x6B0A	# <CJK>
0xC577	0x6B61	# <CJK>
0xC578	0x7051	# <CJK>
0xC579	0x7058	# <CJK>
0xC57A	0x7380	# <CJK>
0xC57B	0x74E4	# <CJK>
0xC57C	0x758A	# <CJK>
0xC57D	0x766E	# <CJK>
0xC57E	0x766C	# <CJK>
0xC5A1	0x79B3	# <CJK>
0xC5A2	0x7C60	# <CJK>
0xC5A3	0x7C5F	# <CJK>
0xC5A4	0x807E	# <CJK>
0xC5A5	0x807D	# <CJK>
0xC5A6	0x81DF	# <CJK>
0xC5A7	0x8972	# <CJK>
0xC5A8	0x896F	# <CJK>
0xC5A9	0x89FC	# <CJK>
0xC5AA	0x8B80	# <CJK>
0xC5AB	0x8D16	# <CJK>
0xC5AC	0x8D17	# <CJK>
0xC5AD	0x8E91	# <CJK>
0xC5AE	0x8E93	# <CJK>
0xC5AF	0x8F61	# <CJK>
0xC5B0	0x9148	# <CJK>
0xC5B1	0x9444	# <CJK>
0xC5B2	0x9451	# <CJK>
0xC5B3	0x9452	# <CJK>
0xC5B4	0x973D	# <CJK>
0xC5B5	0x973E	# <CJK>
0xC5B6	0x97C3	# <CJK>
0xC5B7	0x97C1	# <CJK>
0xC5B8	0x986B	# <CJK>
0xC5B9	0x9955	# <CJK>
0xC5BA	0x9A55	# <CJK>
0xC5BB	0x9A4D	# <CJK>
0xC5BC	0x9AD2	# <CJK>
0xC5BD	0x9B1A	# <CJK>
0xC5BE	0x9C49	# <CJK>
0xC5BF	0x9C31	# <CJK>
0xC5C0	0x9C3E	# <CJK>
0xC5C1	0x9C3B	# <CJK>
0xC5C2	0x9DD3	# <CJK>
0xC5C3	0x9DD7	# <CJK>
0xC5C4	0x9F34	# <CJK>
0xC5C5	0x9F6C	# <CJK>
0xC5C6	0x9F6A	# <CJK>
0xC5C7	0x9F94	# <CJK>
0xC5C8	0x56CC	# <CJK>
0xC5C9	0x5DD6	# <CJK>
0xC5CA	0x6200	# <CJK>
0xC5CB	0x6523	# <CJK>
0xC5CC	0x652B	# <CJK>
0xC5CD	0x652A	# <CJK>
0xC5CE	0x66EC	# <CJK>
0xC5CF	0x6B10	# <CJK>
0xC5D0	0x74DA	# <CJK>
0xC5D1	0x7ACA	# <CJK>
0xC5D2	0x7C64	# <CJK>
0xC5D3	0x7C63	# <CJK>
0xC5D4	0x7C65	# <CJK>
0xC5D5	0x7E93	# <CJK>
0xC5D6	0x7E96	# <CJK>
0xC5D7	0x7E94	# <CJK>
0xC5D8	0x81E2	# <CJK>
0xC5D9	0x8638	# <CJK>
0xC5DA	0x863F	# <CJK>
0xC5DB	0x8831	# <CJK>
0xC5DC	0x8B8A	# <CJK>
0xC5DD	0x9090	# <CJK>
0xC5DE	0x908F	# <CJK>
0xC5DF	0x9463	# <CJK>
0xC5E0	0x9460	# <CJK>
0xC5E1	0x9464	# <CJK>
0xC5E2	0x9768	# <CJK>
0xC5E3	0x986F	# <CJK>
0xC5E4	0x995C	# <CJK>
0xC5E5	0x9A5A	# <CJK>
0xC5E6	0x9A5B	# <CJK>
0xC5E7	0x9A57	# <CJK>
0xC5E8	0x9AD3	# <CJK>
0xC5E9	0x9AD4	# <CJK>
0xC5EA	0x9AD1	# <CJK>
0xC5EB	0x9C54	# <CJK>
0xC5EC	0x9C57	# <CJK>
0xC5ED	0x9C56	# <CJK>
0xC5EE	0x9DE5	# <CJK>
0xC5EF	0x9E9F	# <CJK>
0xC5F0	0x9EF4	# <CJK>
0xC5F1	0x56D1	# <CJK>
0xC5F2	0x58E9	# <CJK>
0xC5F3	0x652C	# <CJK>
0xC5F4	0x705E	# <CJK>
0xC5F5	0x7671	# <CJK>
0xC5F6	0x7672	# <CJK>
0xC5F7	0x77D7	# <CJK>
0xC5F8	0x7F50	# <CJK>
0xC5F9	0x7F88	# <CJK>
0xC5FA	0x8836	# <CJK>
0xC5FB	0x8839	# <CJK>
0xC5FC	0x8862	# <CJK>
0xC5FD	0x8B93	# <CJK>
0xC5FE	0x8B92	# <CJK>
0xC640	0x8B96	# <CJK>
0xC641	0x8277	# <CJK>
0xC642	0x8D1B	# <CJK>
0xC643	0x91C0	# <CJK>
0xC644	0x946A	# <CJK>
0xC645	0x9742	# <CJK>
0xC646	0x9748	# <CJK>
0xC647	0x9744	# <CJK>
0xC648	0x97C6	# <CJK>
0xC649	0x9870	# <CJK>
0xC64A	0x9A5F	# <CJK>
0xC64B	0x9B22	# <CJK>
0xC64C	0x9B58	# <CJK>
0xC64D	0x9C5F	# <CJK>
0xC64E	0x9DF9	# <CJK>
0xC64F	0x9DFA	# <CJK>
0xC650	0x9E7C	# <CJK>
0xC651	0x9E7D	# <CJK>
0xC652	0x9F07	# <CJK>
0xC653	0x9F77	# <CJK>
0xC654	0x9F72	# <CJK>
0xC655	0x5EF3	# <CJK>
0xC656	0x6B16	# <CJK>
0xC657	0x7063	# <CJK>
0xC658	0x7C6C	# <CJK>
0xC659	0x7C6E	# <CJK>
0xC65A	0x883B	# <CJK>
0xC65B	0x89C0	# <CJK>
0xC65C	0x8EA1	# <CJK>
0xC65D	0x91C1	# <CJK>
0xC65E	0x9472	# <CJK>
0xC65F	0x9470	# <CJK>
0xC660	0x9871	# <CJK>
0xC661	0x995E	# <CJK>
0xC662	0x9AD6	# <CJK>
0xC663	0x9B23	# <CJK>
0xC664	0x9ECC	# <CJK>
0xC665	0x7064	# <CJK>
0xC666	0x77DA	# <CJK>
0xC667	0x8B9A	# <CJK>
0xC668	0x9477	# <CJK>
0xC669	0x97C9	# <CJK>
0xC66A	0x9A62	# <CJK>
0xC66B	0x9A65	# <CJK>
0xC66C	0x7E9C	# <CJK>
0xC66D	0x8B9C	# <CJK>
0xC66E	0x8EAA	# <CJK>
0xC66F	0x91C5	# <CJK>
0xC670	0x947D	# <CJK>
0xC671	0x947E	# <CJK>
0xC672	0x947C	# <CJK>
0xC673	0x9C77	# <CJK>
0xC674	0x9C78	# <CJK>
0xC675	0x9EF7	# <CJK>
0xC676	0x8C54	# <CJK>
0xC677	0x947F	# <CJK>
0xC678	0x9E1A	# <CJK>
0xC679	0x7228	# <CJK>
0xC67A	0x9A6A	# <CJK>
0xC67B	0x9B31	# <CJK>
0xC67C	0x9E1B	# <CJK>
0xC67D	0x9E1E	# <CJK>
0xC67E	0x7C72	# <CJK>
0xC6A1	0x30FE	# KATAKANA VOICED ITERATION MARK
0xC6A2	0x309D	# HIRAGANA ITERATION MARK
0xC6A3	0x309E	# HIRAGANA VOICED ITERATION MARK
0xC6A4	0x3005	# IDEOGRAPHIC ITERATION MARK
0xC6A5	0x3041	# HIRAGANA LETTER SMALL A
0xC6A6	0x3042	# HIRAGANA LETTER A
0xC6A7	0x3043	# HIRAGANA LETTER SMALL I
0xC6A8	0x3044	# HIRAGANA LETTER I
0xC6A9	0x3045	# HIRAGANA LETTER SMALL U
0xC6AA	0x3046	# HIRAGANA LETTER U
0xC6AB	0x3047	# HIRAGANA LETTER SMALL E
0xC6AC	0x3048	# HIRAGANA LETTER E
0xC6AD	0x3049	# HIRAGANA LETTER SMALL O
0xC6AE	0x304A	# HIRAGANA LETTER O
0xC6AF	0x304B	# HIRAGANA LETTER KA
0xC6B0	0x304C	# HIRAGANA LETTER GA
0xC6B1	0x304D	# HIRAGANA LETTER KI
0xC6B2	0x304E	# HIRAGANA LETTER GI
0xC6B3	0x304F	# HIRAGANA LETTER KU
0xC6B4	0x3050	# HIRAGANA LETTER GU
0xC6B5	0x3051	# HIRAGANA LETTER KE
0xC6B6	0x3052	# HIRAGANA LETTER GE
0xC6B7	0x3053	# HIRAGANA LETTER KO
0xC6B8	0x3054	# HIRAGANA LETTER GO
0xC6B9	0x3055	# HIRAGANA LETTER SA
0xC6BA	0x3056	# HIRAGANA LETTER ZA
0xC6BB	0x3057	# HIRAGANA LETTER SI
0xC6BC	0x3058	# HIRAGANA LETTER ZI
0xC6BD	0x3059	# HIRAGANA LETTER SU
0xC6BE	0x305A	# HIRAGANA LETTER ZU
0xC6BF	0x305B	# HIRAGANA LETTER SE
0xC6C0	0x305C	# HIRAGANA LETTER ZE
0xC6C1	0x305D	# HIRAGANA LETTER SO
0xC6C2	0x305E	# HIRAGANA LETTER ZO
0xC6C3	0x305F	# HIRAGANA LETTER TA
0xC6C4	0x3060	# HIRAGANA LETTER DA
0xC6C5	0x3061	# HIRAGANA LETTER TI
0xC6C6	0x3062	# HIRAGANA LETTER DI
0xC6C7	0x3063	# HIRAGANA LETTER SMALL TU
0xC6C8	0x3064	# HIRAGANA LETTER TU
0xC6C9	0x3065	# HIRAGANA LETTER DU
0xC6CA	0x3066	# HIRAGANA LETTER TE
0xC6CB	0x3067	# HIRAGANA LETTER DE
0xC6CC	0x3068	# HIRAGANA LETTER TO
0xC6CD	0x3069	# HIRAGANA LETTER DO
0xC6CE	0x306A	# HIRAGANA LETTER NA
0xC6CF	0x306B	# HIRAGANA LETTER NI
0xC6D0	0x306C	# HIRAGANA LETTER NU
0xC6D1	0x306D	# HIRAGANA LETTER NE
0xC6D2	0x306E	# HIRAGANA LETTER NO
0xC6D3	0x306F	# HIRAGANA LETTER HA
0xC6D4	0x3070	# HIRAGANA LETTER BA
0xC6D5	0x3071	# HIRAGANA LETTER PA
0xC6D6	0x3072	# HIRAGANA LETTER HI
0xC6D7	0x3073	# HIRAGANA LETTER BI
0xC6D8	0x3074	# HIRAGANA LETTER PI
0xC6D9	0x3075	# HIRAGANA LETTER HU
0xC6DA	0x3076	# HIRAGANA LETTER BU
0xC6DB	0x3077	# HIRAGANA LETTER PU
0xC6DC	0x3078	# HIRAGANA LETTER HE
0xC6DD	0x3079	# HIRAGANA LETTER BE
0xC6DE	0x307A	# HIRAGANA LETTER PE
0xC6DF	0x307B	# HIRAGANA LETTER HO
0xC6E0	0x307C	# HIRAGANA LETTER BO
0xC6E1	0x307D	# HIRAGANA LETTER PO
0xC6E2	0x307E	# HIRAGANA LETTER MA
0xC6E3	0x307F	# HIRAGANA LETTER MI
0xC6E4	0x3080	# HIRAGANA LETTER MU
0xC6E5	0x3081	# HIRAGANA LETTER ME
0xC6E6	0x3082	# HIRAGANA LETTER MO
0xC6E7	0x3083	# HIRAGANA LETTER SMALL YA
0xC6E8	0x3084	# HIRAGANA LETTER YA
0xC6E9	0x3085	# HIRAGANA LETTER SMALL YU
0xC6EA	0x3086	# HIRAGANA LETTER YU
0xC6EB	0x3087	# HIRAGANA LETTER SMALL YO
0xC6EC	0x3088	# HIRAGANA LETTER YO
0xC6ED	0x3089	# HIRAGANA LETTER RA
0xC6EE	0x308A	# HIRAGANA LETTER RI
0xC6EF	0x308B	# HIRAGANA LETTER RU
0xC6F0	0x308C	# HIRAGANA LETTER RE
0xC6F1	0x308D	# HIRAGANA LETTER RO
0xC6F2	0x308E	# HIRAGANA LETTER SMALL WA
0xC6F3	0x308F	# HIRAGANA LETTER WA
0xC6F4	0x3090	# HIRAGANA LETTER WI
0xC6F5	0x3091	# HIRAGANA LETTER WE
0xC6F6	0x3092	# HIRAGANA LETTER WO
0xC6F7	0x3093	# HIRAGANA LETTER N
0xC6F8	0x30A1	# KATAKANA LETTER SMALL A
0xC6F9	0x30A2	# KATAKANA LETTER A
0xC6FA	0x30A3	# KATAKANA LETTER SMALL I
0xC6FB	0x30A4	# KATAKANA LETTER I
0xC6FC	0x30A5	# KATAKANA LETTER SMALL U
0xC6FD	0x30A6	# KATAKANA LETTER U
0xC6FE	0x30A7	# KATAKANA LETTER SMALL E
0xC740	0x30A8	# KATAKANA LETTER E
0xC741	0x30A9	# KATAKANA LETTER SMALL O
0xC742	0x30AA	# KATAKANA LETTER O
0xC743	0x30AB	# KATAKANA LETTER KA
0xC744	0x30AC	# KATAKANA LETTER GA
0xC745	0x30AD	# KATAKANA LETTER KI
0xC746	0x30AE	# KATAKANA LETTER GI
0xC747	0x30AF	# KATAKANA LETTER KU
0xC748	0x30B0	# KATAKANA LETTER GU
0xC749	0x30B1	# KATAKANA LETTER KE
0xC74A	0x30B2	# KATAKANA LETTER GE
0xC74B	0x30B3	# KATAKANA LETTER KO
0xC74C	0x30B4	# KATAKANA LETTER GO
0xC74D	0x30B5	# KATAKANA LETTER SA
0xC74E	0x30B6	# KATAKANA LETTER ZA
0xC74F	0x30B7	# KATAKANA LETTER SI
0xC750	0x30B8	# KATAKANA LETTER ZI
0xC751	0x30B9	# KATAKANA LETTER SU
0xC752	0x30BA	# KATAKANA LETTER ZU
0xC753	0x30BB	# KATAKANA LETTER SE
0xC754	0x30BC	# KATAKANA LETTER ZE
0xC755	0x30BD	# KATAKANA LETTER SO
0xC756	0x30BE	# KATAKANA LETTER ZO
0xC757	0x30BF	# KATAKANA LETTER TA
0xC758	0x30C0	# KATAKANA LETTER DA
0xC759	0x30C1	# KATAKANA LETTER TI
0xC75A	0x30C2	# KATAKANA LETTER DI
0xC75B	0x30C3	# KATAKANA LETTER SMALL TU
0xC75C	0x30C4	# KATAKANA LETTER TU
0xC75D	0x30C5	# KATAKANA LETTER DU
0xC75E	0x30C6	# KATAKANA LETTER TE
0xC75F	0x30C7	# KATAKANA LETTER DE
0xC760	0x30C8	# KATAKANA LETTER TO
0xC761	0x30C9	# KATAKANA LETTER DO
0xC762	0x30CA	# KATAKANA LETTER NA
0xC763	0x30CB	# KATAKANA LETTER NI
0xC764	0x30CC	# KATAKANA LETTER NU
0xC765	0x30CD	# KATAKANA LETTER NE
0xC766	0x30CE	# KATAKANA LETTER NO
0xC767	0x30CF	# KATAKANA LETTER HA
0xC768	0x30D0	# KATAKANA LETTER BA
0xC769	0x30D1	# KATAKANA LETTER PA
0xC76A	0x30D2	# KATAKANA LETTER HI
0xC76B	0x30D3	# KATAKANA LETTER BI
0xC76C	0x30D4	# KATAKANA LETTER PI
0xC76D	0x30D5	# KATAKANA LETTER HU
0xC76E	0x30D6	# KATAKANA LETTER BU
0xC76F	0x30D7	# KATAKANA LETTER PU
0xC770	0x30D8	# KATAKANA LETTER HE
0xC771	0x30D9	# KATAKANA LETTER BE
0xC772	0x30DA	# KATAKANA LETTER PE
0xC773	0x30DB	# KATAKANA LETTER HO
0xC774	0x30DC	# KATAKANA LETTER BO
0xC775	0x30DD	# KATAKANA LETTER PO
0xC776	0x30DE	# KATAKANA LETTER MA
0xC777	0x30DF	# KATAKANA LETTER MI
0xC778	0x30E0	# KATAKANA LETTER MU
0xC779	0x30E1	# KATAKANA LETTER ME
0xC77A	0x30E2	# KATAKANA LETTER MO
0xC77B	0x30E3	# KATAKANA LETTER SMALL YA
0xC77C	0x30E4	# KATAKANA LETTER YA
0xC77D	0x30E5	# KATAKANA LETTER SMALL YU
0xC77E	0x30E6	# KATAKANA LETTER YU
0xC7A1	0x30E7	# KATAKANA LETTER SMALL YO
0xC7A2	0x30E8	# KATAKANA LETTER YO
0xC7A3	0x30E9	# KATAKANA LETTER RA
0xC7A4	0x30EA	# KATAKANA LETTER RI
0xC7A5	0x30EB	# KATAKANA LETTER RU
0xC7A6	0x30EC	# KATAKANA LETTER RE
0xC7A7	0x30ED	# KATAKANA LETTER RO
0xC7A8	0x30EE	# KATAKANA LETTER SMALL WA
0xC7A9	0x30EF	# KATAKANA LETTER WA
0xC7AA	0x30F0	# KATAKANA LETTER WI
0xC7AB	0x30F1	# KATAKANA LETTER WE
0xC7AC	0x30F2	# KATAKANA LETTER WO
0xC7AD	0x30F3	# KATAKANA LETTER N
0xC7AE	0x30F4	# KATAKANA LETTER VU
0xC7AF	0x30F5	# KATAKANA LETTER SMALL KA
0xC7B0	0x30F6	# KATAKANA LETTER SMALL KE
0xC7B1	0x0414	# CYRILLIC CAPITAL LETTER DE
0xC7B2	0x0415	# CYRILLIC CAPITAL LETTER IE
0xC7B3	0x0401	# CYRILLIC CAPITAL LETTER IO
0xC7B4	0x0416	# CYRILLIC CAPITAL LETTER ZHE
0xC7B5	0x0417	# CYRILLIC CAPITAL LETTER ZE
0xC7B6	0x0418	# CYRILLIC CAPITAL LETTER I
0xC7B7	0x0419	# CYRILLIC CAPITAL LETTER SHORT I
0xC7B8	0x041A	# CYRILLIC CAPITAL LETTER KA
0xC7B9	0x041B	# CYRILLIC CAPITAL LETTER EL
0xC7BA	0x041C	# CYRILLIC CAPITAL LETTER EM
0xC7BB	0x0423	# CYRILLIC CAPITAL LETTER U
0xC7BC	0x0424	# CYRILLIC CAPITAL LETTER EF
0xC7BD	0x0425	# CYRILLIC CAPITAL LETTER HA
0xC7BE	0x0426	# CYRILLIC CAPITAL LETTER TSE
0xC7BF	0x0427	# CYRILLIC CAPITAL LETTER CHE
0xC7C0	0x0428	# CYRILLIC CAPITAL LETTER SHA
0xC7C1	0x0429	# CYRILLIC CAPITAL LETTER SHCHA
0xC7C2	0x042A	# CYRILLIC CAPITAL LETTER HARD SIGN
0xC7C3	0x042B	# CYRILLIC CAPITAL LETTER YERU
0xC7C4	0x042C	# CYRILLIC CAPITAL LETTER SOFT SIGN
0xC7C5	0x042D	# CYRILLIC CAPITAL LETTER E
0xC7C6	0x042E	# CYRILLIC CAPITAL LETTER YU
0xC7C7	0x042F	# CYRILLIC CAPITAL LETTER YA
0xC7C8	0x0430	# CYRILLIC SMALL LETTER A
0xC7C9	0x0431	# CYRILLIC SMALL LETTER BE
0xC7CA	0x0432	# CYRILLIC SMALL LETTER VE
0xC7CB	0x0433	# CYRILLIC SMALL LETTER GHE
0xC7CC	0x0434	# CYRILLIC SMALL LETTER DE
0xC7CD	0x0435	# CYRILLIC SMALL LETTER IE
0xC7CE	0x0451	# CYRILLIC SMALL LETTER IO
0xC7CF	0x0436	# CYRILLIC SMALL LETTER ZHE
0xC7D0	0x0437	# CYRILLIC SMALL LETTER ZE
0xC7D1	0x0438	# CYRILLIC SMALL LETTER I
0xC7D2	0x0439	# CYRILLIC SMALL LETTER SHORT I
0xC7D3	0x043A	# CYRILLIC SMALL LETTER KA
0xC7D4	0x043B	# CYRILLIC SMALL LETTER EL
0xC7D5	0x043C	# CYRILLIC SMALL LETTER EM
0xC7D6	0x043D	# CYRILLIC SMALL LETTER EN
0xC7D7	0x043E	# CYRILLIC SMALL LETTER O
0xC7D8	0x043F	# CYRILLIC SMALL LETTER PE
0xC7D9	0x0440	# CYRILLIC SMALL LETTER ER
0xC7DA	0x0441	# CYRILLIC SMALL LETTER ES
0xC7DB	0x0442	# CYRILLIC SMALL LETTER TE
0xC7DC	0x0443	# CYRILLIC SMALL LETTER U
0xC7DD	0x0444	# CYRILLIC SMALL LETTER EF
0xC7DE	0x0445	# CYRILLIC SMALL LETTER HA
0xC7DF	0x0446	# CYRILLIC SMALL LETTER TSE
0xC7E0	0x0447	# CYRILLIC SMALL LETTER CHE
0xC7E1	0x0448	# CYRILLIC SMALL LETTER SHA
0xC7E2	0x0449	# CYRILLIC SMALL LETTER SHCHA
0xC7E3	0x044A	# CYRILLIC SMALL LETTER HARD SIGN
0xC7E4	0x044B	# CYRILLIC SMALL LETTER YERU
0xC7E5	0x044C	# CYRILLIC SMALL LETTER SOFT SIGN
0xC7E6	0x044D	# CYRILLIC SMALL LETTER E
0xC7E7	0x044E	# CYRILLIC SMALL LETTER YU
0xC7E8	0x044F	# CYRILLIC SMALL LETTER YA
0xC7E9	0x2460	# CIRCLED DIGIT ONE
0xC7EA	0x2461	# CIRCLED DIGIT TWO
0xC7EB	0x2462	# CIRCLED DIGIT THREE
0xC7EC	0x2463	# CIRCLED DIGIT FOUR
0xC7ED	0x2464	# CIRCLED DIGIT FIVE
0xC7EE	0x2465	# CIRCLED DIGIT SIX
0xC7EF	0x2466	# CIRCLED DIGIT SEVEN
0xC7F0	0x2467	# CIRCLED DIGIT EIGHT
0xC7F1	0x2468	# CIRCLED DIGIT NINE
0xC7F2	0x2469	# CIRCLED NUMBER TEN
0xC7F3	0x2474	# PARENTHESIZED DIGIT ONE
0xC7F4	0x2475	# PARENTHESIZED DIGIT TWO
0xC7F5	0x2476	# PARENTHESIZED DIGIT THREE
0xC7F6	0x2477	# PARENTHESIZED DIGIT FOUR
0xC7F7	0x2478	# PARENTHESIZED DIGIT FIVE
0xC7F8	0x2479	# PARENTHESIZED DIGIT SIX
0xC7F9	0x247A	# PARENTHESIZED DIGIT SEVEN
0xC7FA	0x247B	# PARENTHESIZED DIGIT EIGHT
0xC7FB	0x247C	# PARENTHESIZED DIGIT NINE
0xC7FC	0x247D	# PARENTHESIZED NUMBER TEN
0xC940	0x4E42	# <CJK>
0xC941	0x4E5C	# <CJK>
0xC942	0x51F5	# <CJK>
0xC943	0x531A	# <CJK>
0xC944	0x5382	# <CJK>
0xC945	0x4E07	# <CJK>
0xC946	0x4E0C	# <CJK>
0xC947	0x4E47	# <CJK>
0xC948	0x4E8D	# <CJK>
0xC949	0x56D7	# <CJK>
0xC94A	0xFA0C	# CJK COMPATIBILITY IDEOGRAPH-FA0C
0xC94B	0x5C6E	# <CJK>
0xC94C	0x5F73	# <CJK>
0xC94D	0x4E0F	# <CJK>
0xC94E	0x5187	# <CJK>
0xC94F	0x4E0E	# <CJK>
0xC950	0x4E2E	# <CJK>
0xC951	0x4E93	# <CJK>
0xC952	0x4EC2	# <CJK>
0xC953	0x4EC9	# <CJK>
0xC954	0x4EC8	# <CJK>
0xC955	0x5198	# <CJK>
0xC956	0x52FC	# <CJK>
0xC957	0x536C	# <CJK>
0xC958	0x53B9	# <CJK>
0xC959	0x5720	# <CJK>
0xC95A	0x5903	# <CJK>
0xC95B	0x592C	# <CJK>
0xC95C	0x5C10	# <CJK>
0xC95D	0x5DFF	# <CJK>
0xC95E	0x65E1	# <CJK>
0xC95F	0x6BB3	# <CJK>
0xC960	0x6BCC	# <CJK>
0xC961	0x6C14	# <CJK>
0xC962	0x723F	# <CJK>
0xC963	0x4E31	# <CJK>
0xC964	0x4E3C	# <CJK>
0xC965	0x4EE8	# <CJK>
0xC966	0x4EDC	# <CJK>
0xC967	0x4EE9	# <CJK>
0xC968	0x4EE1	# <CJK>
0xC969	0x4EDD	# <CJK>
0xC96A	0x4EDA	# <CJK>
0xC96B	0x520C	# <CJK>
0xC96C	0x531C	# <CJK>
0xC96D	0x534C	# <CJK>
0xC96E	0x5722	# <CJK>
0xC96F	0x5723	# <CJK>
0xC970	0x5917	# <CJK>
0xC971	0x592F	# <CJK>
0xC972	0x5B81	# <CJK>
0xC973	0x5B84	# <CJK>
0xC974	0x5C12	# <CJK>
0xC975	0x5C3B	# <CJK>
0xC976	0x5C74	# <CJK>
0xC977	0x5C73	# <CJK>
0xC978	0x5E04	# <CJK>
0xC979	0x5E80	# <CJK>
0xC97A	0x5E82	# <CJK>
0xC97B	0x5FC9	# <CJK>
0xC97C	0x6209	# <CJK>
0xC97D	0x6250	# <CJK>
0xC97E	0x6C15	# <CJK>
0xC9A1	0x6C36	# <CJK>
0xC9A2	0x6C43	# <CJK>
0xC9A3	0x6C3F	# <CJK>
0xC9A4	0x6C3B	# <CJK>
0xC9A5	0x72AE	# <CJK>
0xC9A6	0x72B0	# <CJK>
0xC9A7	0x738A	# <CJK>
0xC9A8	0x79B8	# <CJK>
0xC9A9	0x808A	# <CJK>
0xC9AA	0x961E	# <CJK>
0xC9AB	0x4F0E	# <CJK>
0xC9AC	0x4F18	# <CJK>
0xC9AD	0x4F2C	# <CJK>
0xC9AE	0x4EF5	# <CJK>
0xC9AF	0x4F14	# <CJK>
0xC9B0	0x4EF1	# <CJK>
0xC9B1	0x4F00	# <CJK>
0xC9B2	0x4EF7	# <CJK>
0xC9B3	0x4F08	# <CJK>
0xC9B4	0x4F1D	# <CJK>
0xC9B5	0x4F02	# <CJK>
0xC9B6	0x4F05	# <CJK>
0xC9B7	0x4F22	# <CJK>
0xC9B8	0x4F13	# <CJK>
0xC9B9	0x4F04	# <CJK>
0xC9BA	0x4EF4	# <CJK>
0xC9BB	0x4F12	# <CJK>
0xC9BC	0x51B1	# <CJK>
0xC9BD	0x5213	# <CJK>
0xC9BE	0x5209	# <CJK>
0xC9BF	0x5210	# <CJK>
0xC9C0	0x52A6	# <CJK>
0xC9C1	0x5322	# <CJK>
0xC9C2	0x531F	# <CJK>
0xC9C3	0x534D	# <CJK>
0xC9C4	0x538A	# <CJK>
0xC9C5	0x5407	# <CJK>
0xC9C6	0x56E1	# <CJK>
0xC9C7	0x56DF	# <CJK>
0xC9C8	0x572E	# <CJK>
0xC9C9	0x572A	# <CJK>
0xC9CA	0x5734	# <CJK>
0xC9CB	0x593C	# <CJK>
0xC9CC	0x5980	# <CJK>
0xC9CD	0x597C	# <CJK>
0xC9CE	0x5985	# <CJK>
0xC9CF	0x597B	# <CJK>
0xC9D0	0x597E	# <CJK>
0xC9D1	0x5977	# <CJK>
0xC9D2	0x597F	# <CJK>
0xC9D3	0x5B56	# <CJK>
0xC9D4	0x5C15	# <CJK>
0xC9D5	0x5C25	# <CJK>
0xC9D6	0x5C7C	# <CJK>
0xC9D7	0x5C7A	# <CJK>
0xC9D8	0x5C7B	# <CJK>
0xC9D9	0x5C7E	# <CJK>
0xC9DA	0x5DDF	# <CJK>
0xC9DB	0x5E75	# <CJK>
0xC9DC	0x5E84	# <CJK>
0xC9DD	0x5F02	# <CJK>
0xC9DE	0x5F1A	# <CJK>
0xC9DF	0x5F74	# <CJK>
0xC9E0	0x5FD5	# <CJK>
0xC9E1	0x5FD4	# <CJK>
0xC9E2	0x5FCF	# <CJK>
0xC9E3	0x625C	# <CJK>
0xC9E4	0x625E	# <CJK>
0xC9E5	0x6264	# <CJK>
0xC9E6	0x6261	# <CJK>
0xC9E7	0x6266	# <CJK>
0xC9E8	0x6262	# <CJK>
0xC9E9	0x6259	# <CJK>
0xC9EA	0x6260	# <CJK>
0xC9EB	0x625A	# <CJK>
0xC9EC	0x6265	# <CJK>
0xC9ED	0x65EF	# <CJK>
0xC9EE	0x65EE	# <CJK>
0xC9EF	0x673E	# <CJK>
0xC9F0	0x6739	# <CJK>
0xC9F1	0x6738	# <CJK>
0xC9F2	0x673B	# <CJK>
0xC9F3	0x673A	# <CJK>
0xC9F4	0x673F	# <CJK>
0xC9F5	0x673C	# <CJK>
0xC9F6	0x6733	# <CJK>
0xC9F7	0x6C18	# <CJK>
0xC9F8	0x6C46	# <CJK>
0xC9F9	0x6C52	# <CJK>
0xC9FA	0x6C5C	# <CJK>
0xC9FB	0x6C4F	# <CJK>
0xC9FC	0x6C4A	# <CJK>
0xC9FD	0x6C54	# <CJK>
0xC9FE	0x6C4B	# <CJK>
0xCA40	0x6C4C	# <CJK>
0xCA41	0x7071	# <CJK>
0xCA42	0x725E	# <CJK>
0xCA43	0x72B4	# <CJK>
0xCA44	0x72B5	# <CJK>
0xCA45	0x738E	# <CJK>
0xCA46	0x752A	# <CJK>
0xCA47	0x767F	# <CJK>
0xCA48	0x7A75	# <CJK>
0xCA49	0x7F51	# <CJK>
0xCA4A	0x8278	# <CJK>
0xCA4B	0x827C	# <CJK>
0xCA4C	0x8280	# <CJK>
0xCA4D	0x827D	# <CJK>
0xCA4E	0x827F	# <CJK>
0xCA4F	0x864D	# <CJK>
0xCA50	0x897E	# <CJK>
0xCA51	0x9099	# <CJK>
0xCA52	0x9097	# <CJK>
0xCA53	0x9098	# <CJK>
0xCA54	0x909B	# <CJK>
0xCA55	0x9094	# <CJK>
0xCA56	0x9622	# <CJK>
0xCA57	0x9624	# <CJK>
0xCA58	0x9620	# <CJK>
0xCA59	0x9623	# <CJK>
0xCA5A	0x4F56	# <CJK>
0xCA5B	0x4F3B	# <CJK>
0xCA5C	0x4F62	# <CJK>
0xCA5D	0x4F49	# <CJK>
0xCA5E	0x4F53	# <CJK>
0xCA5F	0x4F64	# <CJK>
0xCA60	0x4F3E	# <CJK>
0xCA61	0x4F67	# <CJK>
0xCA62	0x4F52	# <CJK>
0xCA63	0x4F5F	# <CJK>
0xCA64	0x4F41	# <CJK>
0xCA65	0x4F58	# <CJK>
0xCA66	0x4F2D	# <CJK>
0xCA67	0x4F33	# <CJK>
0xCA68	0x4F3F	# <CJK>
0xCA69	0x4F61	# <CJK>
0xCA6A	0x518F	# <CJK>
0xCA6B	0x51B9	# <CJK>
0xCA6C	0x521C	# <CJK>
0xCA6D	0x521E	# <CJK>
0xCA6E	0x5221	# <CJK>
0xCA6F	0x52AD	# <CJK>
0xCA70	0x52AE	# <CJK>
0xCA71	0x5309	# <CJK>
0xCA72	0x5363	# <CJK>
0xCA73	0x5372	# <CJK>
0xCA74	0x538E	# <CJK>
0xCA75	0x538F	# <CJK>
0xCA76	0x5430	# <CJK>
0xCA77	0x5437	# <CJK>
0xCA78	0x542A	# <CJK>
0xCA79	0x5454	# <CJK>
0xCA7A	0x5445	# <CJK>
0xCA7B	0x5419	# <CJK>
0xCA7C	0x541C	# <CJK>
0xCA7D	0x5425	# <CJK>
0xCA7E	0x5418	# <CJK>
0xCAA1	0x543D	# <CJK>
0xCAA2	0x544F	# <CJK>
0xCAA3	0x5441	# <CJK>
0xCAA4	0x5428	# <CJK>
0xCAA5	0x5424	# <CJK>
0xCAA6	0x5447	# <CJK>
0xCAA7	0x56EE	# <CJK>
0xCAA8	0x56E7	# <CJK>
0xCAA9	0x56E5	# <CJK>
0xCAAA	0x5741	# <CJK>
0xCAAB	0x5745	# <CJK>
0xCAAC	0x574C	# <CJK>
0xCAAD	0x5749	# <CJK>
0xCAAE	0x574B	# <CJK>
0xCAAF	0x5752	# <CJK>
0xCAB0	0x5906	# <CJK>
0xCAB1	0x5940	# <CJK>
0xCAB2	0x59A6	# <CJK>
0xCAB3	0x5998	# <CJK>
0xCAB4	0x59A0	# <CJK>
0xCAB5	0x5997	# <CJK>
0xCAB6	0x598E	# <CJK>
0xCAB7	0x59A2	# <CJK>
0xCAB8	0x5990	# <CJK>
0xCAB9	0x598F	# <CJK>
0xCABA	0x59A7	# <CJK>
0xCABB	0x59A1	# <CJK>
0xCABC	0x5B8E	# <CJK>
0xCABD	0x5B92	# <CJK>
0xCABE	0x5C28	# <CJK>
0xCABF	0x5C2A	# <CJK>
0xCAC0	0x5C8D	# <CJK>
0xCAC1	0x5C8F	# <CJK>
0xCAC2	0x5C88	# <CJK>
0xCAC3	0x5C8B	# <CJK>
0xCAC4	0x5C89	# <CJK>
0xCAC5	0x5C92	# <CJK>
0xCAC6	0x5C8A	# <CJK>
0xCAC7	0x5C86	# <CJK>
0xCAC8	0x5C93	# <CJK>
0xCAC9	0x5C95	# <CJK>
0xCACA	0x5DE0	# <CJK>
0xCACB	0x5E0A	# <CJK>
0xCACC	0x5E0E	# <CJK>
0xCACD	0x5E8B	# <CJK>
0xCACE	0x5E89	# <CJK>
0xCACF	0x5E8C	# <CJK>
0xCAD0	0x5E88	# <CJK>
0xCAD1	0x5E8D	# <CJK>
0xCAD2	0x5F05	# <CJK>
0xCAD3	0x5F1D	# <CJK>
0xCAD4	0x5F78	# <CJK>
0xCAD5	0x5F76	# <CJK>
0xCAD6	0x5FD2	# <CJK>
0xCAD7	0x5FD1	# <CJK>
0xCAD8	0x5FD0	# <CJK>
0xCAD9	0x5FED	# <CJK>
0xCADA	0x5FE8	# <CJK>
0xCADB	0x5FEE	# <CJK>
0xCADC	0x5FF3	# <CJK>
0xCADD	0x5FE1	# <CJK>
0xCADE	0x5FE4	# <CJK>
0xCADF	0x5FE3	# <CJK>
0xCAE0	0x5FFA	# <CJK>
0xCAE1	0x5FEF	# <CJK>
0xCAE2	0x5FF7	# <CJK>
0xCAE3	0x5FFB	# <CJK>
0xCAE4	0x6000	# <CJK>
0xCAE5	0x5FF4	# <CJK>
0xCAE6	0x623A	# <CJK>
0xCAE7	0x6283	# <CJK>
0xCAE8	0x628C	# <CJK>
0xCAE9	0x628E	# <CJK>
0xCAEA	0x628F	# <CJK>
0xCAEB	0x6294	# <CJK>
0xCAEC	0x6287	# <CJK>
0xCAED	0x6271	# <CJK>
0xCAEE	0x627B	# <CJK>
0xCAEF	0x627A	# <CJK>
0xCAF0	0x6270	# <CJK>
0xCAF1	0x6281	# <CJK>
0xCAF2	0x6288	# <CJK>
0xCAF3	0x6277	# <CJK>
0xCAF4	0x627D	# <CJK>
0xCAF5	0x6272	# <CJK>
0xCAF6	0x6274	# <CJK>
0xCAF7	0x6537	# <CJK>
0xCAF8	0x65F0	# <CJK>
0xCAF9	0x65F4	# <CJK>
0xCAFA	0x65F3	# <CJK>
0xCAFB	0x65F2	# <CJK>
0xCAFC	0x65F5	# <CJK>
0xCAFD	0x6745	# <CJK>
0xCAFE	0x6747	# <CJK>
0xCB40	0x6759	# <CJK>
0xCB41	0x6755	# <CJK>
0xCB42	0x674C	# <CJK>
0xCB43	0x6748	# <CJK>
0xCB44	0x675D	# <CJK>
0xCB45	0x674D	# <CJK>
0xCB46	0x675A	# <CJK>
0xCB47	0x674B	# <CJK>
0xCB48	0x6BD0	# <CJK>
0xCB49	0x6C19	# <CJK>
0xCB4A	0x6C1A	# <CJK>
0xCB4B	0x6C78	# <CJK>
0xCB4C	0x6C67	# <CJK>
0xCB4D	0x6C6B	# <CJK>
0xCB4E	0x6C84	# <CJK>
0xCB4F	0x6C8B	# <CJK>
0xCB50	0x6C8F	# <CJK>
0xCB51	0x6C71	# <CJK>
0xCB52	0x6C6F	# <CJK>
0xCB53	0x6C69	# <CJK>
0xCB54	0x6C9A	# <CJK>
0xCB55	0x6C6D	# <CJK>
0xCB56	0x6C87	# <CJK>
0xCB57	0x6C95	# <CJK>
0xCB58	0x6C9C	# <CJK>
0xCB59	0x6C66	# <CJK>
0xCB5A	0x6C73	# <CJK>
0xCB5B	0x6C65	# <CJK>
0xCB5C	0x6C7B	# <CJK>
0xCB5D	0x6C8E	# <CJK>
0xCB5E	0x7074	# <CJK>
0xCB5F	0x707A	# <CJK>
0xCB60	0x7263	# <CJK>
0xCB61	0x72BF	# <CJK>
0xCB62	0x72BD	# <CJK>
0xCB63	0x72C3	# <CJK>
0xCB64	0x72C6	# <CJK>
0xCB65	0x72C1	# <CJK>
0xCB66	0x72BA	# <CJK>
0xCB67	0x72C5	# <CJK>
0xCB68	0x7395	# <CJK>
0xCB69	0x7397	# <CJK>
0xCB6A	0x7393	# <CJK>
0xCB6B	0x7394	# <CJK>
0xCB6C	0x7392	# <CJK>
0xCB6D	0x753A	# <CJK>
0xCB6E	0x7539	# <CJK>
0xCB6F	0x7594	# <CJK>
0xCB70	0x7595	# <CJK>
0xCB71	0x7681	# <CJK>
0xCB72	0x793D	# <CJK>
0xCB73	0x8034	# <CJK>
0xCB74	0x8095	# <CJK>
0xCB75	0x8099	# <CJK>
0xCB76	0x8090	# <CJK>
0xCB77	0x8092	# <CJK>
0xCB78	0x809C	# <CJK>
0xCB79	0x8290	# <CJK>
0xCB7A	0x828F	# <CJK>
0xCB7B	0x8285	# <CJK>
0xCB7C	0x828E	# <CJK>
0xCB7D	0x8291	# <CJK>
0xCB7E	0x8293	# <CJK>
0xCBA1	0x828A	# <CJK>
0xCBA2	0x8283	# <CJK>
0xCBA3	0x8284	# <CJK>
0xCBA4	0x8C78	# <CJK>
0xCBA5	0x8FC9	# <CJK>
0xCBA6	0x8FBF	# <CJK>
0xCBA7	0x909F	# <CJK>
0xCBA8	0x90A1	# <CJK>
0xCBA9	0x90A5	# <CJK>
0xCBAA	0x909E	# <CJK>
0xCBAB	0x90A7	# <CJK>
0xCBAC	0x90A0	# <CJK>
0xCBAD	0x9630	# <CJK>
0xCBAE	0x9628	# <CJK>
0xCBAF	0x962F	# <CJK>
0xCBB0	0x962D	# <CJK>
0xCBB1	0x4E33	# <CJK>
0xCBB2	0x4F98	# <CJK>
0xCBB3	0x4F7C	# <CJK>
0xCBB4	0x4F85	# <CJK>
0xCBB5	0x4F7D	# <CJK>
0xCBB6	0x4F80	# <CJK>
0xCBB7	0x4F87	# <CJK>
0xCBB8	0x4F76	# <CJK>
0xCBB9	0x4F74	# <CJK>
0xCBBA	0x4F89	# <CJK>
0xCBBB	0x4F84	# <CJK>
0xCBBC	0x4F77	# <CJK>
0xCBBD	0x4F4C	# <CJK>
0xCBBE	0x4F97	# <CJK>
0xCBBF	0x4F6A	# <CJK>
0xCBC0	0x4F9A	# <CJK>
0xCBC1	0x4F79	# <CJK>
0xCBC2	0x4F81	# <CJK>
0xCBC3	0x4F78	# <CJK>
0xCBC4	0x4F90	# <CJK>
0xCBC5	0x4F9C	# <CJK>
0xCBC6	0x4F94	# <CJK>
0xCBC7	0x4F9E	# <CJK>
0xCBC8	0x4F92	# <CJK>
0xCBC9	0x4F82	# <CJK>
0xCBCA	0x4F95	# <CJK>
0xCBCB	0x4F6B	# <CJK>
0xCBCC	0x4F6E	# <CJK>
0xCBCD	0x519E	# <CJK>
0xCBCE	0x51BC	# <CJK>
0xCBCF	0x51BE	# <CJK>
0xCBD0	0x5235	# <CJK>
0xCBD1	0x5232	# <CJK>
0xCBD2	0x5233	# <CJK>
0xCBD3	0x5246	# <CJK>
0xCBD4	0x5231	# <CJK>
0xCBD5	0x52BC	# <CJK>
0xCBD6	0x530A	# <CJK>
0xCBD7	0x530B	# <CJK>
0xCBD8	0x533C	# <CJK>
0xCBD9	0x5392	# <CJK>
0xCBDA	0x5394	# <CJK>
0xCBDB	0x5487	# <CJK>
0xCBDC	0x547F	# <CJK>
0xCBDD	0x5481	# <CJK>
0xCBDE	0x5491	# <CJK>
0xCBDF	0x5482	# <CJK>
0xCBE0	0x5488	# <CJK>
0xCBE1	0x546B	# <CJK>
0xCBE2	0x547A	# <CJK>
0xCBE3	0x547E	# <CJK>
0xCBE4	0x5465	# <CJK>
0xCBE5	0x546C	# <CJK>
0xCBE6	0x5474	# <CJK>
0xCBE7	0x5466	# <CJK>
0xCBE8	0x548D	# <CJK>
0xCBE9	0x546F	# <CJK>
0xCBEA	0x5461	# <CJK>
0xCBEB	0x5460	# <CJK>
0xCBEC	0x5498	# <CJK>
0xCBED	0x5463	# <CJK>
0xCBEE	0x5467	# <CJK>
0xCBEF	0x5464	# <CJK>
0xCBF0	0x56F7	# <CJK>
0xCBF1	0x56F9	# <CJK>
0xCBF2	0x576F	# <CJK>
0xCBF3	0x5772	# <CJK>
0xCBF4	0x576D	# <CJK>
0xCBF5	0x576B	# <CJK>
0xCBF6	0x5771	# <CJK>
0xCBF7	0x5770	# <CJK>
0xCBF8	0x5776	# <CJK>
0xCBF9	0x5780	# <CJK>
0xCBFA	0x5775	# <CJK>
0xCBFB	0x577B	# <CJK>
0xCBFC	0x5773	# <CJK>
0xCBFD	0x5774	# <CJK>
0xCBFE	0x5762	# <CJK>
0xCC40	0x5768	# <CJK>
0xCC41	0x577D	# <CJK>
0xCC42	0x590C	# <CJK>
0xCC43	0x5945	# <CJK>
0xCC44	0x59B5	# <CJK>
0xCC45	0x59BA	# <CJK>
0xCC46	0x59CF	# <CJK>
0xCC47	0x59CE	# <CJK>
0xCC48	0x59B2	# <CJK>
0xCC49	0x59CC	# <CJK>
0xCC4A	0x59C1	# <CJK>
0xCC4B	0x59B6	# <CJK>
0xCC4C	0x59BC	# <CJK>
0xCC4D	0x59C3	# <CJK>
0xCC4E	0x59D6	# <CJK>
0xCC4F	0x59B1	# <CJK>
0xCC50	0x59BD	# <CJK>
0xCC51	0x59C0	# <CJK>
0xCC52	0x59C8	# <CJK>
0xCC53	0x59B4	# <CJK>
0xCC54	0x59C7	# <CJK>
0xCC55	0x5B62	# <CJK>
0xCC56	0x5B65	# <CJK>
0xCC57	0x5B93	# <CJK>
0xCC58	0x5B95	# <CJK>
0xCC59	0x5C44	# <CJK>
0xCC5A	0x5C47	# <CJK>
0xCC5B	0x5CAE	# <CJK>
0xCC5C	0x5CA4	# <CJK>
0xCC5D	0x5CA0	# <CJK>
0xCC5E	0x5CB5	# <CJK>
0xCC5F	0x5CAF	# <CJK>
0xCC60	0x5CA8	# <CJK>
0xCC61	0x5CAC	# <CJK>
0xCC62	0x5C9F	# <CJK>
0xCC63	0x5CA3	# <CJK>
0xCC64	0x5CAD	# <CJK>
0xCC65	0x5CA2	# <CJK>
0xCC66	0x5CAA	# <CJK>
0xCC67	0x5CA7	# <CJK>
0xCC68	0x5C9D	# <CJK>
0xCC69	0x5CA5	# <CJK>
0xCC6A	0x5CB6	# <CJK>
0xCC6B	0x5CB0	# <CJK>
0xCC6C	0x5CA6	# <CJK>
0xCC6D	0x5E17	# <CJK>
0xCC6E	0x5E14	# <CJK>
0xCC6F	0x5E19	# <CJK>
0xCC70	0x5F28	# <CJK>
0xCC71	0x5F22	# <CJK>
0xCC72	0x5F23	# <CJK>
0xCC73	0x5F24	# <CJK>
0xCC74	0x5F54	# <CJK>
0xCC75	0x5F82	# <CJK>
0xCC76	0x5F7E	# <CJK>
0xCC77	0x5F7D	# <CJK>
0xCC78	0x5FDE	# <CJK>
0xCC79	0x5FE5	# <CJK>
0xCC7A	0x602D	# <CJK>
0xCC7B	0x6026	# <CJK>
0xCC7C	0x6019	# <CJK>
0xCC7D	0x6032	# <CJK>
0xCC7E	0x600B	# <CJK>
0xCCA1	0x6034	# <CJK>
0xCCA2	0x600A	# <CJK>
0xCCA3	0x6017	# <CJK>
0xCCA4	0x6033	# <CJK>
0xCCA5	0x601A	# <CJK>
0xCCA6	0x601E	# <CJK>
0xCCA7	0x602C	# <CJK>
0xCCA8	0x6022	# <CJK>
0xCCA9	0x600D	# <CJK>
0xCCAA	0x6010	# <CJK>
0xCCAB	0x602E	# <CJK>
0xCCAC	0x6013	# <CJK>
0xCCAD	0x6011	# <CJK>
0xCCAE	0x600C	# <CJK>
0xCCAF	0x6009	# <CJK>
0xCCB0	0x601C	# <CJK>
0xCCB1	0x6214	# <CJK>
0xCCB2	0x623D	# <CJK>
0xCCB3	0x62AD	# <CJK>
0xCCB4	0x62B4	# <CJK>
0xCCB5	0x62D1	# <CJK>
0xCCB6	0x62BE	# <CJK>
0xCCB7	0x62AA	# <CJK>
0xCCB8	0x62B6	# <CJK>
0xCCB9	0x62CA	# <CJK>
0xCCBA	0x62AE	# <CJK>
0xCCBB	0x62B3	# <CJK>
0xCCBC	0x62AF	# <CJK>
0xCCBD	0x62BB	# <CJK>
0xCCBE	0x62A9	# <CJK>
0xCCBF	0x62B0	# <CJK>
0xCCC0	0x62B8	# <CJK>
0xCCC1	0x653D	# <CJK>
0xCCC2	0x65A8	# <CJK>
0xCCC3	0x65BB	# <CJK>
0xCCC4	0x6609	# <CJK>
0xCCC5	0x65FC	# <CJK>
0xCCC6	0x6604	# <CJK>
0xCCC7	0x6612	# <CJK>
0xCCC8	0x6608	# <CJK>
0xCCC9	0x65FB	# <CJK>
0xCCCA	0x6603	# <CJK>
0xCCCB	0x660B	# <CJK>
0xCCCC	0x660D	# <CJK>
0xCCCD	0x6605	# <CJK>
0xCCCE	0x65FD	# <CJK>
0xCCCF	0x6611	# <CJK>
0xCCD0	0x6610	# <CJK>
0xCCD1	0x66F6	# <CJK>
0xCCD2	0x670A	# <CJK>
0xCCD3	0x6785	# <CJK>
0xCCD4	0x676C	# <CJK>
0xCCD5	0x678E	# <CJK>
0xCCD6	0x6792	# <CJK>
0xCCD7	0x6776	# <CJK>
0xCCD8	0x677B	# <CJK>
0xCCD9	0x6798	# <CJK>
0xCCDA	0x6786	# <CJK>
0xCCDB	0x6784	# <CJK>
0xCCDC	0x6774	# <CJK>
0xCCDD	0x678D	# <CJK>
0xCCDE	0x678C	# <CJK>
0xCCDF	0x677A	# <CJK>
0xCCE0	0x679F	# <CJK>
0xCCE1	0x6791	# <CJK>
0xCCE2	0x6799	# <CJK>
0xCCE3	0x6783	# <CJK>
0xCCE4	0x677D	# <CJK>
0xCCE5	0x6781	# <CJK>
0xCCE6	0x6778	# <CJK>
0xCCE7	0x6779	# <CJK>
0xCCE8	0x6794	# <CJK>
0xCCE9	0x6B25	# <CJK>
0xCCEA	0x6B80	# <CJK>
0xCCEB	0x6B7E	# <CJK>
0xCCEC	0x6BDE	# <CJK>
0xCCED	0x6C1D	# <CJK>
0xCCEE	0x6C93	# <CJK>
0xCCEF	0x6CEC	# <CJK>
0xCCF0	0x6CEB	# <CJK>
0xCCF1	0x6CEE	# <CJK>
0xCCF2	0x6CD9	# <CJK>
0xCCF3	0x6CB6	# <CJK>
0xCCF4	0x6CD4	# <CJK>
0xCCF5	0x6CAD	# <CJK>
0xCCF6	0x6CE7	# <CJK>
0xCCF7	0x6CB7	# <CJK>
0xCCF8	0x6CD0	# <CJK>
0xCCF9	0x6CC2	# <CJK>
0xCCFA	0x6CBA	# <CJK>
0xCCFB	0x6CC3	# <CJK>
0xCCFC	0x6CC6	# <CJK>
0xCCFD	0x6CED	# <CJK>
0xCCFE	0x6CF2	# <CJK>
0xCD40	0x6CD2	# <CJK>
0xCD41	0x6CDD	# <CJK>
0xCD42	0x6CB4	# <CJK>
0xCD43	0x6C8A	# <CJK>
0xCD44	0x6C9D	# <CJK>
0xCD45	0x6C80	# <CJK>
0xCD46	0x6CDE	# <CJK>
0xCD47	0x6CC0	# <CJK>
0xCD48	0x6D30	# <CJK>
0xCD49	0x6CCD	# <CJK>
0xCD4A	0x6CC7	# <CJK>
0xCD4B	0x6CB0	# <CJK>
0xCD4C	0x6CF9	# <CJK>
0xCD4D	0x6CCF	# <CJK>
0xCD4E	0x6CE9	# <CJK>
0xCD4F	0x6CD1	# <CJK>
0xCD50	0x7094	# <CJK>
0xCD51	0x7098	# <CJK>
0xCD52	0x7085	# <CJK>
0xCD53	0x7093	# <CJK>
0xCD54	0x7086	# <CJK>
0xCD55	0x7084	# <CJK>
0xCD56	0x7091	# <CJK>
0xCD57	0x7096	# <CJK>
0xCD58	0x7082	# <CJK>
0xCD59	0x709A	# <CJK>
0xCD5A	0x7083	# <CJK>
0xCD5B	0x726A	# <CJK>
0xCD5C	0x72D6	# <CJK>
0xCD5D	0x72CB	# <CJK>
0xCD5E	0x72D8	# <CJK>
0xCD5F	0x72C9	# <CJK>
0xCD60	0x72DC	# <CJK>
0xCD61	0x72D2	# <CJK>
0xCD62	0x72D4	# <CJK>
0xCD63	0x72DA	# <CJK>
0xCD64	0x72CC	# <CJK>
0xCD65	0x72D1	# <CJK>
0xCD66	0x73A4	# <CJK>
0xCD67	0x73A1	# <CJK>
0xCD68	0x73AD	# <CJK>
0xCD69	0x73A6	# <CJK>
0xCD6A	0x73A2	# <CJK>
0xCD6B	0x73A0	# <CJK>
0xCD6C	0x73AC	# <CJK>
0xCD6D	0x739D	# <CJK>
0xCD6E	0x74DD	# <CJK>
0xCD6F	0x74E8	# <CJK>
0xCD70	0x753F	# <CJK>
0xCD71	0x7540	# <CJK>
0xCD72	0x753E	# <CJK>
0xCD73	0x758C	# <CJK>
0xCD74	0x7598	# <CJK>
0xCD75	0x76AF	# <CJK>
0xCD76	0x76F3	# <CJK>
0xCD77	0x76F1	# <CJK>
0xCD78	0x76F0	# <CJK>
0xCD79	0x76F5	# <CJK>
0xCD7A	0x77F8	# <CJK>
0xCD7B	0x77FC	# <CJK>
0xCD7C	0x77F9	# <CJK>
0xCD7D	0x77FB	# <CJK>
0xCD7E	0x77FA	# <CJK>
0xCDA1	0x77F7	# <CJK>
0xCDA2	0x7942	# <CJK>
0xCDA3	0x793F	# <CJK>
0xCDA4	0x79C5	# <CJK>
0xCDA5	0x7A78	# <CJK>
0xCDA6	0x7A7B	# <CJK>
0xCDA7	0x7AFB	# <CJK>
0xCDA8	0x7C75	# <CJK>
0xCDA9	0x7CFD	# <CJK>
0xCDAA	0x8035	# <CJK>
0xCDAB	0x808F	# <CJK>
0xCDAC	0x80AE	# <CJK>
0xCDAD	0x80A3	# <CJK>
0xCDAE	0x80B8	# <CJK>
0xCDAF	0x80B5	# <CJK>
0xCDB0	0x80AD	# <CJK>
0xCDB1	0x8220	# <CJK>
0xCDB2	0x82A0	# <CJK>
0xCDB3	0x82C0	# <CJK>
0xCDB4	0x82AB	# <CJK>
0xCDB5	0x829A	# <CJK>
0xCDB6	0x8298	# <CJK>
0xCDB7	0x829B	# <CJK>
0xCDB8	0x82B5	# <CJK>
0xCDB9	0x82A7	# <CJK>
0xCDBA	0x82AE	# <CJK>
0xCDBB	0x82BC	# <CJK>
0xCDBC	0x829E	# <CJK>
0xCDBD	0x82BA	# <CJK>
0xCDBE	0x82B4	# <CJK>
0xCDBF	0x82A8	# <CJK>
0xCDC0	0x82A1	# <CJK>
0xCDC1	0x82A9	# <CJK>
0xCDC2	0x82C2	# <CJK>
0xCDC3	0x82A4	# <CJK>
0xCDC4	0x82C3	# <CJK>
0xCDC5	0x82B6	# <CJK>
0xCDC6	0x82A2	# <CJK>
0xCDC7	0x8670	# <CJK>
0xCDC8	0x866F	# <CJK>
0xCDC9	0x866D	# <CJK>
0xCDCA	0x866E	# <CJK>
0xCDCB	0x8C56	# <CJK>
0xCDCC	0x8FD2	# <CJK>
0xCDCD	0x8FCB	# <CJK>
0xCDCE	0x8FD3	# <CJK>
0xCDCF	0x8FCD	# <CJK>
0xCDD0	0x8FD6	# <CJK>
0xCDD1	0x8FD5	# <CJK>
0xCDD2	0x8FD7	# <CJK>
0xCDD3	0x90B2	# <CJK>
0xCDD4	0x90B4	# <CJK>
0xCDD5	0x90AF	# <CJK>
0xCDD6	0x90B3	# <CJK>
0xCDD7	0x90B0	# <CJK>
0xCDD8	0x9639	# <CJK>
0xCDD9	0x963D	# <CJK>
0xCDDA	0x963C	# <CJK>
0xCDDB	0x963A	# <CJK>
0xCDDC	0x9643	# <CJK>
0xCDDD	0x4FCD	# <CJK>
0xCDDE	0x4FC5	# <CJK>
0xCDDF	0x4FD3	# <CJK>
0xCDE0	0x4FB2	# <CJK>
0xCDE1	0x4FC9	# <CJK>
0xCDE2	0x4FCB	# <CJK>
0xCDE3	0x4FC1	# <CJK>
0xCDE4	0x4FD4	# <CJK>
0xCDE5	0x4FDC	# <CJK>
0xCDE6	0x4FD9	# <CJK>
0xCDE7	0x4FBB	# <CJK>
0xCDE8	0x4FB3	# <CJK>
0xCDE9	0x4FDB	# <CJK>
0xCDEA	0x4FC7	# <CJK>
0xCDEB	0x4FD6	# <CJK>
0xCDEC	0x4FBA	# <CJK>
0xCDED	0x4FC0	# <CJK>
0xCDEE	0x4FB9	# <CJK>
0xCDEF	0x4FEC	# <CJK>
0xCDF0	0x5244	# <CJK>
0xCDF1	0x5249	# <CJK>
0xCDF2	0x52C0	# <CJK>
0xCDF3	0x52C2	# <CJK>
0xCDF4	0x533D	# <CJK>
0xCDF5	0x537C	# <CJK>
0xCDF6	0x5397	# <CJK>
0xCDF7	0x5396	# <CJK>
0xCDF8	0x5399	# <CJK>
0xCDF9	0x5398	# <CJK>
0xCDFA	0x54BA	# <CJK>
0xCDFB	0x54A1	# <CJK>
0xCDFC	0x54AD	# <CJK>
0xCDFD	0x54A5	# <CJK>
0xCDFE	0x54CF	# <CJK>
0xCE40	0x54C3	# <CJK>
0xCE41	0x830D	# <CJK>
0xCE42	0x54B7	# <CJK>
0xCE43	0x54AE	# <CJK>
0xCE44	0x54D6	# <CJK>
0xCE45	0x54B6	# <CJK>
0xCE46	0x54C5	# <CJK>
0xCE47	0x54C6	# <CJK>
0xCE48	0x54A0	# <CJK>
0xCE49	0x5470	# <CJK>
0xCE4A	0x54BC	# <CJK>
0xCE4B	0x54A2	# <CJK>
0xCE4C	0x54BE	# <CJK>
0xCE4D	0x5472	# <CJK>
0xCE4E	0x54DE	# <CJK>
0xCE4F	0x54B0	# <CJK>
0xCE50	0x57B5	# <CJK>
0xCE51	0x579E	# <CJK>
0xCE52	0x579F	# <CJK>
0xCE53	0x57A4	# <CJK>
0xCE54	0x578C	# <CJK>
0xCE55	0x5797	# <CJK>
0xCE56	0x579D	# <CJK>
0xCE57	0x579B	# <CJK>
0xCE58	0x5794	# <CJK>
0xCE59	0x5798	# <CJK>
0xCE5A	0x578F	# <CJK>
0xCE5B	0x5799	# <CJK>
0xCE5C	0x57A5	# <CJK>
0xCE5D	0x579A	# <CJK>
0xCE5E	0x5795	# <CJK>
0xCE5F	0x58F4	# <CJK>
0xCE60	0x590D	# <CJK>
0xCE61	0x5953	# <CJK>
0xCE62	0x59E1	# <CJK>
0xCE63	0x59DE	# <CJK>
0xCE64	0x59EE	# <CJK>
0xCE65	0x5A00	# <CJK>
0xCE66	0x59F1	# <CJK>
0xCE67	0x59DD	# <CJK>
0xCE68	0x59FA	# <CJK>
0xCE69	0x59FD	# <CJK>
0xCE6A	0x59FC	# <CJK>
0xCE6B	0x59F6	# <CJK>
0xCE6C	0x59E4	# <CJK>
0xCE6D	0x59F2	# <CJK>
0xCE6E	0x59F7	# <CJK>
0xCE6F	0x59DB	# <CJK>
0xCE70	0x59E9	# <CJK>
0xCE71	0x59F3	# <CJK>
0xCE72	0x59F5	# <CJK>
0xCE73	0x59E0	# <CJK>
0xCE74	0x59FE	# <CJK>
0xCE75	0x59F4	# <CJK>
0xCE76	0x59ED	# <CJK>
0xCE77	0x5BA8	# <CJK>
0xCE78	0x5C4C	# <CJK>
0xCE79	0x5CD0	# <CJK>
0xCE7A	0x5CD8	# <CJK>
0xCE7B	0x5CCC	# <CJK>
0xCE7C	0x5CD7	# <CJK>
0xCE7D	0x5CCB	# <CJK>
0xCE7E	0x5CDB	# <CJK>
0xCEA1	0x5CDE	# <CJK>
0xCEA2	0x5CDA	# <CJK>
0xCEA3	0x5CC9	# <CJK>
0xCEA4	0x5CC7	# <CJK>
0xCEA5	0x5CCA	# <CJK>
0xCEA6	0x5CD6	# <CJK>
0xCEA7	0x5CD3	# <CJK>
0xCEA8	0x5CD4	# <CJK>
0xCEA9	0x5CCF	# <CJK>
0xCEAA	0x5CC8	# <CJK>
0xCEAB	0x5CC6	# <CJK>
0xCEAC	0x5CCE	# <CJK>
0xCEAD	0x5CDF	# <CJK>
0xCEAE	0x5CF8	# <CJK>
0xCEAF	0x5DF9	# <CJK>
0xCEB0	0x5E21	# <CJK>
0xCEB1	0x5E22	# <CJK>
0xCEB2	0x5E23	# <CJK>
0xCEB3	0x5E20	# <CJK>
0xCEB4	0x5E24	# <CJK>
0xCEB5	0x5EB0	# <CJK>
0xCEB6	0x5EA4	# <CJK>
0xCEB7	0x5EA2	# <CJK>
0xCEB8	0x5E9B	# <CJK>
0xCEB9	0x5EA3	# <CJK>
0xCEBA	0x5EA5	# <CJK>
0xCEBB	0x5F07	# <CJK>
0xCEBC	0x5F2E	# <CJK>
0xCEBD	0x5F56	# <CJK>
0xCEBE	0x5F86	# <CJK>
0xCEBF	0x6037	# <CJK>
0xCEC0	0x6039	# <CJK>
0xCEC1	0x6054	# <CJK>
0xCEC2	0x6072	# <CJK>
0xCEC3	0x605E	# <CJK>
0xCEC4	0x6045	# <CJK>
0xCEC5	0x6053	# <CJK>
0xCEC6	0x6047	# <CJK>
0xCEC7	0x6049	# <CJK>
0xCEC8	0x605B	# <CJK>
0xCEC9	0x604C	# <CJK>
0xCECA	0x6040	# <CJK>
0xCECB	0x6042	# <CJK>
0xCECC	0x605F	# <CJK>
0xCECD	0x6024	# <CJK>
0xCECE	0x6044	# <CJK>
0xCECF	0x6058	# <CJK>
0xCED0	0x6066	# <CJK>
0xCED1	0x606E	# <CJK>
0xCED2	0x6242	# <CJK>
0xCED3	0x6243	# <CJK>
0xCED4	0x62CF	# <CJK>
0xCED5	0x630D	# <CJK>
0xCED6	0x630B	# <CJK>
0xCED7	0x62F5	# <CJK>
0xCED8	0x630E	# <CJK>
0xCED9	0x6303	# <CJK>
0xCEDA	0x62EB	# <CJK>
0xCEDB	0x62F9	# <CJK>
0xCEDC	0x630F	# <CJK>
0xCEDD	0x630C	# <CJK>
0xCEDE	0x62F8	# <CJK>
0xCEDF	0x62F6	# <CJK>
0xCEE0	0x6300	# <CJK>
0xCEE1	0x6313	# <CJK>
0xCEE2	0x6314	# <CJK>
0xCEE3	0x62FA	# <CJK>
0xCEE4	0x6315	# <CJK>
0xCEE5	0x62FB	# <CJK>
0xCEE6	0x62F0	# <CJK>
0xCEE7	0x6541	# <CJK>
0xCEE8	0x6543	# <CJK>
0xCEE9	0x65AA	# <CJK>
0xCEEA	0x65BF	# <CJK>
0xCEEB	0x6636	# <CJK>
0xCEEC	0x6621	# <CJK>
0xCEED	0x6632	# <CJK>
0xCEEE	0x6635	# <CJK>
0xCEEF	0x661C	# <CJK>
0xCEF0	0x6626	# <CJK>
0xCEF1	0x6622	# <CJK>
0xCEF2	0x6633	# <CJK>
0xCEF3	0x662B	# <CJK>
0xCEF4	0x663A	# <CJK>
0xCEF5	0x661D	# <CJK>
0xCEF6	0x6634	# <CJK>
0xCEF7	0x6639	# <CJK>
0xCEF8	0x662E	# <CJK>
0xCEF9	0x670F	# <CJK>
0xCEFA	0x6710	# <CJK>
0xCEFB	0x67C1	# <CJK>
0xCEFC	0x67F2	# <CJK>
0xCEFD	0x67C8	# <CJK>
0xCEFE	0x67BA	# <CJK>
0xCF40	0x67DC	# <CJK>
0xCF41	0x67BB	# <CJK>
0xCF42	0x67F8	# <CJK>
0xCF43	0x67D8	# <CJK>
0xCF44	0x67C0	# <CJK>
0xCF45	0x67B7	# <CJK>
0xCF46	0x67C5	# <CJK>
0xCF47	0x67EB	# <CJK>
0xCF48	0x67E4	# <CJK>
0xCF49	0x67DF	# <CJK>
0xCF4A	0x67B5	# <CJK>
0xCF4B	0x67CD	# <CJK>
0xCF4C	0x67B3	# <CJK>
0xCF4D	0x67F7	# <CJK>
0xCF4E	0x67F6	# <CJK>
0xCF4F	0x67EE	# <CJK>
0xCF50	0x67E3	# <CJK>
0xCF51	0x67C2	# <CJK>
0xCF52	0x67B9	# <CJK>
0xCF53	0x67CE	# <CJK>
0xCF54	0x67E7	# <CJK>
0xCF55	0x67F0	# <CJK>
0xCF56	0x67B2	# <CJK>
0xCF57	0x67FC	# <CJK>
0xCF58	0x67C6	# <CJK>
0xCF59	0x67ED	# <CJK>
0xCF5A	0x67CC	# <CJK>
0xCF5B	0x67AE	# <CJK>
0xCF5C	0x67E6	# <CJK>
0xCF5D	0x67DB	# <CJK>
0xCF5E	0x67FA	# <CJK>
0xCF5F	0x67C9	# <CJK>
0xCF60	0x67CA	# <CJK>
0xCF61	0x67C3	# <CJK>
0xCF62	0x67EA	# <CJK>
0xCF63	0x67CB	# <CJK>
0xCF64	0x6B28	# <CJK>
0xCF65	0x6B82	# <CJK>
0xCF66	0x6B84	# <CJK>
0xCF67	0x6BB6	# <CJK>
0xCF68	0x6BD6	# <CJK>
0xCF69	0x6BD8	# <CJK>
0xCF6A	0x6BE0	# <CJK>
0xCF6B	0x6C20	# <CJK>
0xCF6C	0x6C21	# <CJK>
0xCF6D	0x6D28	# <CJK>
0xCF6E	0x6D34	# <CJK>
0xCF6F	0x6D2D	# <CJK>
0xCF70	0x6D1F	# <CJK>
0xCF71	0x6D3C	# <CJK>
0xCF72	0x6D3F	# <CJK>
0xCF73	0x6D12	# <CJK>
0xCF74	0x6D0A	# <CJK>
0xCF75	0x6CDA	# <CJK>
0xCF76	0x6D33	# <CJK>
0xCF77	0x6D04	# <CJK>
0xCF78	0x6D19	# <CJK>
0xCF79	0x6D3A	# <CJK>
0xCF7A	0x6D1A	# <CJK>
0xCF7B	0x6D11	# <CJK>
0xCF7C	0x6D00	# <CJK>
0xCF7D	0x6D1D	# <CJK>
0xCF7E	0x6D42	# <CJK>
0xCFA1	0x6D01	# <CJK>
0xCFA2	0x6D18	# <CJK>
0xCFA3	0x6D37	# <CJK>
0xCFA4	0x6D03	# <CJK>
0xCFA5	0x6D0F	# <CJK>
0xCFA6	0x6D40	# <CJK>
0xCFA7	0x6D07	# <CJK>
0xCFA8	0x6D20	# <CJK>
0xCFA9	0x6D2C	# <CJK>
0xCFAA	0x6D08	# <CJK>
0xCFAB	0x6D22	# <CJK>
0xCFAC	0x6D09	# <CJK>
0xCFAD	0x6D10	# <CJK>
0xCFAE	0x70B7	# <CJK>
0xCFAF	0x709F	# <CJK>
0xCFB0	0x70BE	# <CJK>
0xCFB1	0x70B1	# <CJK>
0xCFB2	0x70B0	# <CJK>
0xCFB3	0x70A1	# <CJK>
0xCFB4	0x70B4	# <CJK>
0xCFB5	0x70B5	# <CJK>
0xCFB6	0x70A9	# <CJK>
0xCFB7	0x7241	# <CJK>
0xCFB8	0x7249	# <CJK>
0xCFB9	0x724A	# <CJK>
0xCFBA	0x726C	# <CJK>
0xCFBB	0x7270	# <CJK>
0xCFBC	0x7273	# <CJK>
0xCFBD	0x726E	# <CJK>
0xCFBE	0x72CA	# <CJK>
0xCFBF	0x72E4	# <CJK>
0xCFC0	0x72E8	# <CJK>
0xCFC1	0x72EB	# <CJK>
0xCFC2	0x72DF	# <CJK>
0xCFC3	0x72EA	# <CJK>
0xCFC4	0x72E6	# <CJK>
0xCFC5	0x72E3	# <CJK>
0xCFC6	0x7385	# <CJK>
0xCFC7	0x73CC	# <CJK>
0xCFC8	0x73C2	# <CJK>
0xCFC9	0x73C8	# <CJK>
0xCFCA	0x73C5	# <CJK>
0xCFCB	0x73B9	# <CJK>
0xCFCC	0x73B6	# <CJK>
0xCFCD	0x73B5	# <CJK>
0xCFCE	0x73B4	# <CJK>
0xCFCF	0x73EB	# <CJK>
0xCFD0	0x73BF	# <CJK>
0xCFD1	0x73C7	# <CJK>
0xCFD2	0x73BE	# <CJK>
0xCFD3	0x73C3	# <CJK>
0xCFD4	0x73C6	# <CJK>
0xCFD5	0x73B8	# <CJK>
0xCFD6	0x73CB	# <CJK>
0xCFD7	0x74EC	# <CJK>
0xCFD8	0x74EE	# <CJK>
0xCFD9	0x752E	# <CJK>
0xCFDA	0x7547	# <CJK>
0xCFDB	0x7548	# <CJK>
0xCFDC	0x75A7	# <CJK>
0xCFDD	0x75AA	# <CJK>
0xCFDE	0x7679	# <CJK>
0xCFDF	0x76C4	# <CJK>
0xCFE0	0x7708	# <CJK>
0xCFE1	0x7703	# <CJK>
0xCFE2	0x7704	# <CJK>
0xCFE3	0x7705	# <CJK>
0xCFE4	0x770A	# <CJK>
0xCFE5	0x76F7	# <CJK>
0xCFE6	0x76FB	# <CJK>
0xCFE7	0x76FA	# <CJK>
0xCFE8	0x77E7	# <CJK>
0xCFE9	0x77E8	# <CJK>
0xCFEA	0x7806	# <CJK>
0xCFEB	0x7811	# <CJK>
0xCFEC	0x7812	# <CJK>
0xCFED	0x7805	# <CJK>
0xCFEE	0x7810	# <CJK>
0xCFEF	0x780F	# <CJK>
0xCFF0	0x780E	# <CJK>
0xCFF1	0x7809	# <CJK>
0xCFF2	0x7803	# <CJK>
0xCFF3	0x7813	# <CJK>
0xCFF4	0x794A	# <CJK>
0xCFF5	0x794C	# <CJK>
0xCFF6	0x794B	# <CJK>
0xCFF7	0x7945	# <CJK>
0xCFF8	0x7944	# <CJK>
0xCFF9	0x79D5	# <CJK>
0xCFFA	0x79CD	# <CJK>
0xCFFB	0x79CF	# <CJK>
0xCFFC	0x79D6	# <CJK>
0xCFFD	0x79CE	# <CJK>
0xCFFE	0x7A80	# <CJK>
0xD040	0x7A7E	# <CJK>
0xD041	0x7AD1	# <CJK>
0xD042	0x7B00	# <CJK>
0xD043	0x7B01	# <CJK>
0xD044	0x7C7A	# <CJK>
0xD045	0x7C78	# <CJK>
0xD046	0x7C79	# <CJK>
0xD047	0x7C7F	# <CJK>
0xD048	0x7C80	# <CJK>
0xD049	0x7C81	# <CJK>
0xD04A	0x7D03	# <CJK>
0xD04B	0x7D08	# <CJK>
0xD04C	0x7D01	# <CJK>
0xD04D	0x7F58	# <CJK>
0xD04E	0x7F91	# <CJK>
0xD04F	0x7F8D	# <CJK>
0xD050	0x7FBE	# <CJK>
0xD051	0x8007	# <CJK>
0xD052	0x800E	# <CJK>
0xD053	0x800F	# <CJK>
0xD054	0x8014	# <CJK>
0xD055	0x8037	# <CJK>
0xD056	0x80D8	# <CJK>
0xD057	0x80C7	# <CJK>
0xD058	0x80E0	# <CJK>
0xD059	0x80D1	# <CJK>
0xD05A	0x80C8	# <CJK>
0xD05B	0x80C2	# <CJK>
0xD05C	0x80D0	# <CJK>
0xD05D	0x80C5	# <CJK>
0xD05E	0x80E3	# <CJK>
0xD05F	0x80D9	# <CJK>
0xD060	0x80DC	# <CJK>
0xD061	0x80CA	# <CJK>
0xD062	0x80D5	# <CJK>
0xD063	0x80C9	# <CJK>
0xD064	0x80CF	# <CJK>
0xD065	0x80D7	# <CJK>
0xD066	0x80E6	# <CJK>
0xD067	0x80CD	# <CJK>
0xD068	0x81FF	# <CJK>
0xD069	0x8221	# <CJK>
0xD06A	0x8294	# <CJK>
0xD06B	0x82D9	# <CJK>
0xD06C	0x82FE	# <CJK>
0xD06D	0x82F9	# <CJK>
0xD06E	0x8307	# <CJK>
0xD06F	0x82E8	# <CJK>
0xD070	0x8300	# <CJK>
0xD071	0x82D5	# <CJK>
0xD072	0x833A	# <CJK>
0xD073	0x82EB	# <CJK>
0xD074	0x82D6	# <CJK>
0xD075	0x82F4	# <CJK>
0xD076	0x82EC	# <CJK>
0xD077	0x82E1	# <CJK>
0xD078	0x82F2	# <CJK>
0xD079	0x82F5	# <CJK>
0xD07A	0x830C	# <CJK>
0xD07B	0x82FB	# <CJK>
0xD07C	0x82F6	# <CJK>
0xD07D	0x82F0	# <CJK>
0xD07E	0x82EA	# <CJK>
0xD0A1	0x82E4	# <CJK>
0xD0A2	0x82E0	# <CJK>
0xD0A3	0x82FA	# <CJK>
0xD0A4	0x82F3	# <CJK>
0xD0A5	0x82ED	# <CJK>
0xD0A6	0x8677	# <CJK>
0xD0A7	0x8674	# <CJK>
0xD0A8	0x867C	# <CJK>
0xD0A9	0x8673	# <CJK>
0xD0AA	0x8841	# <CJK>
0xD0AB	0x884E	# <CJK>
0xD0AC	0x8867	# <CJK>
0xD0AD	0x886A	# <CJK>
0xD0AE	0x8869	# <CJK>
0xD0AF	0x89D3	# <CJK>
0xD0B0	0x8A04	# <CJK>
0xD0B1	0x8A07	# <CJK>
0xD0B2	0x8D72	# <CJK>
0xD0B3	0x8FE3	# <CJK>
0xD0B4	0x8FE1	# <CJK>
0xD0B5	0x8FEE	# <CJK>
0xD0B6	0x8FE0	# <CJK>
0xD0B7	0x90F1	# <CJK>
0xD0B8	0x90BD	# <CJK>
0xD0B9	0x90BF	# <CJK>
0xD0BA	0x90D5	# <CJK>
0xD0BB	0x90C5	# <CJK>
0xD0BC	0x90BE	# <CJK>
0xD0BD	0x90C7	# <CJK>
0xD0BE	0x90CB	# <CJK>
0xD0BF	0x90C8	# <CJK>
0xD0C0	0x91D4	# <CJK>
0xD0C1	0x91D3	# <CJK>
0xD0C2	0x9654	# <CJK>
0xD0C3	0x964F	# <CJK>
0xD0C4	0x9651	# <CJK>
0xD0C5	0x9653	# <CJK>
0xD0C6	0x964A	# <CJK>
0xD0C7	0x964E	# <CJK>
0xD0C8	0x501E	# <CJK>
0xD0C9	0x5005	# <CJK>
0xD0CA	0x5007	# <CJK>
0xD0CB	0x5013	# <CJK>
0xD0CC	0x5022	# <CJK>
0xD0CD	0x5030	# <CJK>
0xD0CE	0x501B	# <CJK>
0xD0CF	0x4FF5	# <CJK>
0xD0D0	0x4FF4	# <CJK>
0xD0D1	0x5033	# <CJK>
0xD0D2	0x5037	# <CJK>
0xD0D3	0x502C	# <CJK>
0xD0D4	0x4FF6	# <CJK>
0xD0D5	0x4FF7	# <CJK>
0xD0D6	0x5017	# <CJK>
0xD0D7	0x501C	# <CJK>
0xD0D8	0x5020	# <CJK>
0xD0D9	0x5027	# <CJK>
0xD0DA	0x5035	# <CJK>
0xD0DB	0x502F	# <CJK>
0xD0DC	0x5031	# <CJK>
0xD0DD	0x500E	# <CJK>
0xD0DE	0x515A	# <CJK>
0xD0DF	0x5194	# <CJK>
0xD0E0	0x5193	# <CJK>
0xD0E1	0x51CA	# <CJK>
0xD0E2	0x51C4	# <CJK>
0xD0E3	0x51C5	# <CJK>
0xD0E4	0x51C8	# <CJK>
0xD0E5	0x51CE	# <CJK>
0xD0E6	0x5261	# <CJK>
0xD0E7	0x525A	# <CJK>
0xD0E8	0x5252	# <CJK>
0xD0E9	0x525E	# <CJK>
0xD0EA	0x525F	# <CJK>
0xD0EB	0x5255	# <CJK>
0xD0EC	0x5262	# <CJK>
0xD0ED	0x52CD	# <CJK>
0xD0EE	0x530E	# <CJK>
0xD0EF	0x539E	# <CJK>
0xD0F0	0x5526	# <CJK>
0xD0F1	0x54E2	# <CJK>
0xD0F2	0x5517	# <CJK>
0xD0F3	0x5512	# <CJK>
0xD0F4	0x54E7	# <CJK>
0xD0F5	0x54F3	# <CJK>
0xD0F6	0x54E4	# <CJK>
0xD0F7	0x551A	# <CJK>
0xD0F8	0x54FF	# <CJK>
0xD0F9	0x5504	# <CJK>
0xD0FA	0x5508	# <CJK>
0xD0FB	0x54EB	# <CJK>
0xD0FC	0x5511	# <CJK>
0xD0FD	0x5505	# <CJK>
0xD0FE	0x54F1	# <CJK>
0xD140	0x550A	# <CJK>
0xD141	0x54FB	# <CJK>
0xD142	0x54F7	# <CJK>
0xD143	0x54F8	# <CJK>
0xD144	0x54E0	# <CJK>
0xD145	0x550E	# <CJK>
0xD146	0x5503	# <CJK>
0xD147	0x550B	# <CJK>
0xD148	0x5701	# <CJK>
0xD149	0x5702	# <CJK>
0xD14A	0x57CC	# <CJK>
0xD14B	0x5832	# <CJK>
0xD14C	0x57D5	# <CJK>
0xD14D	0x57D2	# <CJK>
0xD14E	0x57BA	# <CJK>
0xD14F	0x57C6	# <CJK>
0xD150	0x57BD	# <CJK>
0xD151	0x57BC	# <CJK>
0xD152	0x57B8	# <CJK>
0xD153	0x57B6	# <CJK>
0xD154	0x57BF	# <CJK>
0xD155	0x57C7	# <CJK>
0xD156	0x57D0	# <CJK>
0xD157	0x57B9	# <CJK>
0xD158	0x57C1	# <CJK>
0xD159	0x590E	# <CJK>
0xD15A	0x594A	# <CJK>
0xD15B	0x5A19	# <CJK>
0xD15C	0x5A16	# <CJK>
0xD15D	0x5A2D	# <CJK>
0xD15E	0x5A2E	# <CJK>
0xD15F	0x5A15	# <CJK>
0xD160	0x5A0F	# <CJK>
0xD161	0x5A17	# <CJK>
0xD162	0x5A0A	# <CJK>
0xD163	0x5A1E	# <CJK>
0xD164	0x5A33	# <CJK>
0xD165	0x5B6C	# <CJK>
0xD166	0x5BA7	# <CJK>
0xD167	0x5BAD	# <CJK>
0xD168	0x5BAC	# <CJK>
0xD169	0x5C03	# <CJK>
0xD16A	0x5C56	# <CJK>
0xD16B	0x5C54	# <CJK>
0xD16C	0x5CEC	# <CJK>
0xD16D	0x5CFF	# <CJK>
0xD16E	0x5CEE	# <CJK>
0xD16F	0x5CF1	# <CJK>
0xD170	0x5CF7	# <CJK>
0xD171	0x5D00	# <CJK>
0xD172	0x5CF9	# <CJK>
0xD173	0x5E29	# <CJK>
0xD174	0x5E28	# <CJK>
0xD175	0x5EA8	# <CJK>
0xD176	0x5EAE	# <CJK>
0xD177	0x5EAA	# <CJK>
0xD178	0x5EAC	# <CJK>
0xD179	0x5F33	# <CJK>
0xD17A	0x5F30	# <CJK>
0xD17B	0x5F67	# <CJK>
0xD17C	0x605D	# <CJK>
0xD17D	0x605A	# <CJK>
0xD17E	0x6067	# <CJK>
0xD1A1	0x6041	# <CJK>
0xD1A2	0x60A2	# <CJK>
0xD1A3	0x6088	# <CJK>
0xD1A4	0x6080	# <CJK>
0xD1A5	0x6092	# <CJK>
0xD1A6	0x6081	# <CJK>
0xD1A7	0x609D	# <CJK>
0xD1A8	0x6083	# <CJK>
0xD1A9	0x6095	# <CJK>
0xD1AA	0x609B	# <CJK>
0xD1AB	0x6097	# <CJK>
0xD1AC	0x6087	# <CJK>
0xD1AD	0x609C	# <CJK>
0xD1AE	0x608E	# <CJK>
0xD1AF	0x6219	# <CJK>
0xD1B0	0x6246	# <CJK>
0xD1B1	0x62F2	# <CJK>
0xD1B2	0x6310	# <CJK>
0xD1B3	0x6356	# <CJK>
0xD1B4	0x632C	# <CJK>
0xD1B5	0x6344	# <CJK>
0xD1B6	0x6345	# <CJK>
0xD1B7	0x6336	# <CJK>
0xD1B8	0x6343	# <CJK>
0xD1B9	0x63E4	# <CJK>
0xD1BA	0x6339	# <CJK>
0xD1BB	0x634B	# <CJK>
0xD1BC	0x634A	# <CJK>
0xD1BD	0x633C	# <CJK>
0xD1BE	0x6329	# <CJK>
0xD1BF	0x6341	# <CJK>
0xD1C0	0x6334	# <CJK>
0xD1C1	0x6358	# <CJK>
0xD1C2	0x6354	# <CJK>
0xD1C3	0x6359	# <CJK>
0xD1C4	0x632D	# <CJK>
0xD1C5	0x6347	# <CJK>
0xD1C6	0x6333	# <CJK>
0xD1C7	0x635A	# <CJK>
0xD1C8	0x6351	# <CJK>
0xD1C9	0x6338	# <CJK>
0xD1CA	0x6357	# <CJK>
0xD1CB	0x6340	# <CJK>
0xD1CC	0x6348	# <CJK>
0xD1CD	0x654A	# <CJK>
0xD1CE	0x6546	# <CJK>
0xD1CF	0x65C6	# <CJK>
0xD1D0	0x65C3	# <CJK>
0xD1D1	0x65C4	# <CJK>
0xD1D2	0x65C2	# <CJK>
0xD1D3	0x664A	# <CJK>
0xD1D4	0x665F	# <CJK>
0xD1D5	0x6647	# <CJK>
0xD1D6	0x6651	# <CJK>
0xD1D7	0x6712	# <CJK>
0xD1D8	0x6713	# <CJK>
0xD1D9	0x681F	# <CJK>
0xD1DA	0x681A	# <CJK>
0xD1DB	0x6849	# <CJK>
0xD1DC	0x6832	# <CJK>
0xD1DD	0x6833	# <CJK>
0xD1DE	0x683B	# <CJK>
0xD1DF	0x684B	# <CJK>
0xD1E0	0x684F	# <CJK>
0xD1E1	0x6816	# <CJK>
0xD1E2	0x6831	# <CJK>
0xD1E3	0x681C	# <CJK>
0xD1E4	0x6835	# <CJK>
0xD1E5	0x682B	# <CJK>
0xD1E6	0x682D	# <CJK>
0xD1E7	0x682F	# <CJK>
0xD1E8	0x684E	# <CJK>
0xD1E9	0x6844	# <CJK>
0xD1EA	0x6834	# <CJK>
0xD1EB	0x681D	# <CJK>
0xD1EC	0x6812	# <CJK>
0xD1ED	0x6814	# <CJK>
0xD1EE	0x6826	# <CJK>
0xD1EF	0x6828	# <CJK>
0xD1F0	0x682E	# <CJK>
0xD1F1	0x684D	# <CJK>
0xD1F2	0x683A	# <CJK>
0xD1F3	0x6825	# <CJK>
0xD1F4	0x6820	# <CJK>
0xD1F5	0x6B2C	# <CJK>
0xD1F6	0x6B2F	# <CJK>
0xD1F7	0x6B2D	# <CJK>
0xD1F8	0x6B31	# <CJK>
0xD1F9	0x6B34	# <CJK>
0xD1FA	0x6B6D	# <CJK>
0xD1FB	0x8082	# <CJK>
0xD1FC	0x6B88	# <CJK>
0xD1FD	0x6BE6	# <CJK>
0xD1FE	0x6BE4	# <CJK>
0xD240	0x6BE8	# <CJK>
0xD241	0x6BE3	# <CJK>
0xD242	0x6BE2	# <CJK>
0xD243	0x6BE7	# <CJK>
0xD244	0x6C25	# <CJK>
0xD245	0x6D7A	# <CJK>
0xD246	0x6D63	# <CJK>
0xD247	0x6D64	# <CJK>
0xD248	0x6D76	# <CJK>
0xD249	0x6D0D	# <CJK>
0xD24A	0x6D61	# <CJK>
0xD24B	0x6D92	# <CJK>
0xD24C	0x6D58	# <CJK>
0xD24D	0x6D62	# <CJK>
0xD24E	0x6D6D	# <CJK>
0xD24F	0x6D6F	# <CJK>
0xD250	0x6D91	# <CJK>
0xD251	0x6D8D	# <CJK>
0xD252	0x6DEF	# <CJK>
0xD253	0x6D7F	# <CJK>
0xD254	0x6D86	# <CJK>
0xD255	0x6D5E	# <CJK>
0xD256	0x6D67	# <CJK>
0xD257	0x6D60	# <CJK>
0xD258	0x6D97	# <CJK>
0xD259	0x6D70	# <CJK>
0xD25A	0x6D7C	# <CJK>
0xD25B	0x6D5F	# <CJK>
0xD25C	0x6D82	# <CJK>
0xD25D	0x6D98	# <CJK>
0xD25E	0x6D2F	# <CJK>
0xD25F	0x6D68	# <CJK>
0xD260	0x6D8B	# <CJK>
0xD261	0x6D7E	# <CJK>
0xD262	0x6D80	# <CJK>
0xD263	0x6D84	# <CJK>
0xD264	0x6D16	# <CJK>
0xD265	0x6D83	# <CJK>
0xD266	0x6D7B	# <CJK>
0xD267	0x6D7D	# <CJK>
0xD268	0x6D75	# <CJK>
0xD269	0x6D90	# <CJK>
0xD26A	0x70DC	# <CJK>
0xD26B	0x70D3	# <CJK>
0xD26C	0x70D1	# <CJK>
0xD26D	0x70DD	# <CJK>
0xD26E	0x70CB	# <CJK>
0xD26F	0x7F39	# <CJK>
0xD270	0x70E2	# <CJK>
0xD271	0x70D7	# <CJK>
0xD272	0x70D2	# <CJK>
0xD273	0x70DE	# <CJK>
0xD274	0x70E0	# <CJK>
0xD275	0x70D4	# <CJK>
0xD276	0x70CD	# <CJK>
0xD277	0x70C5	# <CJK>
0xD278	0x70C6	# <CJK>
0xD279	0x70C7	# <CJK>
0xD27A	0x70DA	# <CJK>
0xD27B	0x70CE	# <CJK>
0xD27C	0x70E1	# <CJK>
0xD27D	0x7242	# <CJK>
0xD27E	0x7278	# <CJK>
0xD2A1	0x7277	# <CJK>
0xD2A2	0x7276	# <CJK>
0xD2A3	0x7300	# <CJK>
0xD2A4	0x72FA	# <CJK>
0xD2A5	0x72F4	# <CJK>
0xD2A6	0x72FE	# <CJK>
0xD2A7	0x72F6	# <CJK>
0xD2A8	0x72F3	# <CJK>
0xD2A9	0x72FB	# <CJK>
0xD2AA	0x7301	# <CJK>
0xD2AB	0x73D3	# <CJK>
0xD2AC	0x73D9	# <CJK>
0xD2AD	0x73E5	# <CJK>
0xD2AE	0x73D6	# <CJK>
0xD2AF	0x73BC	# <CJK>
0xD2B0	0x73E7	# <CJK>
0xD2B1	0x73E3	# <CJK>
0xD2B2	0x73E9	# <CJK>
0xD2B3	0x73DC	# <CJK>
0xD2B4	0x73D2	# <CJK>
0xD2B5	0x73DB	# <CJK>
0xD2B6	0x73D4	# <CJK>
0xD2B7	0x73DD	# <CJK>
0xD2B8	0x73DA	# <CJK>
0xD2B9	0x73D7	# <CJK>
0xD2BA	0x73D8	# <CJK>
0xD2BB	0x73E8	# <CJK>
0xD2BC	0x74DE	# <CJK>
0xD2BD	0x74DF	# <CJK>
0xD2BE	0x74F4	# <CJK>
0xD2BF	0x74F5	# <CJK>
0xD2C0	0x7521	# <CJK>
0xD2C1	0x755B	# <CJK>
0xD2C2	0x755F	# <CJK>
0xD2C3	0x75B0	# <CJK>
0xD2C4	0x75C1	# <CJK>
0xD2C5	0x75BB	# <CJK>
0xD2C6	0x75C4	# <CJK>
0xD2C7	0x75C0	# <CJK>
0xD2C8	0x75BF	# <CJK>
0xD2C9	0x75B6	# <CJK>
0xD2CA	0x75BA	# <CJK>
0xD2CB	0x768A	# <CJK>
0xD2CC	0x76C9	# <CJK>
0xD2CD	0x771D	# <CJK>
0xD2CE	0x771B	# <CJK>
0xD2CF	0x7710	# <CJK>
0xD2D0	0x7713	# <CJK>
0xD2D1	0x7712	# <CJK>
0xD2D2	0x7723	# <CJK>
0xD2D3	0x7711	# <CJK>
0xD2D4	0x7715	# <CJK>
0xD2D5	0x7719	# <CJK>
0xD2D6	0x771A	# <CJK>
0xD2D7	0x7722	# <CJK>
0xD2D8	0x7727	# <CJK>
0xD2D9	0x7823	# <CJK>
0xD2DA	0x782C	# <CJK>
0xD2DB	0x7822	# <CJK>
0xD2DC	0x7835	# <CJK>
0xD2DD	0x782F	# <CJK>
0xD2DE	0x7828	# <CJK>
0xD2DF	0x782E	# <CJK>
0xD2E0	0x782B	# <CJK>
0xD2E1	0x7821	# <CJK>
0xD2E2	0x7829	# <CJK>
0xD2E3	0x7833	# <CJK>
0xD2E4	0x782A	# <CJK>
0xD2E5	0x7831	# <CJK>
0xD2E6	0x7954	# <CJK>
0xD2E7	0x795B	# <CJK>
0xD2E8	0x794F	# <CJK>
0xD2E9	0x795C	# <CJK>
0xD2EA	0x7953	# <CJK>
0xD2EB	0x7952	# <CJK>
0xD2EC	0x7951	# <CJK>
0xD2ED	0x79EB	# <CJK>
0xD2EE	0x79EC	# <CJK>
0xD2EF	0x79E0	# <CJK>
0xD2F0	0x79EE	# <CJK>
0xD2F1	0x79ED	# <CJK>
0xD2F2	0x79EA	# <CJK>
0xD2F3	0x79DC	# <CJK>
0xD2F4	0x79DE	# <CJK>
0xD2F5	0x79DD	# <CJK>
0xD2F6	0x7A86	# <CJK>
0xD2F7	0x7A89	# <CJK>
0xD2F8	0x7A85	# <CJK>
0xD2F9	0x7A8B	# <CJK>
0xD2FA	0x7A8C	# <CJK>
0xD2FB	0x7A8A	# <CJK>
0xD2FC	0x7A87	# <CJK>
0xD2FD	0x7AD8	# <CJK>
0xD2FE	0x7B10	# <CJK>
0xD340	0x7B04	# <CJK>
0xD341	0x7B13	# <CJK>
0xD342	0x7B05	# <CJK>
0xD343	0x7B0F	# <CJK>
0xD344	0x7B08	# <CJK>
0xD345	0x7B0A	# <CJK>
0xD346	0x7B0E	# <CJK>
0xD347	0x7B09	# <CJK>
0xD348	0x7B12	# <CJK>
0xD349	0x7C84	# <CJK>
0xD34A	0x7C91	# <CJK>
0xD34B	0x7C8A	# <CJK>
0xD34C	0x7C8C	# <CJK>
0xD34D	0x7C88	# <CJK>
0xD34E	0x7C8D	# <CJK>
0xD34F	0x7C85	# <CJK>
0xD350	0x7D1E	# <CJK>
0xD351	0x7D1D	# <CJK>
0xD352	0x7D11	# <CJK>
0xD353	0x7D0E	# <CJK>
0xD354	0x7D18	# <CJK>
0xD355	0x7D16	# <CJK>
0xD356	0x7D13	# <CJK>
0xD357	0x7D1F	# <CJK>
0xD358	0x7D12	# <CJK>
0xD359	0x7D0F	# <CJK>
0xD35A	0x7D0C	# <CJK>
0xD35B	0x7F5C	# <CJK>
0xD35C	0x7F61	# <CJK>
0xD35D	0x7F5E	# <CJK>
0xD35E	0x7F60	# <CJK>
0xD35F	0x7F5D	# <CJK>
0xD360	0x7F5B	# <CJK>
0xD361	0x7F96	# <CJK>
0xD362	0x7F92	# <CJK>
0xD363	0x7FC3	# <CJK>
0xD364	0x7FC2	# <CJK>
0xD365	0x7FC0	# <CJK>
0xD366	0x8016	# <CJK>
0xD367	0x803E	# <CJK>
0xD368	0x8039	# <CJK>
0xD369	0x80FA	# <CJK>
0xD36A	0x80F2	# <CJK>
0xD36B	0x80F9	# <CJK>
0xD36C	0x80F5	# <CJK>
0xD36D	0x8101	# <CJK>
0xD36E	0x80FB	# <CJK>
0xD36F	0x8100	# <CJK>
0xD370	0x8201	# <CJK>
0xD371	0x822F	# <CJK>
0xD372	0x8225	# <CJK>
0xD373	0x8333	# <CJK>
0xD374	0x832D	# <CJK>
0xD375	0x8344	# <CJK>
0xD376	0x8319	# <CJK>
0xD377	0x8351	# <CJK>
0xD378	0x8325	# <CJK>
0xD379	0x8356	# <CJK>
0xD37A	0x833F	# <CJK>
0xD37B	0x8341	# <CJK>
0xD37C	0x8326	# <CJK>
0xD37D	0x831C	# <CJK>
0xD37E	0x8322	# <CJK>
0xD3A1	0x8342	# <CJK>
0xD3A2	0x834E	# <CJK>
0xD3A3	0x831B	# <CJK>
0xD3A4	0x832A	# <CJK>
0xD3A5	0x8308	# <CJK>
0xD3A6	0x833C	# <CJK>
0xD3A7	0x834D	# <CJK>
0xD3A8	0x8316	# <CJK>
0xD3A9	0x8324	# <CJK>
0xD3AA	0x8320	# <CJK>
0xD3AB	0x8337	# <CJK>
0xD3AC	0x832F	# <CJK>
0xD3AD	0x8329	# <CJK>
0xD3AE	0x8347	# <CJK>
0xD3AF	0x8345	# <CJK>
0xD3B0	0x834C	# <CJK>
0xD3B1	0x8353	# <CJK>
0xD3B2	0x831E	# <CJK>
0xD3B3	0x832C	# <CJK>
0xD3B4	0x834B	# <CJK>
0xD3B5	0x8327	# <CJK>
0xD3B6	0x8348	# <CJK>
0xD3B7	0x8653	# <CJK>
0xD3B8	0x8652	# <CJK>
0xD3B9	0x86A2	# <CJK>
0xD3BA	0x86A8	# <CJK>
0xD3BB	0x8696	# <CJK>
0xD3BC	0x868D	# <CJK>
0xD3BD	0x8691	# <CJK>
0xD3BE	0x869E	# <CJK>
0xD3BF	0x8687	# <CJK>
0xD3C0	0x8697	# <CJK>
0xD3C1	0x8686	# <CJK>
0xD3C2	0x868B	# <CJK>
0xD3C3	0x869A	# <CJK>
0xD3C4	0x8685	# <CJK>
0xD3C5	0x86A5	# <CJK>
0xD3C6	0x8699	# <CJK>
0xD3C7	0x86A1	# <CJK>
0xD3C8	0x86A7	# <CJK>
0xD3C9	0x8695	# <CJK>
0xD3CA	0x8698	# <CJK>
0xD3CB	0x868E	# <CJK>
0xD3CC	0x869D	# <CJK>
0xD3CD	0x8690	# <CJK>
0xD3CE	0x8694	# <CJK>
0xD3CF	0x8843	# <CJK>
0xD3D0	0x8844	# <CJK>
0xD3D1	0x886D	# <CJK>
0xD3D2	0x8875	# <CJK>
0xD3D3	0x8876	# <CJK>
0xD3D4	0x8872	# <CJK>
0xD3D5	0x8880	# <CJK>
0xD3D6	0x8871	# <CJK>
0xD3D7	0x887F	# <CJK>
0xD3D8	0x886F	# <CJK>
0xD3D9	0x8883	# <CJK>
0xD3DA	0x887E	# <CJK>
0xD3DB	0x8874	# <CJK>
0xD3DC	0x887C	# <CJK>
0xD3DD	0x8A12	# <CJK>
0xD3DE	0x8C47	# <CJK>
0xD3DF	0x8C57	# <CJK>
0xD3E0	0x8C7B	# <CJK>
0xD3E1	0x8CA4	# <CJK>
0xD3E2	0x8CA3	# <CJK>
0xD3E3	0x8D76	# <CJK>
0xD3E4	0x8D78	# <CJK>
0xD3E5	0x8DB5	# <CJK>
0xD3E6	0x8DB7	# <CJK>
0xD3E7	0x8DB6	# <CJK>
0xD3E8	0x8ED1	# <CJK>
0xD3E9	0x8ED3	# <CJK>
0xD3EA	0x8FFE	# <CJK>
0xD3EB	0x8FF5	# <CJK>
0xD3EC	0x9002	# <CJK>
0xD3ED	0x8FFF	# <CJK>
0xD3EE	0x8FFB	# <CJK>
0xD3EF	0x9004	# <CJK>
0xD3F0	0x8FFC	# <CJK>
0xD3F1	0x8FF6	# <CJK>
0xD3F2	0x90D6	# <CJK>
0xD3F3	0x90E0	# <CJK>
0xD3F4	0x90D9	# <CJK>
0xD3F5	0x90DA	# <CJK>
0xD3F6	0x90E3	# <CJK>
0xD3F7	0x90DF	# <CJK>
0xD3F8	0x90E5	# <CJK>
0xD3F9	0x90D8	# <CJK>
0xD3FA	0x90DB	# <CJK>
0xD3FB	0x90D7	# <CJK>
0xD3FC	0x90DC	# <CJK>
0xD3FD	0x90E4	# <CJK>
0xD3FE	0x9150	# <CJK>
0xD440	0x914E	# <CJK>
0xD441	0x914F	# <CJK>
0xD442	0x91D5	# <CJK>
0xD443	0x91E2	# <CJK>
0xD444	0x91DA	# <CJK>
0xD445	0x965C	# <CJK>
0xD446	0x965F	# <CJK>
0xD447	0x96BC	# <CJK>
0xD448	0x98E3	# <CJK>
0xD449	0x9ADF	# <CJK>
0xD44A	0x9B2F	# <CJK>
0xD44B	0x4E7F	# <CJK>
0xD44C	0x5070	# <CJK>
0xD44D	0x506A	# <CJK>
0xD44E	0x5061	# <CJK>
0xD44F	0x505E	# <CJK>
0xD450	0x5060	# <CJK>
0xD451	0x5053	# <CJK>
0xD452	0x504B	# <CJK>
0xD453	0x505D	# <CJK>
0xD454	0x5072	# <CJK>
0xD455	0x5048	# <CJK>
0xD456	0x504D	# <CJK>
0xD457	0x5041	# <CJK>
0xD458	0x505B	# <CJK>
0xD459	0x504A	# <CJK>
0xD45A	0x5062	# <CJK>
0xD45B	0x5015	# <CJK>
0xD45C	0x5045	# <CJK>
0xD45D	0x505F	# <CJK>
0xD45E	0x5069	# <CJK>
0xD45F	0x506B	# <CJK>
0xD460	0x5063	# <CJK>
0xD461	0x5064	# <CJK>
0xD462	0x5046	# <CJK>
0xD463	0x5040	# <CJK>
0xD464	0x506E	# <CJK>
0xD465	0x5073	# <CJK>
0xD466	0x5057	# <CJK>
0xD467	0x5051	# <CJK>
0xD468	0x51D0	# <CJK>
0xD469	0x526B	# <CJK>
0xD46A	0x526D	# <CJK>
0xD46B	0x526C	# <CJK>
0xD46C	0x526E	# <CJK>
0xD46D	0x52D6	# <CJK>
0xD46E	0x52D3	# <CJK>
0xD46F	0x532D	# <CJK>
0xD470	0x539C	# <CJK>
0xD471	0x5575	# <CJK>
0xD472	0x5576	# <CJK>
0xD473	0x553C	# <CJK>
0xD474	0x554D	# <CJK>
0xD475	0x5550	# <CJK>
0xD476	0x5534	# <CJK>
0xD477	0x552A	# <CJK>
0xD478	0x5551	# <CJK>
0xD479	0x5562	# <CJK>
0xD47A	0x5536	# <CJK>
0xD47B	0x5535	# <CJK>
0xD47C	0x5530	# <CJK>
0xD47D	0x5552	# <CJK>
0xD47E	0x5545	# <CJK>
0xD4A1	0x550C	# <CJK>
0xD4A2	0x5532	# <CJK>
0xD4A3	0x5565	# <CJK>
0xD4A4	0x554E	# <CJK>
0xD4A5	0x5539	# <CJK>
0xD4A6	0x5548	# <CJK>
0xD4A7	0x552D	# <CJK>
0xD4A8	0x553B	# <CJK>
0xD4A9	0x5540	# <CJK>
0xD4AA	0x554B	# <CJK>
0xD4AB	0x570A	# <CJK>
0xD4AC	0x5707	# <CJK>
0xD4AD	0x57FB	# <CJK>
0xD4AE	0x5814	# <CJK>
0xD4AF	0x57E2	# <CJK>
0xD4B0	0x57F6	# <CJK>
0xD4B1	0x57DC	# <CJK>
0xD4B2	0x57F4	# <CJK>
0xD4B3	0x5800	# <CJK>
0xD4B4	0x57ED	# <CJK>
0xD4B5	0x57FD	# <CJK>
0xD4B6	0x5808	# <CJK>
0xD4B7	0x57F8	# <CJK>
0xD4B8	0x580B	# <CJK>
0xD4B9	0x57F3	# <CJK>
0xD4BA	0x57CF	# <CJK>
0xD4BB	0x5807	# <CJK>
0xD4BC	0x57EE	# <CJK>
0xD4BD	0x57E3	# <CJK>
0xD4BE	0x57F2	# <CJK>
0xD4BF	0x57E5	# <CJK>
0xD4C0	0x57EC	# <CJK>
0xD4C1	0x57E1	# <CJK>
0xD4C2	0x580E	# <CJK>
0xD4C3	0x57FC	# <CJK>
0xD4C4	0x5810	# <CJK>
0xD4C5	0x57E7	# <CJK>
0xD4C6	0x5801	# <CJK>
0xD4C7	0x580C	# <CJK>
0xD4C8	0x57F1	# <CJK>
0xD4C9	0x57E9	# <CJK>
0xD4CA	0x57F0	# <CJK>
0xD4CB	0x580D	# <CJK>
0xD4CC	0x5804	# <CJK>
0xD4CD	0x595C	# <CJK>
0xD4CE	0x5A60	# <CJK>
0xD4CF	0x5A58	# <CJK>
0xD4D0	0x5A55	# <CJK>
0xD4D1	0x5A67	# <CJK>
0xD4D2	0x5A5E	# <CJK>
0xD4D3	0x5A38	# <CJK>
0xD4D4	0x5A35	# <CJK>
0xD4D5	0x5A6D	# <CJK>
0xD4D6	0x5A50	# <CJK>
0xD4D7	0x5A5F	# <CJK>
0xD4D8	0x5A65	# <CJK>
0xD4D9	0x5A6C	# <CJK>
0xD4DA	0x5A53	# <CJK>
0xD4DB	0x5A64	# <CJK>
0xD4DC	0x5A57	# <CJK>
0xD4DD	0x5A43	# <CJK>
0xD4DE	0x5A5D	# <CJK>
0xD4DF	0x5A52	# <CJK>
0xD4E0	0x5A44	# <CJK>
0xD4E1	0x5A5B	# <CJK>
0xD4E2	0x5A48	# <CJK>
0xD4E3	0x5A8E	# <CJK>
0xD4E4	0x5A3E	# <CJK>
0xD4E5	0x5A4D	# <CJK>
0xD4E6	0x5A39	# <CJK>
0xD4E7	0x5A4C	# <CJK>
0xD4E8	0x5A70	# <CJK>
0xD4E9	0x5A69	# <CJK>
0xD4EA	0x5A47	# <CJK>
0xD4EB	0x5A51	# <CJK>
0xD4EC	0x5A56	# <CJK>
0xD4ED	0x5A42	# <CJK>
0xD4EE	0x5A5C	# <CJK>
0xD4EF	0x5B72	# <CJK>
0xD4F0	0x5B6E	# <CJK>
0xD4F1	0x5BC1	# <CJK>
0xD4F2	0x5BC0	# <CJK>
0xD4F3	0x5C59	# <CJK>
0xD4F4	0x5D1E	# <CJK>
0xD4F5	0x5D0B	# <CJK>
0xD4F6	0x5D1D	# <CJK>
0xD4F7	0x5D1A	# <CJK>
0xD4F8	0x5D20	# <CJK>
0xD4F9	0x5D0C	# <CJK>
0xD4FA	0x5D28	# <CJK>
0xD4FB	0x5D0D	# <CJK>
0xD4FC	0x5D26	# <CJK>
0xD4FD	0x5D25	# <CJK>
0xD4FE	0x5D0F	# <CJK>
0xD540	0x5D30	# <CJK>
0xD541	0x5D12	# <CJK>
0xD542	0x5D23	# <CJK>
0xD543	0x5D1F	# <CJK>
0xD544	0x5D2E	# <CJK>
0xD545	0x5E3E	# <CJK>
0xD546	0x5E34	# <CJK>
0xD547	0x5EB1	# <CJK>
0xD548	0x5EB4	# <CJK>
0xD549	0x5EB9	# <CJK>
0xD54A	0x5EB2	# <CJK>
0xD54B	0x5EB3	# <CJK>
0xD54C	0x5F36	# <CJK>
0xD54D	0x5F38	# <CJK>
0xD54E	0x5F9B	# <CJK>
0xD54F	0x5F96	# <CJK>
0xD550	0x5F9F	# <CJK>
0xD551	0x608A	# <CJK>
0xD552	0x6090	# <CJK>
0xD553	0x6086	# <CJK>
0xD554	0x60BE	# <CJK>
0xD555	0x60B0	# <CJK>
0xD556	0x60BA	# <CJK>
0xD557	0x60D3	# <CJK>
0xD558	0x60D4	# <CJK>
0xD559	0x60CF	# <CJK>
0xD55A	0x60E4	# <CJK>
0xD55B	0x60D9	# <CJK>
0xD55C	0x60DD	# <CJK>
0xD55D	0x60C8	# <CJK>
0xD55E	0x60B1	# <CJK>
0xD55F	0x60DB	# <CJK>
0xD560	0x60B7	# <CJK>
0xD561	0x60CA	# <CJK>
0xD562	0x60BF	# <CJK>
0xD563	0x60C3	# <CJK>
0xD564	0x60CD	# <CJK>
0xD565	0x60C0	# <CJK>
0xD566	0x6332	# <CJK>
0xD567	0x6365	# <CJK>
0xD568	0x638A	# <CJK>
0xD569	0x6382	# <CJK>
0xD56A	0x637D	# <CJK>
0xD56B	0x63BD	# <CJK>
0xD56C	0x639E	# <CJK>
0xD56D	0x63AD	# <CJK>
0xD56E	0x639D	# <CJK>
0xD56F	0x6397	# <CJK>
0xD570	0x63AB	# <CJK>
0xD571	0x638E	# <CJK>
0xD572	0x636F	# <CJK>
0xD573	0x6387	# <CJK>
0xD574	0x6390	# <CJK>
0xD575	0x636E	# <CJK>
0xD576	0x63AF	# <CJK>
0xD577	0x6375	# <CJK>
0xD578	0x639C	# <CJK>
0xD579	0x636D	# <CJK>
0xD57A	0x63AE	# <CJK>
0xD57B	0x637C	# <CJK>
0xD57C	0x63A4	# <CJK>
0xD57D	0x633B	# <CJK>
0xD57E	0x639F	# <CJK>
0xD5A1	0x6378	# <CJK>
0xD5A2	0x6385	# <CJK>
0xD5A3	0x6381	# <CJK>
0xD5A4	0x6391	# <CJK>
0xD5A5	0x638D	# <CJK>
0xD5A6	0x6370	# <CJK>
0xD5A7	0x6553	# <CJK>
0xD5A8	0x65CD	# <CJK>
0xD5A9	0x6665	# <CJK>
0xD5AA	0x6661	# <CJK>
0xD5AB	0x665B	# <CJK>
0xD5AC	0x6659	# <CJK>
0xD5AD	0x665C	# <CJK>
0xD5AE	0x6662	# <CJK>
0xD5AF	0x6718	# <CJK>
0xD5B0	0x6879	# <CJK>
0xD5B1	0x6887	# <CJK>
0xD5B2	0x6890	# <CJK>
0xD5B3	0x689C	# <CJK>
0xD5B4	0x686D	# <CJK>
0xD5B5	0x686E	# <CJK>
0xD5B6	0x68AE	# <CJK>
0xD5B7	0x68AB	# <CJK>
0xD5B8	0x6956	# <CJK>
0xD5B9	0x686F	# <CJK>
0xD5BA	0x68A3	# <CJK>
0xD5BB	0x68AC	# <CJK>
0xD5BC	0x68A9	# <CJK>
0xD5BD	0x6875	# <CJK>
0xD5BE	0x6874	# <CJK>
0xD5BF	0x68B2	# <CJK>
0xD5C0	0x688F	# <CJK>
0xD5C1	0x6877	# <CJK>
0xD5C2	0x6892	# <CJK>
0xD5C3	0x687C	# <CJK>
0xD5C4	0x686B	# <CJK>
0xD5C5	0x6872	# <CJK>
0xD5C6	0x68AA	# <CJK>
0xD5C7	0x6880	# <CJK>
0xD5C8	0x6871	# <CJK>
0xD5C9	0x687E	# <CJK>
0xD5CA	0x689B	# <CJK>
0xD5CB	0x6896	# <CJK>
0xD5CC	0x688B	# <CJK>
0xD5CD	0x68A0	# <CJK>
0xD5CE	0x6889	# <CJK>
0xD5CF	0x68A4	# <CJK>
0xD5D0	0x6878	# <CJK>
0xD5D1	0x687B	# <CJK>
0xD5D2	0x6891	# <CJK>
0xD5D3	0x688C	# <CJK>
0xD5D4	0x688A	# <CJK>
0xD5D5	0x687D	# <CJK>
0xD5D6	0x6B36	# <CJK>
0xD5D7	0x6B33	# <CJK>
0xD5D8	0x6B37	# <CJK>
0xD5D9	0x6B38	# <CJK>
0xD5DA	0x6B91	# <CJK>
0xD5DB	0x6B8F	# <CJK>
0xD5DC	0x6B8D	# <CJK>
0xD5DD	0x6B8E	# <CJK>
0xD5DE	0x6B8C	# <CJK>
0xD5DF	0x6C2A	# <CJK>
0xD5E0	0x6DC0	# <CJK>
0xD5E1	0x6DAB	# <CJK>
0xD5E2	0x6DB4	# <CJK>
0xD5E3	0x6DB3	# <CJK>
0xD5E4	0x6E74	# <CJK>
0xD5E5	0x6DAC	# <CJK>
0xD5E6	0x6DE9	# <CJK>
0xD5E7	0x6DE2	# <CJK>
0xD5E8	0x6DB7	# <CJK>
0xD5E9	0x6DF6	# <CJK>
0xD5EA	0x6DD4	# <CJK>
0xD5EB	0x6E00	# <CJK>
0xD5EC	0x6DC8	# <CJK>
0xD5ED	0x6DE0	# <CJK>
0xD5EE	0x6DDF	# <CJK>
0xD5EF	0x6DD6	# <CJK>
0xD5F0	0x6DBE	# <CJK>
0xD5F1	0x6DE5	# <CJK>
0xD5F2	0x6DDC	# <CJK>
0xD5F3	0x6DDD	# <CJK>
0xD5F4	0x6DDB	# <CJK>
0xD5F5	0x6DF4	# <CJK>
0xD5F6	0x6DCA	# <CJK>
0xD5F7	0x6DBD	# <CJK>
0xD5F8	0x6DED	# <CJK>
0xD5F9	0x6DF0	# <CJK>
0xD5FA	0x6DBA	# <CJK>
0xD5FB	0x6DD5	# <CJK>
0xD5FC	0x6DC2	# <CJK>
0xD5FD	0x6DCF	# <CJK>
0xD5FE	0x6DC9	# <CJK>
0xD640	0x6DD0	# <CJK>
0xD641	0x6DF2	# <CJK>
0xD642	0x6DD3	# <CJK>
0xD643	0x6DFD	# <CJK>
0xD644	0x6DD7	# <CJK>
0xD645	0x6DCD	# <CJK>
0xD646	0x6DE3	# <CJK>
0xD647	0x6DBB	# <CJK>
0xD648	0x70FA	# <CJK>
0xD649	0x710D	# <CJK>
0xD64A	0x70F7	# <CJK>
0xD64B	0x7117	# <CJK>
0xD64C	0x70F4	# <CJK>
0xD64D	0x710C	# <CJK>
0xD64E	0x70F0	# <CJK>
0xD64F	0x7104	# <CJK>
0xD650	0x70F3	# <CJK>
0xD651	0x7110	# <CJK>
0xD652	0x70FC	# <CJK>
0xD653	0x70FF	# <CJK>
0xD654	0x7106	# <CJK>
0xD655	0x7113	# <CJK>
0xD656	0x7100	# <CJK>
0xD657	0x70F8	# <CJK>
0xD658	0x70F6	# <CJK>
0xD659	0x710B	# <CJK>
0xD65A	0x7102	# <CJK>
0xD65B	0x710E	# <CJK>
0xD65C	0x727E	# <CJK>
0xD65D	0x727B	# <CJK>
0xD65E	0x727C	# <CJK>
0xD65F	0x727F	# <CJK>
0xD660	0x731D	# <CJK>
0xD661	0x7317	# <CJK>
0xD662	0x7307	# <CJK>
0xD663	0x7311	# <CJK>
0xD664	0x7318	# <CJK>
0xD665	0x730A	# <CJK>
0xD666	0x7308	# <CJK>
0xD667	0x72FF	# <CJK>
0xD668	0x730F	# <CJK>
0xD669	0x731E	# <CJK>
0xD66A	0x7388	# <CJK>
0xD66B	0x73F6	# <CJK>
0xD66C	0x73F8	# <CJK>
0xD66D	0x73F5	# <CJK>
0xD66E	0x7404	# <CJK>
0xD66F	0x7401	# <CJK>
0xD670	0x73FD	# <CJK>
0xD671	0x7407	# <CJK>
0xD672	0x7400	# <CJK>
0xD673	0x73FA	# <CJK>
0xD674	0x73FC	# <CJK>
0xD675	0x73FF	# <CJK>
0xD676	0x740C	# <CJK>
0xD677	0x740B	# <CJK>
0xD678	0x73F4	# <CJK>
0xD679	0x7408	# <CJK>
0xD67A	0x7564	# <CJK>
0xD67B	0x7563	# <CJK>
0xD67C	0x75CE	# <CJK>
0xD67D	0x75D2	# <CJK>
0xD67E	0x75CF	# <CJK>
0xD6A1	0x75CB	# <CJK>
0xD6A2	0x75CC	# <CJK>
0xD6A3	0x75D1	# <CJK>
0xD6A4	0x75D0	# <CJK>
0xD6A5	0x768F	# <CJK>
0xD6A6	0x7689	# <CJK>
0xD6A7	0x76D3	# <CJK>
0xD6A8	0x7739	# <CJK>
0xD6A9	0x772F	# <CJK>
0xD6AA	0x772D	# <CJK>
0xD6AB	0x7731	# <CJK>
0xD6AC	0x7732	# <CJK>
0xD6AD	0x7734	# <CJK>
0xD6AE	0x7733	# <CJK>
0xD6AF	0x773D	# <CJK>
0xD6B0	0x7725	# <CJK>
0xD6B1	0x773B	# <CJK>
0xD6B2	0x7735	# <CJK>
0xD6B3	0x7848	# <CJK>
0xD6B4	0x7852	# <CJK>
0xD6B5	0x7849	# <CJK>
0xD6B6	0x784D	# <CJK>
0xD6B7	0x784A	# <CJK>
0xD6B8	0x784C	# <CJK>
0xD6B9	0x7826	# <CJK>
0xD6BA	0x7845	# <CJK>
0xD6BB	0x7850	# <CJK>
0xD6BC	0x7964	# <CJK>
0xD6BD	0x7967	# <CJK>
0xD6BE	0x7969	# <CJK>
0xD6BF	0x796A	# <CJK>
0xD6C0	0x7963	# <CJK>
0xD6C1	0x796B	# <CJK>
0xD6C2	0x7961	# <CJK>
0xD6C3	0x79BB	# <CJK>
0xD6C4	0x79FA	# <CJK>
0xD6C5	0x79F8	# <CJK>
0xD6C6	0x79F6	# <CJK>
0xD6C7	0x79F7	# <CJK>
0xD6C8	0x7A8F	# <CJK>
0xD6C9	0x7A94	# <CJK>
0xD6CA	0x7A90	# <CJK>
0xD6CB	0x7B35	# <CJK>
0xD6CC	0x7B47	# <CJK>
0xD6CD	0x7B34	# <CJK>
0xD6CE	0x7B25	# <CJK>
0xD6CF	0x7B30	# <CJK>
0xD6D0	0x7B22	# <CJK>
0xD6D1	0x7B24	# <CJK>
0xD6D2	0x7B33	# <CJK>
0xD6D3	0x7B18	# <CJK>
0xD6D4	0x7B2A	# <CJK>
0xD6D5	0x7B1D	# <CJK>
0xD6D6	0x7B31	# <CJK>
0xD6D7	0x7B2B	# <CJK>
0xD6D8	0x7B2D	# <CJK>
0xD6D9	0x7B2F	# <CJK>
0xD6DA	0x7B32	# <CJK>
0xD6DB	0x7B38	# <CJK>
0xD6DC	0x7B1A	# <CJK>
0xD6DD	0x7B23	# <CJK>
0xD6DE	0x7C94	# <CJK>
0xD6DF	0x7C98	# <CJK>
0xD6E0	0x7C96	# <CJK>
0xD6E1	0x7CA3	# <CJK>
0xD6E2	0x7D35	# <CJK>
0xD6E3	0x7D3D	# <CJK>
0xD6E4	0x7D38	# <CJK>
0xD6E5	0x7D36	# <CJK>
0xD6E6	0x7D3A	# <CJK>
0xD6E7	0x7D45	# <CJK>
0xD6E8	0x7D2C	# <CJK>
0xD6E9	0x7D29	# <CJK>
0xD6EA	0x7D41	# <CJK>
0xD6EB	0x7D47	# <CJK>
0xD6EC	0x7D3E	# <CJK>
0xD6ED	0x7D3F	# <CJK>
0xD6EE	0x7D4A	# <CJK>
0xD6EF	0x7D3B	# <CJK>
0xD6F0	0x7D28	# <CJK>
0xD6F1	0x7F63	# <CJK>
0xD6F2	0x7F95	# <CJK>
0xD6F3	0x7F9C	# <CJK>
0xD6F4	0x7F9D	# <CJK>
0xD6F5	0x7F9B	# <CJK>
0xD6F6	0x7FCA	# <CJK>
0xD6F7	0x7FCB	# <CJK>
0xD6F8	0x7FCD	# <CJK>
0xD6F9	0x7FD0	# <CJK>
0xD6FA	0x7FD1	# <CJK>
0xD6FB	0x7FC7	# <CJK>
0xD6FC	0x7FCF	# <CJK>
0xD6FD	0x7FC9	# <CJK>
0xD6FE	0x801F	# <CJK>
0xD740	0x801E	# <CJK>
0xD741	0x801B	# <CJK>
0xD742	0x8047	# <CJK>
0xD743	0x8043	# <CJK>
0xD744	0x8048	# <CJK>
0xD745	0x8118	# <CJK>
0xD746	0x8125	# <CJK>
0xD747	0x8119	# <CJK>
0xD748	0x811B	# <CJK>
0xD749	0x812D	# <CJK>
0xD74A	0x811F	# <CJK>
0xD74B	0x812C	# <CJK>
0xD74C	0x811E	# <CJK>
0xD74D	0x8121	# <CJK>
0xD74E	0x8115	# <CJK>
0xD74F	0x8127	# <CJK>
0xD750	0x811D	# <CJK>
0xD751	0x8122	# <CJK>
0xD752	0x8211	# <CJK>
0xD753	0x8238	# <CJK>
0xD754	0x8233	# <CJK>
0xD755	0x823A	# <CJK>
0xD756	0x8234	# <CJK>
0xD757	0x8232	# <CJK>
0xD758	0x8274	# <CJK>
0xD759	0x8390	# <CJK>
0xD75A	0x83A3	# <CJK>
0xD75B	0x83A8	# <CJK>
0xD75C	0x838D	# <CJK>
0xD75D	0x837A	# <CJK>
0xD75E	0x8373	# <CJK>
0xD75F	0x83A4	# <CJK>
0xD760	0x8374	# <CJK>
0xD761	0x838F	# <CJK>
0xD762	0x8381	# <CJK>
0xD763	0x8395	# <CJK>
0xD764	0x8399	# <CJK>
0xD765	0x8375	# <CJK>
0xD766	0x8394	# <CJK>
0xD767	0x83A9	# <CJK>
0xD768	0x837D	# <CJK>
0xD769	0x8383	# <CJK>
0xD76A	0x838C	# <CJK>
0xD76B	0x839D	# <CJK>
0xD76C	0x839B	# <CJK>
0xD76D	0x83AA	# <CJK>
0xD76E	0x838B	# <CJK>
0xD76F	0x837E	# <CJK>
0xD770	0x83A5	# <CJK>
0xD771	0x83AF	# <CJK>
0xD772	0x8388	# <CJK>
0xD773	0x8397	# <CJK>
0xD774	0x83B0	# <CJK>
0xD775	0x837F	# <CJK>
0xD776	0x83A6	# <CJK>
0xD777	0x8387	# <CJK>
0xD778	0x83AE	# <CJK>
0xD779	0x8376	# <CJK>
0xD77A	0x839A	# <CJK>
0xD77B	0x8659	# <CJK>
0xD77C	0x8656	# <CJK>
0xD77D	0x86BF	# <CJK>
0xD77E	0x86B7	# <CJK>
0xD7A1	0x86C2	# <CJK>
0xD7A2	0x86C1	# <CJK>
0xD7A3	0x86C5	# <CJK>
0xD7A4	0x86BA	# <CJK>
0xD7A5	0x86B0	# <CJK>
0xD7A6	0x86C8	# <CJK>
0xD7A7	0x86B9	# <CJK>
0xD7A8	0x86B3	# <CJK>
0xD7A9	0x86B8	# <CJK>
0xD7AA	0x86CC	# <CJK>
0xD7AB	0x86B4	# <CJK>
0xD7AC	0x86BB	# <CJK>
0xD7AD	0x86BC	# <CJK>
0xD7AE	0x86C3	# <CJK>
0xD7AF	0x86BD	# <CJK>
0xD7B0	0x86BE	# <CJK>
0xD7B1	0x8852	# <CJK>
0xD7B2	0x8889	# <CJK>
0xD7B3	0x8895	# <CJK>
0xD7B4	0x88A8	# <CJK>
0xD7B5	0x88A2	# <CJK>
0xD7B6	0x88AA	# <CJK>
0xD7B7	0x889A	# <CJK>
0xD7B8	0x8891	# <CJK>
0xD7B9	0x88A1	# <CJK>
0xD7BA	0x889F	# <CJK>
0xD7BB	0x8898	# <CJK>
0xD7BC	0x88A7	# <CJK>
0xD7BD	0x8899	# <CJK>
0xD7BE	0x889B	# <CJK>
0xD7BF	0x8897	# <CJK>
0xD7C0	0x88A4	# <CJK>
0xD7C1	0x88AC	# <CJK>
0xD7C2	0x888C	# <CJK>
0xD7C3	0x8893	# <CJK>
0xD7C4	0x888E	# <CJK>
0xD7C5	0x8982	# <CJK>
0xD7C6	0x89D6	# <CJK>
0xD7C7	0x89D9	# <CJK>
0xD7C8	0x89D5	# <CJK>
0xD7C9	0x8A30	# <CJK>
0xD7CA	0x8A27	# <CJK>
0xD7CB	0x8A2C	# <CJK>
0xD7CC	0x8A1E	# <CJK>
0xD7CD	0x8C39	# <CJK>
0xD7CE	0x8C3B	# <CJK>
0xD7CF	0x8C5C	# <CJK>
0xD7D0	0x8C5D	# <CJK>
0xD7D1	0x8C7D	# <CJK>
0xD7D2	0x8CA5	# <CJK>
0xD7D3	0x8D7D	# <CJK>
0xD7D4	0x8D7B	# <CJK>
0xD7D5	0x8D79	# <CJK>
0xD7D6	0x8DBC	# <CJK>
0xD7D7	0x8DC2	# <CJK>
0xD7D8	0x8DB9	# <CJK>
0xD7D9	0x8DBF	# <CJK>
0xD7DA	0x8DC1	# <CJK>
0xD7DB	0x8ED8	# <CJK>
0xD7DC	0x8EDE	# <CJK>
0xD7DD	0x8EDD	# <CJK>
0xD7DE	0x8EDC	# <CJK>
0xD7DF	0x8ED7	# <CJK>
0xD7E0	0x8EE0	# <CJK>
0xD7E1	0x8EE1	# <CJK>
0xD7E2	0x9024	# <CJK>
0xD7E3	0x900B	# <CJK>
0xD7E4	0x9011	# <CJK>
0xD7E5	0x901C	# <CJK>
0xD7E6	0x900C	# <CJK>
0xD7E7	0x9021	# <CJK>
0xD7E8	0x90EF	# <CJK>
0xD7E9	0x90EA	# <CJK>
0xD7EA	0x90F0	# <CJK>
0xD7EB	0x90F4	# <CJK>
0xD7EC	0x90F2	# <CJK>
0xD7ED	0x90F3	# <CJK>
0xD7EE	0x90D4	# <CJK>
0xD7EF	0x90EB	# <CJK>
0xD7F0	0x90EC	# <CJK>
0xD7F1	0x90E9	# <CJK>
0xD7F2	0x9156	# <CJK>
0xD7F3	0x9158	# <CJK>
0xD7F4	0x915A	# <CJK>
0xD7F5	0x9153	# <CJK>
0xD7F6	0x9155	# <CJK>
0xD7F7	0x91EC	# <CJK>
0xD7F8	0x91F4	# <CJK>
0xD7F9	0x91F1	# <CJK>
0xD7FA	0x91F3	# <CJK>
0xD7FB	0x91F8	# <CJK>
0xD7FC	0x91E4	# <CJK>
0xD7FD	0x91F9	# <CJK>
0xD7FE	0x91EA	# <CJK>
0xD840	0x91EB	# <CJK>
0xD841	0x91F7	# <CJK>
0xD842	0x91E8	# <CJK>
0xD843	0x91EE	# <CJK>
0xD844	0x957A	# <CJK>
0xD845	0x9586	# <CJK>
0xD846	0x9588	# <CJK>
0xD847	0x967C	# <CJK>
0xD848	0x966D	# <CJK>
0xD849	0x966B	# <CJK>
0xD84A	0x9671	# <CJK>
0xD84B	0x966F	# <CJK>
0xD84C	0x96BF	# <CJK>
0xD84D	0x976A	# <CJK>
0xD84E	0x9804	# <CJK>
0xD84F	0x98E5	# <CJK>
0xD850	0x9997	# <CJK>
0xD851	0x509B	# <CJK>
0xD852	0x5095	# <CJK>
0xD853	0x5094	# <CJK>
0xD854	0x509E	# <CJK>
0xD855	0x508B	# <CJK>
0xD856	0x50A3	# <CJK>
0xD857	0x5083	# <CJK>
0xD858	0x508C	# <CJK>
0xD859	0x508E	# <CJK>
0xD85A	0x509D	# <CJK>
0xD85B	0x5068	# <CJK>
0xD85C	0x509C	# <CJK>
0xD85D	0x5092	# <CJK>
0xD85E	0x5082	# <CJK>
0xD85F	0x5087	# <CJK>
0xD860	0x515F	# <CJK>
0xD861	0x51D4	# <CJK>
0xD862	0x5312	# <CJK>
0xD863	0x5311	# <CJK>
0xD864	0x53A4	# <CJK>
0xD865	0x53A7	# <CJK>
0xD866	0x5591	# <CJK>
0xD867	0x55A8	# <CJK>
0xD868	0x55A5	# <CJK>
0xD869	0x55AD	# <CJK>
0xD86A	0x5577	# <CJK>
0xD86B	0x5645	# <CJK>
0xD86C	0x55A2	# <CJK>
0xD86D	0x5593	# <CJK>
0xD86E	0x5588	# <CJK>
0xD86F	0x558F	# <CJK>
0xD870	0x55B5	# <CJK>
0xD871	0x5581	# <CJK>
0xD872	0x55A3	# <CJK>
0xD873	0x5592	# <CJK>
0xD874	0x55A4	# <CJK>
0xD875	0x557D	# <CJK>
0xD876	0x558C	# <CJK>
0xD877	0x55A6	# <CJK>
0xD878	0x557F	# <CJK>
0xD879	0x5595	# <CJK>
0xD87A	0x55A1	# <CJK>
0xD87B	0x558E	# <CJK>
0xD87C	0x570C	# <CJK>
0xD87D	0x5829	# <CJK>
0xD87E	0x5837	# <CJK>
0xD8A1	0x5819	# <CJK>
0xD8A2	0x581E	# <CJK>
0xD8A3	0x5827	# <CJK>
0xD8A4	0x5823	# <CJK>
0xD8A5	0x5828	# <CJK>
0xD8A6	0x57F5	# <CJK>
0xD8A7	0x5848	# <CJK>
0xD8A8	0x5825	# <CJK>
0xD8A9	0x581C	# <CJK>
0xD8AA	0x581B	# <CJK>
0xD8AB	0x5833	# <CJK>
0xD8AC	0x583F	# <CJK>
0xD8AD	0x5836	# <CJK>
0xD8AE	0x582E	# <CJK>
0xD8AF	0x5839	# <CJK>
0xD8B0	0x5838	# <CJK>
0xD8B1	0x582D	# <CJK>
0xD8B2	0x582C	# <CJK>
0xD8B3	0x583B	# <CJK>
0xD8B4	0x5961	# <CJK>
0xD8B5	0x5AAF	# <CJK>
0xD8B6	0x5A94	# <CJK>
0xD8B7	0x5A9F	# <CJK>
0xD8B8	0x5A7A	# <CJK>
0xD8B9	0x5AA2	# <CJK>
0xD8BA	0x5A9E	# <CJK>
0xD8BB	0x5A78	# <CJK>
0xD8BC	0x5AA6	# <CJK>
0xD8BD	0x5A7C	# <CJK>
0xD8BE	0x5AA5	# <CJK>
0xD8BF	0x5AAC	# <CJK>
0xD8C0	0x5A95	# <CJK>
0xD8C1	0x5AAE	# <CJK>
0xD8C2	0x5A37	# <CJK>
0xD8C3	0x5A84	# <CJK>
0xD8C4	0x5A8A	# <CJK>
0xD8C5	0x5A97	# <CJK>
0xD8C6	0x5A83	# <CJK>
0xD8C7	0x5A8B	# <CJK>
0xD8C8	0x5AA9	# <CJK>
0xD8C9	0x5A7B	# <CJK>
0xD8CA	0x5A7D	# <CJK>
0xD8CB	0x5A8C	# <CJK>
0xD8CC	0x5A9C	# <CJK>
0xD8CD	0x5A8F	# <CJK>
0xD8CE	0x5A93	# <CJK>
0xD8CF	0x5A9D	# <CJK>
0xD8D0	0x5BEA	# <CJK>
0xD8D1	0x5BCD	# <CJK>
0xD8D2	0x5BCB	# <CJK>
0xD8D3	0x5BD4	# <CJK>
0xD8D4	0x5BD1	# <CJK>
0xD8D5	0x5BCA	# <CJK>
0xD8D6	0x5BCE	# <CJK>
0xD8D7	0x5C0C	# <CJK>
0xD8D8	0x5C30	# <CJK>
0xD8D9	0x5D37	# <CJK>
0xD8DA	0x5D43	# <CJK>
0xD8DB	0x5D6B	# <CJK>
0xD8DC	0x5D41	# <CJK>
0xD8DD	0x5D4B	# <CJK>
0xD8DE	0x5D3F	# <CJK>
0xD8DF	0x5D35	# <CJK>
0xD8E0	0x5D51	# <CJK>
0xD8E1	0x5D4E	# <CJK>
0xD8E2	0x5D55	# <CJK>
0xD8E3	0x5D33	# <CJK>
0xD8E4	0x5D3A	# <CJK>
0xD8E5	0x5D52	# <CJK>
0xD8E6	0x5D3D	# <CJK>
0xD8E7	0x5D31	# <CJK>
0xD8E8	0x5D59	# <CJK>
0xD8E9	0x5D42	# <CJK>
0xD8EA	0x5D39	# <CJK>
0xD8EB	0x5D49	# <CJK>
0xD8EC	0x5D38	# <CJK>
0xD8ED	0x5D3C	# <CJK>
0xD8EE	0x5D32	# <CJK>
0xD8EF	0x5D36	# <CJK>
0xD8F0	0x5D40	# <CJK>
0xD8F1	0x5D45	# <CJK>
0xD8F2	0x5E44	# <CJK>
0xD8F3	0x5E41	# <CJK>
0xD8F4	0x5F58	# <CJK>
0xD8F5	0x5FA6	# <CJK>
0xD8F6	0x5FA5	# <CJK>
0xD8F7	0x5FAB	# <CJK>
0xD8F8	0x60C9	# <CJK>
0xD8F9	0x60B9	# <CJK>
0xD8FA	0x60CC	# <CJK>
0xD8FB	0x60E2	# <CJK>
0xD8FC	0x60CE	# <CJK>
0xD8FD	0x60C4	# <CJK>
0xD8FE	0x6114	# <CJK>
0xD940	0x60F2	# <CJK>
0xD941	0x610A	# <CJK>
0xD942	0x6116	# <CJK>
0xD943	0x6105	# <CJK>
0xD944	0x60F5	# <CJK>
0xD945	0x6113	# <CJK>
0xD946	0x60F8	# <CJK>
0xD947	0x60FC	# <CJK>
0xD948	0x60FE	# <CJK>
0xD949	0x60C1	# <CJK>
0xD94A	0x6103	# <CJK>
0xD94B	0x6118	# <CJK>
0xD94C	0x611D	# <CJK>
0xD94D	0x6110	# <CJK>
0xD94E	0x60FF	# <CJK>
0xD94F	0x6104	# <CJK>
0xD950	0x610B	# <CJK>
0xD951	0x624A	# <CJK>
0xD952	0x6394	# <CJK>
0xD953	0x63B1	# <CJK>
0xD954	0x63B0	# <CJK>
0xD955	0x63CE	# <CJK>
0xD956	0x63E5	# <CJK>
0xD957	0x63E8	# <CJK>
0xD958	0x63EF	# <CJK>
0xD959	0x63C3	# <CJK>
0xD95A	0x649D	# <CJK>
0xD95B	0x63F3	# <CJK>
0xD95C	0x63CA	# <CJK>
0xD95D	0x63E0	# <CJK>
0xD95E	0x63F6	# <CJK>
0xD95F	0x63D5	# <CJK>
0xD960	0x63F2	# <CJK>
0xD961	0x63F5	# <CJK>
0xD962	0x6461	# <CJK>
0xD963	0x63DF	# <CJK>
0xD964	0x63BE	# <CJK>
0xD965	0x63DD	# <CJK>
0xD966	0x63DC	# <CJK>
0xD967	0x63C4	# <CJK>
0xD968	0x63D8	# <CJK>
0xD969	0x63D3	# <CJK>
0xD96A	0x63C2	# <CJK>
0xD96B	0x63C7	# <CJK>
0xD96C	0x63CC	# <CJK>
0xD96D	0x63CB	# <CJK>
0xD96E	0x63C8	# <CJK>
0xD96F	0x63F0	# <CJK>
0xD970	0x63D7	# <CJK>
0xD971	0x63D9	# <CJK>
0xD972	0x6532	# <CJK>
0xD973	0x6567	# <CJK>
0xD974	0x656A	# <CJK>
0xD975	0x6564	# <CJK>
0xD976	0x655C	# <CJK>
0xD977	0x6568	# <CJK>
0xD978	0x6565	# <CJK>
0xD979	0x658C	# <CJK>
0xD97A	0x659D	# <CJK>
0xD97B	0x659E	# <CJK>
0xD97C	0x65AE	# <CJK>
0xD97D	0x65D0	# <CJK>
0xD97E	0x65D2	# <CJK>
0xD9A1	0x667C	# <CJK>
0xD9A2	0x666C	# <CJK>
0xD9A3	0x667B	# <CJK>
0xD9A4	0x6680	# <CJK>
0xD9A5	0x6671	# <CJK>
0xD9A6	0x6679	# <CJK>
0xD9A7	0x666A	# <CJK>
0xD9A8	0x6672	# <CJK>
0xD9A9	0x6701	# <CJK>
0xD9AA	0x690C	# <CJK>
0xD9AB	0x68D3	# <CJK>
0xD9AC	0x6904	# <CJK>
0xD9AD	0x68DC	# <CJK>
0xD9AE	0x692A	# <CJK>
0xD9AF	0x68EC	# <CJK>
0xD9B0	0x68EA	# <CJK>
0xD9B1	0x68F1	# <CJK>
0xD9B2	0x690F	# <CJK>
0xD9B3	0x68D6	# <CJK>
0xD9B4	0x68F7	# <CJK>
0xD9B5	0x68EB	# <CJK>
0xD9B6	0x68E4	# <CJK>
0xD9B7	0x68F6	# <CJK>
0xD9B8	0x6913	# <CJK>
0xD9B9	0x6910	# <CJK>
0xD9BA	0x68F3	# <CJK>
0xD9BB	0x68E1	# <CJK>
0xD9BC	0x6907	# <CJK>
0xD9BD	0x68CC	# <CJK>
0xD9BE	0x6908	# <CJK>
0xD9BF	0x6970	# <CJK>
0xD9C0	0x68B4	# <CJK>
0xD9C1	0x6911	# <CJK>
0xD9C2	0x68EF	# <CJK>
0xD9C3	0x68C6	# <CJK>
0xD9C4	0x6914	# <CJK>
0xD9C5	0x68F8	# <CJK>
0xD9C6	0x68D0	# <CJK>
0xD9C7	0x68FD	# <CJK>
0xD9C8	0x68FC	# <CJK>
0xD9C9	0x68E8	# <CJK>
0xD9CA	0x690B	# <CJK>
0xD9CB	0x690A	# <CJK>
0xD9CC	0x6917	# <CJK>
0xD9CD	0x68CE	# <CJK>
0xD9CE	0x68C8	# <CJK>
0xD9CF	0x68DD	# <CJK>
0xD9D0	0x68DE	# <CJK>
0xD9D1	0x68E6	# <CJK>
0xD9D2	0x68F4	# <CJK>
0xD9D3	0x68D1	# <CJK>
0xD9D4	0x6906	# <CJK>
0xD9D5	0x68D4	# <CJK>
0xD9D6	0x68E9	# <CJK>
0xD9D7	0x6915	# <CJK>
0xD9D8	0x6925	# <CJK>
0xD9D9	0x68C7	# <CJK>
0xD9DA	0x6B39	# <CJK>
0xD9DB	0x6B3B	# <CJK>
0xD9DC	0x6B3F	# <CJK>
0xD9DD	0x6B3C	# <CJK>
0xD9DE	0x6B94	# <CJK>
0xD9DF	0x6B97	# <CJK>
0xD9E0	0x6B99	# <CJK>
0xD9E1	0x6B95	# <CJK>
0xD9E2	0x6BBD	# <CJK>
0xD9E3	0x6BF0	# <CJK>
0xD9E4	0x6BF2	# <CJK>
0xD9E5	0x6BF3	# <CJK>
0xD9E6	0x6C30	# <CJK>
0xD9E7	0x6DFC	# <CJK>
0xD9E8	0x6E46	# <CJK>
0xD9E9	0x6E47	# <CJK>
0xD9EA	0x6E1F	# <CJK>
0xD9EB	0x6E49	# <CJK>
0xD9EC	0x6E88	# <CJK>
0xD9ED	0x6E3C	# <CJK>
0xD9EE	0x6E3D	# <CJK>
0xD9EF	0x6E45	# <CJK>
0xD9F0	0x6E62	# <CJK>
0xD9F1	0x6E2B	# <CJK>
0xD9F2	0x6E3F	# <CJK>
0xD9F3	0x6E41	# <CJK>
0xD9F4	0x6E5D	# <CJK>
0xD9F5	0x6E73	# <CJK>
0xD9F6	0x6E1C	# <CJK>
0xD9F7	0x6E33	# <CJK>
0xD9F8	0x6E4B	# <CJK>
0xD9F9	0x6E40	# <CJK>
0xD9FA	0x6E51	# <CJK>
0xD9FB	0x6E3B	# <CJK>
0xD9FC	0x6E03	# <CJK>
0xD9FD	0x6E2E	# <CJK>
0xD9FE	0x6E5E	# <CJK>
0xDA40	0x6E68	# <CJK>
0xDA41	0x6E5C	# <CJK>
0xDA42	0x6E61	# <CJK>
0xDA43	0x6E31	# <CJK>
0xDA44	0x6E28	# <CJK>
0xDA45	0x6E60	# <CJK>
0xDA46	0x6E71	# <CJK>
0xDA47	0x6E6B	# <CJK>
0xDA48	0x6E39	# <CJK>
0xDA49	0x6E22	# <CJK>
0xDA4A	0x6E30	# <CJK>
0xDA4B	0x6E53	# <CJK>
0xDA4C	0x6E65	# <CJK>
0xDA4D	0x6E27	# <CJK>
0xDA4E	0x6E78	# <CJK>
0xDA4F	0x6E64	# <CJK>
0xDA50	0x6E77	# <CJK>
0xDA51	0x6E55	# <CJK>
0xDA52	0x6E79	# <CJK>
0xDA53	0x6E52	# <CJK>
0xDA54	0x6E66	# <CJK>
0xDA55	0x6E35	# <CJK>
0xDA56	0x6E36	# <CJK>
0xDA57	0x6E5A	# <CJK>
0xDA58	0x7120	# <CJK>
0xDA59	0x711E	# <CJK>
0xDA5A	0x712F	# <CJK>
0xDA5B	0x70FB	# <CJK>
0xDA5C	0x712E	# <CJK>
0xDA5D	0x7131	# <CJK>
0xDA5E	0x7123	# <CJK>
0xDA5F	0x7125	# <CJK>
0xDA60	0x7122	# <CJK>
0xDA61	0x7132	# <CJK>
0xDA62	0x711F	# <CJK>
0xDA63	0x7128	# <CJK>
0xDA64	0x713A	# <CJK>
0xDA65	0x711B	# <CJK>
0xDA66	0x724B	# <CJK>
0xDA67	0x725A	# <CJK>
0xDA68	0x7288	# <CJK>
0xDA69	0x7289	# <CJK>
0xDA6A	0x7286	# <CJK>
0xDA6B	0x7285	# <CJK>
0xDA6C	0x728B	# <CJK>
0xDA6D	0x7312	# <CJK>
0xDA6E	0x730B	# <CJK>
0xDA6F	0x7330	# <CJK>
0xDA70	0x7322	# <CJK>
0xDA71	0x7331	# <CJK>
0xDA72	0x7333	# <CJK>
0xDA73	0x7327	# <CJK>
0xDA74	0x7332	# <CJK>
0xDA75	0x732D	# <CJK>
0xDA76	0x7326	# <CJK>
0xDA77	0x7323	# <CJK>
0xDA78	0x7335	# <CJK>
0xDA79	0x730C	# <CJK>
0xDA7A	0x742E	# <CJK>
0xDA7B	0x742C	# <CJK>
0xDA7C	0x7430	# <CJK>
0xDA7D	0x742B	# <CJK>
0xDA7E	0x7416	# <CJK>
0xDAA1	0x741A	# <CJK>
0xDAA2	0x7421	# <CJK>
0xDAA3	0x742D	# <CJK>
0xDAA4	0x7431	# <CJK>
0xDAA5	0x7424	# <CJK>
0xDAA6	0x7423	# <CJK>
0xDAA7	0x741D	# <CJK>
0xDAA8	0x7429	# <CJK>
0xDAA9	0x7420	# <CJK>
0xDAAA	0x7432	# <CJK>
0xDAAB	0x74FB	# <CJK>
0xDAAC	0x752F	# <CJK>
0xDAAD	0x756F	# <CJK>
0xDAAE	0x756C	# <CJK>
0xDAAF	0x75E7	# <CJK>
0xDAB0	0x75DA	# <CJK>
0xDAB1	0x75E1	# <CJK>
0xDAB2	0x75E6	# <CJK>
0xDAB3	0x75DD	# <CJK>
0xDAB4	0x75DF	# <CJK>
0xDAB5	0x75E4	# <CJK>
0xDAB6	0x75D7	# <CJK>
0xDAB7	0x7695	# <CJK>
0xDAB8	0x7692	# <CJK>
0xDAB9	0x76DA	# <CJK>
0xDABA	0x7746	# <CJK>
0xDABB	0x7747	# <CJK>
0xDABC	0x7744	# <CJK>
0xDABD	0x774D	# <CJK>
0xDABE	0x7745	# <CJK>
0xDABF	0x774A	# <CJK>
0xDAC0	0x774E	# <CJK>
0xDAC1	0x774B	# <CJK>
0xDAC2	0x774C	# <CJK>
0xDAC3	0x77DE	# <CJK>
0xDAC4	0x77EC	# <CJK>
0xDAC5	0x7860	# <CJK>
0xDAC6	0x7864	# <CJK>
0xDAC7	0x7865	# <CJK>
0xDAC8	0x785C	# <CJK>
0xDAC9	0x786D	# <CJK>
0xDACA	0x7871	# <CJK>
0xDACB	0x786A	# <CJK>
0xDACC	0x786E	# <CJK>
0xDACD	0x7870	# <CJK>
0xDACE	0x7869	# <CJK>
0xDACF	0x7868	# <CJK>
0xDAD0	0x785E	# <CJK>
0xDAD1	0x7862	# <CJK>
0xDAD2	0x7974	# <CJK>
0xDAD3	0x7973	# <CJK>
0xDAD4	0x7972	# <CJK>
0xDAD5	0x7970	# <CJK>
0xDAD6	0x7A02	# <CJK>
0xDAD7	0x7A0A	# <CJK>
0xDAD8	0x7A03	# <CJK>
0xDAD9	0x7A0C	# <CJK>
0xDADA	0x7A04	# <CJK>
0xDADB	0x7A99	# <CJK>
0xDADC	0x7AE6	# <CJK>
0xDADD	0x7AE4	# <CJK>
0xDADE	0x7B4A	# <CJK>
0xDADF	0x7B3B	# <CJK>
0xDAE0	0x7B44	# <CJK>
0xDAE1	0x7B48	# <CJK>
0xDAE2	0x7B4C	# <CJK>
0xDAE3	0x7B4E	# <CJK>
0xDAE4	0x7B40	# <CJK>
0xDAE5	0x7B58	# <CJK>
0xDAE6	0x7B45	# <CJK>
0xDAE7	0x7CA2	# <CJK>
0xDAE8	0x7C9E	# <CJK>
0xDAE9	0x7CA8	# <CJK>
0xDAEA	0x7CA1	# <CJK>
0xDAEB	0x7D58	# <CJK>
0xDAEC	0x7D6F	# <CJK>
0xDAED	0x7D63	# <CJK>
0xDAEE	0x7D53	# <CJK>
0xDAEF	0x7D56	# <CJK>
0xDAF0	0x7D67	# <CJK>
0xDAF1	0x7D6A	# <CJK>
0xDAF2	0x7D4F	# <CJK>
0xDAF3	0x7D6D	# <CJK>
0xDAF4	0x7D5C	# <CJK>
0xDAF5	0x7D6B	# <CJK>
0xDAF6	0x7D52	# <CJK>
0xDAF7	0x7D54	# <CJK>
0xDAF8	0x7D69	# <CJK>
0xDAF9	0x7D51	# <CJK>
0xDAFA	0x7D5F	# <CJK>
0xDAFB	0x7D4E	# <CJK>
0xDAFC	0x7F3E	# <CJK>
0xDAFD	0x7F3F	# <CJK>
0xDAFE	0x7F65	# <CJK>
0xDB40	0x7F66	# <CJK>
0xDB41	0x7FA2	# <CJK>
0xDB42	0x7FA0	# <CJK>
0xDB43	0x7FA1	# <CJK>
0xDB44	0x7FD7	# <CJK>
0xDB45	0x8051	# <CJK>
0xDB46	0x804F	# <CJK>
0xDB47	0x8050	# <CJK>
0xDB48	0x80FE	# <CJK>
0xDB49	0x80D4	# <CJK>
0xDB4A	0x8143	# <CJK>
0xDB4B	0x814A	# <CJK>
0xDB4C	0x8152	# <CJK>
0xDB4D	0x814F	# <CJK>
0xDB4E	0x8147	# <CJK>
0xDB4F	0x813D	# <CJK>
0xDB50	0x814D	# <CJK>
0xDB51	0x813A	# <CJK>
0xDB52	0x81E6	# <CJK>
0xDB53	0x81EE	# <CJK>
0xDB54	0x81F7	# <CJK>
0xDB55	0x81F8	# <CJK>
0xDB56	0x81F9	# <CJK>
0xDB57	0x8204	# <CJK>
0xDB58	0x823C	# <CJK>
0xDB59	0x823D	# <CJK>
0xDB5A	0x823F	# <CJK>
0xDB5B	0x8275	# <CJK>
0xDB5C	0x833B	# <CJK>
0xDB5D	0x83CF	# <CJK>
0xDB5E	0x83F9	# <CJK>
0xDB5F	0x8423	# <CJK>
0xDB60	0x83C0	# <CJK>
0xDB61	0x83E8	# <CJK>
0xDB62	0x8412	# <CJK>
0xDB63	0x83E7	# <CJK>
0xDB64	0x83E4	# <CJK>
0xDB65	0x83FC	# <CJK>
0xDB66	0x83F6	# <CJK>
0xDB67	0x8410	# <CJK>
0xDB68	0x83C6	# <CJK>
0xDB69	0x83C8	# <CJK>
0xDB6A	0x83EB	# <CJK>
0xDB6B	0x83E3	# <CJK>
0xDB6C	0x83BF	# <CJK>
0xDB6D	0x8401	# <CJK>
0xDB6E	0x83DD	# <CJK>
0xDB6F	0x83E5	# <CJK>
0xDB70	0x83D8	# <CJK>
0xDB71	0x83FF	# <CJK>
0xDB72	0x83E1	# <CJK>
0xDB73	0x83CB	# <CJK>
0xDB74	0x83CE	# <CJK>
0xDB75	0x83D6	# <CJK>
0xDB76	0x83F5	# <CJK>
0xDB77	0x83C9	# <CJK>
0xDB78	0x8409	# <CJK>
0xDB79	0x840F	# <CJK>
0xDB7A	0x83DE	# <CJK>
0xDB7B	0x8411	# <CJK>
0xDB7C	0x8406	# <CJK>
0xDB7D	0x83C2	# <CJK>
0xDB7E	0x83F3	# <CJK>
0xDBA1	0x83D5	# <CJK>
0xDBA2	0x83FA	# <CJK>
0xDBA3	0x83C7	# <CJK>
0xDBA4	0x83D1	# <CJK>
0xDBA5	0x83EA	# <CJK>
0xDBA6	0x8413	# <CJK>
0xDBA7	0x83C3	# <CJK>
0xDBA8	0x83EC	# <CJK>
0xDBA9	0x83EE	# <CJK>
0xDBAA	0x83C4	# <CJK>
0xDBAB	0x83FB	# <CJK>
0xDBAC	0x83D7	# <CJK>
0xDBAD	0x83E2	# <CJK>
0xDBAE	0x841B	# <CJK>
0xDBAF	0x83DB	# <CJK>
0xDBB0	0x83FE	# <CJK>
0xDBB1	0x86D8	# <CJK>
0xDBB2	0x86E2	# <CJK>
0xDBB3	0x86E6	# <CJK>
0xDBB4	0x86D3	# <CJK>
0xDBB5	0x86E3	# <CJK>
0xDBB6	0x86DA	# <CJK>
0xDBB7	0x86EA	# <CJK>
0xDBB8	0x86DD	# <CJK>
0xDBB9	0x86EB	# <CJK>
0xDBBA	0x86DC	# <CJK>
0xDBBB	0x86EC	# <CJK>
0xDBBC	0x86E9	# <CJK>
0xDBBD	0x86D7	# <CJK>
0xDBBE	0x86E8	# <CJK>
0xDBBF	0x86D1	# <CJK>
0xDBC0	0x8848	# <CJK>
0xDBC1	0x8856	# <CJK>
0xDBC2	0x8855	# <CJK>
0xDBC3	0x88BA	# <CJK>
0xDBC4	0x88D7	# <CJK>
0xDBC5	0x88B9	# <CJK>
0xDBC6	0x88B8	# <CJK>
0xDBC7	0x88C0	# <CJK>
0xDBC8	0x88BE	# <CJK>
0xDBC9	0x88B6	# <CJK>
0xDBCA	0x88BC	# <CJK>
0xDBCB	0x88B7	# <CJK>
0xDBCC	0x88BD	# <CJK>
0xDBCD	0x88B2	# <CJK>
0xDBCE	0x8901	# <CJK>
0xDBCF	0x88C9	# <CJK>
0xDBD0	0x8995	# <CJK>
0xDBD1	0x8998	# <CJK>
0xDBD2	0x8997	# <CJK>
0xDBD3	0x89DD	# <CJK>
0xDBD4	0x89DA	# <CJK>
0xDBD5	0x89DB	# <CJK>
0xDBD6	0x8A4E	# <CJK>
0xDBD7	0x8A4D	# <CJK>
0xDBD8	0x8A39	# <CJK>
0xDBD9	0x8A59	# <CJK>
0xDBDA	0x8A40	# <CJK>
0xDBDB	0x8A57	# <CJK>
0xDBDC	0x8A58	# <CJK>
0xDBDD	0x8A44	# <CJK>
0xDBDE	0x8A45	# <CJK>
0xDBDF	0x8A52	# <CJK>
0xDBE0	0x8A48	# <CJK>
0xDBE1	0x8A51	# <CJK>
0xDBE2	0x8A4A	# <CJK>
0xDBE3	0x8A4C	# <CJK>
0xDBE4	0x8A4F	# <CJK>
0xDBE5	0x8C5F	# <CJK>
0xDBE6	0x8C81	# <CJK>
0xDBE7	0x8C80	# <CJK>
0xDBE8	0x8CBA	# <CJK>
0xDBE9	0x8CBE	# <CJK>
0xDBEA	0x8CB0	# <CJK>
0xDBEB	0x8CB9	# <CJK>
0xDBEC	0x8CB5	# <CJK>
0xDBED	0x8D84	# <CJK>
0xDBEE	0x8D80	# <CJK>
0xDBEF	0x8D89	# <CJK>
0xDBF0	0x8DD8	# <CJK>
0xDBF1	0x8DD3	# <CJK>
0xDBF2	0x8DCD	# <CJK>
0xDBF3	0x8DC7	# <CJK>
0xDBF4	0x8DD6	# <CJK>
0xDBF5	0x8DDC	# <CJK>
0xDBF6	0x8DCF	# <CJK>
0xDBF7	0x8DD5	# <CJK>
0xDBF8	0x8DD9	# <CJK>
0xDBF9	0x8DC8	# <CJK>
0xDBFA	0x8DD7	# <CJK>
0xDBFB	0x8DC5	# <CJK>
0xDBFC	0x8EEF	# <CJK>
0xDBFD	0x8EF7	# <CJK>
0xDBFE	0x8EFA	# <CJK>
0xDC40	0x8EF9	# <CJK>
0xDC41	0x8EE6	# <CJK>
0xDC42	0x8EEE	# <CJK>
0xDC43	0x8EE5	# <CJK>
0xDC44	0x8EF5	# <CJK>
0xDC45	0x8EE7	# <CJK>
0xDC46	0x8EE8	# <CJK>
0xDC47	0x8EF6	# <CJK>
0xDC48	0x8EEB	# <CJK>
0xDC49	0x8EF1	# <CJK>
0xDC4A	0x8EEC	# <CJK>
0xDC4B	0x8EF4	# <CJK>
0xDC4C	0x8EE9	# <CJK>
0xDC4D	0x902D	# <CJK>
0xDC4E	0x9034	# <CJK>
0xDC4F	0x902F	# <CJK>
0xDC50	0x9106	# <CJK>
0xDC51	0x912C	# <CJK>
0xDC52	0x9104	# <CJK>
0xDC53	0x90FF	# <CJK>
0xDC54	0x90FC	# <CJK>
0xDC55	0x9108	# <CJK>
0xDC56	0x90F9	# <CJK>
0xDC57	0x90FB	# <CJK>
0xDC58	0x9101	# <CJK>
0xDC59	0x9100	# <CJK>
0xDC5A	0x9107	# <CJK>
0xDC5B	0x9105	# <CJK>
0xDC5C	0x9103	# <CJK>
0xDC5D	0x9161	# <CJK>
0xDC5E	0x9164	# <CJK>
0xDC5F	0x915F	# <CJK>
0xDC60	0x9162	# <CJK>
0xDC61	0x9160	# <CJK>
0xDC62	0x9201	# <CJK>
0xDC63	0x920A	# <CJK>
0xDC64	0x9225	# <CJK>
0xDC65	0x9203	# <CJK>
0xDC66	0x921A	# <CJK>
0xDC67	0x9226	# <CJK>
0xDC68	0x920F	# <CJK>
0xDC69	0x920C	# <CJK>
0xDC6A	0x9200	# <CJK>
0xDC6B	0x9212	# <CJK>
0xDC6C	0x91FF	# <CJK>
0xDC6D	0x91FD	# <CJK>
0xDC6E	0x9206	# <CJK>
0xDC6F	0x9204	# <CJK>
0xDC70	0x9227	# <CJK>
0xDC71	0x9202	# <CJK>
0xDC72	0x921C	# <CJK>
0xDC73	0x9224	# <CJK>
0xDC74	0x9219	# <CJK>
0xDC75	0x9217	# <CJK>
0xDC76	0x9205	# <CJK>
0xDC77	0x9216	# <CJK>
0xDC78	0x957B	# <CJK>
0xDC79	0x958D	# <CJK>
0xDC7A	0x958C	# <CJK>
0xDC7B	0x9590	# <CJK>
0xDC7C	0x9687	# <CJK>
0xDC7D	0x967E	# <CJK>
0xDC7E	0x9688	# <CJK>
0xDCA1	0x9689	# <CJK>
0xDCA2	0x9683	# <CJK>
0xDCA3	0x9680	# <CJK>
0xDCA4	0x96C2	# <CJK>
0xDCA5	0x96C8	# <CJK>
0xDCA6	0x96C3	# <CJK>
0xDCA7	0x96F1	# <CJK>
0xDCA8	0x96F0	# <CJK>
0xDCA9	0x976C	# <CJK>
0xDCAA	0x9770	# <CJK>
0xDCAB	0x976E	# <CJK>
0xDCAC	0x9807	# <CJK>
0xDCAD	0x98A9	# <CJK>
0xDCAE	0x98EB	# <CJK>
0xDCAF	0x9CE6	# <CJK>
0xDCB0	0x9EF9	# <CJK>
0xDCB1	0x4E83	# <CJK>
0xDCB2	0x4E84	# <CJK>
0xDCB3	0x4EB6	# <CJK>
0xDCB4	0x50BD	# <CJK>
0xDCB5	0x50BF	# <CJK>
0xDCB6	0x50C6	# <CJK>
0xDCB7	0x50AE	# <CJK>
0xDCB8	0x50C4	# <CJK>
0xDCB9	0x50CA	# <CJK>
0xDCBA	0x50B4	# <CJK>
0xDCBB	0x50C8	# <CJK>
0xDCBC	0x50C2	# <CJK>
0xDCBD	0x50B0	# <CJK>
0xDCBE	0x50C1	# <CJK>
0xDCBF	0x50BA	# <CJK>
0xDCC0	0x50B1	# <CJK>
0xDCC1	0x50CB	# <CJK>
0xDCC2	0x50C9	# <CJK>
0xDCC3	0x50B6	# <CJK>
0xDCC4	0x50B8	# <CJK>
0xDCC5	0x51D7	# <CJK>
0xDCC6	0x527A	# <CJK>
0xDCC7	0x5278	# <CJK>
0xDCC8	0x527B	# <CJK>
0xDCC9	0x527C	# <CJK>
0xDCCA	0x55C3	# <CJK>
0xDCCB	0x55DB	# <CJK>
0xDCCC	0x55CC	# <CJK>
0xDCCD	0x55D0	# <CJK>
0xDCCE	0x55CB	# <CJK>
0xDCCF	0x55CA	# <CJK>
0xDCD0	0x55DD	# <CJK>
0xDCD1	0x55C0	# <CJK>
0xDCD2	0x55D4	# <CJK>
0xDCD3	0x55C4	# <CJK>
0xDCD4	0x55E9	# <CJK>
0xDCD5	0x55BF	# <CJK>
0xDCD6	0x55D2	# <CJK>
0xDCD7	0x558D	# <CJK>
0xDCD8	0x55CF	# <CJK>
0xDCD9	0x55D5	# <CJK>
0xDCDA	0x55E2	# <CJK>
0xDCDB	0x55D6	# <CJK>
0xDCDC	0x55C8	# <CJK>
0xDCDD	0x55F2	# <CJK>
0xDCDE	0x55CD	# <CJK>
0xDCDF	0x55D9	# <CJK>
0xDCE0	0x55C2	# <CJK>
0xDCE1	0x5714	# <CJK>
0xDCE2	0x5853	# <CJK>
0xDCE3	0x5868	# <CJK>
0xDCE4	0x5864	# <CJK>
0xDCE5	0x584F	# <CJK>
0xDCE6	0x584D	# <CJK>
0xDCE7	0x5849	# <CJK>
0xDCE8	0x586F	# <CJK>
0xDCE9	0x5855	# <CJK>
0xDCEA	0x584E	# <CJK>
0xDCEB	0x585D	# <CJK>
0xDCEC	0x5859	# <CJK>
0xDCED	0x5865	# <CJK>
0xDCEE	0x585B	# <CJK>
0xDCEF	0x583D	# <CJK>
0xDCF0	0x5863	# <CJK>
0xDCF1	0x5871	# <CJK>
0xDCF2	0x58FC	# <CJK>
0xDCF3	0x5AC7	# <CJK>
0xDCF4	0x5AC4	# <CJK>
0xDCF5	0x5ACB	# <CJK>
0xDCF6	0x5ABA	# <CJK>
0xDCF7	0x5AB8	# <CJK>
0xDCF8	0x5AB1	# <CJK>
0xDCF9	0x5AB5	# <CJK>
0xDCFA	0x5AB0	# <CJK>
0xDCFB	0x5ABF	# <CJK>
0xDCFC	0x5AC8	# <CJK>
0xDCFD	0x5ABB	# <CJK>
0xDCFE	0x5AC6	# <CJK>
0xDD40	0x5AB7	# <CJK>
0xDD41	0x5AC0	# <CJK>
0xDD42	0x5ACA	# <CJK>
0xDD43	0x5AB4	# <CJK>
0xDD44	0x5AB6	# <CJK>
0xDD45	0x5ACD	# <CJK>
0xDD46	0x5AB9	# <CJK>
0xDD47	0x5A90	# <CJK>
0xDD48	0x5BD6	# <CJK>
0xDD49	0x5BD8	# <CJK>
0xDD4A	0x5BD9	# <CJK>
0xDD4B	0x5C1F	# <CJK>
0xDD4C	0x5C33	# <CJK>
0xDD4D	0x5D71	# <CJK>
0xDD4E	0x5D63	# <CJK>
0xDD4F	0x5D4A	# <CJK>
0xDD50	0x5D65	# <CJK>
0xDD51	0x5D72	# <CJK>
0xDD52	0x5D6C	# <CJK>
0xDD53	0x5D5E	# <CJK>
0xDD54	0x5D68	# <CJK>
0xDD55	0x5D67	# <CJK>
0xDD56	0x5D62	# <CJK>
0xDD57	0x5DF0	# <CJK>
0xDD58	0x5E4F	# <CJK>
0xDD59	0x5E4E	# <CJK>
0xDD5A	0x5E4A	# <CJK>
0xDD5B	0x5E4D	# <CJK>
0xDD5C	0x5E4B	# <CJK>
0xDD5D	0x5EC5	# <CJK>
0xDD5E	0x5ECC	# <CJK>
0xDD5F	0x5EC6	# <CJK>
0xDD60	0x5ECB	# <CJK>
0xDD61	0x5EC7	# <CJK>
0xDD62	0x5F40	# <CJK>
0xDD63	0x5FAF	# <CJK>
0xDD64	0x5FAD	# <CJK>
0xDD65	0x60F7	# <CJK>
0xDD66	0x6149	# <CJK>
0xDD67	0x614A	# <CJK>
0xDD68	0x612B	# <CJK>
0xDD69	0x6145	# <CJK>
0xDD6A	0x6136	# <CJK>
0xDD6B	0x6132	# <CJK>
0xDD6C	0x612E	# <CJK>
0xDD6D	0x6146	# <CJK>
0xDD6E	0x612F	# <CJK>
0xDD6F	0x614F	# <CJK>
0xDD70	0x6129	# <CJK>
0xDD71	0x6140	# <CJK>
0xDD72	0x6220	# <CJK>
0xDD73	0x9168	# <CJK>
0xDD74	0x6223	# <CJK>
0xDD75	0x6225	# <CJK>
0xDD76	0x6224	# <CJK>
0xDD77	0x63C5	# <CJK>
0xDD78	0x63F1	# <CJK>
0xDD79	0x63EB	# <CJK>
0xDD7A	0x6410	# <CJK>
0xDD7B	0x6412	# <CJK>
0xDD7C	0x6409	# <CJK>
0xDD7D	0x6420	# <CJK>
0xDD7E	0x6424	# <CJK>
0xDDA1	0x6433	# <CJK>
0xDDA2	0x6443	# <CJK>
0xDDA3	0x641F	# <CJK>
0xDDA4	0x6415	# <CJK>
0xDDA5	0x6418	# <CJK>
0xDDA6	0x6439	# <CJK>
0xDDA7	0x6437	# <CJK>
0xDDA8	0x6422	# <CJK>
0xDDA9	0x6423	# <CJK>
0xDDAA	0x640C	# <CJK>
0xDDAB	0x6426	# <CJK>
0xDDAC	0x6430	# <CJK>
0xDDAD	0x6428	# <CJK>
0xDDAE	0x6441	# <CJK>
0xDDAF	0x6435	# <CJK>
0xDDB0	0x642F	# <CJK>
0xDDB1	0x640A	# <CJK>
0xDDB2	0x641A	# <CJK>
0xDDB3	0x6440	# <CJK>
0xDDB4	0x6425	# <CJK>
0xDDB5	0x6427	# <CJK>
0xDDB6	0x640B	# <CJK>
0xDDB7	0x63E7	# <CJK>
0xDDB8	0x641B	# <CJK>
0xDDB9	0x642E	# <CJK>
0xDDBA	0x6421	# <CJK>
0xDDBB	0x640E	# <CJK>
0xDDBC	0x656F	# <CJK>
0xDDBD	0x6592	# <CJK>
0xDDBE	0x65D3	# <CJK>
0xDDBF	0x6686	# <CJK>
0xDDC0	0x668C	# <CJK>
0xDDC1	0x6695	# <CJK>
0xDDC2	0x6690	# <CJK>
0xDDC3	0x668B	# <CJK>
0xDDC4	0x668A	# <CJK>
0xDDC5	0x6699	# <CJK>
0xDDC6	0x6694	# <CJK>
0xDDC7	0x6678	# <CJK>
0xDDC8	0x6720	# <CJK>
0xDDC9	0x6966	# <CJK>
0xDDCA	0x695F	# <CJK>
0xDDCB	0x6938	# <CJK>
0xDDCC	0x694E	# <CJK>
0xDDCD	0x6962	# <CJK>
0xDDCE	0x6971	# <CJK>
0xDDCF	0x693F	# <CJK>
0xDDD0	0x6945	# <CJK>
0xDDD1	0x696A	# <CJK>
0xDDD2	0x6939	# <CJK>
0xDDD3	0x6942	# <CJK>
0xDDD4	0x6957	# <CJK>
0xDDD5	0x6959	# <CJK>
0xDDD6	0x697A	# <CJK>
0xDDD7	0x6948	# <CJK>
0xDDD8	0x6949	# <CJK>
0xDDD9	0x6935	# <CJK>
0xDDDA	0x696C	# <CJK>
0xDDDB	0x6933	# <CJK>
0xDDDC	0x693D	# <CJK>
0xDDDD	0x6965	# <CJK>
0xDDDE	0x68F0	# <CJK>
0xDDDF	0x6978	# <CJK>
0xDDE0	0x6934	# <CJK>
0xDDE1	0x6969	# <CJK>
0xDDE2	0x6940	# <CJK>
0xDDE3	0x696F	# <CJK>
0xDDE4	0x6944	# <CJK>
0xDDE5	0x6976	# <CJK>
0xDDE6	0x6958	# <CJK>
0xDDE7	0x6941	# <CJK>
0xDDE8	0x6974	# <CJK>
0xDDE9	0x694C	# <CJK>
0xDDEA	0x693B	# <CJK>
0xDDEB	0x694B	# <CJK>
0xDDEC	0x6937	# <CJK>
0xDDED	0x695C	# <CJK>
0xDDEE	0x694F	# <CJK>
0xDDEF	0x6951	# <CJK>
0xDDF0	0x6932	# <CJK>
0xDDF1	0x6952	# <CJK>
0xDDF2	0x692F	# <CJK>
0xDDF3	0x697B	# <CJK>
0xDDF4	0x693C	# <CJK>
0xDDF5	0x6B46	# <CJK>
0xDDF6	0x6B45	# <CJK>
0xDDF7	0x6B43	# <CJK>
0xDDF8	0x6B42	# <CJK>
0xDDF9	0x6B48	# <CJK>
0xDDFA	0x6B41	# <CJK>
0xDDFB	0x6B9B	# <CJK>
0xDDFC	0xFA0D	# CJK COMPATIBILITY IDEOGRAPH-FA0D
0xDDFD	0x6BFB	# <CJK>
0xDDFE	0x6BFC	# <CJK>
0xDE40	0x6BF9	# <CJK>
0xDE41	0x6BF7	# <CJK>
0xDE42	0x6BF8	# <CJK>
0xDE43	0x6E9B	# <CJK>
0xDE44	0x6ED6	# <CJK>
0xDE45	0x6EC8	# <CJK>
0xDE46	0x6E8F	# <CJK>
0xDE47	0x6EC0	# <CJK>
0xDE48	0x6E9F	# <CJK>
0xDE49	0x6E93	# <CJK>
0xDE4A	0x6E94	# <CJK>
0xDE4B	0x6EA0	# <CJK>
0xDE4C	0x6EB1	# <CJK>
0xDE4D	0x6EB9	# <CJK>
0xDE4E	0x6EC6	# <CJK>
0xDE4F	0x6ED2	# <CJK>
0xDE50	0x6EBD	# <CJK>
0xDE51	0x6EC1	# <CJK>
0xDE52	0x6E9E	# <CJK>
0xDE53	0x6EC9	# <CJK>
0xDE54	0x6EB7	# <CJK>
0xDE55	0x6EB0	# <CJK>
0xDE56	0x6ECD	# <CJK>
0xDE57	0x6EA6	# <CJK>
0xDE58	0x6ECF	# <CJK>
0xDE59	0x6EB2	# <CJK>
0xDE5A	0x6EBE	# <CJK>
0xDE5B	0x6EC3	# <CJK>
0xDE5C	0x6EDC	# <CJK>
0xDE5D	0x6ED8	# <CJK>
0xDE5E	0x6E99	# <CJK>
0xDE5F	0x6E92	# <CJK>
0xDE60	0x6E8E	# <CJK>
0xDE61	0x6E8D	# <CJK>
0xDE62	0x6EA4	# <CJK>
0xDE63	0x6EA1	# <CJK>
0xDE64	0x6EBF	# <CJK>
0xDE65	0x6EB3	# <CJK>
0xDE66	0x6ED0	# <CJK>
0xDE67	0x6ECA	# <CJK>
0xDE68	0x6E97	# <CJK>
0xDE69	0x6EAE	# <CJK>
0xDE6A	0x6EA3	# <CJK>
0xDE6B	0x7147	# <CJK>
0xDE6C	0x7154	# <CJK>
0xDE6D	0x7152	# <CJK>
0xDE6E	0x7163	# <CJK>
0xDE6F	0x7160	# <CJK>
0xDE70	0x7141	# <CJK>
0xDE71	0x715D	# <CJK>
0xDE72	0x7162	# <CJK>
0xDE73	0x7172	# <CJK>
0xDE74	0x7178	# <CJK>
0xDE75	0x716A	# <CJK>
0xDE76	0x7161	# <CJK>
0xDE77	0x7142	# <CJK>
0xDE78	0x7158	# <CJK>
0xDE79	0x7143	# <CJK>
0xDE7A	0x714B	# <CJK>
0xDE7B	0x7170	# <CJK>
0xDE7C	0x715F	# <CJK>
0xDE7D	0x7150	# <CJK>
0xDE7E	0x7153	# <CJK>
0xDEA1	0x7144	# <CJK>
0xDEA2	0x714D	# <CJK>
0xDEA3	0x715A	# <CJK>
0xDEA4	0x724F	# <CJK>
0xDEA5	0x728D	# <CJK>
0xDEA6	0x728C	# <CJK>
0xDEA7	0x7291	# <CJK>
0xDEA8	0x7290	# <CJK>
0xDEA9	0x728E	# <CJK>
0xDEAA	0x733C	# <CJK>
0xDEAB	0x7342	# <CJK>
0xDEAC	0x733B	# <CJK>
0xDEAD	0x733A	# <CJK>
0xDEAE	0x7340	# <CJK>
0xDEAF	0x734A	# <CJK>
0xDEB0	0x7349	# <CJK>
0xDEB1	0x7444	# <CJK>
0xDEB2	0x744A	# <CJK>
0xDEB3	0x744B	# <CJK>
0xDEB4	0x7452	# <CJK>
0xDEB5	0x7451	# <CJK>
0xDEB6	0x7457	# <CJK>
0xDEB7	0x7440	# <CJK>
0xDEB8	0x744F	# <CJK>
0xDEB9	0x7450	# <CJK>
0xDEBA	0x744E	# <CJK>
0xDEBB	0x7442	# <CJK>
0xDEBC	0x7446	# <CJK>
0xDEBD	0x744D	# <CJK>
0xDEBE	0x7454	# <CJK>
0xDEBF	0x74E1	# <CJK>
0xDEC0	0x74FF	# <CJK>
0xDEC1	0x74FE	# <CJK>
0xDEC2	0x74FD	# <CJK>
0xDEC3	0x751D	# <CJK>
0xDEC4	0x7579	# <CJK>
0xDEC5	0x7577	# <CJK>
0xDEC6	0x6983	# <CJK>
0xDEC7	0x75EF	# <CJK>
0xDEC8	0x760F	# <CJK>
0xDEC9	0x7603	# <CJK>
0xDECA	0x75F7	# <CJK>
0xDECB	0x75FE	# <CJK>
0xDECC	0x75FC	# <CJK>
0xDECD	0x75F9	# <CJK>
0xDECE	0x75F8	# <CJK>
0xDECF	0x7610	# <CJK>
0xDED0	0x75FB	# <CJK>
0xDED1	0x75F6	# <CJK>
0xDED2	0x75ED	# <CJK>
0xDED3	0x75F5	# <CJK>
0xDED4	0x75FD	# <CJK>
0xDED5	0x7699	# <CJK>
0xDED6	0x76B5	# <CJK>
0xDED7	0x76DD	# <CJK>
0xDED8	0x7755	# <CJK>
0xDED9	0x775F	# <CJK>
0xDEDA	0x7760	# <CJK>
0xDEDB	0x7752	# <CJK>
0xDEDC	0x7756	# <CJK>
0xDEDD	0x775A	# <CJK>
0xDEDE	0x7769	# <CJK>
0xDEDF	0x7767	# <CJK>
0xDEE0	0x7754	# <CJK>
0xDEE1	0x7759	# <CJK>
0xDEE2	0x776D	# <CJK>
0xDEE3	0x77E0	# <CJK>
0xDEE4	0x7887	# <CJK>
0xDEE5	0x789A	# <CJK>
0xDEE6	0x7894	# <CJK>
0xDEE7	0x788F	# <CJK>
0xDEE8	0x7884	# <CJK>
0xDEE9	0x7895	# <CJK>
0xDEEA	0x7885	# <CJK>
0xDEEB	0x7886	# <CJK>
0xDEEC	0x78A1	# <CJK>
0xDEED	0x7883	# <CJK>
0xDEEE	0x7879	# <CJK>
0xDEEF	0x7899	# <CJK>
0xDEF0	0x7880	# <CJK>
0xDEF1	0x7896	# <CJK>
0xDEF2	0x787B	# <CJK>
0xDEF3	0x797C	# <CJK>
0xDEF4	0x7982	# <CJK>
0xDEF5	0x797D	# <CJK>
0xDEF6	0x7979	# <CJK>
0xDEF7	0x7A11	# <CJK>
0xDEF8	0x7A18	# <CJK>
0xDEF9	0x7A19	# <CJK>
0xDEFA	0x7A12	# <CJK>
0xDEFB	0x7A17	# <CJK>
0xDEFC	0x7A15	# <CJK>
0xDEFD	0x7A22	# <CJK>
0xDEFE	0x7A13	# <CJK>
0xDF40	0x7A1B	# <CJK>
0xDF41	0x7A10	# <CJK>
0xDF42	0x7AA3	# <CJK>
0xDF43	0x7AA2	# <CJK>
0xDF44	0x7A9E	# <CJK>
0xDF45	0x7AEB	# <CJK>
0xDF46	0x7B66	# <CJK>
0xDF47	0x7B64	# <CJK>
0xDF48	0x7B6D	# <CJK>
0xDF49	0x7B74	# <CJK>
0xDF4A	0x7B69	# <CJK>
0xDF4B	0x7B72	# <CJK>
0xDF4C	0x7B65	# <CJK>
0xDF4D	0x7B73	# <CJK>
0xDF4E	0x7B71	# <CJK>
0xDF4F	0x7B70	# <CJK>
0xDF50	0x7B61	# <CJK>
0xDF51	0x7B78	# <CJK>
0xDF52	0x7B76	# <CJK>
0xDF53	0x7B63	# <CJK>
0xDF54	0x7CB2	# <CJK>
0xDF55	0x7CB4	# <CJK>
0xDF56	0x7CAF	# <CJK>
0xDF57	0x7D88	# <CJK>
0xDF58	0x7D86	# <CJK>
0xDF59	0x7D80	# <CJK>
0xDF5A	0x7D8D	# <CJK>
0xDF5B	0x7D7F	# <CJK>
0xDF5C	0x7D85	# <CJK>
0xDF5D	0x7D7A	# <CJK>
0xDF5E	0x7D8E	# <CJK>
0xDF5F	0x7D7B	# <CJK>
0xDF60	0x7D83	# <CJK>
0xDF61	0x7D7C	# <CJK>
0xDF62	0x7D8C	# <CJK>
0xDF63	0x7D94	# <CJK>
0xDF64	0x7D84	# <CJK>
0xDF65	0x7D7D	# <CJK>
0xDF66	0x7D92	# <CJK>
0xDF67	0x7F6D	# <CJK>
0xDF68	0x7F6B	# <CJK>
0xDF69	0x7F67	# <CJK>
0xDF6A	0x7F68	# <CJK>
0xDF6B	0x7F6C	# <CJK>
0xDF6C	0x7FA6	# <CJK>
0xDF6D	0x7FA5	# <CJK>
0xDF6E	0x7FA7	# <CJK>
0xDF6F	0x7FDB	# <CJK>
0xDF70	0x7FDC	# <CJK>
0xDF71	0x8021	# <CJK>
0xDF72	0x8164	# <CJK>
0xDF73	0x8160	# <CJK>
0xDF74	0x8177	# <CJK>
0xDF75	0x815C	# <CJK>
0xDF76	0x8169	# <CJK>
0xDF77	0x815B	# <CJK>
0xDF78	0x8162	# <CJK>
0xDF79	0x8172	# <CJK>
0xDF7A	0x6721	# <CJK>
0xDF7B	0x815E	# <CJK>
0xDF7C	0x8176	# <CJK>
0xDF7D	0x8167	# <CJK>
0xDF7E	0x816F	# <CJK>
0xDFA1	0x8144	# <CJK>
0xDFA2	0x8161	# <CJK>
0xDFA3	0x821D	# <CJK>
0xDFA4	0x8249	# <CJK>
0xDFA5	0x8244	# <CJK>
0xDFA6	0x8240	# <CJK>
0xDFA7	0x8242	# <CJK>
0xDFA8	0x8245	# <CJK>
0xDFA9	0x84F1	# <CJK>
0xDFAA	0x843F	# <CJK>
0xDFAB	0x8456	# <CJK>
0xDFAC	0x8476	# <CJK>
0xDFAD	0x8479	# <CJK>
0xDFAE	0x848F	# <CJK>
0xDFAF	0x848D	# <CJK>
0xDFB0	0x8465	# <CJK>
0xDFB1	0x8451	# <CJK>
0xDFB2	0x8440	# <CJK>
0xDFB3	0x8486	# <CJK>
0xDFB4	0x8467	# <CJK>
0xDFB5	0x8430	# <CJK>
0xDFB6	0x844D	# <CJK>
0xDFB7	0x847D	# <CJK>
0xDFB8	0x845A	# <CJK>
0xDFB9	0x8459	# <CJK>
0xDFBA	0x8474	# <CJK>
0xDFBB	0x8473	# <CJK>
0xDFBC	0x845D	# <CJK>
0xDFBD	0x8507	# <CJK>
0xDFBE	0x845E	# <CJK>
0xDFBF	0x8437	# <CJK>
0xDFC0	0x843A	# <CJK>
0xDFC1	0x8434	# <CJK>
0xDFC2	0x847A	# <CJK>
0xDFC3	0x8443	# <CJK>
0xDFC4	0x8478	# <CJK>
0xDFC5	0x8432	# <CJK>
0xDFC6	0x8445	# <CJK>
0xDFC7	0x8429	# <CJK>
0xDFC8	0x83D9	# <CJK>
0xDFC9	0x844B	# <CJK>
0xDFCA	0x842F	# <CJK>
0xDFCB	0x8442	# <CJK>
0xDFCC	0x842D	# <CJK>
0xDFCD	0x845F	# <CJK>
0xDFCE	0x8470	# <CJK>
0xDFCF	0x8439	# <CJK>
0xDFD0	0x844E	# <CJK>
0xDFD1	0x844C	# <CJK>
0xDFD2	0x8452	# <CJK>
0xDFD3	0x846F	# <CJK>
0xDFD4	0x84C5	# <CJK>
0xDFD5	0x848E	# <CJK>
0xDFD6	0x843B	# <CJK>
0xDFD7	0x8447	# <CJK>
0xDFD8	0x8436	# <CJK>
0xDFD9	0x8433	# <CJK>
0xDFDA	0x8468	# <CJK>
0xDFDB	0x847E	# <CJK>
0xDFDC	0x8444	# <CJK>
0xDFDD	0x842B	# <CJK>
0xDFDE	0x8460	# <CJK>
0xDFDF	0x8454	# <CJK>
0xDFE0	0x846E	# <CJK>
0xDFE1	0x8450	# <CJK>
0xDFE2	0x870B	# <CJK>
0xDFE3	0x8704	# <CJK>
0xDFE4	0x86F7	# <CJK>
0xDFE5	0x870C	# <CJK>
0xDFE6	0x86FA	# <CJK>
0xDFE7	0x86D6	# <CJK>
0xDFE8	0x86F5	# <CJK>
0xDFE9	0x874D	# <CJK>
0xDFEA	0x86F8	# <CJK>
0xDFEB	0x870E	# <CJK>
0xDFEC	0x8709	# <CJK>
0xDFED	0x8701	# <CJK>
0xDFEE	0x86F6	# <CJK>
0xDFEF	0x870D	# <CJK>
0xDFF0	0x8705	# <CJK>
0xDFF1	0x88D6	# <CJK>
0xDFF2	0x88CB	# <CJK>
0xDFF3	0x88CD	# <CJK>
0xDFF4	0x88CE	# <CJK>
0xDFF5	0x88DE	# <CJK>
0xDFF6	0x88DB	# <CJK>
0xDFF7	0x88DA	# <CJK>
0xDFF8	0x88CC	# <CJK>
0xDFF9	0x88D0	# <CJK>
0xDFFA	0x8985	# <CJK>
0xDFFB	0x899B	# <CJK>
0xDFFC	0x89DF	# <CJK>
0xDFFD	0x89E5	# <CJK>
0xDFFE	0x89E4	# <CJK>
0xE040	0x89E1	# <CJK>
0xE041	0x89E0	# <CJK>
0xE042	0x89E2	# <CJK>
0xE043	0x89DC	# <CJK>
0xE044	0x89E6	# <CJK>
0xE045	0x8A76	# <CJK>
0xE046	0x8A86	# <CJK>
0xE047	0x8A7F	# <CJK>
0xE048	0x8A61	# <CJK>
0xE049	0x8A3F	# <CJK>
0xE04A	0x8A77	# <CJK>
0xE04B	0x8A82	# <CJK>
0xE04C	0x8A84	# <CJK>
0xE04D	0x8A75	# <CJK>
0xE04E	0x8A83	# <CJK>
0xE04F	0x8A81	# <CJK>
0xE050	0x8A74	# <CJK>
0xE051	0x8A7A	# <CJK>
0xE052	0x8C3C	# <CJK>
0xE053	0x8C4B	# <CJK>
0xE054	0x8C4A	# <CJK>
0xE055	0x8C65	# <CJK>
0xE056	0x8C64	# <CJK>
0xE057	0x8C66	# <CJK>
0xE058	0x8C86	# <CJK>
0xE059	0x8C84	# <CJK>
0xE05A	0x8C85	# <CJK>
0xE05B	0x8CCC	# <CJK>
0xE05C	0x8D68	# <CJK>
0xE05D	0x8D69	# <CJK>
0xE05E	0x8D91	# <CJK>
0xE05F	0x8D8C	# <CJK>
0xE060	0x8D8E	# <CJK>
0xE061	0x8D8F	# <CJK>
0xE062	0x8D8D	# <CJK>
0xE063	0x8D93	# <CJK>
0xE064	0x8D94	# <CJK>
0xE065	0x8D90	# <CJK>
0xE066	0x8D92	# <CJK>
0xE067	0x8DF0	# <CJK>
0xE068	0x8DE0	# <CJK>
0xE069	0x8DEC	# <CJK>
0xE06A	0x8DF1	# <CJK>
0xE06B	0x8DEE	# <CJK>
0xE06C	0x8DD0	# <CJK>
0xE06D	0x8DE9	# <CJK>
0xE06E	0x8DE3	# <CJK>
0xE06F	0x8DE2	# <CJK>
0xE070	0x8DE7	# <CJK>
0xE071	0x8DF2	# <CJK>
0xE072	0x8DEB	# <CJK>
0xE073	0x8DF4	# <CJK>
0xE074	0x8F06	# <CJK>
0xE075	0x8EFF	# <CJK>
0xE076	0x8F01	# <CJK>
0xE077	0x8F00	# <CJK>
0xE078	0x8F05	# <CJK>
0xE079	0x8F07	# <CJK>
0xE07A	0x8F08	# <CJK>
0xE07B	0x8F02	# <CJK>
0xE07C	0x8F0B	# <CJK>
0xE07D	0x9052	# <CJK>
0xE07E	0x903F	# <CJK>
0xE0A1	0x9044	# <CJK>
0xE0A2	0x9049	# <CJK>
0xE0A3	0x903D	# <CJK>
0xE0A4	0x9110	# <CJK>
0xE0A5	0x910D	# <CJK>
0xE0A6	0x910F	# <CJK>
0xE0A7	0x9111	# <CJK>
0xE0A8	0x9116	# <CJK>
0xE0A9	0x9114	# <CJK>
0xE0AA	0x910B	# <CJK>
0xE0AB	0x910E	# <CJK>
0xE0AC	0x916E	# <CJK>
0xE0AD	0x916F	# <CJK>
0xE0AE	0x9248	# <CJK>
0xE0AF	0x9252	# <CJK>
0xE0B0	0x9230	# <CJK>
0xE0B1	0x923A	# <CJK>
0xE0B2	0x9266	# <CJK>
0xE0B3	0x9233	# <CJK>
0xE0B4	0x9265	# <CJK>
0xE0B5	0x925E	# <CJK>
0xE0B6	0x9283	# <CJK>
0xE0B7	0x922E	# <CJK>
0xE0B8	0x924A	# <CJK>
0xE0B9	0x9246	# <CJK>
0xE0BA	0x926D	# <CJK>
0xE0BB	0x926C	# <CJK>
0xE0BC	0x924F	# <CJK>
0xE0BD	0x9260	# <CJK>
0xE0BE	0x9267	# <CJK>
0xE0BF	0x926F	# <CJK>
0xE0C0	0x9236	# <CJK>
0xE0C1	0x9261	# <CJK>
0xE0C2	0x9270	# <CJK>
0xE0C3	0x9231	# <CJK>
0xE0C4	0x9254	# <CJK>
0xE0C5	0x9263	# <CJK>
0xE0C6	0x9250	# <CJK>
0xE0C7	0x9272	# <CJK>
0xE0C8	0x924E	# <CJK>
0xE0C9	0x9253	# <CJK>
0xE0CA	0x924C	# <CJK>
0xE0CB	0x9256	# <CJK>
0xE0CC	0x9232	# <CJK>
0xE0CD	0x959F	# <CJK>
0xE0CE	0x959C	# <CJK>
0xE0CF	0x959E	# <CJK>
0xE0D0	0x959B	# <CJK>
0xE0D1	0x9692	# <CJK>
0xE0D2	0x9693	# <CJK>
0xE0D3	0x9691	# <CJK>
0xE0D4	0x9697	# <CJK>
0xE0D5	0x96CE	# <CJK>
0xE0D6	0x96FA	# <CJK>
0xE0D7	0x96FD	# <CJK>
0xE0D8	0x96F8	# <CJK>
0xE0D9	0x96F5	# <CJK>
0xE0DA	0x9773	# <CJK>
0xE0DB	0x9777	# <CJK>
0xE0DC	0x9778	# <CJK>
0xE0DD	0x9772	# <CJK>
0xE0DE	0x980F	# <CJK>
0xE0DF	0x980D	# <CJK>
0xE0E0	0x980E	# <CJK>
0xE0E1	0x98AC	# <CJK>
0xE0E2	0x98F6	# <CJK>
0xE0E3	0x98F9	# <CJK>
0xE0E4	0x99AF	# <CJK>
0xE0E5	0x99B2	# <CJK>
0xE0E6	0x99B0	# <CJK>
0xE0E7	0x99B5	# <CJK>
0xE0E8	0x9AAD	# <CJK>
0xE0E9	0x9AAB	# <CJK>
0xE0EA	0x9B5B	# <CJK>
0xE0EB	0x9CEA	# <CJK>
0xE0EC	0x9CED	# <CJK>
0xE0ED	0x9CE7	# <CJK>
0xE0EE	0x9E80	# <CJK>
0xE0EF	0x9EFD	# <CJK>
0xE0F0	0x50E6	# <CJK>
0xE0F1	0x50D4	# <CJK>
0xE0F2	0x50D7	# <CJK>
0xE0F3	0x50E8	# <CJK>
0xE0F4	0x50F3	# <CJK>
0xE0F5	0x50DB	# <CJK>
0xE0F6	0x50EA	# <CJK>
0xE0F7	0x50DD	# <CJK>
0xE0F8	0x50E4	# <CJK>
0xE0F9	0x50D3	# <CJK>
0xE0FA	0x50EC	# <CJK>
0xE0FB	0x50F0	# <CJK>
0xE0FC	0x50EF	# <CJK>
0xE0FD	0x50E3	# <CJK>
0xE0FE	0x50E0	# <CJK>
0xE140	0x51D8	# <CJK>
0xE141	0x5280	# <CJK>
0xE142	0x5281	# <CJK>
0xE143	0x52E9	# <CJK>
0xE144	0x52EB	# <CJK>
0xE145	0x5330	# <CJK>
0xE146	0x53AC	# <CJK>
0xE147	0x5627	# <CJK>
0xE148	0x5615	# <CJK>
0xE149	0x560C	# <CJK>
0xE14A	0x5612	# <CJK>
0xE14B	0x55FC	# <CJK>
0xE14C	0x560F	# <CJK>
0xE14D	0x561C	# <CJK>
0xE14E	0x5601	# <CJK>
0xE14F	0x5613	# <CJK>
0xE150	0x5602	# <CJK>
0xE151	0x55FA	# <CJK>
0xE152	0x561D	# <CJK>
0xE153	0x5604	# <CJK>
0xE154	0x55FF	# <CJK>
0xE155	0x55F9	# <CJK>
0xE156	0x5889	# <CJK>
0xE157	0x587C	# <CJK>
0xE158	0x5890	# <CJK>
0xE159	0x5898	# <CJK>
0xE15A	0x5886	# <CJK>
0xE15B	0x5881	# <CJK>
0xE15C	0x587F	# <CJK>
0xE15D	0x5874	# <CJK>
0xE15E	0x588B	# <CJK>
0xE15F	0x587A	# <CJK>
0xE160	0x5887	# <CJK>
0xE161	0x5891	# <CJK>
0xE162	0x588E	# <CJK>
0xE163	0x5876	# <CJK>
0xE164	0x5882	# <CJK>
0xE165	0x5888	# <CJK>
0xE166	0x587B	# <CJK>
0xE167	0x5894	# <CJK>
0xE168	0x588F	# <CJK>
0xE169	0x58FE	# <CJK>
0xE16A	0x596B	# <CJK>
0xE16B	0x5ADC	# <CJK>
0xE16C	0x5AEE	# <CJK>
0xE16D	0x5AE5	# <CJK>
0xE16E	0x5AD5	# <CJK>
0xE16F	0x5AEA	# <CJK>
0xE170	0x5ADA	# <CJK>
0xE171	0x5AED	# <CJK>
0xE172	0x5AEB	# <CJK>
0xE173	0x5AF3	# <CJK>
0xE174	0x5AE2	# <CJK>
0xE175	0x5AE0	# <CJK>
0xE176	0x5ADB	# <CJK>
0xE177	0x5AEC	# <CJK>
0xE178	0x5ADE	# <CJK>
0xE179	0x5ADD	# <CJK>
0xE17A	0x5AD9	# <CJK>
0xE17B	0x5AE8	# <CJK>
0xE17C	0x5ADF	# <CJK>
0xE17D	0x5B77	# <CJK>
0xE17E	0x5BE0	# <CJK>
0xE1A1	0x5BE3	# <CJK>
0xE1A2	0x5C63	# <CJK>
0xE1A3	0x5D82	# <CJK>
0xE1A4	0x5D80	# <CJK>
0xE1A5	0x5D7D	# <CJK>
0xE1A6	0x5D86	# <CJK>
0xE1A7	0x5D7A	# <CJK>
0xE1A8	0x5D81	# <CJK>
0xE1A9	0x5D77	# <CJK>
0xE1AA	0x5D8A	# <CJK>
0xE1AB	0x5D89	# <CJK>
0xE1AC	0x5D88	# <CJK>
0xE1AD	0x5D7E	# <CJK>
0xE1AE	0x5D7C	# <CJK>
0xE1AF	0x5D8D	# <CJK>
0xE1B0	0x5D79	# <CJK>
0xE1B1	0x5D7F	# <CJK>
0xE1B2	0x5E58	# <CJK>
0xE1B3	0x5E59	# <CJK>
0xE1B4	0x5E53	# <CJK>
0xE1B5	0x5ED8	# <CJK>
0xE1B6	0x5ED1	# <CJK>
0xE1B7	0x5ED7	# <CJK>
0xE1B8	0x5ECE	# <CJK>
0xE1B9	0x5EDC	# <CJK>
0xE1BA	0x5ED5	# <CJK>
0xE1BB	0x5ED9	# <CJK>
0xE1BC	0x5ED2	# <CJK>
0xE1BD	0x5ED4	# <CJK>
0xE1BE	0x5F44	# <CJK>
0xE1BF	0x5F43	# <CJK>
0xE1C0	0x5F6F	# <CJK>
0xE1C1	0x5FB6	# <CJK>
0xE1C2	0x612C	# <CJK>
0xE1C3	0x6128	# <CJK>
0xE1C4	0x6141	# <CJK>
0xE1C5	0x615E	# <CJK>
0xE1C6	0x6171	# <CJK>
0xE1C7	0x6173	# <CJK>
0xE1C8	0x6152	# <CJK>
0xE1C9	0x6153	# <CJK>
0xE1CA	0x6172	# <CJK>
0xE1CB	0x616C	# <CJK>
0xE1CC	0x6180	# <CJK>
0xE1CD	0x6174	# <CJK>
0xE1CE	0x6154	# <CJK>
0xE1CF	0x617A	# <CJK>
0xE1D0	0x615B	# <CJK>
0xE1D1	0x6165	# <CJK>
0xE1D2	0x613B	# <CJK>
0xE1D3	0x616A	# <CJK>
0xE1D4	0x6161	# <CJK>
0xE1D5	0x6156	# <CJK>
0xE1D6	0x6229	# <CJK>
0xE1D7	0x6227	# <CJK>
0xE1D8	0x622B	# <CJK>
0xE1D9	0x642B	# <CJK>
0xE1DA	0x644D	# <CJK>
0xE1DB	0x645B	# <CJK>
0xE1DC	0x645D	# <CJK>
0xE1DD	0x6474	# <CJK>
0xE1DE	0x6476	# <CJK>
0xE1DF	0x6472	# <CJK>
0xE1E0	0x6473	# <CJK>
0xE1E1	0x647D	# <CJK>
0xE1E2	0x6475	# <CJK>
0xE1E3	0x6466	# <CJK>
0xE1E4	0x64A6	# <CJK>
0xE1E5	0x644E	# <CJK>
0xE1E6	0x6482	# <CJK>
0xE1E7	0x645E	# <CJK>
0xE1E8	0x645C	# <CJK>
0xE1E9	0x644B	# <CJK>
0xE1EA	0x6453	# <CJK>
0xE1EB	0x6460	# <CJK>
0xE1EC	0x6450	# <CJK>
0xE1ED	0x647F	# <CJK>
0xE1EE	0x643F	# <CJK>
0xE1EF	0x646C	# <CJK>
0xE1F0	0x646B	# <CJK>
0xE1F1	0x6459	# <CJK>
0xE1F2	0x6465	# <CJK>
0xE1F3	0x6477	# <CJK>
0xE1F4	0x6573	# <CJK>
0xE1F5	0x65A0	# <CJK>
0xE1F6	0x66A1	# <CJK>
0xE1F7	0x66A0	# <CJK>
0xE1F8	0x669F	# <CJK>
0xE1F9	0x6705	# <CJK>
0xE1FA	0x6704	# <CJK>
0xE1FB	0x6722	# <CJK>
0xE1FC	0x69B1	# <CJK>
0xE1FD	0x69B6	# <CJK>
0xE1FE	0x69C9	# <CJK>
0xE240	0x69A0	# <CJK>
0xE241	0x69CE	# <CJK>
0xE242	0x6996	# <CJK>
0xE243	0x69B0	# <CJK>
0xE244	0x69AC	# <CJK>
0xE245	0x69BC	# <CJK>
0xE246	0x6991	# <CJK>
0xE247	0x6999	# <CJK>
0xE248	0x698E	# <CJK>
0xE249	0x69A7	# <CJK>
0xE24A	0x698D	# <CJK>
0xE24B	0x69A9	# <CJK>
0xE24C	0x69BE	# <CJK>
0xE24D	0x69AF	# <CJK>
0xE24E	0x69BF	# <CJK>
0xE24F	0x69C4	# <CJK>
0xE250	0x69BD	# <CJK>
0xE251	0x69A4	# <CJK>
0xE252	0x69D4	# <CJK>
0xE253	0x69B9	# <CJK>
0xE254	0x69CA	# <CJK>
0xE255	0x699A	# <CJK>
0xE256	0x69CF	# <CJK>
0xE257	0x69B3	# <CJK>
0xE258	0x6993	# <CJK>
0xE259	0x69AA	# <CJK>
0xE25A	0x69A1	# <CJK>
0xE25B	0x699E	# <CJK>
0xE25C	0x69D9	# <CJK>
0xE25D	0x6997	# <CJK>
0xE25E	0x6990	# <CJK>
0xE25F	0x69C2	# <CJK>
0xE260	0x69B5	# <CJK>
0xE261	0x69A5	# <CJK>
0xE262	0x69C6	# <CJK>
0xE263	0x6B4A	# <CJK>
0xE264	0x6B4D	# <CJK>
0xE265	0x6B4B	# <CJK>
0xE266	0x6B9E	# <CJK>
0xE267	0x6B9F	# <CJK>
0xE268	0x6BA0	# <CJK>
0xE269	0x6BC3	# <CJK>
0xE26A	0x6BC4	# <CJK>
0xE26B	0x6BFE	# <CJK>
0xE26C	0x6ECE	# <CJK>
0xE26D	0x6EF5	# <CJK>
0xE26E	0x6EF1	# <CJK>
0xE26F	0x6F03	# <CJK>
0xE270	0x6F25	# <CJK>
0xE271	0x6EF8	# <CJK>
0xE272	0x6F37	# <CJK>
0xE273	0x6EFB	# <CJK>
0xE274	0x6F2E	# <CJK>
0xE275	0x6F09	# <CJK>
0xE276	0x6F4E	# <CJK>
0xE277	0x6F19	# <CJK>
0xE278	0x6F1A	# <CJK>
0xE279	0x6F27	# <CJK>
0xE27A	0x6F18	# <CJK>
0xE27B	0x6F3B	# <CJK>
0xE27C	0x6F12	# <CJK>
0xE27D	0x6EED	# <CJK>
0xE27E	0x6F0A	# <CJK>
0xE2A1	0x6F36	# <CJK>
0xE2A2	0x6F73	# <CJK>
0xE2A3	0x6EF9	# <CJK>
0xE2A4	0x6EEE	# <CJK>
0xE2A5	0x6F2D	# <CJK>
0xE2A6	0x6F40	# <CJK>
0xE2A7	0x6F30	# <CJK>
0xE2A8	0x6F3C	# <CJK>
0xE2A9	0x6F35	# <CJK>
0xE2AA	0x6EEB	# <CJK>
0xE2AB	0x6F07	# <CJK>
0xE2AC	0x6F0E	# <CJK>
0xE2AD	0x6F43	# <CJK>
0xE2AE	0x6F05	# <CJK>
0xE2AF	0x6EFD	# <CJK>
0xE2B0	0x6EF6	# <CJK>
0xE2B1	0x6F39	# <CJK>
0xE2B2	0x6F1C	# <CJK>
0xE2B3	0x6EFC	# <CJK>
0xE2B4	0x6F3A	# <CJK>
0xE2B5	0x6F1F	# <CJK>
0xE2B6	0x6F0D	# <CJK>
0xE2B7	0x6F1E	# <CJK>
0xE2B8	0x6F08	# <CJK>
0xE2B9	0x6F21	# <CJK>
0xE2BA	0x7187	# <CJK>
0xE2BB	0x7190	# <CJK>
0xE2BC	0x7189	# <CJK>
0xE2BD	0x7180	# <CJK>
0xE2BE	0x7185	# <CJK>
0xE2BF	0x7182	# <CJK>
0xE2C0	0x718F	# <CJK>
0xE2C1	0x717B	# <CJK>
0xE2C2	0x7186	# <CJK>
0xE2C3	0x7181	# <CJK>
0xE2C4	0x7197	# <CJK>
0xE2C5	0x7244	# <CJK>
0xE2C6	0x7253	# <CJK>
0xE2C7	0x7297	# <CJK>
0xE2C8	0x7295	# <CJK>
0xE2C9	0x7293	# <CJK>
0xE2CA	0x7343	# <CJK>
0xE2CB	0x734D	# <CJK>
0xE2CC	0x7351	# <CJK>
0xE2CD	0x734C	# <CJK>
0xE2CE	0x7462	# <CJK>
0xE2CF	0x7473	# <CJK>
0xE2D0	0x7471	# <CJK>
0xE2D1	0x7475	# <CJK>
0xE2D2	0x7472	# <CJK>
0xE2D3	0x7467	# <CJK>
0xE2D4	0x746E	# <CJK>
0xE2D5	0x7500	# <CJK>
0xE2D6	0x7502	# <CJK>
0xE2D7	0x7503	# <CJK>
0xE2D8	0x757D	# <CJK>
0xE2D9	0x7590	# <CJK>
0xE2DA	0x7616	# <CJK>
0xE2DB	0x7608	# <CJK>
0xE2DC	0x760C	# <CJK>
0xE2DD	0x7615	# <CJK>
0xE2DE	0x7611	# <CJK>
0xE2DF	0x760A	# <CJK>
0xE2E0	0x7614	# <CJK>
0xE2E1	0x76B8	# <CJK>
0xE2E2	0x7781	# <CJK>
0xE2E3	0x777C	# <CJK>
0xE2E4	0x7785	# <CJK>
0xE2E5	0x7782	# <CJK>
0xE2E6	0x776E	# <CJK>
0xE2E7	0x7780	# <CJK>
0xE2E8	0x776F	# <CJK>
0xE2E9	0x777E	# <CJK>
0xE2EA	0x7783	# <CJK>
0xE2EB	0x78B2	# <CJK>
0xE2EC	0x78AA	# <CJK>
0xE2ED	0x78B4	# <CJK>
0xE2EE	0x78AD	# <CJK>
0xE2EF	0x78A8	# <CJK>
0xE2F0	0x787E	# <CJK>
0xE2F1	0x78AB	# <CJK>
0xE2F2	0x789E	# <CJK>
0xE2F3	0x78A5	# <CJK>
0xE2F4	0x78A0	# <CJK>
0xE2F5	0x78AC	# <CJK>
0xE2F6	0x78A2	# <CJK>
0xE2F7	0x78A4	# <CJK>
0xE2F8	0x7998	# <CJK>
0xE2F9	0x798A	# <CJK>
0xE2FA	0x798B	# <CJK>
0xE2FB	0x7996	# <CJK>
0xE2FC	0x7995	# <CJK>
0xE2FD	0x7994	# <CJK>
0xE2FE	0x7993	# <CJK>
0xE340	0x7997	# <CJK>
0xE341	0x7988	# <CJK>
0xE342	0x7992	# <CJK>
0xE343	0x7990	# <CJK>
0xE344	0x7A2B	# <CJK>
0xE345	0x7A4A	# <CJK>
0xE346	0x7A30	# <CJK>
0xE347	0x7A2F	# <CJK>
0xE348	0x7A28	# <CJK>
0xE349	0x7A26	# <CJK>
0xE34A	0x7AA8	# <CJK>
0xE34B	0x7AAB	# <CJK>
0xE34C	0x7AAC	# <CJK>
0xE34D	0x7AEE	# <CJK>
0xE34E	0x7B88	# <CJK>
0xE34F	0x7B9C	# <CJK>
0xE350	0x7B8A	# <CJK>
0xE351	0x7B91	# <CJK>
0xE352	0x7B90	# <CJK>
0xE353	0x7B96	# <CJK>
0xE354	0x7B8D	# <CJK>
0xE355	0x7B8C	# <CJK>
0xE356	0x7B9B	# <CJK>
0xE357	0x7B8E	# <CJK>
0xE358	0x7B85	# <CJK>
0xE359	0x7B98	# <CJK>
0xE35A	0x5284	# <CJK>
0xE35B	0x7B99	# <CJK>
0xE35C	0x7BA4	# <CJK>
0xE35D	0x7B82	# <CJK>
0xE35E	0x7CBB	# <CJK>
0xE35F	0x7CBF	# <CJK>
0xE360	0x7CBC	# <CJK>
0xE361	0x7CBA	# <CJK>
0xE362	0x7DA7	# <CJK>
0xE363	0x7DB7	# <CJK>
0xE364	0x7DC2	# <CJK>
0xE365	0x7DA3	# <CJK>
0xE366	0x7DAA	# <CJK>
0xE367	0x7DC1	# <CJK>
0xE368	0x7DC0	# <CJK>
0xE369	0x7DC5	# <CJK>
0xE36A	0x7D9D	# <CJK>
0xE36B	0x7DCE	# <CJK>
0xE36C	0x7DC4	# <CJK>
0xE36D	0x7DC6	# <CJK>
0xE36E	0x7DCB	# <CJK>
0xE36F	0x7DCC	# <CJK>
0xE370	0x7DAF	# <CJK>
0xE371	0x7DB9	# <CJK>
0xE372	0x7D96	# <CJK>
0xE373	0x7DBC	# <CJK>
0xE374	0x7D9F	# <CJK>
0xE375	0x7DA6	# <CJK>
0xE376	0x7DAE	# <CJK>
0xE377	0x7DA9	# <CJK>
0xE378	0x7DA1	# <CJK>
0xE379	0x7DC9	# <CJK>
0xE37A	0x7F73	# <CJK>
0xE37B	0x7FE2	# <CJK>
0xE37C	0x7FE3	# <CJK>
0xE37D	0x7FE5	# <CJK>
0xE37E	0x7FDE	# <CJK>
0xE3A1	0x8024	# <CJK>
0xE3A2	0x805D	# <CJK>
0xE3A3	0x805C	# <CJK>
0xE3A4	0x8189	# <CJK>
0xE3A5	0x8186	# <CJK>
0xE3A6	0x8183	# <CJK>
0xE3A7	0x8187	# <CJK>
0xE3A8	0x818D	# <CJK>
0xE3A9	0x818C	# <CJK>
0xE3AA	0x818B	# <CJK>
0xE3AB	0x8215	# <CJK>
0xE3AC	0x8497	# <CJK>
0xE3AD	0x84A4	# <CJK>
0xE3AE	0x84A1	# <CJK>
0xE3AF	0x849F	# <CJK>
0xE3B0	0x84BA	# <CJK>
0xE3B1	0x84CE	# <CJK>
0xE3B2	0x84C2	# <CJK>
0xE3B3	0x84AC	# <CJK>
0xE3B4	0x84AE	# <CJK>
0xE3B5	0x84AB	# <CJK>
0xE3B6	0x84B9	# <CJK>
0xE3B7	0x84B4	# <CJK>
0xE3B8	0x84C1	# <CJK>
0xE3B9	0x84CD	# <CJK>
0xE3BA	0x84AA	# <CJK>
0xE3BB	0x849A	# <CJK>
0xE3BC	0x84B1	# <CJK>
0xE3BD	0x84D0	# <CJK>
0xE3BE	0x849D	# <CJK>
0xE3BF	0x84A7	# <CJK>
0xE3C0	0x84BB	# <CJK>
0xE3C1	0x84A2	# <CJK>
0xE3C2	0x8494	# <CJK>
0xE3C3	0x84C7	# <CJK>
0xE3C4	0x84CC	# <CJK>
0xE3C5	0x849B	# <CJK>
0xE3C6	0x84A9	# <CJK>
0xE3C7	0x84AF	# <CJK>
0xE3C8	0x84A8	# <CJK>
0xE3C9	0x84D6	# <CJK>
0xE3CA	0x8498	# <CJK>
0xE3CB	0x84B6	# <CJK>
0xE3CC	0x84CF	# <CJK>
0xE3CD	0x84A0	# <CJK>
0xE3CE	0x84D7	# <CJK>
0xE3CF	0x84D4	# <CJK>
0xE3D0	0x84D2	# <CJK>
0xE3D1	0x84DB	# <CJK>
0xE3D2	0x84B0	# <CJK>
0xE3D3	0x8491	# <CJK>
0xE3D4	0x8661	# <CJK>
0xE3D5	0x8733	# <CJK>
0xE3D6	0x8723	# <CJK>
0xE3D7	0x8728	# <CJK>
0xE3D8	0x876B	# <CJK>
0xE3D9	0x8740	# <CJK>
0xE3DA	0x872E	# <CJK>
0xE3DB	0x871E	# <CJK>
0xE3DC	0x8721	# <CJK>
0xE3DD	0x8719	# <CJK>
0xE3DE	0x871B	# <CJK>
0xE3DF	0x8743	# <CJK>
0xE3E0	0x872C	# <CJK>
0xE3E1	0x8741	# <CJK>
0xE3E2	0x873E	# <CJK>
0xE3E3	0x8746	# <CJK>
0xE3E4	0x8720	# <CJK>
0xE3E5	0x8732	# <CJK>
0xE3E6	0x872A	# <CJK>
0xE3E7	0x872D	# <CJK>
0xE3E8	0x873C	# <CJK>
0xE3E9	0x8712	# <CJK>
0xE3EA	0x873A	# <CJK>
0xE3EB	0x8731	# <CJK>
0xE3EC	0x8735	# <CJK>
0xE3ED	0x8742	# <CJK>
0xE3EE	0x8726	# <CJK>
0xE3EF	0x8727	# <CJK>
0xE3F0	0x8738	# <CJK>
0xE3F1	0x8724	# <CJK>
0xE3F2	0x871A	# <CJK>
0xE3F3	0x8730	# <CJK>
0xE3F4	0x8711	# <CJK>
0xE3F5	0x88F7	# <CJK>
0xE3F6	0x88E7	# <CJK>
0xE3F7	0x88F1	# <CJK>
0xE3F8	0x88F2	# <CJK>
0xE3F9	0x88FA	# <CJK>
0xE3FA	0x88FE	# <CJK>
0xE3FB	0x88EE	# <CJK>
0xE3FC	0x88FC	# <CJK>
0xE3FD	0x88F6	# <CJK>
0xE3FE	0x88FB	# <CJK>
0xE440	0x88F0	# <CJK>
0xE441	0x88EC	# <CJK>
0xE442	0x88EB	# <CJK>
0xE443	0x899D	# <CJK>
0xE444	0x89A1	# <CJK>
0xE445	0x899F	# <CJK>
0xE446	0x899E	# <CJK>
0xE447	0x89E9	# <CJK>
0xE448	0x89EB	# <CJK>
0xE449	0x89E8	# <CJK>
0xE44A	0x8AAB	# <CJK>
0xE44B	0x8A99	# <CJK>
0xE44C	0x8A8B	# <CJK>
0xE44D	0x8A92	# <CJK>
0xE44E	0x8A8F	# <CJK>
0xE44F	0x8A96	# <CJK>
0xE450	0x8C3D	# <CJK>
0xE451	0x8C68	# <CJK>
0xE452	0x8C69	# <CJK>
0xE453	0x8CD5	# <CJK>
0xE454	0x8CCF	# <CJK>
0xE455	0x8CD7	# <CJK>
0xE456	0x8D96	# <CJK>
0xE457	0x8E09	# <CJK>
0xE458	0x8E02	# <CJK>
0xE459	0x8DFF	# <CJK>
0xE45A	0x8E0D	# <CJK>
0xE45B	0x8DFD	# <CJK>
0xE45C	0x8E0A	# <CJK>
0xE45D	0x8E03	# <CJK>
0xE45E	0x8E07	# <CJK>
0xE45F	0x8E06	# <CJK>
0xE460	0x8E05	# <CJK>
0xE461	0x8DFE	# <CJK>
0xE462	0x8E00	# <CJK>
0xE463	0x8E04	# <CJK>
0xE464	0x8F10	# <CJK>
0xE465	0x8F11	# <CJK>
0xE466	0x8F0E	# <CJK>
0xE467	0x8F0D	# <CJK>
0xE468	0x9123	# <CJK>
0xE469	0x911C	# <CJK>
0xE46A	0x9120	# <CJK>
0xE46B	0x9122	# <CJK>
0xE46C	0x911F	# <CJK>
0xE46D	0x911D	# <CJK>
0xE46E	0x911A	# <CJK>
0xE46F	0x9124	# <CJK>
0xE470	0x9121	# <CJK>
0xE471	0x911B	# <CJK>
0xE472	0x917A	# <CJK>
0xE473	0x9172	# <CJK>
0xE474	0x9179	# <CJK>
0xE475	0x9173	# <CJK>
0xE476	0x92A5	# <CJK>
0xE477	0x92A4	# <CJK>
0xE478	0x9276	# <CJK>
0xE479	0x929B	# <CJK>
0xE47A	0x927A	# <CJK>
0xE47B	0x92A0	# <CJK>
0xE47C	0x9294	# <CJK>
0xE47D	0x92AA	# <CJK>
0xE47E	0x928D	# <CJK>
0xE4A1	0x92A6	# <CJK>
0xE4A2	0x929A	# <CJK>
0xE4A3	0x92AB	# <CJK>
0xE4A4	0x9279	# <CJK>
0xE4A5	0x9297	# <CJK>
0xE4A6	0x927F	# <CJK>
0xE4A7	0x92A3	# <CJK>
0xE4A8	0x92EE	# <CJK>
0xE4A9	0x928E	# <CJK>
0xE4AA	0x9282	# <CJK>
0xE4AB	0x9295	# <CJK>
0xE4AC	0x92A2	# <CJK>
0xE4AD	0x927D	# <CJK>
0xE4AE	0x9288	# <CJK>
0xE4AF	0x92A1	# <CJK>
0xE4B0	0x928A	# <CJK>
0xE4B1	0x9286	# <CJK>
0xE4B2	0x928C	# <CJK>
0xE4B3	0x9299	# <CJK>
0xE4B4	0x92A7	# <CJK>
0xE4B5	0x927E	# <CJK>
0xE4B6	0x9287	# <CJK>
0xE4B7	0x92A9	# <CJK>
0xE4B8	0x929D	# <CJK>
0xE4B9	0x928B	# <CJK>
0xE4BA	0x922D	# <CJK>
0xE4BB	0x969E	# <CJK>
0xE4BC	0x96A1	# <CJK>
0xE4BD	0x96FF	# <CJK>
0xE4BE	0x9758	# <CJK>
0xE4BF	0x977D	# <CJK>
0xE4C0	0x977A	# <CJK>
0xE4C1	0x977E	# <CJK>
0xE4C2	0x9783	# <CJK>
0xE4C3	0x9780	# <CJK>
0xE4C4	0x9782	# <CJK>
0xE4C5	0x977B	# <CJK>
0xE4C6	0x9784	# <CJK>
0xE4C7	0x9781	# <CJK>
0xE4C8	0x977F	# <CJK>
0xE4C9	0x97CE	# <CJK>
0xE4CA	0x97CD	# <CJK>
0xE4CB	0x9816	# <CJK>
0xE4CC	0x98AD	# <CJK>
0xE4CD	0x98AE	# <CJK>
0xE4CE	0x9902	# <CJK>
0xE4CF	0x9900	# <CJK>
0xE4D0	0x9907	# <CJK>
0xE4D1	0x999D	# <CJK>
0xE4D2	0x999C	# <CJK>
0xE4D3	0x99C3	# <CJK>
0xE4D4	0x99B9	# <CJK>
0xE4D5	0x99BB	# <CJK>
0xE4D6	0x99BA	# <CJK>
0xE4D7	0x99C2	# <CJK>
0xE4D8	0x99BD	# <CJK>
0xE4D9	0x99C7	# <CJK>
0xE4DA	0x9AB1	# <CJK>
0xE4DB	0x9AE3	# <CJK>
0xE4DC	0x9AE7	# <CJK>
0xE4DD	0x9B3E	# <CJK>
0xE4DE	0x9B3F	# <CJK>
0xE4DF	0x9B60	# <CJK>
0xE4E0	0x9B61	# <CJK>
0xE4E1	0x9B5F	# <CJK>
0xE4E2	0x9CF1	# <CJK>
0xE4E3	0x9CF2	# <CJK>
0xE4E4	0x9CF5	# <CJK>
0xE4E5	0x9EA7	# <CJK>
0xE4E6	0x50FF	# <CJK>
0xE4E7	0x5103	# <CJK>
0xE4E8	0x5130	# <CJK>
0xE4E9	0x50F8	# <CJK>
0xE4EA	0x5106	# <CJK>
0xE4EB	0x5107	# <CJK>
0xE4EC	0x50F6	# <CJK>
0xE4ED	0x50FE	# <CJK>
0xE4EE	0x510B	# <CJK>
0xE4EF	0x510C	# <CJK>
0xE4F0	0x50FD	# <CJK>
0xE4F1	0x510A	# <CJK>
0xE4F2	0x528B	# <CJK>
0xE4F3	0x528C	# <CJK>
0xE4F4	0x52F1	# <CJK>
0xE4F5	0x52EF	# <CJK>
0xE4F6	0x5648	# <CJK>
0xE4F7	0x5642	# <CJK>
0xE4F8	0x564C	# <CJK>
0xE4F9	0x5635	# <CJK>
0xE4FA	0x5641	# <CJK>
0xE4FB	0x564A	# <CJK>
0xE4FC	0x5649	# <CJK>
0xE4FD	0x5646	# <CJK>
0xE4FE	0x5658	# <CJK>
0xE540	0x565A	# <CJK>
0xE541	0x5640	# <CJK>
0xE542	0x5633	# <CJK>
0xE543	0x563D	# <CJK>
0xE544	0x562C	# <CJK>
0xE545	0x563E	# <CJK>
0xE546	0x5638	# <CJK>
0xE547	0x562A	# <CJK>
0xE548	0x563A	# <CJK>
0xE549	0x571A	# <CJK>
0xE54A	0x58AB	# <CJK>
0xE54B	0x589D	# <CJK>
0xE54C	0x58B1	# <CJK>
0xE54D	0x58A0	# <CJK>
0xE54E	0x58A3	# <CJK>
0xE54F	0x58AF	# <CJK>
0xE550	0x58AC	# <CJK>
0xE551	0x58A5	# <CJK>
0xE552	0x58A1	# <CJK>
0xE553	0x58FF	# <CJK>
0xE554	0x5AFF	# <CJK>
0xE555	0x5AF4	# <CJK>
0xE556	0x5AFD	# <CJK>
0xE557	0x5AF7	# <CJK>
0xE558	0x5AF6	# <CJK>
0xE559	0x5B03	# <CJK>
0xE55A	0x5AF8	# <CJK>
0xE55B	0x5B02	# <CJK>
0xE55C	0x5AF9	# <CJK>
0xE55D	0x5B01	# <CJK>
0xE55E	0x5B07	# <CJK>
0xE55F	0x5B05	# <CJK>
0xE560	0x5B0F	# <CJK>
0xE561	0x5C67	# <CJK>
0xE562	0x5D99	# <CJK>
0xE563	0x5D97	# <CJK>
0xE564	0x5D9F	# <CJK>
0xE565	0x5D92	# <CJK>
0xE566	0x5DA2	# <CJK>
0xE567	0x5D93	# <CJK>
0xE568	0x5D95	# <CJK>
0xE569	0x5DA0	# <CJK>
0xE56A	0x5D9C	# <CJK>
0xE56B	0x5DA1	# <CJK>
0xE56C	0x5D9A	# <CJK>
0xE56D	0x5D9E	# <CJK>
0xE56E	0x5E69	# <CJK>
0xE56F	0x5E5D	# <CJK>
0xE570	0x5E60	# <CJK>
0xE571	0x5E5C	# <CJK>
0xE572	0x7DF3	# <CJK>
0xE573	0x5EDB	# <CJK>
0xE574	0x5EDE	# <CJK>
0xE575	0x5EE1	# <CJK>
0xE576	0x5F49	# <CJK>
0xE577	0x5FB2	# <CJK>
0xE578	0x618B	# <CJK>
0xE579	0x6183	# <CJK>
0xE57A	0x6179	# <CJK>
0xE57B	0x61B1	# <CJK>
0xE57C	0x61B0	# <CJK>
0xE57D	0x61A2	# <CJK>
0xE57E	0x6189	# <CJK>
0xE5A1	0x619B	# <CJK>
0xE5A2	0x6193	# <CJK>
0xE5A3	0x61AF	# <CJK>
0xE5A4	0x61AD	# <CJK>
0xE5A5	0x619F	# <CJK>
0xE5A6	0x6192	# <CJK>
0xE5A7	0x61AA	# <CJK>
0xE5A8	0x61A1	# <CJK>
0xE5A9	0x618D	# <CJK>
0xE5AA	0x6166	# <CJK>
0xE5AB	0x61B3	# <CJK>
0xE5AC	0x622D	# <CJK>
0xE5AD	0x646E	# <CJK>
0xE5AE	0x6470	# <CJK>
0xE5AF	0x6496	# <CJK>
0xE5B0	0x64A0	# <CJK>
0xE5B1	0x6485	# <CJK>
0xE5B2	0x6497	# <CJK>
0xE5B3	0x649C	# <CJK>
0xE5B4	0x648F	# <CJK>
0xE5B5	0x648B	# <CJK>
0xE5B6	0x648A	# <CJK>
0xE5B7	0x648C	# <CJK>
0xE5B8	0x64A3	# <CJK>
0xE5B9	0x649F	# <CJK>
0xE5BA	0x6468	# <CJK>
0xE5BB	0x64B1	# <CJK>
0xE5BC	0x6498	# <CJK>
0xE5BD	0x6576	# <CJK>
0xE5BE	0x657A	# <CJK>
0xE5BF	0x6579	# <CJK>
0xE5C0	0x657B	# <CJK>
0xE5C1	0x65B2	# <CJK>
0xE5C2	0x65B3	# <CJK>
0xE5C3	0x66B5	# <CJK>
0xE5C4	0x66B0	# <CJK>
0xE5C5	0x66A9	# <CJK>
0xE5C6	0x66B2	# <CJK>
0xE5C7	0x66B7	# <CJK>
0xE5C8	0x66AA	# <CJK>
0xE5C9	0x66AF	# <CJK>
0xE5CA	0x6A00	# <CJK>
0xE5CB	0x6A06	# <CJK>
0xE5CC	0x6A17	# <CJK>
0xE5CD	0x69E5	# <CJK>
0xE5CE	0x69F8	# <CJK>
0xE5CF	0x6A15	# <CJK>
0xE5D0	0x69F1	# <CJK>
0xE5D1	0x69E4	# <CJK>
0xE5D2	0x6A20	# <CJK>
0xE5D3	0x69FF	# <CJK>
0xE5D4	0x69EC	# <CJK>
0xE5D5	0x69E2	# <CJK>
0xE5D6	0x6A1B	# <CJK>
0xE5D7	0x6A1D	# <CJK>
0xE5D8	0x69FE	# <CJK>
0xE5D9	0x6A27	# <CJK>
0xE5DA	0x69F2	# <CJK>
0xE5DB	0x69EE	# <CJK>
0xE5DC	0x6A14	# <CJK>
0xE5DD	0x69F7	# <CJK>
0xE5DE	0x69E7	# <CJK>
0xE5DF	0x6A40	# <CJK>
0xE5E0	0x6A08	# <CJK>
0xE5E1	0x69E6	# <CJK>
0xE5E2	0x69FB	# <CJK>
0xE5E3	0x6A0D	# <CJK>
0xE5E4	0x69FC	# <CJK>
0xE5E5	0x69EB	# <CJK>
0xE5E6	0x6A09	# <CJK>
0xE5E7	0x6A04	# <CJK>
0xE5E8	0x6A18	# <CJK>
0xE5E9	0x6A25	# <CJK>
0xE5EA	0x6A0F	# <CJK>
0xE5EB	0x69F6	# <CJK>
0xE5EC	0x6A26	# <CJK>
0xE5ED	0x6A07	# <CJK>
0xE5EE	0x69F4	# <CJK>
0xE5EF	0x6A16	# <CJK>
0xE5F0	0x6B51	# <CJK>
0xE5F1	0x6BA5	# <CJK>
0xE5F2	0x6BA3	# <CJK>
0xE5F3	0x6BA2	# <CJK>
0xE5F4	0x6BA6	# <CJK>
0xE5F5	0x6C01	# <CJK>
0xE5F6	0x6C00	# <CJK>
0xE5F7	0x6BFF	# <CJK>
0xE5F8	0x6C02	# <CJK>
0xE5F9	0x6F41	# <CJK>
0xE5FA	0x6F26	# <CJK>
0xE5FB	0x6F7E	# <CJK>
0xE5FC	0x6F87	# <CJK>
0xE5FD	0x6FC6	# <CJK>
0xE5FE	0x6F92	# <CJK>
0xE640	0x6F8D	# <CJK>
0xE641	0x6F89	# <CJK>
0xE642	0x6F8C	# <CJK>
0xE643	0x6F62	# <CJK>
0xE644	0x6F4F	# <CJK>
0xE645	0x6F85	# <CJK>
0xE646	0x6F5A	# <CJK>
0xE647	0x6F96	# <CJK>
0xE648	0x6F76	# <CJK>
0xE649	0x6F6C	# <CJK>
0xE64A	0x6F82	# <CJK>
0xE64B	0x6F55	# <CJK>
0xE64C	0x6F72	# <CJK>
0xE64D	0x6F52	# <CJK>
0xE64E	0x6F50	# <CJK>
0xE64F	0x6F57	# <CJK>
0xE650	0x6F94	# <CJK>
0xE651	0x6F93	# <CJK>
0xE652	0x6F5D	# <CJK>
0xE653	0x6F00	# <CJK>
0xE654	0x6F61	# <CJK>
0xE655	0x6F6B	# <CJK>
0xE656	0x6F7D	# <CJK>
0xE657	0x6F67	# <CJK>
0xE658	0x6F90	# <CJK>
0xE659	0x6F53	# <CJK>
0xE65A	0x6F8B	# <CJK>
0xE65B	0x6F69	# <CJK>
0xE65C	0x6F7F	# <CJK>
0xE65D	0x6F95	# <CJK>
0xE65E	0x6F63	# <CJK>
0xE65F	0x6F77	# <CJK>
0xE660	0x6F6A	# <CJK>
0xE661	0x6F7B	# <CJK>
0xE662	0x71B2	# <CJK>
0xE663	0x71AF	# <CJK>
0xE664	0x719B	# <CJK>
0xE665	0x71B0	# <CJK>
0xE666	0x71A0	# <CJK>
0xE667	0x719A	# <CJK>
0xE668	0x71A9	# <CJK>
0xE669	0x71B5	# <CJK>
0xE66A	0x719D	# <CJK>
0xE66B	0x71A5	# <CJK>
0xE66C	0x719E	# <CJK>
0xE66D	0x71A4	# <CJK>
0xE66E	0x71A1	# <CJK>
0xE66F	0x71AA	# <CJK>
0xE670	0x719C	# <CJK>
0xE671	0x71A7	# <CJK>
0xE672	0x71B3	# <CJK>
0xE673	0x7298	# <CJK>
0xE674	0x729A	# <CJK>
0xE675	0x7358	# <CJK>
0xE676	0x7352	# <CJK>
0xE677	0x735E	# <CJK>
0xE678	0x735F	# <CJK>
0xE679	0x7360	# <CJK>
0xE67A	0x735D	# <CJK>
0xE67B	0x735B	# <CJK>
0xE67C	0x7361	# <CJK>
0xE67D	0x735A	# <CJK>
0xE67E	0x7359	# <CJK>
0xE6A1	0x7362	# <CJK>
0xE6A2	0x7487	# <CJK>
0xE6A3	0x7489	# <CJK>
0xE6A4	0x748A	# <CJK>
0xE6A5	0x7486	# <CJK>
0xE6A6	0x7481	# <CJK>
0xE6A7	0x747D	# <CJK>
0xE6A8	0x7485	# <CJK>
0xE6A9	0x7488	# <CJK>
0xE6AA	0x747C	# <CJK>
0xE6AB	0x7479	# <CJK>
0xE6AC	0x7508	# <CJK>
0xE6AD	0x7507	# <CJK>
0xE6AE	0x757E	# <CJK>
0xE6AF	0x7625	# <CJK>
0xE6B0	0x761E	# <CJK>
0xE6B1	0x7619	# <CJK>
0xE6B2	0x761D	# <CJK>
0xE6B3	0x761C	# <CJK>
0xE6B4	0x7623	# <CJK>
0xE6B5	0x761A	# <CJK>
0xE6B6	0x7628	# <CJK>
0xE6B7	0x761B	# <CJK>
0xE6B8	0x769C	# <CJK>
0xE6B9	0x769D	# <CJK>
0xE6BA	0x769E	# <CJK>
0xE6BB	0x769B	# <CJK>
0xE6BC	0x778D	# <CJK>
0xE6BD	0x778F	# <CJK>
0xE6BE	0x7789	# <CJK>
0xE6BF	0x7788	# <CJK>
0xE6C0	0x78CD	# <CJK>
0xE6C1	0x78BB	# <CJK>
0xE6C2	0x78CF	# <CJK>
0xE6C3	0x78CC	# <CJK>
0xE6C4	0x78D1	# <CJK>
0xE6C5	0x78CE	# <CJK>
0xE6C6	0x78D4	# <CJK>
0xE6C7	0x78C8	# <CJK>
0xE6C8	0x78C3	# <CJK>
0xE6C9	0x78C4	# <CJK>
0xE6CA	0x78C9	# <CJK>
0xE6CB	0x799A	# <CJK>
0xE6CC	0x79A1	# <CJK>
0xE6CD	0x79A0	# <CJK>
0xE6CE	0x799C	# <CJK>
0xE6CF	0x79A2	# <CJK>
0xE6D0	0x799B	# <CJK>
0xE6D1	0x6B76	# <CJK>
0xE6D2	0x7A39	# <CJK>
0xE6D3	0x7AB2	# <CJK>
0xE6D4	0x7AB4	# <CJK>
0xE6D5	0x7AB3	# <CJK>
0xE6D6	0x7BB7	# <CJK>
0xE6D7	0x7BCB	# <CJK>
0xE6D8	0x7BBE	# <CJK>
0xE6D9	0x7BAC	# <CJK>
0xE6DA	0x7BCE	# <CJK>
0xE6DB	0x7BAF	# <CJK>
0xE6DC	0x7BB9	# <CJK>
0xE6DD	0x7BCA	# <CJK>
0xE6DE	0x7BB5	# <CJK>
0xE6DF	0x7CC5	# <CJK>
0xE6E0	0x7CC8	# <CJK>
0xE6E1	0x7CCC	# <CJK>
0xE6E2	0x7CCB	# <CJK>
0xE6E3	0x7DF7	# <CJK>
0xE6E4	0x7DDB	# <CJK>
0xE6E5	0x7DEA	# <CJK>
0xE6E6	0x7DE7	# <CJK>
0xE6E7	0x7DD7	# <CJK>
0xE6E8	0x7DE1	# <CJK>
0xE6E9	0x7E03	# <CJK>
0xE6EA	0x7DFA	# <CJK>
0xE6EB	0x7DE6	# <CJK>
0xE6EC	0x7DF6	# <CJK>
0xE6ED	0x7DF1	# <CJK>
0xE6EE	0x7DF0	# <CJK>
0xE6EF	0x7DEE	# <CJK>
0xE6F0	0x7DDF	# <CJK>
0xE6F1	0x7F76	# <CJK>
0xE6F2	0x7FAC	# <CJK>
0xE6F3	0x7FB0	# <CJK>
0xE6F4	0x7FAD	# <CJK>
0xE6F5	0x7FED	# <CJK>
0xE6F6	0x7FEB	# <CJK>
0xE6F7	0x7FEA	# <CJK>
0xE6F8	0x7FEC	# <CJK>
0xE6F9	0x7FE6	# <CJK>
0xE6FA	0x7FE8	# <CJK>
0xE6FB	0x8064	# <CJK>
0xE6FC	0x8067	# <CJK>
0xE6FD	0x81A3	# <CJK>
0xE6FE	0x819F	# <CJK>
0xE740	0x819E	# <CJK>
0xE741	0x8195	# <CJK>
0xE742	0x81A2	# <CJK>
0xE743	0x8199	# <CJK>
0xE744	0x8197	# <CJK>
0xE745	0x8216	# <CJK>
0xE746	0x824F	# <CJK>
0xE747	0x8253	# <CJK>
0xE748	0x8252	# <CJK>
0xE749	0x8250	# <CJK>
0xE74A	0x824E	# <CJK>
0xE74B	0x8251	# <CJK>
0xE74C	0x8524	# <CJK>
0xE74D	0x853B	# <CJK>
0xE74E	0x850F	# <CJK>
0xE74F	0x8500	# <CJK>
0xE750	0x8529	# <CJK>
0xE751	0x850E	# <CJK>
0xE752	0x8509	# <CJK>
0xE753	0x850D	# <CJK>
0xE754	0x851F	# <CJK>
0xE755	0x850A	# <CJK>
0xE756	0x8527	# <CJK>
0xE757	0x851C	# <CJK>
0xE758	0x84FB	# <CJK>
0xE759	0x852B	# <CJK>
0xE75A	0x84FA	# <CJK>
0xE75B	0x8508	# <CJK>
0xE75C	0x850C	# <CJK>
0xE75D	0x84F4	# <CJK>
0xE75E	0x852A	# <CJK>
0xE75F	0x84F2	# <CJK>
0xE760	0x8515	# <CJK>
0xE761	0x84F7	# <CJK>
0xE762	0x84EB	# <CJK>
0xE763	0x84F3	# <CJK>
0xE764	0x84FC	# <CJK>
0xE765	0x8512	# <CJK>
0xE766	0x84EA	# <CJK>
0xE767	0x84E9	# <CJK>
0xE768	0x8516	# <CJK>
0xE769	0x84FE	# <CJK>
0xE76A	0x8528	# <CJK>
0xE76B	0x851D	# <CJK>
0xE76C	0x852E	# <CJK>
0xE76D	0x8502	# <CJK>
0xE76E	0x84FD	# <CJK>
0xE76F	0x851E	# <CJK>
0xE770	0x84F6	# <CJK>
0xE771	0x8531	# <CJK>
0xE772	0x8526	# <CJK>
0xE773	0x84E7	# <CJK>
0xE774	0x84E8	# <CJK>
0xE775	0x84F0	# <CJK>
0xE776	0x84EF	# <CJK>
0xE777	0x84F9	# <CJK>
0xE778	0x8518	# <CJK>
0xE779	0x8520	# <CJK>
0xE77A	0x8530	# <CJK>
0xE77B	0x850B	# <CJK>
0xE77C	0x8519	# <CJK>
0xE77D	0x852F	# <CJK>
0xE77E	0x8662	# <CJK>
0xE7A1	0x8756	# <CJK>
0xE7A2	0x8763	# <CJK>
0xE7A3	0x8764	# <CJK>
0xE7A4	0x8777	# <CJK>
0xE7A5	0x87E1	# <CJK>
0xE7A6	0x8773	# <CJK>
0xE7A7	0x8758	# <CJK>
0xE7A8	0x8754	# <CJK>
0xE7A9	0x875B	# <CJK>
0xE7AA	0x8752	# <CJK>
0xE7AB	0x8761	# <CJK>
0xE7AC	0x875A	# <CJK>
0xE7AD	0x8751	# <CJK>
0xE7AE	0x875E	# <CJK>
0xE7AF	0x876D	# <CJK>
0xE7B0	0x876A	# <CJK>
0xE7B1	0x8750	# <CJK>
0xE7B2	0x874E	# <CJK>
0xE7B3	0x875F	# <CJK>
0xE7B4	0x875D	# <CJK>
0xE7B5	0x876F	# <CJK>
0xE7B6	0x876C	# <CJK>
0xE7B7	0x877A	# <CJK>
0xE7B8	0x876E	# <CJK>
0xE7B9	0x875C	# <CJK>
0xE7BA	0x8765	# <CJK>
0xE7BB	0x874F	# <CJK>
0xE7BC	0x877B	# <CJK>
0xE7BD	0x8775	# <CJK>
0xE7BE	0x8762	# <CJK>
0xE7BF	0x8767	# <CJK>
0xE7C0	0x8769	# <CJK>
0xE7C1	0x885A	# <CJK>
0xE7C2	0x8905	# <CJK>
0xE7C3	0x890C	# <CJK>
0xE7C4	0x8914	# <CJK>
0xE7C5	0x890B	# <CJK>
0xE7C6	0x8917	# <CJK>
0xE7C7	0x8918	# <CJK>
0xE7C8	0x8919	# <CJK>
0xE7C9	0x8906	# <CJK>
0xE7CA	0x8916	# <CJK>
0xE7CB	0x8911	# <CJK>
0xE7CC	0x890E	# <CJK>
0xE7CD	0x8909	# <CJK>
0xE7CE	0x89A2	# <CJK>
0xE7CF	0x89A4	# <CJK>
0xE7D0	0x89A3	# <CJK>
0xE7D1	0x89ED	# <CJK>
0xE7D2	0x89F0	# <CJK>
0xE7D3	0x89EC	# <CJK>
0xE7D4	0x8ACF	# <CJK>
0xE7D5	0x8AC6	# <CJK>
0xE7D6	0x8AB8	# <CJK>
0xE7D7	0x8AD3	# <CJK>
0xE7D8	0x8AD1	# <CJK>
0xE7D9	0x8AD4	# <CJK>
0xE7DA	0x8AD5	# <CJK>
0xE7DB	0x8ABB	# <CJK>
0xE7DC	0x8AD7	# <CJK>
0xE7DD	0x8ABE	# <CJK>
0xE7DE	0x8AC0	# <CJK>
0xE7DF	0x8AC5	# <CJK>
0xE7E0	0x8AD8	# <CJK>
0xE7E1	0x8AC3	# <CJK>
0xE7E2	0x8ABA	# <CJK>
0xE7E3	0x8ABD	# <CJK>
0xE7E4	0x8AD9	# <CJK>
0xE7E5	0x8C3E	# <CJK>
0xE7E6	0x8C4D	# <CJK>
0xE7E7	0x8C8F	# <CJK>
0xE7E8	0x8CE5	# <CJK>
0xE7E9	0x8CDF	# <CJK>
0xE7EA	0x8CD9	# <CJK>
0xE7EB	0x8CE8	# <CJK>
0xE7EC	0x8CDA	# <CJK>
0xE7ED	0x8CDD	# <CJK>
0xE7EE	0x8CE7	# <CJK>
0xE7EF	0x8DA0	# <CJK>
0xE7F0	0x8D9C	# <CJK>
0xE7F1	0x8DA1	# <CJK>
0xE7F2	0x8D9B	# <CJK>
0xE7F3	0x8E20	# <CJK>
0xE7F4	0x8E23	# <CJK>
0xE7F5	0x8E25	# <CJK>
0xE7F6	0x8E24	# <CJK>
0xE7F7	0x8E2E	# <CJK>
0xE7F8	0x8E15	# <CJK>
0xE7F9	0x8E1B	# <CJK>
0xE7FA	0x8E16	# <CJK>
0xE7FB	0x8E11	# <CJK>
0xE7FC	0x8E19	# <CJK>
0xE7FD	0x8E26	# <CJK>
0xE7FE	0x8E27	# <CJK>
0xE840	0x8E14	# <CJK>
0xE841	0x8E12	# <CJK>
0xE842	0x8E18	# <CJK>
0xE843	0x8E13	# <CJK>
0xE844	0x8E1C	# <CJK>
0xE845	0x8E17	# <CJK>
0xE846	0x8E1A	# <CJK>
0xE847	0x8F2C	# <CJK>
0xE848	0x8F24	# <CJK>
0xE849	0x8F18	# <CJK>
0xE84A	0x8F1A	# <CJK>
0xE84B	0x8F20	# <CJK>
0xE84C	0x8F23	# <CJK>
0xE84D	0x8F16	# <CJK>
0xE84E	0x8F17	# <CJK>
0xE84F	0x9073	# <CJK>
0xE850	0x9070	# <CJK>
0xE851	0x906F	# <CJK>
0xE852	0x9067	# <CJK>
0xE853	0x906B	# <CJK>
0xE854	0x912F	# <CJK>
0xE855	0x912B	# <CJK>
0xE856	0x9129	# <CJK>
0xE857	0x912A	# <CJK>
0xE858	0x9132	# <CJK>
0xE859	0x9126	# <CJK>
0xE85A	0x912E	# <CJK>
0xE85B	0x9185	# <CJK>
0xE85C	0x9186	# <CJK>
0xE85D	0x918A	# <CJK>
0xE85E	0x9181	# <CJK>
0xE85F	0x9182	# <CJK>
0xE860	0x9184	# <CJK>
0xE861	0x9180	# <CJK>
0xE862	0x92D0	# <CJK>
0xE863	0x92C3	# <CJK>
0xE864	0x92C4	# <CJK>
0xE865	0x92C0	# <CJK>
0xE866	0x92D9	# <CJK>
0xE867	0x92B6	# <CJK>
0xE868	0x92CF	# <CJK>
0xE869	0x92F1	# <CJK>
0xE86A	0x92DF	# <CJK>
0xE86B	0x92D8	# <CJK>
0xE86C	0x92E9	# <CJK>
0xE86D	0x92D7	# <CJK>
0xE86E	0x92DD	# <CJK>
0xE86F	0x92CC	# <CJK>
0xE870	0x92EF	# <CJK>
0xE871	0x92C2	# <CJK>
0xE872	0x92E8	# <CJK>
0xE873	0x92CA	# <CJK>
0xE874	0x92C8	# <CJK>
0xE875	0x92CE	# <CJK>
0xE876	0x92E6	# <CJK>
0xE877	0x92CD	# <CJK>
0xE878	0x92D5	# <CJK>
0xE879	0x92C9	# <CJK>
0xE87A	0x92E0	# <CJK>
0xE87B	0x92DE	# <CJK>
0xE87C	0x92E7	# <CJK>
0xE87D	0x92D1	# <CJK>
0xE87E	0x92D3	# <CJK>
0xE8A1	0x92B5	# <CJK>
0xE8A2	0x92E1	# <CJK>
0xE8A3	0x92C6	# <CJK>
0xE8A4	0x92B4	# <CJK>
0xE8A5	0x957C	# <CJK>
0xE8A6	0x95AC	# <CJK>
0xE8A7	0x95AB	# <CJK>
0xE8A8	0x95AE	# <CJK>
0xE8A9	0x95B0	# <CJK>
0xE8AA	0x96A4	# <CJK>
0xE8AB	0x96A2	# <CJK>
0xE8AC	0x96D3	# <CJK>
0xE8AD	0x9705	# <CJK>
0xE8AE	0x9708	# <CJK>
0xE8AF	0x9702	# <CJK>
0xE8B0	0x975A	# <CJK>
0xE8B1	0x978A	# <CJK>
0xE8B2	0x978E	# <CJK>
0xE8B3	0x9788	# <CJK>
0xE8B4	0x97D0	# <CJK>
0xE8B5	0x97CF	# <CJK>
0xE8B6	0x981E	# <CJK>
0xE8B7	0x981D	# <CJK>
0xE8B8	0x9826	# <CJK>
0xE8B9	0x9829	# <CJK>
0xE8BA	0x9828	# <CJK>
0xE8BB	0x9820	# <CJK>
0xE8BC	0x981B	# <CJK>
0xE8BD	0x9827	# <CJK>
0xE8BE	0x98B2	# <CJK>
0xE8BF	0x9908	# <CJK>
0xE8C0	0x98FA	# <CJK>
0xE8C1	0x9911	# <CJK>
0xE8C2	0x9914	# <CJK>
0xE8C3	0x9916	# <CJK>
0xE8C4	0x9917	# <CJK>
0xE8C5	0x9915	# <CJK>
0xE8C6	0x99DC	# <CJK>
0xE8C7	0x99CD	# <CJK>
0xE8C8	0x99CF	# <CJK>
0xE8C9	0x99D3	# <CJK>
0xE8CA	0x99D4	# <CJK>
0xE8CB	0x99CE	# <CJK>
0xE8CC	0x99C9	# <CJK>
0xE8CD	0x99D6	# <CJK>
0xE8CE	0x99D8	# <CJK>
0xE8CF	0x99CB	# <CJK>
0xE8D0	0x99D7	# <CJK>
0xE8D1	0x99CC	# <CJK>
0xE8D2	0x9AB3	# <CJK>
0xE8D3	0x9AEC	# <CJK>
0xE8D4	0x9AEB	# <CJK>
0xE8D5	0x9AF3	# <CJK>
0xE8D6	0x9AF2	# <CJK>
0xE8D7	0x9AF1	# <CJK>
0xE8D8	0x9B46	# <CJK>
0xE8D9	0x9B43	# <CJK>
0xE8DA	0x9B67	# <CJK>
0xE8DB	0x9B74	# <CJK>
0xE8DC	0x9B71	# <CJK>
0xE8DD	0x9B66	# <CJK>
0xE8DE	0x9B76	# <CJK>
0xE8DF	0x9B75	# <CJK>
0xE8E0	0x9B70	# <CJK>
0xE8E1	0x9B68	# <CJK>
0xE8E2	0x9B64	# <CJK>
0xE8E3	0x9B6C	# <CJK>
0xE8E4	0x9CFC	# <CJK>
0xE8E5	0x9CFA	# <CJK>
0xE8E6	0x9CFD	# <CJK>
0xE8E7	0x9CFF	# <CJK>
0xE8E8	0x9CF7	# <CJK>
0xE8E9	0x9D07	# <CJK>
0xE8EA	0x9D00	# <CJK>
0xE8EB	0x9CF9	# <CJK>
0xE8EC	0x9CFB	# <CJK>
0xE8ED	0x9D08	# <CJK>
0xE8EE	0x9D05	# <CJK>
0xE8EF	0x9D04	# <CJK>
0xE8F0	0x9E83	# <CJK>
0xE8F1	0x9ED3	# <CJK>
0xE8F2	0x9F0F	# <CJK>
0xE8F3	0x9F10	# <CJK>
0xE8F4	0x511C	# <CJK>
0xE8F5	0x5113	# <CJK>
0xE8F6	0x5117	# <CJK>
0xE8F7	0x511A	# <CJK>
0xE8F8	0x5111	# <CJK>
0xE8F9	0x51DE	# <CJK>
0xE8FA	0x5334	# <CJK>
0xE8FB	0x53E1	# <CJK>
0xE8FC	0x5670	# <CJK>
0xE8FD	0x5660	# <CJK>
0xE8FE	0x566E	# <CJK>
0xE940	0x5673	# <CJK>
0xE941	0x5666	# <CJK>
0xE942	0x5663	# <CJK>
0xE943	0x566D	# <CJK>
0xE944	0x5672	# <CJK>
0xE945	0x565E	# <CJK>
0xE946	0x5677	# <CJK>
0xE947	0x571C	# <CJK>
0xE948	0x571B	# <CJK>
0xE949	0x58C8	# <CJK>
0xE94A	0x58BD	# <CJK>
0xE94B	0x58C9	# <CJK>
0xE94C	0x58BF	# <CJK>
0xE94D	0x58BA	# <CJK>
0xE94E	0x58C2	# <CJK>
0xE94F	0x58BC	# <CJK>
0xE950	0x58C6	# <CJK>
0xE951	0x5B17	# <CJK>
0xE952	0x5B19	# <CJK>
0xE953	0x5B1B	# <CJK>
0xE954	0x5B21	# <CJK>
0xE955	0x5B14	# <CJK>
0xE956	0x5B13	# <CJK>
0xE957	0x5B10	# <CJK>
0xE958	0x5B16	# <CJK>
0xE959	0x5B28	# <CJK>
0xE95A	0x5B1A	# <CJK>
0xE95B	0x5B20	# <CJK>
0xE95C	0x5B1E	# <CJK>
0xE95D	0x5BEF	# <CJK>
0xE95E	0x5DAC	# <CJK>
0xE95F	0x5DB1	# <CJK>
0xE960	0x5DA9	# <CJK>
0xE961	0x5DA7	# <CJK>
0xE962	0x5DB5	# <CJK>
0xE963	0x5DB0	# <CJK>
0xE964	0x5DAE	# <CJK>
0xE965	0x5DAA	# <CJK>
0xE966	0x5DA8	# <CJK>
0xE967	0x5DB2	# <CJK>
0xE968	0x5DAD	# <CJK>
0xE969	0x5DAF	# <CJK>
0xE96A	0x5DB4	# <CJK>
0xE96B	0x5E67	# <CJK>
0xE96C	0x5E68	# <CJK>
0xE96D	0x5E66	# <CJK>
0xE96E	0x5E6F	# <CJK>
0xE96F	0x5EE9	# <CJK>
0xE970	0x5EE7	# <CJK>
0xE971	0x5EE6	# <CJK>
0xE972	0x5EE8	# <CJK>
0xE973	0x5EE5	# <CJK>
0xE974	0x5F4B	# <CJK>
0xE975	0x5FBC	# <CJK>
0xE976	0x619D	# <CJK>
0xE977	0x61A8	# <CJK>
0xE978	0x6196	# <CJK>
0xE979	0x61C5	# <CJK>
0xE97A	0x61B4	# <CJK>
0xE97B	0x61C6	# <CJK>
0xE97C	0x61C1	# <CJK>
0xE97D	0x61CC	# <CJK>
0xE97E	0x61BA	# <CJK>
0xE9A1	0x61BF	# <CJK>
0xE9A2	0x61B8	# <CJK>
0xE9A3	0x618C	# <CJK>
0xE9A4	0x64D7	# <CJK>
0xE9A5	0x64D6	# <CJK>
0xE9A6	0x64D0	# <CJK>
0xE9A7	0x64CF	# <CJK>
0xE9A8	0x64C9	# <CJK>
0xE9A9	0x64BD	# <CJK>
0xE9AA	0x6489	# <CJK>
0xE9AB	0x64C3	# <CJK>
0xE9AC	0x64DB	# <CJK>
0xE9AD	0x64F3	# <CJK>
0xE9AE	0x64D9	# <CJK>
0xE9AF	0x6533	# <CJK>
0xE9B0	0x657F	# <CJK>
0xE9B1	0x657C	# <CJK>
0xE9B2	0x65A2	# <CJK>
0xE9B3	0x66C8	# <CJK>
0xE9B4	0x66BE	# <CJK>
0xE9B5	0x66C0	# <CJK>
0xE9B6	0x66CA	# <CJK>
0xE9B7	0x66CB	# <CJK>
0xE9B8	0x66CF	# <CJK>
0xE9B9	0x66BD	# <CJK>
0xE9BA	0x66BB	# <CJK>
0xE9BB	0x66BA	# <CJK>
0xE9BC	0x66CC	# <CJK>
0xE9BD	0x6723	# <CJK>
0xE9BE	0x6A34	# <CJK>
0xE9BF	0x6A66	# <CJK>
0xE9C0	0x6A49	# <CJK>
0xE9C1	0x6A67	# <CJK>
0xE9C2	0x6A32	# <CJK>
0xE9C3	0x6A68	# <CJK>
0xE9C4	0x6A3E	# <CJK>
0xE9C5	0x6A5D	# <CJK>
0xE9C6	0x6A6D	# <CJK>
0xE9C7	0x6A76	# <CJK>
0xE9C8	0x6A5B	# <CJK>
0xE9C9	0x6A51	# <CJK>
0xE9CA	0x6A28	# <CJK>
0xE9CB	0x6A5A	# <CJK>
0xE9CC	0x6A3B	# <CJK>
0xE9CD	0x6A3F	# <CJK>
0xE9CE	0x6A41	# <CJK>
0xE9CF	0x6A6A	# <CJK>
0xE9D0	0x6A64	# <CJK>
0xE9D1	0x6A50	# <CJK>
0xE9D2	0x6A4F	# <CJK>
0xE9D3	0x6A54	# <CJK>
0xE9D4	0x6A6F	# <CJK>
0xE9D5	0x6A69	# <CJK>
0xE9D6	0x6A60	# <CJK>
0xE9D7	0x6A3C	# <CJK>
0xE9D8	0x6A5E	# <CJK>
0xE9D9	0x6A56	# <CJK>
0xE9DA	0x6A55	# <CJK>
0xE9DB	0x6A4D	# <CJK>
0xE9DC	0x6A4E	# <CJK>
0xE9DD	0x6A46	# <CJK>
0xE9DE	0x6B55	# <CJK>
0xE9DF	0x6B54	# <CJK>
0xE9E0	0x6B56	# <CJK>
0xE9E1	0x6BA7	# <CJK>
0xE9E2	0x6BAA	# <CJK>
0xE9E3	0x6BAB	# <CJK>
0xE9E4	0x6BC8	# <CJK>
0xE9E5	0x6BC7	# <CJK>
0xE9E6	0x6C04	# <CJK>
0xE9E7	0x6C03	# <CJK>
0xE9E8	0x6C06	# <CJK>
0xE9E9	0x6FAD	# <CJK>
0xE9EA	0x6FCB	# <CJK>
0xE9EB	0x6FA3	# <CJK>
0xE9EC	0x6FC7	# <CJK>
0xE9ED	0x6FBC	# <CJK>
0xE9EE	0x6FCE	# <CJK>
0xE9EF	0x6FC8	# <CJK>
0xE9F0	0x6F5E	# <CJK>
0xE9F1	0x6FC4	# <CJK>
0xE9F2	0x6FBD	# <CJK>
0xE9F3	0x6F9E	# <CJK>
0xE9F4	0x6FCA	# <CJK>
0xE9F5	0x6FA8	# <CJK>
0xE9F6	0x7004	# <CJK>
0xE9F7	0x6FA5	# <CJK>
0xE9F8	0x6FAE	# <CJK>
0xE9F9	0x6FBA	# <CJK>
0xE9FA	0x6FAC	# <CJK>
0xE9FB	0x6FAA	# <CJK>
0xE9FC	0x6FCF	# <CJK>
0xE9FD	0x6FBF	# <CJK>
0xE9FE	0x6FB8	# <CJK>
0xEA40	0x6FA2	# <CJK>
0xEA41	0x6FC9	# <CJK>
0xEA42	0x6FAB	# <CJK>
0xEA43	0x6FCD	# <CJK>
0xEA44	0x6FAF	# <CJK>
0xEA45	0x6FB2	# <CJK>
0xEA46	0x6FB0	# <CJK>
0xEA47	0x71C5	# <CJK>
0xEA48	0x71C2	# <CJK>
0xEA49	0x71BF	# <CJK>
0xEA4A	0x71B8	# <CJK>
0xEA4B	0x71D6	# <CJK>
0xEA4C	0x71C0	# <CJK>
0xEA4D	0x71C1	# <CJK>
0xEA4E	0x71CB	# <CJK>
0xEA4F	0x71D4	# <CJK>
0xEA50	0x71CA	# <CJK>
0xEA51	0x71C7	# <CJK>
0xEA52	0x71CF	# <CJK>
0xEA53	0x71BD	# <CJK>
0xEA54	0x71D8	# <CJK>
0xEA55	0x71BC	# <CJK>
0xEA56	0x71C6	# <CJK>
0xEA57	0x71DA	# <CJK>
0xEA58	0x71DB	# <CJK>
0xEA59	0x729D	# <CJK>
0xEA5A	0x729E	# <CJK>
0xEA5B	0x7369	# <CJK>
0xEA5C	0x7366	# <CJK>
0xEA5D	0x7367	# <CJK>
0xEA5E	0x736C	# <CJK>
0xEA5F	0x7365	# <CJK>
0xEA60	0x736B	# <CJK>
0xEA61	0x736A	# <CJK>
0xEA62	0x747F	# <CJK>
0xEA63	0x749A	# <CJK>
0xEA64	0x74A0	# <CJK>
0xEA65	0x7494	# <CJK>
0xEA66	0x7492	# <CJK>
0xEA67	0x7495	# <CJK>
0xEA68	0x74A1	# <CJK>
0xEA69	0x750B	# <CJK>
0xEA6A	0x7580	# <CJK>
0xEA6B	0x762F	# <CJK>
0xEA6C	0x762D	# <CJK>
0xEA6D	0x7631	# <CJK>
0xEA6E	0x763D	# <CJK>
0xEA6F	0x7633	# <CJK>
0xEA70	0x763C	# <CJK>
0xEA71	0x7635	# <CJK>
0xEA72	0x7632	# <CJK>
0xEA73	0x7630	# <CJK>
0xEA74	0x76BB	# <CJK>
0xEA75	0x76E6	# <CJK>
0xEA76	0x779A	# <CJK>
0xEA77	0x779D	# <CJK>
0xEA78	0x77A1	# <CJK>
0xEA79	0x779C	# <CJK>
0xEA7A	0x779B	# <CJK>
0xEA7B	0x77A2	# <CJK>
0xEA7C	0x77A3	# <CJK>
0xEA7D	0x7795	# <CJK>
0xEA7E	0x7799	# <CJK>
0xEAA1	0x7797	# <CJK>
0xEAA2	0x78DD	# <CJK>
0xEAA3	0x78E9	# <CJK>
0xEAA4	0x78E5	# <CJK>
0xEAA5	0x78EA	# <CJK>
0xEAA6	0x78DE	# <CJK>
0xEAA7	0x78E3	# <CJK>
0xEAA8	0x78DB	# <CJK>
0xEAA9	0x78E1	# <CJK>
0xEAAA	0x78E2	# <CJK>
0xEAAB	0x78ED	# <CJK>
0xEAAC	0x78DF	# <CJK>
0xEAAD	0x78E0	# <CJK>
0xEAAE	0x79A4	# <CJK>
0xEAAF	0x7A44	# <CJK>
0xEAB0	0x7A48	# <CJK>
0xEAB1	0x7A47	# <CJK>
0xEAB2	0x7AB6	# <CJK>
0xEAB3	0x7AB8	# <CJK>
0xEAB4	0x7AB5	# <CJK>
0xEAB5	0x7AB1	# <CJK>
0xEAB6	0x7AB7	# <CJK>
0xEAB7	0x7BDE	# <CJK>
0xEAB8	0x7BE3	# <CJK>
0xEAB9	0x7BE7	# <CJK>
0xEABA	0x7BDD	# <CJK>
0xEABB	0x7BD5	# <CJK>
0xEABC	0x7BE5	# <CJK>
0xEABD	0x7BDA	# <CJK>
0xEABE	0x7BE8	# <CJK>
0xEABF	0x7BF9	# <CJK>
0xEAC0	0x7BD4	# <CJK>
0xEAC1	0x7BEA	# <CJK>
0xEAC2	0x7BE2	# <CJK>
0xEAC3	0x7BDC	# <CJK>
0xEAC4	0x7BEB	# <CJK>
0xEAC5	0x7BD8	# <CJK>
0xEAC6	0x7BDF	# <CJK>
0xEAC7	0x7CD2	# <CJK>
0xEAC8	0x7CD4	# <CJK>
0xEAC9	0x7CD7	# <CJK>
0xEACA	0x7CD0	# <CJK>
0xEACB	0x7CD1	# <CJK>
0xEACC	0x7E12	# <CJK>
0xEACD	0x7E21	# <CJK>
0xEACE	0x7E17	# <CJK>
0xEACF	0x7E0C	# <CJK>
0xEAD0	0x7E1F	# <CJK>
0xEAD1	0x7E20	# <CJK>
0xEAD2	0x7E13	# <CJK>
0xEAD3	0x7E0E	# <CJK>
0xEAD4	0x7E1C	# <CJK>
0xEAD5	0x7E15	# <CJK>
0xEAD6	0x7E1A	# <CJK>
0xEAD7	0x7E22	# <CJK>
0xEAD8	0x7E0B	# <CJK>
0xEAD9	0x7E0F	# <CJK>
0xEADA	0x7E16	# <CJK>
0xEADB	0x7E0D	# <CJK>
0xEADC	0x7E14	# <CJK>
0xEADD	0x7E25	# <CJK>
0xEADE	0x7E24	# <CJK>
0xEADF	0x7F43	# <CJK>
0xEAE0	0x7F7B	# <CJK>
0xEAE1	0x7F7C	# <CJK>
0xEAE2	0x7F7A	# <CJK>
0xEAE3	0x7FB1	# <CJK>
0xEAE4	0x7FEF	# <CJK>
0xEAE5	0x802A	# <CJK>
0xEAE6	0x8029	# <CJK>
0xEAE7	0x806C	# <CJK>
0xEAE8	0x81B1	# <CJK>
0xEAE9	0x81A6	# <CJK>
0xEAEA	0x81AE	# <CJK>
0xEAEB	0x81B9	# <CJK>
0xEAEC	0x81B5	# <CJK>
0xEAED	0x81AB	# <CJK>
0xEAEE	0x81B0	# <CJK>
0xEAEF	0x81AC	# <CJK>
0xEAF0	0x81B4	# <CJK>
0xEAF1	0x81B2	# <CJK>
0xEAF2	0x81B7	# <CJK>
0xEAF3	0x81A7	# <CJK>
0xEAF4	0x81F2	# <CJK>
0xEAF5	0x8255	# <CJK>
0xEAF6	0x8256	# <CJK>
0xEAF7	0x8257	# <CJK>
0xEAF8	0x8556	# <CJK>
0xEAF9	0x8545	# <CJK>
0xEAFA	0x856B	# <CJK>
0xEAFB	0x854D	# <CJK>
0xEAFC	0x8553	# <CJK>
0xEAFD	0x8561	# <CJK>
0xEAFE	0x8558	# <CJK>
0xEB40	0x8540	# <CJK>
0xEB41	0x8546	# <CJK>
0xEB42	0x8564	# <CJK>
0xEB43	0x8541	# <CJK>
0xEB44	0x8562	# <CJK>
0xEB45	0x8544	# <CJK>
0xEB46	0x8551	# <CJK>
0xEB47	0x8547	# <CJK>
0xEB48	0x8563	# <CJK>
0xEB49	0x853E	# <CJK>
0xEB4A	0x855B	# <CJK>
0xEB4B	0x8571	# <CJK>
0xEB4C	0x854E	# <CJK>
0xEB4D	0x856E	# <CJK>
0xEB4E	0x8575	# <CJK>
0xEB4F	0x8555	# <CJK>
0xEB50	0x8567	# <CJK>
0xEB51	0x8560	# <CJK>
0xEB52	0x858C	# <CJK>
0xEB53	0x8566	# <CJK>
0xEB54	0x855D	# <CJK>
0xEB55	0x8554	# <CJK>
0xEB56	0x8565	# <CJK>
0xEB57	0x856C	# <CJK>
0xEB58	0x8663	# <CJK>
0xEB59	0x8665	# <CJK>
0xEB5A	0x8664	# <CJK>
0xEB5B	0x879B	# <CJK>
0xEB5C	0x878F	# <CJK>
0xEB5D	0x8797	# <CJK>
0xEB5E	0x8793	# <CJK>
0xEB5F	0x8792	# <CJK>
0xEB60	0x8788	# <CJK>
0xEB61	0x8781	# <CJK>
0xEB62	0x8796	# <CJK>
0xEB63	0x8798	# <CJK>
0xEB64	0x8779	# <CJK>
0xEB65	0x8787	# <CJK>
0xEB66	0x87A3	# <CJK>
0xEB67	0x8785	# <CJK>
0xEB68	0x8790	# <CJK>
0xEB69	0x8791	# <CJK>
0xEB6A	0x879D	# <CJK>
0xEB6B	0x8784	# <CJK>
0xEB6C	0x8794	# <CJK>
0xEB6D	0x879C	# <CJK>
0xEB6E	0x879A	# <CJK>
0xEB6F	0x8789	# <CJK>
0xEB70	0x891E	# <CJK>
0xEB71	0x8926	# <CJK>
0xEB72	0x8930	# <CJK>
0xEB73	0x892D	# <CJK>
0xEB74	0x892E	# <CJK>
0xEB75	0x8927	# <CJK>
0xEB76	0x8931	# <CJK>
0xEB77	0x8922	# <CJK>
0xEB78	0x8929	# <CJK>
0xEB79	0x8923	# <CJK>
0xEB7A	0x892F	# <CJK>
0xEB7B	0x892C	# <CJK>
0xEB7C	0x891F	# <CJK>
0xEB7D	0x89F1	# <CJK>
0xEB7E	0x8AE0	# <CJK>
0xEBA1	0x8AE2	# <CJK>
0xEBA2	0x8AF2	# <CJK>
0xEBA3	0x8AF4	# <CJK>
0xEBA4	0x8AF5	# <CJK>
0xEBA5	0x8ADD	# <CJK>
0xEBA6	0x8B14	# <CJK>
0xEBA7	0x8AE4	# <CJK>
0xEBA8	0x8ADF	# <CJK>
0xEBA9	0x8AF0	# <CJK>
0xEBAA	0x8AC8	# <CJK>
0xEBAB	0x8ADE	# <CJK>
0xEBAC	0x8AE1	# <CJK>
0xEBAD	0x8AE8	# <CJK>
0xEBAE	0x8AFF	# <CJK>
0xEBAF	0x8AEF	# <CJK>
0xEBB0	0x8AFB	# <CJK>
0xEBB1	0x8C91	# <CJK>
0xEBB2	0x8C92	# <CJK>
0xEBB3	0x8C90	# <CJK>
0xEBB4	0x8CF5	# <CJK>
0xEBB5	0x8CEE	# <CJK>
0xEBB6	0x8CF1	# <CJK>
0xEBB7	0x8CF0	# <CJK>
0xEBB8	0x8CF3	# <CJK>
0xEBB9	0x8D6C	# <CJK>
0xEBBA	0x8D6E	# <CJK>
0xEBBB	0x8DA5	# <CJK>
0xEBBC	0x8DA7	# <CJK>
0xEBBD	0x8E33	# <CJK>
0xEBBE	0x8E3E	# <CJK>
0xEBBF	0x8E38	# <CJK>
0xEBC0	0x8E40	# <CJK>
0xEBC1	0x8E45	# <CJK>
0xEBC2	0x8E36	# <CJK>
0xEBC3	0x8E3C	# <CJK>
0xEBC4	0x8E3D	# <CJK>
0xEBC5	0x8E41	# <CJK>
0xEBC6	0x8E30	# <CJK>
0xEBC7	0x8E3F	# <CJK>
0xEBC8	0x8EBD	# <CJK>
0xEBC9	0x8F36	# <CJK>
0xEBCA	0x8F2E	# <CJK>
0xEBCB	0x8F35	# <CJK>
0xEBCC	0x8F32	# <CJK>
0xEBCD	0x8F39	# <CJK>
0xEBCE	0x8F37	# <CJK>
0xEBCF	0x8F34	# <CJK>
0xEBD0	0x9076	# <CJK>
0xEBD1	0x9079	# <CJK>
0xEBD2	0x907B	# <CJK>
0xEBD3	0x9086	# <CJK>
0xEBD4	0x90FA	# <CJK>
0xEBD5	0x9133	# <CJK>
0xEBD6	0x9135	# <CJK>
0xEBD7	0x9136	# <CJK>
0xEBD8	0x9193	# <CJK>
0xEBD9	0x9190	# <CJK>
0xEBDA	0x9191	# <CJK>
0xEBDB	0x918D	# <CJK>
0xEBDC	0x918F	# <CJK>
0xEBDD	0x9327	# <CJK>
0xEBDE	0x931E	# <CJK>
0xEBDF	0x9308	# <CJK>
0xEBE0	0x931F	# <CJK>
0xEBE1	0x9306	# <CJK>
0xEBE2	0x930F	# <CJK>
0xEBE3	0x937A	# <CJK>
0xEBE4	0x9338	# <CJK>
0xEBE5	0x933C	# <CJK>
0xEBE6	0x931B	# <CJK>
0xEBE7	0x9323	# <CJK>
0xEBE8	0x9312	# <CJK>
0xEBE9	0x9301	# <CJK>
0xEBEA	0x9346	# <CJK>
0xEBEB	0x932D	# <CJK>
0xEBEC	0x930E	# <CJK>
0xEBED	0x930D	# <CJK>
0xEBEE	0x92CB	# <CJK>
0xEBEF	0x931D	# <CJK>
0xEBF0	0x92FA	# <CJK>
0xEBF1	0x9325	# <CJK>
0xEBF2	0x9313	# <CJK>
0xEBF3	0x92F9	# <CJK>
0xEBF4	0x92F7	# <CJK>
0xEBF5	0x9334	# <CJK>
0xEBF6	0x9302	# <CJK>
0xEBF7	0x9324	# <CJK>
0xEBF8	0x92FF	# <CJK>
0xEBF9	0x9329	# <CJK>
0xEBFA	0x9339	# <CJK>
0xEBFB	0x9335	# <CJK>
0xEBFC	0x932A	# <CJK>
0xEBFD	0x9314	# <CJK>
0xEBFE	0x930C	# <CJK>
0xEC40	0x930B	# <CJK>
0xEC41	0x92FE	# <CJK>
0xEC42	0x9309	# <CJK>
0xEC43	0x9300	# <CJK>
0xEC44	0x92FB	# <CJK>
0xEC45	0x9316	# <CJK>
0xEC46	0x95BC	# <CJK>
0xEC47	0x95CD	# <CJK>
0xEC48	0x95BE	# <CJK>
0xEC49	0x95B9	# <CJK>
0xEC4A	0x95BA	# <CJK>
0xEC4B	0x95B6	# <CJK>
0xEC4C	0x95BF	# <CJK>
0xEC4D	0x95B5	# <CJK>
0xEC4E	0x95BD	# <CJK>
0xEC4F	0x96A9	# <CJK>
0xEC50	0x96D4	# <CJK>
0xEC51	0x970B	# <CJK>
0xEC52	0x9712	# <CJK>
0xEC53	0x9710	# <CJK>
0xEC54	0x9799	# <CJK>
0xEC55	0x9797	# <CJK>
0xEC56	0x9794	# <CJK>
0xEC57	0x97F0	# <CJK>
0xEC58	0x97F8	# <CJK>
0xEC59	0x9835	# <CJK>
0xEC5A	0x982F	# <CJK>
0xEC5B	0x9832	# <CJK>
0xEC5C	0x9924	# <CJK>
0xEC5D	0x991F	# <CJK>
0xEC5E	0x9927	# <CJK>
0xEC5F	0x9929	# <CJK>
0xEC60	0x999E	# <CJK>
0xEC61	0x99EE	# <CJK>
0xEC62	0x99EC	# <CJK>
0xEC63	0x99E5	# <CJK>
0xEC64	0x99E4	# <CJK>
0xEC65	0x99F0	# <CJK>
0xEC66	0x99E3	# <CJK>
0xEC67	0x99EA	# <CJK>
0xEC68	0x99E9	# <CJK>
0xEC69	0x99E7	# <CJK>
0xEC6A	0x9AB9	# <CJK>
0xEC6B	0x9ABF	# <CJK>
0xEC6C	0x9AB4	# <CJK>
0xEC6D	0x9ABB	# <CJK>
0xEC6E	0x9AF6	# <CJK>
0xEC6F	0x9AFA	# <CJK>
0xEC70	0x9AF9	# <CJK>
0xEC71	0x9AF7	# <CJK>
0xEC72	0x9B33	# <CJK>
0xEC73	0x9B80	# <CJK>
0xEC74	0x9B85	# <CJK>
0xEC75	0x9B87	# <CJK>
0xEC76	0x9B7C	# <CJK>
0xEC77	0x9B7E	# <CJK>
0xEC78	0x9B7B	# <CJK>
0xEC79	0x9B82	# <CJK>
0xEC7A	0x9B93	# <CJK>
0xEC7B	0x9B92	# <CJK>
0xEC7C	0x9B90	# <CJK>
0xEC7D	0x9B7A	# <CJK>
0xEC7E	0x9B95	# <CJK>
0xECA1	0x9B7D	# <CJK>
0xECA2	0x9B88	# <CJK>
0xECA3	0x9D25	# <CJK>
0xECA4	0x9D17	# <CJK>
0xECA5	0x9D20	# <CJK>
0xECA6	0x9D1E	# <CJK>
0xECA7	0x9D14	# <CJK>
0xECA8	0x9D29	# <CJK>
0xECA9	0x9D1D	# <CJK>
0xECAA	0x9D18	# <CJK>
0xECAB	0x9D22	# <CJK>
0xECAC	0x9D10	# <CJK>
0xECAD	0x9D19	# <CJK>
0xECAE	0x9D1F	# <CJK>
0xECAF	0x9E88	# <CJK>
0xECB0	0x9E86	# <CJK>
0xECB1	0x9E87	# <CJK>
0xECB2	0x9EAE	# <CJK>
0xECB3	0x9EAD	# <CJK>
0xECB4	0x9ED5	# <CJK>
0xECB5	0x9ED6	# <CJK>
0xECB6	0x9EFA	# <CJK>
0xECB7	0x9F12	# <CJK>
0xECB8	0x9F3D	# <CJK>
0xECB9	0x5126	# <CJK>
0xECBA	0x5125	# <CJK>
0xECBB	0x5122	# <CJK>
0xECBC	0x5124	# <CJK>
0xECBD	0x5120	# <CJK>
0xECBE	0x5129	# <CJK>
0xECBF	0x52F4	# <CJK>
0xECC0	0x5693	# <CJK>
0xECC1	0x568C	# <CJK>
0xECC2	0x568D	# <CJK>
0xECC3	0x5686	# <CJK>
0xECC4	0x5684	# <CJK>
0xECC5	0x5683	# <CJK>
0xECC6	0x567E	# <CJK>
0xECC7	0x5682	# <CJK>
0xECC8	0x567F	# <CJK>
0xECC9	0x5681	# <CJK>
0xECCA	0x58D6	# <CJK>
0xECCB	0x58D4	# <CJK>
0xECCC	0x58CF	# <CJK>
0xECCD	0x58D2	# <CJK>
0xECCE	0x5B2D	# <CJK>
0xECCF	0x5B25	# <CJK>
0xECD0	0x5B32	# <CJK>
0xECD1	0x5B23	# <CJK>
0xECD2	0x5B2C	# <CJK>
0xECD3	0x5B27	# <CJK>
0xECD4	0x5B26	# <CJK>
0xECD5	0x5B2F	# <CJK>
0xECD6	0x5B2E	# <CJK>
0xECD7	0x5B7B	# <CJK>
0xECD8	0x5BF1	# <CJK>
0xECD9	0x5BF2	# <CJK>
0xECDA	0x5DB7	# <CJK>
0xECDB	0x5E6C	# <CJK>
0xECDC	0x5E6A	# <CJK>
0xECDD	0x5FBE	# <CJK>
0xECDE	0x5FBB	# <CJK>
0xECDF	0x61C3	# <CJK>
0xECE0	0x61B5	# <CJK>
0xECE1	0x61BC	# <CJK>
0xECE2	0x61E7	# <CJK>
0xECE3	0x61E0	# <CJK>
0xECE4	0x61E5	# <CJK>
0xECE5	0x61E4	# <CJK>
0xECE6	0x61E8	# <CJK>
0xECE7	0x61DE	# <CJK>
0xECE8	0x64EF	# <CJK>
0xECE9	0x64E9	# <CJK>
0xECEA	0x64E3	# <CJK>
0xECEB	0x64EB	# <CJK>
0xECEC	0x64E4	# <CJK>
0xECED	0x64E8	# <CJK>
0xECEE	0x6581	# <CJK>
0xECEF	0x6580	# <CJK>
0xECF0	0x65B6	# <CJK>
0xECF1	0x65DA	# <CJK>
0xECF2	0x66D2	# <CJK>
0xECF3	0x6A8D	# <CJK>
0xECF4	0x6A96	# <CJK>
0xECF5	0x6A81	# <CJK>
0xECF6	0x6AA5	# <CJK>
0xECF7	0x6A89	# <CJK>
0xECF8	0x6A9F	# <CJK>
0xECF9	0x6A9B	# <CJK>
0xECFA	0x6AA1	# <CJK>
0xECFB	0x6A9E	# <CJK>
0xECFC	0x6A87	# <CJK>
0xECFD	0x6A93	# <CJK>
0xECFE	0x6A8E	# <CJK>
0xED40	0x6A95	# <CJK>
0xED41	0x6A83	# <CJK>
0xED42	0x6AA8	# <CJK>
0xED43	0x6AA4	# <CJK>
0xED44	0x6A91	# <CJK>
0xED45	0x6A7F	# <CJK>
0xED46	0x6AA6	# <CJK>
0xED47	0x6A9A	# <CJK>
0xED48	0x6A85	# <CJK>
0xED49	0x6A8C	# <CJK>
0xED4A	0x6A92	# <CJK>
0xED4B	0x6B5B	# <CJK>
0xED4C	0x6BAD	# <CJK>
0xED4D	0x6C09	# <CJK>
0xED4E	0x6FCC	# <CJK>
0xED4F	0x6FA9	# <CJK>
0xED50	0x6FF4	# <CJK>
0xED51	0x6FD4	# <CJK>
0xED52	0x6FE3	# <CJK>
0xED53	0x6FDC	# <CJK>
0xED54	0x6FED	# <CJK>
0xED55	0x6FE7	# <CJK>
0xED56	0x6FE6	# <CJK>
0xED57	0x6FDE	# <CJK>
0xED58	0x6FF2	# <CJK>
0xED59	0x6FDD	# <CJK>
0xED5A	0x6FE2	# <CJK>
0xED5B	0x6FE8	# <CJK>
0xED5C	0x71E1	# <CJK>
0xED5D	0x71F1	# <CJK>
0xED5E	0x71E8	# <CJK>
0xED5F	0x71F2	# <CJK>
0xED60	0x71E4	# <CJK>
0xED61	0x71F0	# <CJK>
0xED62	0x71E2	# <CJK>
0xED63	0x7373	# <CJK>
0xED64	0x736E	# <CJK>
0xED65	0x736F	# <CJK>
0xED66	0x7497	# <CJK>
0xED67	0x74B2	# <CJK>
0xED68	0x74AB	# <CJK>
0xED69	0x7490	# <CJK>
0xED6A	0x74AA	# <CJK>
0xED6B	0x74AD	# <CJK>
0xED6C	0x74B1	# <CJK>
0xED6D	0x74A5	# <CJK>
0xED6E	0x74AF	# <CJK>
0xED6F	0x7510	# <CJK>
0xED70	0x7511	# <CJK>
0xED71	0x7512	# <CJK>
0xED72	0x750F	# <CJK>
0xED73	0x7584	# <CJK>
0xED74	0x7643	# <CJK>
0xED75	0x7648	# <CJK>
0xED76	0x7649	# <CJK>
0xED77	0x7647	# <CJK>
0xED78	0x76A4	# <CJK>
0xED79	0x76E9	# <CJK>
0xED7A	0x77B5	# <CJK>
0xED7B	0x77AB	# <CJK>
0xED7C	0x77B2	# <CJK>
0xED7D	0x77B7	# <CJK>
0xED7E	0x77B6	# <CJK>
0xEDA1	0x77B4	# <CJK>
0xEDA2	0x77B1	# <CJK>
0xEDA3	0x77A8	# <CJK>
0xEDA4	0x77F0	# <CJK>
0xEDA5	0x78F3	# <CJK>
0xEDA6	0x78FD	# <CJK>
0xEDA7	0x7902	# <CJK>
0xEDA8	0x78FB	# <CJK>
0xEDA9	0x78FC	# <CJK>
0xEDAA	0x78F2	# <CJK>
0xEDAB	0x7905	# <CJK>
0xEDAC	0x78F9	# <CJK>
0xEDAD	0x78FE	# <CJK>
0xEDAE	0x7904	# <CJK>
0xEDAF	0x79AB	# <CJK>
0xEDB0	0x79A8	# <CJK>
0xEDB1	0x7A5C	# <CJK>
0xEDB2	0x7A5B	# <CJK>
0xEDB3	0x7A56	# <CJK>
0xEDB4	0x7A58	# <CJK>
0xEDB5	0x7A54	# <CJK>
0xEDB6	0x7A5A	# <CJK>
0xEDB7	0x7ABE	# <CJK>
0xEDB8	0x7AC0	# <CJK>
0xEDB9	0x7AC1	# <CJK>
0xEDBA	0x7C05	# <CJK>
0xEDBB	0x7C0F	# <CJK>
0xEDBC	0x7BF2	# <CJK>
0xEDBD	0x7C00	# <CJK>
0xEDBE	0x7BFF	# <CJK>
0xEDBF	0x7BFB	# <CJK>
0xEDC0	0x7C0E	# <CJK>
0xEDC1	0x7BF4	# <CJK>
0xEDC2	0x7C0B	# <CJK>
0xEDC3	0x7BF3	# <CJK>
0xEDC4	0x7C02	# <CJK>
0xEDC5	0x7C09	# <CJK>
0xEDC6	0x7C03	# <CJK>
0xEDC7	0x7C01	# <CJK>
0xEDC8	0x7BF8	# <CJK>
0xEDC9	0x7BFD	# <CJK>
0xEDCA	0x7C06	# <CJK>
0xEDCB	0x7BF0	# <CJK>
0xEDCC	0x7BF1	# <CJK>
0xEDCD	0x7C10	# <CJK>
0xEDCE	0x7C0A	# <CJK>
0xEDCF	0x7CE8	# <CJK>
0xEDD0	0x7E2D	# <CJK>
0xEDD1	0x7E3C	# <CJK>
0xEDD2	0x7E42	# <CJK>
0xEDD3	0x7E33	# <CJK>
0xEDD4	0x9848	# <CJK>
0xEDD5	0x7E38	# <CJK>
0xEDD6	0x7E2A	# <CJK>
0xEDD7	0x7E49	# <CJK>
0xEDD8	0x7E40	# <CJK>
0xEDD9	0x7E47	# <CJK>
0xEDDA	0x7E29	# <CJK>
0xEDDB	0x7E4C	# <CJK>
0xEDDC	0x7E30	# <CJK>
0xEDDD	0x7E3B	# <CJK>
0xEDDE	0x7E36	# <CJK>
0xEDDF	0x7E44	# <CJK>
0xEDE0	0x7E3A	# <CJK>
0xEDE1	0x7F45	# <CJK>
0xEDE2	0x7F7F	# <CJK>
0xEDE3	0x7F7E	# <CJK>
0xEDE4	0x7F7D	# <CJK>
0xEDE5	0x7FF4	# <CJK>
0xEDE6	0x7FF2	# <CJK>
0xEDE7	0x802C	# <CJK>
0xEDE8	0x81BB	# <CJK>
0xEDE9	0x81C4	# <CJK>
0xEDEA	0x81CC	# <CJK>
0xEDEB	0x81CA	# <CJK>
0xEDEC	0x81C5	# <CJK>
0xEDED	0x81C7	# <CJK>
0xEDEE	0x81BC	# <CJK>
0xEDEF	0x81E9	# <CJK>
0xEDF0	0x825B	# <CJK>
0xEDF1	0x825A	# <CJK>
0xEDF2	0x825C	# <CJK>
0xEDF3	0x8583	# <CJK>
0xEDF4	0x8580	# <CJK>
0xEDF5	0x858F	# <CJK>
0xEDF6	0x85A7	# <CJK>
0xEDF7	0x8595	# <CJK>
0xEDF8	0x85A0	# <CJK>
0xEDF9	0x858B	# <CJK>
0xEDFA	0x85A3	# <CJK>
0xEDFB	0x857B	# <CJK>
0xEDFC	0x85A4	# <CJK>
0xEDFD	0x859A	# <CJK>
0xEDFE	0x859E	# <CJK>
0xEE40	0x8577	# <CJK>
0xEE41	0x857C	# <CJK>
0xEE42	0x8589	# <CJK>
0xEE43	0x85A1	# <CJK>
0xEE44	0x857A	# <CJK>
0xEE45	0x8578	# <CJK>
0xEE46	0x8557	# <CJK>
0xEE47	0x858E	# <CJK>
0xEE48	0x8596	# <CJK>
0xEE49	0x8586	# <CJK>
0xEE4A	0x858D	# <CJK>
0xEE4B	0x8599	# <CJK>
0xEE4C	0x859D	# <CJK>
0xEE4D	0x8581	# <CJK>
0xEE4E	0x85A2	# <CJK>
0xEE4F	0x8582	# <CJK>
0xEE50	0x8588	# <CJK>
0xEE51	0x8585	# <CJK>
0xEE52	0x8579	# <CJK>
0xEE53	0x8576	# <CJK>
0xEE54	0x8598	# <CJK>
0xEE55	0x8590	# <CJK>
0xEE56	0x859F	# <CJK>
0xEE57	0x8668	# <CJK>
0xEE58	0x87BE	# <CJK>
0xEE59	0x87AA	# <CJK>
0xEE5A	0x87AD	# <CJK>
0xEE5B	0x87C5	# <CJK>
0xEE5C	0x87B0	# <CJK>
0xEE5D	0x87AC	# <CJK>
0xEE5E	0x87B9	# <CJK>
0xEE5F	0x87B5	# <CJK>
0xEE60	0x87BC	# <CJK>
0xEE61	0x87AE	# <CJK>
0xEE62	0x87C9	# <CJK>
0xEE63	0x87C3	# <CJK>
0xEE64	0x87C2	# <CJK>
0xEE65	0x87CC	# <CJK>
0xEE66	0x87B7	# <CJK>
0xEE67	0x87AF	# <CJK>
0xEE68	0x87C4	# <CJK>
0xEE69	0x87CA	# <CJK>
0xEE6A	0x87B4	# <CJK>
0xEE6B	0x87B6	# <CJK>
0xEE6C	0x87BF	# <CJK>
0xEE6D	0x87B8	# <CJK>
0xEE6E	0x87BD	# <CJK>
0xEE6F	0x87DE	# <CJK>
0xEE70	0x87B2	# <CJK>
0xEE71	0x8935	# <CJK>
0xEE72	0x8933	# <CJK>
0xEE73	0x893C	# <CJK>
0xEE74	0x893E	# <CJK>
0xEE75	0x8941	# <CJK>
0xEE76	0x8952	# <CJK>
0xEE77	0x8937	# <CJK>
0xEE78	0x8942	# <CJK>
0xEE79	0x89AD	# <CJK>
0xEE7A	0x89AF	# <CJK>
0xEE7B	0x89AE	# <CJK>
0xEE7C	0x89F2	# <CJK>
0xEE7D	0x89F3	# <CJK>
0xEE7E	0x8B1E	# <CJK>
0xEEA1	0x8B18	# <CJK>
0xEEA2	0x8B16	# <CJK>
0xEEA3	0x8B11	# <CJK>
0xEEA4	0x8B05	# <CJK>
0xEEA5	0x8B0B	# <CJK>
0xEEA6	0x8B22	# <CJK>
0xEEA7	0x8B0F	# <CJK>
0xEEA8	0x8B12	# <CJK>
0xEEA9	0x8B15	# <CJK>
0xEEAA	0x8B07	# <CJK>
0xEEAB	0x8B0D	# <CJK>
0xEEAC	0x8B08	# <CJK>
0xEEAD	0x8B06	# <CJK>
0xEEAE	0x8B1C	# <CJK>
0xEEAF	0x8B13	# <CJK>
0xEEB0	0x8B1A	# <CJK>
0xEEB1	0x8C4F	# <CJK>
0xEEB2	0x8C70	# <CJK>
0xEEB3	0x8C72	# <CJK>
0xEEB4	0x8C71	# <CJK>
0xEEB5	0x8C6F	# <CJK>
0xEEB6	0x8C95	# <CJK>
0xEEB7	0x8C94	# <CJK>
0xEEB8	0x8CF9	# <CJK>
0xEEB9	0x8D6F	# <CJK>
0xEEBA	0x8E4E	# <CJK>
0xEEBB	0x8E4D	# <CJK>
0xEEBC	0x8E53	# <CJK>
0xEEBD	0x8E50	# <CJK>
0xEEBE	0x8E4C	# <CJK>
0xEEBF	0x8E47	# <CJK>
0xEEC0	0x8F43	# <CJK>
0xEEC1	0x8F40	# <CJK>
0xEEC2	0x9085	# <CJK>
0xEEC3	0x907E	# <CJK>
0xEEC4	0x9138	# <CJK>
0xEEC5	0x919A	# <CJK>
0xEEC6	0x91A2	# <CJK>
0xEEC7	0x919B	# <CJK>
0xEEC8	0x9199	# <CJK>
0xEEC9	0x919F	# <CJK>
0xEECA	0x91A1	# <CJK>
0xEECB	0x919D	# <CJK>
0xEECC	0x91A0	# <CJK>
0xEECD	0x93A1	# <CJK>
0xEECE	0x9383	# <CJK>
0xEECF	0x93AF	# <CJK>
0xEED0	0x9364	# <CJK>
0xEED1	0x9356	# <CJK>
0xEED2	0x9347	# <CJK>
0xEED3	0x937C	# <CJK>
0xEED4	0x9358	# <CJK>
0xEED5	0x935C	# <CJK>
0xEED6	0x9376	# <CJK>
0xEED7	0x9349	# <CJK>
0xEED8	0x9350	# <CJK>
0xEED9	0x9351	# <CJK>
0xEEDA	0x9360	# <CJK>
0xEEDB	0x936D	# <CJK>
0xEEDC	0x938F	# <CJK>
0xEEDD	0x934C	# <CJK>
0xEEDE	0x936A	# <CJK>
0xEEDF	0x9379	# <CJK>
0xEEE0	0x9357	# <CJK>
0xEEE1	0x9355	# <CJK>
0xEEE2	0x9352	# <CJK>
0xEEE3	0x934F	# <CJK>
0xEEE4	0x9371	# <CJK>
0xEEE5	0x9377	# <CJK>
0xEEE6	0x937B	# <CJK>
0xEEE7	0x9361	# <CJK>
0xEEE8	0x935E	# <CJK>
0xEEE9	0x9363	# <CJK>
0xEEEA	0x9367	# <CJK>
0xEEEB	0x9380	# <CJK>
0xEEEC	0x934E	# <CJK>
0xEEED	0x9359	# <CJK>
0xEEEE	0x95C7	# <CJK>
0xEEEF	0x95C0	# <CJK>
0xEEF0	0x95C9	# <CJK>
0xEEF1	0x95C3	# <CJK>
0xEEF2	0x95C5	# <CJK>
0xEEF3	0x95B7	# <CJK>
0xEEF4	0x96AE	# <CJK>
0xEEF5	0x96B0	# <CJK>
0xEEF6	0x96AC	# <CJK>
0xEEF7	0x9720	# <CJK>
0xEEF8	0x971F	# <CJK>
0xEEF9	0x9718	# <CJK>
0xEEFA	0x971D	# <CJK>
0xEEFB	0x9719	# <CJK>
0xEEFC	0x979A	# <CJK>
0xEEFD	0x97A1	# <CJK>
0xEEFE	0x979C	# <CJK>
0xEF40	0x979E	# <CJK>
0xEF41	0x979D	# <CJK>
0xEF42	0x97D5	# <CJK>
0xEF43	0x97D4	# <CJK>
0xEF44	0x97F1	# <CJK>
0xEF45	0x9841	# <CJK>
0xEF46	0x9844	# <CJK>
0xEF47	0x984A	# <CJK>
0xEF48	0x9849	# <CJK>
0xEF49	0x9845	# <CJK>
0xEF4A	0x9843	# <CJK>
0xEF4B	0x9925	# <CJK>
0xEF4C	0x992B	# <CJK>
0xEF4D	0x992C	# <CJK>
0xEF4E	0x992A	# <CJK>
0xEF4F	0x9933	# <CJK>
0xEF50	0x9932	# <CJK>
0xEF51	0x992F	# <CJK>
0xEF52	0x992D	# <CJK>
0xEF53	0x9931	# <CJK>
0xEF54	0x9930	# <CJK>
0xEF55	0x9998	# <CJK>
0xEF56	0x99A3	# <CJK>
0xEF57	0x99A1	# <CJK>
0xEF58	0x9A02	# <CJK>
0xEF59	0x99FA	# <CJK>
0xEF5A	0x99F4	# <CJK>
0xEF5B	0x99F7	# <CJK>
0xEF5C	0x99F9	# <CJK>
0xEF5D	0x99F8	# <CJK>
0xEF5E	0x99F6	# <CJK>
0xEF5F	0x99FB	# <CJK>
0xEF60	0x99FD	# <CJK>
0xEF61	0x99FE	# <CJK>
0xEF62	0x99FC	# <CJK>
0xEF63	0x9A03	# <CJK>
0xEF64	0x9ABE	# <CJK>
0xEF65	0x9AFE	# <CJK>
0xEF66	0x9AFD	# <CJK>
0xEF67	0x9B01	# <CJK>
0xEF68	0x9AFC	# <CJK>
0xEF69	0x9B48	# <CJK>
0xEF6A	0x9B9A	# <CJK>
0xEF6B	0x9BA8	# <CJK>
0xEF6C	0x9B9E	# <CJK>
0xEF6D	0x9B9B	# <CJK>
0xEF6E	0x9BA6	# <CJK>
0xEF6F	0x9BA1	# <CJK>
0xEF70	0x9BA5	# <CJK>
0xEF71	0x9BA4	# <CJK>
0xEF72	0x9B86	# <CJK>
0xEF73	0x9BA2	# <CJK>
0xEF74	0x9BA0	# <CJK>
0xEF75	0x9BAF	# <CJK>
0xEF76	0x9D33	# <CJK>
0xEF77	0x9D41	# <CJK>
0xEF78	0x9D67	# <CJK>
0xEF79	0x9D36	# <CJK>
0xEF7A	0x9D2E	# <CJK>
0xEF7B	0x9D2F	# <CJK>
0xEF7C	0x9D31	# <CJK>
0xEF7D	0x9D38	# <CJK>
0xEF7E	0x9D30	# <CJK>
0xEFA1	0x9D45	# <CJK>
0xEFA2	0x9D42	# <CJK>
0xEFA3	0x9D43	# <CJK>
0xEFA4	0x9D3E	# <CJK>
0xEFA5	0x9D37	# <CJK>
0xEFA6	0x9D40	# <CJK>
0xEFA7	0x9D3D	# <CJK>
0xEFA8	0x7FF5	# <CJK>
0xEFA9	0x9D2D	# <CJK>
0xEFAA	0x9E8A	# <CJK>
0xEFAB	0x9E89	# <CJK>
0xEFAC	0x9E8D	# <CJK>
0xEFAD	0x9EB0	# <CJK>
0xEFAE	0x9EC8	# <CJK>
0xEFAF	0x9EDA	# <CJK>
0xEFB0	0x9EFB	# <CJK>
0xEFB1	0x9EFF	# <CJK>
0xEFB2	0x9F24	# <CJK>
0xEFB3	0x9F23	# <CJK>
0xEFB4	0x9F22	# <CJK>
0xEFB5	0x9F54	# <CJK>
0xEFB6	0x9FA0	# <CJK>
0xEFB7	0x5131	# <CJK>
0xEFB8	0x512D	# <CJK>
0xEFB9	0x512E	# <CJK>
0xEFBA	0x5698	# <CJK>
0xEFBB	0x569C	# <CJK>
0xEFBC	0x5697	# <CJK>
0xEFBD	0x569A	# <CJK>
0xEFBE	0x569D	# <CJK>
0xEFBF	0x5699	# <CJK>
0xEFC0	0x5970	# <CJK>
0xEFC1	0x5B3C	# <CJK>
0xEFC2	0x5C69	# <CJK>
0xEFC3	0x5C6A	# <CJK>
0xEFC4	0x5DC0	# <CJK>
0xEFC5	0x5E6D	# <CJK>
0xEFC6	0x5E6E	# <CJK>
0xEFC7	0x61D8	# <CJK>
0xEFC8	0x61DF	# <CJK>
0xEFC9	0x61ED	# <CJK>
0xEFCA	0x61EE	# <CJK>
0xEFCB	0x61F1	# <CJK>
0xEFCC	0x61EA	# <CJK>
0xEFCD	0x61F0	# <CJK>
0xEFCE	0x61EB	# <CJK>
0xEFCF	0x61D6	# <CJK>
0xEFD0	0x61E9	# <CJK>
0xEFD1	0x64FF	# <CJK>
0xEFD2	0x6504	# <CJK>
0xEFD3	0x64FD	# <CJK>
0xEFD4	0x64F8	# <CJK>
0xEFD5	0x6501	# <CJK>
0xEFD6	0x6503	# <CJK>
0xEFD7	0x64FC	# <CJK>
0xEFD8	0x6594	# <CJK>
0xEFD9	0x65DB	# <CJK>
0xEFDA	0x66DA	# <CJK>
0xEFDB	0x66DB	# <CJK>
0xEFDC	0x66D8	# <CJK>
0xEFDD	0x6AC5	# <CJK>
0xEFDE	0x6AB9	# <CJK>
0xEFDF	0x6ABD	# <CJK>
0xEFE0	0x6AE1	# <CJK>
0xEFE1	0x6AC6	# <CJK>
0xEFE2	0x6ABA	# <CJK>
0xEFE3	0x6AB6	# <CJK>
0xEFE4	0x6AB7	# <CJK>
0xEFE5	0x6AC7	# <CJK>
0xEFE6	0x6AB4	# <CJK>
0xEFE7	0x6AAD	# <CJK>
0xEFE8	0x6B5E	# <CJK>
0xEFE9	0x6BC9	# <CJK>
0xEFEA	0x6C0B	# <CJK>
0xEFEB	0x7007	# <CJK>
0xEFEC	0x700C	# <CJK>
0xEFED	0x700D	# <CJK>
0xEFEE	0x7001	# <CJK>
0xEFEF	0x7005	# <CJK>
0xEFF0	0x7014	# <CJK>
0xEFF1	0x700E	# <CJK>
0xEFF2	0x6FFF	# <CJK>
0xEFF3	0x7000	# <CJK>
0xEFF4	0x6FFB	# <CJK>
0xEFF5	0x7026	# <CJK>
0xEFF6	0x6FFC	# <CJK>
0xEFF7	0x6FF7	# <CJK>
0xEFF8	0x700A	# <CJK>
0xEFF9	0x7201	# <CJK>
0xEFFA	0x71FF	# <CJK>
0xEFFB	0x71F9	# <CJK>
0xEFFC	0x7203	# <CJK>
0xEFFD	0x71FD	# <CJK>
0xEFFE	0x7376	# <CJK>
0xF040	0x74B8	# <CJK>
0xF041	0x74C0	# <CJK>
0xF042	0x74B5	# <CJK>
0xF043	0x74C1	# <CJK>
0xF044	0x74BE	# <CJK>
0xF045	0x74B6	# <CJK>
0xF046	0x74BB	# <CJK>
0xF047	0x74C2	# <CJK>
0xF048	0x7514	# <CJK>
0xF049	0x7513	# <CJK>
0xF04A	0x765C	# <CJK>
0xF04B	0x7664	# <CJK>
0xF04C	0x7659	# <CJK>
0xF04D	0x7650	# <CJK>
0xF04E	0x7653	# <CJK>
0xF04F	0x7657	# <CJK>
0xF050	0x765A	# <CJK>
0xF051	0x76A6	# <CJK>
0xF052	0x76BD	# <CJK>
0xF053	0x76EC	# <CJK>
0xF054	0x77C2	# <CJK>
0xF055	0x77BA	# <CJK>
0xF056	0x78FF	# <CJK>
0xF057	0x790C	# <CJK>
0xF058	0x7913	# <CJK>
0xF059	0x7914	# <CJK>
0xF05A	0x7909	# <CJK>
0xF05B	0x7910	# <CJK>
0xF05C	0x7912	# <CJK>
0xF05D	0x7911	# <CJK>
0xF05E	0x79AD	# <CJK>
0xF05F	0x79AC	# <CJK>
0xF060	0x7A5F	# <CJK>
0xF061	0x7C1C	# <CJK>
0xF062	0x7C29	# <CJK>
0xF063	0x7C19	# <CJK>
0xF064	0x7C20	# <CJK>
0xF065	0x7C1F	# <CJK>
0xF066	0x7C2D	# <CJK>
0xF067	0x7C1D	# <CJK>
0xF068	0x7C26	# <CJK>
0xF069	0x7C28	# <CJK>
0xF06A	0x7C22	# <CJK>
0xF06B	0x7C25	# <CJK>
0xF06C	0x7C30	# <CJK>
0xF06D	0x7E5C	# <CJK>
0xF06E	0x7E50	# <CJK>
0xF06F	0x7E56	# <CJK>
0xF070	0x7E63	# <CJK>
0xF071	0x7E58	# <CJK>
0xF072	0x7E62	# <CJK>
0xF073	0x7E5F	# <CJK>
0xF074	0x7E51	# <CJK>
0xF075	0x7E60	# <CJK>
0xF076	0x7E57	# <CJK>
0xF077	0x7E53	# <CJK>
0xF078	0x7FB5	# <CJK>
0xF079	0x7FB3	# <CJK>
0xF07A	0x7FF7	# <CJK>
0xF07B	0x7FF8	# <CJK>
0xF07C	0x8075	# <CJK>
0xF07D	0x81D1	# <CJK>
0xF07E	0x81D2	# <CJK>
0xF0A1	0x81D0	# <CJK>
0xF0A2	0x825F	# <CJK>
0xF0A3	0x825E	# <CJK>
0xF0A4	0x85B4	# <CJK>
0xF0A5	0x85C6	# <CJK>
0xF0A6	0x85C0	# <CJK>
0xF0A7	0x85C3	# <CJK>
0xF0A8	0x85C2	# <CJK>
0xF0A9	0x85B3	# <CJK>
0xF0AA	0x85B5	# <CJK>
0xF0AB	0x85BD	# <CJK>
0xF0AC	0x85C7	# <CJK>
0xF0AD	0x85C4	# <CJK>
0xF0AE	0x85BF	# <CJK>
0xF0AF	0x85CB	# <CJK>
0xF0B0	0x85CE	# <CJK>
0xF0B1	0x85C8	# <CJK>
0xF0B2	0x85C5	# <CJK>
0xF0B3	0x85B1	# <CJK>
0xF0B4	0x85B6	# <CJK>
0xF0B5	0x85D2	# <CJK>
0xF0B6	0x8624	# <CJK>
0xF0B7	0x85B8	# <CJK>
0xF0B8	0x85B7	# <CJK>
0xF0B9	0x85BE	# <CJK>
0xF0BA	0x8669	# <CJK>
0xF0BB	0x87E7	# <CJK>
0xF0BC	0x87E6	# <CJK>
0xF0BD	0x87E2	# <CJK>
0xF0BE	0x87DB	# <CJK>
0xF0BF	0x87EB	# <CJK>
0xF0C0	0x87EA	# <CJK>
0xF0C1	0x87E5	# <CJK>
0xF0C2	0x87DF	# <CJK>
0xF0C3	0x87F3	# <CJK>
0xF0C4	0x87E4	# <CJK>
0xF0C5	0x87D4	# <CJK>
0xF0C6	0x87DC	# <CJK>
0xF0C7	0x87D3	# <CJK>
0xF0C8	0x87ED	# <CJK>
0xF0C9	0x87D8	# <CJK>
0xF0CA	0x87E3	# <CJK>
0xF0CB	0x87A4	# <CJK>
0xF0CC	0x87D7	# <CJK>
0xF0CD	0x87D9	# <CJK>
0xF0CE	0x8801	# <CJK>
0xF0CF	0x87F4	# <CJK>
0xF0D0	0x87E8	# <CJK>
0xF0D1	0x87DD	# <CJK>
0xF0D2	0x8953	# <CJK>
0xF0D3	0x894B	# <CJK>
0xF0D4	0x894F	# <CJK>
0xF0D5	0x894C	# <CJK>
0xF0D6	0x8946	# <CJK>
0xF0D7	0x8950	# <CJK>
0xF0D8	0x8951	# <CJK>
0xF0D9	0x8949	# <CJK>
0xF0DA	0x8B2A	# <CJK>
0xF0DB	0x8B27	# <CJK>
0xF0DC	0x8B23	# <CJK>
0xF0DD	0x8B33	# <CJK>
0xF0DE	0x8B30	# <CJK>
0xF0DF	0x8B35	# <CJK>
0xF0E0	0x8B47	# <CJK>
0xF0E1	0x8B2F	# <CJK>
0xF0E2	0x8B3C	# <CJK>
0xF0E3	0x8B3E	# <CJK>
0xF0E4	0x8B31	# <CJK>
0xF0E5	0x8B25	# <CJK>
0xF0E6	0x8B37	# <CJK>
0xF0E7	0x8B26	# <CJK>
0xF0E8	0x8B36	# <CJK>
0xF0E9	0x8B2E	# <CJK>
0xF0EA	0x8B24	# <CJK>
0xF0EB	0x8B3B	# <CJK>
0xF0EC	0x8B3D	# <CJK>
0xF0ED	0x8B3A	# <CJK>
0xF0EE	0x8C42	# <CJK>
0xF0EF	0x8C75	# <CJK>
0xF0F0	0x8C99	# <CJK>
0xF0F1	0x8C98	# <CJK>
0xF0F2	0x8C97	# <CJK>
0xF0F3	0x8CFE	# <CJK>
0xF0F4	0x8D04	# <CJK>
0xF0F5	0x8D02	# <CJK>
0xF0F6	0x8D00	# <CJK>
0xF0F7	0x8E5C	# <CJK>
0xF0F8	0x8E62	# <CJK>
0xF0F9	0x8E60	# <CJK>
0xF0FA	0x8E57	# <CJK>
0xF0FB	0x8E56	# <CJK>
0xF0FC	0x8E5E	# <CJK>
0xF0FD	0x8E65	# <CJK>
0xF0FE	0x8E67	# <CJK>
0xF140	0x8E5B	# <CJK>
0xF141	0x8E5A	# <CJK>
0xF142	0x8E61	# <CJK>
0xF143	0x8E5D	# <CJK>
0xF144	0x8E69	# <CJK>
0xF145	0x8E54	# <CJK>
0xF146	0x8F46	# <CJK>
0xF147	0x8F47	# <CJK>
0xF148	0x8F48	# <CJK>
0xF149	0x8F4B	# <CJK>
0xF14A	0x9128	# <CJK>
0xF14B	0x913A	# <CJK>
0xF14C	0x913B	# <CJK>
0xF14D	0x913E	# <CJK>
0xF14E	0x91A8	# <CJK>
0xF14F	0x91A5	# <CJK>
0xF150	0x91A7	# <CJK>
0xF151	0x91AF	# <CJK>
0xF152	0x91AA	# <CJK>
0xF153	0x93B5	# <CJK>
0xF154	0x938C	# <CJK>
0xF155	0x9392	# <CJK>
0xF156	0x93B7	# <CJK>
0xF157	0x939B	# <CJK>
0xF158	0x939D	# <CJK>
0xF159	0x9389	# <CJK>
0xF15A	0x93A7	# <CJK>
0xF15B	0x938E	# <CJK>
0xF15C	0x93AA	# <CJK>
0xF15D	0x939E	# <CJK>
0xF15E	0x93A6	# <CJK>
0xF15F	0x9395	# <CJK>
0xF160	0x9388	# <CJK>
0xF161	0x9399	# <CJK>
0xF162	0x939F	# <CJK>
0xF163	0x938D	# <CJK>
0xF164	0x93B1	# <CJK>
0xF165	0x9391	# <CJK>
0xF166	0x93B2	# <CJK>
0xF167	0x93A4	# <CJK>
0xF168	0x93A8	# <CJK>
0xF169	0x93B4	# <CJK>
0xF16A	0x93A3	# <CJK>
0xF16B	0x93A5	# <CJK>
0xF16C	0x95D2	# <CJK>
0xF16D	0x95D3	# <CJK>
0xF16E	0x95D1	# <CJK>
0xF16F	0x96B3	# <CJK>
0xF170	0x96D7	# <CJK>
0xF171	0x96DA	# <CJK>
0xF172	0x5DC2	# <CJK>
0xF173	0x96DF	# <CJK>
0xF174	0x96D8	# <CJK>
0xF175	0x96DD	# <CJK>
0xF176	0x9723	# <CJK>
0xF177	0x9722	# <CJK>
0xF178	0x9725	# <CJK>
0xF179	0x97AC	# <CJK>
0xF17A	0x97AE	# <CJK>
0xF17B	0x97A8	# <CJK>
0xF17C	0x97AB	# <CJK>
0xF17D	0x97A4	# <CJK>
0xF17E	0x97AA	# <CJK>
0xF1A1	0x97A2	# <CJK>
0xF1A2	0x97A5	# <CJK>
0xF1A3	0x97D7	# <CJK>
0xF1A4	0x97D9	# <CJK>
0xF1A5	0x97D6	# <CJK>
0xF1A6	0x97D8	# <CJK>
0xF1A7	0x97FA	# <CJK>
0xF1A8	0x9850	# <CJK>
0xF1A9	0x9851	# <CJK>
0xF1AA	0x9852	# <CJK>
0xF1AB	0x98B8	# <CJK>
0xF1AC	0x9941	# <CJK>
0xF1AD	0x993C	# <CJK>
0xF1AE	0x993A	# <CJK>
0xF1AF	0x9A0F	# <CJK>
0xF1B0	0x9A0B	# <CJK>
0xF1B1	0x9A09	# <CJK>
0xF1B2	0x9A0D	# <CJK>
0xF1B3	0x9A04	# <CJK>
0xF1B4	0x9A11	# <CJK>
0xF1B5	0x9A0A	# <CJK>
0xF1B6	0x9A05	# <CJK>
0xF1B7	0x9A07	# <CJK>
0xF1B8	0x9A06	# <CJK>
0xF1B9	0x9AC0	# <CJK>
0xF1BA	0x9ADC	# <CJK>
0xF1BB	0x9B08	# <CJK>
0xF1BC	0x9B04	# <CJK>
0xF1BD	0x9B05	# <CJK>
0xF1BE	0x9B29	# <CJK>
0xF1BF	0x9B35	# <CJK>
0xF1C0	0x9B4A	# <CJK>
0xF1C1	0x9B4C	# <CJK>
0xF1C2	0x9B4B	# <CJK>
0xF1C3	0x9BC7	# <CJK>
0xF1C4	0x9BC6	# <CJK>
0xF1C5	0x9BC3	# <CJK>
0xF1C6	0x9BBF	# <CJK>
0xF1C7	0x9BC1	# <CJK>
0xF1C8	0x9BB5	# <CJK>
0xF1C9	0x9BB8	# <CJK>
0xF1CA	0x9BD3	# <CJK>
0xF1CB	0x9BB6	# <CJK>
0xF1CC	0x9BC4	# <CJK>
0xF1CD	0x9BB9	# <CJK>
0xF1CE	0x9BBD	# <CJK>
0xF1CF	0x9D5C	# <CJK>
0xF1D0	0x9D53	# <CJK>
0xF1D1	0x9D4F	# <CJK>
0xF1D2	0x9D4A	# <CJK>
0xF1D3	0x9D5B	# <CJK>
0xF1D4	0x9D4B	# <CJK>
0xF1D5	0x9D59	# <CJK>
0xF1D6	0x9D56	# <CJK>
0xF1D7	0x9D4C	# <CJK>
0xF1D8	0x9D57	# <CJK>
0xF1D9	0x9D52	# <CJK>
0xF1DA	0x9D54	# <CJK>
0xF1DB	0x9D5F	# <CJK>
0xF1DC	0x9D58	# <CJK>
0xF1DD	0x9D5A	# <CJK>
0xF1DE	0x9E8E	# <CJK>
0xF1DF	0x9E8C	# <CJK>
0xF1E0	0x9EDF	# <CJK>
0xF1E1	0x9F01	# <CJK>
0xF1E2	0x9F00	# <CJK>
0xF1E3	0x9F16	# <CJK>
0xF1E4	0x9F25	# <CJK>
0xF1E5	0x9F2B	# <CJK>
0xF1E6	0x9F2A	# <CJK>
0xF1E7	0x9F29	# <CJK>
0xF1E8	0x9F28	# <CJK>
0xF1E9	0x9F4C	# <CJK>
0xF1EA	0x9F55	# <CJK>
0xF1EB	0x5134	# <CJK>
0xF1EC	0x5135	# <CJK>
0xF1ED	0x5296	# <CJK>
0xF1EE	0x52F7	# <CJK>
0xF1EF	0x53B4	# <CJK>
0xF1F0	0x56AB	# <CJK>
0xF1F1	0x56AD	# <CJK>
0xF1F2	0x56A6	# <CJK>
0xF1F3	0x56A7	# <CJK>
0xF1F4	0x56AA	# <CJK>
0xF1F5	0x56AC	# <CJK>
0xF1F6	0x58DA	# <CJK>
0xF1F7	0x58DD	# <CJK>
0xF1F8	0x58DB	# <CJK>
0xF1F9	0x5912	# <CJK>
0xF1FA	0x5B3D	# <CJK>
0xF1FB	0x5B3E	# <CJK>
0xF1FC	0x5B3F	# <CJK>
0xF1FD	0x5DC3	# <CJK>
0xF1FE	0x5E70	# <CJK>
0xF240	0x5FBF	# <CJK>
0xF241	0x61FB	# <CJK>
0xF242	0x6507	# <CJK>
0xF243	0x6510	# <CJK>
0xF244	0x650D	# <CJK>
0xF245	0x6509	# <CJK>
0xF246	0x650C	# <CJK>
0xF247	0x650E	# <CJK>
0xF248	0x6584	# <CJK>
0xF249	0x65DE	# <CJK>
0xF24A	0x65DD	# <CJK>
0xF24B	0x66DE	# <CJK>
0xF24C	0x6AE7	# <CJK>
0xF24D	0x6AE0	# <CJK>
0xF24E	0x6ACC	# <CJK>
0xF24F	0x6AD1	# <CJK>
0xF250	0x6AD9	# <CJK>
0xF251	0x6ACB	# <CJK>
0xF252	0x6ADF	# <CJK>
0xF253	0x6ADC	# <CJK>
0xF254	0x6AD0	# <CJK>
0xF255	0x6AEB	# <CJK>
0xF256	0x6ACF	# <CJK>
0xF257	0x6ACD	# <CJK>
0xF258	0x6ADE	# <CJK>
0xF259	0x6B60	# <CJK>
0xF25A	0x6BB0	# <CJK>
0xF25B	0x6C0C	# <CJK>
0xF25C	0x7019	# <CJK>
0xF25D	0x7027	# <CJK>
0xF25E	0x7020	# <CJK>
0xF25F	0x7016	# <CJK>
0xF260	0x702B	# <CJK>
0xF261	0x7021	# <CJK>
0xF262	0x7022	# <CJK>
0xF263	0x7023	# <CJK>
0xF264	0x7029	# <CJK>
0xF265	0x7017	# <CJK>
0xF266	0x7024	# <CJK>
0xF267	0x701C	# <CJK>
0xF268	0x702A	# <CJK>
0xF269	0x720C	# <CJK>
0xF26A	0x720A	# <CJK>
0xF26B	0x7207	# <CJK>
0xF26C	0x7202	# <CJK>
0xF26D	0x7205	# <CJK>
0xF26E	0x72A5	# <CJK>
0xF26F	0x72A6	# <CJK>
0xF270	0x72A4	# <CJK>
0xF271	0x72A3	# <CJK>
0xF272	0x72A1	# <CJK>
0xF273	0x74CB	# <CJK>
0xF274	0x74C5	# <CJK>
0xF275	0x74B7	# <CJK>
0xF276	0x74C3	# <CJK>
0xF277	0x7516	# <CJK>
0xF278	0x7660	# <CJK>
0xF279	0x77C9	# <CJK>
0xF27A	0x77CA	# <CJK>
0xF27B	0x77C4	# <CJK>
0xF27C	0x77F1	# <CJK>
0xF27D	0x791D	# <CJK>
0xF27E	0x791B	# <CJK>
0xF2A1	0x7921	# <CJK>
0xF2A2	0x791C	# <CJK>
0xF2A3	0x7917	# <CJK>
0xF2A4	0x791E	# <CJK>
0xF2A5	0x79B0	# <CJK>
0xF2A6	0x7A67	# <CJK>
0xF2A7	0x7A68	# <CJK>
0xF2A8	0x7C33	# <CJK>
0xF2A9	0x7C3C	# <CJK>
0xF2AA	0x7C39	# <CJK>
0xF2AB	0x7C2C	# <CJK>
0xF2AC	0x7C3B	# <CJK>
0xF2AD	0x7CEC	# <CJK>
0xF2AE	0x7CEA	# <CJK>
0xF2AF	0x7E76	# <CJK>
0xF2B0	0x7E75	# <CJK>
0xF2B1	0x7E78	# <CJK>
0xF2B2	0x7E70	# <CJK>
0xF2B3	0x7E77	# <CJK>
0xF2B4	0x7E6F	# <CJK>
0xF2B5	0x7E7A	# <CJK>
0xF2B6	0x7E72	# <CJK>
0xF2B7	0x7E74	# <CJK>
0xF2B8	0x7E68	# <CJK>
0xF2B9	0x7F4B	# <CJK>
0xF2BA	0x7F4A	# <CJK>
0xF2BB	0x7F83	# <CJK>
0xF2BC	0x7F86	# <CJK>
0xF2BD	0x7FB7	# <CJK>
0xF2BE	0x7FFD	# <CJK>
0xF2BF	0x7FFE	# <CJK>
0xF2C0	0x8078	# <CJK>
0xF2C1	0x81D7	# <CJK>
0xF2C2	0x81D5	# <CJK>
0xF2C3	0x8264	# <CJK>
0xF2C4	0x8261	# <CJK>
0xF2C5	0x8263	# <CJK>
0xF2C6	0x85EB	# <CJK>
0xF2C7	0x85F1	# <CJK>
0xF2C8	0x85ED	# <CJK>
0xF2C9	0x85D9	# <CJK>
0xF2CA	0x85E1	# <CJK>
0xF2CB	0x85E8	# <CJK>
0xF2CC	0x85DA	# <CJK>
0xF2CD	0x85D7	# <CJK>
0xF2CE	0x85EC	# <CJK>
0xF2CF	0x85F2	# <CJK>
0xF2D0	0x85F8	# <CJK>
0xF2D1	0x85D8	# <CJK>
0xF2D2	0x85DF	# <CJK>
0xF2D3	0x85E3	# <CJK>
0xF2D4	0x85DC	# <CJK>
0xF2D5	0x85D1	# <CJK>
0xF2D6	0x85F0	# <CJK>
0xF2D7	0x85E6	# <CJK>
0xF2D8	0x85EF	# <CJK>
0xF2D9	0x85DE	# <CJK>
0xF2DA	0x85E2	# <CJK>
0xF2DB	0x8800	# <CJK>
0xF2DC	0x87FA	# <CJK>
0xF2DD	0x8803	# <CJK>
0xF2DE	0x87F6	# <CJK>
0xF2DF	0x87F7	# <CJK>
0xF2E0	0x8809	# <CJK>
0xF2E1	0x880C	# <CJK>
0xF2E2	0x880B	# <CJK>
0xF2E3	0x8806	# <CJK>
0xF2E4	0x87FC	# <CJK>
0xF2E5	0x8808	# <CJK>
0xF2E6	0x87FF	# <CJK>
0xF2E7	0x880A	# <CJK>
0xF2E8	0x8802	# <CJK>
0xF2E9	0x8962	# <CJK>
0xF2EA	0x895A	# <CJK>
0xF2EB	0x895B	# <CJK>
0xF2EC	0x8957	# <CJK>
0xF2ED	0x8961	# <CJK>
0xF2EE	0x895C	# <CJK>
0xF2EF	0x8958	# <CJK>
0xF2F0	0x895D	# <CJK>
0xF2F1	0x8959	# <CJK>
0xF2F2	0x8988	# <CJK>
0xF2F3	0x89B7	# <CJK>
0xF2F4	0x89B6	# <CJK>
0xF2F5	0x89F6	# <CJK>
0xF2F6	0x8B50	# <CJK>
0xF2F7	0x8B48	# <CJK>
0xF2F8	0x8B4A	# <CJK>
0xF2F9	0x8B40	# <CJK>
0xF2FA	0x8B53	# <CJK>
0xF2FB	0x8B56	# <CJK>
0xF2FC	0x8B54	# <CJK>
0xF2FD	0x8B4B	# <CJK>
0xF2FE	0x8B55	# <CJK>
0xF340	0x8B51	# <CJK>
0xF341	0x8B42	# <CJK>
0xF342	0x8B52	# <CJK>
0xF343	0x8B57	# <CJK>
0xF344	0x8C43	# <CJK>
0xF345	0x8C77	# <CJK>
0xF346	0x8C76	# <CJK>
0xF347	0x8C9A	# <CJK>
0xF348	0x8D06	# <CJK>
0xF349	0x8D07	# <CJK>
0xF34A	0x8D09	# <CJK>
0xF34B	0x8DAC	# <CJK>
0xF34C	0x8DAA	# <CJK>
0xF34D	0x8DAD	# <CJK>
0xF34E	0x8DAB	# <CJK>
0xF34F	0x8E6D	# <CJK>
0xF350	0x8E78	# <CJK>
0xF351	0x8E73	# <CJK>
0xF352	0x8E6A	# <CJK>
0xF353	0x8E6F	# <CJK>
0xF354	0x8E7B	# <CJK>
0xF355	0x8EC2	# <CJK>
0xF356	0x8F52	# <CJK>
0xF357	0x8F51	# <CJK>
0xF358	0x8F4F	# <CJK>
0xF359	0x8F50	# <CJK>
0xF35A	0x8F53	# <CJK>
0xF35B	0x8FB4	# <CJK>
0xF35C	0x9140	# <CJK>
0xF35D	0x913F	# <CJK>
0xF35E	0x91B0	# <CJK>
0xF35F	0x91AD	# <CJK>
0xF360	0x93DE	# <CJK>
0xF361	0x93C7	# <CJK>
0xF362	0x93CF	# <CJK>
0xF363	0x93C2	# <CJK>
0xF364	0x93DA	# <CJK>
0xF365	0x93D0	# <CJK>
0xF366	0x93F9	# <CJK>
0xF367	0x93EC	# <CJK>
0xF368	0x93CC	# <CJK>
0xF369	0x93D9	# <CJK>
0xF36A	0x93A9	# <CJK>
0xF36B	0x93E6	# <CJK>
0xF36C	0x93CA	# <CJK>
0xF36D	0x93D4	# <CJK>
0xF36E	0x93EE	# <CJK>
0xF36F	0x93E3	# <CJK>
0xF370	0x93D5	# <CJK>
0xF371	0x93C4	# <CJK>
0xF372	0x93CE	# <CJK>
0xF373	0x93C0	# <CJK>
0xF374	0x93D2	# <CJK>
0xF375	0x93E7	# <CJK>
0xF376	0x957D	# <CJK>
0xF377	0x95DA	# <CJK>
0xF378	0x95DB	# <CJK>
0xF379	0x96E1	# <CJK>
0xF37A	0x9729	# <CJK>
0xF37B	0x972B	# <CJK>
0xF37C	0x972C	# <CJK>
0xF37D	0x9728	# <CJK>
0xF37E	0x9726	# <CJK>
0xF3A1	0x97B3	# <CJK>
0xF3A2	0x97B7	# <CJK>
0xF3A3	0x97B6	# <CJK>
0xF3A4	0x97DD	# <CJK>
0xF3A5	0x97DE	# <CJK>
0xF3A6	0x97DF	# <CJK>
0xF3A7	0x985C	# <CJK>
0xF3A8	0x9859	# <CJK>
0xF3A9	0x985D	# <CJK>
0xF3AA	0x9857	# <CJK>
0xF3AB	0x98BF	# <CJK>
0xF3AC	0x98BD	# <CJK>
0xF3AD	0x98BB	# <CJK>
0xF3AE	0x98BE	# <CJK>
0xF3AF	0x9948	# <CJK>
0xF3B0	0x9947	# <CJK>
0xF3B1	0x9943	# <CJK>
0xF3B2	0x99A6	# <CJK>
0xF3B3	0x99A7	# <CJK>
0xF3B4	0x9A1A	# <CJK>
0xF3B5	0x9A15	# <CJK>
0xF3B6	0x9A25	# <CJK>
0xF3B7	0x9A1D	# <CJK>
0xF3B8	0x9A24	# <CJK>
0xF3B9	0x9A1B	# <CJK>
0xF3BA	0x9A22	# <CJK>
0xF3BB	0x9A20	# <CJK>
0xF3BC	0x9A27	# <CJK>
0xF3BD	0x9A23	# <CJK>
0xF3BE	0x9A1E	# <CJK>
0xF3BF	0x9A1C	# <CJK>
0xF3C0	0x9A14	# <CJK>
0xF3C1	0x9AC2	# <CJK>
0xF3C2	0x9B0B	# <CJK>
0xF3C3	0x9B0A	# <CJK>
0xF3C4	0x9B0E	# <CJK>
0xF3C5	0x9B0C	# <CJK>
0xF3C6	0x9B37	# <CJK>
0xF3C7	0x9BEA	# <CJK>
0xF3C8	0x9BEB	# <CJK>
0xF3C9	0x9BE0	# <CJK>
0xF3CA	0x9BDE	# <CJK>
0xF3CB	0x9BE4	# <CJK>
0xF3CC	0x9BE6	# <CJK>
0xF3CD	0x9BE2	# <CJK>
0xF3CE	0x9BF0	# <CJK>
0xF3CF	0x9BD4	# <CJK>
0xF3D0	0x9BD7	# <CJK>
0xF3D1	0x9BEC	# <CJK>
0xF3D2	0x9BDC	# <CJK>
0xF3D3	0x9BD9	# <CJK>
0xF3D4	0x9BE5	# <CJK>
0xF3D5	0x9BD5	# <CJK>
0xF3D6	0x9BE1	# <CJK>
0xF3D7	0x9BDA	# <CJK>
0xF3D8	0x9D77	# <CJK>
0xF3D9	0x9D81	# <CJK>
0xF3DA	0x9D8A	# <CJK>
0xF3DB	0x9D84	# <CJK>
0xF3DC	0x9D88	# <CJK>
0xF3DD	0x9D71	# <CJK>
0xF3DE	0x9D80	# <CJK>
0xF3DF	0x9D78	# <CJK>
0xF3E0	0x9D86	# <CJK>
0xF3E1	0x9D8B	# <CJK>
0xF3E2	0x9D8C	# <CJK>
0xF3E3	0x9D7D	# <CJK>
0xF3E4	0x9D6B	# <CJK>
0xF3E5	0x9D74	# <CJK>
0xF3E6	0x9D75	# <CJK>
0xF3E7	0x9D70	# <CJK>
0xF3E8	0x9D69	# <CJK>
0xF3E9	0x9D85	# <CJK>
0xF3EA	0x9D73	# <CJK>
0xF3EB	0x9D7B	# <CJK>
0xF3EC	0x9D82	# <CJK>
0xF3ED	0x9D6F	# <CJK>
0xF3EE	0x9D79	# <CJK>
0xF3EF	0x9D7F	# <CJK>
0xF3F0	0x9D87	# <CJK>
0xF3F1	0x9D68	# <CJK>
0xF3F2	0x9E94	# <CJK>
0xF3F3	0x9E91	# <CJK>
0xF3F4	0x9EC0	# <CJK>
0xF3F5	0x9EFC	# <CJK>
0xF3F6	0x9F2D	# <CJK>
0xF3F7	0x9F40	# <CJK>
0xF3F8	0x9F41	# <CJK>
0xF3F9	0x9F4D	# <CJK>
0xF3FA	0x9F56	# <CJK>
0xF3FB	0x9F57	# <CJK>
0xF3FC	0x9F58	# <CJK>
0xF3FD	0x5337	# <CJK>
0xF3FE	0x56B2	# <CJK>
0xF440	0x56B5	# <CJK>
0xF441	0x56B3	# <CJK>
0xF442	0x58E3	# <CJK>
0xF443	0x5B45	# <CJK>
0xF444	0x5DC6	# <CJK>
0xF445	0x5DC7	# <CJK>
0xF446	0x5EEE	# <CJK>
0xF447	0x5EEF	# <CJK>
0xF448	0x5FC0	# <CJK>
0xF449	0x5FC1	# <CJK>
0xF44A	0x61F9	# <CJK>
0xF44B	0x6517	# <CJK>
0xF44C	0x6516	# <CJK>
0xF44D	0x6515	# <CJK>
0xF44E	0x6513	# <CJK>
0xF44F	0x65DF	# <CJK>
0xF450	0x66E8	# <CJK>
0xF451	0x66E3	# <CJK>
0xF452	0x66E4	# <CJK>
0xF453	0x6AF3	# <CJK>
0xF454	0x6AF0	# <CJK>
0xF455	0x6AEA	# <CJK>
0xF456	0x6AE8	# <CJK>
0xF457	0x6AF9	# <CJK>
0xF458	0x6AF1	# <CJK>
0xF459	0x6AEE	# <CJK>
0xF45A	0x6AEF	# <CJK>
0xF45B	0x703C	# <CJK>
0xF45C	0x7035	# <CJK>
0xF45D	0x702F	# <CJK>
0xF45E	0x7037	# <CJK>
0xF45F	0x7034	# <CJK>
0xF460	0x7031	# <CJK>
0xF461	0x7042	# <CJK>
0xF462	0x7038	# <CJK>
0xF463	0x703F	# <CJK>
0xF464	0x703A	# <CJK>
0xF465	0x7039	# <CJK>
0xF466	0x7040	# <CJK>
0xF467	0x703B	# <CJK>
0xF468	0x7033	# <CJK>
0xF469	0x7041	# <CJK>
0xF46A	0x7213	# <CJK>
0xF46B	0x7214	# <CJK>
0xF46C	0x72A8	# <CJK>
0xF46D	0x737D	# <CJK>
0xF46E	0x737C	# <CJK>
0xF46F	0x74BA	# <CJK>
0xF470	0x76AB	# <CJK>
0xF471	0x76AA	# <CJK>
0xF472	0x76BE	# <CJK>
0xF473	0x76ED	# <CJK>
0xF474	0x77CC	# <CJK>
0xF475	0x77CE	# <CJK>
0xF476	0x77CF	# <CJK>
0xF477	0x77CD	# <CJK>
0xF478	0x77F2	# <CJK>
0xF479	0x7925	# <CJK>
0xF47A	0x7923	# <CJK>
0xF47B	0x7927	# <CJK>
0xF47C	0x7928	# <CJK>
0xF47D	0x7924	# <CJK>
0xF47E	0x7929	# <CJK>
0xF4A1	0x79B2	# <CJK>
0xF4A2	0x7A6E	# <CJK>
0xF4A3	0x7A6C	# <CJK>
0xF4A4	0x7A6D	# <CJK>
0xF4A5	0x7AF7	# <CJK>
0xF4A6	0x7C49	# <CJK>
0xF4A7	0x7C48	# <CJK>
0xF4A8	0x7C4A	# <CJK>
0xF4A9	0x7C47	# <CJK>
0xF4AA	0x7C45	# <CJK>
0xF4AB	0x7CEE	# <CJK>
0xF4AC	0x7E7B	# <CJK>
0xF4AD	0x7E7E	# <CJK>
0xF4AE	0x7E81	# <CJK>
0xF4AF	0x7E80	# <CJK>
0xF4B0	0x7FBA	# <CJK>
0xF4B1	0x7FFF	# <CJK>
0xF4B2	0x8079	# <CJK>
0xF4B3	0x81DB	# <CJK>
0xF4B4	0x81D9	# <CJK>
0xF4B5	0x820B	# <CJK>
0xF4B6	0x8268	# <CJK>
0xF4B7	0x8269	# <CJK>
0xF4B8	0x8622	# <CJK>
0xF4B9	0x85FF	# <CJK>
0xF4BA	0x8601	# <CJK>
0xF4BB	0x85FE	# <CJK>
0xF4BC	0x861B	# <CJK>
0xF4BD	0x8600	# <CJK>
0xF4BE	0x85F6	# <CJK>
0xF4BF	0x8604	# <CJK>
0xF4C0	0x8609	# <CJK>
0xF4C1	0x8605	# <CJK>
0xF4C2	0x860C	# <CJK>
0xF4C3	0x85FD	# <CJK>
0xF4C4	0x8819	# <CJK>
0xF4C5	0x8810	# <CJK>
0xF4C6	0x8811	# <CJK>
0xF4C7	0x8817	# <CJK>
0xF4C8	0x8813	# <CJK>
0xF4C9	0x8816	# <CJK>
0xF4CA	0x8963	# <CJK>
0xF4CB	0x8966	# <CJK>
0xF4CC	0x89B9	# <CJK>
0xF4CD	0x89F7	# <CJK>
0xF4CE	0x8B60	# <CJK>
0xF4CF	0x8B6A	# <CJK>
0xF4D0	0x8B5D	# <CJK>
0xF4D1	0x8B68	# <CJK>
0xF4D2	0x8B63	# <CJK>
0xF4D3	0x8B65	# <CJK>
0xF4D4	0x8B67	# <CJK>
0xF4D5	0x8B6D	# <CJK>
0xF4D6	0x8DAE	# <CJK>
0xF4D7	0x8E86	# <CJK>
0xF4D8	0x8E88	# <CJK>
0xF4D9	0x8E84	# <CJK>
0xF4DA	0x8F59	# <CJK>
0xF4DB	0x8F56	# <CJK>
0xF4DC	0x8F57	# <CJK>
0xF4DD	0x8F55	# <CJK>
0xF4DE	0x8F58	# <CJK>
0xF4DF	0x8F5A	# <CJK>
0xF4E0	0x908D	# <CJK>
0xF4E1	0x9143	# <CJK>
0xF4E2	0x9141	# <CJK>
0xF4E3	0x91B7	# <CJK>
0xF4E4	0x91B5	# <CJK>
0xF4E5	0x91B2	# <CJK>
0xF4E6	0x91B3	# <CJK>
0xF4E7	0x940B	# <CJK>
0xF4E8	0x9413	# <CJK>
0xF4E9	0x93FB	# <CJK>
0xF4EA	0x9420	# <CJK>
0xF4EB	0x940F	# <CJK>
0xF4EC	0x9414	# <CJK>
0xF4ED	0x93FE	# <CJK>
0xF4EE	0x9415	# <CJK>
0xF4EF	0x9410	# <CJK>
0xF4F0	0x9428	# <CJK>
0xF4F1	0x9419	# <CJK>
0xF4F2	0x940D	# <CJK>
0xF4F3	0x93F5	# <CJK>
0xF4F4	0x9400	# <CJK>
0xF4F5	0x93F7	# <CJK>
0xF4F6	0x9407	# <CJK>
0xF4F7	0x940E	# <CJK>
0xF4F8	0x9416	# <CJK>
0xF4F9	0x9412	# <CJK>
0xF4FA	0x93FA	# <CJK>
0xF4FB	0x9409	# <CJK>
0xF4FC	0x93F8	# <CJK>
0xF4FD	0x940A	# <CJK>
0xF4FE	0x93FF	# <CJK>
0xF540	0x93FC	# <CJK>
0xF541	0x940C	# <CJK>
0xF542	0x93F6	# <CJK>
0xF543	0x9411	# <CJK>
0xF544	0x9406	# <CJK>
0xF545	0x95DE	# <CJK>
0xF546	0x95E0	# <CJK>
0xF547	0x95DF	# <CJK>
0xF548	0x972E	# <CJK>
0xF549	0x972F	# <CJK>
0xF54A	0x97B9	# <CJK>
0xF54B	0x97BB	# <CJK>
0xF54C	0x97FD	# <CJK>
0xF54D	0x97FE	# <CJK>
0xF54E	0x9860	# <CJK>
0xF54F	0x9862	# <CJK>
0xF550	0x9863	# <CJK>
0xF551	0x985F	# <CJK>
0xF552	0x98C1	# <CJK>
0xF553	0x98C2	# <CJK>
0xF554	0x9950	# <CJK>
0xF555	0x994E	# <CJK>
0xF556	0x9959	# <CJK>
0xF557	0x994C	# <CJK>
0xF558	0x994B	# <CJK>
0xF559	0x9953	# <CJK>
0xF55A	0x9A32	# <CJK>
0xF55B	0x9A34	# <CJK>
0xF55C	0x9A31	# <CJK>
0xF55D	0x9A2C	# <CJK>
0xF55E	0x9A2A	# <CJK>
0xF55F	0x9A36	# <CJK>
0xF560	0x9A29	# <CJK>
0xF561	0x9A2E	# <CJK>
0xF562	0x9A38	# <CJK>
0xF563	0x9A2D	# <CJK>
0xF564	0x9AC7	# <CJK>
0xF565	0x9ACA	# <CJK>
0xF566	0x9AC6	# <CJK>
0xF567	0x9B10	# <CJK>
0xF568	0x9B12	# <CJK>
0xF569	0x9B11	# <CJK>
0xF56A	0x9C0B	# <CJK>
0xF56B	0x9C08	# <CJK>
0xF56C	0x9BF7	# <CJK>
0xF56D	0x9C05	# <CJK>
0xF56E	0x9C12	# <CJK>
0xF56F	0x9BF8	# <CJK>
0xF570	0x9C40	# <CJK>
0xF571	0x9C07	# <CJK>
0xF572	0x9C0E	# <CJK>
0xF573	0x9C06	# <CJK>
0xF574	0x9C17	# <CJK>
0xF575	0x9C14	# <CJK>
0xF576	0x9C09	# <CJK>
0xF577	0x9D9F	# <CJK>
0xF578	0x9D99	# <CJK>
0xF579	0x9DA4	# <CJK>
0xF57A	0x9D9D	# <CJK>
0xF57B	0x9D92	# <CJK>
0xF57C	0x9D98	# <CJK>
0xF57D	0x9D90	# <CJK>
0xF57E	0x9D9B	# <CJK>
0xF5A1	0x9DA0	# <CJK>
0xF5A2	0x9D94	# <CJK>
0xF5A3	0x9D9C	# <CJK>
0xF5A4	0x9DAA	# <CJK>
0xF5A5	0x9D97	# <CJK>
0xF5A6	0x9DA1	# <CJK>
0xF5A7	0x9D9A	# <CJK>
0xF5A8	0x9DA2	# <CJK>
0xF5A9	0x9DA8	# <CJK>
0xF5AA	0x9D9E	# <CJK>
0xF5AB	0x9DA3	# <CJK>
0xF5AC	0x9DBF	# <CJK>
0xF5AD	0x9DA9	# <CJK>
0xF5AE	0x9D96	# <CJK>
0xF5AF	0x9DA6	# <CJK>
0xF5B0	0x9DA7	# <CJK>
0xF5B1	0x9E99	# <CJK>
0xF5B2	0x9E9B	# <CJK>
0xF5B3	0x9E9A	# <CJK>
0xF5B4	0x9EE5	# <CJK>
0xF5B5	0x9EE4	# <CJK>
0xF5B6	0x9EE7	# <CJK>
0xF5B7	0x9EE6	# <CJK>
0xF5B8	0x9F30	# <CJK>
0xF5B9	0x9F2E	# <CJK>
0xF5BA	0x9F5B	# <CJK>
0xF5BB	0x9F60	# <CJK>
0xF5BC	0x9F5E	# <CJK>
0xF5BD	0x9F5D	# <CJK>
0xF5BE	0x9F59	# <CJK>
0xF5BF	0x9F91	# <CJK>
0xF5C0	0x513A	# <CJK>
0xF5C1	0x5139	# <CJK>
0xF5C2	0x5298	# <CJK>
0xF5C3	0x5297	# <CJK>
0xF5C4	0x56C3	# <CJK>
0xF5C5	0x56BD	# <CJK>
0xF5C6	0x56BE	# <CJK>
0xF5C7	0x5B48	# <CJK>
0xF5C8	0x5B47	# <CJK>
0xF5C9	0x5DCB	# <CJK>
0xF5CA	0x5DCF	# <CJK>
0xF5CB	0x5EF1	# <CJK>
0xF5CC	0x61FD	# <CJK>
0xF5CD	0x651B	# <CJK>
0xF5CE	0x6B02	# <CJK>
0xF5CF	0x6AFC	# <CJK>
0xF5D0	0x6B03	# <CJK>
0xF5D1	0x6AF8	# <CJK>
0xF5D2	0x6B00	# <CJK>
0xF5D3	0x7043	# <CJK>
0xF5D4	0x7044	# <CJK>
0xF5D5	0x704A	# <CJK>
0xF5D6	0x7048	# <CJK>
0xF5D7	0x7049	# <CJK>
0xF5D8	0x7045	# <CJK>
0xF5D9	0x7046	# <CJK>
0xF5DA	0x721D	# <CJK>
0xF5DB	0x721A	# <CJK>
0xF5DC	0x7219	# <CJK>
0xF5DD	0x737E	# <CJK>
0xF5DE	0x7517	# <CJK>
0xF5DF	0x766A	# <CJK>
0xF5E0	0x77D0	# <CJK>
0xF5E1	0x792D	# <CJK>
0xF5E2	0x7931	# <CJK>
0xF5E3	0x792F	# <CJK>
0xF5E4	0x7C54	# <CJK>
0xF5E5	0x7C53	# <CJK>
0xF5E6	0x7CF2	# <CJK>
0xF5E7	0x7E8A	# <CJK>
0xF5E8	0x7E87	# <CJK>
0xF5E9	0x7E88	# <CJK>
0xF5EA	0x7E8B	# <CJK>
0xF5EB	0x7E86	# <CJK>
0xF5EC	0x7E8D	# <CJK>
0xF5ED	0x7F4D	# <CJK>
0xF5EE	0x7FBB	# <CJK>
0xF5EF	0x8030	# <CJK>
0xF5F0	0x81DD	# <CJK>
0xF5F1	0x8618	# <CJK>
0xF5F2	0x862A	# <CJK>
0xF5F3	0x8626	# <CJK>
0xF5F4	0x861F	# <CJK>
0xF5F5	0x8623	# <CJK>
0xF5F6	0x861C	# <CJK>
0xF5F7	0x8619	# <CJK>
0xF5F8	0x8627	# <CJK>
0xF5F9	0x862E	# <CJK>
0xF5FA	0x8621	# <CJK>
0xF5FB	0x8620	# <CJK>
0xF5FC	0x8629	# <CJK>
0xF5FD	0x861E	# <CJK>
0xF5FE	0x8625	# <CJK>
0xF640	0x8829	# <CJK>
0xF641	0x881D	# <CJK>
0xF642	0x881B	# <CJK>
0xF643	0x8820	# <CJK>
0xF644	0x8824	# <CJK>
0xF645	0x881C	# <CJK>
0xF646	0x882B	# <CJK>
0xF647	0x884A	# <CJK>
0xF648	0x896D	# <CJK>
0xF649	0x8969	# <CJK>
0xF64A	0x896E	# <CJK>
0xF64B	0x896B	# <CJK>
0xF64C	0x89FA	# <CJK>
0xF64D	0x8B79	# <CJK>
0xF64E	0x8B78	# <CJK>
0xF64F	0x8B45	# <CJK>
0xF650	0x8B7A	# <CJK>
0xF651	0x8B7B	# <CJK>
0xF652	0x8D10	# <CJK>
0xF653	0x8D14	# <CJK>
0xF654	0x8DAF	# <CJK>
0xF655	0x8E8E	# <CJK>
0xF656	0x8E8C	# <CJK>
0xF657	0x8F5E	# <CJK>
0xF658	0x8F5B	# <CJK>
0xF659	0x8F5D	# <CJK>
0xF65A	0x9146	# <CJK>
0xF65B	0x9144	# <CJK>
0xF65C	0x9145	# <CJK>
0xF65D	0x91B9	# <CJK>
0xF65E	0x943F	# <CJK>
0xF65F	0x943B	# <CJK>
0xF660	0x9436	# <CJK>
0xF661	0x9429	# <CJK>
0xF662	0x943D	# <CJK>
0xF663	0x943C	# <CJK>
0xF664	0x9430	# <CJK>
0xF665	0x9439	# <CJK>
0xF666	0x942A	# <CJK>
0xF667	0x9437	# <CJK>
0xF668	0x942C	# <CJK>
0xF669	0x9440	# <CJK>
0xF66A	0x9431	# <CJK>
0xF66B	0x95E5	# <CJK>
0xF66C	0x95E4	# <CJK>
0xF66D	0x95E3	# <CJK>
0xF66E	0x9735	# <CJK>
0xF66F	0x973A	# <CJK>
0xF670	0x97BF	# <CJK>
0xF671	0x97E1	# <CJK>
0xF672	0x9864	# <CJK>
0xF673	0x98C9	# <CJK>
0xF674	0x98C6	# <CJK>
0xF675	0x98C0	# <CJK>
0xF676	0x9958	# <CJK>
0xF677	0x9956	# <CJK>
0xF678	0x9A39	# <CJK>
0xF679	0x9A3D	# <CJK>
0xF67A	0x9A46	# <CJK>
0xF67B	0x9A44	# <CJK>
0xF67C	0x9A42	# <CJK>
0xF67D	0x9A41	# <CJK>
0xF67E	0x9A3A	# <CJK>
0xF6A1	0x9A3F	# <CJK>
0xF6A2	0x9ACD	# <CJK>
0xF6A3	0x9B15	# <CJK>
0xF6A4	0x9B17	# <CJK>
0xF6A5	0x9B18	# <CJK>
0xF6A6	0x9B16	# <CJK>
0xF6A7	0x9B3A	# <CJK>
0xF6A8	0x9B52	# <CJK>
0xF6A9	0x9C2B	# <CJK>
0xF6AA	0x9C1D	# <CJK>
0xF6AB	0x9C1C	# <CJK>
0xF6AC	0x9C2C	# <CJK>
0xF6AD	0x9C23	# <CJK>
0xF6AE	0x9C28	# <CJK>
0xF6AF	0x9C29	# <CJK>
0xF6B0	0x9C24	# <CJK>
0xF6B1	0x9C21	# <CJK>
0xF6B2	0x9DB7	# <CJK>
0xF6B3	0x9DB6	# <CJK>
0xF6B4	0x9DBC	# <CJK>
0xF6B5	0x9DC1	# <CJK>
0xF6B6	0x9DC7	# <CJK>
0xF6B7	0x9DCA	# <CJK>
0xF6B8	0x9DCF	# <CJK>
0xF6B9	0x9DBE	# <CJK>
0xF6BA	0x9DC5	# <CJK>
0xF6BB	0x9DC3	# <CJK>
0xF6BC	0x9DBB	# <CJK>
0xF6BD	0x9DB5	# <CJK>
0xF6BE	0x9DCE	# <CJK>
0xF6BF	0x9DB9	# <CJK>
0xF6C0	0x9DBA	# <CJK>
0xF6C1	0x9DAC	# <CJK>
0xF6C2	0x9DC8	# <CJK>
0xF6C3	0x9DB1	# <CJK>
0xF6C4	0x9DAD	# <CJK>
0xF6C5	0x9DCC	# <CJK>
0xF6C6	0x9DB3	# <CJK>
0xF6C7	0x9DCD	# <CJK>
0xF6C8	0x9DB2	# <CJK>
0xF6C9	0x9E7A	# <CJK>
0xF6CA	0x9E9C	# <CJK>
0xF6CB	0x9EEB	# <CJK>
0xF6CC	0x9EEE	# <CJK>
0xF6CD	0x9EED	# <CJK>
0xF6CE	0x9F1B	# <CJK>
0xF6CF	0x9F18	# <CJK>
0xF6D0	0x9F1A	# <CJK>
0xF6D1	0x9F31	# <CJK>
0xF6D2	0x9F4E	# <CJK>
0xF6D3	0x9F65	# <CJK>
0xF6D4	0x9F64	# <CJK>
0xF6D5	0x9F92	# <CJK>
0xF6D6	0x4EB9	# <CJK>
0xF6D7	0x56C6	# <CJK>
0xF6D8	0x56C5	# <CJK>
0xF6D9	0x56CB	# <CJK>
0xF6DA	0x5971	# <CJK>
0xF6DB	0x5B4B	# <CJK>
0xF6DC	0x5B4C	# <CJK>
0xF6DD	0x5DD5	# <CJK>
0xF6DE	0x5DD1	# <CJK>
0xF6DF	0x5EF2	# <CJK>
0xF6E0	0x6521	# <CJK>
0xF6E1	0x6520	# <CJK>
0xF6E2	0x6526	# <CJK>
0xF6E3	0x6522	# <CJK>
0xF6E4	0x6B0B	# <CJK>
0xF6E5	0x6B08	# <CJK>
0xF6E6	0x6B09	# <CJK>
0xF6E7	0x6C0D	# <CJK>
0xF6E8	0x7055	# <CJK>
0xF6E9	0x7056	# <CJK>
0xF6EA	0x7057	# <CJK>
0xF6EB	0x7052	# <CJK>
0xF6EC	0x721E	# <CJK>
0xF6ED	0x721F	# <CJK>
0xF6EE	0x72A9	# <CJK>
0xF6EF	0x737F	# <CJK>
0xF6F0	0x74D8	# <CJK>
0xF6F1	0x74D5	# <CJK>
0xF6F2	0x74D9	# <CJK>
0xF6F3	0x74D7	# <CJK>
0xF6F4	0x766D	# <CJK>
0xF6F5	0x76AD	# <CJK>
0xF6F6	0x7935	# <CJK>
0xF6F7	0x79B4	# <CJK>
0xF6F8	0x7A70	# <CJK>
0xF6F9	0x7A71	# <CJK>
0xF6FA	0x7C57	# <CJK>
0xF6FB	0x7C5C	# <CJK>
0xF6FC	0x7C59	# <CJK>
0xF6FD	0x7C5B	# <CJK>
0xF6FE	0x7C5A	# <CJK>
0xF740	0x7CF4	# <CJK>
0xF741	0x7CF1	# <CJK>
0xF742	0x7E91	# <CJK>
0xF743	0x7F4F	# <CJK>
0xF744	0x7F87	# <CJK>
0xF745	0x81DE	# <CJK>
0xF746	0x826B	# <CJK>
0xF747	0x8634	# <CJK>
0xF748	0x8635	# <CJK>
0xF749	0x8633	# <CJK>
0xF74A	0x862C	# <CJK>
0xF74B	0x8632	# <CJK>
0xF74C	0x8636	# <CJK>
0xF74D	0x882C	# <CJK>
0xF74E	0x8828	# <CJK>
0xF74F	0x8826	# <CJK>
0xF750	0x882A	# <CJK>
0xF751	0x8825	# <CJK>
0xF752	0x8971	# <CJK>
0xF753	0x89BF	# <CJK>
0xF754	0x89BE	# <CJK>
0xF755	0x89FB	# <CJK>
0xF756	0x8B7E	# <CJK>
0xF757	0x8B84	# <CJK>
0xF758	0x8B82	# <CJK>
0xF759	0x8B86	# <CJK>
0xF75A	0x8B85	# <CJK>
0xF75B	0x8B7F	# <CJK>
0xF75C	0x8D15	# <CJK>
0xF75D	0x8E95	# <CJK>
0xF75E	0x8E94	# <CJK>
0xF75F	0x8E9A	# <CJK>
0xF760	0x8E92	# <CJK>
0xF761	0x8E90	# <CJK>
0xF762	0x8E96	# <CJK>
0xF763	0x8E97	# <CJK>
0xF764	0x8F60	# <CJK>
0xF765	0x8F62	# <CJK>
0xF766	0x9147	# <CJK>
0xF767	0x944C	# <CJK>
0xF768	0x9450	# <CJK>
0xF769	0x944A	# <CJK>
0xF76A	0x944B	# <CJK>
0xF76B	0x944F	# <CJK>
0xF76C	0x9447	# <CJK>
0xF76D	0x9445	# <CJK>
0xF76E	0x9448	# <CJK>
0xF76F	0x9449	# <CJK>
0xF770	0x9446	# <CJK>
0xF771	0x973F	# <CJK>
0xF772	0x97E3	# <CJK>
0xF773	0x986A	# <CJK>
0xF774	0x9869	# <CJK>
0xF775	0x98CB	# <CJK>
0xF776	0x9954	# <CJK>
0xF777	0x995B	# <CJK>
0xF778	0x9A4E	# <CJK>
0xF779	0x9A53	# <CJK>
0xF77A	0x9A54	# <CJK>
0xF77B	0x9A4C	# <CJK>
0xF77C	0x9A4F	# <CJK>
0xF77D	0x9A48	# <CJK>
0xF77E	0x9A4A	# <CJK>
0xF7A1	0x9A49	# <CJK>
0xF7A2	0x9A52	# <CJK>
0xF7A3	0x9A50	# <CJK>
0xF7A4	0x9AD0	# <CJK>
0xF7A5	0x9B19	# <CJK>
0xF7A6	0x9B2B	# <CJK>
0xF7A7	0x9B3B	# <CJK>
0xF7A8	0x9B56	# <CJK>
0xF7A9	0x9B55	# <CJK>
0xF7AA	0x9C46	# <CJK>
0xF7AB	0x9C48	# <CJK>
0xF7AC	0x9C3F	# <CJK>
0xF7AD	0x9C44	# <CJK>
0xF7AE	0x9C39	# <CJK>
0xF7AF	0x9C33	# <CJK>
0xF7B0	0x9C41	# <CJK>
0xF7B1	0x9C3C	# <CJK>
0xF7B2	0x9C37	# <CJK>
0xF7B3	0x9C34	# <CJK>
0xF7B4	0x9C32	# <CJK>
0xF7B5	0x9C3D	# <CJK>
0xF7B6	0x9C36	# <CJK>
0xF7B7	0x9DDB	# <CJK>
0xF7B8	0x9DD2	# <CJK>
0xF7B9	0x9DDE	# <CJK>
0xF7BA	0x9DDA	# <CJK>
0xF7BB	0x9DCB	# <CJK>
0xF7BC	0x9DD0	# <CJK>
0xF7BD	0x9DDC	# <CJK>
0xF7BE	0x9DD1	# <CJK>
0xF7BF	0x9DDF	# <CJK>
0xF7C0	0x9DE9	# <CJK>
0xF7C1	0x9DD9	# <CJK>
0xF7C2	0x9DD8	# <CJK>
0xF7C3	0x9DD6	# <CJK>
0xF7C4	0x9DF5	# <CJK>
0xF7C5	0x9DD5	# <CJK>
0xF7C6	0x9DDD	# <CJK>
0xF7C7	0x9EB6	# <CJK>
0xF7C8	0x9EF0	# <CJK>
0xF7C9	0x9F35	# <CJK>
0xF7CA	0x9F33	# <CJK>
0xF7CB	0x9F32	# <CJK>
0xF7CC	0x9F42	# <CJK>
0xF7CD	0x9F6B	# <CJK>
0xF7CE	0x9F95	# <CJK>
0xF7CF	0x9FA2	# <CJK>
0xF7D0	0x513D	# <CJK>
0xF7D1	0x5299	# <CJK>
0xF7D2	0x58E8	# <CJK>
0xF7D3	0x58E7	# <CJK>
0xF7D4	0x5972	# <CJK>
0xF7D5	0x5B4D	# <CJK>
0xF7D6	0x5DD8	# <CJK>
0xF7D7	0x882F	# <CJK>
0xF7D8	0x5F4F	# <CJK>
0xF7D9	0x6201	# <CJK>
0xF7DA	0x6203	# <CJK>
0xF7DB	0x6204	# <CJK>
0xF7DC	0x6529	# <CJK>
0xF7DD	0x6525	# <CJK>
0xF7DE	0x6596	# <CJK>
0xF7DF	0x66EB	# <CJK>
0xF7E0	0x6B11	# <CJK>
0xF7E1	0x6B12	# <CJK>
0xF7E2	0x6B0F	# <CJK>
0xF7E3	0x6BCA	# <CJK>
0xF7E4	0x705B	# <CJK>
0xF7E5	0x705A	# <CJK>
0xF7E6	0x7222	# <CJK>
0xF7E7	0x7382	# <CJK>
0xF7E8	0x7381	# <CJK>
0xF7E9	0x7383	# <CJK>
0xF7EA	0x7670	# <CJK>
0xF7EB	0x77D4	# <CJK>
0xF7EC	0x7C67	# <CJK>
0xF7ED	0x7C66	# <CJK>
0xF7EE	0x7E95	# <CJK>
0xF7EF	0x826C	# <CJK>
0xF7F0	0x863A	# <CJK>
0xF7F1	0x8640	# <CJK>
0xF7F2	0x8639	# <CJK>
0xF7F3	0x863C	# <CJK>
0xF7F4	0x8631	# <CJK>
0xF7F5	0x863B	# <CJK>
0xF7F6	0x863E	# <CJK>
0xF7F7	0x8830	# <CJK>
0xF7F8	0x8832	# <CJK>
0xF7F9	0x882E	# <CJK>
0xF7FA	0x8833	# <CJK>
0xF7FB	0x8976	# <CJK>
0xF7FC	0x8974	# <CJK>
0xF7FD	0x8973	# <CJK>
0xF7FE	0x89FE	# <CJK>
0xF840	0x8B8C	# <CJK>
0xF841	0x8B8E	# <CJK>
0xF842	0x8B8B	# <CJK>
0xF843	0x8B88	# <CJK>
0xF844	0x8C45	# <CJK>
0xF845	0x8D19	# <CJK>
0xF846	0x8E98	# <CJK>
0xF847	0x8F64	# <CJK>
0xF848	0x8F63	# <CJK>
0xF849	0x91BC	# <CJK>
0xF84A	0x9462	# <CJK>
0xF84B	0x9455	# <CJK>
0xF84C	0x945D	# <CJK>
0xF84D	0x9457	# <CJK>
0xF84E	0x945E	# <CJK>
0xF84F	0x97C4	# <CJK>
0xF850	0x97C5	# <CJK>
0xF851	0x9800	# <CJK>
0xF852	0x9A56	# <CJK>
0xF853	0x9A59	# <CJK>
0xF854	0x9B1E	# <CJK>
0xF855	0x9B1F	# <CJK>
0xF856	0x9B20	# <CJK>
0xF857	0x9C52	# <CJK>
0xF858	0x9C58	# <CJK>
0xF859	0x9C50	# <CJK>
0xF85A	0x9C4A	# <CJK>
0xF85B	0x9C4D	# <CJK>
0xF85C	0x9C4B	# <CJK>
0xF85D	0x9C55	# <CJK>
0xF85E	0x9C59	# <CJK>
0xF85F	0x9C4C	# <CJK>
0xF860	0x9C4E	# <CJK>
0xF861	0x9DFB	# <CJK>
0xF862	0x9DF7	# <CJK>
0xF863	0x9DEF	# <CJK>
0xF864	0x9DE3	# <CJK>
0xF865	0x9DEB	# <CJK>
0xF866	0x9DF8	# <CJK>
0xF867	0x9DE4	# <CJK>
0xF868	0x9DF6	# <CJK>
0xF869	0x9DE1	# <CJK>
0xF86A	0x9DEE	# <CJK>
0xF86B	0x9DE6	# <CJK>
0xF86C	0x9DF2	# <CJK>
0xF86D	0x9DF0	# <CJK>
0xF86E	0x9DE2	# <CJK>
0xF86F	0x9DEC	# <CJK>
0xF870	0x9DF4	# <CJK>
0xF871	0x9DF3	# <CJK>
0xF872	0x9DE8	# <CJK>
0xF873	0x9DED	# <CJK>
0xF874	0x9EC2	# <CJK>
0xF875	0x9ED0	# <CJK>
0xF876	0x9EF2	# <CJK>
0xF877	0x9EF3	# <CJK>
0xF878	0x9F06	# <CJK>
0xF879	0x9F1C	# <CJK>
0xF87A	0x9F38	# <CJK>
0xF87B	0x9F37	# <CJK>
0xF87C	0x9F36	# <CJK>
0xF87D	0x9F43	# <CJK>
0xF87E	0x9F4F	# <CJK>
0xF8A1	0x9F71	# <CJK>
0xF8A2	0x9F70	# <CJK>
0xF8A3	0x9F6E	# <CJK>
0xF8A4	0x9F6F	# <CJK>
0xF8A5	0x56D3	# <CJK>
0xF8A6	0x56CD	# <CJK>
0xF8A7	0x5B4E	# <CJK>
0xF8A8	0x5C6D	# <CJK>
0xF8A9	0x652D	# <CJK>
0xF8AA	0x66ED	# <CJK>
0xF8AB	0x66EE	# <CJK>
0xF8AC	0x6B13	# <CJK>
0xF8AD	0x705F	# <CJK>
0xF8AE	0x7061	# <CJK>
0xF8AF	0x705D	# <CJK>
0xF8B0	0x7060	# <CJK>
0xF8B1	0x7223	# <CJK>
0xF8B2	0x74DB	# <CJK>
0xF8B3	0x74E5	# <CJK>
0xF8B4	0x77D5	# <CJK>
0xF8B5	0x7938	# <CJK>
0xF8B6	0x79B7	# <CJK>
0xF8B7	0x79B6	# <CJK>
0xF8B8	0x7C6A	# <CJK>
0xF8B9	0x7E97	# <CJK>
0xF8BA	0x7F89	# <CJK>
0xF8BB	0x826D	# <CJK>
0xF8BC	0x8643	# <CJK>
0xF8BD	0x8838	# <CJK>
0xF8BE	0x8837	# <CJK>
0xF8BF	0x8835	# <CJK>
0xF8C0	0x884B	# <CJK>
0xF8C1	0x8B94	# <CJK>
0xF8C2	0x8B95	# <CJK>
0xF8C3	0x8E9E	# <CJK>
0xF8C4	0x8E9F	# <CJK>
0xF8C5	0x8EA0	# <CJK>
0xF8C6	0x8E9D	# <CJK>
0xF8C7	0x91BE	# <CJK>
0xF8C8	0x91BD	# <CJK>
0xF8C9	0x91C2	# <CJK>
0xF8CA	0x946B	# <CJK>
0xF8CB	0x9468	# <CJK>
0xF8CC	0x9469	# <CJK>
0xF8CD	0x96E5	# <CJK>
0xF8CE	0x9746	# <CJK>
0xF8CF	0x9743	# <CJK>
0xF8D0	0x9747	# <CJK>
0xF8D1	0x97C7	# <CJK>
0xF8D2	0x97E5	# <CJK>
0xF8D3	0x9A5E	# <CJK>
0xF8D4	0x9AD5	# <CJK>
0xF8D5	0x9B59	# <CJK>
0xF8D6	0x9C63	# <CJK>
0xF8D7	0x9C67	# <CJK>
0xF8D8	0x9C66	# <CJK>
0xF8D9	0x9C62	# <CJK>
0xF8DA	0x9C5E	# <CJK>
0xF8DB	0x9C60	# <CJK>
0xF8DC	0x9E02	# <CJK>
0xF8DD	0x9DFE	# <CJK>
0xF8DE	0x9E07	# <CJK>
0xF8DF	0x9E03	# <CJK>
0xF8E0	0x9E06	# <CJK>
0xF8E1	0x9E05	# <CJK>
0xF8E2	0x9E00	# <CJK>
0xF8E3	0x9E01	# <CJK>
0xF8E4	0x9E09	# <CJK>
0xF8E5	0x9DFF	# <CJK>
0xF8E6	0x9DFD	# <CJK>
0xF8E7	0x9E04	# <CJK>
0xF8E8	0x9EA0	# <CJK>
0xF8E9	0x9F1E	# <CJK>
0xF8EA	0x9F46	# <CJK>
0xF8EB	0x9F74	# <CJK>
0xF8EC	0x9F75	# <CJK>
0xF8ED	0x9F76	# <CJK>
0xF8EE	0x56D4	# <CJK>
0xF8EF	0x652E	# <CJK>
0xF8F0	0x65B8	# <CJK>
0xF8F1	0x6B18	# <CJK>
0xF8F2	0x6B19	# <CJK>
0xF8F3	0x6B17	# <CJK>
0xF8F4	0x6B1A	# <CJK>
0xF8F5	0x7062	# <CJK>
0xF8F6	0x7226	# <CJK>
0xF8F7	0x72AA	# <CJK>
0xF8F8	0x77D8	# <CJK>
0xF8F9	0x77D9	# <CJK>
0xF8FA	0x7939	# <CJK>
0xF8FB	0x7C69	# <CJK>
0xF8FC	0x7C6B	# <CJK>
0xF8FD	0x7CF6	# <CJK>
0xF8FE	0x7E9A	# <CJK>
0xF940	0x7E98	# <CJK>
0xF941	0x7E9B	# <CJK>
0xF942	0x7E99	# <CJK>
0xF943	0x81E0	# <CJK>
0xF944	0x81E1	# <CJK>
0xF945	0x8646	# <CJK>
0xF946	0x8647	# <CJK>
0xF947	0x8648	# <CJK>
0xF948	0x8979	# <CJK>
0xF949	0x897A	# <CJK>
0xF94A	0x897C	# <CJK>
0xF94B	0x897B	# <CJK>
0xF94C	0x89FF	# <CJK>
0xF94D	0x8B98	# <CJK>
0xF94E	0x8B99	# <CJK>
0xF94F	0x8EA5	# <CJK>
0xF950	0x8EA4	# <CJK>
0xF951	0x8EA3	# <CJK>
0xF952	0x946E	# <CJK>
0xF953	0x946D	# <CJK>
0xF954	0x946F	# <CJK>
0xF955	0x9471	# <CJK>
0xF956	0x9473	# <CJK>
0xF957	0x9749	# <CJK>
0xF958	0x9872	# <CJK>
0xF959	0x995F	# <CJK>
0xF95A	0x9C68	# <CJK>
0xF95B	0x9C6E	# <CJK>
0xF95C	0x9C6D	# <CJK>
0xF95D	0x9E0B	# <CJK>
0xF95E	0x9E0D	# <CJK>
0xF95F	0x9E10	# <CJK>
0xF960	0x9E0F	# <CJK>
0xF961	0x9E12	# <CJK>
0xF962	0x9E11	# <CJK>
0xF963	0x9EA1	# <CJK>
0xF964	0x9EF5	# <CJK>
0xF965	0x9F09	# <CJK>
0xF966	0x9F47	# <CJK>
0xF967	0x9F78	# <CJK>
0xF968	0x9F7B	# <CJK>
0xF969	0x9F7A	# <CJK>
0xF96A	0x9F79	# <CJK>
0xF96B	0x571E	# <CJK>
0xF96C	0x7066	# <CJK>
0xF96D	0x7C6F	# <CJK>
0xF96E	0x883C	# <CJK>
0xF96F	0x8DB2	# <CJK>
0xF970	0x8EA6	# <CJK>
0xF971	0x91C3	# <CJK>
0xF972	0x9474	# <CJK>
0xF973	0x9478	# <CJK>
0xF974	0x9476	# <CJK>
0xF975	0x9475	# <CJK>
0xF976	0x9A60	# <CJK>
0xF977	0x9C74	# <CJK>
0xF978	0x9C73	# <CJK>
0xF979	0x9C71	# <CJK>
0xF97A	0x9C75	# <CJK>
0xF97B	0x9E14	# <CJK>
0xF97C	0x9E13	# <CJK>
0xF97D	0x9EF6	# <CJK>
0xF97E	0x9F0A	# <CJK>
0xF9A1	0x9FA4	# <CJK>
0xF9A2	0x7068	# <CJK>
0xF9A3	0x7065	# <CJK>
0xF9A4	0x7CF7	# <CJK>
0xF9A5	0x866A	# <CJK>
0xF9A6	0x883E	# <CJK>
0xF9A7	0x883D	# <CJK>
0xF9A8	0x883F	# <CJK>
0xF9A9	0x8B9E	# <CJK>
0xF9AA	0x8C9C	# <CJK>
0xF9AB	0x8EA9	# <CJK>
0xF9AC	0x8EC9	# <CJK>
0xF9AD	0x974B	# <CJK>
0xF9AE	0x9873	# <CJK>
0xF9AF	0x9874	# <CJK>
0xF9B0	0x98CC	# <CJK>
0xF9B1	0x9961	# <CJK>
0xF9B2	0x99AB	# <CJK>
0xF9B3	0x9A64	# <CJK>
0xF9B4	0x9A66	# <CJK>
0xF9B5	0x9A67	# <CJK>
0xF9B6	0x9B24	# <CJK>
0xF9B7	0x9E15	# <CJK>
0xF9B8	0x9E17	# <CJK>
0xF9B9	0x9F48	# <CJK>
0xF9BA	0x6207	# <CJK>
0xF9BB	0x6B1E	# <CJK>
0xF9BC	0x7227	# <CJK>
0xF9BD	0x864C	# <CJK>
0xF9BE	0x8EA8	# <CJK>
0xF9BF	0x9482	# <CJK>
0xF9C0	0x9480	# <CJK>
0xF9C1	0x9481	# <CJK>
0xF9C2	0x9A69	# <CJK>
0xF9C3	0x9A68	# <CJK>
0xF9C4	0x9B2E	# <CJK>
0xF9C5	0x9E19	# <CJK>
0xF9C6	0x7229	# <CJK>
0xF9C7	0x864B	# <CJK>
0xF9C8	0x8B9F	# <CJK>
0xF9C9	0x9483	# <CJK>
0xF9CA	0x9C79	# <CJK>
0xF9CB	0x9EB7	# <CJK>
0xF9CC	0x7675	# <CJK>
0xF9CD	0x9A6B	# <CJK>
0xF9CE	0x9C7A	# <CJK>
0xF9CF	0x9E1D	# <CJK>
0xF9D0	0x7069	# <CJK>
0xF9D1	0x706A	# <CJK>
0xF9D2	0x9EA4	# <CJK>
0xF9D3	0x9F7E	# <CJK>
0xF9D4	0x9F49	# <CJK>
0xF9D5	0x9F98	# <CJK>
 * The contents of this file are subject to the Interbase Public
 * License Version 1.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy
 * of the License at http://www.Inprise.com/IPL.html
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code was created by Inprise Corporation
 * and its predecessors. Portions created by Inprise Corporation are
 * Copyright (C) Inprise Corporation.
 *
 * All Rights Reserved.
 * Contributor(s): ______________________________________.
   -------------------------------------------- */


#ifndef UNICODE_REPLACEMENT_CHARACTER
#define UNICODE_REPLACEMENT_CHARACTER 0xFFFD
#endif

static CONST USHORT FAR_VARIABLE to_unicode_mapping_array[] = {
/* U+XX00 */	UNICODE_REPLACEMENT_CHARACTER,	/* 0 */
/* U+XX01 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1 */
/* U+XX02 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2 */
/* U+XX03 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3 */
/* U+XX04 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4 */
/* U+XX05 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5 */
/* U+XX06 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6 */
/* U+XX07 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7 */
/* U+XX08 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8 */
/* U+XX09 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9 */
/* U+XX0A */	UNICODE_REPLACEMENT_CHARACTER,	/* 10 */
/* U+XX0B */	UNICODE_REPLACEMENT_CHARACTER,	/* 11 */
/* U+XX0C */	UNICODE_REPLACEMENT_CHARACTER,	/* 12 */
/* U+XX0D */	UNICODE_REPLACEMENT_CHARACTER,	/* 13 */
/* U+XX0E */	UNICODE_REPLACEMENT_CHARACTER,	/* 14 */
/* U+XX0F */	UNICODE_REPLACEMENT_CHARACTER,	/* 15 */
/* U+XX10 */	UNICODE_REPLACEMENT_CHARACTER,	/* 16 */
/* U+XX11 */	UNICODE_REPLACEMENT_CHARACTER,	/* 17 */
/* U+XX12 */	UNICODE_REPLACEMENT_CHARACTER,	/* 18 */
/* U+XX13 */	UNICODE_REPLACEMENT_CHARACTER,	/* 19 */
/* U+XX14 */	UNICODE_REPLACEMENT_CHARACTER,	/* 20 */
/* U+XX15 */	UNICODE_REPLACEMENT_CHARACTER,	/* 21 */
/* U+XX16 */	UNICODE_REPLACEMENT_CHARACTER,	/* 22 */
/* U+XX17 */	UNICODE_REPLACEMENT_CHARACTER,	/* 23 */
/* U+XX18 */	UNICODE_REPLACEMENT_CHARACTER,	/* 24 */
/* U+XX19 */	UNICODE_REPLACEMENT_CHARACTER,	/* 25 */
/* U+XX1A */	UNICODE_REPLACEMENT_CHARACTER,	/* 26 */
/* U+XX1B */	UNICODE_REPLACEMENT_CHARACTER,	/* 27 */
/* U+XX1C */	UNICODE_REPLACEMENT_CHARACTER,	/* 28 */
/* U+XX1D */	UNICODE_REPLACEMENT_CHARACTER,	/* 29 */
/* U+XX1E */	UNICODE_REPLACEMENT_CHARACTER,	/* 30 */
/* U+XX1F */	UNICODE_REPLACEMENT_CHARACTER,	/* 31 */
/* U+XX20 */	UNICODE_REPLACEMENT_CHARACTER,	/* 32 */
/* U+XX21 */	UNICODE_REPLACEMENT_CHARACTER,	/* 33 */
/* U+XX22 */	UNICODE_REPLACEMENT_CHARACTER,	/* 34 */
/* U+XX23 */	UNICODE_REPLACEMENT_CHARACTER,	/* 35 */
/* U+XX24 */	UNICODE_REPLACEMENT_CHARACTER,	/* 36 */
/* U+XX25 */	UNICODE_REPLACEMENT_CHARACTER,	/* 37 */
/* U+XX26 */	UNICODE_REPLACEMENT_CHARACTER,	/* 38 */
/* U+XX27 */	UNICODE_REPLACEMENT_CHARACTER,	/* 39 */
/* U+XX28 */	UNICODE_REPLACEMENT_CHARACTER,	/* 40 */
/* U+XX29 */	UNICODE_REPLACEMENT_CHARACTER,	/* 41 */
/* U+XX2A */	UNICODE_REPLACEMENT_CHARACTER,	/* 42 */
/* U+XX2B */	UNICODE_REPLACEMENT_CHARACTER,	/* 43 */
/* U+XX2C */	UNICODE_REPLACEMENT_CHARACTER,	/* 44 */
/* U+XX2D */	UNICODE_REPLACEMENT_CHARACTER,	/* 45 */
/* U+XX2E */	UNICODE_REPLACEMENT_CHARACTER,	/* 46 */
/* U+XX2F */	UNICODE_REPLACEMENT_CHARACTER,	/* 47 */
/* U+XX30 */	UNICODE_REPLACEMENT_CHARACTER,	/* 48 */
/* U+XX31 */	UNICODE_REPLACEMENT_CHARACTER,	/* 49 */
/* U+XX32 */	UNICODE_REPLACEMENT_CHARACTER,	/* 50 */
/* U+XX33 */	UNICODE_REPLACEMENT_CHARACTER,	/* 51 */
/* U+XX34 */	UNICODE_REPLACEMENT_CHARACTER,	/* 52 */
/* U+XX35 */	UNICODE_REPLACEMENT_CHARACTER,	/* 53 */
/* U+XX36 */	UNICODE_REPLACEMENT_CHARACTER,	/* 54 */
/* U+XX37 */	UNICODE_REPLACEMENT_CHARACTER,	/* 55 */
/* U+XX38 */	UNICODE_REPLACEMENT_CHARACTER,	/* 56 */
/* U+XX39 */	UNICODE_REPLACEMENT_CHARACTER,	/* 57 */
/* U+XX3A */	UNICODE_REPLACEMENT_CHARACTER,	/* 58 */
/* U+XX3B */	UNICODE_REPLACEMENT_CHARACTER,	/* 59 */
/* U+XX3C */	UNICODE_REPLACEMENT_CHARACTER,	/* 60 */
/* U+XX3D */	UNICODE_REPLACEMENT_CHARACTER,	/* 61 */
/* U+XX3E */	UNICODE_REPLACEMENT_CHARACTER,	/* 62 */
/* U+XX3F */	UNICODE_REPLACEMENT_CHARACTER,	/* 63 */
/* U+XX40 */	UNICODE_REPLACEMENT_CHARACTER,	/* 64 */
/* U+XX41 */	UNICODE_REPLACEMENT_CHARACTER,	/* 65 */
/* U+XX42 */	UNICODE_REPLACEMENT_CHARACTER,	/* 66 */
/* U+XX43 */	UNICODE_REPLACEMENT_CHARACTER,	/* 67 */
/* U+XX44 */	UNICODE_REPLACEMENT_CHARACTER,	/* 68 */
/* U+XX45 */	UNICODE_REPLACEMENT_CHARACTER,	/* 69 */
/* U+XX46 */	UNICODE_REPLACEMENT_CHARACTER,	/* 70 */
/* U+XX47 */	UNICODE_REPLACEMENT_CHARACTER,	/* 71 */
/* U+XX48 */	UNICODE_REPLACEMENT_CHARACTER,	/* 72 */
/* U+XX49 */	UNICODE_REPLACEMENT_CHARACTER,	/* 73 */
/* U+XX4A */	UNICODE_REPLACEMENT_CHARACTER,	/* 74 */
/* U+XX4B */	UNICODE_REPLACEMENT_CHARACTER,	/* 75 */
/* U+XX4C */	UNICODE_REPLACEMENT_CHARACTER,	/* 76 */
/* U+XX4D */	UNICODE_REPLACEMENT_CHARACTER,	/* 77 */
/* U+XX4E */	UNICODE_REPLACEMENT_CHARACTER,	/* 78 */
/* U+XX4F */	UNICODE_REPLACEMENT_CHARACTER,	/* 79 */
/* U+XX50 */	UNICODE_REPLACEMENT_CHARACTER,	/* 80 */
/* U+XX51 */	UNICODE_REPLACEMENT_CHARACTER,	/* 81 */
/* U+XX52 */	UNICODE_REPLACEMENT_CHARACTER,	/* 82 */
/* U+XX53 */	UNICODE_REPLACEMENT_CHARACTER,	/* 83 */
/* U+XX54 */	UNICODE_REPLACEMENT_CHARACTER,	/* 84 */
/* U+XX55 */	UNICODE_REPLACEMENT_CHARACTER,	/* 85 */
/* U+XX56 */	UNICODE_REPLACEMENT_CHARACTER,	/* 86 */
/* U+XX57 */	UNICODE_REPLACEMENT_CHARACTER,	/* 87 */
/* U+XX58 */	UNICODE_REPLACEMENT_CHARACTER,	/* 88 */
/* U+XX59 */	UNICODE_REPLACEMENT_CHARACTER,	/* 89 */
/* U+XX5A */	UNICODE_REPLACEMENT_CHARACTER,	/* 90 */
/* U+XX5B */	UNICODE_REPLACEMENT_CHARACTER,	/* 91 */
/* U+XX5C */	UNICODE_REPLACEMENT_CHARACTER,	/* 92 */
/* U+XX5D */	UNICODE_REPLACEMENT_CHARACTER,	/* 93 */
/* U+XX5E */	UNICODE_REPLACEMENT_CHARACTER,	/* 94 */
/* U+XX5F */	UNICODE_REPLACEMENT_CHARACTER,	/* 95 */
/* U+XX60 */	UNICODE_REPLACEMENT_CHARACTER,	/* 96 */
/* U+XX61 */	UNICODE_REPLACEMENT_CHARACTER,	/* 97 */
/* U+XX62 */	UNICODE_REPLACEMENT_CHARACTER,	/* 98 */
/* U+XX63 */	UNICODE_REPLACEMENT_CHARACTER,	/* 99 */
/* U+XX64 */	UNICODE_REPLACEMENT_CHARACTER,	/* 100 */
/* U+XX65 */	UNICODE_REPLACEMENT_CHARACTER,	/* 101 */
/* U+XX66 */	UNICODE_REPLACEMENT_CHARACTER,	/* 102 */
/* U+XX67 */	UNICODE_REPLACEMENT_CHARACTER,	/* 103 */
/* U+XX68 */	UNICODE_REPLACEMENT_CHARACTER,	/* 104 */
/* U+XX69 */	UNICODE_REPLACEMENT_CHARACTER,	/* 105 */
/* U+XX6A */	UNICODE_REPLACEMENT_CHARACTER,	/* 106 */
/* U+XX6B */	UNICODE_REPLACEMENT_CHARACTER,	/* 107 */
/* U+XX6C */	UNICODE_REPLACEMENT_CHARACTER,	/* 108 */
/* U+XX6D */	UNICODE_REPLACEMENT_CHARACTER,	/* 109 */
/* U+XX6E */	UNICODE_REPLACEMENT_CHARACTER,	/* 110 */
/* U+XX6F */	UNICODE_REPLACEMENT_CHARACTER,	/* 111 */
/* U+XX70 */	UNICODE_REPLACEMENT_CHARACTER,	/* 112 */
/* U+XX71 */	UNICODE_REPLACEMENT_CHARACTER,	/* 113 */
/* U+XX72 */	UNICODE_REPLACEMENT_CHARACTER,	/* 114 */
/* U+XX73 */	UNICODE_REPLACEMENT_CHARACTER,	/* 115 */
/* U+XX74 */	UNICODE_REPLACEMENT_CHARACTER,	/* 116 */
/* U+XX75 */	UNICODE_REPLACEMENT_CHARACTER,	/* 117 */
/* U+XX76 */	UNICODE_REPLACEMENT_CHARACTER,	/* 118 */
/* U+XX77 */	UNICODE_REPLACEMENT_CHARACTER,	/* 119 */
/* U+XX78 */	UNICODE_REPLACEMENT_CHARACTER,	/* 120 */
/* U+XX79 */	UNICODE_REPLACEMENT_CHARACTER,	/* 121 */
/* U+XX7A */	UNICODE_REPLACEMENT_CHARACTER,	/* 122 */
/* U+XX7B */	UNICODE_REPLACEMENT_CHARACTER,	/* 123 */
/* U+XX7C */	UNICODE_REPLACEMENT_CHARACTER,	/* 124 */
/* U+XX7D */	UNICODE_REPLACEMENT_CHARACTER,	/* 125 */
/* U+XX7E */	UNICODE_REPLACEMENT_CHARACTER,	/* 126 */
/* U+XX7F */	UNICODE_REPLACEMENT_CHARACTER,	/* 127 */
/* U+XX80 */	UNICODE_REPLACEMENT_CHARACTER,	/* 128 */
/* U+XX81 */	UNICODE_REPLACEMENT_CHARACTER,	/* 129 */
/* U+XX82 */	UNICODE_REPLACEMENT_CHARACTER,	/* 130 */
/* U+XX83 */	UNICODE_REPLACEMENT_CHARACTER,	/* 131 */
/* U+XX84 */	UNICODE_REPLACEMENT_CHARACTER,	/* 132 */
/* U+XX85 */	UNICODE_REPLACEMENT_CHARACTER,	/* 133 */
/* U+XX86 */	UNICODE_REPLACEMENT_CHARACTER,	/* 134 */
/* U+XX87 */	UNICODE_REPLACEMENT_CHARACTER,	/* 135 */
/* U+XX88 */	UNICODE_REPLACEMENT_CHARACTER,	/* 136 */
/* U+XX89 */	UNICODE_REPLACEMENT_CHARACTER,	/* 137 */
/* U+XX8A */	UNICODE_REPLACEMENT_CHARACTER,	/* 138 */
/* U+XX8B */	UNICODE_REPLACEMENT_CHARACTER,	/* 139 */
/* U+XX8C */	UNICODE_REPLACEMENT_CHARACTER,	/* 140 */
/* U+XX8D */	UNICODE_REPLACEMENT_CHARACTER,	/* 141 */
/* U+XX8E */	UNICODE_REPLACEMENT_CHARACTER,	/* 142 */
/* U+XX8F */	UNICODE_REPLACEMENT_CHARACTER,	/* 143 */
/* U+XX90 */	UNICODE_REPLACEMENT_CHARACTER,	/* 144 */
/* U+XX91 */	UNICODE_REPLACEMENT_CHARACTER,	/* 145 */
/* U+XX92 */	UNICODE_REPLACEMENT_CHARACTER,	/* 146 */
/* U+XX93 */	UNICODE_REPLACEMENT_CHARACTER,	/* 147 */
/* U+XX94 */	UNICODE_REPLACEMENT_CHARACTER,	/* 148 */
/* U+XX95 */	UNICODE_REPLACEMENT_CHARACTER,	/* 149 */
/* U+XX96 */	UNICODE_REPLACEMENT_CHARACTER,	/* 150 */
/* U+XX97 */	UNICODE_REPLACEMENT_CHARACTER,	/* 151 */
/* U+XX98 */	UNICODE_REPLACEMENT_CHARACTER,	/* 152 */
/* U+XX99 */	UNICODE_REPLACEMENT_CHARACTER,	/* 153 */
/* U+XX9A */	UNICODE_REPLACEMENT_CHARACTER,	/* 154 */
/* U+XX9B */	UNICODE_REPLACEMENT_CHARACTER,	/* 155 */
/* U+XX9C */	UNICODE_REPLACEMENT_CHARACTER,	/* 156 */
/* U+XX9D */	UNICODE_REPLACEMENT_CHARACTER,	/* 157 */
/* U+XX9E */	UNICODE_REPLACEMENT_CHARACTER,	/* 158 */
/* U+XX9F */	UNICODE_REPLACEMENT_CHARACTER,	/* 159 */
/* U+XXA0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 160 */
/* U+XXA1 */	UNICODE_REPLACEMENT_CHARACTER,	/* 161 */
/* U+XXA2 */	UNICODE_REPLACEMENT_CHARACTER,	/* 162 */
/* U+XXA3 */	UNICODE_REPLACEMENT_CHARACTER,	/* 163 */
/* U+XXA4 */	UNICODE_REPLACEMENT_CHARACTER,	/* 164 */
/* U+XXA5 */	UNICODE_REPLACEMENT_CHARACTER,	/* 165 */
/* U+XXA6 */	UNICODE_REPLACEMENT_CHARACTER,	/* 166 */
/* U+XXA7 */	UNICODE_REPLACEMENT_CHARACTER,	/* 167 */
/* U+XXA8 */	UNICODE_REPLACEMENT_CHARACTER,	/* 168 */
/* U+XXA9 */	UNICODE_REPLACEMENT_CHARACTER,	/* 169 */
/* U+XXAA */	UNICODE_REPLACEMENT_CHARACTER,	/* 170 */
/* U+XXAB */	UNICODE_REPLACEMENT_CHARACTER,	/* 171 */
/* U+XXAC */	UNICODE_REPLACEMENT_CHARACTER,	/* 172 */
/* U+XXAD */	UNICODE_REPLACEMENT_CHARACTER,	/* 173 */
/* U+XXAE */	UNICODE_REPLACEMENT_CHARACTER,	/* 174 */
/* U+XXAF */	UNICODE_REPLACEMENT_CHARACTER,	/* 175 */
/* U+XXB0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 176 */
/* U+XXB1 */	UNICODE_REPLACEMENT_CHARACTER,	/* 177 */
/* U+XXB2 */	UNICODE_REPLACEMENT_CHARACTER,	/* 178 */
/* U+XXB3 */	UNICODE_REPLACEMENT_CHARACTER,	/* 179 */
/* U+XXB4 */	UNICODE_REPLACEMENT_CHARACTER,	/* 180 */
/* U+XXB5 */	UNICODE_REPLACEMENT_CHARACTER,	/* 181 */
/* U+XXB6 */	UNICODE_REPLACEMENT_CHARACTER,	/* 182 */
/* U+XXB7 */	UNICODE_REPLACEMENT_CHARACTER,	/* 183 */
/* U+XXB8 */	UNICODE_REPLACEMENT_CHARACTER,	/* 184 */
/* U+XXB9 */	UNICODE_REPLACEMENT_CHARACTER,	/* 185 */
/* U+XXBA */	UNICODE_REPLACEMENT_CHARACTER,	/* 186 */
/* U+XXBB */	UNICODE_REPLACEMENT_CHARACTER,	/* 187 */
/* U+XXBC */	UNICODE_REPLACEMENT_CHARACTER,	/* 188 */
/* U+XXBD */	UNICODE_REPLACEMENT_CHARACTER,	/* 189 */
/* U+XXBE */	UNICODE_REPLACEMENT_CHARACTER,	/* 190 */
/* U+XXBF */	UNICODE_REPLACEMENT_CHARACTER,	/* 191 */
/* U+XXC0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 192 */
/* U+XXC1 */	UNICODE_REPLACEMENT_CHARACTER,	/* 193 */
/* U+XXC2 */	UNICODE_REPLACEMENT_CHARACTER,	/* 194 */
/* U+XXC3 */	UNICODE_REPLACEMENT_CHARACTER,	/* 195 */
/* U+XXC4 */	UNICODE_REPLACEMENT_CHARACTER,	/* 196 */
/* U+XXC5 */	UNICODE_REPLACEMENT_CHARACTER,	/* 197 */
/* U+XXC6 */	UNICODE_REPLACEMENT_CHARACTER,	/* 198 */
/* U+XXC7 */	UNICODE_REPLACEMENT_CHARACTER,	/* 199 */
/* U+XXC8 */	UNICODE_REPLACEMENT_CHARACTER,	/* 200 */
/* U+XXC9 */	UNICODE_REPLACEMENT_CHARACTER,	/* 201 */
/* U+XXCA */	UNICODE_REPLACEMENT_CHARACTER,	/* 202 */
/* U+XXCB */	UNICODE_REPLACEMENT_CHARACTER,	/* 203 */
/* U+XXCC */	UNICODE_REPLACEMENT_CHARACTER,	/* 204 */
/* U+XXCD */	UNICODE_REPLACEMENT_CHARACTER,	/* 205 */
/* U+XXCE */	UNICODE_REPLACEMENT_CHARACTER,	/* 206 */
/* U+XXCF */	UNICODE_REPLACEMENT_CHARACTER,	/* 207 */
/* U+XXD0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 208 */
/* U+XXD1 */	UNICODE_REPLACEMENT_CHARACTER,	/* 209 */
/* U+XXD2 */	UNICODE_REPLACEMENT_CHARACTER,	/* 210 */
/* U+XXD3 */	UNICODE_REPLACEMENT_CHARACTER,	/* 211 */
/* U+XXD4 */	UNICODE_REPLACEMENT_CHARACTER,	/* 212 */
/* U+XXD5 */	UNICODE_REPLACEMENT_CHARACTER,	/* 213 */
/* U+XXD6 */	UNICODE_REPLACEMENT_CHARACTER,	/* 214 */
/* U+XXD7 */	UNICODE_REPLACEMENT_CHARACTER,	/* 215 */
/* U+XXD8 */	UNICODE_REPLACEMENT_CHARACTER,	/* 216 */
/* U+XXD9 */	UNICODE_REPLACEMENT_CHARACTER,	/* 217 */
/* U+XXDA */	UNICODE_REPLACEMENT_CHARACTER,	/* 218 */
/* U+XXDB */	UNICODE_REPLACEMENT_CHARACTER,	/* 219 */
/* U+XXDC */	UNICODE_REPLACEMENT_CHARACTER,	/* 220 */
/* U+XXDD */	UNICODE_REPLACEMENT_CHARACTER,	/* 221 */
/* U+XXDE */	UNICODE_REPLACEMENT_CHARACTER,	/* 222 */
/* U+XXDF */	UNICODE_REPLACEMENT_CHARACTER,	/* 223 */
/* U+XXE0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 224 */
/* U+XXE1 */	UNICODE_REPLACEMENT_CHARACTER,	/* 225 */
/* U+XXE2 */	UNICODE_REPLACEMENT_CHARACTER,	/* 226 */
/* U+XXE3 */	UNICODE_REPLACEMENT_CHARACTER,	/* 227 */
/* U+XXE4 */	UNICODE_REPLACEMENT_CHARACTER,	/* 228 */
/* U+XXE5 */	UNICODE_REPLACEMENT_CHARACTER,	/* 229 */
/* U+XXE6 */	UNICODE_REPLACEMENT_CHARACTER,	/* 230 */
/* U+XXE7 */	UNICODE_REPLACEMENT_CHARACTER,	/* 231 */
/* U+XXE8 */	UNICODE_REPLACEMENT_CHARACTER,	/* 232 */
/* U+XXE9 */	UNICODE_REPLACEMENT_CHARACTER,	/* 233 */
/* U+XXEA */	UNICODE_REPLACEMENT_CHARACTER,	/* 234 */
/* U+XXEB */	UNICODE_REPLACEMENT_CHARACTER,	/* 235 */
/* U+XXEC */	UNICODE_REPLACEMENT_CHARACTER,	/* 236 */
/* U+XXED */	UNICODE_REPLACEMENT_CHARACTER,	/* 237 */
/* U+XXEE */	UNICODE_REPLACEMENT_CHARACTER,	/* 238 */
/* U+XXEF */	UNICODE_REPLACEMENT_CHARACTER,	/* 239 */
/* U+XXF0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 240 */
/* U+XXF1 */	UNICODE_REPLACEMENT_CHARACTER,	/* 241 */
/* U+XXF2 */	UNICODE_REPLACEMENT_CHARACTER,	/* 242 */
/* U+XXF3 */	UNICODE_REPLACEMENT_CHARACTER,	/* 243 */
/* U+XXF4 */	UNICODE_REPLACEMENT_CHARACTER,	/* 244 */
/* U+XXF5 */	UNICODE_REPLACEMENT_CHARACTER,	/* 245 */
/* U+XXF6 */	UNICODE_REPLACEMENT_CHARACTER,	/* 246 */
/* U+XXF7 */	UNICODE_REPLACEMENT_CHARACTER,	/* 247 */
/* U+XXF8 */	UNICODE_REPLACEMENT_CHARACTER,	/* 248 */
/* U+XXF9 */	UNICODE_REPLACEMENT_CHARACTER,	/* 249 */
/* U+XXFA */	UNICODE_REPLACEMENT_CHARACTER,	/* 250 */
/* U+XXFB */	UNICODE_REPLACEMENT_CHARACTER,	/* 251 */
/* U+XXFC */	UNICODE_REPLACEMENT_CHARACTER,	/* 252 */
/* U+XXFD */	UNICODE_REPLACEMENT_CHARACTER,	/* 253 */
/* U+XXFE */	UNICODE_REPLACEMENT_CHARACTER,	/* 254 */
/* U+XXFF */	UNICODE_REPLACEMENT_CHARACTER,	/* 255 */
/* U+0000 */	0x0000	/*                                         ASCII */,/* 256 */
/* U+0001 */	0x0001	/*                                         ASCII */,/* 257 */
/* U+0002 */	0x0002	/*                                         ASCII */,/* 258 */
/* U+0003 */	0x0003	/*                                         ASCII */,/* 259 */
/* U+0004 */	0x0004	/*                                         ASCII */,/* 260 */
/* U+0005 */	0x0005	/*                                         ASCII */,/* 261 */
/* U+0006 */	0x0006	/*                                         ASCII */,/* 262 */
/* U+0007 */	0x0007	/*                                         ASCII */,/* 263 */
/* U+0008 */	0x0008	/*                                         ASCII */,/* 264 */
/* U+0009 */	0x0009	/*                                         ASCII */,/* 265 */
/* U+000A */	0x000A	/*                                         ASCII */,/* 266 */
/* U+000B */	0x000B	/*                                         ASCII */,/* 267 */
/* U+000C */	0x000C	/*                                         ASCII */,/* 268 */
/* U+000D */	0x000D	/*                                         ASCII */,/* 269 */
/* U+000E */	0x000E	/*                                         ASCII */,/* 270 */
/* U+000F */	0x000F	/*                                         ASCII */,/* 271 */
/* U+0010 */	0x0010	/*                                         ASCII */,/* 272 */
/* U+0011 */	0x0011	/*                                         ASCII */,/* 273 */
/* U+0012 */	0x0012	/*                                         ASCII */,/* 274 */
/* U+0013 */	0x0013	/*                                         ASCII */,/* 275 */
/* U+0014 */	0x0014	/*                                         ASCII */,/* 276 */
/* U+0015 */	0x0015	/*                                         ASCII */,/* 277 */
/* U+0016 */	0x0016	/*                                         ASCII */,/* 278 */
/* U+0017 */	0x0017	/*                                         ASCII */,/* 279 */
/* U+0018 */	0x0018	/*                                         ASCII */,/* 280 */
/* U+0019 */	0x0019	/*                                         ASCII */,/* 281 */
/* U+001A */	0x001A	/*                                         ASCII */,/* 282 */
/* U+001B */	0x001B	/*                                         ASCII */,/* 283 */
/* U+001C */	0x001C	/*                                         ASCII */,/* 284 */
/* U+001D */	0x001D	/*                                         ASCII */,/* 285 */
/* U+001E */	0x001E	/*                                         ASCII */,/* 286 */
/* U+001F */	0x001F	/*                                         ASCII */,/* 287 */
/* U+0020 */	0x0020	/*                                         ASCII */,/* 288 */
/* U+0021 */	0x0021	/*                                         ASCII */,/* 289 */
/* U+0022 */	0x0022	/*                                         ASCII */,/* 290 */
/* U+0023 */	0x0023	/*                                         ASCII */,/* 291 */
/* U+0024 */	0x0024	/*                                         ASCII */,/* 292 */
/* U+0025 */	0x0025	/*                                         ASCII */,/* 293 */
/* U+0026 */	0x0026	/*                                         ASCII */,/* 294 */
/* U+0027 */	0x0027	/*                                         ASCII */,/* 295 */
/* U+0028 */	0x0028	/*                                         ASCII */,/* 296 */
/* U+0029 */	0x0029	/*                                         ASCII */,/* 297 */
/* U+002A */	0x002A	/*                                         ASCII */,/* 298 */
/* U+002B */	0x002B	/*                                         ASCII */,/* 299 */
/* U+002C */	0x002C	/*                                         ASCII */,/* 300 */
/* U+002D */	0x002D	/*                                         ASCII */,/* 301 */
/* U+002E */	0x002E	/*                                         ASCII */,/* 302 */
/* U+002F */	0x002F	/*                                         ASCII */,/* 303 */
/* U+0030 */	0x0030	/*                                         ASCII */,/* 304 */
/* U+0031 */	0x0031	/*                                         ASCII */,/* 305 */
/* U+0032 */	0x0032	/*                                         ASCII */,/* 306 */
/* U+0033 */	0x0033	/*                                         ASCII */,/* 307 */
/* U+0034 */	0x0034	/*                                         ASCII */,/* 308 */
/* U+0035 */	0x0035	/*                                         ASCII */,/* 309 */
/* U+0036 */	0x0036	/*                                         ASCII */,/* 310 */
/* U+0037 */	0x0037	/*                                         ASCII */,/* 311 */
/* U+0038 */	0x0038	/*                                         ASCII */,/* 312 */
/* U+0039 */	0x0039	/*                                         ASCII */,/* 313 */
/* U+003A */	0x003A	/*                                         ASCII */,/* 314 */
/* U+003B */	0x003B	/*                                         ASCII */,/* 315 */
/* U+003C */	0x003C	/*                                         ASCII */,/* 316 */
/* U+003D */	0x003D	/*                                         ASCII */,/* 317 */
/* U+003E */	0x003E	/*                                         ASCII */,/* 318 */
/* U+003F */	0x003F	/*                                         ASCII */,/* 319 */
/* U+0040 */	0x0040	/*                                         ASCII */,/* 320 */
/* U+0041 */	0x0041	/*                                         ASCII */,/* 321 */
/* U+0042 */	0x0042	/*                                         ASCII */,/* 322 */
/* U+0043 */	0x0043	/*                                         ASCII */,/* 323 */
/* U+0044 */	0x0044	/*                                         ASCII */,/* 324 */
/* U+0045 */	0x0045	/*                                         ASCII */,/* 325 */
/* U+0046 */	0x0046	/*                                         ASCII */,/* 326 */
/* U+0047 */	0x0047	/*                                         ASCII */,/* 327 */
/* U+0048 */	0x0048	/*                                         ASCII */,/* 328 */
/* U+0049 */	0x0049	/*                                         ASCII */,/* 329 */
/* U+004A */	0x004A	/*                                         ASCII */,/* 330 */
/* U+004B */	0x004B	/*                                         ASCII */,/* 331 */
/* U+004C */	0x004C	/*                                         ASCII */,/* 332 */
/* U+004D */	0x004D	/*                                         ASCII */,/* 333 */
/* U+004E */	0x004E	/*                                         ASCII */,/* 334 */
/* U+004F */	0x004F	/*                                         ASCII */,/* 335 */
/* U+0050 */	0x0050	/*                                         ASCII */,/* 336 */
/* U+0051 */	0x0051	/*                                         ASCII */,/* 337 */
/* U+0052 */	0x0052	/*                                         ASCII */,/* 338 */
/* U+0053 */	0x0053	/*                                         ASCII */,/* 339 */
/* U+0054 */	0x0054	/*                                         ASCII */,/* 340 */
/* U+0055 */	0x0055	/*                                         ASCII */,/* 341 */
/* U+0056 */	0x0056	/*                                         ASCII */,/* 342 */
/* U+0057 */	0x0057	/*                                         ASCII */,/* 343 */
/* U+0058 */	0x0058	/*                                         ASCII */,/* 344 */
/* U+0059 */	0x0059	/*                                         ASCII */,/* 345 */
/* U+005A */	0x005A	/*                                         ASCII */,/* 346 */
/* U+005B */	0x005B	/*                                         ASCII */,/* 347 */
/* U+005C */	0x005C	/*                                         ASCII */,/* 348 */
/* U+005D */	0x005D	/*                                         ASCII */,/* 349 */
/* U+005E */	0x005E	/*                                         ASCII */,/* 350 */
/* U+005F */	0x005F	/*                                         ASCII */,/* 351 */
/* U+0060 */	0x0060	/*                                         ASCII */,/* 352 */
/* U+0061 */	0x0061	/*                                         ASCII */,/* 353 */
/* U+0062 */	0x0062	/*                                         ASCII */,/* 354 */
/* U+0063 */	0x0063	/*                                         ASCII */,/* 355 */
/* U+0064 */	0x0064	/*                                         ASCII */,/* 356 */
/* U+0065 */	0x0065	/*                                         ASCII */,/* 357 */
/* U+0066 */	0x0066	/*                                         ASCII */,/* 358 */
/* U+0067 */	0x0067	/*                                         ASCII */,/* 359 */
/* U+0068 */	0x0068	/*                                         ASCII */,/* 360 */
/* U+0069 */	0x0069	/*                                         ASCII */,/* 361 */
/* U+006A */	0x006A	/*                                         ASCII */,/* 362 */
/* U+006B */	0x006B	/*                                         ASCII */,/* 363 */
/* U+006C */	0x006C	/*                                         ASCII */,/* 364 */
/* U+006D */	0x006D	/*                                         ASCII */,/* 365 */
/* U+006E */	0x006E	/*                                         ASCII */,/* 366 */
/* U+006F */	0x006F	/*                                         ASCII */,/* 367 */
/* U+0070 */	0x0070	/*                                         ASCII */,/* 368 */
/* U+0071 */	0x0071	/*                                         ASCII */,/* 369 */
/* U+0072 */	0x0072	/*                                         ASCII */,/* 370 */
/* U+0073 */	0x0073	/*                                         ASCII */,/* 371 */
/* U+0074 */	0x0074	/*                                         ASCII */,/* 372 */
/* U+0075 */	0x0075	/*                                         ASCII */,/* 373 */
/* U+0076 */	0x0076	/*                                         ASCII */,/* 374 */
/* U+0077 */	0x0077	/*                                         ASCII */,/* 375 */
/* U+0078 */	0x0078	/*                                         ASCII */,/* 376 */
/* U+0079 */	0x0079	/*                                         ASCII */,/* 377 */
/* U+007A */	0x007A	/*                                         ASCII */,/* 378 */
/* U+007B */	0x007B	/*                                         ASCII */,/* 379 */
/* U+007C */	0x007C	/*                                         ASCII */,/* 380 */
/* U+007D */	0x007D	/*                                         ASCII */,/* 381 */
/* U+007E */	0x007E	/*                                         ASCII */,/* 382 */
/* U+007F */	0x007F	/*                                         ASCII */,/* 383 */
/* U+0080 */	UNICODE_REPLACEMENT_CHARACTER,	/* 384 */
/* U+0081 */	UNICODE_REPLACEMENT_CHARACTER,	/* 385 */
/* U+0082 */	UNICODE_REPLACEMENT_CHARACTER,	/* 386 */
/* U+0083 */	UNICODE_REPLACEMENT_CHARACTER,	/* 387 */
/* U+0084 */	UNICODE_REPLACEMENT_CHARACTER,	/* 388 */
/* U+0085 */	UNICODE_REPLACEMENT_CHARACTER,	/* 389 */
/* U+0086 */	UNICODE_REPLACEMENT_CHARACTER,	/* 390 */
/* U+0087 */	UNICODE_REPLACEMENT_CHARACTER,	/* 391 */
/* U+0088 */	UNICODE_REPLACEMENT_CHARACTER,	/* 392 */
/* U+0089 */	UNICODE_REPLACEMENT_CHARACTER,	/* 393 */
/* U+008A */	UNICODE_REPLACEMENT_CHARACTER,	/* 394 */
/* U+008B */	UNICODE_REPLACEMENT_CHARACTER,	/* 395 */
/* U+008C */	UNICODE_REPLACEMENT_CHARACTER,	/* 396 */
/* U+008D */	UNICODE_REPLACEMENT_CHARACTER,	/* 397 */
/* U+008E */	UNICODE_REPLACEMENT_CHARACTER,	/* 398 */
/* U+008F */	UNICODE_REPLACEMENT_CHARACTER,	/* 399 */
/* U+0090 */	UNICODE_REPLACEMENT_CHARACTER,	/* 400 */
/* U+0091 */	UNICODE_REPLACEMENT_CHARACTER,	/* 401 */
/* U+0092 */	UNICODE_REPLACEMENT_CHARACTER,	/* 402 */
/* U+0093 */	UNICODE_REPLACEMENT_CHARACTER,	/* 403 */
/* U+0094 */	UNICODE_REPLACEMENT_CHARACTER,	/* 404 */
/* U+0095 */	UNICODE_REPLACEMENT_CHARACTER,	/* 405 */
/* U+0096 */	UNICODE_REPLACEMENT_CHARACTER,	/* 406 */
/* U+0097 */	UNICODE_REPLACEMENT_CHARACTER,	/* 407 */
/* U+0098 */	UNICODE_REPLACEMENT_CHARACTER,	/* 408 */
/* U+0099 */	UNICODE_REPLACEMENT_CHARACTER,	/* 409 */
/* U+009A */	UNICODE_REPLACEMENT_CHARACTER,	/* 410 */
/* U+009B */	UNICODE_REPLACEMENT_CHARACTER,	/* 411 */
/* U+009C */	UNICODE_REPLACEMENT_CHARACTER,	/* 412 */
/* U+009D */	UNICODE_REPLACEMENT_CHARACTER,	/* 413 */
/* U+009E */	UNICODE_REPLACEMENT_CHARACTER,	/* 414 */
/* U+009F */	UNICODE_REPLACEMENT_CHARACTER,	/* 415 */
/* U+00A0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 416 */
/* U+00A1 */	UNICODE_REPLACEMENT_CHARACTER,	/* 417 */
/* U+00A2 */	UNICODE_REPLACEMENT_CHARACTER,	/* 418 */
/* U+00A3 */	UNICODE_REPLACEMENT_CHARACTER,	/* 419 */
/* U+00A4 */	UNICODE_REPLACEMENT_CHARACTER,	/* 420 */
/* U+00A5 */	UNICODE_REPLACEMENT_CHARACTER,	/* 421 */
/* U+00A6 */	UNICODE_REPLACEMENT_CHARACTER,	/* 422 */
/* U+00A7 */	UNICODE_REPLACEMENT_CHARACTER,	/* 423 */
/* U+00A8 */	UNICODE_REPLACEMENT_CHARACTER,	/* 424 */
/* U+00A9 */	UNICODE_REPLACEMENT_CHARACTER,	/* 425 */
/* U+00AA */	UNICODE_REPLACEMENT_CHARACTER,	/* 426 */
/* U+00AB */	UNICODE_REPLACEMENT_CHARACTER,	/* 427 */
/* U+00AC */	UNICODE_REPLACEMENT_CHARACTER,	/* 428 */
/* U+00AD */	UNICODE_REPLACEMENT_CHARACTER,	/* 429 */
/* U+00AE */	UNICODE_REPLACEMENT_CHARACTER,	/* 430 */
/* U+00AF */	UNICODE_REPLACEMENT_CHARACTER,	/* 431 */
/* U+00B0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 432 */
/* U+00B1 */	UNICODE_REPLACEMENT_CHARACTER,	/* 433 */
/* U+00B2 */	UNICODE_REPLACEMENT_CHARACTER,	/* 434 */
/* U+00B3 */	UNICODE_REPLACEMENT_CHARACTER,	/* 435 */
/* U+00B4 */	UNICODE_REPLACEMENT_CHARACTER,	/* 436 */
/* U+00B5 */	UNICODE_REPLACEMENT_CHARACTER,	/* 437 */
/* U+00B6 */	UNICODE_REPLACEMENT_CHARACTER,	/* 438 */
/* U+00B7 */	UNICODE_REPLACEMENT_CHARACTER,	/* 439 */
/* U+00B8 */	UNICODE_REPLACEMENT_CHARACTER,	/* 440 */
/* U+00B9 */	UNICODE_REPLACEMENT_CHARACTER,	/* 441 */
/* U+00BA */	UNICODE_REPLACEMENT_CHARACTER,	/* 442 */
/* U+00BB */	UNICODE_REPLACEMENT_CHARACTER,	/* 443 */
/* U+00BC */	UNICODE_REPLACEMENT_CHARACTER,	/* 444 */
/* U+00BD */	UNICODE_REPLACEMENT_CHARACTER,	/* 445 */
/* U+00BE */	UNICODE_REPLACEMENT_CHARACTER,	/* 446 */
/* U+00BF */	UNICODE_REPLACEMENT_CHARACTER,	/* 447 */
/* U+00C0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 448 */
/* U+00C1 */	UNICODE_REPLACEMENT_CHARACTER,	/* 449 */
/* U+00C2 */	UNICODE_REPLACEMENT_CHARACTER,	/* 450 */
/* U+00C3 */	UNICODE_REPLACEMENT_CHARACTER,	/* 451 */
/* U+00C4 */	UNICODE_REPLACEMENT_CHARACTER,	/* 452 */
/* U+00C5 */	UNICODE_REPLACEMENT_CHARACTER,	/* 453 */
/* U+00C6 */	UNICODE_REPLACEMENT_CHARACTER,	/* 454 */
/* U+00C7 */	UNICODE_REPLACEMENT_CHARACTER,	/* 455 */
/* U+00C8 */	UNICODE_REPLACEMENT_CHARACTER,	/* 456 */
/* U+00C9 */	UNICODE_REPLACEMENT_CHARACTER,	/* 457 */
/* U+00CA */	UNICODE_REPLACEMENT_CHARACTER,	/* 458 */
/* U+00CB */	UNICODE_REPLACEMENT_CHARACTER,	/* 459 */
/* U+00CC */	UNICODE_REPLACEMENT_CHARACTER,	/* 460 */
/* U+00CD */	UNICODE_REPLACEMENT_CHARACTER,	/* 461 */
/* U+00CE */	UNICODE_REPLACEMENT_CHARACTER,	/* 462 */
/* U+00CF */	UNICODE_REPLACEMENT_CHARACTER,	/* 463 */
/* U+00D0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 464 */
/* U+00D1 */	UNICODE_REPLACEMENT_CHARACTER,	/* 465 */
/* U+00D2 */	UNICODE_REPLACEMENT_CHARACTER,	/* 466 */
/* U+00D3 */	UNICODE_REPLACEMENT_CHARACTER,	/* 467 */
/* U+00D4 */	UNICODE_REPLACEMENT_CHARACTER,	/* 468 */
/* U+00D5 */	UNICODE_REPLACEMENT_CHARACTER,	/* 469 */
/* U+00D6 */	UNICODE_REPLACEMENT_CHARACTER,	/* 470 */
/* U+00D7 */	UNICODE_REPLACEMENT_CHARACTER,	/* 471 */
/* U+00D8 */	UNICODE_REPLACEMENT_CHARACTER,	/* 472 */
/* U+00D9 */	UNICODE_REPLACEMENT_CHARACTER,	/* 473 */
/* U+00DA */	UNICODE_REPLACEMENT_CHARACTER,	/* 474 */
/* U+00DB */	UNICODE_REPLACEMENT_CHARACTER,	/* 475 */
/* U+00DC */	UNICODE_REPLACEMENT_CHARACTER,	/* 476 */
/* U+00DD */	UNICODE_REPLACEMENT_CHARACTER,	/* 477 */
/* U+00DE */	UNICODE_REPLACEMENT_CHARACTER,	/* 478 */
/* U+00DF */	UNICODE_REPLACEMENT_CHARACTER,	/* 479 */
/* U+00E0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 480 */
/* U+00E1 */	UNICODE_REPLACEMENT_CHARACTER,	/* 481 */
/* U+00E2 */	UNICODE_REPLACEMENT_CHARACTER,	/* 482 */
/* U+00E3 */	UNICODE_REPLACEMENT_CHARACTER,	/* 483 */
/* U+00E4 */	UNICODE_REPLACEMENT_CHARACTER,	/* 484 */
/* U+00E5 */	UNICODE_REPLACEMENT_CHARACTER,	/* 485 */
/* U+00E6 */	UNICODE_REPLACEMENT_CHARACTER,	/* 486 */
/* U+00E7 */	UNICODE_REPLACEMENT_CHARACTER,	/* 487 */
/* U+00E8 */	UNICODE_REPLACEMENT_CHARACTER,	/* 488 */
/* U+00E9 */	UNICODE_REPLACEMENT_CHARACTER,	/* 489 */
/* U+00EA */	UNICODE_REPLACEMENT_CHARACTER,	/* 490 */
/* U+00EB */	UNICODE_REPLACEMENT_CHARACTER,	/* 491 */
/* U+00EC */	UNICODE_REPLACEMENT_CHARACTER,	/* 492 */
/* U+00ED */	UNICODE_REPLACEMENT_CHARACTER,	/* 493 */
/* U+00EE */	UNICODE_REPLACEMENT_CHARACTER,	/* 494 */
/* U+00EF */	UNICODE_REPLACEMENT_CHARACTER,	/* 495 */
/* U+00F0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 496 */
/* U+00F1 */	UNICODE_REPLACEMENT_CHARACTER,	/* 497 */
/* U+00F2 */	UNICODE_REPLACEMENT_CHARACTER,	/* 498 */
/* U+00F3 */	UNICODE_REPLACEMENT_CHARACTER,	/* 499 */
/* U+00F4 */	UNICODE_REPLACEMENT_CHARACTER,	/* 500 */
/* U+00F5 */	UNICODE_REPLACEMENT_CHARACTER,	/* 501 */
/* U+00F6 */	UNICODE_REPLACEMENT_CHARACTER,	/* 502 */
/* U+00F7 */	UNICODE_REPLACEMENT_CHARACTER,	/* 503 */
/* U+00F8 */	UNICODE_REPLACEMENT_CHARACTER,	/* 504 */
/* U+00F9 */	UNICODE_REPLACEMENT_CHARACTER,	/* 505 */
/* U+00FA */	UNICODE_REPLACEMENT_CHARACTER,	/* 506 */
/* U+00FB */	UNICODE_REPLACEMENT_CHARACTER,	/* 507 */
/* U+00FC */	UNICODE_REPLACEMENT_CHARACTER,	/* 508 */
/* U+00FD */	UNICODE_REPLACEMENT_CHARACTER,	/* 509 */
/* U+00FE */	UNICODE_REPLACEMENT_CHARACTER,	/* 510 */
/* U+00FF */	UNICODE_REPLACEMENT_CHARACTER,	/* 511 */
/* U+A100 */	UNICODE_REPLACEMENT_CHARACTER,	/* 512 */
/* U+A101 */	UNICODE_REPLACEMENT_CHARACTER,	/* 513 */
/* U+A102 */	UNICODE_REPLACEMENT_CHARACTER,	/* 514 */
/* U+A103 */	UNICODE_REPLACEMENT_CHARACTER,	/* 515 */
/* U+A104 */	UNICODE_REPLACEMENT_CHARACTER,	/* 516 */
/* U+A105 */	UNICODE_REPLACEMENT_CHARACTER,	/* 517 */
/* U+A106 */	UNICODE_REPLACEMENT_CHARACTER,	/* 518 */
/* U+A107 */	UNICODE_REPLACEMENT_CHARACTER,	/* 519 */
/* U+A108 */	UNICODE_REPLACEMENT_CHARACTER,	/* 520 */
/* U+A109 */	UNICODE_REPLACEMENT_CHARACTER,	/* 521 */
/* U+A10A */	UNICODE_REPLACEMENT_CHARACTER,	/* 522 */
/* U+A10B */	UNICODE_REPLACEMENT_CHARACTER,	/* 523 */
/* U+A10C */	UNICODE_REPLACEMENT_CHARACTER,	/* 524 */
/* U+A10D */	UNICODE_REPLACEMENT_CHARACTER,	/* 525 */
/* U+A10E */	UNICODE_REPLACEMENT_CHARACTER,	/* 526 */
/* U+A10F */	UNICODE_REPLACEMENT_CHARACTER,	/* 527 */
/* U+A110 */	UNICODE_REPLACEMENT_CHARACTER,	/* 528 */
/* U+A111 */	UNICODE_REPLACEMENT_CHARACTER,	/* 529 */
/* U+A112 */	UNICODE_REPLACEMENT_CHARACTER,	/* 530 */
/* U+A113 */	UNICODE_REPLACEMENT_CHARACTER,	/* 531 */
/* U+A114 */	UNICODE_REPLACEMENT_CHARACTER,	/* 532 */
/* U+A115 */	UNICODE_REPLACEMENT_CHARACTER,	/* 533 */
/* U+A116 */	UNICODE_REPLACEMENT_CHARACTER,	/* 534 */
/* U+A117 */	UNICODE_REPLACEMENT_CHARACTER,	/* 535 */
/* U+A118 */	UNICODE_REPLACEMENT_CHARACTER,	/* 536 */
/* U+A119 */	UNICODE_REPLACEMENT_CHARACTER,	/* 537 */
/* U+A11A */	UNICODE_REPLACEMENT_CHARACTER,	/* 538 */
/* U+A11B */	UNICODE_REPLACEMENT_CHARACTER,	/* 539 */
/* U+A11C */	UNICODE_REPLACEMENT_CHARACTER,	/* 540 */
/* U+A11D */	UNICODE_REPLACEMENT_CHARACTER,	/* 541 */
/* U+A11E */	UNICODE_REPLACEMENT_CHARACTER,	/* 542 */
/* U+A11F */	UNICODE_REPLACEMENT_CHARACTER,	/* 543 */
/* U+A120 */	UNICODE_REPLACEMENT_CHARACTER,	/* 544 */
/* U+A121 */	UNICODE_REPLACEMENT_CHARACTER,	/* 545 */
/* U+A122 */	UNICODE_REPLACEMENT_CHARACTER,	/* 546 */
/* U+A123 */	UNICODE_REPLACEMENT_CHARACTER,	/* 547 */
/* U+A124 */	UNICODE_REPLACEMENT_CHARACTER,	/* 548 */
/* U+A125 */	UNICODE_REPLACEMENT_CHARACTER,	/* 549 */
/* U+A126 */	UNICODE_REPLACEMENT_CHARACTER,	/* 550 */
/* U+A127 */	UNICODE_REPLACEMENT_CHARACTER,	/* 551 */
/* U+A128 */	UNICODE_REPLACEMENT_CHARACTER,	/* 552 */
/* U+A129 */	UNICODE_REPLACEMENT_CHARACTER,	/* 553 */
/* U+A12A */	UNICODE_REPLACEMENT_CHARACTER,	/* 554 */
/* U+A12B */	UNICODE_REPLACEMENT_CHARACTER,	/* 555 */
/* U+A12C */	UNICODE_REPLACEMENT_CHARACTER,	/* 556 */
/* U+A12D */	UNICODE_REPLACEMENT_CHARACTER,	/* 557 */
/* U+A12E */	UNICODE_REPLACEMENT_CHARACTER,	/* 558 */
/* U+A12F */	UNICODE_REPLACEMENT_CHARACTER,	/* 559 */
/* U+A130 */	UNICODE_REPLACEMENT_CHARACTER,	/* 560 */
/* U+A131 */	UNICODE_REPLACEMENT_CHARACTER,	/* 561 */
/* U+A132 */	UNICODE_REPLACEMENT_CHARACTER,	/* 562 */
/* U+A133 */	UNICODE_REPLACEMENT_CHARACTER,	/* 563 */
/* U+A134 */	UNICODE_REPLACEMENT_CHARACTER,	/* 564 */
/* U+A135 */	UNICODE_REPLACEMENT_CHARACTER,	/* 565 */
/* U+A136 */	UNICODE_REPLACEMENT_CHARACTER,	/* 566 */
/* U+A137 */	UNICODE_REPLACEMENT_CHARACTER,	/* 567 */
/* U+A138 */	UNICODE_REPLACEMENT_CHARACTER,	/* 568 */
/* U+A139 */	UNICODE_REPLACEMENT_CHARACTER,	/* 569 */
/* U+A13A */	UNICODE_REPLACEMENT_CHARACTER,	/* 570 */
/* U+A13B */	UNICODE_REPLACEMENT_CHARACTER,	/* 571 */
/* U+A13C */	UNICODE_REPLACEMENT_CHARACTER,	/* 572 */
/* U+A13D */	UNICODE_REPLACEMENT_CHARACTER,	/* 573 */
/* U+A13E */	UNICODE_REPLACEMENT_CHARACTER,	/* 574 */
/* U+A13F */	UNICODE_REPLACEMENT_CHARACTER,	/* 575 */
/* U+A140 */	0x3000	/*                             IDEOGRAPHIC SPACE */,/* 576 */
/* U+A141 */	0xFF0C	/*                               FULLWIDTH COMMA */,/* 577 */
/* U+A142 */	0x3001	/*                             IDEOGRAPHIC COMMA */,/* 578 */
/* U+A143 */	0x3002	/*                         IDEOGRAPHIC FULL STOP */,/* 579 */
/* U+A144 */	0xFF0E	/*                           FULLWIDTH FULL STOP */,/* 580 */
/* U+A145 */	0x2022	/*                                        BULLET */,/* 581 */
/* U+A146 */	0xFF1B	/*                           FULLWIDTH SEMICOLON */,/* 582 */
/* U+A147 */	0xFF1A	/*                               FULLWIDTH COLON */,/* 583 */
/* U+A148 */	0xFF1F	/*                       FULLWIDTH QUESTION MARK */,/* 584 */
/* U+A149 */	0xFF01	/*                    FULLWIDTH EXCLAMATION MARK */,/* 585 */
/* U+A14A */	0xFE30	/*  PRESENTATION FORM FOR VERTICAL TWO DOT LEADER */,/* 586 */
/* U+A14B */	0x2026	/*                           HORIZONTAL ELLIPSIS */,/* 587 */
/* U+A14C */	0x2025	/*                                TWO DOT LEADER */,/* 588 */
/* U+A14D */	0xFE50	/*                                   SMALL COMMA */,/* 589 */
/* U+A14E */	0xFF64	/*                   HALFWIDTH IDEOGRAPHIC COMMA */,/* 590 */
/* U+A14F */	0xFE52	/*                               SMALL FULL STOP */,/* 591 */
/* U+A150 */	0x00B7	/*                                    MIDDLE DOT */,/* 592 */
/* U+A151 */	0xFE54	/*                               SMALL SEMICOLON */,/* 593 */
/* U+A152 */	0xFE55	/*                                   SMALL COLON */,/* 594 */
/* U+A153 */	0xFE56	/*                           SMALL QUESTION MARK */,/* 595 */
/* U+A154 */	0xFE57	/*                        SMALL EXCLAMATION MARK */,/* 596 */
/* U+A155 */	0xFF5C	/*                        FULLWIDTH VERTICAL BAR */,/* 597 */
/* U+A156 */	0x2013	/*                                       EN DASH */,/* 598 */
/* U+A157 */	0xFE31	/*        PRESENTATION FORM FOR VERTICAL EM DASH */,/* 599 */
/* U+A158 */	0x2014	/*                                       EM DASH */,/* 600 */
/* U+A159 */	0xFE33	/*       PRESENTATION FORM FOR VERTICAL LOW LINE */,/* 601 */
/* U+A15A */	0xFFFD	/*                            *** NO MAPPING *** */,/* 602 */
/* U+A15B */	0xFE34	/*  PRESENTATION FORM FOR VERTICAL WAVY LOW LINE */,/* 603 */
/* U+A15C */	0xFE4F	/*                                 WAVY LOW LINE */,/* 604 */
/* U+A15D */	0xFF08	/*                    FULLWIDTH LEFT PARENTHESIS */,/* 605 */
/* U+A15E */	0xFF09	/*                   FULLWIDTH RIGHT PARENTHESIS */,/* 606 */
/* U+A15F */	0xFE35	/*  PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS */,/* 607 */
/* U+A160 */	0xFE36	/*  PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS */,/* 608 */
/* U+A161 */	0xFF5B	/*                  FULLWIDTH LEFT CURLY BRACKET */,/* 609 */
/* U+A162 */	0xFF5D	/*                 FULLWIDTH RIGHT CURLY BRACKET */,/* 610 */
/* U+A163 */	0xFE37	/*  PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET */,/* 611 */
/* U+A164 */	0xFE38	/*  PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET */,/* 612 */
/* U+A165 */	0x3014	/*                   LEFT TORTOISE SHELL BRACKET */,/* 613 */
/* U+A166 */	0x3015	/*                  RIGHT TORTOISE SHELL BRACKET */,/* 614 */
/* U+A167 */	0xFE39	/*  PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET */,/* 615 */
/* U+A168 */	0xFE3A	/*  PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET */,/* 616 */
/* U+A169 */	0x3010	/*                 LEFT BLACK LENTICULAR BRACKET */,/* 617 */
/* U+A16A */	0x3011	/*                RIGHT BLACK LENTICULAR BRACKET */,/* 618 */
/* U+A16B */	0xFE3B	/*  PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET */,/* 619 */
/* U+A16C */	0xFE3C	/*  PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET */,/* 620 */
/* U+A16D */	0x300A	/*                     LEFT DOUBLE ANGLE BRACKET */,/* 621 */
/* U+A16E */	0x300B	/*                    RIGHT DOUBLE ANGLE BRACKET */,/* 622 */
/* U+A16F */	0xFE3D	/*  PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET */,/* 623 */
/* U+A170 */	0xFE3E	/*  PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET */,/* 624 */
/* U+A171 */	0x3008	/*                            LEFT ANGLE BRACKET */,/* 625 */
/* U+A172 */	0x3009	/*                           RIGHT ANGLE BRACKET */,/* 626 */
/* U+A173 */	0xFE3F	/*  PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET */,/* 627 */
/* U+A174 */	0xFE40	/*  PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET */,/* 628 */
/* U+A175 */	0x300C	/*                           LEFT CORNER BRACKET */,/* 629 */
/* U+A176 */	0x300D	/*                          RIGHT CORNER BRACKET */,/* 630 */
/* U+A177 */	0xFE41	/*  PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET */,/* 631 */
/* U+A178 */	0xFE42	/*  PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET */,/* 632 */
/* U+A179 */	0x300E	/*                     LEFT WHITE CORNER BRACKET */,/* 633 */
/* U+A17A */	0x300F	/*                    RIGHT WHITE CORNER BRACKET */,/* 634 */
/* U+A17B */	0xFE43	/*  PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET */,/* 635 */
/* U+A17C */	0xFE44	/*  PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET */,/* 636 */
/* U+A17D */	0xFE59	/*                        SMALL LEFT PARENTHESIS */,/* 637 */
/* U+A17E */	0xFE5A	/*                       SMALL RIGHT PARENTHESIS */,/* 638 */
/* U+A17F */	UNICODE_REPLACEMENT_CHARACTER,	/* 639 */
/* U+A180 */	UNICODE_REPLACEMENT_CHARACTER,	/* 640 */
/* U+A181 */	UNICODE_REPLACEMENT_CHARACTER,	/* 641 */
/* U+A182 */	UNICODE_REPLACEMENT_CHARACTER,	/* 642 */
/* U+A183 */	UNICODE_REPLACEMENT_CHARACTER,	/* 643 */
/* U+A184 */	UNICODE_REPLACEMENT_CHARACTER,	/* 644 */
/* U+A185 */	UNICODE_REPLACEMENT_CHARACTER,	/* 645 */
/* U+A186 */	UNICODE_REPLACEMENT_CHARACTER,	/* 646 */
/* U+A187 */	UNICODE_REPLACEMENT_CHARACTER,	/* 647 */
/* U+A188 */	UNICODE_REPLACEMENT_CHARACTER,	/* 648 */
/* U+A189 */	UNICODE_REPLACEMENT_CHARACTER,	/* 649 */
/* U+A18A */	UNICODE_REPLACEMENT_CHARACTER,	/* 650 */
/* U+A18B */	UNICODE_REPLACEMENT_CHARACTER,	/* 651 */
/* U+A18C */	UNICODE_REPLACEMENT_CHARACTER,	/* 652 */
/* U+A18D */	UNICODE_REPLACEMENT_CHARACTER,	/* 653 */
/* U+A18E */	UNICODE_REPLACEMENT_CHARACTER,	/* 654 */
/* U+A18F */	UNICODE_REPLACEMENT_CHARACTER,	/* 655 */
/* U+A190 */	UNICODE_REPLACEMENT_CHARACTER,	/* 656 */
/* U+A191 */	UNICODE_REPLACEMENT_CHARACTER,	/* 657 */
/* U+A192 */	UNICODE_REPLACEMENT_CHARACTER,	/* 658 */
/* U+A193 */	UNICODE_REPLACEMENT_CHARACTER,	/* 659 */
/* U+A194 */	UNICODE_REPLACEMENT_CHARACTER,	/* 660 */
/* U+A195 */	UNICODE_REPLACEMENT_CHARACTER,	/* 661 */
/* U+A196 */	UNICODE_REPLACEMENT_CHARACTER,	/* 662 */
/* U+A197 */	UNICODE_REPLACEMENT_CHARACTER,	/* 663 */
/* U+A198 */	UNICODE_REPLACEMENT_CHARACTER,	/* 664 */
/* U+A199 */	UNICODE_REPLACEMENT_CHARACTER,	/* 665 */
/* U+A19A */	UNICODE_REPLACEMENT_CHARACTER,	/* 666 */
/* U+A19B */	UNICODE_REPLACEMENT_CHARACTER,	/* 667 */
/* U+A19C */	UNICODE_REPLACEMENT_CHARACTER,	/* 668 */
/* U+A19D */	UNICODE_REPLACEMENT_CHARACTER,	/* 669 */
/* U+A19E */	UNICODE_REPLACEMENT_CHARACTER,	/* 670 */
/* U+A19F */	UNICODE_REPLACEMENT_CHARACTER,	/* 671 */
/* U+A1A0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 672 */
/* U+A1A1 */	0xFE5B	/*                      SMALL LEFT CURLY BRACKET */,/* 673 */
/* U+A1A2 */	0xFE5C	/*                     SMALL RIGHT CURLY BRACKET */,/* 674 */
/* U+A1A3 */	0xFE5D	/*             SMALL LEFT TORTOISE SHELL BRACKET */,/* 675 */
/* U+A1A4 */	0xFE5E	/*            SMALL RIGHT TORTOISE SHELL BRACKET */,/* 676 */
/* U+A1A5 */	0x2018	/*                    LEFT SINGLE QUOTATION MARK */,/* 677 */
/* U+A1A6 */	0x2019	/*                   RIGHT SINGLE QUOTATION MARK */,/* 678 */
/* U+A1A7 */	0x201C	/*                    LEFT DOUBLE QUOTATION MARK */,/* 679 */
/* U+A1A8 */	0x201D	/*                   RIGHT DOUBLE QUOTATION MARK */,/* 680 */
/* U+A1A9 */	0x301D	/*          REVERSED DOUBLE PRIME QUOTATION MARK */,/* 681 */
/* U+A1AA */	0x301E	/*                   DOUBLE PRIME QUOTATION MARK */,/* 682 */
/* U+A1AB */	0x2035	/*                                REVERSED PRIME */,/* 683 */
/* U+A1AC */	0x2032	/*                                         PRIME */,/* 684 */
/* U+A1AD */	0xFF03	/*                         FULLWIDTH NUMBER SIGN */,/* 685 */
/* U+A1AE */	0xFF06	/*                           FULLWIDTH AMPERSAND */,/* 686 */
/* U+A1AF */	0xFF0A	/*                            FULLWIDTH ASTERISK */,/* 687 */
/* U+A1B0 */	0x203B	/*                                REFERENCE MARK */,/* 688 */
/* U+A1B1 */	0x00A7	/*                                  SECTION SIGN */,/* 689 */
/* U+A1B2 */	0x3003	/*                                    DITTO MARK */,/* 690 */
/* U+A1B3 */	0x25CB	/*                                  WHITE CIRCLE */,/* 691 */
/* U+A1B4 */	0x25CF	/*                                  BLACK CIRCLE */,/* 692 */
/* U+A1B5 */	0x25B3	/*                    WHITE UP-POINTING TRIANGLE */,/* 693 */
/* U+A1B6 */	0x25B2	/*                    BLACK UP-POINTING TRIANGLE */,/* 694 */
/* U+A1B7 */	0x25CE	/*                                      BULLSEYE */,/* 695 */
/* U+A1B8 */	0x2606	/*                                    WHITE STAR */,/* 696 */
/* U+A1B9 */	0x2605	/*                                    BLACK STAR */,/* 697 */
/* U+A1BA */	0x25C7	/*                                 WHITE DIAMOND */,/* 698 */
/* U+A1BB */	0x25C6	/*                                 BLACK DIAMOND */,/* 699 */
/* U+A1BC */	0x25A1	/*                                  WHITE SQUARE */,/* 700 */
/* U+A1BD */	0x25A0	/*                                  BLACK SQUARE */,/* 701 */
/* U+A1BE */	0x25BD	/*                  WHITE DOWN-POINTING TRIANGLE */,/* 702 */
/* U+A1BF */	0x25BC	/*                  BLACK DOWN-POINTING TRIANGLE */,/* 703 */
/* U+A1C0 */	0x32A3	/*                     CIRCLED IDEOGRAPH CORRECT */,/* 704 */
/* U+A1C1 */	0x2105	/*                                       CARE OF */,/* 705 */
/* U+A1C2 */	0x203E	/*                                      OVERLINE */,/* 706 */
/* U+A1C3 */	0xFFFD	/*                            *** NO MAPPING *** */,/* 707 */
/* U+A1C4 */	0xFF3F	/*                            FULLWIDTH LOW LINE */,/* 708 */
/* U+A1C5 */	0xFFFD	/*                            *** NO MAPPING *** */,/* 709 */
/* U+A1C6 */	0xFE49	/*                               DASHED OVERLINE */,/* 710 */
/* U+A1C7 */	0xFE4A	/*                           CENTRELINE OVERLINE */,/* 711 */
/* U+A1C8 */	0xFE4D	/*                               DASHED LOW LINE */,/* 712 */
/* U+A1C9 */	0xFE4E	/*                           CENTRELINE LOW LINE */,/* 713 */
/* U+A1CA */	0xFE4B	/*                                 WAVY OVERLINE */,/* 714 */
/* U+A1CB */	0xFE4C	/*                          DOUBLE WAVY OVERLINE */,/* 715 */
/* U+A1CC */	0xFE5F	/*                             SMALL NUMBER SIGN */,/* 716 */
/* U+A1CD */	0xFE60	/*                               SMALL AMPERSAND */,/* 717 */
/* U+A1CE */	0xFE61	/*                                SMALL ASTERISK */,/* 718 */
/* U+A1CF */	0xFF0B	/*                           FULLWIDTH PLUS SIGN */,/* 719 */
/* U+A1D0 */	0xFF0D	/*                        FULLWIDTH HYPHEN-MINUS */,/* 720 */
/* U+A1D1 */	0x00D7	/*                           MULTIPLICATION SIGN */,/* 721 */
/* U+A1D2 */	0x00F7	/*                                 DIVISION SIGN */,/* 722 */
/* U+A1D3 */	0x00B1	/*                               PLUS-MINUS SIGN */,/* 723 */
/* U+A1D4 */	0x221A	/*                                   SQUARE ROOT */,/* 724 */
/* U+A1D5 */	0xFF1C	/*                      FULLWIDTH LESS-THAN SIGN */,/* 725 */
/* U+A1D6 */	0xFF1E	/*                   FULLWIDTH GREATER-THAN SIGN */,/* 726 */
/* U+A1D7 */	0xFF1D	/*                         FULLWIDTH EQUALS SIGN */,/* 727 */
/* U+A1D8 */	0x2266	/*                       LESS THAN OVER EQUAL TO */,/* 728 */
/* U+A1D9 */	0x2267	/*                    GREATER THAN OVER EQUAL TO */,/* 729 */
/* U+A1DA */	0x2260	/*                                  NOT EQUAL TO */,/* 730 */
/* U+A1DB */	0x221E	/*                                      INFINITY */,/* 731 */
/* U+A1DC */	0x2252	/*        APPROXIMATELY EQUAL TO OR THE IMAGE OF */,/* 732 */
/* U+A1DD */	0x2261	/*                                  IDENTICAL TO */,/* 733 */
/* U+A1DE */	0xFE62	/*                               SMALL PLUS SIGN */,/* 734 */
/* U+A1DF */	0xFE63	/*                            SMALL HYPHEN-MINUS */,/* 735 */
/* U+A1E0 */	0xFE64	/*                          SMALL LESS-THAN SIGN */,/* 736 */
/* U+A1E1 */	0xFE65	/*                       SMALL GREATER-THAN SIGN */,/* 737 */
/* U+A1E2 */	0xFE66	/*                             SMALL EQUALS SIGN */,/* 738 */
/* U+A1E3 */	0x223C	/*                                TILDE OPERATOR */,/* 739 */
/* U+A1E4 */	0x2229	/*                                  INTERSECTION */,/* 740 */
/* U+A1E5 */	0x222A	/*                                         UNION */,/* 741 */
/* U+A1E6 */	0x22A5	/*                                       UP TACK */,/* 742 */
/* U+A1E7 */	0x2220	/*                                         ANGLE */,/* 743 */
/* U+A1E8 */	0x221F	/*                                   RIGHT ANGLE */,/* 744 */
/* U+A1E9 */	0x22BF	/*                                RIGHT TRIANGLE */,/* 745 */
/* U+A1EA */	0x33D2	/*                                    SQUARE LOG */,/* 746 */
/* U+A1EB */	0x33D1	/*                                     SQUARE LN */,/* 747 */
/* U+A1EC */	0x222B	/*                                      INTEGRAL */,/* 748 */
/* U+A1ED */	0x222E	/*                              CONTOUR INTEGRAL */,/* 749 */
/* U+A1EE */	0x2235	/*                                       BECAUSE */,/* 750 */
/* U+A1EF */	0x2234	/*                                     THEREFORE */,/* 751 */
/* U+A1F0 */	0x2640	/*                                   FEMALE SIGN */,/* 752 */
/* U+A1F1 */	0x2642	/*                                     MALE SIGN */,/* 753 */
/* U+A1F2 */	0x2641	/*                                         EARTH */,/* 754 */
/* U+A1F3 */	0x2609	/*                                           SUN */,/* 755 */
/* U+A1F4 */	0x2191	/*                                 UPWARDS ARROW */,/* 756 */
/* U+A1F5 */	0x2193	/*                               DOWNWARDS ARROW */,/* 757 */
/* U+A1F6 */	0x2190	/*                               LEFTWARDS ARROW */,/* 758 */
/* U+A1F7 */	0x2192	/*                              RIGHTWARDS ARROW */,/* 759 */
/* U+A1F8 */	0x2196	/*                              NORTH WEST ARROW */,/* 760 */
/* U+A1F9 */	0x2197	/*                              NORTH EAST ARROW */,/* 761 */
/* U+A1FA */	0x2199	/*                              SOUTH WEST ARROW */,/* 762 */
/* U+A1FB */	0x2198	/*                              SOUTH EAST ARROW */,/* 763 */
/* U+A1FC */	0x2225	/*                                   PARALLEL TO */,/* 764 */
/* U+A1FD */	0x2223	/*                                       DIVIDES */,/* 765 */
/* U+A1FE */	0xFFFD	/*                            *** NO MAPPING *** */,/* 766 */
/* U+A1FF */	UNICODE_REPLACEMENT_CHARACTER,	/* 767 */
/* U+A200 */	UNICODE_REPLACEMENT_CHARACTER,	/* 768 */
/* U+A201 */	UNICODE_REPLACEMENT_CHARACTER,	/* 769 */
/* U+A202 */	UNICODE_REPLACEMENT_CHARACTER,	/* 770 */
/* U+A203 */	UNICODE_REPLACEMENT_CHARACTER,	/* 771 */
/* U+A204 */	UNICODE_REPLACEMENT_CHARACTER,	/* 772 */
/* U+A205 */	UNICODE_REPLACEMENT_CHARACTER,	/* 773 */
/* U+A206 */	UNICODE_REPLACEMENT_CHARACTER,	/* 774 */
/* U+A207 */	UNICODE_REPLACEMENT_CHARACTER,	/* 775 */
/* U+A208 */	UNICODE_REPLACEMENT_CHARACTER,	/* 776 */
/* U+A209 */	UNICODE_REPLACEMENT_CHARACTER,	/* 777 */
/* U+A20A */	UNICODE_REPLACEMENT_CHARACTER,	/* 778 */
/* U+A20B */	UNICODE_REPLACEMENT_CHARACTER,	/* 779 */
/* U+A20C */	UNICODE_REPLACEMENT_CHARACTER,	/* 780 */
/* U+A20D */	UNICODE_REPLACEMENT_CHARACTER,	/* 781 */
/* U+A20E */	UNICODE_REPLACEMENT_CHARACTER,	/* 782 */
/* U+A20F */	UNICODE_REPLACEMENT_CHARACTER,	/* 783 */
/* U+A210 */	UNICODE_REPLACEMENT_CHARACTER,	/* 784 */
/* U+A211 */	UNICODE_REPLACEMENT_CHARACTER,	/* 785 */
/* U+A212 */	UNICODE_REPLACEMENT_CHARACTER,	/* 786 */
/* U+A213 */	UNICODE_REPLACEMENT_CHARACTER,	/* 787 */
/* U+A214 */	UNICODE_REPLACEMENT_CHARACTER,	/* 788 */
/* U+A215 */	UNICODE_REPLACEMENT_CHARACTER,	/* 789 */
/* U+A216 */	UNICODE_REPLACEMENT_CHARACTER,	/* 790 */
/* U+A217 */	UNICODE_REPLACEMENT_CHARACTER,	/* 791 */
/* U+A218 */	UNICODE_REPLACEMENT_CHARACTER,	/* 792 */
/* U+A219 */	UNICODE_REPLACEMENT_CHARACTER,	/* 793 */
/* U+A21A */	UNICODE_REPLACEMENT_CHARACTER,	/* 794 */
/* U+A21B */	UNICODE_REPLACEMENT_CHARACTER,	/* 795 */
/* U+A21C */	UNICODE_REPLACEMENT_CHARACTER,	/* 796 */
/* U+A21D */	UNICODE_REPLACEMENT_CHARACTER,	/* 797 */
/* U+A21E */	UNICODE_REPLACEMENT_CHARACTER,	/* 798 */
/* U+A21F */	UNICODE_REPLACEMENT_CHARACTER,	/* 799 */
/* U+A220 */	UNICODE_REPLACEMENT_CHARACTER,	/* 800 */
/* U+A221 */	UNICODE_REPLACEMENT_CHARACTER,	/* 801 */
/* U+A222 */	UNICODE_REPLACEMENT_CHARACTER,	/* 802 */
/* U+A223 */	UNICODE_REPLACEMENT_CHARACTER,	/* 803 */
/* U+A224 */	UNICODE_REPLACEMENT_CHARACTER,	/* 804 */
/* U+A225 */	UNICODE_REPLACEMENT_CHARACTER,	/* 805 */
/* U+A226 */	UNICODE_REPLACEMENT_CHARACTER,	/* 806 */
/* U+A227 */	UNICODE_REPLACEMENT_CHARACTER,	/* 807 */
/* U+A228 */	UNICODE_REPLACEMENT_CHARACTER,	/* 808 */
/* U+A229 */	UNICODE_REPLACEMENT_CHARACTER,	/* 809 */
/* U+A22A */	UNICODE_REPLACEMENT_CHARACTER,	/* 810 */
/* U+A22B */	UNICODE_REPLACEMENT_CHARACTER,	/* 811 */
/* U+A22C */	UNICODE_REPLACEMENT_CHARACTER,	/* 812 */
/* U+A22D */	UNICODE_REPLACEMENT_CHARACTER,	/* 813 */
/* U+A22E */	UNICODE_REPLACEMENT_CHARACTER,	/* 814 */
/* U+A22F */	UNICODE_REPLACEMENT_CHARACTER,	/* 815 */
/* U+A230 */	UNICODE_REPLACEMENT_CHARACTER,	/* 816 */
/* U+A231 */	UNICODE_REPLACEMENT_CHARACTER,	/* 817 */
/* U+A232 */	UNICODE_REPLACEMENT_CHARACTER,	/* 818 */
/* U+A233 */	UNICODE_REPLACEMENT_CHARACTER,	/* 819 */
/* U+A234 */	UNICODE_REPLACEMENT_CHARACTER,	/* 820 */
/* U+A235 */	UNICODE_REPLACEMENT_CHARACTER,	/* 821 */
/* U+A236 */	UNICODE_REPLACEMENT_CHARACTER,	/* 822 */
/* U+A237 */	UNICODE_REPLACEMENT_CHARACTER,	/* 823 */
/* U+A238 */	UNICODE_REPLACEMENT_CHARACTER,	/* 824 */
/* U+A239 */	UNICODE_REPLACEMENT_CHARACTER,	/* 825 */
/* U+A23A */	UNICODE_REPLACEMENT_CHARACTER,	/* 826 */
/* U+A23B */	UNICODE_REPLACEMENT_CHARACTER,	/* 827 */
/* U+A23C */	UNICODE_REPLACEMENT_CHARACTER,	/* 828 */
/* U+A23D */	UNICODE_REPLACEMENT_CHARACTER,	/* 829 */
/* U+A23E */	UNICODE_REPLACEMENT_CHARACTER,	/* 830 */
/* U+A23F */	UNICODE_REPLACEMENT_CHARACTER,	/* 831 */
/* U+A240 */	0xFFFD	/*                            *** NO MAPPING *** */,/* 832 */
/* U+A241 */	0xFF0F	/*                             FULLWIDTH SOLIDUS */,/* 833 */
/* U+A242 */	0xFF3C	/*                     FULLWIDTH REVERSE SOLIDUS */,/* 834 */
/* U+A243 */	0xFF04	/*                         FULLWIDTH DOLLAR SIGN */,/* 835 */
/* U+A244 */	0x00A5	/*                                      YEN SIGN */,/* 836 */
/* U+A245 */	0x3012	/*                                   POSTAL MARK */,/* 837 */
/* U+A246 */	0x00A2	/*                                     CENT SIGN */,/* 838 */
/* U+A247 */	0x00A3	/*                                    POUND SIGN */,/* 839 */
/* U+A248 */	0xFF05	/*                        FULLWIDTH PERCENT SIGN */,/* 840 */
/* U+A249 */	0xFF20	/*                       FULLWIDTH COMMERCIAL AT */,/* 841 */
/* U+A24A */	0x2103	/*                                DEGREE CELSIUS */,/* 842 */
/* U+A24B */	0x2109	/*                             DEGREE FAHRENHEIT */,/* 843 */
/* U+A24C */	0xFE69	/*                             SMALL DOLLAR SIGN */,/* 844 */
/* U+A24D */	0xFE6A	/*                            SMALL PERCENT SIGN */,/* 845 */
/* U+A24E */	0xFE6B	/*                           SMALL COMMERCIAL AT */,/* 846 */
/* U+A24F */	0x33D5	/*                                    SQUARE MIL */,/* 847 */
/* U+A250 */	0x339C	/*                                     SQUARE MM */,/* 848 */
/* U+A251 */	0x339D	/*                                     SQUARE CM */,/* 849 */
/* U+A252 */	0x339E	/*                                     SQUARE KM */,/* 850 */
/* U+A253 */	0x33CE	/*                             SQUARE KM CAPITAL */,/* 851 */
/* U+A254 */	0x33A1	/*                              SQUARE M SQUARED */,/* 852 */
/* U+A255 */	0x338E	/*                                     SQUARE MG */,/* 853 */
/* U+A256 */	0x338F	/*                                     SQUARE KG */,/* 854 */
/* U+A257 */	0x33C4	/*                                     SQUARE CC */,/* 855 */
/* U+A258 */	0x00B0	/*                                   DEGREE SIGN */,/* 856 */
/* U+A259 */	0x5159	/*                                         <CJK> */,/* 857 */
/* U+A25A */	0x515B	/*                                         <CJK> */,/* 858 */
/* U+A25B */	0x515E	/*                                         <CJK> */,/* 859 */
/* U+A25C */	0x515D	/*                                         <CJK> */,/* 860 */
/* U+A25D */	0x5161	/*                                         <CJK> */,/* 861 */
/* U+A25E */	0x5163	/*                                         <CJK> */,/* 862 */
/* U+A25F */	0x55E7	/*                                         <CJK> */,/* 863 */
/* U+A260 */	0x74E9	/*                                         <CJK> */,/* 864 */
/* U+A261 */	0x7CCE	/*                                         <CJK> */,/* 865 */
/* U+A262 */	0x2581	/*                        LOWER ONE EIGHTH BLOCK */,/* 866 */
/* U+A263 */	0x2582	/*                       LOWER ONE QUARTER BLOCK */,/* 867 */
/* U+A264 */	0x2583	/*                     LOWER THREE EIGHTHS BLOCK */,/* 868 */
/* U+A265 */	0x2584	/*                              LOWER HALF BLOCK */,/* 869 */
/* U+A266 */	0x2585	/*                      LOWER FIVE EIGHTHS BLOCK */,/* 870 */
/* U+A267 */	0x2586	/*                    LOWER THREE QUARTERS BLOCK */,/* 871 */
/* U+A268 */	0x2587	/*                     LOWER SEVEN EIGHTHS BLOCK */,/* 872 */
/* U+A269 */	0x2588	/*                                    FULL BLOCK */,/* 873 */
/* U+A26A */	0x258F	/*                         LEFT ONE EIGHTH BLOCK */,/* 874 */
/* U+A26B */	0x258E	/*                        LEFT ONE QUARTER BLOCK */,/* 875 */
/* U+A26C */	0x258D	/*                      LEFT THREE EIGHTHS BLOCK */,/* 876 */
/* U+A26D */	0x258C	/*                               LEFT HALF BLOCK */,/* 877 */
/* U+A26E */	0x258B	/*                       LEFT FIVE EIGHTHS BLOCK */,/* 878 */
/* U+A26F */	0x258A	/*                     LEFT THREE QUARTERS BLOCK */,/* 879 */
/* U+A270 */	0x2589	/*                      LEFT SEVEN EIGHTHS BLOCK */,/* 880 */
/* U+A271 */	0x253C	/*    BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */,/* 881 */
/* U+A272 */	0x2534	/*          BOX DRAWINGS LIGHT UP AND HORIZONTAL */,/* 882 */
/* U+A273 */	0x252C	/*        BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */,/* 883 */
/* U+A274 */	0x2524	/*          BOX DRAWINGS LIGHT VERTICAL AND LEFT */,/* 884 */
/* U+A275 */	0x251C	/*         BOX DRAWINGS LIGHT VERTICAL AND RIGHT */,/* 885 */
/* U+A276 */	0x2594	/*                        UPPER ONE EIGHTH BLOCK */,/* 886 */
/* U+A277 */	0x2500	/*                 BOX DRAWINGS LIGHT HORIZONTAL */,/* 887 */
/* U+A278 */	0x2502	/*                   BOX DRAWINGS LIGHT VERTICAL */,/* 888 */
/* U+A279 */	0x2595	/*                        RIGHT ONE EIGHTH BLOCK */,/* 889 */
/* U+A27A */	0x250C	/*             BOX DRAWINGS LIGHT DOWN AND RIGHT */,/* 890 */
/* U+A27B */	0x2510	/*              BOX DRAWINGS LIGHT DOWN AND LEFT */,/* 891 */
/* U+A27C */	0x2514	/*               BOX DRAWINGS LIGHT UP AND RIGHT */,/* 892 */
/* U+A27D */	0x2518	/*                BOX DRAWINGS LIGHT UP AND LEFT */,/* 893 */
/* U+A27E */	0x256D	/*         BOX DRAWINGS LIGHT ARC DOWN AND RIGHT */,/* 894 */
/* U+A27F */	UNICODE_REPLACEMENT_CHARACTER,	/* 895 */
/* U+A280 */	UNICODE_REPLACEMENT_CHARACTER,	/* 896 */
/* U+A281 */	UNICODE_REPLACEMENT_CHARACTER,	/* 897 */
/* U+A282 */	UNICODE_REPLACEMENT_CHARACTER,	/* 898 */
/* U+A283 */	UNICODE_REPLACEMENT_CHARACTER,	/* 899 */
/* U+A284 */	UNICODE_REPLACEMENT_CHARACTER,	/* 900 */
/* U+A285 */	UNICODE_REPLACEMENT_CHARACTER,	/* 901 */
/* U+A286 */	UNICODE_REPLACEMENT_CHARACTER,	/* 902 */
/* U+A287 */	UNICODE_REPLACEMENT_CHARACTER,	/* 903 */
/* U+A288 */	UNICODE_REPLACEMENT_CHARACTER,	/* 904 */
/* U+A289 */	UNICODE_REPLACEMENT_CHARACTER,	/* 905 */
/* U+A28A */	UNICODE_REPLACEMENT_CHARACTER,	/* 906 */
/* U+A28B */	UNICODE_REPLACEMENT_CHARACTER,	/* 907 */
/* U+A28C */	UNICODE_REPLACEMENT_CHARACTER,	/* 908 */
/* U+A28D */	UNICODE_REPLACEMENT_CHARACTER,	/* 909 */
/* U+A28E */	UNICODE_REPLACEMENT_CHARACTER,	/* 910 */
/* U+A28F */	UNICODE_REPLACEMENT_CHARACTER,	/* 911 */
/* U+A290 */	UNICODE_REPLACEMENT_CHARACTER,	/* 912 */
/* U+A291 */	UNICODE_REPLACEMENT_CHARACTER,	/* 913 */
/* U+A292 */	UNICODE_REPLACEMENT_CHARACTER,	/* 914 */
/* U+A293 */	UNICODE_REPLACEMENT_CHARACTER,	/* 915 */
/* U+A294 */	UNICODE_REPLACEMENT_CHARACTER,	/* 916 */
/* U+A295 */	UNICODE_REPLACEMENT_CHARACTER,	/* 917 */
/* U+A296 */	UNICODE_REPLACEMENT_CHARACTER,	/* 918 */
/* U+A297 */	UNICODE_REPLACEMENT_CHARACTER,	/* 919 */
/* U+A298 */	UNICODE_REPLACEMENT_CHARACTER,	/* 920 */
/* U+A299 */	UNICODE_REPLACEMENT_CHARACTER,	/* 921 */
/* U+A29A */	UNICODE_REPLACEMENT_CHARACTER,	/* 922 */
/* U+A29B */	UNICODE_REPLACEMENT_CHARACTER,	/* 923 */
/* U+A29C */	UNICODE_REPLACEMENT_CHARACTER,	/* 924 */
/* U+A29D */	UNICODE_REPLACEMENT_CHARACTER,	/* 925 */
/* U+A29E */	UNICODE_REPLACEMENT_CHARACTER,	/* 926 */
/* U+A29F */	UNICODE_REPLACEMENT_CHARACTER,	/* 927 */
/* U+A2A0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 928 */
/* U+A2A1 */	0x256E	/*          BOX DRAWINGS LIGHT ARC DOWN AND LEFT */,/* 929 */
/* U+A2A2 */	0x2570	/*           BOX DRAWINGS LIGHT ARC UP AND RIGHT */,/* 930 */
/* U+A2A3 */	0x256F	/*            BOX DRAWINGS LIGHT ARC UP AND LEFT */,/* 931 */
/* U+A2A4 */	0x2550	/*                BOX DRAWINGS DOUBLE HORIZONTAL */,/* 932 */
/* U+A2A5 */	0x255E	/*  BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE */,/* 933 */
/* U+A2A6 */	0x256A	/*  BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE */,/* 934 */
/* U+A2A7 */	0x2561	/*  BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE */,/* 935 */
/* U+A2A8 */	0x25E2	/*                    BLACK LOWER RIGHT TRIANGLE */,/* 936 */
/* U+A2A9 */	0x25E3	/*                     BLACK LOWER LEFT TRIANGLE */,/* 937 */
/* U+A2AA */	0x25E5	/*                    BLACK UPPER RIGHT TRIANGLE */,/* 938 */
/* U+A2AB */	0x25E4	/*                     BLACK UPPER LEFT TRIANGLE */,/* 939 */
/* U+A2AC */	0x2571	/*  BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT */,/* 940 */
/* U+A2AD */	0x2572	/*  BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT */,/* 941 */
/* U+A2AE */	0x2573	/*             BOX DRAWINGS LIGHT DIAGONAL CROSS */,/* 942 */
/* U+A2AF */	0xFF10	/*                          FULLWIDTH DIGIT ZERO */,/* 943 */
/* U+A2B0 */	0xFF11	/*                           FULLWIDTH DIGIT ONE */,/* 944 */
/* U+A2B1 */	0xFF12	/*                           FULLWIDTH DIGIT TWO */,/* 945 */
/* U+A2B2 */	0xFF13	/*                         FULLWIDTH DIGIT THREE */,/* 946 */
/* U+A2B3 */	0xFF14	/*                          FULLWIDTH DIGIT FOUR */,/* 947 */
/* U+A2B4 */	0xFF15	/*                          FULLWIDTH DIGIT FIVE */,/* 948 */
/* U+A2B5 */	0xFF16	/*                           FULLWIDTH DIGIT SIX */,/* 949 */
/* U+A2B6 */	0xFF17	/*                         FULLWIDTH DIGIT SEVEN */,/* 950 */
/* U+A2B7 */	0xFF18	/*                         FULLWIDTH DIGIT EIGHT */,/* 951 */
/* U+A2B8 */	0xFF19	/*                          FULLWIDTH DIGIT NINE */,/* 952 */
/* U+A2B9 */	0x2160	/*                             ROMAN NUMERAL ONE */,/* 953 */
/* U+A2BA */	0x2161	/*                             ROMAN NUMERAL TWO */,/* 954 */
/* U+A2BB */	0x2162	/*                           ROMAN NUMERAL THREE */,/* 955 */
/* U+A2BC */	0x2163	/*                            ROMAN NUMERAL FOUR */,/* 956 */
/* U+A2BD */	0x2164	/*                            ROMAN NUMERAL FIVE */,/* 957 */
/* U+A2BE */	0x2165	/*                             ROMAN NUMERAL SIX */,/* 958 */
/* U+A2BF */	0x2166	/*                           ROMAN NUMERAL SEVEN */,/* 959 */
/* U+A2C0 */	0x2167	/*                           ROMAN NUMERAL EIGHT */,/* 960 */
/* U+A2C1 */	0x2168	/*                            ROMAN NUMERAL NINE */,/* 961 */
/* U+A2C2 */	0x2169	/*                             ROMAN NUMERAL TEN */,/* 962 */
/* U+A2C3 */	0x3021	/*                          HANGZHOU NUMERAL ONE */,/* 963 */
/* U+A2C4 */	0x3022	/*                          HANGZHOU NUMERAL TWO */,/* 964 */
/* U+A2C5 */	0x3023	/*                        HANGZHOU NUMERAL THREE */,/* 965 */
/* U+A2C6 */	0x3024	/*                         HANGZHOU NUMERAL FOUR */,/* 966 */
/* U+A2C7 */	0x3025	/*                         HANGZHOU NUMERAL FIVE */,/* 967 */
/* U+A2C8 */	0x3026	/*                          HANGZHOU NUMERAL SIX */,/* 968 */
/* U+A2C9 */	0x3027	/*                        HANGZHOU NUMERAL SEVEN */,/* 969 */
/* U+A2CA */	0x3028	/*                        HANGZHOU NUMERAL EIGHT */,/* 970 */
/* U+A2CB */	0x3029	/*                         HANGZHOU NUMERAL NINE */,/* 971 */
/* U+A2CC */	0xFFFD	/*                            *** NO MAPPING *** */,/* 972 */
/* U+A2CD */	0x5344	/*                                         <CJK> */,/* 973 */
/* U+A2CE */	0xFFFD	/*                            *** NO MAPPING *** */,/* 974 */
/* U+A2CF */	0xFF21	/*              FULLWIDTH LATIN CAPITAL LETTER A */,/* 975 */
/* U+A2D0 */	0xFF22	/*              FULLWIDTH LATIN CAPITAL LETTER B */,/* 976 */
/* U+A2D1 */	0xFF23	/*              FULLWIDTH LATIN CAPITAL LETTER C */,/* 977 */
/* U+A2D2 */	0xFF24	/*              FULLWIDTH LATIN CAPITAL LETTER D */,/* 978 */
/* U+A2D3 */	0xFF25	/*              FULLWIDTH LATIN CAPITAL LETTER E */,/* 979 */
/* U+A2D4 */	0xFF26	/*              FULLWIDTH LATIN CAPITAL LETTER F */,/* 980 */
/* U+A2D5 */	0xFF27	/*              FULLWIDTH LATIN CAPITAL LETTER G */,/* 981 */
/* U+A2D6 */	0xFF28	/*              FULLWIDTH LATIN CAPITAL LETTER H */,/* 982 */
/* U+A2D7 */	0xFF29	/*              FULLWIDTH LATIN CAPITAL LETTER I */,/* 983 */
/* U+A2D8 */	0xFF2A	/*              FULLWIDTH LATIN CAPITAL LETTER J */,/* 984 */
/* U+A2D9 */	0xFF2B	/*              FULLWIDTH LATIN CAPITAL LETTER K */,/* 985 */
/* U+A2DA */	0xFF2C	/*              FULLWIDTH LATIN CAPITAL LETTER L */,/* 986 */
/* U+A2DB */	0xFF2D	/*              FULLWIDTH LATIN CAPITAL LETTER M */,/* 987 */
/* U+A2DC */	0xFF2E	/*              FULLWIDTH LATIN CAPITAL LETTER N */,/* 988 */
/* U+A2DD */	0xFF2F	/*              FULLWIDTH LATIN CAPITAL LETTER O */,/* 989 */
/* U+A2DE */	0xFF30	/*              FULLWIDTH LATIN CAPITAL LETTER P */,/* 990 */
/* U+A2DF */	0xFF31	/*              FULLWIDTH LATIN CAPITAL LETTER Q */,/* 991 */
/* U+A2E0 */	0xFF32	/*              FULLWIDTH LATIN CAPITAL LETTER R */,/* 992 */
/* U+A2E1 */	0xFF33	/*              FULLWIDTH LATIN CAPITAL LETTER S */,/* 993 */
/* U+A2E2 */	0xFF34	/*              FULLWIDTH LATIN CAPITAL LETTER T */,/* 994 */
/* U+A2E3 */	0xFF35	/*              FULLWIDTH LATIN CAPITAL LETTER U */,/* 995 */
/* U+A2E4 */	0xFF36	/*              FULLWIDTH LATIN CAPITAL LETTER V */,/* 996 */
/* U+A2E5 */	0xFF37	/*              FULLWIDTH LATIN CAPITAL LETTER W */,/* 997 */
/* U+A2E6 */	0xFF38	/*              FULLWIDTH LATIN CAPITAL LETTER X */,/* 998 */
/* U+A2E7 */	0xFF39	/*              FULLWIDTH LATIN CAPITAL LETTER Y */,/* 999 */
/* U+A2E8 */	0xFF3A	/*              FULLWIDTH LATIN CAPITAL LETTER Z */,/* 1000 */
/* U+A2E9 */	0xFF41	/*                FULLWIDTH LATIN SMALL LETTER A */,/* 1001 */
/* U+A2EA */	0xFF42	/*                FULLWIDTH LATIN SMALL LETTER B */,/* 1002 */
/* U+A2EB */	0xFF43	/*                FULLWIDTH LATIN SMALL LETTER C */,/* 1003 */
/* U+A2EC */	0xFF44	/*                FULLWIDTH LATIN SMALL LETTER D */,/* 1004 */
/* U+A2ED */	0xFF45	/*                FULLWIDTH LATIN SMALL LETTER E */,/* 1005 */
/* U+A2EE */	0xFF46	/*                FULLWIDTH LATIN SMALL LETTER F */,/* 1006 */
/* U+A2EF */	0xFF47	/*                FULLWIDTH LATIN SMALL LETTER G */,/* 1007 */
/* U+A2F0 */	0xFF48	/*                FULLWIDTH LATIN SMALL LETTER H */,/* 1008 */
/* U+A2F1 */	0xFF49	/*                FULLWIDTH LATIN SMALL LETTER I */,/* 1009 */
/* U+A2F2 */	0xFF4A	/*                FULLWIDTH LATIN SMALL LETTER J */,/* 1010 */
/* U+A2F3 */	0xFF4B	/*                FULLWIDTH LATIN SMALL LETTER K */,/* 1011 */
/* U+A2F4 */	0xFF4C	/*                FULLWIDTH LATIN SMALL LETTER L */,/* 1012 */
/* U+A2F5 */	0xFF4D	/*                FULLWIDTH LATIN SMALL LETTER M */,/* 1013 */
/* U+A2F6 */	0xFF4E	/*                FULLWIDTH LATIN SMALL LETTER N */,/* 1014 */
/* U+A2F7 */	0xFF4F	/*                FULLWIDTH LATIN SMALL LETTER O */,/* 1015 */
/* U+A2F8 */	0xFF50	/*                FULLWIDTH LATIN SMALL LETTER P */,/* 1016 */
/* U+A2F9 */	0xFF51	/*                FULLWIDTH LATIN SMALL LETTER Q */,/* 1017 */
/* U+A2FA */	0xFF52	/*                FULLWIDTH LATIN SMALL LETTER R */,/* 1018 */
/* U+A2FB */	0xFF53	/*                FULLWIDTH LATIN SMALL LETTER S */,/* 1019 */
/* U+A2FC */	0xFF54	/*                FULLWIDTH LATIN SMALL LETTER T */,/* 1020 */
/* U+A2FD */	0xFF55	/*                FULLWIDTH LATIN SMALL LETTER U */,/* 1021 */
/* U+A2FE */	0xFF56	/*                FULLWIDTH LATIN SMALL LETTER V */,/* 1022 */
/* U+A2FF */	UNICODE_REPLACEMENT_CHARACTER,	/* 1023 */
/* U+A300 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1024 */
/* U+A301 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1025 */
/* U+A302 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1026 */
/* U+A303 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1027 */
/* U+A304 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1028 */
/* U+A305 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1029 */
/* U+A306 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1030 */
/* U+A307 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1031 */
/* U+A308 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1032 */
/* U+A309 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1033 */
/* U+A30A */	UNICODE_REPLACEMENT_CHARACTER,	/* 1034 */
/* U+A30B */	UNICODE_REPLACEMENT_CHARACTER,	/* 1035 */
/* U+A30C */	UNICODE_REPLACEMENT_CHARACTER,	/* 1036 */
/* U+A30D */	UNICODE_REPLACEMENT_CHARACTER,	/* 1037 */
/* U+A30E */	UNICODE_REPLACEMENT_CHARACTER,	/* 1038 */
/* U+A30F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1039 */
/* U+A310 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1040 */
/* U+A311 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1041 */
/* U+A312 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1042 */
/* U+A313 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1043 */
/* U+A314 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1044 */
/* U+A315 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1045 */
/* U+A316 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1046 */
/* U+A317 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1047 */
/* U+A318 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1048 */
/* U+A319 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1049 */
/* U+A31A */	UNICODE_REPLACEMENT_CHARACTER,	/* 1050 */
/* U+A31B */	UNICODE_REPLACEMENT_CHARACTER,	/* 1051 */
/* U+A31C */	UNICODE_REPLACEMENT_CHARACTER,	/* 1052 */
/* U+A31D */	UNICODE_REPLACEMENT_CHARACTER,	/* 1053 */
/* U+A31E */	UNICODE_REPLACEMENT_CHARACTER,	/* 1054 */
/* U+A31F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1055 */
/* U+A320 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1056 */
/* U+A321 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1057 */
/* U+A322 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1058 */
/* U+A323 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1059 */
/* U+A324 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1060 */
/* U+A325 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1061 */
/* U+A326 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1062 */
/* U+A327 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1063 */
/* U+A328 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1064 */
/* U+A329 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1065 */
/* U+A32A */	UNICODE_REPLACEMENT_CHARACTER,	/* 1066 */
/* U+A32B */	UNICODE_REPLACEMENT_CHARACTER,	/* 1067 */
/* U+A32C */	UNICODE_REPLACEMENT_CHARACTER,	/* 1068 */
/* U+A32D */	UNICODE_REPLACEMENT_CHARACTER,	/* 1069 */
/* U+A32E */	UNICODE_REPLACEMENT_CHARACTER,	/* 1070 */
/* U+A32F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1071 */
/* U+A330 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1072 */
/* U+A331 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1073 */
/* U+A332 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1074 */
/* U+A333 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1075 */
/* U+A334 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1076 */
/* U+A335 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1077 */
/* U+A336 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1078 */
/* U+A337 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1079 */
/* U+A338 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1080 */
/* U+A339 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1081 */
/* U+A33A */	UNICODE_REPLACEMENT_CHARACTER,	/* 1082 */
/* U+A33B */	UNICODE_REPLACEMENT_CHARACTER,	/* 1083 */
/* U+A33C */	UNICODE_REPLACEMENT_CHARACTER,	/* 1084 */
/* U+A33D */	UNICODE_REPLACEMENT_CHARACTER,	/* 1085 */
/* U+A33E */	UNICODE_REPLACEMENT_CHARACTER,	/* 1086 */
/* U+A33F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1087 */
/* U+A340 */	0xFF57	/*                FULLWIDTH LATIN SMALL LETTER W */,/* 1088 */
/* U+A341 */	0xFF58	/*                FULLWIDTH LATIN SMALL LETTER X */,/* 1089 */
/* U+A342 */	0xFF59	/*                FULLWIDTH LATIN SMALL LETTER Y */,/* 1090 */
/* U+A343 */	0xFF5A	/*                FULLWIDTH LATIN SMALL LETTER Z */,/* 1091 */
/* U+A344 */	0x0391	/*                    GREEK CAPITAL LETTER ALPHA */,/* 1092 */
/* U+A345 */	0x0392	/*                     GREEK CAPITAL LETTER BETA */,/* 1093 */
/* U+A346 */	0x0393	/*                    GREEK CAPITAL LETTER GAMMA */,/* 1094 */
/* U+A347 */	0x0394	/*                    GREEK CAPITAL LETTER DELTA */,/* 1095 */
/* U+A348 */	0x0395	/*                  GREEK CAPITAL LETTER EPSILON */,/* 1096 */
/* U+A349 */	0x0396	/*                     GREEK CAPITAL LETTER ZETA */,/* 1097 */
/* U+A34A */	0x0397	/*                      GREEK CAPITAL LETTER ETA */,/* 1098 */
/* U+A34B */	0x0398	/*                    GREEK CAPITAL LETTER THETA */,/* 1099 */
/* U+A34C */	0x0399	/*                     GREEK CAPITAL LETTER IOTA */,/* 1100 */
/* U+A34D */	0x039A	/*                    GREEK CAPITAL LETTER KAPPA */,/* 1101 */
/* U+A34E */	0x039B	/*                    GREEK CAPITAL LETTER LAMDA */,/* 1102 */
/* U+A34F */	0x039C	/*                       GREEK CAPITAL LETTER MU */,/* 1103 */
/* U+A350 */	0x039D	/*                       GREEK CAPITAL LETTER NU */,/* 1104 */
/* U+A351 */	0x039E	/*                       GREEK CAPITAL LETTER XI */,/* 1105 */
/* U+A352 */	0x039F	/*                  GREEK CAPITAL LETTER OMICRON */,/* 1106 */
/* U+A353 */	0x03A0	/*                       GREEK CAPITAL LETTER PI */,/* 1107 */
/* U+A354 */	0x03A1	/*                      GREEK CAPITAL LETTER RHO */,/* 1108 */
/* U+A355 */	0x03A3	/*                    GREEK CAPITAL LETTER SIGMA */,/* 1109 */
/* U+A356 */	0x03A4	/*                      GREEK CAPITAL LETTER TAU */,/* 1110 */
/* U+A357 */	0x03A5	/*                  GREEK CAPITAL LETTER UPSILON */,/* 1111 */
/* U+A358 */	0x03A6	/*                      GREEK CAPITAL LETTER PHI */,/* 1112 */
/* U+A359 */	0x03A7	/*                      GREEK CAPITAL LETTER CHI */,/* 1113 */
/* U+A35A */	0x03A8	/*                      GREEK CAPITAL LETTER PSI */,/* 1114 */
/* U+A35B */	0x03A9	/*                    GREEK CAPITAL LETTER OMEGA */,/* 1115 */
/* U+A35C */	0x03B1	/*                      GREEK SMALL LETTER ALPHA */,/* 1116 */
/* U+A35D */	0x03B2	/*                       GREEK SMALL LETTER BETA */,/* 1117 */
/* U+A35E */	0x03B3	/*                      GREEK SMALL LETTER GAMMA */,/* 1118 */
/* U+A35F */	0x03B4	/*                      GREEK SMALL LETTER DELTA */,/* 1119 */
/* U+A360 */	0x03B5	/*                    GREEK SMALL LETTER EPSILON */,/* 1120 */
/* U+A361 */	0x03B6	/*                       GREEK SMALL LETTER ZETA */,/* 1121 */
/* U+A362 */	0x03B7	/*                        GREEK SMALL LETTER ETA */,/* 1122 */
/* U+A363 */	0x03B8	/*                      GREEK SMALL LETTER THETA */,/* 1123 */
/* U+A364 */	0x03B9	/*                       GREEK SMALL LETTER IOTA */,/* 1124 */
/* U+A365 */	0x03BA	/*                      GREEK SMALL LETTER KAPPA */,/* 1125 */
/* U+A366 */	0x03BB	/*                      GREEK SMALL LETTER LAMDA */,/* 1126 */
/* U+A367 */	0x03BC	/*                         GREEK SMALL LETTER MU */,/* 1127 */
/* U+A368 */	0x03BD	/*                         GREEK SMALL LETTER NU */,/* 1128 */
/* U+A369 */	0x03BE	/*                         GREEK SMALL LETTER XI */,/* 1129 */
/* U+A36A */	0x03BF	/*                    GREEK SMALL LETTER OMICRON */,/* 1130 */
/* U+A36B */	0x03C0	/*                         GREEK SMALL LETTER PI */,/* 1131 */
/* U+A36C */	0x03C1	/*                        GREEK SMALL LETTER RHO */,/* 1132 */
/* U+A36D */	0x03C3	/*                      GREEK SMALL LETTER SIGMA */,/* 1133 */
/* U+A36E */	0x03C4	/*                        GREEK SMALL LETTER TAU */,/* 1134 */
/* U+A36F */	0x03C5	/*                    GREEK SMALL LETTER UPSILON */,/* 1135 */
/* U+A370 */	0x03C6	/*                        GREEK SMALL LETTER PHI */,/* 1136 */
/* U+A371 */	0x03C7	/*                        GREEK SMALL LETTER CHI */,/* 1137 */
/* U+A372 */	0x03C8	/*                        GREEK SMALL LETTER PSI */,/* 1138 */
/* U+A373 */	0x03C9	/*                      GREEK SMALL LETTER OMEGA */,/* 1139 */
/* U+A374 */	0x3105	/*                             BOPOMOFO LETTER B */,/* 1140 */
/* U+A375 */	0x3106	/*                             BOPOMOFO LETTER P */,/* 1141 */
/* U+A376 */	0x3107	/*                             BOPOMOFO LETTER M */,/* 1142 */
/* U+A377 */	0x3108	/*                             BOPOMOFO LETTER F */,/* 1143 */
/* U+A378 */	0x3109	/*                             BOPOMOFO LETTER D */,/* 1144 */
/* U+A379 */	0x310A	/*                             BOPOMOFO LETTER T */,/* 1145 */
/* U+A37A */	0x310B	/*                             BOPOMOFO LETTER N */,/* 1146 */
/* U+A37B */	0x310C	/*                             BOPOMOFO LETTER L */,/* 1147 */
/* U+A37C */	0x310D	/*                             BOPOMOFO LETTER G */,/* 1148 */
/* U+A37D */	0x310E	/*                             BOPOMOFO LETTER K */,/* 1149 */
/* U+A37E */	0x310F	/*                             BOPOMOFO LETTER H */,/* 1150 */
/* U+A37F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1151 */
/* U+A380 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1152 */
/* U+A381 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1153 */
/* U+A382 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1154 */
/* U+A383 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1155 */
/* U+A384 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1156 */
/* U+A385 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1157 */
/* U+A386 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1158 */
/* U+A387 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1159 */
/* U+A388 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1160 */
/* U+A389 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1161 */
/* U+A38A */	UNICODE_REPLACEMENT_CHARACTER,	/* 1162 */
/* U+A38B */	UNICODE_REPLACEMENT_CHARACTER,	/* 1163 */
/* U+A38C */	UNICODE_REPLACEMENT_CHARACTER,	/* 1164 */
/* U+A38D */	UNICODE_REPLACEMENT_CHARACTER,	/* 1165 */
/* U+A38E */	UNICODE_REPLACEMENT_CHARACTER,	/* 1166 */
/* U+A38F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1167 */
/* U+A390 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1168 */
/* U+A391 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1169 */
/* U+A392 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1170 */
/* U+A393 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1171 */
/* U+A394 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1172 */
/* U+A395 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1173 */
/* U+A396 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1174 */
/* U+A397 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1175 */
/* U+A398 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1176 */
/* U+A399 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1177 */
/* U+A39A */	UNICODE_REPLACEMENT_CHARACTER,	/* 1178 */
/* U+A39B */	UNICODE_REPLACEMENT_CHARACTER,	/* 1179 */
/* U+A39C */	UNICODE_REPLACEMENT_CHARACTER,	/* 1180 */
/* U+A39D */	UNICODE_REPLACEMENT_CHARACTER,	/* 1181 */
/* U+A39E */	UNICODE_REPLACEMENT_CHARACTER,	/* 1182 */
/* U+A39F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1183 */
/* U+A3A0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1184 */
/* U+A3A1 */	0x3110	/*                             BOPOMOFO LETTER J */,/* 1185 */
/* U+A3A2 */	0x3111	/*                             BOPOMOFO LETTER Q */,/* 1186 */
/* U+A3A3 */	0x3112	/*                             BOPOMOFO LETTER X */,/* 1187 */
/* U+A3A4 */	0x3113	/*                            BOPOMOFO LETTER ZH */,/* 1188 */
/* U+A3A5 */	0x3114	/*                            BOPOMOFO LETTER CH */,/* 1189 */
/* U+A3A6 */	0x3115	/*                            BOPOMOFO LETTER SH */,/* 1190 */
/* U+A3A7 */	0x3116	/*                             BOPOMOFO LETTER R */,/* 1191 */
/* U+A3A8 */	0x3117	/*                             BOPOMOFO LETTER Z */,/* 1192 */
/* U+A3A9 */	0x3118	/*                             BOPOMOFO LETTER C */,/* 1193 */
/* U+A3AA */	0x3119	/*                             BOPOMOFO LETTER S */,/* 1194 */
/* U+A3AB */	0x311A	/*                             BOPOMOFO LETTER A */,/* 1195 */
/* U+A3AC */	0x311B	/*                             BOPOMOFO LETTER O */,/* 1196 */
/* U+A3AD */	0x311C	/*                             BOPOMOFO LETTER E */,/* 1197 */
/* U+A3AE */	0x311D	/*                            BOPOMOFO LETTER EH */,/* 1198 */
/* U+A3AF */	0x311E	/*                            BOPOMOFO LETTER AI */,/* 1199 */
/* U+A3B0 */	0x311F	/*                            BOPOMOFO LETTER EI */,/* 1200 */
/* U+A3B1 */	0x3120	/*                            BOPOMOFO LETTER AU */,/* 1201 */
/* U+A3B2 */	0x3121	/*                            BOPOMOFO LETTER OU */,/* 1202 */
/* U+A3B3 */	0x3122	/*                            BOPOMOFO LETTER AN */,/* 1203 */
/* U+A3B4 */	0x3123	/*                            BOPOMOFO LETTER EN */,/* 1204 */
/* U+A3B5 */	0x3124	/*                           BOPOMOFO LETTER ANG */,/* 1205 */
/* U+A3B6 */	0x3125	/*                           BOPOMOFO LETTER ENG */,/* 1206 */
/* U+A3B7 */	0x3126	/*                            BOPOMOFO LETTER ER */,/* 1207 */
/* U+A3B8 */	0x3127	/*                             BOPOMOFO LETTER I */,/* 1208 */
/* U+A3B9 */	0x3128	/*                             BOPOMOFO LETTER U */,/* 1209 */
/* U+A3BA */	0x3129	/*                            BOPOMOFO LETTER IU */,/* 1210 */
/* U+A3BB */	0x02D9	/*       DOT ABOVE (Mandarin Chinese light tone) */,/* 1211 */
/* U+A3BC */	0x02C9	/*  MODIFIER LETTER MACRON (Mandarin Chinese first tone) */,/* 1212 */
/* U+A3BD */	0x02CA	/*  MODIFIER LETTER ACUTE ACCENT (Mandarin Chinese second tone) */,/* 1213 */
/* U+A3BE */	0x02C7	/*           CARON (Mandarin Chinese third tone) */,/* 1214 */
/* U+A3BF */	0x02CB	/*  MODIFIER LETTER GRAVE ACCENT (Mandarin Chinese fourth tone) */,/* 1215 */
/* U+A3C0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1216 */
/* U+A3C1 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1217 */
/* U+A3C2 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1218 */
/* U+A3C3 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1219 */
/* U+A3C4 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1220 */
/* U+A3C5 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1221 */
/* U+A3C6 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1222 */
/* U+A3C7 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1223 */
/* U+A3C8 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1224 */
/* U+A3C9 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1225 */
/* U+A3CA */	UNICODE_REPLACEMENT_CHARACTER,	/* 1226 */
/* U+A3CB */	UNICODE_REPLACEMENT_CHARACTER,	/* 1227 */
/* U+A3CC */	UNICODE_REPLACEMENT_CHARACTER,	/* 1228 */
/* U+A3CD */	UNICODE_REPLACEMENT_CHARACTER,	/* 1229 */
/* U+A3CE */	UNICODE_REPLACEMENT_CHARACTER,	/* 1230 */
/* U+A3CF */	UNICODE_REPLACEMENT_CHARACTER,	/* 1231 */
/* U+A3D0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1232 */
/* U+A3D1 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1233 */
/* U+A3D2 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1234 */
/* U+A3D3 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1235 */
/* U+A3D4 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1236 */
/* U+A3D5 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1237 */
/* U+A3D6 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1238 */
/* U+A3D7 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1239 */
/* U+A3D8 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1240 */
/* U+A3D9 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1241 */
/* U+A3DA */	UNICODE_REPLACEMENT_CHARACTER,	/* 1242 */
/* U+A3DB */	UNICODE_REPLACEMENT_CHARACTER,	/* 1243 */
/* U+A3DC */	UNICODE_REPLACEMENT_CHARACTER,	/* 1244 */
/* U+A3DD */	UNICODE_REPLACEMENT_CHARACTER,	/* 1245 */
/* U+A3DE */	UNICODE_REPLACEMENT_CHARACTER,	/* 1246 */
/* U+A3DF */	UNICODE_REPLACEMENT_CHARACTER,	/* 1247 */
/* U+A3E0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1248 */
/* U+A3E1 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1249 */
/* U+A3E2 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1250 */
/* U+A3E3 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1251 */
/* U+A3E4 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1252 */
/* U+A3E5 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1253 */
/* U+A3E6 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1254 */
/* U+A3E7 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1255 */
/* U+A3E8 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1256 */
/* U+A3E9 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1257 */
/* U+A3EA */	UNICODE_REPLACEMENT_CHARACTER,	/* 1258 */
/* U+A3EB */	UNICODE_REPLACEMENT_CHARACTER,	/* 1259 */
/* U+A3EC */	UNICODE_REPLACEMENT_CHARACTER,	/* 1260 */
/* U+A3ED */	UNICODE_REPLACEMENT_CHARACTER,	/* 1261 */
/* U+A3EE */	UNICODE_REPLACEMENT_CHARACTER,	/* 1262 */
/* U+A3EF */	UNICODE_REPLACEMENT_CHARACTER,	/* 1263 */
/* U+A3F0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1264 */
/* U+A3F1 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1265 */
/* U+A3F2 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1266 */
/* U+A3F3 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1267 */
/* U+A3F4 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1268 */
/* U+A3F5 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1269 */
/* U+A3F6 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1270 */
/* U+A3F7 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1271 */
/* U+A3F8 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1272 */
/* U+A3F9 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1273 */
/* U+A3FA */	UNICODE_REPLACEMENT_CHARACTER,	/* 1274 */
/* U+A3FB */	UNICODE_REPLACEMENT_CHARACTER,	/* 1275 */
/* U+A3FC */	UNICODE_REPLACEMENT_CHARACTER,	/* 1276 */
/* U+A3FD */	UNICODE_REPLACEMENT_CHARACTER,	/* 1277 */
/* U+A3FE */	UNICODE_REPLACEMENT_CHARACTER,	/* 1278 */
/* U+A3FF */	UNICODE_REPLACEMENT_CHARACTER,	/* 1279 */
/* U+A400 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1280 */
/* U+A401 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1281 */
/* U+A402 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1282 */
/* U+A403 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1283 */
/* U+A404 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1284 */
/* U+A405 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1285 */
/* U+A406 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1286 */
/* U+A407 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1287 */
/* U+A408 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1288 */
/* U+A409 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1289 */
/* U+A40A */	UNICODE_REPLACEMENT_CHARACTER,	/* 1290 */
/* U+A40B */	UNICODE_REPLACEMENT_CHARACTER,	/* 1291 */
/* U+A40C */	UNICODE_REPLACEMENT_CHARACTER,	/* 1292 */
/* U+A40D */	UNICODE_REPLACEMENT_CHARACTER,	/* 1293 */
/* U+A40E */	UNICODE_REPLACEMENT_CHARACTER,	/* 1294 */
/* U+A40F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1295 */
/* U+A410 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1296 */
/* U+A411 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1297 */
/* U+A412 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1298 */
/* U+A413 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1299 */
/* U+A414 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1300 */
/* U+A415 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1301 */
/* U+A416 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1302 */
/* U+A417 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1303 */
/* U+A418 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1304 */
/* U+A419 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1305 */
/* U+A41A */	UNICODE_REPLACEMENT_CHARACTER,	/* 1306 */
/* U+A41B */	UNICODE_REPLACEMENT_CHARACTER,	/* 1307 */
/* U+A41C */	UNICODE_REPLACEMENT_CHARACTER,	/* 1308 */
/* U+A41D */	UNICODE_REPLACEMENT_CHARACTER,	/* 1309 */
/* U+A41E */	UNICODE_REPLACEMENT_CHARACTER,	/* 1310 */
/* U+A41F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1311 */
/* U+A420 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1312 */
/* U+A421 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1313 */
/* U+A422 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1314 */
/* U+A423 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1315 */
/* U+A424 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1316 */
/* U+A425 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1317 */
/* U+A426 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1318 */
/* U+A427 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1319 */
/* U+A428 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1320 */
/* U+A429 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1321 */
/* U+A42A */	UNICODE_REPLACEMENT_CHARACTER,	/* 1322 */
/* U+A42B */	UNICODE_REPLACEMENT_CHARACTER,	/* 1323 */
/* U+A42C */	UNICODE_REPLACEMENT_CHARACTER,	/* 1324 */
/* U+A42D */	UNICODE_REPLACEMENT_CHARACTER,	/* 1325 */
/* U+A42E */	UNICODE_REPLACEMENT_CHARACTER,	/* 1326 */
/* U+A42F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1327 */
/* U+A430 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1328 */
/* U+A431 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1329 */
/* U+A432 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1330 */
/* U+A433 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1331 */
/* U+A434 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1332 */
/* U+A435 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1333 */
/* U+A436 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1334 */
/* U+A437 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1335 */
/* U+A438 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1336 */
/* U+A439 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1337 */
/* U+A43A */	UNICODE_REPLACEMENT_CHARACTER,	/* 1338 */
/* U+A43B */	UNICODE_REPLACEMENT_CHARACTER,	/* 1339 */
/* U+A43C */	UNICODE_REPLACEMENT_CHARACTER,	/* 1340 */
/* U+A43D */	UNICODE_REPLACEMENT_CHARACTER,	/* 1341 */
/* U+A43E */	UNICODE_REPLACEMENT_CHARACTER,	/* 1342 */
/* U+A43F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1343 */
/* U+A440 */	0x4E00	/*                                         <CJK> */,/* 1344 */
/* U+A441 */	0x4E59	/*                                         <CJK> */,/* 1345 */
/* U+A442 */	0x4E01	/*                                         <CJK> */,/* 1346 */
/* U+A443 */	0x4E03	/*                                         <CJK> */,/* 1347 */
/* U+A444 */	0x4E43	/*                                         <CJK> */,/* 1348 */
/* U+A445 */	0x4E5D	/*                                         <CJK> */,/* 1349 */
/* U+A446 */	0x4E86	/*                                         <CJK> */,/* 1350 */
/* U+A447 */	0x4E8C	/*                                         <CJK> */,/* 1351 */
/* U+A448 */	0x4EBA	/*                                         <CJK> */,/* 1352 */
/* U+A449 */	0x513F	/*                                         <CJK> */,/* 1353 */
/* U+A44A */	0x5165	/*                                         <CJK> */,/* 1354 */
/* U+A44B */	0x516B	/*                                         <CJK> */,/* 1355 */
/* U+A44C */	0x51E0	/*                                         <CJK> */,/* 1356 */
/* U+A44D */	0x5200	/*                                         <CJK> */,/* 1357 */
/* U+A44E */	0x5201	/*                                         <CJK> */,/* 1358 */
/* U+A44F */	0x529B	/*                                         <CJK> */,/* 1359 */
/* U+A450 */	0x5315	/*                                         <CJK> */,/* 1360 */
/* U+A451 */	0x5341	/*                                         <CJK> */,/* 1361 */
/* U+A452 */	0x535C	/*                                         <CJK> */,/* 1362 */
/* U+A453 */	0x53C8	/*                                         <CJK> */,/* 1363 */
/* U+A454 */	0x4E09	/*                                         <CJK> */,/* 1364 */
/* U+A455 */	0x4E0B	/*                                         <CJK> */,/* 1365 */
/* U+A456 */	0x4E08	/*                                         <CJK> */,/* 1366 */
/* U+A457 */	0x4E0A	/*                                         <CJK> */,/* 1367 */
/* U+A458 */	0x4E2B	/*                                         <CJK> */,/* 1368 */
/* U+A459 */	0x4E38	/*                                         <CJK> */,/* 1369 */
/* U+A45A */	0x51E1	/*                                         <CJK> */,/* 1370 */
/* U+A45B */	0x4E45	/*                                         <CJK> */,/* 1371 */
/* U+A45C */	0x4E48	/*                                         <CJK> */,/* 1372 */
/* U+A45D */	0x4E5F	/*                                         <CJK> */,/* 1373 */
/* U+A45E */	0x4E5E	/*                                         <CJK> */,/* 1374 */
/* U+A45F */	0x4E8E	/*                                         <CJK> */,/* 1375 */
/* U+A460 */	0x4EA1	/*                                         <CJK> */,/* 1376 */
/* U+A461 */	0x5140	/*                                         <CJK> */,/* 1377 */
/* U+A462 */	0x5203	/*                                         <CJK> */,/* 1378 */
/* U+A463 */	0x52FA	/*                                         <CJK> */,/* 1379 */
/* U+A464 */	0x5343	/*                                         <CJK> */,/* 1380 */
/* U+A465 */	0x53C9	/*                                         <CJK> */,/* 1381 */
/* U+A466 */	0x53E3	/*                                         <CJK> */,/* 1382 */
/* U+A467 */	0x571F	/*                                         <CJK> */,/* 1383 */
/* U+A468 */	0x58EB	/*                                         <CJK> */,/* 1384 */
/* U+A469 */	0x5915	/*                                         <CJK> */,/* 1385 */
/* U+A46A */	0x5927	/*                                         <CJK> */,/* 1386 */
/* U+A46B */	0x5973	/*                                         <CJK> */,/* 1387 */
/* U+A46C */	0x5B50	/*                                         <CJK> */,/* 1388 */
/* U+A46D */	0x5B51	/*                                         <CJK> */,/* 1389 */
/* U+A46E */	0x5B53	/*                                         <CJK> */,/* 1390 */
/* U+A46F */	0x5BF8	/*                                         <CJK> */,/* 1391 */
/* U+A470 */	0x5C0F	/*                                         <CJK> */,/* 1392 */
/* U+A471 */	0x5C22	/*                                         <CJK> */,/* 1393 */
/* U+A472 */	0x5C38	/*                                         <CJK> */,/* 1394 */
/* U+A473 */	0x5C71	/*                                         <CJK> */,/* 1395 */
/* U+A474 */	0x5DDD	/*                                         <CJK> */,/* 1396 */
/* U+A475 */	0x5DE5	/*                                         <CJK> */,/* 1397 */
/* U+A476 */	0x5DF1	/*                                         <CJK> */,/* 1398 */
/* U+A477 */	0x5DF2	/*                                         <CJK> */,/* 1399 */
/* U+A478 */	0x5DF3	/*                                         <CJK> */,/* 1400 */
/* U+A479 */	0x5DFE	/*                                         <CJK> */,/* 1401 */
/* U+A47A */	0x5E72	/*                                         <CJK> */,/* 1402 */
/* U+A47B */	0x5EFE	/*                                         <CJK> */,/* 1403 */
/* U+A47C */	0x5F0B	/*                                         <CJK> */,/* 1404 */
/* U+A47D */	0x5F13	/*                                         <CJK> */,/* 1405 */
/* U+A47E */	0x624D	/*                                         <CJK> */,/* 1406 */
/* U+A47F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1407 */
/* U+A480 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1408 */
/* U+A481 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1409 */
/* U+A482 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1410 */
/* U+A483 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1411 */
/* U+A484 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1412 */
/* U+A485 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1413 */
/* U+A486 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1414 */
/* U+A487 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1415 */
/* U+A488 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1416 */
/* U+A489 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1417 */
/* U+A48A */	UNICODE_REPLACEMENT_CHARACTER,	/* 1418 */
/* U+A48B */	UNICODE_REPLACEMENT_CHARACTER,	/* 1419 */
/* U+A48C */	UNICODE_REPLACEMENT_CHARACTER,	/* 1420 */
/* U+A48D */	UNICODE_REPLACEMENT_CHARACTER,	/* 1421 */
/* U+A48E */	UNICODE_REPLACEMENT_CHARACTER,	/* 1422 */
/* U+A48F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1423 */
/* U+A490 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1424 */
/* U+A491 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1425 */
/* U+A492 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1426 */
/* U+A493 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1427 */
/* U+A494 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1428 */
/* U+A495 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1429 */
/* U+A496 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1430 */
/* U+A497 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1431 */
/* U+A498 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1432 */
/* U+A499 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1433 */
/* U+A49A */	UNICODE_REPLACEMENT_CHARACTER,	/* 1434 */
/* U+A49B */	UNICODE_REPLACEMENT_CHARACTER,	/* 1435 */
/* U+A49C */	UNICODE_REPLACEMENT_CHARACTER,	/* 1436 */
/* U+A49D */	UNICODE_REPLACEMENT_CHARACTER,	/* 1437 */
/* U+A49E */	UNICODE_REPLACEMENT_CHARACTER,	/* 1438 */
/* U+A49F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1439 */
/* U+A4A0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1440 */
/* U+A4A1 */	0x4E11	/*                                         <CJK> */,/* 1441 */
/* U+A4A2 */	0x4E10	/*                                         <CJK> */,/* 1442 */
/* U+A4A3 */	0x4E0D	/*                                         <CJK> */,/* 1443 */
/* U+A4A4 */	0x4E2D	/*                                         <CJK> */,/* 1444 */
/* U+A4A5 */	0x4E30	/*                                         <CJK> */,/* 1445 */
/* U+A4A6 */	0x4E39	/*                                         <CJK> */,/* 1446 */
/* U+A4A7 */	0x4E4B	/*                                         <CJK> */,/* 1447 */
/* U+A4A8 */	0x5C39	/*                                         <CJK> */,/* 1448 */
/* U+A4A9 */	0x4E88	/*                                         <CJK> */,/* 1449 */
/* U+A4AA */	0x4E91	/*                                         <CJK> */,/* 1450 */
/* U+A4AB */	0x4E95	/*                                         <CJK> */,/* 1451 */
/* U+A4AC */	0x4E92	/*                                         <CJK> */,/* 1452 */
/* U+A4AD */	0x4E94	/*                                         <CJK> */,/* 1453 */
/* U+A4AE */	0x4EA2	/*                                         <CJK> */,/* 1454 */
/* U+A4AF */	0x4EC1	/*                                         <CJK> */,/* 1455 */
/* U+A4B0 */	0x4EC0	/*                                         <CJK> */,/* 1456 */
/* U+A4B1 */	0x4EC3	/*                                         <CJK> */,/* 1457 */
/* U+A4B2 */	0x4EC6	/*                                         <CJK> */,/* 1458 */
/* U+A4B3 */	0x4EC7	/*                                         <CJK> */,/* 1459 */
/* U+A4B4 */	0x4ECD	/*                                         <CJK> */,/* 1460 */
/* U+A4B5 */	0x4ECA	/*                                         <CJK> */,/* 1461 */
/* U+A4B6 */	0x4ECB	/*                                         <CJK> */,/* 1462 */
/* U+A4B7 */	0x4EC4	/*                                         <CJK> */,/* 1463 */
/* U+A4B8 */	0x5143	/*                                         <CJK> */,/* 1464 */
/* U+A4B9 */	0x5141	/*                                         <CJK> */,/* 1465 */
/* U+A4BA */	0x5167	/*                                         <CJK> */,/* 1466 */
/* U+A4BB */	0x516D	/*                                         <CJK> */,/* 1467 */
/* U+A4BC */	0x516E	/*                                         <CJK> */,/* 1468 */
/* U+A4BD */	0x516C	/*                                         <CJK> */,/* 1469 */
/* U+A4BE */	0x5197	/*                                         <CJK> */,/* 1470 */
/* U+A4BF */	0x51F6	/*                                         <CJK> */,/* 1471 */
/* U+A4C0 */	0x5206	/*                                         <CJK> */,/* 1472 */
/* U+A4C1 */	0x5207	/*                                         <CJK> */,/* 1473 */
/* U+A4C2 */	0x5208	/*                                         <CJK> */,/* 1474 */
/* U+A4C3 */	0x52FB	/*                                         <CJK> */,/* 1475 */
/* U+A4C4 */	0x52FE	/*                                         <CJK> */,/* 1476 */
/* U+A4C5 */	0x52FF	/*                                         <CJK> */,/* 1477 */
/* U+A4C6 */	0x5316	/*                                         <CJK> */,/* 1478 */
/* U+A4C7 */	0x5339	/*                                         <CJK> */,/* 1479 */
/* U+A4C8 */	0x5348	/*                                         <CJK> */,/* 1480 */
/* U+A4C9 */	0x5347	/*                                         <CJK> */,/* 1481 */
/* U+A4CA */	0x5345	/*                                         <CJK> */,/* 1482 */
/* U+A4CB */	0x535E	/*                                         <CJK> */,/* 1483 */
/* U+A4CC */	0x5384	/*                                         <CJK> */,/* 1484 */
/* U+A4CD */	0x53CB	/*                                         <CJK> */,/* 1485 */
/* U+A4CE */	0x53CA	/*                                         <CJK> */,/* 1486 */
/* U+A4CF */	0x53CD	/*                                         <CJK> */,/* 1487 */
/* U+A4D0 */	0x58EC	/*                                         <CJK> */,/* 1488 */
/* U+A4D1 */	0x5929	/*                                         <CJK> */,/* 1489 */
/* U+A4D2 */	0x592B	/*                                         <CJK> */,/* 1490 */
/* U+A4D3 */	0x592A	/*                                         <CJK> */,/* 1491 */
/* U+A4D4 */	0x592D	/*                                         <CJK> */,/* 1492 */
/* U+A4D5 */	0x5B54	/*                                         <CJK> */,/* 1493 */
/* U+A4D6 */	0x5C11	/*                                         <CJK> */,/* 1494 */
/* U+A4D7 */	0x5C24	/*                                         <CJK> */,/* 1495 */
/* U+A4D8 */	0x5C3A	/*                                         <CJK> */,/* 1496 */
/* U+A4D9 */	0x5C6F	/*                                         <CJK> */,/* 1497 */
/* U+A4DA */	0x5DF4	/*                                         <CJK> */,/* 1498 */
/* U+A4DB */	0x5E7B	/*                                         <CJK> */,/* 1499 */
/* U+A4DC */	0x5EFF	/*                                         <CJK> */,/* 1500 */
/* U+A4DD */	0x5F14	/*                                         <CJK> */,/* 1501 */
/* U+A4DE */	0x5F15	/*                                         <CJK> */,/* 1502 */
/* U+A4DF */	0x5FC3	/*                                         <CJK> */,/* 1503 */
/* U+A4E0 */	0x6208	/*                                         <CJK> */,/* 1504 */
/* U+A4E1 */	0x6236	/*                                         <CJK> */,/* 1505 */
/* U+A4E2 */	0x624B	/*                                         <CJK> */,/* 1506 */
/* U+A4E3 */	0x624E	/*                                         <CJK> */,/* 1507 */
/* U+A4E4 */	0x652F	/*                                         <CJK> */,/* 1508 */
/* U+A4E5 */	0x6587	/*                                         <CJK> */,/* 1509 */
/* U+A4E6 */	0x6597	/*                                         <CJK> */,/* 1510 */
/* U+A4E7 */	0x65A4	/*                                         <CJK> */,/* 1511 */
/* U+A4E8 */	0x65B9	/*                                         <CJK> */,/* 1512 */
/* U+A4E9 */	0x65E5	/*                                         <CJK> */,/* 1513 */
/* U+A4EA */	0x66F0	/*                                         <CJK> */,/* 1514 */
/* U+A4EB */	0x6708	/*                                         <CJK> */,/* 1515 */
/* U+A4EC */	0x6728	/*                                         <CJK> */,/* 1516 */
/* U+A4ED */	0x6B20	/*                                         <CJK> */,/* 1517 */
/* U+A4EE */	0x6B62	/*                                         <CJK> */,/* 1518 */
/* U+A4EF */	0x6B79	/*                                         <CJK> */,/* 1519 */
/* U+A4F0 */	0x6BCB	/*                                         <CJK> */,/* 1520 */
/* U+A4F1 */	0x6BD4	/*                                         <CJK> */,/* 1521 */
/* U+A4F2 */	0x6BDB	/*                                         <CJK> */,/* 1522 */
/* U+A4F3 */	0x6C0F	/*                                         <CJK> */,/* 1523 */
/* U+A4F4 */	0x6C34	/*                                         <CJK> */,/* 1524 */
/* U+A4F5 */	0x706B	/*                                         <CJK> */,/* 1525 */
/* U+A4F6 */	0x722A	/*                                         <CJK> */,/* 1526 */
/* U+A4F7 */	0x7236	/*                                         <CJK> */,/* 1527 */
/* U+A4F8 */	0x723B	/*                                         <CJK> */,/* 1528 */
/* U+A4F9 */	0x7247	/*                                         <CJK> */,/* 1529 */
/* U+A4FA */	0x7259	/*                                         <CJK> */,/* 1530 */
/* U+A4FB */	0x725B	/*                                         <CJK> */,/* 1531 */
/* U+A4FC */	0x72AC	/*                                         <CJK> */,/* 1532 */
/* U+A4FD */	0x738B	/*                                         <CJK> */,/* 1533 */
/* U+A4FE */	0x4E19	/*                                         <CJK> */,/* 1534 */
/* U+A4FF */	UNICODE_REPLACEMENT_CHARACTER,	/* 1535 */
/* U+A500 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1536 */
/* U+A501 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1537 */
/* U+A502 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1538 */
/* U+A503 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1539 */
/* U+A504 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1540 */
/* U+A505 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1541 */
/* U+A506 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1542 */
/* U+A507 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1543 */
/* U+A508 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1544 */
/* U+A509 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1545 */
/* U+A50A */	UNICODE_REPLACEMENT_CHARACTER,	/* 1546 */
/* U+A50B */	UNICODE_REPLACEMENT_CHARACTER,	/* 1547 */
/* U+A50C */	UNICODE_REPLACEMENT_CHARACTER,	/* 1548 */
/* U+A50D */	UNICODE_REPLACEMENT_CHARACTER,	/* 1549 */
/* U+A50E */	UNICODE_REPLACEMENT_CHARACTER,	/* 1550 */
/* U+A50F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1551 */
/* U+A510 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1552 */
/* U+A511 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1553 */
/* U+A512 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1554 */
/* U+A513 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1555 */
/* U+A514 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1556 */
/* U+A515 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1557 */
/* U+A516 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1558 */
/* U+A517 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1559 */
/* U+A518 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1560 */
/* U+A519 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1561 */
/* U+A51A */	UNICODE_REPLACEMENT_CHARACTER,	/* 1562 */
/* U+A51B */	UNICODE_REPLACEMENT_CHARACTER,	/* 1563 */
/* U+A51C */	UNICODE_REPLACEMENT_CHARACTER,	/* 1564 */
/* U+A51D */	UNICODE_REPLACEMENT_CHARACTER,	/* 1565 */
/* U+A51E */	UNICODE_REPLACEMENT_CHARACTER,	/* 1566 */
/* U+A51F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1567 */
/* U+A520 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1568 */
/* U+A521 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1569 */
/* U+A522 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1570 */
/* U+A523 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1571 */
/* U+A524 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1572 */
/* U+A525 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1573 */
/* U+A526 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1574 */
/* U+A527 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1575 */
/* U+A528 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1576 */
/* U+A529 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1577 */
/* U+A52A */	UNICODE_REPLACEMENT_CHARACTER,	/* 1578 */
/* U+A52B */	UNICODE_REPLACEMENT_CHARACTER,	/* 1579 */
/* U+A52C */	UNICODE_REPLACEMENT_CHARACTER,	/* 1580 */
/* U+A52D */	UNICODE_REPLACEMENT_CHARACTER,	/* 1581 */
/* U+A52E */	UNICODE_REPLACEMENT_CHARACTER,	/* 1582 */
/* U+A52F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1583 */
/* U+A530 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1584 */
/* U+A531 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1585 */
/* U+A532 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1586 */
/* U+A533 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1587 */
/* U+A534 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1588 */
/* U+A535 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1589 */
/* U+A536 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1590 */
/* U+A537 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1591 */
/* U+A538 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1592 */
/* U+A539 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1593 */
/* U+A53A */	UNICODE_REPLACEMENT_CHARACTER,	/* 1594 */
/* U+A53B */	UNICODE_REPLACEMENT_CHARACTER,	/* 1595 */
/* U+A53C */	UNICODE_REPLACEMENT_CHARACTER,	/* 1596 */
/* U+A53D */	UNICODE_REPLACEMENT_CHARACTER,	/* 1597 */
/* U+A53E */	UNICODE_REPLACEMENT_CHARACTER,	/* 1598 */
/* U+A53F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1599 */
/* U+A540 */	0x4E16	/*                                         <CJK> */,/* 1600 */
/* U+A541 */	0x4E15	/*                                         <CJK> */,/* 1601 */
/* U+A542 */	0x4E14	/*                                         <CJK> */,/* 1602 */
/* U+A543 */	0x4E18	/*                                         <CJK> */,/* 1603 */
/* U+A544 */	0x4E3B	/*                                         <CJK> */,/* 1604 */
/* U+A545 */	0x4E4D	/*                                         <CJK> */,/* 1605 */
/* U+A546 */	0x4E4F	/*                                         <CJK> */,/* 1606 */
/* U+A547 */	0x4E4E	/*                                         <CJK> */,/* 1607 */
/* U+A548 */	0x4EE5	/*                                         <CJK> */,/* 1608 */
/* U+A549 */	0x4ED8	/*                                         <CJK> */,/* 1609 */
/* U+A54A */	0x4ED4	/*                                         <CJK> */,/* 1610 */
/* U+A54B */	0x4ED5	/*                                         <CJK> */,/* 1611 */
/* U+A54C */	0x4ED6	/*                                         <CJK> */,/* 1612 */
/* U+A54D */	0x4ED7	/*                                         <CJK> */,/* 1613 */
/* U+A54E */	0x4EE3	/*                                         <CJK> */,/* 1614 */
/* U+A54F */	0x4EE4	/*                                         <CJK> */,/* 1615 */
/* U+A550 */	0x4ED9	/*                                         <CJK> */,/* 1616 */
/* U+A551 */	0x4EDE	/*                                         <CJK> */,/* 1617 */
/* U+A552 */	0x5145	/*                                         <CJK> */,/* 1618 */
/* U+A553 */	0x5144	/*                                         <CJK> */,/* 1619 */
/* U+A554 */	0x5189	/*                                         <CJK> */,/* 1620 */
/* U+A555 */	0x518A	/*                                         <CJK> */,/* 1621 */
/* U+A556 */	0x51AC	/*                                         <CJK> */,/* 1622 */
/* U+A557 */	0x51F9	/*                                         <CJK> */,/* 1623 */
/* U+A558 */	0x51FA	/*                                         <CJK> */,/* 1624 */
/* U+A559 */	0x51F8	/*                                         <CJK> */,/* 1625 */
/* U+A55A */	0x520A	/*                                         <CJK> */,/* 1626 */
/* U+A55B */	0x52A0	/*                                         <CJK> */,/* 1627 */
/* U+A55C */	0x529F	/*                                         <CJK> */,/* 1628 */
/* U+A55D */	0x5305	/*                                         <CJK> */,/* 1629 */
/* U+A55E */	0x5306	/*                                         <CJK> */,/* 1630 */
/* U+A55F */	0x5317	/*                                         <CJK> */,/* 1631 */
/* U+A560 */	0x531D	/*                                         <CJK> */,/* 1632 */
/* U+A561 */	0x4EDF	/*                                         <CJK> */,/* 1633 */
/* U+A562 */	0x534A	/*                                         <CJK> */,/* 1634 */
/* U+A563 */	0x5349	/*                                         <CJK> */,/* 1635 */
/* U+A564 */	0x5361	/*                                         <CJK> */,/* 1636 */
/* U+A565 */	0x5360	/*                                         <CJK> */,/* 1637 */
/* U+A566 */	0x536F	/*                                         <CJK> */,/* 1638 */
/* U+A567 */	0x536E	/*                                         <CJK> */,/* 1639 */
/* U+A568 */	0x53BB	/*                                         <CJK> */,/* 1640 */
/* U+A569 */	0x53EF	/*                                         <CJK> */,/* 1641 */
/* U+A56A */	0x53E4	/*                                         <CJK> */,/* 1642 */
/* U+A56B */	0x53F3	/*                                         <CJK> */,/* 1643 */
/* U+A56C */	0x53EC	/*                                         <CJK> */,/* 1644 */
/* U+A56D */	0x53EE	/*                                         <CJK> */,/* 1645 */
/* U+A56E */	0x53E9	/*                                         <CJK> */,/* 1646 */
/* U+A56F */	0x53E8	/*                                         <CJK> */,/* 1647 */
/* U+A570 */	0x53FC	/*                                         <CJK> */,/* 1648 */
/* U+A571 */	0x53F8	/*                                         <CJK> */,/* 1649 */
/* U+A572 */	0x53F5	/*                                         <CJK> */,/* 1650 */
/* U+A573 */	0x53EB	/*                                         <CJK> */,/* 1651 */
/* U+A574 */	0x53E6	/*                                         <CJK> */,/* 1652 */
/* U+A575 */	0x53EA	/*                                         <CJK> */,/* 1653 */
/* U+A576 */	0x53F2	/*                                         <CJK> */,/* 1654 */
/* U+A577 */	0x53F1	/*                                         <CJK> */,/* 1655 */
/* U+A578 */	0x53F0	/*                                         <CJK> */,/* 1656 */
/* U+A579 */	0x53E5	/*                                         <CJK> */,/* 1657 */
/* U+A57A */	0x53ED	/*                                         <CJK> */,/* 1658 */
/* U+A57B */	0x53FB	/*                                         <CJK> */,/* 1659 */
/* U+A57C */	0x56DB	/*                                         <CJK> */,/* 1660 */
/* U+A57D */	0x56DA	/*                                         <CJK> */,/* 1661 */
/* U+A57E */	0x5916	/*                                         <CJK> */,/* 1662 */
/* U+A57F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1663 */
/* U+A580 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1664 */
/* U+A581 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1665 */
/* U+A582 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1666 */
/* U+A583 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1667 */
/* U+A584 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1668 */
/* U+A585 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1669 */
/* U+A586 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1670 */
/* U+A587 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1671 */
/* U+A588 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1672 */
/* U+A589 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1673 */
/* U+A58A */	UNICODE_REPLACEMENT_CHARACTER,	/* 1674 */
/* U+A58B */	UNICODE_REPLACEMENT_CHARACTER,	/* 1675 */
/* U+A58C */	UNICODE_REPLACEMENT_CHARACTER,	/* 1676 */
/* U+A58D */	UNICODE_REPLACEMENT_CHARACTER,	/* 1677 */
/* U+A58E */	UNICODE_REPLACEMENT_CHARACTER,	/* 1678 */
/* U+A58F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1679 */
/* U+A590 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1680 */
/* U+A591 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1681 */
/* U+A592 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1682 */
/* U+A593 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1683 */
/* U+A594 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1684 */
/* U+A595 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1685 */
/* U+A596 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1686 */
/* U+A597 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1687 */
/* U+A598 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1688 */
/* U+A599 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1689 */
/* U+A59A */	UNICODE_REPLACEMENT_CHARACTER,	/* 1690 */
/* U+A59B */	UNICODE_REPLACEMENT_CHARACTER,	/* 1691 */
/* U+A59C */	UNICODE_REPLACEMENT_CHARACTER,	/* 1692 */
/* U+A59D */	UNICODE_REPLACEMENT_CHARACTER,	/* 1693 */
/* U+A59E */	UNICODE_REPLACEMENT_CHARACTER,	/* 1694 */
/* U+A59F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1695 */
/* U+A5A0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1696 */
/* U+A5A1 */	0x592E	/*                                         <CJK> */,/* 1697 */
/* U+A5A2 */	0x5931	/*                                         <CJK> */,/* 1698 */
/* U+A5A3 */	0x5974	/*                                         <CJK> */,/* 1699 */
/* U+A5A4 */	0x5976	/*                                         <CJK> */,/* 1700 */
/* U+A5A5 */	0x5B55	/*                                         <CJK> */,/* 1701 */
/* U+A5A6 */	0x5B83	/*                                         <CJK> */,/* 1702 */
/* U+A5A7 */	0x5C3C	/*                                         <CJK> */,/* 1703 */
/* U+A5A8 */	0x5DE8	/*                                         <CJK> */,/* 1704 */
/* U+A5A9 */	0x5DE7	/*                                         <CJK> */,/* 1705 */
/* U+A5AA */	0x5DE6	/*                                         <CJK> */,/* 1706 */
/* U+A5AB */	0x5E02	/*                                         <CJK> */,/* 1707 */
/* U+A5AC */	0x5E03	/*                                         <CJK> */,/* 1708 */
/* U+A5AD */	0x5E73	/*                                         <CJK> */,/* 1709 */
/* U+A5AE */	0x5E7C	/*                                         <CJK> */,/* 1710 */
/* U+A5AF */	0x5F01	/*                                         <CJK> */,/* 1711 */
/* U+A5B0 */	0x5F18	/*                                         <CJK> */,/* 1712 */
/* U+A5B1 */	0x5F17	/*                                         <CJK> */,/* 1713 */
/* U+A5B2 */	0x5FC5	/*                                         <CJK> */,/* 1714 */
/* U+A5B3 */	0x620A	/*                                         <CJK> */,/* 1715 */
/* U+A5B4 */	0x6253	/*                                         <CJK> */,/* 1716 */
/* U+A5B5 */	0x6254	/*                                         <CJK> */,/* 1717 */
/* U+A5B6 */	0x6252	/*                                         <CJK> */,/* 1718 */
/* U+A5B7 */	0x6251	/*                                         <CJK> */,/* 1719 */
/* U+A5B8 */	0x65A5	/*                                         <CJK> */,/* 1720 */
/* U+A5B9 */	0x65E6	/*                                         <CJK> */,/* 1721 */
/* U+A5BA */	0x672E	/*                                         <CJK> */,/* 1722 */
/* U+A5BB */	0x672C	/*                                         <CJK> */,/* 1723 */
/* U+A5BC */	0x672A	/*                                         <CJK> */,/* 1724 */
/* U+A5BD */	0x672B	/*                                         <CJK> */,/* 1725 */
/* U+A5BE */	0x672D	/*                                         <CJK> */,/* 1726 */
/* U+A5BF */	0x6B63	/*                                         <CJK> */,/* 1727 */
/* U+A5C0 */	0x6BCD	/*                                         <CJK> */,/* 1728 */
/* U+A5C1 */	0x6C11	/*                                         <CJK> */,/* 1729 */
/* U+A5C2 */	0x6C10	/*                                         <CJK> */,/* 1730 */
/* U+A5C3 */	0x6C38	/*                                         <CJK> */,/* 1731 */
/* U+A5C4 */	0x6C41	/*                                         <CJK> */,/* 1732 */
/* U+A5C5 */	0x6C40	/*                                         <CJK> */,/* 1733 */
/* U+A5C6 */	0x6C3E	/*                                         <CJK> */,/* 1734 */
/* U+A5C7 */	0x72AF	/*                                         <CJK> */,/* 1735 */
/* U+A5C8 */	0x7384	/*                                         <CJK> */,/* 1736 */
/* U+A5C9 */	0x7389	/*                                         <CJK> */,/* 1737 */
/* U+A5CA */	0x74DC	/*                                         <CJK> */,/* 1738 */
/* U+A5CB */	0x74E6	/*                                         <CJK> */,/* 1739 */
/* U+A5CC */	0x7518	/*                                         <CJK> */,/* 1740 */
/* U+A5CD */	0x751F	/*                                         <CJK> */,/* 1741 */
/* U+A5CE */	0x7528	/*                                         <CJK> */,/* 1742 */
/* U+A5CF */	0x7529	/*                                         <CJK> */,/* 1743 */
/* U+A5D0 */	0x7530	/*                                         <CJK> */,/* 1744 */
/* U+A5D1 */	0x7531	/*                                         <CJK> */,/* 1745 */
/* U+A5D2 */	0x7532	/*                                         <CJK> */,/* 1746 */
/* U+A5D3 */	0x7533	/*                                         <CJK> */,/* 1747 */
/* U+A5D4 */	0x758B	/*                                         <CJK> */,/* 1748 */
/* U+A5D5 */	0x767D	/*                                         <CJK> */,/* 1749 */
/* U+A5D6 */	0x76AE	/*                                         <CJK> */,/* 1750 */
/* U+A5D7 */	0x76BF	/*                                         <CJK> */,/* 1751 */
/* U+A5D8 */	0x76EE	/*                                         <CJK> */,/* 1752 */
/* U+A5D9 */	0x77DB	/*                                         <CJK> */,/* 1753 */
/* U+A5DA */	0x77E2	/*                                         <CJK> */,/* 1754 */
/* U+A5DB */	0x77F3	/*                                         <CJK> */,/* 1755 */
/* U+A5DC */	0x793A	/*                                         <CJK> */,/* 1756 */
/* U+A5DD */	0x79BE	/*                                         <CJK> */,/* 1757 */
/* U+A5DE */	0x7A74	/*                                         <CJK> */,/* 1758 */
/* U+A5DF */	0x7ACB	/*                                         <CJK> */,/* 1759 */
/* U+A5E0 */	0x4E1E	/*                                         <CJK> */,/* 1760 */
/* U+A5E1 */	0x4E1F	/*                                         <CJK> */,/* 1761 */
/* U+A5E2 */	0x4E52	/*                                         <CJK> */,/* 1762 */
/* U+A5E3 */	0x4E53	/*                                         <CJK> */,/* 1763 */
/* U+A5E4 */	0x4E69	/*                                         <CJK> */,/* 1764 */
/* U+A5E5 */	0x4E99	/*                                         <CJK> */,/* 1765 */
/* U+A5E6 */	0x4EA4	/*                                         <CJK> */,/* 1766 */
/* U+A5E7 */	0x4EA6	/*                                         <CJK> */,/* 1767 */
/* U+A5E8 */	0x4EA5	/*                                         <CJK> */,/* 1768 */
/* U+A5E9 */	0x4EFF	/*                                         <CJK> */,/* 1769 */
/* U+A5EA */	0x4F09	/*                                         <CJK> */,/* 1770 */
/* U+A5EB */	0x4F19	/*                                         <CJK> */,/* 1771 */
/* U+A5EC */	0x4F0A	/*                                         <CJK> */,/* 1772 */
/* U+A5ED */	0x4F15	/*                                         <CJK> */,/* 1773 */
/* U+A5EE */	0x4F0D	/*                                         <CJK> */,/* 1774 */
/* U+A5EF */	0x4F10	/*                                         <CJK> */,/* 1775 */
/* U+A5F0 */	0x4F11	/*                                         <CJK> */,/* 1776 */
/* U+A5F1 */	0x4F0F	/*                                         <CJK> */,/* 1777 */
/* U+A5F2 */	0x4EF2	/*                                         <CJK> */,/* 1778 */
/* U+A5F3 */	0x4EF6	/*                                         <CJK> */,/* 1779 */
/* U+A5F4 */	0x4EFB	/*                                         <CJK> */,/* 1780 */
/* U+A5F5 */	0x4EF0	/*                                         <CJK> */,/* 1781 */
/* U+A5F6 */	0x4EF3	/*                                         <CJK> */,/* 1782 */
/* U+A5F7 */	0x4EFD	/*                                         <CJK> */,/* 1783 */
/* U+A5F8 */	0x4F01	/*                                         <CJK> */,/* 1784 */
/* U+A5F9 */	0x4F0B	/*                                         <CJK> */,/* 1785 */
/* U+A5FA */	0x5149	/*                                         <CJK> */,/* 1786 */
/* U+A5FB */	0x5147	/*                                         <CJK> */,/* 1787 */
/* U+A5FC */	0x5146	/*                                         <CJK> */,/* 1788 */
/* U+A5FD */	0x5148	/*                                         <CJK> */,/* 1789 */
/* U+A5FE */	0x5168	/*                                         <CJK> */,/* 1790 */
/* U+A5FF */	UNICODE_REPLACEMENT_CHARACTER,	/* 1791 */
/* U+A600 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1792 */
/* U+A601 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1793 */
/* U+A602 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1794 */
/* U+A603 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1795 */
/* U+A604 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1796 */
/* U+A605 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1797 */
/* U+A606 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1798 */
/* U+A607 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1799 */
/* U+A608 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1800 */
/* U+A609 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1801 */
/* U+A60A */	UNICODE_REPLACEMENT_CHARACTER,	/* 1802 */
/* U+A60B */	UNICODE_REPLACEMENT_CHARACTER,	/* 1803 */
/* U+A60C */	UNICODE_REPLACEMENT_CHARACTER,	/* 1804 */
/* U+A60D */	UNICODE_REPLACEMENT_CHARACTER,	/* 1805 */
/* U+A60E */	UNICODE_REPLACEMENT_CHARACTER,	/* 1806 */
/* U+A60F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1807 */
/* U+A610 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1808 */
/* U+A611 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1809 */
/* U+A612 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1810 */
/* U+A613 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1811 */
/* U+A614 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1812 */
/* U+A615 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1813 */
/* U+A616 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1814 */
/* U+A617 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1815 */
/* U+A618 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1816 */
/* U+A619 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1817 */
/* U+A61A */	UNICODE_REPLACEMENT_CHARACTER,	/* 1818 */
/* U+A61B */	UNICODE_REPLACEMENT_CHARACTER,	/* 1819 */
/* U+A61C */	UNICODE_REPLACEMENT_CHARACTER,	/* 1820 */
/* U+A61D */	UNICODE_REPLACEMENT_CHARACTER,	/* 1821 */
/* U+A61E */	UNICODE_REPLACEMENT_CHARACTER,	/* 1822 */
/* U+A61F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1823 */
/* U+A620 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1824 */
/* U+A621 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1825 */
/* U+A622 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1826 */
/* U+A623 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1827 */
/* U+A624 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1828 */
/* U+A625 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1829 */
/* U+A626 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1830 */
/* U+A627 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1831 */
/* U+A628 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1832 */
/* U+A629 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1833 */
/* U+A62A */	UNICODE_REPLACEMENT_CHARACTER,	/* 1834 */
/* U+A62B */	UNICODE_REPLACEMENT_CHARACTER,	/* 1835 */
/* U+A62C */	UNICODE_REPLACEMENT_CHARACTER,	/* 1836 */
/* U+A62D */	UNICODE_REPLACEMENT_CHARACTER,	/* 1837 */
/* U+A62E */	UNICODE_REPLACEMENT_CHARACTER,	/* 1838 */
/* U+A62F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1839 */
/* U+A630 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1840 */
/* U+A631 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1841 */
/* U+A632 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1842 */
/* U+A633 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1843 */
/* U+A634 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1844 */
/* U+A635 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1845 */
/* U+A636 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1846 */
/* U+A637 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1847 */
/* U+A638 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1848 */
/* U+A639 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1849 */
/* U+A63A */	UNICODE_REPLACEMENT_CHARACTER,	/* 1850 */
/* U+A63B */	UNICODE_REPLACEMENT_CHARACTER,	/* 1851 */
/* U+A63C */	UNICODE_REPLACEMENT_CHARACTER,	/* 1852 */
/* U+A63D */	UNICODE_REPLACEMENT_CHARACTER,	/* 1853 */
/* U+A63E */	UNICODE_REPLACEMENT_CHARACTER,	/* 1854 */
/* U+A63F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1855 */
/* U+A640 */	0x5171	/*                                         <CJK> */,/* 1856 */
/* U+A641 */	0x518D	/*                                         <CJK> */,/* 1857 */
/* U+A642 */	0x51B0	/*                                         <CJK> */,/* 1858 */
/* U+A643 */	0x5217	/*                                         <CJK> */,/* 1859 */
/* U+A644 */	0x5211	/*                                         <CJK> */,/* 1860 */
/* U+A645 */	0x5212	/*                                         <CJK> */,/* 1861 */
/* U+A646 */	0x520E	/*                                         <CJK> */,/* 1862 */
/* U+A647 */	0x5216	/*                                         <CJK> */,/* 1863 */
/* U+A648 */	0x52A3	/*                                         <CJK> */,/* 1864 */
/* U+A649 */	0x5308	/*                                         <CJK> */,/* 1865 */
/* U+A64A */	0x5321	/*                                         <CJK> */,/* 1866 */
/* U+A64B */	0x5320	/*                                         <CJK> */,/* 1867 */
/* U+A64C */	0x5370	/*                                         <CJK> */,/* 1868 */
/* U+A64D */	0x5371	/*                                         <CJK> */,/* 1869 */
/* U+A64E */	0x5409	/*                                         <CJK> */,/* 1870 */
/* U+A64F */	0x540F	/*                                         <CJK> */,/* 1871 */
/* U+A650 */	0x540C	/*                                         <CJK> */,/* 1872 */
/* U+A651 */	0x540A	/*                                         <CJK> */,/* 1873 */
/* U+A652 */	0x5410	/*                                         <CJK> */,/* 1874 */
/* U+A653 */	0x5401	/*                                         <CJK> */,/* 1875 */
/* U+A654 */	0x540B	/*                                         <CJK> */,/* 1876 */
/* U+A655 */	0x5404	/*                                         <CJK> */,/* 1877 */
/* U+A656 */	0x5411	/*                                         <CJK> */,/* 1878 */
/* U+A657 */	0x540D	/*                                         <CJK> */,/* 1879 */
/* U+A658 */	0x5408	/*                                         <CJK> */,/* 1880 */
/* U+A659 */	0x5403	/*                                         <CJK> */,/* 1881 */
/* U+A65A */	0x540E	/*                                         <CJK> */,/* 1882 */
/* U+A65B */	0x5406	/*                                         <CJK> */,/* 1883 */
/* U+A65C */	0x5412	/*                                         <CJK> */,/* 1884 */
/* U+A65D */	0x56E0	/*                                         <CJK> */,/* 1885 */
/* U+A65E */	0x56DE	/*                                         <CJK> */,/* 1886 */
/* U+A65F */	0x56DD	/*                                         <CJK> */,/* 1887 */
/* U+A660 */	0x5733	/*                                         <CJK> */,/* 1888 */
/* U+A661 */	0x5730	/*                                         <CJK> */,/* 1889 */
/* U+A662 */	0x5728	/*                                         <CJK> */,/* 1890 */
/* U+A663 */	0x572D	/*                                         <CJK> */,/* 1891 */
/* U+A664 */	0x572C	/*                                         <CJK> */,/* 1892 */
/* U+A665 */	0x572F	/*                                         <CJK> */,/* 1893 */
/* U+A666 */	0x5729	/*                                         <CJK> */,/* 1894 */
/* U+A667 */	0x5919	/*                                         <CJK> */,/* 1895 */
/* U+A668 */	0x591A	/*                                         <CJK> */,/* 1896 */
/* U+A669 */	0x5937	/*                                         <CJK> */,/* 1897 */
/* U+A66A */	0x5938	/*                                         <CJK> */,/* 1898 */
/* U+A66B */	0x5984	/*                                         <CJK> */,/* 1899 */
/* U+A66C */	0x5978	/*                                         <CJK> */,/* 1900 */
/* U+A66D */	0x5983	/*                                         <CJK> */,/* 1901 */
/* U+A66E */	0x597D	/*                                         <CJK> */,/* 1902 */
/* U+A66F */	0x5979	/*                                         <CJK> */,/* 1903 */
/* U+A670 */	0x5982	/*                                         <CJK> */,/* 1904 */
/* U+A671 */	0x5981	/*                                         <CJK> */,/* 1905 */
/* U+A672 */	0x5B57	/*                                         <CJK> */,/* 1906 */
/* U+A673 */	0x5B58	/*                                         <CJK> */,/* 1907 */
/* U+A674 */	0x5B87	/*                                         <CJK> */,/* 1908 */
/* U+A675 */	0x5B88	/*                                         <CJK> */,/* 1909 */
/* U+A676 */	0x5B85	/*                                         <CJK> */,/* 1910 */
/* U+A677 */	0x5B89	/*                                         <CJK> */,/* 1911 */
/* U+A678 */	0x5BFA	/*                                         <CJK> */,/* 1912 */
/* U+A679 */	0x5C16	/*                                         <CJK> */,/* 1913 */
/* U+A67A */	0x5C79	/*                                         <CJK> */,/* 1914 */
/* U+A67B */	0x5DDE	/*                                         <CJK> */,/* 1915 */
/* U+A67C */	0x5E06	/*                                         <CJK> */,/* 1916 */
/* U+A67D */	0x5E76	/*                                         <CJK> */,/* 1917 */
/* U+A67E */	0x5E74	/*                                         <CJK> */,/* 1918 */
/* U+A67F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1919 */
/* U+A680 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1920 */
/* U+A681 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1921 */
/* U+A682 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1922 */
/* U+A683 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1923 */
/* U+A684 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1924 */
/* U+A685 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1925 */
/* U+A686 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1926 */
/* U+A687 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1927 */
/* U+A688 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1928 */
/* U+A689 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1929 */
/* U+A68A */	UNICODE_REPLACEMENT_CHARACTER,	/* 1930 */
/* U+A68B */	UNICODE_REPLACEMENT_CHARACTER,	/* 1931 */
/* U+A68C */	UNICODE_REPLACEMENT_CHARACTER,	/* 1932 */
/* U+A68D */	UNICODE_REPLACEMENT_CHARACTER,	/* 1933 */
/* U+A68E */	UNICODE_REPLACEMENT_CHARACTER,	/* 1934 */
/* U+A68F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1935 */
/* U+A690 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1936 */
/* U+A691 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1937 */
/* U+A692 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1938 */
/* U+A693 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1939 */
/* U+A694 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1940 */
/* U+A695 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1941 */
/* U+A696 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1942 */
/* U+A697 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1943 */
/* U+A698 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1944 */
/* U+A699 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1945 */
/* U+A69A */	UNICODE_REPLACEMENT_CHARACTER,	/* 1946 */
/* U+A69B */	UNICODE_REPLACEMENT_CHARACTER,	/* 1947 */
/* U+A69C */	UNICODE_REPLACEMENT_CHARACTER,	/* 1948 */
/* U+A69D */	UNICODE_REPLACEMENT_CHARACTER,	/* 1949 */
/* U+A69E */	UNICODE_REPLACEMENT_CHARACTER,	/* 1950 */
/* U+A69F */	UNICODE_REPLACEMENT_CHARACTER,	/* 1951 */
/* U+A6A0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 1952 */
/* U+A6A1 */	0x5F0F	/*                                         <CJK> */,/* 1953 */
/* U+A6A2 */	0x5F1B	/*                                         <CJK> */,/* 1954 */
/* U+A6A3 */	0x5FD9	/*                                         <CJK> */,/* 1955 */
/* U+A6A4 */	0x5FD6	/*                                         <CJK> */,/* 1956 */
/* U+A6A5 */	0x620E	/*                                         <CJK> */,/* 1957 */
/* U+A6A6 */	0x620C	/*                                         <CJK> */,/* 1958 */
/* U+A6A7 */	0x620D	/*                                         <CJK> */,/* 1959 */
/* U+A6A8 */	0x6210	/*                                         <CJK> */,/* 1960 */
/* U+A6A9 */	0x6263	/*                                         <CJK> */,/* 1961 */
/* U+A6AA */	0x625B	/*                                         <CJK> */,/* 1962 */
/* U+A6AB */	0x6258	/*                                         <CJK> */,/* 1963 */
/* U+A6AC */	0x6536	/*                                         <CJK> */,/* 1964 */
/* U+A6AD */	0x65E9	/*                                         <CJK> */,/* 1965 */
/* U+A6AE */	0x65E8	/*                                         <CJK> */,/* 1966 */
/* U+A6AF */	0x65EC	/*                                         <CJK> */,/* 1967 */
/* U+A6B0 */	0x65ED	/*                                         <CJK> */,/* 1968 */
/* U+A6B1 */	0x66F2	/*                                         <CJK> */,/* 1969 */
/* U+A6B2 */	0x66F3	/*                                         <CJK> */,/* 1970 */
/* U+A6B3 */	0x6709	/*                                         <CJK> */,/* 1971 */
/* U+A6B4 */	0x673D	/*                                         <CJK> */,/* 1972 */
/* U+A6B5 */	0x6734	/*                                         <CJK> */,/* 1973 */
/* U+A6B6 */	0x6731	/*                                         <CJK> */,/* 1974 */
/* U+A6B7 */	0x6735	/*                                         <CJK> */,/* 1975 */
/* U+A6B8 */	0x6B21	/*                                         <CJK> */,/* 1976 */
/* U+A6B9 */	0x6B64	/*                                         <CJK> */,/* 1977 */
/* U+A6BA */	0x6B7B	/*                                         <CJK> */,/* 1978 */
/* U+A6BB */	0x6C16	/*                                         <CJK> */,/* 1979 */
/* U+A6BC */	0x6C5D	/*                                         <CJK> */,/* 1980 */
/* U+A6BD */	0x6C57	/*                                         <CJK> */,/* 1981 */
/* U+A6BE */	0x6C59	/*                                         <CJK> */,/* 1982 */
/* U+A6BF */	0x6C5F	/*                                         <CJK> */,/* 1983 */
/* U+A6C0 */	0x6C60	/*                                         <CJK> */,/* 1984 */
/* U+A6C1 */	0x6C50	/*                                         <CJK> */,/* 1985 */
/* U+A6C2 */	0x6C55	/*                                         <CJK> */,/* 1986 */
/* U+A6C3 */	0x6C61	/*                                         <CJK> */,/* 1987 */
/* U+A6C4 */	0x6C5B	/*                                         <CJK> */,/* 1988 */
/* U+A6C5 */	0x6C4D	/*                                         <CJK> */,/* 1989 */
/* U+A6C6 */	0x6C4E	/*                                         <CJK> */,/* 1990 */
/* U+A6C7 */	0x7070	/*                                         <CJK> */,/* 1991 */
/* U+A6C8 */	0x725F	/*                                         <CJK> */,/* 1992 */
/* U+A6C9 */	0x725D	/*                                         <CJK> */,/* 1993 */
/* U+A6CA */	0x767E	/*                                         <CJK> */,/* 1994 */
/* U+A6CB */	0x7AF9	/*                                         <CJK> */,/* 1995 */
/* U+A6CC */	0x7C73	/*                                         <CJK> */,/* 1996 */
/* U+A6CD */	0x7CF8	/*                                         <CJK> */,/* 1997 */
/* U+A6CE */	0x7F36	/*                                         <CJK> */,/* 1998 */
/* U+A6CF */	0x7F8A	/*                                         <CJK> */,/* 1999 */
/* U+A6D0 */	0x7FBD	/*                                         <CJK> */,/* 2000 */
/* U+A6D1 */	0x8001	/*                                         <CJK> */,/* 2001 */
/* U+A6D2 */	0x8003	/*                                         <CJK> */,/* 2002 */
/* U+A6D3 */	0x800C	/*                                         <CJK> */,/* 2003 */
/* U+A6D4 */	0x8012	/*                                         <CJK> */,/* 2004 */
/* U+A6D5 */	0x8033	/*                                         <CJK> */,/* 2005 */
/* U+A6D6 */	0x807F	/*                                         <CJK> */,/* 2006 */
/* U+A6D7 */	0x8089	/*                                         <CJK> */,/* 2007 */
/* U+A6D8 */	0x808B	/*                                         <CJK> */,/* 2008 */
/* U+A6D9 */	0x808C	/*                                         <CJK> */,/* 2009 */
/* U+A6DA */	0x81E3	/*                                         <CJK> */,/* 2010 */
/* U+A6DB */	0x81EA	/*                                         <CJK> */,/* 2011 */
/* U+A6DC */	0x81F3	/*                                         <CJK> */,/* 2012 */
/* U+A6DD */	0x81FC	/*                                         <CJK> */,/* 2013 */
/* U+A6DE */	0x820C	/*                                         <CJK> */,/* 2014 */
/* U+A6DF */	0x821B	/*                                         <CJK> */,/* 2015 */
/* U+A6E0 */	0x821F	/*                                         <CJK> */,/* 2016 */
/* U+A6E1 */	0x826E	/*                                         <CJK> */,/* 2017 */
/* U+A6E2 */	0x8272	/*                                         <CJK> */,/* 2018 */
/* U+A6E3 */	0x827E	/*                                         <CJK> */,/* 2019 */
/* U+A6E4 */	0x866B	/*                                         <CJK> */,/* 2020 */
/* U+A6E5 */	0x8840	/*                                         <CJK> */,/* 2021 */
/* U+A6E6 */	0x884C	/*                                         <CJK> */,/* 2022 */
/* U+A6E7 */	0x8863	/*                                         <CJK> */,/* 2023 */
/* U+A6E8 */	0x897F	/*                                         <CJK> */,/* 2024 */
/* U+A6E9 */	0x9621	/*                                         <CJK> */,/* 2025 */
/* U+A6EA */	0x4E32	/*                                         <CJK> */,/* 2026 */
/* U+A6EB */	0x4EA8	/*                                         <CJK> */,/* 2027 */
/* U+A6EC */	0x4F4D	/*                                         <CJK> */,/* 2028 */
/* U+A6ED */	0x4F4F	/*                                         <CJK> */,/* 2029 */
/* U+A6EE */	0x4F47	/*                                         <CJK> */,/* 2030 */
/* U+A6EF */	0x4F57	/*                                         <CJK> */,/* 2031 */
/* U+A6F0 */	0x4F5E	/*                                         <CJK> */,/* 2032 */
/* U+A6F1 */	0x4F34	/*                                         <CJK> */,/* 2033 */
/* U+A6F2 */	0x4F5B	/*                                         <CJK> */,/* 2034 */
/* U+A6F3 */	0x4F55	/*                                         <CJK> */,/* 2035 */
/* U+A6F4 */	0x4F30	/*                                         <CJK> */,/* 2036 */
/* U+A6F5 */	0x4F50	/*                                         <CJK> */,/* 2037 */
/* U+A6F6 */	0x4F51	/*                                         <CJK> */,/* 2038 */
/* U+A6F7 */	0x4F3D	/*                                         <CJK> */,/* 2039 */
/* U+A6F8 */	0x4F3A	/*                                         <CJK> */,/* 2040 */
/* U+A6F9 */	0x4F38	/*                                         <CJK> */,/* 2041 */
/* U+A6FA */	0x4F43	/*                                         <CJK> */,/* 2042 */
/* U+A6FB */	0x4F54	/*                                         <CJK> */,/* 2043 */
/* U+A6FC */	0x4F3C	/*                                         <CJK> */,/* 2044 */
/* U+A6FD */	0x4F46	/*                                         <CJK> */,/* 2045 */
/* U+A6FE */	0x4F63	/*                                         <CJK> */,/* 2046 */
/* U+A6FF */	UNICODE_REPLACEMENT_CHARACTER,	/* 2047 */
/* U+A700 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2048 */
/* U+A701 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2049 */
/* U+A702 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2050 */
/* U+A703 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2051 */
/* U+A704 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2052 */
/* U+A705 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2053 */
/* U+A706 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2054 */
/* U+A707 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2055 */
/* U+A708 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2056 */
/* U+A709 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2057 */
/* U+A70A */	UNICODE_REPLACEMENT_CHARACTER,	/* 2058 */
/* U+A70B */	UNICODE_REPLACEMENT_CHARACTER,	/* 2059 */
/* U+A70C */	UNICODE_REPLACEMENT_CHARACTER,	/* 2060 */
/* U+A70D */	UNICODE_REPLACEMENT_CHARACTER,	/* 2061 */
/* U+A70E */	UNICODE_REPLACEMENT_CHARACTER,	/* 2062 */
/* U+A70F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2063 */
/* U+A710 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2064 */
/* U+A711 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2065 */
/* U+A712 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2066 */
/* U+A713 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2067 */
/* U+A714 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2068 */
/* U+A715 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2069 */
/* U+A716 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2070 */
/* U+A717 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2071 */
/* U+A718 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2072 */
/* U+A719 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2073 */
/* U+A71A */	UNICODE_REPLACEMENT_CHARACTER,	/* 2074 */
/* U+A71B */	UNICODE_REPLACEMENT_CHARACTER,	/* 2075 */
/* U+A71C */	UNICODE_REPLACEMENT_CHARACTER,	/* 2076 */
/* U+A71D */	UNICODE_REPLACEMENT_CHARACTER,	/* 2077 */
/* U+A71E */	UNICODE_REPLACEMENT_CHARACTER,	/* 2078 */
/* U+A71F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2079 */
/* U+A720 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2080 */
/* U+A721 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2081 */
/* U+A722 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2082 */
/* U+A723 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2083 */
/* U+A724 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2084 */
/* U+A725 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2085 */
/* U+A726 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2086 */
/* U+A727 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2087 */
/* U+A728 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2088 */
/* U+A729 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2089 */
/* U+A72A */	UNICODE_REPLACEMENT_CHARACTER,	/* 2090 */
/* U+A72B */	UNICODE_REPLACEMENT_CHARACTER,	/* 2091 */
/* U+A72C */	UNICODE_REPLACEMENT_CHARACTER,	/* 2092 */
/* U+A72D */	UNICODE_REPLACEMENT_CHARACTER,	/* 2093 */
/* U+A72E */	UNICODE_REPLACEMENT_CHARACTER,	/* 2094 */
/* U+A72F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2095 */
/* U+A730 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2096 */
/* U+A731 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2097 */
/* U+A732 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2098 */
/* U+A733 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2099 */
/* U+A734 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2100 */
/* U+A735 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2101 */
/* U+A736 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2102 */
/* U+A737 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2103 */
/* U+A738 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2104 */
/* U+A739 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2105 */
/* U+A73A */	UNICODE_REPLACEMENT_CHARACTER,	/* 2106 */
/* U+A73B */	UNICODE_REPLACEMENT_CHARACTER,	/* 2107 */
/* U+A73C */	UNICODE_REPLACEMENT_CHARACTER,	/* 2108 */
/* U+A73D */	UNICODE_REPLACEMENT_CHARACTER,	/* 2109 */
/* U+A73E */	UNICODE_REPLACEMENT_CHARACTER,	/* 2110 */
/* U+A73F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2111 */
/* U+A740 */	0x4F5C	/*                                         <CJK> */,/* 2112 */
/* U+A741 */	0x4F60	/*                                         <CJK> */,/* 2113 */
/* U+A742 */	0x4F2F	/*                                         <CJK> */,/* 2114 */
/* U+A743 */	0x4F4E	/*                                         <CJK> */,/* 2115 */
/* U+A744 */	0x4F36	/*                                         <CJK> */,/* 2116 */
/* U+A745 */	0x4F59	/*                                         <CJK> */,/* 2117 */
/* U+A746 */	0x4F5D	/*                                         <CJK> */,/* 2118 */
/* U+A747 */	0x4F48	/*                                         <CJK> */,/* 2119 */
/* U+A748 */	0x4F5A	/*                                         <CJK> */,/* 2120 */
/* U+A749 */	0x514C	/*                                         <CJK> */,/* 2121 */
/* U+A74A */	0x514B	/*                                         <CJK> */,/* 2122 */
/* U+A74B */	0x514D	/*                                         <CJK> */,/* 2123 */
/* U+A74C */	0x5175	/*                                         <CJK> */,/* 2124 */
/* U+A74D */	0x51B6	/*                                         <CJK> */,/* 2125 */
/* U+A74E */	0x51B7	/*                                         <CJK> */,/* 2126 */
/* U+A74F */	0x5225	/*                                         <CJK> */,/* 2127 */
/* U+A750 */	0x5224	/*                                         <CJK> */,/* 2128 */
/* U+A751 */	0x5229	/*                                         <CJK> */,/* 2129 */
/* U+A752 */	0x522A	/*                                         <CJK> */,/* 2130 */
/* U+A753 */	0x5228	/*                                         <CJK> */,/* 2131 */
/* U+A754 */	0x52AB	/*                                         <CJK> */,/* 2132 */
/* U+A755 */	0x52A9	/*                                         <CJK> */,/* 2133 */
/* U+A756 */	0x52AA	/*                                         <CJK> */,/* 2134 */
/* U+A757 */	0x52AC	/*                                         <CJK> */,/* 2135 */
/* U+A758 */	0x5323	/*                                         <CJK> */,/* 2136 */
/* U+A759 */	0x5373	/*                                         <CJK> */,/* 2137 */
/* U+A75A */	0x5375	/*                                         <CJK> */,/* 2138 */
/* U+A75B */	0x541D	/*                                         <CJK> */,/* 2139 */
/* U+A75C */	0x542D	/*                                         <CJK> */,/* 2140 */
/* U+A75D */	0x541E	/*                                         <CJK> */,/* 2141 */
/* U+A75E */	0x543E	/*                                         <CJK> */,/* 2142 */
/* U+A75F */	0x5426	/*                                         <CJK> */,/* 2143 */
/* U+A760 */	0x544E	/*                                         <CJK> */,/* 2144 */
/* U+A761 */	0x5427	/*                                         <CJK> */,/* 2145 */
/* U+A762 */	0x5446	/*                                         <CJK> */,/* 2146 */
/* U+A763 */	0x5443	/*                                         <CJK> */,/* 2147 */
/* U+A764 */	0x5433	/*                                         <CJK> */,/* 2148 */
/* U+A765 */	0x5448	/*                                         <CJK> */,/* 2149 */
/* U+A766 */	0x5442	/*                                         <CJK> */,/* 2150 */
/* U+A767 */	0x541B	/*                                         <CJK> */,/* 2151 */
/* U+A768 */	0x5429	/*                                         <CJK> */,/* 2152 */
/* U+A769 */	0x544A	/*                                         <CJK> */,/* 2153 */
/* U+A76A */	0x5439	/*                                         <CJK> */,/* 2154 */
/* U+A76B */	0x543B	/*                                         <CJK> */,/* 2155 */
/* U+A76C */	0x5438	/*                                         <CJK> */,/* 2156 */
/* U+A76D */	0x542E	/*                                         <CJK> */,/* 2157 */
/* U+A76E */	0x5435	/*                                         <CJK> */,/* 2158 */
/* U+A76F */	0x5436	/*                                         <CJK> */,/* 2159 */
/* U+A770 */	0x5420	/*                                         <CJK> */,/* 2160 */
/* U+A771 */	0x543C	/*                                         <CJK> */,/* 2161 */
/* U+A772 */	0x5440	/*                                         <CJK> */,/* 2162 */
/* U+A773 */	0x5431	/*                                         <CJK> */,/* 2163 */
/* U+A774 */	0x542B	/*                                         <CJK> */,/* 2164 */
/* U+A775 */	0x541F	/*                                         <CJK> */,/* 2165 */
/* U+A776 */	0x542C	/*                                         <CJK> */,/* 2166 */
/* U+A777 */	0x56EA	/*                                         <CJK> */,/* 2167 */
/* U+A778 */	0x56F0	/*                                         <CJK> */,/* 2168 */
/* U+A779 */	0x56E4	/*                                         <CJK> */,/* 2169 */
/* U+A77A */	0x56EB	/*                                         <CJK> */,/* 2170 */
/* U+A77B */	0x574A	/*                                         <CJK> */,/* 2171 */
/* U+A77C */	0x5751	/*                                         <CJK> */,/* 2172 */
/* U+A77D */	0x5740	/*                                         <CJK> */,/* 2173 */
/* U+A77E */	0x574D	/*                                         <CJK> */,/* 2174 */
/* U+A77F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2175 */
/* U+A780 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2176 */
/* U+A781 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2177 */
/* U+A782 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2178 */
/* U+A783 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2179 */
/* U+A784 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2180 */
/* U+A785 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2181 */
/* U+A786 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2182 */
/* U+A787 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2183 */
/* U+A788 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2184 */
/* U+A789 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2185 */
/* U+A78A */	UNICODE_REPLACEMENT_CHARACTER,	/* 2186 */
/* U+A78B */	UNICODE_REPLACEMENT_CHARACTER,	/* 2187 */
/* U+A78C */	UNICODE_REPLACEMENT_CHARACTER,	/* 2188 */
/* U+A78D */	UNICODE_REPLACEMENT_CHARACTER,	/* 2189 */
/* U+A78E */	UNICODE_REPLACEMENT_CHARACTER,	/* 2190 */
/* U+A78F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2191 */
/* U+A790 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2192 */
/* U+A791 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2193 */
/* U+A792 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2194 */
/* U+A793 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2195 */
/* U+A794 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2196 */
/* U+A795 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2197 */
/* U+A796 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2198 */
/* U+A797 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2199 */
/* U+A798 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2200 */
/* U+A799 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2201 */
/* U+A79A */	UNICODE_REPLACEMENT_CHARACTER,	/* 2202 */
/* U+A79B */	UNICODE_REPLACEMENT_CHARACTER,	/* 2203 */
/* U+A79C */	UNICODE_REPLACEMENT_CHARACTER,	/* 2204 */
/* U+A79D */	UNICODE_REPLACEMENT_CHARACTER,	/* 2205 */
/* U+A79E */	UNICODE_REPLACEMENT_CHARACTER,	/* 2206 */
/* U+A79F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2207 */
/* U+A7A0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2208 */
/* U+A7A1 */	0x5747	/*                                         <CJK> */,/* 2209 */
/* U+A7A2 */	0x574E	/*                                         <CJK> */,/* 2210 */
/* U+A7A3 */	0x573E	/*                                         <CJK> */,/* 2211 */
/* U+A7A4 */	0x5750	/*                                         <CJK> */,/* 2212 */
/* U+A7A5 */	0x574F	/*                                         <CJK> */,/* 2213 */
/* U+A7A6 */	0x573B	/*                                         <CJK> */,/* 2214 */
/* U+A7A7 */	0x58EF	/*                                         <CJK> */,/* 2215 */
/* U+A7A8 */	0x593E	/*                                         <CJK> */,/* 2216 */
/* U+A7A9 */	0x599D	/*                                         <CJK> */,/* 2217 */
/* U+A7AA */	0x5992	/*                                         <CJK> */,/* 2218 */
/* U+A7AB */	0x59A8	/*                                         <CJK> */,/* 2219 */
/* U+A7AC */	0x599E	/*                                         <CJK> */,/* 2220 */
/* U+A7AD */	0x59A3	/*                                         <CJK> */,/* 2221 */
/* U+A7AE */	0x5999	/*                                         <CJK> */,/* 2222 */
/* U+A7AF */	0x5996	/*                                         <CJK> */,/* 2223 */
/* U+A7B0 */	0x598D	/*                                         <CJK> */,/* 2224 */
/* U+A7B1 */	0x59A4	/*                                         <CJK> */,/* 2225 */
/* U+A7B2 */	0x5993	/*                                         <CJK> */,/* 2226 */
/* U+A7B3 */	0x598A	/*                                         <CJK> */,/* 2227 */
/* U+A7B4 */	0x59A5	/*                                         <CJK> */,/* 2228 */
/* U+A7B5 */	0x5B5D	/*                                         <CJK> */,/* 2229 */
/* U+A7B6 */	0x5B5C	/*                                         <CJK> */,/* 2230 */
/* U+A7B7 */	0x5B5A	/*                                         <CJK> */,/* 2231 */
/* U+A7B8 */	0x5B5B	/*                                         <CJK> */,/* 2232 */
/* U+A7B9 */	0x5B8C	/*                                         <CJK> */,/* 2233 */
/* U+A7BA */	0x5B8B	/*                                         <CJK> */,/* 2234 */
/* U+A7BB */	0x5B8F	/*                                         <CJK> */,/* 2235 */
/* U+A7BC */	0x5C2C	/*                                         <CJK> */,/* 2236 */
/* U+A7BD */	0x5C40	/*                                         <CJK> */,/* 2237 */
/* U+A7BE */	0x5C41	/*                                         <CJK> */,/* 2238 */
/* U+A7BF */	0x5C3F	/*                                         <CJK> */,/* 2239 */
/* U+A7C0 */	0x5C3E	/*                                         <CJK> */,/* 2240 */
/* U+A7C1 */	0x5C90	/*                                         <CJK> */,/* 2241 */
/* U+A7C2 */	0x5C91	/*                                         <CJK> */,/* 2242 */
/* U+A7C3 */	0x5C94	/*                                         <CJK> */,/* 2243 */
/* U+A7C4 */	0x5C8C	/*                                         <CJK> */,/* 2244 */
/* U+A7C5 */	0x5DEB	/*                                         <CJK> */,/* 2245 */
/* U+A7C6 */	0x5E0C	/*                                         <CJK> */,/* 2246 */
/* U+A7C7 */	0x5E8F	/*                                         <CJK> */,/* 2247 */
/* U+A7C8 */	0x5E87	/*                                         <CJK> */,/* 2248 */
/* U+A7C9 */	0x5E8A	/*                                         <CJK> */,/* 2249 */
/* U+A7CA */	0x5EF7	/*                                         <CJK> */,/* 2250 */
/* U+A7CB */	0x5F04	/*                                         <CJK> */,/* 2251 */
/* U+A7CC */	0x5F1F	/*                                         <CJK> */,/* 2252 */
/* U+A7CD */	0x5F64	/*                                         <CJK> */,/* 2253 */
/* U+A7CE */	0x5F62	/*                                         <CJK> */,/* 2254 */
/* U+A7CF */	0x5F77	/*                                         <CJK> */,/* 2255 */
/* U+A7D0 */	0x5F79	/*                                         <CJK> */,/* 2256 */
/* U+A7D1 */	0x5FD8	/*                                         <CJK> */,/* 2257 */
/* U+A7D2 */	0x5FCC	/*                                         <CJK> */,/* 2258 */
/* U+A7D3 */	0x5FD7	/*                                         <CJK> */,/* 2259 */
/* U+A7D4 */	0x5FCD	/*                                         <CJK> */,/* 2260 */
/* U+A7D5 */	0x5FF1	/*                                         <CJK> */,/* 2261 */
/* U+A7D6 */	0x5FEB	/*                                         <CJK> */,/* 2262 */
/* U+A7D7 */	0x5FF8	/*                                         <CJK> */,/* 2263 */
/* U+A7D8 */	0x5FEA	/*                                         <CJK> */,/* 2264 */
/* U+A7D9 */	0x6212	/*                                         <CJK> */,/* 2265 */
/* U+A7DA */	0x6211	/*                                         <CJK> */,/* 2266 */
/* U+A7DB */	0x6284	/*                                         <CJK> */,/* 2267 */
/* U+A7DC */	0x6297	/*                                         <CJK> */,/* 2268 */
/* U+A7DD */	0x6296	/*                                         <CJK> */,/* 2269 */
/* U+A7DE */	0x6280	/*                                         <CJK> */,/* 2270 */
/* U+A7DF */	0x6276	/*                                         <CJK> */,/* 2271 */
/* U+A7E0 */	0x6289	/*                                         <CJK> */,/* 2272 */
/* U+A7E1 */	0x626D	/*                                         <CJK> */,/* 2273 */
/* U+A7E2 */	0x628A	/*                                         <CJK> */,/* 2274 */
/* U+A7E3 */	0x627C	/*                                         <CJK> */,/* 2275 */
/* U+A7E4 */	0x627E	/*                                         <CJK> */,/* 2276 */
/* U+A7E5 */	0x6279	/*                                         <CJK> */,/* 2277 */
/* U+A7E6 */	0x6273	/*                                         <CJK> */,/* 2278 */
/* U+A7E7 */	0x6292	/*                                         <CJK> */,/* 2279 */
/* U+A7E8 */	0x626F	/*                                         <CJK> */,/* 2280 */
/* U+A7E9 */	0x6298	/*                                         <CJK> */,/* 2281 */
/* U+A7EA */	0x626E	/*                                         <CJK> */,/* 2282 */
/* U+A7EB */	0x6295	/*                                         <CJK> */,/* 2283 */
/* U+A7EC */	0x6293	/*                                         <CJK> */,/* 2284 */
/* U+A7ED */	0x6291	/*                                         <CJK> */,/* 2285 */
/* U+A7EE */	0x6286	/*                                         <CJK> */,/* 2286 */
/* U+A7EF */	0x6539	/*                                         <CJK> */,/* 2287 */
/* U+A7F0 */	0x653B	/*                                         <CJK> */,/* 2288 */
/* U+A7F1 */	0x6538	/*                                         <CJK> */,/* 2289 */
/* U+A7F2 */	0x65F1	/*                                         <CJK> */,/* 2290 */
/* U+A7F3 */	0x66F4	/*                                         <CJK> */,/* 2291 */
/* U+A7F4 */	0x675F	/*                                         <CJK> */,/* 2292 */
/* U+A7F5 */	0x674E	/*                                         <CJK> */,/* 2293 */
/* U+A7F6 */	0x674F	/*                                         <CJK> */,/* 2294 */
/* U+A7F7 */	0x6750	/*                                         <CJK> */,/* 2295 */
/* U+A7F8 */	0x6751	/*                                         <CJK> */,/* 2296 */
/* U+A7F9 */	0x675C	/*                                         <CJK> */,/* 2297 */
/* U+A7FA */	0x6756	/*                                         <CJK> */,/* 2298 */
/* U+A7FB */	0x675E	/*                                         <CJK> */,/* 2299 */
/* U+A7FC */	0x6749	/*                                         <CJK> */,/* 2300 */
/* U+A7FD */	0x6746	/*                                         <CJK> */,/* 2301 */
/* U+A7FE */	0x6760	/*                                         <CJK> */,/* 2302 */
/* U+A7FF */	UNICODE_REPLACEMENT_CHARACTER,	/* 2303 */
/* U+A800 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2304 */
/* U+A801 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2305 */
/* U+A802 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2306 */
/* U+A803 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2307 */
/* U+A804 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2308 */
/* U+A805 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2309 */
/* U+A806 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2310 */
/* U+A807 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2311 */
/* U+A808 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2312 */
/* U+A809 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2313 */
/* U+A80A */	UNICODE_REPLACEMENT_CHARACTER,	/* 2314 */
/* U+A80B */	UNICODE_REPLACEMENT_CHARACTER,	/* 2315 */
/* U+A80C */	UNICODE_REPLACEMENT_CHARACTER,	/* 2316 */
/* U+A80D */	UNICODE_REPLACEMENT_CHARACTER,	/* 2317 */
/* U+A80E */	UNICODE_REPLACEMENT_CHARACTER,	/* 2318 */
/* U+A80F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2319 */
/* U+A810 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2320 */
/* U+A811 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2321 */
/* U+A812 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2322 */
/* U+A813 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2323 */
/* U+A814 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2324 */
/* U+A815 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2325 */
/* U+A816 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2326 */
/* U+A817 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2327 */
/* U+A818 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2328 */
/* U+A819 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2329 */
/* U+A81A */	UNICODE_REPLACEMENT_CHARACTER,	/* 2330 */
/* U+A81B */	UNICODE_REPLACEMENT_CHARACTER,	/* 2331 */
/* U+A81C */	UNICODE_REPLACEMENT_CHARACTER,	/* 2332 */
/* U+A81D */	UNICODE_REPLACEMENT_CHARACTER,	/* 2333 */
/* U+A81E */	UNICODE_REPLACEMENT_CHARACTER,	/* 2334 */
/* U+A81F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2335 */
/* U+A820 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2336 */
/* U+A821 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2337 */
/* U+A822 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2338 */
/* U+A823 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2339 */
/* U+A824 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2340 */
/* U+A825 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2341 */
/* U+A826 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2342 */
/* U+A827 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2343 */
/* U+A828 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2344 */
/* U+A829 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2345 */
/* U+A82A */	UNICODE_REPLACEMENT_CHARACTER,	/* 2346 */
/* U+A82B */	UNICODE_REPLACEMENT_CHARACTER,	/* 2347 */
/* U+A82C */	UNICODE_REPLACEMENT_CHARACTER,	/* 2348 */
/* U+A82D */	UNICODE_REPLACEMENT_CHARACTER,	/* 2349 */
/* U+A82E */	UNICODE_REPLACEMENT_CHARACTER,	/* 2350 */
/* U+A82F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2351 */
/* U+A830 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2352 */
/* U+A831 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2353 */
/* U+A832 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2354 */
/* U+A833 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2355 */
/* U+A834 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2356 */
/* U+A835 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2357 */
/* U+A836 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2358 */
/* U+A837 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2359 */
/* U+A838 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2360 */
/* U+A839 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2361 */
/* U+A83A */	UNICODE_REPLACEMENT_CHARACTER,	/* 2362 */
/* U+A83B */	UNICODE_REPLACEMENT_CHARACTER,	/* 2363 */
/* U+A83C */	UNICODE_REPLACEMENT_CHARACTER,	/* 2364 */
/* U+A83D */	UNICODE_REPLACEMENT_CHARACTER,	/* 2365 */
/* U+A83E */	UNICODE_REPLACEMENT_CHARACTER,	/* 2366 */
/* U+A83F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2367 */
/* U+A840 */	0x6753	/*                                         <CJK> */,/* 2368 */
/* U+A841 */	0x6757	/*                                         <CJK> */,/* 2369 */
/* U+A842 */	0x6B65	/*                                         <CJK> */,/* 2370 */
/* U+A843 */	0x6BCF	/*                                         <CJK> */,/* 2371 */
/* U+A844 */	0x6C42	/*                                         <CJK> */,/* 2372 */
/* U+A845 */	0x6C5E	/*                                         <CJK> */,/* 2373 */
/* U+A846 */	0x6C99	/*                                         <CJK> */,/* 2374 */
/* U+A847 */	0x6C81	/*                                         <CJK> */,/* 2375 */
/* U+A848 */	0x6C88	/*                                         <CJK> */,/* 2376 */
/* U+A849 */	0x6C89	/*                                         <CJK> */,/* 2377 */
/* U+A84A */	0x6C85	/*                                         <CJK> */,/* 2378 */
/* U+A84B */	0x6C9B	/*                                         <CJK> */,/* 2379 */
/* U+A84C */	0x6C6A	/*                                         <CJK> */,/* 2380 */
/* U+A84D */	0x6C7A	/*                                         <CJK> */,/* 2381 */
/* U+A84E */	0x6C90	/*                                         <CJK> */,/* 2382 */
/* U+A84F */	0x6C70	/*                                         <CJK> */,/* 2383 */
/* U+A850 */	0x6C8C	/*                                         <CJK> */,/* 2384 */
/* U+A851 */	0x6C68	/*                                         <CJK> */,/* 2385 */
/* U+A852 */	0x6C96	/*                                         <CJK> */,/* 2386 */
/* U+A853 */	0x6C92	/*                                         <CJK> */,/* 2387 */
/* U+A854 */	0x6C7D	/*                                         <CJK> */,/* 2388 */
/* U+A855 */	0x6C83	/*                                         <CJK> */,/* 2389 */
/* U+A856 */	0x6C72	/*                                         <CJK> */,/* 2390 */
/* U+A857 */	0x6C7E	/*                                         <CJK> */,/* 2391 */
/* U+A858 */	0x6C74	/*                                         <CJK> */,/* 2392 */
/* U+A859 */	0x6C86	/*                                         <CJK> */,/* 2393 */
/* U+A85A */	0x6C76	/*                                         <CJK> */,/* 2394 */
/* U+A85B */	0x6C8D	/*                                         <CJK> */,/* 2395 */
/* U+A85C */	0x6C94	/*                                         <CJK> */,/* 2396 */
/* U+A85D */	0x6C98	/*                                         <CJK> */,/* 2397 */
/* U+A85E */	0x6C82	/*                                         <CJK> */,/* 2398 */
/* U+A85F */	0x7076	/*                                         <CJK> */,/* 2399 */
/* U+A860 */	0x707C	/*                                         <CJK> */,/* 2400 */
/* U+A861 */	0x707D	/*                                         <CJK> */,/* 2401 */
/* U+A862 */	0x7078	/*                                         <CJK> */,/* 2402 */
/* U+A863 */	0x7262	/*                                         <CJK> */,/* 2403 */
/* U+A864 */	0x7261	/*                                         <CJK> */,/* 2404 */
/* U+A865 */	0x7260	/*                                         <CJK> */,/* 2405 */
/* U+A866 */	0x72C4	/*                                         <CJK> */,/* 2406 */
/* U+A867 */	0x72C2	/*                                         <CJK> */,/* 2407 */
/* U+A868 */	0x7396	/*                                         <CJK> */,/* 2408 */
/* U+A869 */	0x752C	/*                                         <CJK> */,/* 2409 */
/* U+A86A */	0x752B	/*                                         <CJK> */,/* 2410 */
/* U+A86B */	0x7537	/*                                         <CJK> */,/* 2411 */
/* U+A86C */	0x7538	/*                                         <CJK> */,/* 2412 */
/* U+A86D */	0x7682	/*                                         <CJK> */,/* 2413 */
/* U+A86E */	0x76EF	/*                                         <CJK> */,/* 2414 */
/* U+A86F */	0x77E3	/*                                         <CJK> */,/* 2415 */
/* U+A870 */	0x79C1	/*                                         <CJK> */,/* 2416 */
/* U+A871 */	0x79C0	/*                                         <CJK> */,/* 2417 */
/* U+A872 */	0x79BF	/*                                         <CJK> */,/* 2418 */
/* U+A873 */	0x7A76	/*                                         <CJK> */,/* 2419 */
/* U+A874 */	0x7CFB	/*                                         <CJK> */,/* 2420 */
/* U+A875 */	0x7F55	/*                                         <CJK> */,/* 2421 */
/* U+A876 */	0x8096	/*                                         <CJK> */,/* 2422 */
/* U+A877 */	0x8093	/*                                         <CJK> */,/* 2423 */
/* U+A878 */	0x809D	/*                                         <CJK> */,/* 2424 */
/* U+A879 */	0x8098	/*                                         <CJK> */,/* 2425 */
/* U+A87A */	0x809B	/*                                         <CJK> */,/* 2426 */
/* U+A87B */	0x809A	/*                                         <CJK> */,/* 2427 */
/* U+A87C */	0x80B2	/*                                         <CJK> */,/* 2428 */
/* U+A87D */	0x826F	/*                                         <CJK> */,/* 2429 */
/* U+A87E */	0x8292	/*                                         <CJK> */,/* 2430 */
/* U+A87F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2431 */
/* U+A880 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2432 */
/* U+A881 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2433 */
/* U+A882 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2434 */
/* U+A883 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2435 */
/* U+A884 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2436 */
/* U+A885 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2437 */
/* U+A886 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2438 */
/* U+A887 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2439 */
/* U+A888 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2440 */
/* U+A889 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2441 */
/* U+A88A */	UNICODE_REPLACEMENT_CHARACTER,	/* 2442 */
/* U+A88B */	UNICODE_REPLACEMENT_CHARACTER,	/* 2443 */
/* U+A88C */	UNICODE_REPLACEMENT_CHARACTER,	/* 2444 */
/* U+A88D */	UNICODE_REPLACEMENT_CHARACTER,	/* 2445 */
/* U+A88E */	UNICODE_REPLACEMENT_CHARACTER,	/* 2446 */
/* U+A88F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2447 */
/* U+A890 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2448 */
/* U+A891 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2449 */
/* U+A892 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2450 */
/* U+A893 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2451 */
/* U+A894 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2452 */
/* U+A895 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2453 */
/* U+A896 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2454 */
/* U+A897 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2455 */
/* U+A898 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2456 */
/* U+A899 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2457 */
/* U+A89A */	UNICODE_REPLACEMENT_CHARACTER,	/* 2458 */
/* U+A89B */	UNICODE_REPLACEMENT_CHARACTER,	/* 2459 */
/* U+A89C */	UNICODE_REPLACEMENT_CHARACTER,	/* 2460 */
/* U+A89D */	UNICODE_REPLACEMENT_CHARACTER,	/* 2461 */
/* U+A89E */	UNICODE_REPLACEMENT_CHARACTER,	/* 2462 */
/* U+A89F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2463 */
/* U+A8A0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2464 */
/* U+A8A1 */	0x828B	/*                                         <CJK> */,/* 2465 */
/* U+A8A2 */	0x828D	/*                                         <CJK> */,/* 2466 */
/* U+A8A3 */	0x898B	/*                                         <CJK> */,/* 2467 */
/* U+A8A4 */	0x89D2	/*                                         <CJK> */,/* 2468 */
/* U+A8A5 */	0x8A00	/*                                         <CJK> */,/* 2469 */
/* U+A8A6 */	0x8C37	/*                                         <CJK> */,/* 2470 */
/* U+A8A7 */	0x8C46	/*                                         <CJK> */,/* 2471 */
/* U+A8A8 */	0x8C55	/*                                         <CJK> */,/* 2472 */
/* U+A8A9 */	0x8C9D	/*                                         <CJK> */,/* 2473 */
/* U+A8AA */	0x8D64	/*                                         <CJK> */,/* 2474 */
/* U+A8AB */	0x8D70	/*                                         <CJK> */,/* 2475 */
/* U+A8AC */	0x8DB3	/*                                         <CJK> */,/* 2476 */
/* U+A8AD */	0x8EAB	/*                                         <CJK> */,/* 2477 */
/* U+A8AE */	0x8ECA	/*                                         <CJK> */,/* 2478 */
/* U+A8AF */	0x8F9B	/*                                         <CJK> */,/* 2479 */
/* U+A8B0 */	0x8FB0	/*                                         <CJK> */,/* 2480 */
/* U+A8B1 */	0x8FC2	/*                                         <CJK> */,/* 2481 */
/* U+A8B2 */	0x8FC6	/*                                         <CJK> */,/* 2482 */
/* U+A8B3 */	0x8FC5	/*                                         <CJK> */,/* 2483 */
/* U+A8B4 */	0x8FC4	/*                                         <CJK> */,/* 2484 */
/* U+A8B5 */	0x5DE1	/*                                         <CJK> */,/* 2485 */
/* U+A8B6 */	0x9091	/*                                         <CJK> */,/* 2486 */
/* U+A8B7 */	0x90A2	/*                                         <CJK> */,/* 2487 */
/* U+A8B8 */	0x90AA	/*                                         <CJK> */,/* 2488 */
/* U+A8B9 */	0x90A6	/*                                         <CJK> */,/* 2489 */
/* U+A8BA */	0x90A3	/*                                         <CJK> */,/* 2490 */
/* U+A8BB */	0x9149	/*                                         <CJK> */,/* 2491 */
/* U+A8BC */	0x91C6	/*                                         <CJK> */,/* 2492 */
/* U+A8BD */	0x91CC	/*                                         <CJK> */,/* 2493 */
/* U+A8BE */	0x9632	/*                                         <CJK> */,/* 2494 */
/* U+A8BF */	0x962E	/*                                         <CJK> */,/* 2495 */
/* U+A8C0 */	0x9631	/*                                         <CJK> */,/* 2496 */
/* U+A8C1 */	0x962A	/*                                         <CJK> */,/* 2497 */
/* U+A8C2 */	0x962C	/*                                         <CJK> */,/* 2498 */
/* U+A8C3 */	0x4E26	/*                                         <CJK> */,/* 2499 */
/* U+A8C4 */	0x4E56	/*                                         <CJK> */,/* 2500 */
/* U+A8C5 */	0x4E73	/*                                         <CJK> */,/* 2501 */
/* U+A8C6 */	0x4E8B	/*                                         <CJK> */,/* 2502 */
/* U+A8C7 */	0x4E9B	/*                                         <CJK> */,/* 2503 */
/* U+A8C8 */	0x4E9E	/*                                         <CJK> */,/* 2504 */
/* U+A8C9 */	0x4EAB	/*                                         <CJK> */,/* 2505 */
/* U+A8CA */	0x4EAC	/*                                         <CJK> */,/* 2506 */
/* U+A8CB */	0x4F6F	/*                                         <CJK> */,/* 2507 */
/* U+A8CC */	0x4F9D	/*                                         <CJK> */,/* 2508 */
/* U+A8CD */	0x4F8D	/*                                         <CJK> */,/* 2509 */
/* U+A8CE */	0x4F73	/*                                         <CJK> */,/* 2510 */
/* U+A8CF */	0x4F7F	/*                                         <CJK> */,/* 2511 */
/* U+A8D0 */	0x4F6C	/*                                         <CJK> */,/* 2512 */
/* U+A8D1 */	0x4F9B	/*                                         <CJK> */,/* 2513 */
/* U+A8D2 */	0x4F8B	/*                                         <CJK> */,/* 2514 */
/* U+A8D3 */	0x4F86	/*                                         <CJK> */,/* 2515 */
/* U+A8D4 */	0x4F83	/*                                         <CJK> */,/* 2516 */
/* U+A8D5 */	0x4F70	/*                                         <CJK> */,/* 2517 */
/* U+A8D6 */	0x4F75	/*                                         <CJK> */,/* 2518 */
/* U+A8D7 */	0x4F88	/*                                         <CJK> */,/* 2519 */
/* U+A8D8 */	0x4F69	/*                                         <CJK> */,/* 2520 */
/* U+A8D9 */	0x4F7B	/*                                         <CJK> */,/* 2521 */
/* U+A8DA */	0x4F96	/*                                         <CJK> */,/* 2522 */
/* U+A8DB */	0x4F7E	/*                                         <CJK> */,/* 2523 */
/* U+A8DC */	0x4F8F	/*                                         <CJK> */,/* 2524 */
/* U+A8DD */	0x4F91	/*                                         <CJK> */,/* 2525 */
/* U+A8DE */	0x4F7A	/*                                         <CJK> */,/* 2526 */
/* U+A8DF */	0x5154	/*                                         <CJK> */,/* 2527 */
/* U+A8E0 */	0x5152	/*                                         <CJK> */,/* 2528 */
/* U+A8E1 */	0x5155	/*                                         <CJK> */,/* 2529 */
/* U+A8E2 */	0x5169	/*                                         <CJK> */,/* 2530 */
/* U+A8E3 */	0x5177	/*                                         <CJK> */,/* 2531 */
/* U+A8E4 */	0x5176	/*                                         <CJK> */,/* 2532 */
/* U+A8E5 */	0x5178	/*                                         <CJK> */,/* 2533 */
/* U+A8E6 */	0x51BD	/*                                         <CJK> */,/* 2534 */
/* U+A8E7 */	0x51FD	/*                                         <CJK> */,/* 2535 */
/* U+A8E8 */	0x523B	/*                                         <CJK> */,/* 2536 */
/* U+A8E9 */	0x5238	/*                                         <CJK> */,/* 2537 */
/* U+A8EA */	0x5237	/*                                         <CJK> */,/* 2538 */
/* U+A8EB */	0x523A	/*                                         <CJK> */,/* 2539 */
/* U+A8EC */	0x5230	/*                                         <CJK> */,/* 2540 */
/* U+A8ED */	0x522E	/*                                         <CJK> */,/* 2541 */
/* U+A8EE */	0x5236	/*                                         <CJK> */,/* 2542 */
/* U+A8EF */	0x5241	/*                                         <CJK> */,/* 2543 */
/* U+A8F0 */	0x52BE	/*                                         <CJK> */,/* 2544 */
/* U+A8F1 */	0x52BB	/*                                         <CJK> */,/* 2545 */
/* U+A8F2 */	0x5352	/*                                         <CJK> */,/* 2546 */
/* U+A8F3 */	0x5354	/*                                         <CJK> */,/* 2547 */
/* U+A8F4 */	0x5353	/*                                         <CJK> */,/* 2548 */
/* U+A8F5 */	0x5351	/*                                         <CJK> */,/* 2549 */
/* U+A8F6 */	0x5366	/*                                         <CJK> */,/* 2550 */
/* U+A8F7 */	0x5377	/*                                         <CJK> */,/* 2551 */
/* U+A8F8 */	0x5378	/*                                         <CJK> */,/* 2552 */
/* U+A8F9 */	0x5379	/*                                         <CJK> */,/* 2553 */
/* U+A8FA */	0x53D6	/*                                         <CJK> */,/* 2554 */
/* U+A8FB */	0x53D4	/*                                         <CJK> */,/* 2555 */
/* U+A8FC */	0x53D7	/*                                         <CJK> */,/* 2556 */
/* U+A8FD */	0x5473	/*                                         <CJK> */,/* 2557 */
/* U+A8FE */	0x5475	/*                                         <CJK> */,/* 2558 */
/* U+A8FF */	UNICODE_REPLACEMENT_CHARACTER,	/* 2559 */
/* U+A900 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2560 */
/* U+A901 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2561 */
/* U+A902 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2562 */
/* U+A903 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2563 */
/* U+A904 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2564 */
/* U+A905 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2565 */
/* U+A906 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2566 */
/* U+A907 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2567 */
/* U+A908 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2568 */
/* U+A909 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2569 */
/* U+A90A */	UNICODE_REPLACEMENT_CHARACTER,	/* 2570 */
/* U+A90B */	UNICODE_REPLACEMENT_CHARACTER,	/* 2571 */
/* U+A90C */	UNICODE_REPLACEMENT_CHARACTER,	/* 2572 */
/* U+A90D */	UNICODE_REPLACEMENT_CHARACTER,	/* 2573 */
/* U+A90E */	UNICODE_REPLACEMENT_CHARACTER,	/* 2574 */
/* U+A90F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2575 */
/* U+A910 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2576 */
/* U+A911 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2577 */
/* U+A912 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2578 */
/* U+A913 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2579 */
/* U+A914 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2580 */
/* U+A915 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2581 */
/* U+A916 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2582 */
/* U+A917 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2583 */
/* U+A918 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2584 */
/* U+A919 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2585 */
/* U+A91A */	UNICODE_REPLACEMENT_CHARACTER,	/* 2586 */
/* U+A91B */	UNICODE_REPLACEMENT_CHARACTER,	/* 2587 */
/* U+A91C */	UNICODE_REPLACEMENT_CHARACTER,	/* 2588 */
/* U+A91D */	UNICODE_REPLACEMENT_CHARACTER,	/* 2589 */
/* U+A91E */	UNICODE_REPLACEMENT_CHARACTER,	/* 2590 */
/* U+A91F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2591 */
/* U+A920 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2592 */
/* U+A921 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2593 */
/* U+A922 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2594 */
/* U+A923 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2595 */
/* U+A924 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2596 */
/* U+A925 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2597 */
/* U+A926 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2598 */
/* U+A927 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2599 */
/* U+A928 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2600 */
/* U+A929 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2601 */
/* U+A92A */	UNICODE_REPLACEMENT_CHARACTER,	/* 2602 */
/* U+A92B */	UNICODE_REPLACEMENT_CHARACTER,	/* 2603 */
/* U+A92C */	UNICODE_REPLACEMENT_CHARACTER,	/* 2604 */
/* U+A92D */	UNICODE_REPLACEMENT_CHARACTER,	/* 2605 */
/* U+A92E */	UNICODE_REPLACEMENT_CHARACTER,	/* 2606 */
/* U+A92F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2607 */
/* U+A930 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2608 */
/* U+A931 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2609 */
/* U+A932 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2610 */
/* U+A933 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2611 */
/* U+A934 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2612 */
/* U+A935 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2613 */
/* U+A936 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2614 */
/* U+A937 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2615 */
/* U+A938 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2616 */
/* U+A939 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2617 */
/* U+A93A */	UNICODE_REPLACEMENT_CHARACTER,	/* 2618 */
/* U+A93B */	UNICODE_REPLACEMENT_CHARACTER,	/* 2619 */
/* U+A93C */	UNICODE_REPLACEMENT_CHARACTER,	/* 2620 */
/* U+A93D */	UNICODE_REPLACEMENT_CHARACTER,	/* 2621 */
/* U+A93E */	UNICODE_REPLACEMENT_CHARACTER,	/* 2622 */
/* U+A93F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2623 */
/* U+A940 */	0x5496	/*                                         <CJK> */,/* 2624 */
/* U+A941 */	0x5478	/*                                         <CJK> */,/* 2625 */
/* U+A942 */	0x5495	/*                                         <CJK> */,/* 2626 */
/* U+A943 */	0x5480	/*                                         <CJK> */,/* 2627 */
/* U+A944 */	0x547B	/*                                         <CJK> */,/* 2628 */
/* U+A945 */	0x5477	/*                                         <CJK> */,/* 2629 */
/* U+A946 */	0x5484	/*                                         <CJK> */,/* 2630 */
/* U+A947 */	0x5492	/*                                         <CJK> */,/* 2631 */
/* U+A948 */	0x5486	/*                                         <CJK> */,/* 2632 */
/* U+A949 */	0x547C	/*                                         <CJK> */,/* 2633 */
/* U+A94A */	0x5490	/*                                         <CJK> */,/* 2634 */
/* U+A94B */	0x5471	/*                                         <CJK> */,/* 2635 */
/* U+A94C */	0x5476	/*                                         <CJK> */,/* 2636 */
/* U+A94D */	0x548C	/*                                         <CJK> */,/* 2637 */
/* U+A94E */	0x549A	/*                                         <CJK> */,/* 2638 */
/* U+A94F */	0x5462	/*                                         <CJK> */,/* 2639 */
/* U+A950 */	0x5468	/*                                         <CJK> */,/* 2640 */
/* U+A951 */	0x548B	/*                                         <CJK> */,/* 2641 */
/* U+A952 */	0x547D	/*                                         <CJK> */,/* 2642 */
/* U+A953 */	0x548E	/*                                         <CJK> */,/* 2643 */
/* U+A954 */	0x56FA	/*                                         <CJK> */,/* 2644 */
/* U+A955 */	0x5783	/*                                         <CJK> */,/* 2645 */
/* U+A956 */	0x5777	/*                                         <CJK> */,/* 2646 */
/* U+A957 */	0x576A	/*                                         <CJK> */,/* 2647 */
/* U+A958 */	0x5769	/*                                         <CJK> */,/* 2648 */
/* U+A959 */	0x5761	/*                                         <CJK> */,/* 2649 */
/* U+A95A */	0x5766	/*                                         <CJK> */,/* 2650 */
/* U+A95B */	0x5764	/*                                         <CJK> */,/* 2651 */
/* U+A95C */	0x577C	/*                                         <CJK> */,/* 2652 */
/* U+A95D */	0x591C	/*                                         <CJK> */,/* 2653 */
/* U+A95E */	0x5949	/*                                         <CJK> */,/* 2654 */
/* U+A95F */	0x5947	/*                                         <CJK> */,/* 2655 */
/* U+A960 */	0x5948	/*                                         <CJK> */,/* 2656 */
/* U+A961 */	0x5944	/*                                         <CJK> */,/* 2657 */
/* U+A962 */	0x5954	/*                                         <CJK> */,/* 2658 */
/* U+A963 */	0x59BE	/*                                         <CJK> */,/* 2659 */
/* U+A964 */	0x59BB	/*                                         <CJK> */,/* 2660 */
/* U+A965 */	0x59D4	/*                                         <CJK> */,/* 2661 */
/* U+A966 */	0x59B9	/*                                         <CJK> */,/* 2662 */
/* U+A967 */	0x59AE	/*                                         <CJK> */,/* 2663 */
/* U+A968 */	0x59D1	/*                                         <CJK> */,/* 2664 */
/* U+A969 */	0x59C6	/*                                         <CJK> */,/* 2665 */
/* U+A96A */	0x59D0	/*                                         <CJK> */,/* 2666 */
/* U+A96B */	0x59CD	/*                                         <CJK> */,/* 2667 */
/* U+A96C */	0x59CB	/*                                         <CJK> */,/* 2668 */
/* U+A96D */	0x59D3	/*                                         <CJK> */,/* 2669 */
/* U+A96E */	0x59CA	/*                                         <CJK> */,/* 2670 */
/* U+A96F */	0x59AF	/*                                         <CJK> */,/* 2671 */
/* U+A970 */	0x59B3	/*                                         <CJK> */,/* 2672 */
/* U+A971 */	0x59D2	/*                                         <CJK> */,/* 2673 */
/* U+A972 */	0x59C5	/*                                         <CJK> */,/* 2674 */
/* U+A973 */	0x5B5F	/*                                         <CJK> */,/* 2675 */
/* U+A974 */	0x5B64	/*                                         <CJK> */,/* 2676 */
/* U+A975 */	0x5B63	/*                                         <CJK> */,/* 2677 */
/* U+A976 */	0x5B97	/*                                         <CJK> */,/* 2678 */
/* U+A977 */	0x5B9A	/*                                         <CJK> */,/* 2679 */
/* U+A978 */	0x5B98	/*                                         <CJK> */,/* 2680 */
/* U+A979 */	0x5B9C	/*                                         <CJK> */,/* 2681 */
/* U+A97A */	0x5B99	/*                                         <CJK> */,/* 2682 */
/* U+A97B */	0x5B9B	/*                                         <CJK> */,/* 2683 */
/* U+A97C */	0x5C1A	/*                                         <CJK> */,/* 2684 */
/* U+A97D */	0x5C48	/*                                         <CJK> */,/* 2685 */
/* U+A97E */	0x5C45	/*                                         <CJK> */,/* 2686 */
/* U+A97F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2687 */
/* U+A980 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2688 */
/* U+A981 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2689 */
/* U+A982 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2690 */
/* U+A983 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2691 */
/* U+A984 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2692 */
/* U+A985 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2693 */
/* U+A986 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2694 */
/* U+A987 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2695 */
/* U+A988 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2696 */
/* U+A989 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2697 */
/* U+A98A */	UNICODE_REPLACEMENT_CHARACTER,	/* 2698 */
/* U+A98B */	UNICODE_REPLACEMENT_CHARACTER,	/* 2699 */
/* U+A98C */	UNICODE_REPLACEMENT_CHARACTER,	/* 2700 */
/* U+A98D */	UNICODE_REPLACEMENT_CHARACTER,	/* 2701 */
/* U+A98E */	UNICODE_REPLACEMENT_CHARACTER,	/* 2702 */
/* U+A98F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2703 */
/* U+A990 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2704 */
/* U+A991 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2705 */
/* U+A992 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2706 */
/* U+A993 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2707 */
/* U+A994 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2708 */
/* U+A995 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2709 */
/* U+A996 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2710 */
/* U+A997 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2711 */
/* U+A998 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2712 */
/* U+A999 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2713 */
/* U+A99A */	UNICODE_REPLACEMENT_CHARACTER,	/* 2714 */
/* U+A99B */	UNICODE_REPLACEMENT_CHARACTER,	/* 2715 */
/* U+A99C */	UNICODE_REPLACEMENT_CHARACTER,	/* 2716 */
/* U+A99D */	UNICODE_REPLACEMENT_CHARACTER,	/* 2717 */
/* U+A99E */	UNICODE_REPLACEMENT_CHARACTER,	/* 2718 */
/* U+A99F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2719 */
/* U+A9A0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2720 */
/* U+A9A1 */	0x5C46	/*                                         <CJK> */,/* 2721 */
/* U+A9A2 */	0x5CB7	/*                                         <CJK> */,/* 2722 */
/* U+A9A3 */	0x5CA1	/*                                         <CJK> */,/* 2723 */
/* U+A9A4 */	0x5CB8	/*                                         <CJK> */,/* 2724 */
/* U+A9A5 */	0x5CA9	/*                                         <CJK> */,/* 2725 */
/* U+A9A6 */	0x5CAB	/*                                         <CJK> */,/* 2726 */
/* U+A9A7 */	0x5CB1	/*                                         <CJK> */,/* 2727 */
/* U+A9A8 */	0x5CB3	/*                                         <CJK> */,/* 2728 */
/* U+A9A9 */	0x5E18	/*                                         <CJK> */,/* 2729 */
/* U+A9AA */	0x5E1A	/*                                         <CJK> */,/* 2730 */
/* U+A9AB */	0x5E16	/*                                         <CJK> */,/* 2731 */
/* U+A9AC */	0x5E15	/*                                         <CJK> */,/* 2732 */
/* U+A9AD */	0x5E1B	/*                                         <CJK> */,/* 2733 */
/* U+A9AE */	0x5E11	/*                                         <CJK> */,/* 2734 */
/* U+A9AF */	0x5E78	/*                                         <CJK> */,/* 2735 */
/* U+A9B0 */	0x5E9A	/*                                         <CJK> */,/* 2736 */
/* U+A9B1 */	0x5E97	/*                                         <CJK> */,/* 2737 */
/* U+A9B2 */	0x5E9C	/*                                         <CJK> */,/* 2738 */
/* U+A9B3 */	0x5E95	/*                                         <CJK> */,/* 2739 */
/* U+A9B4 */	0x5E96	/*                                         <CJK> */,/* 2740 */
/* U+A9B5 */	0x5EF6	/*                                         <CJK> */,/* 2741 */
/* U+A9B6 */	0x5F26	/*                                         <CJK> */,/* 2742 */
/* U+A9B7 */	0x5F27	/*                                         <CJK> */,/* 2743 */
/* U+A9B8 */	0x5F29	/*                                         <CJK> */,/* 2744 */
/* U+A9B9 */	0x5F80	/*                                         <CJK> */,/* 2745 */
/* U+A9BA */	0x5F81	/*                                         <CJK> */,/* 2746 */
/* U+A9BB */	0x5F7F	/*                                         <CJK> */,/* 2747 */
/* U+A9BC */	0x5F7C	/*                                         <CJK> */,/* 2748 */
/* U+A9BD */	0x5FDD	/*                                         <CJK> */,/* 2749 */
/* U+A9BE */	0x5FE0	/*                                         <CJK> */,/* 2750 */
/* U+A9BF */	0x5FFD	/*                                         <CJK> */,/* 2751 */
/* U+A9C0 */	0x5FF5	/*                                         <CJK> */,/* 2752 */
/* U+A9C1 */	0x5FFF	/*                                         <CJK> */,/* 2753 */
/* U+A9C2 */	0x600F	/*                                         <CJK> */,/* 2754 */
/* U+A9C3 */	0x6014	/*                                         <CJK> */,/* 2755 */
/* U+A9C4 */	0x602F	/*                                         <CJK> */,/* 2756 */
/* U+A9C5 */	0x6035	/*                                         <CJK> */,/* 2757 */
/* U+A9C6 */	0x6016	/*                                         <CJK> */,/* 2758 */
/* U+A9C7 */	0x602A	/*                                         <CJK> */,/* 2759 */
/* U+A9C8 */	0x6015	/*                                         <CJK> */,/* 2760 */
/* U+A9C9 */	0x6021	/*                                         <CJK> */,/* 2761 */
/* U+A9CA */	0x6027	/*                                         <CJK> */,/* 2762 */
/* U+A9CB */	0x6029	/*                                         <CJK> */,/* 2763 */
/* U+A9CC */	0x602B	/*                                         <CJK> */,/* 2764 */
/* U+A9CD */	0x601B	/*                                         <CJK> */,/* 2765 */
/* U+A9CE */	0x6216	/*                                         <CJK> */,/* 2766 */
/* U+A9CF */	0x6215	/*                                         <CJK> */,/* 2767 */
/* U+A9D0 */	0x623F	/*                                         <CJK> */,/* 2768 */
/* U+A9D1 */	0x623E	/*                                         <CJK> */,/* 2769 */
/* U+A9D2 */	0x6240	/*                                         <CJK> */,/* 2770 */
/* U+A9D3 */	0x627F	/*                                         <CJK> */,/* 2771 */
/* U+A9D4 */	0x62C9	/*                                         <CJK> */,/* 2772 */
/* U+A9D5 */	0x62CC	/*                                         <CJK> */,/* 2773 */
/* U+A9D6 */	0x62C4	/*                                         <CJK> */,/* 2774 */
/* U+A9D7 */	0x62BF	/*                                         <CJK> */,/* 2775 */
/* U+A9D8 */	0x62C2	/*                                         <CJK> */,/* 2776 */
/* U+A9D9 */	0x62B9	/*                                         <CJK> */,/* 2777 */
/* U+A9DA */	0x62D2	/*                                         <CJK> */,/* 2778 */
/* U+A9DB */	0x62DB	/*                                         <CJK> */,/* 2779 */
/* U+A9DC */	0x62AB	/*                                         <CJK> */,/* 2780 */
/* U+A9DD */	0x62D3	/*                                         <CJK> */,/* 2781 */
/* U+A9DE */	0x62D4	/*                                         <CJK> */,/* 2782 */
/* U+A9DF */	0x62CB	/*                                         <CJK> */,/* 2783 */
/* U+A9E0 */	0x62C8	/*                                         <CJK> */,/* 2784 */
/* U+A9E1 */	0x62A8	/*                                         <CJK> */,/* 2785 */
/* U+A9E2 */	0x62BD	/*                                         <CJK> */,/* 2786 */
/* U+A9E3 */	0x62BC	/*                                         <CJK> */,/* 2787 */
/* U+A9E4 */	0x62D0	/*                                         <CJK> */,/* 2788 */
/* U+A9E5 */	0x62D9	/*                                         <CJK> */,/* 2789 */
/* U+A9E6 */	0x62C7	/*                                         <CJK> */,/* 2790 */
/* U+A9E7 */	0x62CD	/*                                         <CJK> */,/* 2791 */
/* U+A9E8 */	0x62B5	/*                                         <CJK> */,/* 2792 */
/* U+A9E9 */	0x62DA	/*                                         <CJK> */,/* 2793 */
/* U+A9EA */	0x62B1	/*                                         <CJK> */,/* 2794 */
/* U+A9EB */	0x62D8	/*                                         <CJK> */,/* 2795 */
/* U+A9EC */	0x62D6	/*                                         <CJK> */,/* 2796 */
/* U+A9ED */	0x62D7	/*                                         <CJK> */,/* 2797 */
/* U+A9EE */	0x62C6	/*                                         <CJK> */,/* 2798 */
/* U+A9EF */	0x62AC	/*                                         <CJK> */,/* 2799 */
/* U+A9F0 */	0x62CE	/*                                         <CJK> */,/* 2800 */
/* U+A9F1 */	0x653E	/*                                         <CJK> */,/* 2801 */
/* U+A9F2 */	0x65A7	/*                                         <CJK> */,/* 2802 */
/* U+A9F3 */	0x65BC	/*                                         <CJK> */,/* 2803 */
/* U+A9F4 */	0x65FA	/*                                         <CJK> */,/* 2804 */
/* U+A9F5 */	0x6614	/*                                         <CJK> */,/* 2805 */
/* U+A9F6 */	0x6613	/*                                         <CJK> */,/* 2806 */
/* U+A9F7 */	0x660C	/*                                         <CJK> */,/* 2807 */
/* U+A9F8 */	0x6606	/*                                         <CJK> */,/* 2808 */
/* U+A9F9 */	0x6602	/*                                         <CJK> */,/* 2809 */
/* U+A9FA */	0x660E	/*                                         <CJK> */,/* 2810 */
/* U+A9FB */	0x6600	/*                                         <CJK> */,/* 2811 */
/* U+A9FC */	0x660F	/*                                         <CJK> */,/* 2812 */
/* U+A9FD */	0x6615	/*                                         <CJK> */,/* 2813 */
/* U+A9FE */	0x660A	/*                                         <CJK> */,/* 2814 */
/* U+A9FF */	UNICODE_REPLACEMENT_CHARACTER,	/* 2815 */
/* U+AA00 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2816 */
/* U+AA01 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2817 */
/* U+AA02 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2818 */
/* U+AA03 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2819 */
/* U+AA04 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2820 */
/* U+AA05 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2821 */
/* U+AA06 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2822 */
/* U+AA07 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2823 */
/* U+AA08 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2824 */
/* U+AA09 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2825 */
/* U+AA0A */	UNICODE_REPLACEMENT_CHARACTER,	/* 2826 */
/* U+AA0B */	UNICODE_REPLACEMENT_CHARACTER,	/* 2827 */
/* U+AA0C */	UNICODE_REPLACEMENT_CHARACTER,	/* 2828 */
/* U+AA0D */	UNICODE_REPLACEMENT_CHARACTER,	/* 2829 */
/* U+AA0E */	UNICODE_REPLACEMENT_CHARACTER,	/* 2830 */
/* U+AA0F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2831 */
/* U+AA10 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2832 */
/* U+AA11 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2833 */
/* U+AA12 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2834 */
/* U+AA13 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2835 */
/* U+AA14 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2836 */
/* U+AA15 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2837 */
/* U+AA16 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2838 */
/* U+AA17 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2839 */
/* U+AA18 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2840 */
/* U+AA19 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2841 */
/* U+AA1A */	UNICODE_REPLACEMENT_CHARACTER,	/* 2842 */
/* U+AA1B */	UNICODE_REPLACEMENT_CHARACTER,	/* 2843 */
/* U+AA1C */	UNICODE_REPLACEMENT_CHARACTER,	/* 2844 */
/* U+AA1D */	UNICODE_REPLACEMENT_CHARACTER,	/* 2845 */
/* U+AA1E */	UNICODE_REPLACEMENT_CHARACTER,	/* 2846 */
/* U+AA1F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2847 */
/* U+AA20 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2848 */
/* U+AA21 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2849 */
/* U+AA22 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2850 */
/* U+AA23 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2851 */
/* U+AA24 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2852 */
/* U+AA25 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2853 */
/* U+AA26 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2854 */
/* U+AA27 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2855 */
/* U+AA28 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2856 */
/* U+AA29 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2857 */
/* U+AA2A */	UNICODE_REPLACEMENT_CHARACTER,	/* 2858 */
/* U+AA2B */	UNICODE_REPLACEMENT_CHARACTER,	/* 2859 */
/* U+AA2C */	UNICODE_REPLACEMENT_CHARACTER,	/* 2860 */
/* U+AA2D */	UNICODE_REPLACEMENT_CHARACTER,	/* 2861 */
/* U+AA2E */	UNICODE_REPLACEMENT_CHARACTER,	/* 2862 */
/* U+AA2F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2863 */
/* U+AA30 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2864 */
/* U+AA31 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2865 */
/* U+AA32 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2866 */
/* U+AA33 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2867 */
/* U+AA34 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2868 */
/* U+AA35 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2869 */
/* U+AA36 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2870 */
/* U+AA37 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2871 */
/* U+AA38 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2872 */
/* U+AA39 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2873 */
/* U+AA3A */	UNICODE_REPLACEMENT_CHARACTER,	/* 2874 */
/* U+AA3B */	UNICODE_REPLACEMENT_CHARACTER,	/* 2875 */
/* U+AA3C */	UNICODE_REPLACEMENT_CHARACTER,	/* 2876 */
/* U+AA3D */	UNICODE_REPLACEMENT_CHARACTER,	/* 2877 */
/* U+AA3E */	UNICODE_REPLACEMENT_CHARACTER,	/* 2878 */
/* U+AA3F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2879 */
/* U+AA40 */	0x6607	/*                                         <CJK> */,/* 2880 */
/* U+AA41 */	0x670D	/*                                         <CJK> */,/* 2881 */
/* U+AA42 */	0x670B	/*                                         <CJK> */,/* 2882 */
/* U+AA43 */	0x676D	/*                                         <CJK> */,/* 2883 */
/* U+AA44 */	0x678B	/*                                         <CJK> */,/* 2884 */
/* U+AA45 */	0x6795	/*                                         <CJK> */,/* 2885 */
/* U+AA46 */	0x6771	/*                                         <CJK> */,/* 2886 */
/* U+AA47 */	0x679C	/*                                         <CJK> */,/* 2887 */
/* U+AA48 */	0x6773	/*                                         <CJK> */,/* 2888 */
/* U+AA49 */	0x6777	/*                                         <CJK> */,/* 2889 */
/* U+AA4A */	0x6787	/*                                         <CJK> */,/* 2890 */
/* U+AA4B */	0x679D	/*                                         <CJK> */,/* 2891 */
/* U+AA4C */	0x6797	/*                                         <CJK> */,/* 2892 */
/* U+AA4D */	0x676F	/*                                         <CJK> */,/* 2893 */
/* U+AA4E */	0x6770	/*                                         <CJK> */,/* 2894 */
/* U+AA4F */	0x677F	/*                                         <CJK> */,/* 2895 */
/* U+AA50 */	0x6789	/*                                         <CJK> */,/* 2896 */
/* U+AA51 */	0x677E	/*                                         <CJK> */,/* 2897 */
/* U+AA52 */	0x6790	/*                                         <CJK> */,/* 2898 */
/* U+AA53 */	0x6775	/*                                         <CJK> */,/* 2899 */
/* U+AA54 */	0x679A	/*                                         <CJK> */,/* 2900 */
/* U+AA55 */	0x6793	/*                                         <CJK> */,/* 2901 */
/* U+AA56 */	0x677C	/*                                         <CJK> */,/* 2902 */
/* U+AA57 */	0x676A	/*                                         <CJK> */,/* 2903 */
/* U+AA58 */	0x6772	/*                                         <CJK> */,/* 2904 */
/* U+AA59 */	0x6B23	/*                                         <CJK> */,/* 2905 */
/* U+AA5A */	0x6B66	/*                                         <CJK> */,/* 2906 */
/* U+AA5B */	0x6B67	/*                                         <CJK> */,/* 2907 */
/* U+AA5C */	0x6B7F	/*                                         <CJK> */,/* 2908 */
/* U+AA5D */	0x6C13	/*                                         <CJK> */,/* 2909 */
/* U+AA5E */	0x6C1B	/*                                         <CJK> */,/* 2910 */
/* U+AA5F */	0x6CE3	/*                                         <CJK> */,/* 2911 */
/* U+AA60 */	0x6CE8	/*                                         <CJK> */,/* 2912 */
/* U+AA61 */	0x6CF3	/*                                         <CJK> */,/* 2913 */
/* U+AA62 */	0x6CB1	/*                                         <CJK> */,/* 2914 */
/* U+AA63 */	0x6CCC	/*                                         <CJK> */,/* 2915 */
/* U+AA64 */	0x6CE5	/*                                         <CJK> */,/* 2916 */
/* U+AA65 */	0x6CB3	/*                                         <CJK> */,/* 2917 */
/* U+AA66 */	0x6CBD	/*                                         <CJK> */,/* 2918 */
/* U+AA67 */	0x6CBE	/*                                         <CJK> */,/* 2919 */
/* U+AA68 */	0x6CBC	/*                                         <CJK> */,/* 2920 */
/* U+AA69 */	0x6CE2	/*                                         <CJK> */,/* 2921 */
/* U+AA6A */	0x6CAB	/*                                         <CJK> */,/* 2922 */
/* U+AA6B */	0x6CD5	/*                                         <CJK> */,/* 2923 */
/* U+AA6C */	0x6CD3	/*                                         <CJK> */,/* 2924 */
/* U+AA6D */	0x6CB8	/*                                         <CJK> */,/* 2925 */
/* U+AA6E */	0x6CC4	/*                                         <CJK> */,/* 2926 */
/* U+AA6F */	0x6CB9	/*                                         <CJK> */,/* 2927 */
/* U+AA70 */	0x6CC1	/*                                         <CJK> */,/* 2928 */
/* U+AA71 */	0x6CAE	/*                                         <CJK> */,/* 2929 */
/* U+AA72 */	0x6CD7	/*                                         <CJK> */,/* 2930 */
/* U+AA73 */	0x6CC5	/*                                         <CJK> */,/* 2931 */
/* U+AA74 */	0x6CF1	/*                                         <CJK> */,/* 2932 */
/* U+AA75 */	0x6CBF	/*                                         <CJK> */,/* 2933 */
/* U+AA76 */	0x6CBB	/*                                         <CJK> */,/* 2934 */
/* U+AA77 */	0x6CE1	/*                                         <CJK> */,/* 2935 */
/* U+AA78 */	0x6CDB	/*                                         <CJK> */,/* 2936 */
/* U+AA79 */	0x6CCA	/*                                         <CJK> */,/* 2937 */
/* U+AA7A */	0x6CAC	/*                                         <CJK> */,/* 2938 */
/* U+AA7B */	0x6CEF	/*                                         <CJK> */,/* 2939 */
/* U+AA7C */	0x6CDC	/*                                         <CJK> */,/* 2940 */
/* U+AA7D */	0x6CD6	/*                                         <CJK> */,/* 2941 */
/* U+AA7E */	0x6CE0	/*                                         <CJK> */,/* 2942 */
/* U+AA7F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2943 */
/* U+AA80 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2944 */
/* U+AA81 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2945 */
/* U+AA82 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2946 */
/* U+AA83 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2947 */
/* U+AA84 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2948 */
/* U+AA85 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2949 */
/* U+AA86 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2950 */
/* U+AA87 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2951 */
/* U+AA88 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2952 */
/* U+AA89 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2953 */
/* U+AA8A */	UNICODE_REPLACEMENT_CHARACTER,	/* 2954 */
/* U+AA8B */	UNICODE_REPLACEMENT_CHARACTER,	/* 2955 */
/* U+AA8C */	UNICODE_REPLACEMENT_CHARACTER,	/* 2956 */
/* U+AA8D */	UNICODE_REPLACEMENT_CHARACTER,	/* 2957 */
/* U+AA8E */	UNICODE_REPLACEMENT_CHARACTER,	/* 2958 */
/* U+AA8F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2959 */
/* U+AA90 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2960 */
/* U+AA91 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2961 */
/* U+AA92 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2962 */
/* U+AA93 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2963 */
/* U+AA94 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2964 */
/* U+AA95 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2965 */
/* U+AA96 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2966 */
/* U+AA97 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2967 */
/* U+AA98 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2968 */
/* U+AA99 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2969 */
/* U+AA9A */	UNICODE_REPLACEMENT_CHARACTER,	/* 2970 */
/* U+AA9B */	UNICODE_REPLACEMENT_CHARACTER,	/* 2971 */
/* U+AA9C */	UNICODE_REPLACEMENT_CHARACTER,	/* 2972 */
/* U+AA9D */	UNICODE_REPLACEMENT_CHARACTER,	/* 2973 */
/* U+AA9E */	UNICODE_REPLACEMENT_CHARACTER,	/* 2974 */
/* U+AA9F */	UNICODE_REPLACEMENT_CHARACTER,	/* 2975 */
/* U+AAA0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 2976 */
/* U+AAA1 */	0x7095	/*                                         <CJK> */,/* 2977 */
/* U+AAA2 */	0x708E	/*                                         <CJK> */,/* 2978 */
/* U+AAA3 */	0x7092	/*                                         <CJK> */,/* 2979 */
/* U+AAA4 */	0x708A	/*                                         <CJK> */,/* 2980 */
/* U+AAA5 */	0x7099	/*                                         <CJK> */,/* 2981 */
/* U+AAA6 */	0x722C	/*                                         <CJK> */,/* 2982 */
/* U+AAA7 */	0x722D	/*                                         <CJK> */,/* 2983 */
/* U+AAA8 */	0x7238	/*                                         <CJK> */,/* 2984 */
/* U+AAA9 */	0x7248	/*                                         <CJK> */,/* 2985 */
/* U+AAAA */	0x7267	/*                                         <CJK> */,/* 2986 */
/* U+AAAB */	0x7269	/*                                         <CJK> */,/* 2987 */
/* U+AAAC */	0x72C0	/*                                         <CJK> */,/* 2988 */
/* U+AAAD */	0x72CE	/*                                         <CJK> */,/* 2989 */
/* U+AAAE */	0x72D9	/*                                         <CJK> */,/* 2990 */
/* U+AAAF */	0x72D7	/*                                         <CJK> */,/* 2991 */
/* U+AAB0 */	0x72D0	/*                                         <CJK> */,/* 2992 */
/* U+AAB1 */	0x73A9	/*                                         <CJK> */,/* 2993 */
/* U+AAB2 */	0x73A8	/*                                         <CJK> */,/* 2994 */
/* U+AAB3 */	0x739F	/*                                         <CJK> */,/* 2995 */
/* U+AAB4 */	0x73AB	/*                                         <CJK> */,/* 2996 */
/* U+AAB5 */	0x73A5	/*                                         <CJK> */,/* 2997 */
/* U+AAB6 */	0x753D	/*                                         <CJK> */,/* 2998 */
/* U+AAB7 */	0x759D	/*                                         <CJK> */,/* 2999 */
/* U+AAB8 */	0x7599	/*                                         <CJK> */,/* 3000 */
/* U+AAB9 */	0x759A	/*                                         <CJK> */,/* 3001 */
/* U+AABA */	0x7684	/*                                         <CJK> */,/* 3002 */
/* U+AABB */	0x76C2	/*                                         <CJK> */,/* 3003 */
/* U+AABC */	0x76F2	/*                                         <CJK> */,/* 3004 */
/* U+AABD */	0x76F4	/*                                         <CJK> */,/* 3005 */
/* U+AABE */	0x77E5	/*                                         <CJK> */,/* 3006 */
/* U+AABF */	0x77FD	/*                                         <CJK> */,/* 3007 */
/* U+AAC0 */	0x793E	/*                                         <CJK> */,/* 3008 */
/* U+AAC1 */	0x7940	/*                                         <CJK> */,/* 3009 */
/* U+AAC2 */	0x7941	/*                                         <CJK> */,/* 3010 */
/* U+AAC3 */	0x79C9	/*                                         <CJK> */,/* 3011 */
/* U+AAC4 */	0x79C8	/*                                         <CJK> */,/* 3012 */
/* U+AAC5 */	0x7A7A	/*                                         <CJK> */,/* 3013 */
/* U+AAC6 */	0x7A79	/*                                         <CJK> */,/* 3014 */
/* U+AAC7 */	0x7AFA	/*                                         <CJK> */,/* 3015 */
/* U+AAC8 */	0x7CFE	/*                                         <CJK> */,/* 3016 */
/* U+AAC9 */	0x7F54	/*                                         <CJK> */,/* 3017 */
/* U+AACA */	0x7F8C	/*                                         <CJK> */,/* 3018 */
/* U+AACB */	0x7F8B	/*                                         <CJK> */,/* 3019 */
/* U+AACC */	0x8005	/*                                         <CJK> */,/* 3020 */
/* U+AACD */	0x80BA	/*                                         <CJK> */,/* 3021 */
/* U+AACE */	0x80A5	/*                                         <CJK> */,/* 3022 */
/* U+AACF */	0x80A2	/*                                         <CJK> */,/* 3023 */
/* U+AAD0 */	0x80B1	/*                                         <CJK> */,/* 3024 */
/* U+AAD1 */	0x80A1	/*                                         <CJK> */,/* 3025 */
/* U+AAD2 */	0x80AB	/*                                         <CJK> */,/* 3026 */
/* U+AAD3 */	0x80A9	/*                                         <CJK> */,/* 3027 */
/* U+AAD4 */	0x80B4	/*                                         <CJK> */,/* 3028 */
/* U+AAD5 */	0x80AA	/*                                         <CJK> */,/* 3029 */
/* U+AAD6 */	0x80AF	/*                                         <CJK> */,/* 3030 */
/* U+AAD7 */	0x81E5	/*                                         <CJK> */,/* 3031 */
/* U+AAD8 */	0x81FE	/*                                         <CJK> */,/* 3032 */
/* U+AAD9 */	0x820D	/*                                         <CJK> */,/* 3033 */
/* U+AADA */	0x82B3	/*                                         <CJK> */,/* 3034 */
/* U+AADB */	0x829D	/*                                         <CJK> */,/* 3035 */
/* U+AADC */	0x8299	/*                                         <CJK> */,/* 3036 */
/* U+AADD */	0x82AD	/*                                         <CJK> */,/* 3037 */
/* U+AADE */	0x82BD	/*                                         <CJK> */,/* 3038 */
/* U+AADF */	0x829F	/*                                         <CJK> */,/* 3039 */
/* U+AAE0 */	0x82B9	/*                                         <CJK> */,/* 3040 */
/* U+AAE1 */	0x82B1	/*                                         <CJK> */,/* 3041 */
/* U+AAE2 */	0x82AC	/*                                         <CJK> */,/* 3042 */
/* U+AAE3 */	0x82A5	/*                                         <CJK> */,/* 3043 */
/* U+AAE4 */	0x82AF	/*                                         <CJK> */,/* 3044 */
/* U+AAE5 */	0x82B8	/*                                         <CJK> */,/* 3045 */
/* U+AAE6 */	0x82A3	/*                                         <CJK> */,/* 3046 */
/* U+AAE7 */	0x82B0	/*                                         <CJK> */,/* 3047 */
/* U+AAE8 */	0x82BE	/*                                         <CJK> */,/* 3048 */
/* U+AAE9 */	0x82B7	/*                                         <CJK> */,/* 3049 */
/* U+AAEA */	0x864E	/*                                         <CJK> */,/* 3050 */
/* U+AAEB */	0x8671	/*                                         <CJK> */,/* 3051 */
/* U+AAEC */	0x521D	/*                                         <CJK> */,/* 3052 */
/* U+AAED */	0x8868	/*                                         <CJK> */,/* 3053 */
/* U+AAEE */	0x8ECB	/*                                         <CJK> */,/* 3054 */
/* U+AAEF */	0x8FCE	/*                                         <CJK> */,/* 3055 */
/* U+AAF0 */	0x8FD4	/*                                         <CJK> */,/* 3056 */
/* U+AAF1 */	0x8FD1	/*                                         <CJK> */,/* 3057 */
/* U+AAF2 */	0x90B5	/*                                         <CJK> */,/* 3058 */
/* U+AAF3 */	0x90B8	/*                                         <CJK> */,/* 3059 */
/* U+AAF4 */	0x90B1	/*                                         <CJK> */,/* 3060 */
/* U+AAF5 */	0x90B6	/*                                         <CJK> */,/* 3061 */
/* U+AAF6 */	0x91C7	/*                                         <CJK> */,/* 3062 */
/* U+AAF7 */	0x91D1	/*                                         <CJK> */,/* 3063 */
/* U+AAF8 */	0x9577	/*                                         <CJK> */,/* 3064 */
/* U+AAF9 */	0x9580	/*                                         <CJK> */,/* 3065 */
/* U+AAFA */	0x961C	/*                                         <CJK> */,/* 3066 */
/* U+AAFB */	0x9640	/*                                         <CJK> */,/* 3067 */
/* U+AAFC */	0x963F	/*                                         <CJK> */,/* 3068 */
/* U+AAFD */	0x963B	/*                                         <CJK> */,/* 3069 */
/* U+AAFE */	0x9644	/*                                         <CJK> */,/* 3070 */
/* U+AAFF */	UNICODE_REPLACEMENT_CHARACTER,	/* 3071 */
/* U+AB00 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3072 */
/* U+AB01 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3073 */
/* U+AB02 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3074 */
/* U+AB03 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3075 */
/* U+AB04 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3076 */
/* U+AB05 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3077 */
/* U+AB06 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3078 */
/* U+AB07 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3079 */
/* U+AB08 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3080 */
/* U+AB09 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3081 */
/* U+AB0A */	UNICODE_REPLACEMENT_CHARACTER,	/* 3082 */
/* U+AB0B */	UNICODE_REPLACEMENT_CHARACTER,	/* 3083 */
/* U+AB0C */	UNICODE_REPLACEMENT_CHARACTER,	/* 3084 */
/* U+AB0D */	UNICODE_REPLACEMENT_CHARACTER,	/* 3085 */
/* U+AB0E */	UNICODE_REPLACEMENT_CHARACTER,	/* 3086 */
/* U+AB0F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3087 */
/* U+AB10 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3088 */
/* U+AB11 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3089 */
/* U+AB12 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3090 */
/* U+AB13 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3091 */
/* U+AB14 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3092 */
/* U+AB15 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3093 */
/* U+AB16 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3094 */
/* U+AB17 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3095 */
/* U+AB18 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3096 */
/* U+AB19 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3097 */
/* U+AB1A */	UNICODE_REPLACEMENT_CHARACTER,	/* 3098 */
/* U+AB1B */	UNICODE_REPLACEMENT_CHARACTER,	/* 3099 */
/* U+AB1C */	UNICODE_REPLACEMENT_CHARACTER,	/* 3100 */
/* U+AB1D */	UNICODE_REPLACEMENT_CHARACTER,	/* 3101 */
/* U+AB1E */	UNICODE_REPLACEMENT_CHARACTER,	/* 3102 */
/* U+AB1F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3103 */
/* U+AB20 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3104 */
/* U+AB21 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3105 */
/* U+AB22 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3106 */
/* U+AB23 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3107 */
/* U+AB24 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3108 */
/* U+AB25 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3109 */
/* U+AB26 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3110 */
/* U+AB27 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3111 */
/* U+AB28 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3112 */
/* U+AB29 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3113 */
/* U+AB2A */	UNICODE_REPLACEMENT_CHARACTER,	/* 3114 */
/* U+AB2B */	UNICODE_REPLACEMENT_CHARACTER,	/* 3115 */
/* U+AB2C */	UNICODE_REPLACEMENT_CHARACTER,	/* 3116 */
/* U+AB2D */	UNICODE_REPLACEMENT_CHARACTER,	/* 3117 */
/* U+AB2E */	UNICODE_REPLACEMENT_CHARACTER,	/* 3118 */
/* U+AB2F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3119 */
/* U+AB30 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3120 */
/* U+AB31 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3121 */
/* U+AB32 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3122 */
/* U+AB33 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3123 */
/* U+AB34 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3124 */
/* U+AB35 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3125 */
/* U+AB36 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3126 */
/* U+AB37 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3127 */
/* U+AB38 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3128 */
/* U+AB39 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3129 */
/* U+AB3A */	UNICODE_REPLACEMENT_CHARACTER,	/* 3130 */
/* U+AB3B */	UNICODE_REPLACEMENT_CHARACTER,	/* 3131 */
/* U+AB3C */	UNICODE_REPLACEMENT_CHARACTER,	/* 3132 */
/* U+AB3D */	UNICODE_REPLACEMENT_CHARACTER,	/* 3133 */
/* U+AB3E */	UNICODE_REPLACEMENT_CHARACTER,	/* 3134 */
/* U+AB3F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3135 */
/* U+AB40 */	0x9642	/*                                         <CJK> */,/* 3136 */
/* U+AB41 */	0x96B9	/*                                         <CJK> */,/* 3137 */
/* U+AB42 */	0x96E8	/*                                         <CJK> */,/* 3138 */
/* U+AB43 */	0x9752	/*                                         <CJK> */,/* 3139 */
/* U+AB44 */	0x975E	/*                                         <CJK> */,/* 3140 */
/* U+AB45 */	0x4E9F	/*                                         <CJK> */,/* 3141 */
/* U+AB46 */	0x4EAD	/*                                         <CJK> */,/* 3142 */
/* U+AB47 */	0x4EAE	/*                                         <CJK> */,/* 3143 */
/* U+AB48 */	0x4FE1	/*                                         <CJK> */,/* 3144 */
/* U+AB49 */	0x4FB5	/*                                         <CJK> */,/* 3145 */
/* U+AB4A */	0x4FAF	/*                                         <CJK> */,/* 3146 */
/* U+AB4B */	0x4FBF	/*                                         <CJK> */,/* 3147 */
/* U+AB4C */	0x4FE0	/*                                         <CJK> */,/* 3148 */
/* U+AB4D */	0x4FD1	/*                                         <CJK> */,/* 3149 */
/* U+AB4E */	0x4FCF	/*                                         <CJK> */,/* 3150 */
/* U+AB4F */	0x4FDD	/*                                         <CJK> */,/* 3151 */
/* U+AB50 */	0x4FC3	/*                                         <CJK> */,/* 3152 */
/* U+AB51 */	0x4FB6	/*                                         <CJK> */,/* 3153 */
/* U+AB52 */	0x4FD8	/*                                         <CJK> */,/* 3154 */
/* U+AB53 */	0x4FDF	/*                                         <CJK> */,/* 3155 */
/* U+AB54 */	0x4FCA	/*                                         <CJK> */,/* 3156 */
/* U+AB55 */	0x4FD7	/*                                         <CJK> */,/* 3157 */
/* U+AB56 */	0x4FAE	/*                                         <CJK> */,/* 3158 */
/* U+AB57 */	0x4FD0	/*                                         <CJK> */,/* 3159 */
/* U+AB58 */	0x4FC4	/*                                         <CJK> */,/* 3160 */
/* U+AB59 */	0x4FC2	/*                                         <CJK> */,/* 3161 */
/* U+AB5A */	0x4FDA	/*                                         <CJK> */,/* 3162 */
/* U+AB5B */	0x4FCE	/*                                         <CJK> */,/* 3163 */
/* U+AB5C */	0x4FDE	/*                                         <CJK> */,/* 3164 */
/* U+AB5D */	0x4FB7	/*                                         <CJK> */,/* 3165 */
/* U+AB5E */	0x5157	/*                                         <CJK> */,/* 3166 */
/* U+AB5F */	0x5192	/*                                         <CJK> */,/* 3167 */
/* U+AB60 */	0x5191	/*                                         <CJK> */,/* 3168 */
/* U+AB61 */	0x51A0	/*                                         <CJK> */,/* 3169 */
/* U+AB62 */	0x524E	/*                                         <CJK> */,/* 3170 */
/* U+AB63 */	0x5243	/*                                         <CJK> */,/* 3171 */
/* U+AB64 */	0x524A	/*                                         <CJK> */,/* 3172 */
/* U+AB65 */	0x524D	/*                                         <CJK> */,/* 3173 */
/* U+AB66 */	0x524C	/*                                         <CJK> */,/* 3174 */
/* U+AB67 */	0x524B	/*                                         <CJK> */,/* 3175 */
/* U+AB68 */	0x5247	/*                                         <CJK> */,/* 3176 */
/* U+AB69 */	0x52C7	/*                                         <CJK> */,/* 3177 */
/* U+AB6A */	0x52C9	/*                                         <CJK> */,/* 3178 */
/* U+AB6B */	0x52C3	/*                                         <CJK> */,/* 3179 */
/* U+AB6C */	0x52C1	/*                                         <CJK> */,/* 3180 */
/* U+AB6D */	0x530D	/*                                         <CJK> */,/* 3181 */
/* U+AB6E */	0x5357	/*                                         <CJK> */,/* 3182 */
/* U+AB6F */	0x537B	/*                                         <CJK> */,/* 3183 */
/* U+AB70 */	0x539A	/*                                         <CJK> */,/* 3184 */
/* U+AB71 */	0x53DB	/*                                         <CJK> */,/* 3185 */
/* U+AB72 */	0x54AC	/*                                         <CJK> */,/* 3186 */
/* U+AB73 */	0x54C0	/*                                         <CJK> */,/* 3187 */
/* U+AB74 */	0x54A8	/*                                         <CJK> */,/* 3188 */
/* U+AB75 */	0x54CE	/*                                         <CJK> */,/* 3189 */
/* U+AB76 */	0x54C9	/*                                         <CJK> */,/* 3190 */
/* U+AB77 */	0x54B8	/*                                         <CJK> */,/* 3191 */
/* U+AB78 */	0x54A6	/*                                         <CJK> */,/* 3192 */
/* U+AB79 */	0x54B3	/*                                         <CJK> */,/* 3193 */
/* U+AB7A */	0x54C7	/*                                         <CJK> */,/* 3194 */
/* U+AB7B */	0x54C2	/*                                         <CJK> */,/* 3195 */
/* U+AB7C */	0x54BD	/*                                         <CJK> */,/* 3196 */
/* U+AB7D */	0x54AA	/*                                         <CJK> */,/* 3197 */
/* U+AB7E */	0x54C1	/*                                         <CJK> */,/* 3198 */
/* U+AB7F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3199 */
/* U+AB80 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3200 */
/* U+AB81 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3201 */
/* U+AB82 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3202 */
/* U+AB83 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3203 */
/* U+AB84 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3204 */
/* U+AB85 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3205 */
/* U+AB86 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3206 */
/* U+AB87 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3207 */
/* U+AB88 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3208 */
/* U+AB89 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3209 */
/* U+AB8A */	UNICODE_REPLACEMENT_CHARACTER,	/* 3210 */
/* U+AB8B */	UNICODE_REPLACEMENT_CHARACTER,	/* 3211 */
/* U+AB8C */	UNICODE_REPLACEMENT_CHARACTER,	/* 3212 */
/* U+AB8D */	UNICODE_REPLACEMENT_CHARACTER,	/* 3213 */
/* U+AB8E */	UNICODE_REPLACEMENT_CHARACTER,	/* 3214 */
/* U+AB8F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3215 */
/* U+AB90 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3216 */
/* U+AB91 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3217 */
/* U+AB92 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3218 */
/* U+AB93 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3219 */
/* U+AB94 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3220 */
/* U+AB95 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3221 */
/* U+AB96 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3222 */
/* U+AB97 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3223 */
/* U+AB98 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3224 */
/* U+AB99 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3225 */
/* U+AB9A */	UNICODE_REPLACEMENT_CHARACTER,	/* 3226 */
/* U+AB9B */	UNICODE_REPLACEMENT_CHARACTER,	/* 3227 */
/* U+AB9C */	UNICODE_REPLACEMENT_CHARACTER,	/* 3228 */
/* U+AB9D */	UNICODE_REPLACEMENT_CHARACTER,	/* 3229 */
/* U+AB9E */	UNICODE_REPLACEMENT_CHARACTER,	/* 3230 */
/* U+AB9F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3231 */
/* U+ABA0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3232 */
/* U+ABA1 */	0x54C4	/*                                         <CJK> */,/* 3233 */
/* U+ABA2 */	0x54C8	/*                                         <CJK> */,/* 3234 */
/* U+ABA3 */	0x54AF	/*                                         <CJK> */,/* 3235 */
/* U+ABA4 */	0x54AB	/*                                         <CJK> */,/* 3236 */
/* U+ABA5 */	0x54B1	/*                                         <CJK> */,/* 3237 */
/* U+ABA6 */	0x54BB	/*                                         <CJK> */,/* 3238 */
/* U+ABA7 */	0x54A9	/*                                         <CJK> */,/* 3239 */
/* U+ABA8 */	0x54A7	/*                                         <CJK> */,/* 3240 */
/* U+ABA9 */	0x54BF	/*                                         <CJK> */,/* 3241 */
/* U+ABAA */	0x56FF	/*                                         <CJK> */,/* 3242 */
/* U+ABAB */	0x5782	/*                                         <CJK> */,/* 3243 */
/* U+ABAC */	0x578B	/*                                         <CJK> */,/* 3244 */
/* U+ABAD */	0x57A0	/*                                         <CJK> */,/* 3245 */
/* U+ABAE */	0x57A3	/*                                         <CJK> */,/* 3246 */
/* U+ABAF */	0x57A2	/*                                         <CJK> */,/* 3247 */
/* U+ABB0 */	0x57CE	/*                                         <CJK> */,/* 3248 */
/* U+ABB1 */	0x57AE	/*                                         <CJK> */,/* 3249 */
/* U+ABB2 */	0x5793	/*                                         <CJK> */,/* 3250 */
/* U+ABB3 */	0x5955	/*                                         <CJK> */,/* 3251 */
/* U+ABB4 */	0x5951	/*                                         <CJK> */,/* 3252 */
/* U+ABB5 */	0x594F	/*                                         <CJK> */,/* 3253 */
/* U+ABB6 */	0x594E	/*                                         <CJK> */,/* 3254 */
/* U+ABB7 */	0x5950	/*                                         <CJK> */,/* 3255 */
/* U+ABB8 */	0x59DC	/*                                         <CJK> */,/* 3256 */
/* U+ABB9 */	0x59D8	/*                                         <CJK> */,/* 3257 */
/* U+ABBA */	0x59FF	/*                                         <CJK> */,/* 3258 */
/* U+ABBB */	0x59E3	/*                                         <CJK> */,/* 3259 */
/* U+ABBC */	0x59E8	/*                                         <CJK> */,/* 3260 */
/* U+ABBD */	0x5A03	/*                                         <CJK> */,/* 3261 */
/* U+ABBE */	0x59E5	/*                                         <CJK> */,/* 3262 */
/* U+ABBF */	0x59EA	/*                                         <CJK> */,/* 3263 */
/* U+ABC0 */	0x59DA	/*                                         <CJK> */,/* 3264 */
/* U+ABC1 */	0x59E6	/*                                         <CJK> */,/* 3265 */
/* U+ABC2 */	0x5A01	/*                                         <CJK> */,/* 3266 */
/* U+ABC3 */	0x59FB	/*                                         <CJK> */,/* 3267 */
/* U+ABC4 */	0x5B69	/*                                         <CJK> */,/* 3268 */
/* U+ABC5 */	0x5BA3	/*                                         <CJK> */,/* 3269 */
/* U+ABC6 */	0x5BA6	/*                                         <CJK> */,/* 3270 */
/* U+ABC7 */	0x5BA4	/*                                         <CJK> */,/* 3271 */
/* U+ABC8 */	0x5BA2	/*                                         <CJK> */,/* 3272 */
/* U+ABC9 */	0x5BA5	/*                                         <CJK> */,/* 3273 */
/* U+ABCA */	0x5C01	/*                                         <CJK> */,/* 3274 */
/* U+ABCB */	0x5C4E	/*                                         <CJK> */,/* 3275 */
/* U+ABCC */	0x5C4F	/*                                         <CJK> */,/* 3276 */
/* U+ABCD */	0x5C4D	/*                                         <CJK> */,/* 3277 */
/* U+ABCE */	0x5C4B	/*                                         <CJK> */,/* 3278 */
/* U+ABCF */	0x5CD9	/*                                         <CJK> */,/* 3279 */
/* U+ABD0 */	0x5CD2	/*                                         <CJK> */,/* 3280 */
/* U+ABD1 */	0x5DF7	/*                                         <CJK> */,/* 3281 */
/* U+ABD2 */	0x5E1D	/*                                         <CJK> */,/* 3282 */
/* U+ABD3 */	0x5E25	/*                                         <CJK> */,/* 3283 */
/* U+ABD4 */	0x5E1F	/*                                         <CJK> */,/* 3284 */
/* U+ABD5 */	0x5E7D	/*                                         <CJK> */,/* 3285 */
/* U+ABD6 */	0x5EA0	/*                                         <CJK> */,/* 3286 */
/* U+ABD7 */	0x5EA6	/*                                         <CJK> */,/* 3287 */
/* U+ABD8 */	0x5EFA	/*                                         <CJK> */,/* 3288 */
/* U+ABD9 */	0x5F08	/*                                         <CJK> */,/* 3289 */
/* U+ABDA */	0x5F2D	/*                                         <CJK> */,/* 3290 */
/* U+ABDB */	0x5F65	/*                                         <CJK> */,/* 3291 */
/* U+ABDC */	0x5F88	/*                                         <CJK> */,/* 3292 */
/* U+ABDD */	0x5F85	/*                                         <CJK> */,/* 3293 */
/* U+ABDE */	0x5F8A	/*                                         <CJK> */,/* 3294 */
/* U+ABDF */	0x5F8B	/*                                         <CJK> */,/* 3295 */
/* U+ABE0 */	0x5F87	/*                                         <CJK> */,/* 3296 */
/* U+ABE1 */	0x5F8C	/*                                         <CJK> */,/* 3297 */
/* U+ABE2 */	0x5F89	/*                                         <CJK> */,/* 3298 */
/* U+ABE3 */	0x6012	/*                                         <CJK> */,/* 3299 */
/* U+ABE4 */	0x601D	/*                                         <CJK> */,/* 3300 */
/* U+ABE5 */	0x6020	/*                                         <CJK> */,/* 3301 */
/* U+ABE6 */	0x6025	/*                                         <CJK> */,/* 3302 */
/* U+ABE7 */	0x600E	/*                                         <CJK> */,/* 3303 */
/* U+ABE8 */	0x6028	/*                                         <CJK> */,/* 3304 */
/* U+ABE9 */	0x604D	/*                                         <CJK> */,/* 3305 */
/* U+ABEA */	0x6070	/*                                         <CJK> */,/* 3306 */
/* U+ABEB */	0x6068	/*                                         <CJK> */,/* 3307 */
/* U+ABEC */	0x6062	/*                                         <CJK> */,/* 3308 */
/* U+ABED */	0x6046	/*                                         <CJK> */,/* 3309 */
/* U+ABEE */	0x6043	/*                                         <CJK> */,/* 3310 */
/* U+ABEF */	0x606C	/*                                         <CJK> */,/* 3311 */
/* U+ABF0 */	0x606B	/*                                         <CJK> */,/* 3312 */
/* U+ABF1 */	0x606A	/*                                         <CJK> */,/* 3313 */
/* U+ABF2 */	0x6064	/*                                         <CJK> */,/* 3314 */
/* U+ABF3 */	0x6241	/*                                         <CJK> */,/* 3315 */
/* U+ABF4 */	0x62DC	/*                                         <CJK> */,/* 3316 */
/* U+ABF5 */	0x6316	/*                                         <CJK> */,/* 3317 */
/* U+ABF6 */	0x6309	/*                                         <CJK> */,/* 3318 */
/* U+ABF7 */	0x62FC	/*                                         <CJK> */,/* 3319 */
/* U+ABF8 */	0x62ED	/*                                         <CJK> */,/* 3320 */
/* U+ABF9 */	0x6301	/*                                         <CJK> */,/* 3321 */
/* U+ABFA */	0x62EE	/*                                         <CJK> */,/* 3322 */
/* U+ABFB */	0x62FD	/*                                         <CJK> */,/* 3323 */
/* U+ABFC */	0x6307	/*                                         <CJK> */,/* 3324 */
/* U+ABFD */	0x62F1	/*                                         <CJK> */,/* 3325 */
/* U+ABFE */	0x62F7	/*                                         <CJK> */,/* 3326 */
/* U+ABFF */	UNICODE_REPLACEMENT_CHARACTER,	/* 3327 */
/* U+AC00 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3328 */
/* U+AC01 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3329 */
/* U+AC02 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3330 */
/* U+AC03 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3331 */
/* U+AC04 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3332 */
/* U+AC05 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3333 */
/* U+AC06 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3334 */
/* U+AC07 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3335 */
/* U+AC08 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3336 */
/* U+AC09 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3337 */
/* U+AC0A */	UNICODE_REPLACEMENT_CHARACTER,	/* 3338 */
/* U+AC0B */	UNICODE_REPLACEMENT_CHARACTER,	/* 3339 */
/* U+AC0C */	UNICODE_REPLACEMENT_CHARACTER,	/* 3340 */
/* U+AC0D */	UNICODE_REPLACEMENT_CHARACTER,	/* 3341 */
/* U+AC0E */	UNICODE_REPLACEMENT_CHARACTER,	/* 3342 */
/* U+AC0F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3343 */
/* U+AC10 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3344 */
/* U+AC11 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3345 */
/* U+AC12 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3346 */
/* U+AC13 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3347 */
/* U+AC14 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3348 */
/* U+AC15 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3349 */
/* U+AC16 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3350 */
/* U+AC17 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3351 */
/* U+AC18 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3352 */
/* U+AC19 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3353 */
/* U+AC1A */	UNICODE_REPLACEMENT_CHARACTER,	/* 3354 */
/* U+AC1B */	UNICODE_REPLACEMENT_CHARACTER,	/* 3355 */
/* U+AC1C */	UNICODE_REPLACEMENT_CHARACTER,	/* 3356 */
/* U+AC1D */	UNICODE_REPLACEMENT_CHARACTER,	/* 3357 */
/* U+AC1E */	UNICODE_REPLACEMENT_CHARACTER,	/* 3358 */
/* U+AC1F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3359 */
/* U+AC20 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3360 */
/* U+AC21 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3361 */
/* U+AC22 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3362 */
/* U+AC23 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3363 */
/* U+AC24 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3364 */
/* U+AC25 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3365 */
/* U+AC26 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3366 */
/* U+AC27 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3367 */
/* U+AC28 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3368 */
/* U+AC29 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3369 */
/* U+AC2A */	UNICODE_REPLACEMENT_CHARACTER,	/* 3370 */
/* U+AC2B */	UNICODE_REPLACEMENT_CHARACTER,	/* 3371 */
/* U+AC2C */	UNICODE_REPLACEMENT_CHARACTER,	/* 3372 */
/* U+AC2D */	UNICODE_REPLACEMENT_CHARACTER,	/* 3373 */
/* U+AC2E */	UNICODE_REPLACEMENT_CHARACTER,	/* 3374 */
/* U+AC2F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3375 */
/* U+AC30 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3376 */
/* U+AC31 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3377 */
/* U+AC32 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3378 */
/* U+AC33 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3379 */
/* U+AC34 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3380 */
/* U+AC35 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3381 */
/* U+AC36 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3382 */
/* U+AC37 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3383 */
/* U+AC38 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3384 */
/* U+AC39 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3385 */
/* U+AC3A */	UNICODE_REPLACEMENT_CHARACTER,	/* 3386 */
/* U+AC3B */	UNICODE_REPLACEMENT_CHARACTER,	/* 3387 */
/* U+AC3C */	UNICODE_REPLACEMENT_CHARACTER,	/* 3388 */
/* U+AC3D */	UNICODE_REPLACEMENT_CHARACTER,	/* 3389 */
/* U+AC3E */	UNICODE_REPLACEMENT_CHARACTER,	/* 3390 */
/* U+AC3F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3391 */
/* U+AC40 */	0x62EF	/*                                         <CJK> */,/* 3392 */
/* U+AC41 */	0x62EC	/*                                         <CJK> */,/* 3393 */
/* U+AC42 */	0x62FE	/*                                         <CJK> */,/* 3394 */
/* U+AC43 */	0x62F4	/*                                         <CJK> */,/* 3395 */
/* U+AC44 */	0x6311	/*                                         <CJK> */,/* 3396 */
/* U+AC45 */	0x6302	/*                                         <CJK> */,/* 3397 */
/* U+AC46 */	0x653F	/*                                         <CJK> */,/* 3398 */
/* U+AC47 */	0x6545	/*                                         <CJK> */,/* 3399 */
/* U+AC48 */	0x65AB	/*                                         <CJK> */,/* 3400 */
/* U+AC49 */	0x65BD	/*                                         <CJK> */,/* 3401 */
/* U+AC4A */	0x65E2	/*                                         <CJK> */,/* 3402 */
/* U+AC4B */	0x6625	/*                                         <CJK> */,/* 3403 */
/* U+AC4C */	0x662D	/*                                         <CJK> */,/* 3404 */
/* U+AC4D */	0x6620	/*                                         <CJK> */,/* 3405 */
/* U+AC4E */	0x6627	/*                                         <CJK> */,/* 3406 */
/* U+AC4F */	0x662F	/*                                         <CJK> */,/* 3407 */
/* U+AC50 */	0x661F	/*                                         <CJK> */,/* 3408 */
/* U+AC51 */	0x6628	/*                                         <CJK> */,/* 3409 */
/* U+AC52 */	0x6631	/*                                         <CJK> */,/* 3410 */
/* U+AC53 */	0x6624	/*                                         <CJK> */,/* 3411 */
/* U+AC54 */	0x66F7	/*                                         <CJK> */,/* 3412 */
/* U+AC55 */	0x67FF	/*                                         <CJK> */,/* 3413 */
/* U+AC56 */	0x67D3	/*                                         <CJK> */,/* 3414 */
/* U+AC57 */	0x67F1	/*                                         <CJK> */,/* 3415 */
/* U+AC58 */	0x67D4	/*                                         <CJK> */,/* 3416 */
/* U+AC59 */	0x67D0	/*                                         <CJK> */,/* 3417 */
/* U+AC5A */	0x67EC	/*                                         <CJK> */,/* 3418 */
/* U+AC5B */	0x67B6	/*                                         <CJK> */,/* 3419 */
/* U+AC5C */	0x67AF	/*                                         <CJK> */,/* 3420 */
/* U+AC5D */	0x67F5	/*                                         <CJK> */,/* 3421 */
/* U+AC5E */	0x67E9	/*                                         <CJK> */,/* 3422 */
/* U+AC5F */	0x67EF	/*                                         <CJK> */,/* 3423 */
/* U+AC60 */	0x67C4	/*                                         <CJK> */,/* 3424 */
/* U+AC61 */	0x67D1	/*                                         <CJK> */,/* 3425 */
/* U+AC62 */	0x67B4	/*                                         <CJK> */,/* 3426 */
/* U+AC63 */	0x67DA	/*                                         <CJK> */,/* 3427 */
/* U+AC64 */	0x67E5	/*                                         <CJK> */,/* 3428 */
/* U+AC65 */	0x67B8	/*                                         <CJK> */,/* 3429 */
/* U+AC66 */	0x67CF	/*                                         <CJK> */,/* 3430 */
/* U+AC67 */	0x67DE	/*                                         <CJK> */,/* 3431 */
/* U+AC68 */	0x67F3	/*                                         <CJK> */,/* 3432 */
/* U+AC69 */	0x67B0	/*                                         <CJK> */,/* 3433 */
/* U+AC6A */	0x67D9	/*                                         <CJK> */,/* 3434 */
/* U+AC6B */	0x67E2	/*                                         <CJK> */,/* 3435 */
/* U+AC6C */	0x67DD	/*                                         <CJK> */,/* 3436 */
/* U+AC6D */	0x67D2	/*                                         <CJK> */,/* 3437 */
/* U+AC6E */	0x6B6A	/*                                         <CJK> */,/* 3438 */
/* U+AC6F */	0x6B83	/*                                         <CJK> */,/* 3439 */
/* U+AC70 */	0x6B86	/*                                         <CJK> */,/* 3440 */
/* U+AC71 */	0x6BB5	/*                                         <CJK> */,/* 3441 */
/* U+AC72 */	0x6BD2	/*                                         <CJK> */,/* 3442 */
/* U+AC73 */	0x6BD7	/*                                         <CJK> */,/* 3443 */
/* U+AC74 */	0x6C1F	/*                                         <CJK> */,/* 3444 */
/* U+AC75 */	0x6CC9	/*                                         <CJK> */,/* 3445 */
/* U+AC76 */	0x6D0B	/*                                         <CJK> */,/* 3446 */
/* U+AC77 */	0x6D32	/*                                         <CJK> */,/* 3447 */
/* U+AC78 */	0x6D2A	/*                                         <CJK> */,/* 3448 */
/* U+AC79 */	0x6D41	/*                                         <CJK> */,/* 3449 */
/* U+AC7A */	0x6D25	/*                                         <CJK> */,/* 3450 */
/* U+AC7B */	0x6D0C	/*                                         <CJK> */,/* 3451 */
/* U+AC7C */	0x6D31	/*                                         <CJK> */,/* 3452 */
/* U+AC7D */	0x6D1E	/*                                         <CJK> */,/* 3453 */
/* U+AC7E */	0x6D17	/*                                         <CJK> */,/* 3454 */
/* U+AC7F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3455 */
/* U+AC80 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3456 */
/* U+AC81 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3457 */
/* U+AC82 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3458 */
/* U+AC83 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3459 */
/* U+AC84 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3460 */
/* U+AC85 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3461 */
/* U+AC86 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3462 */
/* U+AC87 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3463 */
/* U+AC88 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3464 */
/* U+AC89 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3465 */
/* U+AC8A */	UNICODE_REPLACEMENT_CHARACTER,	/* 3466 */
/* U+AC8B */	UNICODE_REPLACEMENT_CHARACTER,	/* 3467 */
/* U+AC8C */	UNICODE_REPLACEMENT_CHARACTER,	/* 3468 */
/* U+AC8D */	UNICODE_REPLACEMENT_CHARACTER,	/* 3469 */
/* U+AC8E */	UNICODE_REPLACEMENT_CHARACTER,	/* 3470 */
/* U+AC8F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3471 */
/* U+AC90 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3472 */
/* U+AC91 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3473 */
/* U+AC92 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3474 */
/* U+AC93 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3475 */
/* U+AC94 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3476 */
/* U+AC95 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3477 */
/* U+AC96 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3478 */
/* U+AC97 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3479 */
/* U+AC98 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3480 */
/* U+AC99 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3481 */
/* U+AC9A */	UNICODE_REPLACEMENT_CHARACTER,	/* 3482 */
/* U+AC9B */	UNICODE_REPLACEMENT_CHARACTER,	/* 3483 */
/* U+AC9C */	UNICODE_REPLACEMENT_CHARACTER,	/* 3484 */
/* U+AC9D */	UNICODE_REPLACEMENT_CHARACTER,	/* 3485 */
/* U+AC9E */	UNICODE_REPLACEMENT_CHARACTER,	/* 3486 */
/* U+AC9F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3487 */
/* U+ACA0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3488 */
/* U+ACA1 */	0x6D3B	/*                                         <CJK> */,/* 3489 */
/* U+ACA2 */	0x6D3D	/*                                         <CJK> */,/* 3490 */
/* U+ACA3 */	0x6D3E	/*                                         <CJK> */,/* 3491 */
/* U+ACA4 */	0x6D36	/*                                         <CJK> */,/* 3492 */
/* U+ACA5 */	0x6D1B	/*                                         <CJK> */,/* 3493 */
/* U+ACA6 */	0x6CF5	/*                                         <CJK> */,/* 3494 */
/* U+ACA7 */	0x6D39	/*                                         <CJK> */,/* 3495 */
/* U+ACA8 */	0x6D27	/*                                         <CJK> */,/* 3496 */
/* U+ACA9 */	0x6D38	/*                                         <CJK> */,/* 3497 */
/* U+ACAA */	0x6D29	/*                                         <CJK> */,/* 3498 */
/* U+ACAB */	0x6D2E	/*                                         <CJK> */,/* 3499 */
/* U+ACAC */	0x6D35	/*                                         <CJK> */,/* 3500 */
/* U+ACAD */	0x6D0E	/*                                         <CJK> */,/* 3501 */
/* U+ACAE */	0x6D2B	/*                                         <CJK> */,/* 3502 */
/* U+ACAF */	0x70AB	/*                                         <CJK> */,/* 3503 */
/* U+ACB0 */	0x70BA	/*                                         <CJK> */,/* 3504 */
/* U+ACB1 */	0x70B3	/*                                         <CJK> */,/* 3505 */
/* U+ACB2 */	0x70AC	/*                                         <CJK> */,/* 3506 */
/* U+ACB3 */	0x70AF	/*                                         <CJK> */,/* 3507 */
/* U+ACB4 */	0x70AD	/*                                         <CJK> */,/* 3508 */
/* U+ACB5 */	0x70B8	/*                                         <CJK> */,/* 3509 */
/* U+ACB6 */	0x70AE	/*                                         <CJK> */,/* 3510 */
/* U+ACB7 */	0x70A4	/*                                         <CJK> */,/* 3511 */
/* U+ACB8 */	0x7230	/*                                         <CJK> */,/* 3512 */
/* U+ACB9 */	0x7272	/*                                         <CJK> */,/* 3513 */
/* U+ACBA */	0x726F	/*                                         <CJK> */,/* 3514 */
/* U+ACBB */	0x7274	/*                                         <CJK> */,/* 3515 */
/* U+ACBC */	0x72E9	/*                                         <CJK> */,/* 3516 */
/* U+ACBD */	0x72E0	/*                                         <CJK> */,/* 3517 */
/* U+ACBE */	0x72E1	/*                                         <CJK> */,/* 3518 */
/* U+ACBF */	0x73B7	/*                                         <CJK> */,/* 3519 */
/* U+ACC0 */	0x73CA	/*                                         <CJK> */,/* 3520 */
/* U+ACC1 */	0x73BB	/*                                         <CJK> */,/* 3521 */
/* U+ACC2 */	0x73B2	/*                                         <CJK> */,/* 3522 */
/* U+ACC3 */	0x73CD	/*                                         <CJK> */,/* 3523 */
/* U+ACC4 */	0x73C0	/*                                         <CJK> */,/* 3524 */
/* U+ACC5 */	0x73B3	/*                                         <CJK> */,/* 3525 */
/* U+ACC6 */	0x751A	/*                                         <CJK> */,/* 3526 */
/* U+ACC7 */	0x752D	/*                                         <CJK> */,/* 3527 */
/* U+ACC8 */	0x754F	/*                                         <CJK> */,/* 3528 */
/* U+ACC9 */	0x754C	/*                                         <CJK> */,/* 3529 */
/* U+ACCA */	0x754E	/*                                         <CJK> */,/* 3530 */
/* U+ACCB */	0x754B	/*                                         <CJK> */,/* 3531 */
/* U+ACCC */	0x75AB	/*                                         <CJK> */,/* 3532 */
/* U+ACCD */	0x75A4	/*                                         <CJK> */,/* 3533 */
/* U+ACCE */	0x75A5	/*                                         <CJK> */,/* 3534 */
/* U+ACCF */	0x75A2	/*                                         <CJK> */,/* 3535 */
/* U+ACD0 */	0x75A3	/*                                         <CJK> */,/* 3536 */
/* U+ACD1 */	0x7678	/*                                         <CJK> */,/* 3537 */
/* U+ACD2 */	0x7686	/*                                         <CJK> */,/* 3538 */
/* U+ACD3 */	0x7687	/*                                         <CJK> */,/* 3539 */
/* U+ACD4 */	0x7688	/*                                         <CJK> */,/* 3540 */
/* U+ACD5 */	0x76C8	/*                                         <CJK> */,/* 3541 */
/* U+ACD6 */	0x76C6	/*                                         <CJK> */,/* 3542 */
/* U+ACD7 */	0x76C3	/*                                         <CJK> */,/* 3543 */
/* U+ACD8 */	0x76C5	/*                                         <CJK> */,/* 3544 */
/* U+ACD9 */	0x7701	/*                                         <CJK> */,/* 3545 */
/* U+ACDA */	0x76F9	/*                                         <CJK> */,/* 3546 */
/* U+ACDB */	0x76F8	/*                                         <CJK> */,/* 3547 */
/* U+ACDC */	0x7709	/*                                         <CJK> */,/* 3548 */
/* U+ACDD */	0x770B	/*                                         <CJK> */,/* 3549 */
/* U+ACDE */	0x76FE	/*                                         <CJK> */,/* 3550 */
/* U+ACDF */	0x76FC	/*                                         <CJK> */,/* 3551 */
/* U+ACE0 */	0x7707	/*                                         <CJK> */,/* 3552 */
/* U+ACE1 */	0x77DC	/*                                         <CJK> */,/* 3553 */
/* U+ACE2 */	0x7802	/*                                         <CJK> */,/* 3554 */
/* U+ACE3 */	0x7814	/*                                         <CJK> */,/* 3555 */
/* U+ACE4 */	0x780C	/*                                         <CJK> */,/* 3556 */
/* U+ACE5 */	0x780D	/*                                         <CJK> */,/* 3557 */
/* U+ACE6 */	0x7946	/*                                         <CJK> */,/* 3558 */
/* U+ACE7 */	0x7949	/*                                         <CJK> */,/* 3559 */
/* U+ACE8 */	0x7948	/*                                         <CJK> */,/* 3560 */
/* U+ACE9 */	0x7947	/*                                         <CJK> */,/* 3561 */
/* U+ACEA */	0x79B9	/*                                         <CJK> */,/* 3562 */
/* U+ACEB */	0x79BA	/*                                         <CJK> */,/* 3563 */
/* U+ACEC */	0x79D1	/*                                         <CJK> */,/* 3564 */
/* U+ACED */	0x79D2	/*                                         <CJK> */,/* 3565 */
/* U+ACEE */	0x79CB	/*                                         <CJK> */,/* 3566 */
/* U+ACEF */	0x7A7F	/*                                         <CJK> */,/* 3567 */
/* U+ACF0 */	0x7A81	/*                                         <CJK> */,/* 3568 */
/* U+ACF1 */	0x7AFF	/*                                         <CJK> */,/* 3569 */
/* U+ACF2 */	0x7AFD	/*                                         <CJK> */,/* 3570 */
/* U+ACF3 */	0x7C7D	/*                                         <CJK> */,/* 3571 */
/* U+ACF4 */	0x7D02	/*                                         <CJK> */,/* 3572 */
/* U+ACF5 */	0x7D05	/*                                         <CJK> */,/* 3573 */
/* U+ACF6 */	0x7D00	/*                                         <CJK> */,/* 3574 */
/* U+ACF7 */	0x7D09	/*                                         <CJK> */,/* 3575 */
/* U+ACF8 */	0x7D07	/*                                         <CJK> */,/* 3576 */
/* U+ACF9 */	0x7D04	/*                                         <CJK> */,/* 3577 */
/* U+ACFA */	0x7D06	/*                                         <CJK> */,/* 3578 */
/* U+ACFB */	0x7F38	/*                                         <CJK> */,/* 3579 */
/* U+ACFC */	0x7F8E	/*                                         <CJK> */,/* 3580 */
/* U+ACFD */	0x7FBF	/*                                         <CJK> */,/* 3581 */
/* U+ACFE */	0x8004	/*                                         <CJK> */,/* 3582 */
/* U+ACFF */	UNICODE_REPLACEMENT_CHARACTER,	/* 3583 */
/* U+AD00 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3584 */
/* U+AD01 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3585 */
/* U+AD02 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3586 */
/* U+AD03 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3587 */
/* U+AD04 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3588 */
/* U+AD05 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3589 */
/* U+AD06 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3590 */
/* U+AD07 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3591 */
/* U+AD08 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3592 */
/* U+AD09 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3593 */
/* U+AD0A */	UNICODE_REPLACEMENT_CHARACTER,	/* 3594 */
/* U+AD0B */	UNICODE_REPLACEMENT_CHARACTER,	/* 3595 */
/* U+AD0C */	UNICODE_REPLACEMENT_CHARACTER,	/* 3596 */
/* U+AD0D */	UNICODE_REPLACEMENT_CHARACTER,	/* 3597 */
/* U+AD0E */	UNICODE_REPLACEMENT_CHARACTER,	/* 3598 */
/* U+AD0F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3599 */
/* U+AD10 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3600 */
/* U+AD11 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3601 */
/* U+AD12 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3602 */
/* U+AD13 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3603 */
/* U+AD14 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3604 */
/* U+AD15 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3605 */
/* U+AD16 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3606 */
/* U+AD17 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3607 */
/* U+AD18 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3608 */
/* U+AD19 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3609 */
/* U+AD1A */	UNICODE_REPLACEMENT_CHARACTER,	/* 3610 */
/* U+AD1B */	UNICODE_REPLACEMENT_CHARACTER,	/* 3611 */
/* U+AD1C */	UNICODE_REPLACEMENT_CHARACTER,	/* 3612 */
/* U+AD1D */	UNICODE_REPLACEMENT_CHARACTER,	/* 3613 */
/* U+AD1E */	UNICODE_REPLACEMENT_CHARACTER,	/* 3614 */
/* U+AD1F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3615 */
/* U+AD20 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3616 */
/* U+AD21 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3617 */
/* U+AD22 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3618 */
/* U+AD23 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3619 */
/* U+AD24 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3620 */
/* U+AD25 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3621 */
/* U+AD26 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3622 */
/* U+AD27 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3623 */
/* U+AD28 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3624 */
/* U+AD29 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3625 */
/* U+AD2A */	UNICODE_REPLACEMENT_CHARACTER,	/* 3626 */
/* U+AD2B */	UNICODE_REPLACEMENT_CHARACTER,	/* 3627 */
/* U+AD2C */	UNICODE_REPLACEMENT_CHARACTER,	/* 3628 */
/* U+AD2D */	UNICODE_REPLACEMENT_CHARACTER,	/* 3629 */
/* U+AD2E */	UNICODE_REPLACEMENT_CHARACTER,	/* 3630 */
/* U+AD2F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3631 */
/* U+AD30 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3632 */
/* U+AD31 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3633 */
/* U+AD32 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3634 */
/* U+AD33 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3635 */
/* U+AD34 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3636 */
/* U+AD35 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3637 */
/* U+AD36 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3638 */
/* U+AD37 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3639 */
/* U+AD38 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3640 */
/* U+AD39 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3641 */
/* U+AD3A */	UNICODE_REPLACEMENT_CHARACTER,	/* 3642 */
/* U+AD3B */	UNICODE_REPLACEMENT_CHARACTER,	/* 3643 */
/* U+AD3C */	UNICODE_REPLACEMENT_CHARACTER,	/* 3644 */
/* U+AD3D */	UNICODE_REPLACEMENT_CHARACTER,	/* 3645 */
/* U+AD3E */	UNICODE_REPLACEMENT_CHARACTER,	/* 3646 */
/* U+AD3F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3647 */
/* U+AD40 */	0x8010	/*                                         <CJK> */,/* 3648 */
/* U+AD41 */	0x800D	/*                                         <CJK> */,/* 3649 */
/* U+AD42 */	0x8011	/*                                         <CJK> */,/* 3650 */
/* U+AD43 */	0x8036	/*                                         <CJK> */,/* 3651 */
/* U+AD44 */	0x80D6	/*                                         <CJK> */,/* 3652 */
/* U+AD45 */	0x80E5	/*                                         <CJK> */,/* 3653 */
/* U+AD46 */	0x80DA	/*                                         <CJK> */,/* 3654 */
/* U+AD47 */	0x80C3	/*                                         <CJK> */,/* 3655 */
/* U+AD48 */	0x80C4	/*                                         <CJK> */,/* 3656 */
/* U+AD49 */	0x80CC	/*                                         <CJK> */,/* 3657 */
/* U+AD4A */	0x80E1	/*                                         <CJK> */,/* 3658 */
/* U+AD4B */	0x80DB	/*                                         <CJK> */,/* 3659 */
/* U+AD4C */	0x80CE	/*                                         <CJK> */,/* 3660 */
/* U+AD4D */	0x80DE	/*                                         <CJK> */,/* 3661 */
/* U+AD4E */	0x80E4	/*                                         <CJK> */,/* 3662 */
/* U+AD4F */	0x80DD	/*                                         <CJK> */,/* 3663 */
/* U+AD50 */	0x81F4	/*                                         <CJK> */,/* 3664 */
/* U+AD51 */	0x8222	/*                                         <CJK> */,/* 3665 */
/* U+AD52 */	0x82E7	/*                                         <CJK> */,/* 3666 */
/* U+AD53 */	0x8303	/*                                         <CJK> */,/* 3667 */
/* U+AD54 */	0x8305	/*                                         <CJK> */,/* 3668 */
/* U+AD55 */	0x82E3	/*                                         <CJK> */,/* 3669 */
/* U+AD56 */	0x82DB	/*                                         <CJK> */,/* 3670 */
/* U+AD57 */	0x82E6	/*                                         <CJK> */,/* 3671 */
/* U+AD58 */	0x8304	/*                                         <CJK> */,/* 3672 */
/* U+AD59 */	0x82E5	/*                                         <CJK> */,/* 3673 */
/* U+AD5A */	0x8302	/*                                         <CJK> */,/* 3674 */
/* U+AD5B */	0x8309	/*                                         <CJK> */,/* 3675 */
/* U+AD5C */	0x82D2	/*                                         <CJK> */,/* 3676 */
/* U+AD5D */	0x82D7	/*                                         <CJK> */,/* 3677 */
/* U+AD5E */	0x82F1	/*                                         <CJK> */,/* 3678 */
/* U+AD5F */	0x8301	/*                                         <CJK> */,/* 3679 */
/* U+AD60 */	0x82DC	/*                                         <CJK> */,/* 3680 */
/* U+AD61 */	0x82D4	/*                                         <CJK> */,/* 3681 */
/* U+AD62 */	0x82D1	/*                                         <CJK> */,/* 3682 */
/* U+AD63 */	0x82DE	/*                                         <CJK> */,/* 3683 */
/* U+AD64 */	0x82D3	/*                                         <CJK> */,/* 3684 */
/* U+AD65 */	0x82DF	/*                                         <CJK> */,/* 3685 */
/* U+AD66 */	0x82EF	/*                                         <CJK> */,/* 3686 */
/* U+AD67 */	0x8306	/*                                         <CJK> */,/* 3687 */
/* U+AD68 */	0x8650	/*                                         <CJK> */,/* 3688 */
/* U+AD69 */	0x8679	/*                                         <CJK> */,/* 3689 */
/* U+AD6A */	0x867B	/*                                         <CJK> */,/* 3690 */
/* U+AD6B */	0x867A	/*                                         <CJK> */,/* 3691 */
/* U+AD6C */	0x884D	/*                                         <CJK> */,/* 3692 */
/* U+AD6D */	0x886B	/*                                         <CJK> */,/* 3693 */
/* U+AD6E */	0x8981	/*                                         <CJK> */,/* 3694 */
/* U+AD6F */	0x89D4	/*                                         <CJK> */,/* 3695 */
/* U+AD70 */	0x8A08	/*                                         <CJK> */,/* 3696 */
/* U+AD71 */	0x8A02	/*                                         <CJK> */,/* 3697 */
/* U+AD72 */	0x8A03	/*                                         <CJK> */,/* 3698 */
/* U+AD73 */	0x8C9E	/*                                         <CJK> */,/* 3699 */
/* U+AD74 */	0x8CA0	/*                                         <CJK> */,/* 3700 */
/* U+AD75 */	0x8D74	/*                                         <CJK> */,/* 3701 */
/* U+AD76 */	0x8D73	/*                                         <CJK> */,/* 3702 */
/* U+AD77 */	0x8DB4	/*                                         <CJK> */,/* 3703 */
/* U+AD78 */	0x8ECD	/*                                         <CJK> */,/* 3704 */
/* U+AD79 */	0x8ECC	/*                                         <CJK> */,/* 3705 */
/* U+AD7A */	0x8FF0	/*                                         <CJK> */,/* 3706 */
/* U+AD7B */	0x8FE6	/*                                         <CJK> */,/* 3707 */
/* U+AD7C */	0x8FE2	/*                                         <CJK> */,/* 3708 */
/* U+AD7D */	0x8FEA	/*                                         <CJK> */,/* 3709 */
/* U+AD7E */	0x8FE5	/*                                         <CJK> */,/* 3710 */
/* U+AD7F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3711 */
/* U+AD80 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3712 */
/* U+AD81 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3713 */
/* U+AD82 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3714 */
/* U+AD83 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3715 */
/* U+AD84 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3716 */
/* U+AD85 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3717 */
/* U+AD86 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3718 */
/* U+AD87 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3719 */
/* U+AD88 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3720 */
/* U+AD89 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3721 */
/* U+AD8A */	UNICODE_REPLACEMENT_CHARACTER,	/* 3722 */
/* U+AD8B */	UNICODE_REPLACEMENT_CHARACTER,	/* 3723 */
/* U+AD8C */	UNICODE_REPLACEMENT_CHARACTER,	/* 3724 */
/* U+AD8D */	UNICODE_REPLACEMENT_CHARACTER,	/* 3725 */
/* U+AD8E */	UNICODE_REPLACEMENT_CHARACTER,	/* 3726 */
/* U+AD8F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3727 */
/* U+AD90 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3728 */
/* U+AD91 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3729 */
/* U+AD92 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3730 */
/* U+AD93 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3731 */
/* U+AD94 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3732 */
/* U+AD95 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3733 */
/* U+AD96 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3734 */
/* U+AD97 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3735 */
/* U+AD98 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3736 */
/* U+AD99 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3737 */
/* U+AD9A */	UNICODE_REPLACEMENT_CHARACTER,	/* 3738 */
/* U+AD9B */	UNICODE_REPLACEMENT_CHARACTER,	/* 3739 */
/* U+AD9C */	UNICODE_REPLACEMENT_CHARACTER,	/* 3740 */
/* U+AD9D */	UNICODE_REPLACEMENT_CHARACTER,	/* 3741 */
/* U+AD9E */	UNICODE_REPLACEMENT_CHARACTER,	/* 3742 */
/* U+AD9F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3743 */
/* U+ADA0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3744 */
/* U+ADA1 */	0x8FED	/*                                         <CJK> */,/* 3745 */
/* U+ADA2 */	0x8FEB	/*                                         <CJK> */,/* 3746 */
/* U+ADA3 */	0x8FE4	/*                                         <CJK> */,/* 3747 */
/* U+ADA4 */	0x8FE8	/*                                         <CJK> */,/* 3748 */
/* U+ADA5 */	0x90CA	/*                                         <CJK> */,/* 3749 */
/* U+ADA6 */	0x90CE	/*                                         <CJK> */,/* 3750 */
/* U+ADA7 */	0x90C1	/*                                         <CJK> */,/* 3751 */
/* U+ADA8 */	0x90C3	/*                                         <CJK> */,/* 3752 */
/* U+ADA9 */	0x914B	/*                                         <CJK> */,/* 3753 */
/* U+ADAA */	0x914A	/*                                         <CJK> */,/* 3754 */
/* U+ADAB */	0x91CD	/*                                         <CJK> */,/* 3755 */
/* U+ADAC */	0x9582	/*                                         <CJK> */,/* 3756 */
/* U+ADAD */	0x9650	/*                                         <CJK> */,/* 3757 */
/* U+ADAE */	0x964B	/*                                         <CJK> */,/* 3758 */
/* U+ADAF */	0x964C	/*                                         <CJK> */,/* 3759 */
/* U+ADB0 */	0x964D	/*                                         <CJK> */,/* 3760 */
/* U+ADB1 */	0x9762	/*                                         <CJK> */,/* 3761 */
/* U+ADB2 */	0x9769	/*                                         <CJK> */,/* 3762 */
/* U+ADB3 */	0x97CB	/*                                         <CJK> */,/* 3763 */
/* U+ADB4 */	0x97ED	/*                                         <CJK> */,/* 3764 */
/* U+ADB5 */	0x97F3	/*                                         <CJK> */,/* 3765 */
/* U+ADB6 */	0x9801	/*                                         <CJK> */,/* 3766 */
/* U+ADB7 */	0x98A8	/*                                         <CJK> */,/* 3767 */
/* U+ADB8 */	0x98DB	/*                                         <CJK> */,/* 3768 */
/* U+ADB9 */	0x98DF	/*                                         <CJK> */,/* 3769 */
/* U+ADBA */	0x9996	/*                                         <CJK> */,/* 3770 */
/* U+ADBB */	0x9999	/*                                         <CJK> */,/* 3771 */
/* U+ADBC */	0x4E58	/*                                         <CJK> */,/* 3772 */
/* U+ADBD */	0x4EB3	/*                                         <CJK> */,/* 3773 */
/* U+ADBE */	0x500C	/*                                         <CJK> */,/* 3774 */
/* U+ADBF */	0x500D	/*                                         <CJK> */,/* 3775 */
/* U+ADC0 */	0x5023	/*                                         <CJK> */,/* 3776 */
/* U+ADC1 */	0x4FEF	/*                                         <CJK> */,/* 3777 */
/* U+ADC2 */	0x5026	/*                                         <CJK> */,/* 3778 */
/* U+ADC3 */	0x5025	/*                                         <CJK> */,/* 3779 */
/* U+ADC4 */	0x4FF8	/*                                         <CJK> */,/* 3780 */
/* U+ADC5 */	0x5029	/*                                         <CJK> */,/* 3781 */
/* U+ADC6 */	0x5016	/*                                         <CJK> */,/* 3782 */
/* U+ADC7 */	0x5006	/*                                         <CJK> */,/* 3783 */
/* U+ADC8 */	0x503C	/*                                         <CJK> */,/* 3784 */
/* U+ADC9 */	0x501F	/*                                         <CJK> */,/* 3785 */
/* U+ADCA */	0x501A	/*                                         <CJK> */,/* 3786 */
/* U+ADCB */	0x5012	/*                                         <CJK> */,/* 3787 */
/* U+ADCC */	0x5011	/*                                         <CJK> */,/* 3788 */
/* U+ADCD */	0x4FFA	/*                                         <CJK> */,/* 3789 */
/* U+ADCE */	0x5000	/*                                         <CJK> */,/* 3790 */
/* U+ADCF */	0x5014	/*                                         <CJK> */,/* 3791 */
/* U+ADD0 */	0x5028	/*                                         <CJK> */,/* 3792 */
/* U+ADD1 */	0x4FF1	/*                                         <CJK> */,/* 3793 */
/* U+ADD2 */	0x5021	/*                                         <CJK> */,/* 3794 */
/* U+ADD3 */	0x500B	/*                                         <CJK> */,/* 3795 */
/* U+ADD4 */	0x5019	/*                                         <CJK> */,/* 3796 */
/* U+ADD5 */	0x5018	/*                                         <CJK> */,/* 3797 */
/* U+ADD6 */	0x4FF3	/*                                         <CJK> */,/* 3798 */
/* U+ADD7 */	0x4FEE	/*                                         <CJK> */,/* 3799 */
/* U+ADD8 */	0x502D	/*                                         <CJK> */,/* 3800 */
/* U+ADD9 */	0x502A	/*                                         <CJK> */,/* 3801 */
/* U+ADDA */	0x4FFE	/*                                         <CJK> */,/* 3802 */
/* U+ADDB */	0x502B	/*                                         <CJK> */,/* 3803 */
/* U+ADDC */	0x5009	/*                                         <CJK> */,/* 3804 */
/* U+ADDD */	0x517C	/*                                         <CJK> */,/* 3805 */
/* U+ADDE */	0x51A4	/*                                         <CJK> */,/* 3806 */
/* U+ADDF */	0x51A5	/*                                         <CJK> */,/* 3807 */
/* U+ADE0 */	0x51A2	/*                                         <CJK> */,/* 3808 */
/* U+ADE1 */	0x51CD	/*                                         <CJK> */,/* 3809 */
/* U+ADE2 */	0x51CC	/*                                         <CJK> */,/* 3810 */
/* U+ADE3 */	0x51C6	/*                                         <CJK> */,/* 3811 */
/* U+ADE4 */	0x51CB	/*                                         <CJK> */,/* 3812 */
/* U+ADE5 */	0x5256	/*                                         <CJK> */,/* 3813 */
/* U+ADE6 */	0x525C	/*                                         <CJK> */,/* 3814 */
/* U+ADE7 */	0x5254	/*                                         <CJK> */,/* 3815 */
/* U+ADE8 */	0x525B	/*                                         <CJK> */,/* 3816 */
/* U+ADE9 */	0x525D	/*                                         <CJK> */,/* 3817 */
/* U+ADEA */	0x532A	/*                                         <CJK> */,/* 3818 */
/* U+ADEB */	0x537F	/*                                         <CJK> */,/* 3819 */
/* U+ADEC */	0x539F	/*                                         <CJK> */,/* 3820 */
/* U+ADED */	0x539D	/*                                         <CJK> */,/* 3821 */
/* U+ADEE */	0x53DF	/*                                         <CJK> */,/* 3822 */
/* U+ADEF */	0x54E8	/*                                         <CJK> */,/* 3823 */
/* U+ADF0 */	0x5510	/*                                         <CJK> */,/* 3824 */
/* U+ADF1 */	0x5501	/*                                         <CJK> */,/* 3825 */
/* U+ADF2 */	0x5537	/*                                         <CJK> */,/* 3826 */
/* U+ADF3 */	0x54FC	/*                                         <CJK> */,/* 3827 */
/* U+ADF4 */	0x54E5	/*                                         <CJK> */,/* 3828 */
/* U+ADF5 */	0x54F2	/*                                         <CJK> */,/* 3829 */
/* U+ADF6 */	0x5506	/*                                         <CJK> */,/* 3830 */
/* U+ADF7 */	0x54FA	/*                                         <CJK> */,/* 3831 */
/* U+ADF8 */	0x5514	/*                                         <CJK> */,/* 3832 */
/* U+ADF9 */	0x54E9	/*                                         <CJK> */,/* 3833 */
/* U+ADFA */	0x54ED	/*                                         <CJK> */,/* 3834 */
/* U+ADFB */	0x54E1	/*                                         <CJK> */,/* 3835 */
/* U+ADFC */	0x5509	/*                                         <CJK> */,/* 3836 */
/* U+ADFD */	0x54EE	/*                                         <CJK> */,/* 3837 */
/* U+ADFE */	0x54EA	/*                                         <CJK> */,/* 3838 */
/* U+ADFF */	UNICODE_REPLACEMENT_CHARACTER,	/* 3839 */
/* U+AE00 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3840 */
/* U+AE01 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3841 */
/* U+AE02 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3842 */
/* U+AE03 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3843 */
/* U+AE04 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3844 */
/* U+AE05 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3845 */
/* U+AE06 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3846 */
/* U+AE07 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3847 */
/* U+AE08 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3848 */
/* U+AE09 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3849 */
/* U+AE0A */	UNICODE_REPLACEMENT_CHARACTER,	/* 3850 */
/* U+AE0B */	UNICODE_REPLACEMENT_CHARACTER,	/* 3851 */
/* U+AE0C */	UNICODE_REPLACEMENT_CHARACTER,	/* 3852 */
/* U+AE0D */	UNICODE_REPLACEMENT_CHARACTER,	/* 3853 */
/* U+AE0E */	UNICODE_REPLACEMENT_CHARACTER,	/* 3854 */
/* U+AE0F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3855 */
/* U+AE10 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3856 */
/* U+AE11 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3857 */
/* U+AE12 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3858 */
/* U+AE13 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3859 */
/* U+AE14 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3860 */
/* U+AE15 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3861 */
/* U+AE16 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3862 */
/* U+AE17 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3863 */
/* U+AE18 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3864 */
/* U+AE19 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3865 */
/* U+AE1A */	UNICODE_REPLACEMENT_CHARACTER,	/* 3866 */
/* U+AE1B */	UNICODE_REPLACEMENT_CHARACTER,	/* 3867 */
/* U+AE1C */	UNICODE_REPLACEMENT_CHARACTER,	/* 3868 */
/* U+AE1D */	UNICODE_REPLACEMENT_CHARACTER,	/* 3869 */
/* U+AE1E */	UNICODE_REPLACEMENT_CHARACTER,	/* 3870 */
/* U+AE1F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3871 */
/* U+AE20 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3872 */
/* U+AE21 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3873 */
/* U+AE22 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3874 */
/* U+AE23 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3875 */
/* U+AE24 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3876 */
/* U+AE25 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3877 */
/* U+AE26 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3878 */
/* U+AE27 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3879 */
/* U+AE28 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3880 */
/* U+AE29 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3881 */
/* U+AE2A */	UNICODE_REPLACEMENT_CHARACTER,	/* 3882 */
/* U+AE2B */	UNICODE_REPLACEMENT_CHARACTER,	/* 3883 */
/* U+AE2C */	UNICODE_REPLACEMENT_CHARACTER,	/* 3884 */
/* U+AE2D */	UNICODE_REPLACEMENT_CHARACTER,	/* 3885 */
/* U+AE2E */	UNICODE_REPLACEMENT_CHARACTER,	/* 3886 */
/* U+AE2F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3887 */
/* U+AE30 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3888 */
/* U+AE31 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3889 */
/* U+AE32 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3890 */
/* U+AE33 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3891 */
/* U+AE34 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3892 */
/* U+AE35 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3893 */
/* U+AE36 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3894 */
/* U+AE37 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3895 */
/* U+AE38 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3896 */
/* U+AE39 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3897 */
/* U+AE3A */	UNICODE_REPLACEMENT_CHARACTER,	/* 3898 */
/* U+AE3B */	UNICODE_REPLACEMENT_CHARACTER,	/* 3899 */
/* U+AE3C */	UNICODE_REPLACEMENT_CHARACTER,	/* 3900 */
/* U+AE3D */	UNICODE_REPLACEMENT_CHARACTER,	/* 3901 */
/* U+AE3E */	UNICODE_REPLACEMENT_CHARACTER,	/* 3902 */
/* U+AE3F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3903 */
/* U+AE40 */	0x54E6	/*                                         <CJK> */,/* 3904 */
/* U+AE41 */	0x5527	/*                                         <CJK> */,/* 3905 */
/* U+AE42 */	0x5507	/*                                         <CJK> */,/* 3906 */
/* U+AE43 */	0x54FD	/*                                         <CJK> */,/* 3907 */
/* U+AE44 */	0x550F	/*                                         <CJK> */,/* 3908 */
/* U+AE45 */	0x5703	/*                                         <CJK> */,/* 3909 */
/* U+AE46 */	0x5704	/*                                         <CJK> */,/* 3910 */
/* U+AE47 */	0x57C2	/*                                         <CJK> */,/* 3911 */
/* U+AE48 */	0x57D4	/*                                         <CJK> */,/* 3912 */
/* U+AE49 */	0x57CB	/*                                         <CJK> */,/* 3913 */
/* U+AE4A */	0x57C3	/*                                         <CJK> */,/* 3914 */
/* U+AE4B */	0x5809	/*                                         <CJK> */,/* 3915 */
/* U+AE4C */	0x590F	/*                                         <CJK> */,/* 3916 */
/* U+AE4D */	0x5957	/*                                         <CJK> */,/* 3917 */
/* U+AE4E */	0x5958	/*                                         <CJK> */,/* 3918 */
/* U+AE4F */	0x595A	/*                                         <CJK> */,/* 3919 */
/* U+AE50 */	0x5A11	/*                                         <CJK> */,/* 3920 */
/* U+AE51 */	0x5A18	/*                                         <CJK> */,/* 3921 */
/* U+AE52 */	0x5A1C	/*                                         <CJK> */,/* 3922 */
/* U+AE53 */	0x5A1F	/*                                         <CJK> */,/* 3923 */
/* U+AE54 */	0x5A1B	/*                                         <CJK> */,/* 3924 */
/* U+AE55 */	0x5A13	/*                                         <CJK> */,/* 3925 */
/* U+AE56 */	0x59EC	/*                                         <CJK> */,/* 3926 */
/* U+AE57 */	0x5A20	/*                                         <CJK> */,/* 3927 */
/* U+AE58 */	0x5A23	/*                                         <CJK> */,/* 3928 */
/* U+AE59 */	0x5A29	/*                                         <CJK> */,/* 3929 */
/* U+AE5A */	0x5A25	/*                                         <CJK> */,/* 3930 */
/* U+AE5B */	0x5A0C	/*                                         <CJK> */,/* 3931 */
/* U+AE5C */	0x5A09	/*                                         <CJK> */,/* 3932 */
/* U+AE5D */	0x5B6B	/*                                         <CJK> */,/* 3933 */
/* U+AE5E */	0x5C58	/*                                         <CJK> */,/* 3934 */
/* U+AE5F */	0x5BB0	/*                                         <CJK> */,/* 3935 */
/* U+AE60 */	0x5BB3	/*                                         <CJK> */,/* 3936 */
/* U+AE61 */	0x5BB6	/*                                         <CJK> */,/* 3937 */
/* U+AE62 */	0x5BB4	/*                                         <CJK> */,/* 3938 */
/* U+AE63 */	0x5BAE	/*                                         <CJK> */,/* 3939 */
/* U+AE64 */	0x5BB5	/*                                         <CJK> */,/* 3940 */
/* U+AE65 */	0x5BB9	/*                                         <CJK> */,/* 3941 */
/* U+AE66 */	0x5BB8	/*                                         <CJK> */,/* 3942 */
/* U+AE67 */	0x5C04	/*                                         <CJK> */,/* 3943 */
/* U+AE68 */	0x5C51	/*                                         <CJK> */,/* 3944 */
/* U+AE69 */	0x5C55	/*                                         <CJK> */,/* 3945 */
/* U+AE6A */	0x5C50	/*                                         <CJK> */,/* 3946 */
/* U+AE6B */	0x5CED	/*                                         <CJK> */,/* 3947 */
/* U+AE6C */	0x5CFD	/*                                         <CJK> */,/* 3948 */
/* U+AE6D */	0x5CFB	/*                                         <CJK> */,/* 3949 */
/* U+AE6E */	0x5CEA	/*                                         <CJK> */,/* 3950 */
/* U+AE6F */	0x5CE8	/*                                         <CJK> */,/* 3951 */
/* U+AE70 */	0x5CF0	/*                                         <CJK> */,/* 3952 */
/* U+AE71 */	0x5CF6	/*                                         <CJK> */,/* 3953 */
/* U+AE72 */	0x5D01	/*                                         <CJK> */,/* 3954 */
/* U+AE73 */	0x5CF4	/*                                         <CJK> */,/* 3955 */
/* U+AE74 */	0x5DEE	/*                                         <CJK> */,/* 3956 */
/* U+AE75 */	0x5E2D	/*                                         <CJK> */,/* 3957 */
/* U+AE76 */	0x5E2B	/*                                         <CJK> */,/* 3958 */
/* U+AE77 */	0x5EAB	/*                                         <CJK> */,/* 3959 */
/* U+AE78 */	0x5EAD	/*                                         <CJK> */,/* 3960 */
/* U+AE79 */	0x5EA7	/*                                         <CJK> */,/* 3961 */
/* U+AE7A */	0x5F31	/*                                         <CJK> */,/* 3962 */
/* U+AE7B */	0x5F92	/*                                         <CJK> */,/* 3963 */
/* U+AE7C */	0x5F91	/*                                         <CJK> */,/* 3964 */
/* U+AE7D */	0x5F90	/*                                         <CJK> */,/* 3965 */
/* U+AE7E */	0x6059	/*                                         <CJK> */,/* 3966 */
/* U+AE7F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3967 */
/* U+AE80 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3968 */
/* U+AE81 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3969 */
/* U+AE82 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3970 */
/* U+AE83 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3971 */
/* U+AE84 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3972 */
/* U+AE85 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3973 */
/* U+AE86 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3974 */
/* U+AE87 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3975 */
/* U+AE88 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3976 */
/* U+AE89 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3977 */
/* U+AE8A */	UNICODE_REPLACEMENT_CHARACTER,	/* 3978 */
/* U+AE8B */	UNICODE_REPLACEMENT_CHARACTER,	/* 3979 */
/* U+AE8C */	UNICODE_REPLACEMENT_CHARACTER,	/* 3980 */
/* U+AE8D */	UNICODE_REPLACEMENT_CHARACTER,	/* 3981 */
/* U+AE8E */	UNICODE_REPLACEMENT_CHARACTER,	/* 3982 */
/* U+AE8F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3983 */
/* U+AE90 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3984 */
/* U+AE91 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3985 */
/* U+AE92 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3986 */
/* U+AE93 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3987 */
/* U+AE94 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3988 */
/* U+AE95 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3989 */
/* U+AE96 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3990 */
/* U+AE97 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3991 */
/* U+AE98 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3992 */
/* U+AE99 */	UNICODE_REPLACEMENT_CHARACTER,	/* 3993 */
/* U+AE9A */	UNICODE_REPLACEMENT_CHARACTER,	/* 3994 */
/* U+AE9B */	UNICODE_REPLACEMENT_CHARACTER,	/* 3995 */
/* U+AE9C */	UNICODE_REPLACEMENT_CHARACTER,	/* 3996 */
/* U+AE9D */	UNICODE_REPLACEMENT_CHARACTER,	/* 3997 */
/* U+AE9E */	UNICODE_REPLACEMENT_CHARACTER,	/* 3998 */
/* U+AE9F */	UNICODE_REPLACEMENT_CHARACTER,	/* 3999 */
/* U+AEA0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4000 */
/* U+AEA1 */	0x6063	/*                                         <CJK> */,/* 4001 */
/* U+AEA2 */	0x6065	/*                                         <CJK> */,/* 4002 */
/* U+AEA3 */	0x6050	/*                                         <CJK> */,/* 4003 */
/* U+AEA4 */	0x6055	/*                                         <CJK> */,/* 4004 */
/* U+AEA5 */	0x606D	/*                                         <CJK> */,/* 4005 */
/* U+AEA6 */	0x6069	/*                                         <CJK> */,/* 4006 */
/* U+AEA7 */	0x606F	/*                                         <CJK> */,/* 4007 */
/* U+AEA8 */	0x6084	/*                                         <CJK> */,/* 4008 */
/* U+AEA9 */	0x609F	/*                                         <CJK> */,/* 4009 */
/* U+AEAA */	0x609A	/*                                         <CJK> */,/* 4010 */
/* U+AEAB */	0x608D	/*                                         <CJK> */,/* 4011 */
/* U+AEAC */	0x6094	/*                                         <CJK> */,/* 4012 */
/* U+AEAD */	0x608C	/*                                         <CJK> */,/* 4013 */
/* U+AEAE */	0x6085	/*                                         <CJK> */,/* 4014 */
/* U+AEAF */	0x6096	/*                                         <CJK> */,/* 4015 */
/* U+AEB0 */	0x6247	/*                                         <CJK> */,/* 4016 */
/* U+AEB1 */	0x62F3	/*                                         <CJK> */,/* 4017 */
/* U+AEB2 */	0x6308	/*                                         <CJK> */,/* 4018 */
/* U+AEB3 */	0x62FF	/*                                         <CJK> */,/* 4019 */
/* U+AEB4 */	0x634E	/*                                         <CJK> */,/* 4020 */
/* U+AEB5 */	0x633E	/*                                         <CJK> */,/* 4021 */
/* U+AEB6 */	0x632F	/*                                         <CJK> */,/* 4022 */
/* U+AEB7 */	0x6355	/*                                         <CJK> */,/* 4023 */
/* U+AEB8 */	0x6342	/*                                         <CJK> */,/* 4024 */
/* U+AEB9 */	0x6346	/*                                         <CJK> */,/* 4025 */
/* U+AEBA */	0x634F	/*                                         <CJK> */,/* 4026 */
/* U+AEBB */	0x6349	/*                                         <CJK> */,/* 4027 */
/* U+AEBC */	0x633A	/*                                         <CJK> */,/* 4028 */
/* U+AEBD */	0x6350	/*                                         <CJK> */,/* 4029 */
/* U+AEBE */	0x633D	/*                                         <CJK> */,/* 4030 */
/* U+AEBF */	0x632A	/*                                         <CJK> */,/* 4031 */
/* U+AEC0 */	0x632B	/*                                         <CJK> */,/* 4032 */
/* U+AEC1 */	0x6328	/*                                         <CJK> */,/* 4033 */
/* U+AEC2 */	0x634D	/*                                         <CJK> */,/* 4034 */
/* U+AEC3 */	0x634C	/*                                         <CJK> */,/* 4035 */
/* U+AEC4 */	0x6548	/*                                         <CJK> */,/* 4036 */
/* U+AEC5 */	0x6549	/*                                         <CJK> */,/* 4037 */
/* U+AEC6 */	0x6599	/*                                         <CJK> */,/* 4038 */
/* U+AEC7 */	0x65C1	/*                                         <CJK> */,/* 4039 */
/* U+AEC8 */	0x65C5	/*                                         <CJK> */,/* 4040 */
/* U+AEC9 */	0x6642	/*                                         <CJK> */,/* 4041 */
/* U+AECA */	0x6649	/*                                         <CJK> */,/* 4042 */
/* U+AECB */	0x664F	/*                                         <CJK> */,/* 4043 */
/* U+AECC */	0x6643	/*                                         <CJK> */,/* 4044 */
/* U+AECD */	0x6652	/*                                         <CJK> */,/* 4045 */
/* U+AECE */	0x664C	/*                                         <CJK> */,/* 4046 */
/* U+AECF */	0x6645	/*                                         <CJK> */,/* 4047 */
/* U+AED0 */	0x6641	/*                                         <CJK> */,/* 4048 */
/* U+AED1 */	0x66F8	/*                                         <CJK> */,/* 4049 */
/* U+AED2 */	0x6714	/*                                         <CJK> */,/* 4050 */
/* U+AED3 */	0x6715	/*                                         <CJK> */,/* 4051 */
/* U+AED4 */	0x6717	/*                                         <CJK> */,/* 4052 */
/* U+AED5 */	0x6821	/*                                         <CJK> */,/* 4053 */
/* U+AED6 */	0x6838	/*                                         <CJK> */,/* 4054 */
/* U+AED7 */	0x6848	/*                                         <CJK> */,/* 4055 */
/* U+AED8 */	0x6846	/*                                         <CJK> */,/* 4056 */
/* U+AED9 */	0x6853	/*                                         <CJK> */,/* 4057 */
/* U+AEDA */	0x6839	/*                                         <CJK> */,/* 4058 */
/* U+AEDB */	0x6842	/*                                         <CJK> */,/* 4059 */
/* U+AEDC */	0x6854	/*                                         <CJK> */,/* 4060 */
/* U+AEDD */	0x6829	/*                                         <CJK> */,/* 4061 */
/* U+AEDE */	0x68B3	/*                                         <CJK> */,/* 4062 */
/* U+AEDF */	0x6817	/*                                         <CJK> */,/* 4063 */
/* U+AEE0 */	0x684C	/*                                         <CJK> */,/* 4064 */
/* U+AEE1 */	0x6851	/*                                         <CJK> */,/* 4065 */
/* U+AEE2 */	0x683D	/*                                         <CJK> */,/* 4066 */
/* U+AEE3 */	0x67F4	/*                                         <CJK> */,/* 4067 */
/* U+AEE4 */	0x6850	/*                                         <CJK> */,/* 4068 */
/* U+AEE5 */	0x6840	/*                                         <CJK> */,/* 4069 */
/* U+AEE6 */	0x683C	/*                                         <CJK> */,/* 4070 */
/* U+AEE7 */	0x6843	/*                                         <CJK> */,/* 4071 */
/* U+AEE8 */	0x682A	/*                                         <CJK> */,/* 4072 */
/* U+AEE9 */	0x6845	/*                                         <CJK> */,/* 4073 */
/* U+AEEA */	0x6813	/*                                         <CJK> */,/* 4074 */
/* U+AEEB */	0x6818	/*                                         <CJK> */,/* 4075 */
/* U+AEEC */	0x6841	/*                                         <CJK> */,/* 4076 */
/* U+AEED */	0x6B8A	/*                                         <CJK> */,/* 4077 */
/* U+AEEE */	0x6B89	/*                                         <CJK> */,/* 4078 */
/* U+AEEF */	0x6BB7	/*                                         <CJK> */,/* 4079 */
/* U+AEF0 */	0x6C23	/*                                         <CJK> */,/* 4080 */
/* U+AEF1 */	0x6C27	/*                                         <CJK> */,/* 4081 */
/* U+AEF2 */	0x6C28	/*                                         <CJK> */,/* 4082 */
/* U+AEF3 */	0x6C26	/*                                         <CJK> */,/* 4083 */
/* U+AEF4 */	0x6C24	/*                                         <CJK> */,/* 4084 */
/* U+AEF5 */	0x6CF0	/*                                         <CJK> */,/* 4085 */
/* U+AEF6 */	0x6D6A	/*                                         <CJK> */,/* 4086 */
/* U+AEF7 */	0x6D95	/*                                         <CJK> */,/* 4087 */
/* U+AEF8 */	0x6D88	/*                                         <CJK> */,/* 4088 */
/* U+AEF9 */	0x6D87	/*                                         <CJK> */,/* 4089 */
/* U+AEFA */	0x6D66	/*                                         <CJK> */,/* 4090 */
/* U+AEFB */	0x6D78	/*                                         <CJK> */,/* 4091 */
/* U+AEFC */	0x6D77	/*                                         <CJK> */,/* 4092 */
/* U+AEFD */	0x6D59	/*                                         <CJK> */,/* 4093 */
/* U+AEFE */	0x6D93	/*                                         <CJK> */,/* 4094 */
/* U+AEFF */	UNICODE_REPLACEMENT_CHARACTER,	/* 4095 */
/* U+AF00 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4096 */
/* U+AF01 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4097 */
/* U+AF02 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4098 */
/* U+AF03 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4099 */
/* U+AF04 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4100 */
/* U+AF05 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4101 */
/* U+AF06 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4102 */
/* U+AF07 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4103 */
/* U+AF08 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4104 */
/* U+AF09 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4105 */
/* U+AF0A */	UNICODE_REPLACEMENT_CHARACTER,	/* 4106 */
/* U+AF0B */	UNICODE_REPLACEMENT_CHARACTER,	/* 4107 */
/* U+AF0C */	UNICODE_REPLACEMENT_CHARACTER,	/* 4108 */
/* U+AF0D */	UNICODE_REPLACEMENT_CHARACTER,	/* 4109 */
/* U+AF0E */	UNICODE_REPLACEMENT_CHARACTER,	/* 4110 */
/* U+AF0F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4111 */
/* U+AF10 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4112 */
/* U+AF11 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4113 */
/* U+AF12 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4114 */
/* U+AF13 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4115 */
/* U+AF14 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4116 */
/* U+AF15 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4117 */
/* U+AF16 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4118 */
/* U+AF17 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4119 */
/* U+AF18 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4120 */
/* U+AF19 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4121 */
/* U+AF1A */	UNICODE_REPLACEMENT_CHARACTER,	/* 4122 */
/* U+AF1B */	UNICODE_REPLACEMENT_CHARACTER,	/* 4123 */
/* U+AF1C */	UNICODE_REPLACEMENT_CHARACTER,	/* 4124 */
/* U+AF1D */	UNICODE_REPLACEMENT_CHARACTER,	/* 4125 */
/* U+AF1E */	UNICODE_REPLACEMENT_CHARACTER,	/* 4126 */
/* U+AF1F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4127 */
/* U+AF20 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4128 */
/* U+AF21 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4129 */
/* U+AF22 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4130 */
/* U+AF23 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4131 */
/* U+AF24 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4132 */
/* U+AF25 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4133 */
/* U+AF26 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4134 */
/* U+AF27 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4135 */
/* U+AF28 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4136 */
/* U+AF29 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4137 */
/* U+AF2A */	UNICODE_REPLACEMENT_CHARACTER,	/* 4138 */
/* U+AF2B */	UNICODE_REPLACEMENT_CHARACTER,	/* 4139 */
/* U+AF2C */	UNICODE_REPLACEMENT_CHARACTER,	/* 4140 */
/* U+AF2D */	UNICODE_REPLACEMENT_CHARACTER,	/* 4141 */
/* U+AF2E */	UNICODE_REPLACEMENT_CHARACTER,	/* 4142 */
/* U+AF2F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4143 */
/* U+AF30 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4144 */
/* U+AF31 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4145 */
/* U+AF32 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4146 */
/* U+AF33 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4147 */
/* U+AF34 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4148 */
/* U+AF35 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4149 */
/* U+AF36 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4150 */
/* U+AF37 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4151 */
/* U+AF38 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4152 */
/* U+AF39 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4153 */
/* U+AF3A */	UNICODE_REPLACEMENT_CHARACTER,	/* 4154 */
/* U+AF3B */	UNICODE_REPLACEMENT_CHARACTER,	/* 4155 */
/* U+AF3C */	UNICODE_REPLACEMENT_CHARACTER,	/* 4156 */
/* U+AF3D */	UNICODE_REPLACEMENT_CHARACTER,	/* 4157 */
/* U+AF3E */	UNICODE_REPLACEMENT_CHARACTER,	/* 4158 */
/* U+AF3F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4159 */
/* U+AF40 */	0x6D6C	/*                                         <CJK> */,/* 4160 */
/* U+AF41 */	0x6D89	/*                                         <CJK> */,/* 4161 */
/* U+AF42 */	0x6D6E	/*                                         <CJK> */,/* 4162 */
/* U+AF43 */	0x6D5A	/*                                         <CJK> */,/* 4163 */
/* U+AF44 */	0x6D74	/*                                         <CJK> */,/* 4164 */
/* U+AF45 */	0x6D69	/*                                         <CJK> */,/* 4165 */
/* U+AF46 */	0x6D8C	/*                                         <CJK> */,/* 4166 */
/* U+AF47 */	0x6D8A	/*                                         <CJK> */,/* 4167 */
/* U+AF48 */	0x6D79	/*                                         <CJK> */,/* 4168 */
/* U+AF49 */	0x6D85	/*                                         <CJK> */,/* 4169 */
/* U+AF4A */	0x6D65	/*                                         <CJK> */,/* 4170 */
/* U+AF4B */	0x6D94	/*                                         <CJK> */,/* 4171 */
/* U+AF4C */	0x70CA	/*                                         <CJK> */,/* 4172 */
/* U+AF4D */	0x70D8	/*                                         <CJK> */,/* 4173 */
/* U+AF4E */	0x70E4	/*                                         <CJK> */,/* 4174 */
/* U+AF4F */	0x70D9	/*                                         <CJK> */,/* 4175 */
/* U+AF50 */	0x70C8	/*                                         <CJK> */,/* 4176 */
/* U+AF51 */	0x70CF	/*                                         <CJK> */,/* 4177 */
/* U+AF52 */	0x7239	/*                                         <CJK> */,/* 4178 */
/* U+AF53 */	0x7279	/*                                         <CJK> */,/* 4179 */
/* U+AF54 */	0x72FC	/*                                         <CJK> */,/* 4180 */
/* U+AF55 */	0x72F9	/*                                         <CJK> */,/* 4181 */
/* U+AF56 */	0x72FD	/*                                         <CJK> */,/* 4182 */
/* U+AF57 */	0x72F8	/*                                         <CJK> */,/* 4183 */
/* U+AF58 */	0x72F7	/*                                         <CJK> */,/* 4184 */
/* U+AF59 */	0x7386	/*                                         <CJK> */,/* 4185 */
/* U+AF5A */	0x73ED	/*                                         <CJK> */,/* 4186 */
/* U+AF5B */	0x7409	/*                                         <CJK> */,/* 4187 */
/* U+AF5C */	0x73EE	/*                                         <CJK> */,/* 4188 */
/* U+AF5D */	0x73E0	/*                                         <CJK> */,/* 4189 */
/* U+AF5E */	0x73EA	/*                                         <CJK> */,/* 4190 */
/* U+AF5F */	0x73DE	/*                                         <CJK> */,/* 4191 */
/* U+AF60 */	0x7554	/*                                         <CJK> */,/* 4192 */
/* U+AF61 */	0x755D	/*                                         <CJK> */,/* 4193 */
/* U+AF62 */	0x755C	/*                                         <CJK> */,/* 4194 */
/* U+AF63 */	0x755A	/*                                         <CJK> */,/* 4195 */
/* U+AF64 */	0x7559	/*                                         <CJK> */,/* 4196 */
/* U+AF65 */	0x75BE	/*                                         <CJK> */,/* 4197 */
/* U+AF66 */	0x75C5	/*                                         <CJK> */,/* 4198 */
/* U+AF67 */	0x75C7	/*                                         <CJK> */,/* 4199 */
/* U+AF68 */	0x75B2	/*                                         <CJK> */,/* 4200 */
/* U+AF69 */	0x75B3	/*                                         <CJK> */,/* 4201 */
/* U+AF6A */	0x75BD	/*                                         <CJK> */,/* 4202 */
/* U+AF6B */	0x75BC	/*                                         <CJK> */,/* 4203 */
/* U+AF6C */	0x75B9	/*                                         <CJK> */,/* 4204 */
/* U+AF6D */	0x75C2	/*                                         <CJK> */,/* 4205 */
/* U+AF6E */	0x75B8	/*                                         <CJK> */,/* 4206 */
/* U+AF6F */	0x768B	/*                                         <CJK> */,/* 4207 */
/* U+AF70 */	0x76B0	/*                                         <CJK> */,/* 4208 */
/* U+AF71 */	0x76CA	/*                                         <CJK> */,/* 4209 */
/* U+AF72 */	0x76CD	/*                                         <CJK> */,/* 4210 */
/* U+AF73 */	0x76CE	/*                                         <CJK> */,/* 4211 */
/* U+AF74 */	0x7729	/*                                         <CJK> */,/* 4212 */
/* U+AF75 */	0x771F	/*                                         <CJK> */,/* 4213 */
/* U+AF76 */	0x7720	/*                                         <CJK> */,/* 4214 */
/* U+AF77 */	0x7728	/*                                         <CJK> */,/* 4215 */
/* U+AF78 */	0x77E9	/*                                         <CJK> */,/* 4216 */
/* U+AF79 */	0x7830	/*                                         <CJK> */,/* 4217 */
/* U+AF7A */	0x7827	/*                                         <CJK> */,/* 4218 */
/* U+AF7B */	0x7838	/*                                         <CJK> */,/* 4219 */
/* U+AF7C */	0x781D	/*                                         <CJK> */,/* 4220 */
/* U+AF7D */	0x7834	/*                                         <CJK> */,/* 4221 */
/* U+AF7E */	0x7837	/*                                         <CJK> */,/* 4222 */
/* U+AF7F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4223 */
/* U+AF80 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4224 */
/* U+AF81 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4225 */
/* U+AF82 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4226 */
/* U+AF83 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4227 */
/* U+AF84 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4228 */
/* U+AF85 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4229 */
/* U+AF86 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4230 */
/* U+AF87 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4231 */
/* U+AF88 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4232 */
/* U+AF89 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4233 */
/* U+AF8A */	UNICODE_REPLACEMENT_CHARACTER,	/* 4234 */
/* U+AF8B */	UNICODE_REPLACEMENT_CHARACTER,	/* 4235 */
/* U+AF8C */	UNICODE_REPLACEMENT_CHARACTER,	/* 4236 */
/* U+AF8D */	UNICODE_REPLACEMENT_CHARACTER,	/* 4237 */
/* U+AF8E */	UNICODE_REPLACEMENT_CHARACTER,	/* 4238 */
/* U+AF8F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4239 */
/* U+AF90 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4240 */
/* U+AF91 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4241 */
/* U+AF92 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4242 */
/* U+AF93 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4243 */
/* U+AF94 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4244 */
/* U+AF95 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4245 */
/* U+AF96 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4246 */
/* U+AF97 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4247 */
/* U+AF98 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4248 */
/* U+AF99 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4249 */
/* U+AF9A */	UNICODE_REPLACEMENT_CHARACTER,	/* 4250 */
/* U+AF9B */	UNICODE_REPLACEMENT_CHARACTER,	/* 4251 */
/* U+AF9C */	UNICODE_REPLACEMENT_CHARACTER,	/* 4252 */
/* U+AF9D */	UNICODE_REPLACEMENT_CHARACTER,	/* 4253 */
/* U+AF9E */	UNICODE_REPLACEMENT_CHARACTER,	/* 4254 */
/* U+AF9F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4255 */
/* U+AFA0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4256 */
/* U+AFA1 */	0x7825	/*                                         <CJK> */,/* 4257 */
/* U+AFA2 */	0x782D	/*                                         <CJK> */,/* 4258 */
/* U+AFA3 */	0x7820	/*                                         <CJK> */,/* 4259 */
/* U+AFA4 */	0x781F	/*                                         <CJK> */,/* 4260 */
/* U+AFA5 */	0x7832	/*                                         <CJK> */,/* 4261 */
/* U+AFA6 */	0x7955	/*                                         <CJK> */,/* 4262 */
/* U+AFA7 */	0x7950	/*                                         <CJK> */,/* 4263 */
/* U+AFA8 */	0x7960	/*                                         <CJK> */,/* 4264 */
/* U+AFA9 */	0x795F	/*                                         <CJK> */,/* 4265 */
/* U+AFAA */	0x7956	/*                                         <CJK> */,/* 4266 */
/* U+AFAB */	0x795E	/*                                         <CJK> */,/* 4267 */
/* U+AFAC */	0x795D	/*                                         <CJK> */,/* 4268 */
/* U+AFAD */	0x7957	/*                                         <CJK> */,/* 4269 */
/* U+AFAE */	0x795A	/*                                         <CJK> */,/* 4270 */
/* U+AFAF */	0x79E4	/*                                         <CJK> */,/* 4271 */
/* U+AFB0 */	0x79E3	/*                                         <CJK> */,/* 4272 */
/* U+AFB1 */	0x79E7	/*                                         <CJK> */,/* 4273 */
/* U+AFB2 */	0x79DF	/*                                         <CJK> */,/* 4274 */
/* U+AFB3 */	0x79E6	/*                                         <CJK> */,/* 4275 */
/* U+AFB4 */	0x79E9	/*                                         <CJK> */,/* 4276 */
/* U+AFB5 */	0x79D8	/*                                         <CJK> */,/* 4277 */
/* U+AFB6 */	0x7A84	/*                                         <CJK> */,/* 4278 */
/* U+AFB7 */	0x7A88	/*                                         <CJK> */,/* 4279 */
/* U+AFB8 */	0x7AD9	/*                                         <CJK> */,/* 4280 */
/* U+AFB9 */	0x7B06	/*                                         <CJK> */,/* 4281 */
/* U+AFBA */	0x7B11	/*                                         <CJK> */,/* 4282 */
/* U+AFBB */	0x7C89	/*                                         <CJK> */,/* 4283 */
/* U+AFBC */	0x7D21	/*                                         <CJK> */,/* 4284 */
/* U+AFBD */	0x7D17	/*                                         <CJK> */,/* 4285 */
/* U+AFBE */	0x7D0B	/*                                         <CJK> */,/* 4286 */
/* U+AFBF */	0x7D0A	/*                                         <CJK> */,/* 4287 */
/* U+AFC0 */	0x7D20	/*                                         <CJK> */,/* 4288 */
/* U+AFC1 */	0x7D22	/*                                         <CJK> */,/* 4289 */
/* U+AFC2 */	0x7D14	/*                                         <CJK> */,/* 4290 */
/* U+AFC3 */	0x7D10	/*                                         <CJK> */,/* 4291 */
/* U+AFC4 */	0x7D15	/*                                         <CJK> */,/* 4292 */
/* U+AFC5 */	0x7D1A	/*                                         <CJK> */,/* 4293 */
/* U+AFC6 */	0x7D1C	/*                                         <CJK> */,/* 4294 */
/* U+AFC7 */	0x7D0D	/*                                         <CJK> */,/* 4295 */
/* U+AFC8 */	0x7D19	/*                                         <CJK> */,/* 4296 */
/* U+AFC9 */	0x7D1B	/*                                         <CJK> */,/* 4297 */
/* U+AFCA */	0x7F3A	/*                                         <CJK> */,/* 4298 */
/* U+AFCB */	0x7F5F	/*                                         <CJK> */,/* 4299 */
/* U+AFCC */	0x7F94	/*                                         <CJK> */,/* 4300 */
/* U+AFCD */	0x7FC5	/*                                         <CJK> */,/* 4301 */
/* U+AFCE */	0x7FC1	/*                                         <CJK> */,/* 4302 */
/* U+AFCF */	0x8006	/*                                         <CJK> */,/* 4303 */
/* U+AFD0 */	0x8018	/*                                         <CJK> */,/* 4304 */
/* U+AFD1 */	0x8015	/*                                         <CJK> */,/* 4305 */
/* U+AFD2 */	0x8019	/*                                         <CJK> */,/* 4306 */
/* U+AFD3 */	0x8017	/*                                         <CJK> */,/* 4307 */
/* U+AFD4 */	0x803D	/*                                         <CJK> */,/* 4308 */
/* U+AFD5 */	0x803F	/*                                         <CJK> */,/* 4309 */
/* U+AFD6 */	0x80F1	/*                                         <CJK> */,/* 4310 */
/* U+AFD7 */	0x8102	/*                                         <CJK> */,/* 4311 */
/* U+AFD8 */	0x80F0	/*                                         <CJK> */,/* 4312 */
/* U+AFD9 */	0x8105	/*                                         <CJK> */,/* 4313 */
/* U+AFDA */	0x80ED	/*                                         <CJK> */,/* 4314 */
/* U+AFDB */	0x80F4	/*                                         <CJK> */,/* 4315 */
/* U+AFDC */	0x8106	/*                                         <CJK> */,/* 4316 */
/* U+AFDD */	0x80F8	/*                                         <CJK> */,/* 4317 */
/* U+AFDE */	0x80F3	/*                                         <CJK> */,/* 4318 */
/* U+AFDF */	0x8108	/*                                         <CJK> */,/* 4319 */
/* U+AFE0 */	0x80FD	/*                                         <CJK> */,/* 4320 */
/* U+AFE1 */	0x810A	/*                                         <CJK> */,/* 4321 */
/* U+AFE2 */	0x80FC	/*                                         <CJK> */,/* 4322 */
/* U+AFE3 */	0x80EF	/*                                         <CJK> */,/* 4323 */
/* U+AFE4 */	0x81ED	/*                                         <CJK> */,/* 4324 */
/* U+AFE5 */	0x81EC	/*                                         <CJK> */,/* 4325 */
/* U+AFE6 */	0x8200	/*                                         <CJK> */,/* 4326 */
/* U+AFE7 */	0x8210	/*                                         <CJK> */,/* 4327 */
/* U+AFE8 */	0x822A	/*                                         <CJK> */,/* 4328 */
/* U+AFE9 */	0x822B	/*                                         <CJK> */,/* 4329 */
/* U+AFEA */	0x8228	/*                                         <CJK> */,/* 4330 */
/* U+AFEB */	0x822C	/*                                         <CJK> */,/* 4331 */
/* U+AFEC */	0x82BB	/*                                         <CJK> */,/* 4332 */
/* U+AFED */	0x832B	/*                                         <CJK> */,/* 4333 */
/* U+AFEE */	0x8352	/*                                         <CJK> */,/* 4334 */
/* U+AFEF */	0x8354	/*                                         <CJK> */,/* 4335 */
/* U+AFF0 */	0x834A	/*                                         <CJK> */,/* 4336 */
/* U+AFF1 */	0x8338	/*                                         <CJK> */,/* 4337 */
/* U+AFF2 */	0x8350	/*                                         <CJK> */,/* 4338 */
/* U+AFF3 */	0x8349	/*                                         <CJK> */,/* 4339 */
/* U+AFF4 */	0x8335	/*                                         <CJK> */,/* 4340 */
/* U+AFF5 */	0x8334	/*                                         <CJK> */,/* 4341 */
/* U+AFF6 */	0x834F	/*                                         <CJK> */,/* 4342 */
/* U+AFF7 */	0x8332	/*                                         <CJK> */,/* 4343 */
/* U+AFF8 */	0x8339	/*                                         <CJK> */,/* 4344 */
/* U+AFF9 */	0x8336	/*                                         <CJK> */,/* 4345 */
/* U+AFFA */	0x8317	/*                                         <CJK> */,/* 4346 */
/* U+AFFB */	0x8340	/*                                         <CJK> */,/* 4347 */
/* U+AFFC */	0x8331	/*                                         <CJK> */,/* 4348 */
/* U+AFFD */	0x8328	/*                                         <CJK> */,/* 4349 */
/* U+AFFE */	0x8343	/*                                         <CJK> */,/* 4350 */
/* U+AFFF */	UNICODE_REPLACEMENT_CHARACTER,	/* 4351 */
/* U+B000 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4352 */
/* U+B001 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4353 */
/* U+B002 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4354 */
/* U+B003 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4355 */
/* U+B004 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4356 */
/* U+B005 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4357 */
/* U+B006 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4358 */
/* U+B007 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4359 */
/* U+B008 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4360 */
/* U+B009 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4361 */
/* U+B00A */	UNICODE_REPLACEMENT_CHARACTER,	/* 4362 */
/* U+B00B */	UNICODE_REPLACEMENT_CHARACTER,	/* 4363 */
/* U+B00C */	UNICODE_REPLACEMENT_CHARACTER,	/* 4364 */
/* U+B00D */	UNICODE_REPLACEMENT_CHARACTER,	/* 4365 */
/* U+B00E */	UNICODE_REPLACEMENT_CHARACTER,	/* 4366 */
/* U+B00F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4367 */
/* U+B010 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4368 */
/* U+B011 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4369 */
/* U+B012 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4370 */
/* U+B013 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4371 */
/* U+B014 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4372 */
/* U+B015 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4373 */
/* U+B016 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4374 */
/* U+B017 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4375 */
/* U+B018 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4376 */
/* U+B019 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4377 */
/* U+B01A */	UNICODE_REPLACEMENT_CHARACTER,	/* 4378 */
/* U+B01B */	UNICODE_REPLACEMENT_CHARACTER,	/* 4379 */
/* U+B01C */	UNICODE_REPLACEMENT_CHARACTER,	/* 4380 */
/* U+B01D */	UNICODE_REPLACEMENT_CHARACTER,	/* 4381 */
/* U+B01E */	UNICODE_REPLACEMENT_CHARACTER,	/* 4382 */
/* U+B01F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4383 */
/* U+B020 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4384 */
/* U+B021 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4385 */
/* U+B022 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4386 */
/* U+B023 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4387 */
/* U+B024 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4388 */
/* U+B025 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4389 */
/* U+B026 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4390 */
/* U+B027 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4391 */
/* U+B028 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4392 */
/* U+B029 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4393 */
/* U+B02A */	UNICODE_REPLACEMENT_CHARACTER,	/* 4394 */
/* U+B02B */	UNICODE_REPLACEMENT_CHARACTER,	/* 4395 */
/* U+B02C */	UNICODE_REPLACEMENT_CHARACTER,	/* 4396 */
/* U+B02D */	UNICODE_REPLACEMENT_CHARACTER,	/* 4397 */
/* U+B02E */	UNICODE_REPLACEMENT_CHARACTER,	/* 4398 */
/* U+B02F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4399 */
/* U+B030 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4400 */
/* U+B031 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4401 */
/* U+B032 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4402 */
/* U+B033 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4403 */
/* U+B034 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4404 */
/* U+B035 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4405 */
/* U+B036 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4406 */
/* U+B037 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4407 */
/* U+B038 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4408 */
/* U+B039 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4409 */
/* U+B03A */	UNICODE_REPLACEMENT_CHARACTER,	/* 4410 */
/* U+B03B */	UNICODE_REPLACEMENT_CHARACTER,	/* 4411 */
/* U+B03C */	UNICODE_REPLACEMENT_CHARACTER,	/* 4412 */
/* U+B03D */	UNICODE_REPLACEMENT_CHARACTER,	/* 4413 */
/* U+B03E */	UNICODE_REPLACEMENT_CHARACTER,	/* 4414 */
/* U+B03F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4415 */
/* U+B040 */	0x8654	/*                                         <CJK> */,/* 4416 */
/* U+B041 */	0x868A	/*                                         <CJK> */,/* 4417 */
/* U+B042 */	0x86AA	/*                                         <CJK> */,/* 4418 */
/* U+B043 */	0x8693	/*                                         <CJK> */,/* 4419 */
/* U+B044 */	0x86A4	/*                                         <CJK> */,/* 4420 */
/* U+B045 */	0x86A9	/*                                         <CJK> */,/* 4421 */
/* U+B046 */	0x868C	/*                                         <CJK> */,/* 4422 */
/* U+B047 */	0x86A3	/*                                         <CJK> */,/* 4423 */
/* U+B048 */	0x869C	/*                                         <CJK> */,/* 4424 */
/* U+B049 */	0x8870	/*                                         <CJK> */,/* 4425 */
/* U+B04A */	0x8877	/*                                         <CJK> */,/* 4426 */
/* U+B04B */	0x8881	/*                                         <CJK> */,/* 4427 */
/* U+B04C */	0x8882	/*                                         <CJK> */,/* 4428 */
/* U+B04D */	0x887D	/*                                         <CJK> */,/* 4429 */
/* U+B04E */	0x8879	/*                                         <CJK> */,/* 4430 */
/* U+B04F */	0x8A18	/*                                         <CJK> */,/* 4431 */
/* U+B050 */	0x8A10	/*                                         <CJK> */,/* 4432 */
/* U+B051 */	0x8A0E	/*                                         <CJK> */,/* 4433 */
/* U+B052 */	0x8A0C	/*                                         <CJK> */,/* 4434 */
/* U+B053 */	0x8A15	/*                                         <CJK> */,/* 4435 */
/* U+B054 */	0x8A0A	/*                                         <CJK> */,/* 4436 */
/* U+B055 */	0x8A17	/*                                         <CJK> */,/* 4437 */
/* U+B056 */	0x8A13	/*                                         <CJK> */,/* 4438 */
/* U+B057 */	0x8A16	/*                                         <CJK> */,/* 4439 */
/* U+B058 */	0x8A0F	/*                                         <CJK> */,/* 4440 */
/* U+B059 */	0x8A11	/*                                         <CJK> */,/* 4441 */
/* U+B05A */	0x8C48	/*                                         <CJK> */,/* 4442 */
/* U+B05B */	0x8C7A	/*                                         <CJK> */,/* 4443 */
/* U+B05C */	0x8C79	/*                                         <CJK> */,/* 4444 */
/* U+B05D */	0x8CA1	/*                                         <CJK> */,/* 4445 */
/* U+B05E */	0x8CA2	/*                                         <CJK> */,/* 4446 */
/* U+B05F */	0x8D77	/*                                         <CJK> */,/* 4447 */
/* U+B060 */	0x8EAC	/*                                         <CJK> */,/* 4448 */
/* U+B061 */	0x8ED2	/*                                         <CJK> */,/* 4449 */
/* U+B062 */	0x8ED4	/*                                         <CJK> */,/* 4450 */
/* U+B063 */	0x8ECF	/*                                         <CJK> */,/* 4451 */
/* U+B064 */	0x8FB1	/*                                         <CJK> */,/* 4452 */
/* U+B065 */	0x9001	/*                                         <CJK> */,/* 4453 */
/* U+B066 */	0x9006	/*                                         <CJK> */,/* 4454 */
/* U+B067 */	0x8FF7	/*                                         <CJK> */,/* 4455 */
/* U+B068 */	0x9000	/*                                         <CJK> */,/* 4456 */
/* U+B069 */	0x8FFA	/*                                         <CJK> */,/* 4457 */
/* U+B06A */	0x8FF4	/*                                         <CJK> */,/* 4458 */
/* U+B06B */	0x9003	/*                                         <CJK> */,/* 4459 */
/* U+B06C */	0x8FFD	/*                                         <CJK> */,/* 4460 */
/* U+B06D */	0x9005	/*                                         <CJK> */,/* 4461 */
/* U+B06E */	0x8FF8	/*                                         <CJK> */,/* 4462 */
/* U+B06F */	0x9095	/*                                         <CJK> */,/* 4463 */
/* U+B070 */	0x90E1	/*                                         <CJK> */,/* 4464 */
/* U+B071 */	0x90DD	/*                                         <CJK> */,/* 4465 */
/* U+B072 */	0x90E2	/*                                         <CJK> */,/* 4466 */
/* U+B073 */	0x9152	/*                                         <CJK> */,/* 4467 */
/* U+B074 */	0x914D	/*                                         <CJK> */,/* 4468 */
/* U+B075 */	0x914C	/*                                         <CJK> */,/* 4469 */
/* U+B076 */	0x91D8	/*                                         <CJK> */,/* 4470 */
/* U+B077 */	0x91DD	/*                                         <CJK> */,/* 4471 */
/* U+B078 */	0x91D7	/*                                         <CJK> */,/* 4472 */
/* U+B079 */	0x91DC	/*                                         <CJK> */,/* 4473 */
/* U+B07A */	0x91D9	/*                                         <CJK> */,/* 4474 */
/* U+B07B */	0x9583	/*                                         <CJK> */,/* 4475 */
/* U+B07C */	0x9662	/*                                         <CJK> */,/* 4476 */
/* U+B07D */	0x9663	/*                                         <CJK> */,/* 4477 */
/* U+B07E */	0x9661	/*                                         <CJK> */,/* 4478 */
/* U+B07F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4479 */
/* U+B080 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4480 */
/* U+B081 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4481 */
/* U+B082 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4482 */
/* U+B083 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4483 */
/* U+B084 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4484 */
/* U+B085 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4485 */
/* U+B086 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4486 */
/* U+B087 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4487 */
/* U+B088 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4488 */
/* U+B089 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4489 */
/* U+B08A */	UNICODE_REPLACEMENT_CHARACTER,	/* 4490 */
/* U+B08B */	UNICODE_REPLACEMENT_CHARACTER,	/* 4491 */
/* U+B08C */	UNICODE_REPLACEMENT_CHARACTER,	/* 4492 */
/* U+B08D */	UNICODE_REPLACEMENT_CHARACTER,	/* 4493 */
/* U+B08E */	UNICODE_REPLACEMENT_CHARACTER,	/* 4494 */
/* U+B08F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4495 */
/* U+B090 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4496 */
/* U+B091 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4497 */
/* U+B092 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4498 */
/* U+B093 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4499 */
/* U+B094 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4500 */
/* U+B095 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4501 */
/* U+B096 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4502 */
/* U+B097 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4503 */
/* U+B098 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4504 */
/* U+B099 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4505 */
/* U+B09A */	UNICODE_REPLACEMENT_CHARACTER,	/* 4506 */
/* U+B09B */	UNICODE_REPLACEMENT_CHARACTER,	/* 4507 */
/* U+B09C */	UNICODE_REPLACEMENT_CHARACTER,	/* 4508 */
/* U+B09D */	UNICODE_REPLACEMENT_CHARACTER,	/* 4509 */
/* U+B09E */	UNICODE_REPLACEMENT_CHARACTER,	/* 4510 */
/* U+B09F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4511 */
/* U+B0A0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4512 */
/* U+B0A1 */	0x965B	/*                                         <CJK> */,/* 4513 */
/* U+B0A2 */	0x965D	/*                                         <CJK> */,/* 4514 */
/* U+B0A3 */	0x9664	/*                                         <CJK> */,/* 4515 */
/* U+B0A4 */	0x9658	/*                                         <CJK> */,/* 4516 */
/* U+B0A5 */	0x965E	/*                                         <CJK> */,/* 4517 */
/* U+B0A6 */	0x96BB	/*                                         <CJK> */,/* 4518 */
/* U+B0A7 */	0x98E2	/*                                         <CJK> */,/* 4519 */
/* U+B0A8 */	0x99AC	/*                                         <CJK> */,/* 4520 */
/* U+B0A9 */	0x9AA8	/*                                         <CJK> */,/* 4521 */
/* U+B0AA */	0x9AD8	/*                                         <CJK> */,/* 4522 */
/* U+B0AB */	0x9B25	/*                                         <CJK> */,/* 4523 */
/* U+B0AC */	0x9B32	/*                                         <CJK> */,/* 4524 */
/* U+B0AD */	0x9B3C	/*                                         <CJK> */,/* 4525 */
/* U+B0AE */	0x4E7E	/*                                         <CJK> */,/* 4526 */
/* U+B0AF */	0x507A	/*                                         <CJK> */,/* 4527 */
/* U+B0B0 */	0x507D	/*                                         <CJK> */,/* 4528 */
/* U+B0B1 */	0x505C	/*                                         <CJK> */,/* 4529 */
/* U+B0B2 */	0x5047	/*                                         <CJK> */,/* 4530 */
/* U+B0B3 */	0x5043	/*                                         <CJK> */,/* 4531 */
/* U+B0B4 */	0x504C	/*                                         <CJK> */,/* 4532 */
/* U+B0B5 */	0x505A	/*                                         <CJK> */,/* 4533 */
/* U+B0B6 */	0x5049	/*                                         <CJK> */,/* 4534 */
/* U+B0B7 */	0x5065	/*                                         <CJK> */,/* 4535 */
/* U+B0B8 */	0x5076	/*                                         <CJK> */,/* 4536 */
/* U+B0B9 */	0x504E	/*                                         <CJK> */,/* 4537 */
/* U+B0BA */	0x5055	/*                                         <CJK> */,/* 4538 */
/* U+B0BB */	0x5075	/*                                         <CJK> */,/* 4539 */
/* U+B0BC */	0x5074	/*                                         <CJK> */,/* 4540 */
/* U+B0BD */	0x5077	/*                                         <CJK> */,/* 4541 */
/* U+B0BE */	0x504F	/*                                         <CJK> */,/* 4542 */
/* U+B0BF */	0x500F	/*                                         <CJK> */,/* 4543 */
/* U+B0C0 */	0x506F	/*                                         <CJK> */,/* 4544 */
/* U+B0C1 */	0x506D	/*                                         <CJK> */,/* 4545 */
/* U+B0C2 */	0x515C	/*                                         <CJK> */,/* 4546 */
/* U+B0C3 */	0x5195	/*                                         <CJK> */,/* 4547 */
/* U+B0C4 */	0x51F0	/*                                         <CJK> */,/* 4548 */
/* U+B0C5 */	0x526A	/*                                         <CJK> */,/* 4549 */
/* U+B0C6 */	0x526F	/*                                         <CJK> */,/* 4550 */
/* U+B0C7 */	0x52D2	/*                                         <CJK> */,/* 4551 */
/* U+B0C8 */	0x52D9	/*                                         <CJK> */,/* 4552 */
/* U+B0C9 */	0x52D8	/*                                         <CJK> */,/* 4553 */
/* U+B0CA */	0x52D5	/*                                         <CJK> */,/* 4554 */
/* U+B0CB */	0x5310	/*                                         <CJK> */,/* 4555 */
/* U+B0CC */	0x530F	/*                                         <CJK> */,/* 4556 */
/* U+B0CD */	0x5319	/*                                         <CJK> */,/* 4557 */
/* U+B0CE */	0x533F	/*                                         <CJK> */,/* 4558 */
/* U+B0CF */	0x5340	/*                                         <CJK> */,/* 4559 */
/* U+B0D0 */	0x533E	/*                                         <CJK> */,/* 4560 */
/* U+B0D1 */	0x53C3	/*                                         <CJK> */,/* 4561 */
/* U+B0D2 */	0x66FC	/*                                         <CJK> */,/* 4562 */
/* U+B0D3 */	0x5546	/*                                         <CJK> */,/* 4563 */
/* U+B0D4 */	0x556A	/*                                         <CJK> */,/* 4564 */
/* U+B0D5 */	0x5566	/*                                         <CJK> */,/* 4565 */
/* U+B0D6 */	0x5544	/*                                         <CJK> */,/* 4566 */
/* U+B0D7 */	0x555E	/*                                         <CJK> */,/* 4567 */
/* U+B0D8 */	0x5561	/*                                         <CJK> */,/* 4568 */
/* U+B0D9 */	0x5543	/*                                         <CJK> */,/* 4569 */
/* U+B0DA */	0x554A	/*                                         <CJK> */,/* 4570 */
/* U+B0DB */	0x5531	/*                                         <CJK> */,/* 4571 */
/* U+B0DC */	0x5556	/*                                         <CJK> */,/* 4572 */
/* U+B0DD */	0x554F	/*                                         <CJK> */,/* 4573 */
/* U+B0DE */	0x5555	/*                                         <CJK> */,/* 4574 */
/* U+B0DF */	0x552F	/*                                         <CJK> */,/* 4575 */
/* U+B0E0 */	0x5564	/*                                         <CJK> */,/* 4576 */
/* U+B0E1 */	0x5538	/*                                         <CJK> */,/* 4577 */
/* U+B0E2 */	0x552E	/*                                         <CJK> */,/* 4578 */
/* U+B0E3 */	0x555C	/*                                         <CJK> */,/* 4579 */
/* U+B0E4 */	0x552C	/*                                         <CJK> */,/* 4580 */
/* U+B0E5 */	0x5563	/*                                         <CJK> */,/* 4581 */
/* U+B0E6 */	0x5533	/*                                         <CJK> */,/* 4582 */
/* U+B0E7 */	0x5541	/*                                         <CJK> */,/* 4583 */
/* U+B0E8 */	0x5557	/*                                         <CJK> */,/* 4584 */
/* U+B0E9 */	0x5708	/*                                         <CJK> */,/* 4585 */
/* U+B0EA */	0x570B	/*                                         <CJK> */,/* 4586 */
/* U+B0EB */	0x5709	/*                                         <CJK> */,/* 4587 */
/* U+B0EC */	0x57DF	/*                                         <CJK> */,/* 4588 */
/* U+B0ED */	0x5805	/*                                         <CJK> */,/* 4589 */
/* U+B0EE */	0x580A	/*                                         <CJK> */,/* 4590 */
/* U+B0EF */	0x5806	/*                                         <CJK> */,/* 4591 */
/* U+B0F0 */	0x57E0	/*                                         <CJK> */,/* 4592 */
/* U+B0F1 */	0x57E4	/*                                         <CJK> */,/* 4593 */
/* U+B0F2 */	0x57FA	/*                                         <CJK> */,/* 4594 */
/* U+B0F3 */	0x5802	/*                                         <CJK> */,/* 4595 */
/* U+B0F4 */	0x5835	/*                                         <CJK> */,/* 4596 */
/* U+B0F5 */	0x57F7	/*                                         <CJK> */,/* 4597 */
/* U+B0F6 */	0x57F9	/*                                         <CJK> */,/* 4598 */
/* U+B0F7 */	0x5920	/*                                         <CJK> */,/* 4599 */
/* U+B0F8 */	0x5962	/*                                         <CJK> */,/* 4600 */
/* U+B0F9 */	0x5A36	/*                                         <CJK> */,/* 4601 */
/* U+B0FA */	0x5A41	/*                                         <CJK> */,/* 4602 */
/* U+B0FB */	0x5A49	/*                                         <CJK> */,/* 4603 */
/* U+B0FC */	0x5A66	/*                                         <CJK> */,/* 4604 */
/* U+B0FD */	0x5A6A	/*                                         <CJK> */,/* 4605 */
/* U+B0FE */	0x5A40	/*                                         <CJK> */,/* 4606 */
/* U+B0FF */	UNICODE_REPLACEMENT_CHARACTER,	/* 4607 */
/* U+B100 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4608 */
/* U+B101 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4609 */
/* U+B102 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4610 */
/* U+B103 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4611 */
/* U+B104 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4612 */
/* U+B105 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4613 */
/* U+B106 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4614 */
/* U+B107 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4615 */
/* U+B108 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4616 */
/* U+B109 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4617 */
/* U+B10A */	UNICODE_REPLACEMENT_CHARACTER,	/* 4618 */
/* U+B10B */	UNICODE_REPLACEMENT_CHARACTER,	/* 4619 */
/* U+B10C */	UNICODE_REPLACEMENT_CHARACTER,	/* 4620 */
/* U+B10D */	UNICODE_REPLACEMENT_CHARACTER,	/* 4621 */
/* U+B10E */	UNICODE_REPLACEMENT_CHARACTER,	/* 4622 */
/* U+B10F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4623 */
/* U+B110 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4624 */
/* U+B111 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4625 */
/* U+B112 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4626 */
/* U+B113 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4627 */
/* U+B114 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4628 */
/* U+B115 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4629 */
/* U+B116 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4630 */
/* U+B117 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4631 */
/* U+B118 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4632 */
/* U+B119 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4633 */
/* U+B11A */	UNICODE_REPLACEMENT_CHARACTER,	/* 4634 */
/* U+B11B */	UNICODE_REPLACEMENT_CHARACTER,	/* 4635 */
/* U+B11C */	UNICODE_REPLACEMENT_CHARACTER,	/* 4636 */
/* U+B11D */	UNICODE_REPLACEMENT_CHARACTER,	/* 4637 */
/* U+B11E */	UNICODE_REPLACEMENT_CHARACTER,	/* 4638 */
/* U+B11F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4639 */
/* U+B120 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4640 */
/* U+B121 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4641 */
/* U+B122 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4642 */
/* U+B123 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4643 */
/* U+B124 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4644 */
/* U+B125 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4645 */
/* U+B126 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4646 */
/* U+B127 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4647 */
/* U+B128 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4648 */
/* U+B129 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4649 */
/* U+B12A */	UNICODE_REPLACEMENT_CHARACTER,	/* 4650 */
/* U+B12B */	UNICODE_REPLACEMENT_CHARACTER,	/* 4651 */
/* U+B12C */	UNICODE_REPLACEMENT_CHARACTER,	/* 4652 */
/* U+B12D */	UNICODE_REPLACEMENT_CHARACTER,	/* 4653 */
/* U+B12E */	UNICODE_REPLACEMENT_CHARACTER,	/* 4654 */
/* U+B12F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4655 */
/* U+B130 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4656 */
/* U+B131 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4657 */
/* U+B132 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4658 */
/* U+B133 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4659 */
/* U+B134 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4660 */
/* U+B135 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4661 */
/* U+B136 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4662 */
/* U+B137 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4663 */
/* U+B138 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4664 */
/* U+B139 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4665 */
/* U+B13A */	UNICODE_REPLACEMENT_CHARACTER,	/* 4666 */
/* U+B13B */	UNICODE_REPLACEMENT_CHARACTER,	/* 4667 */
/* U+B13C */	UNICODE_REPLACEMENT_CHARACTER,	/* 4668 */
/* U+B13D */	UNICODE_REPLACEMENT_CHARACTER,	/* 4669 */
/* U+B13E */	UNICODE_REPLACEMENT_CHARACTER,	/* 4670 */
/* U+B13F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4671 */
/* U+B140 */	0x5A3C	/*                                         <CJK> */,/* 4672 */
/* U+B141 */	0x5A62	/*                                         <CJK> */,/* 4673 */
/* U+B142 */	0x5A5A	/*                                         <CJK> */,/* 4674 */
/* U+B143 */	0x5A46	/*                                         <CJK> */,/* 4675 */
/* U+B144 */	0x5A4A	/*                                         <CJK> */,/* 4676 */
/* U+B145 */	0x5B70	/*                                         <CJK> */,/* 4677 */
/* U+B146 */	0x5BC7	/*                                         <CJK> */,/* 4678 */
/* U+B147 */	0x5BC5	/*                                         <CJK> */,/* 4679 */
/* U+B148 */	0x5BC4	/*                                         <CJK> */,/* 4680 */
/* U+B149 */	0x5BC2	/*                                         <CJK> */,/* 4681 */
/* U+B14A */	0x5BBF	/*                                         <CJK> */,/* 4682 */
/* U+B14B */	0x5BC6	/*                                         <CJK> */,/* 4683 */
/* U+B14C */	0x5C09	/*                                         <CJK> */,/* 4684 */
/* U+B14D */	0x5C08	/*                                         <CJK> */,/* 4685 */
/* U+B14E */	0x5C07	/*                                         <CJK> */,/* 4686 */
/* U+B14F */	0x5C60	/*                                         <CJK> */,/* 4687 */
/* U+B150 */	0x5C5C	/*                                         <CJK> */,/* 4688 */
/* U+B151 */	0x5C5D	/*                                         <CJK> */,/* 4689 */
/* U+B152 */	0x5D07	/*                                         <CJK> */,/* 4690 */
/* U+B153 */	0x5D06	/*                                         <CJK> */,/* 4691 */
/* U+B154 */	0x5D0E	/*                                         <CJK> */,/* 4692 */
/* U+B155 */	0x5D1B	/*                                         <CJK> */,/* 4693 */
/* U+B156 */	0x5D16	/*                                         <CJK> */,/* 4694 */
/* U+B157 */	0x5D22	/*                                         <CJK> */,/* 4695 */
/* U+B158 */	0x5D11	/*                                         <CJK> */,/* 4696 */
/* U+B159 */	0x5D29	/*                                         <CJK> */,/* 4697 */
/* U+B15A */	0x5D14	/*                                         <CJK> */,/* 4698 */
/* U+B15B */	0x5D19	/*                                         <CJK> */,/* 4699 */
/* U+B15C */	0x5D24	/*                                         <CJK> */,/* 4700 */
/* U+B15D */	0x5D27	/*                                         <CJK> */,/* 4701 */
/* U+B15E */	0x5D17	/*                                         <CJK> */,/* 4702 */
/* U+B15F */	0x5DE2	/*                                         <CJK> */,/* 4703 */
/* U+B160 */	0x5E38	/*                                         <CJK> */,/* 4704 */
/* U+B161 */	0x5E36	/*                                         <CJK> */,/* 4705 */
/* U+B162 */	0x5E33	/*                                         <CJK> */,/* 4706 */
/* U+B163 */	0x5E37	/*                                         <CJK> */,/* 4707 */
/* U+B164 */	0x5EB7	/*                                         <CJK> */,/* 4708 */
/* U+B165 */	0x5EB8	/*                                         <CJK> */,/* 4709 */
/* U+B166 */	0x5EB6	/*                                         <CJK> */,/* 4710 */
/* U+B167 */	0x5EB5	/*                                         <CJK> */,/* 4711 */
/* U+B168 */	0x5EBE	/*                                         <CJK> */,/* 4712 */
/* U+B169 */	0x5F35	/*                                         <CJK> */,/* 4713 */
/* U+B16A */	0x5F37	/*                                         <CJK> */,/* 4714 */
/* U+B16B */	0x5F57	/*                                         <CJK> */,/* 4715 */
/* U+B16C */	0x5F6C	/*                                         <CJK> */,/* 4716 */
/* U+B16D */	0x5F69	/*                                         <CJK> */,/* 4717 */
/* U+B16E */	0x5F6B	/*                                         <CJK> */,/* 4718 */
/* U+B16F */	0x5F97	/*                                         <CJK> */,/* 4719 */
/* U+B170 */	0x5F99	/*                                         <CJK> */,/* 4720 */
/* U+B171 */	0x5F9E	/*                                         <CJK> */,/* 4721 */
/* U+B172 */	0x5F98	/*                                         <CJK> */,/* 4722 */
/* U+B173 */	0x5FA1	/*                                         <CJK> */,/* 4723 */
/* U+B174 */	0x5FA0	/*                                         <CJK> */,/* 4724 */
/* U+B175 */	0x5F9C	/*                                         <CJK> */,/* 4725 */
/* U+B176 */	0x607F	/*                                         <CJK> */,/* 4726 */
/* U+B177 */	0x60A3	/*                                         <CJK> */,/* 4727 */
/* U+B178 */	0x6089	/*                                         <CJK> */,/* 4728 */
/* U+B179 */	0x60A0	/*                                         <CJK> */,/* 4729 */
/* U+B17A */	0x60A8	/*                                         <CJK> */,/* 4730 */
/* U+B17B */	0x60CB	/*                                         <CJK> */,/* 4731 */
/* U+B17C */	0x60B4	/*                                         <CJK> */,/* 4732 */
/* U+B17D */	0x60E6	/*                                         <CJK> */,/* 4733 */
/* U+B17E */	0x60BD	/*                                         <CJK> */,/* 4734 */
/* U+B17F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4735 */
/* U+B180 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4736 */
/* U+B181 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4737 */
/* U+B182 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4738 */
/* U+B183 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4739 */
/* U+B184 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4740 */
/* U+B185 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4741 */
/* U+B186 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4742 */
/* U+B187 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4743 */
/* U+B188 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4744 */
/* U+B189 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4745 */
/* U+B18A */	UNICODE_REPLACEMENT_CHARACTER,	/* 4746 */
/* U+B18B */	UNICODE_REPLACEMENT_CHARACTER,	/* 4747 */
/* U+B18C */	UNICODE_REPLACEMENT_CHARACTER,	/* 4748 */
/* U+B18D */	UNICODE_REPLACEMENT_CHARACTER,	/* 4749 */
/* U+B18E */	UNICODE_REPLACEMENT_CHARACTER,	/* 4750 */
/* U+B18F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4751 */
/* U+B190 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4752 */
/* U+B191 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4753 */
/* U+B192 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4754 */
/* U+B193 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4755 */
/* U+B194 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4756 */
/* U+B195 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4757 */
/* U+B196 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4758 */
/* U+B197 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4759 */
/* U+B198 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4760 */
/* U+B199 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4761 */
/* U+B19A */	UNICODE_REPLACEMENT_CHARACTER,	/* 4762 */
/* U+B19B */	UNICODE_REPLACEMENT_CHARACTER,	/* 4763 */
/* U+B19C */	UNICODE_REPLACEMENT_CHARACTER,	/* 4764 */
/* U+B19D */	UNICODE_REPLACEMENT_CHARACTER,	/* 4765 */
/* U+B19E */	UNICODE_REPLACEMENT_CHARACTER,	/* 4766 */
/* U+B19F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4767 */
/* U+B1A0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4768 */
/* U+B1A1 */	0x60C5	/*                                         <CJK> */,/* 4769 */
/* U+B1A2 */	0x60BB	/*                                         <CJK> */,/* 4770 */
/* U+B1A3 */	0x60B5	/*                                         <CJK> */,/* 4771 */
/* U+B1A4 */	0x60DC	/*                                         <CJK> */,/* 4772 */
/* U+B1A5 */	0x60BC	/*                                         <CJK> */,/* 4773 */
/* U+B1A6 */	0x60D8	/*                                         <CJK> */,/* 4774 */
/* U+B1A7 */	0x60D5	/*                                         <CJK> */,/* 4775 */
/* U+B1A8 */	0x60C6	/*                                         <CJK> */,/* 4776 */
/* U+B1A9 */	0x60DF	/*                                         <CJK> */,/* 4777 */
/* U+B1AA */	0x60B8	/*                                         <CJK> */,/* 4778 */
/* U+B1AB */	0x60DA	/*                                         <CJK> */,/* 4779 */
/* U+B1AC */	0x60C7	/*                                         <CJK> */,/* 4780 */
/* U+B1AD */	0x621A	/*                                         <CJK> */,/* 4781 */
/* U+B1AE */	0x621B	/*                                         <CJK> */,/* 4782 */
/* U+B1AF */	0x6248	/*                                         <CJK> */,/* 4783 */
/* U+B1B0 */	0x63A0	/*                                         <CJK> */,/* 4784 */
/* U+B1B1 */	0x63A7	/*                                         <CJK> */,/* 4785 */
/* U+B1B2 */	0x6372	/*                                         <CJK> */,/* 4786 */
/* U+B1B3 */	0x6396	/*                                         <CJK> */,/* 4787 */
/* U+B1B4 */	0x63A2	/*                                         <CJK> */,/* 4788 */
/* U+B1B5 */	0x63A5	/*                                         <CJK> */,/* 4789 */
/* U+B1B6 */	0x6377	/*                                         <CJK> */,/* 4790 */
/* U+B1B7 */	0x6367	/*                                         <CJK> */,/* 4791 */
/* U+B1B8 */	0x6398	/*                                         <CJK> */,/* 4792 */
/* U+B1B9 */	0x63AA	/*                                         <CJK> */,/* 4793 */
/* U+B1BA */	0x6371	/*                                         <CJK> */,/* 4794 */
/* U+B1BB */	0x63A9	/*                                         <CJK> */,/* 4795 */
/* U+B1BC */	0x6389	/*                                         <CJK> */,/* 4796 */
/* U+B1BD */	0x6383	/*                                         <CJK> */,/* 4797 */
/* U+B1BE */	0x639B	/*                                         <CJK> */,/* 4798 */
/* U+B1BF */	0x636B	/*                                         <CJK> */,/* 4799 */
/* U+B1C0 */	0x63A8	/*                                         <CJK> */,/* 4800 */
/* U+B1C1 */	0x6384	/*                                         <CJK> */,/* 4801 */
/* U+B1C2 */	0x6388	/*                                         <CJK> */,/* 4802 */
/* U+B1C3 */	0x6399	/*                                         <CJK> */,/* 4803 */
/* U+B1C4 */	0x63A1	/*                                         <CJK> */,/* 4804 */
/* U+B1C5 */	0x63AC	/*                                         <CJK> */,/* 4805 */
/* U+B1C6 */	0x6392	/*                                         <CJK> */,/* 4806 */
/* U+B1C7 */	0x638F	/*                                         <CJK> */,/* 4807 */
/* U+B1C8 */	0x6380	/*                                         <CJK> */,/* 4808 */
/* U+B1C9 */	0x637B	/*                                         <CJK> */,/* 4809 */
/* U+B1CA */	0x6369	/*                                         <CJK> */,/* 4810 */
/* U+B1CB */	0x6368	/*                                         <CJK> */,/* 4811 */
/* U+B1CC */	0x637A	/*                                         <CJK> */,/* 4812 */
/* U+B1CD */	0x655D	/*                                         <CJK> */,/* 4813 */
/* U+B1CE */	0x6556	/*                                         <CJK> */,/* 4814 */
/* U+B1CF */	0x6551	/*                                         <CJK> */,/* 4815 */
/* U+B1D0 */	0x6559	/*                                         <CJK> */,/* 4816 */
/* U+B1D1 */	0x6557	/*                                         <CJK> */,/* 4817 */
/* U+B1D2 */	0x555F	/*                                         <CJK> */,/* 4818 */
/* U+B1D3 */	0x654F	/*                                         <CJK> */,/* 4819 */
/* U+B1D4 */	0x6558	/*                                         <CJK> */,/* 4820 */
/* U+B1D5 */	0x6555	/*                                         <CJK> */,/* 4821 */
/* U+B1D6 */	0x6554	/*                                         <CJK> */,/* 4822 */
/* U+B1D7 */	0x659C	/*                                         <CJK> */,/* 4823 */
/* U+B1D8 */	0x659B	/*                                         <CJK> */,/* 4824 */
/* U+B1D9 */	0x65AC	/*                                         <CJK> */,/* 4825 */
/* U+B1DA */	0x65CF	/*                                         <CJK> */,/* 4826 */
/* U+B1DB */	0x65CB	/*                                         <CJK> */,/* 4827 */
/* U+B1DC */	0x65CC	/*                                         <CJK> */,/* 4828 */
/* U+B1DD */	0x65CE	/*                                         <CJK> */,/* 4829 */
/* U+B1DE */	0x665D	/*                                         <CJK> */,/* 4830 */
/* U+B1DF */	0x665A	/*                                         <CJK> */,/* 4831 */
/* U+B1E0 */	0x6664	/*                                         <CJK> */,/* 4832 */
/* U+B1E1 */	0x6668	/*                                         <CJK> */,/* 4833 */
/* U+B1E2 */	0x6666	/*                                         <CJK> */,/* 4834 */
/* U+B1E3 */	0x665E	/*                                         <CJK> */,/* 4835 */
/* U+B1E4 */	0x66F9	/*                                         <CJK> */,/* 4836 */
/* U+B1E5 */	0x52D7	/*                                         <CJK> */,/* 4837 */
/* U+B1E6 */	0x671B	/*                                         <CJK> */,/* 4838 */
/* U+B1E7 */	0x6881	/*                                         <CJK> */,/* 4839 */
/* U+B1E8 */	0x68AF	/*                                         <CJK> */,/* 4840 */
/* U+B1E9 */	0x68A2	/*                                         <CJK> */,/* 4841 */
/* U+B1EA */	0x6893	/*                                         <CJK> */,/* 4842 */
/* U+B1EB */	0x68B5	/*                                         <CJK> */,/* 4843 */
/* U+B1EC */	0x687F	/*                                         <CJK> */,/* 4844 */
/* U+B1ED */	0x6876	/*                                         <CJK> */,/* 4845 */
/* U+B1EE */	0x68B1	/*                                         <CJK> */,/* 4846 */
/* U+B1EF */	0x68A7	/*                                         <CJK> */,/* 4847 */
/* U+B1F0 */	0x6897	/*                                         <CJK> */,/* 4848 */
/* U+B1F1 */	0x68B0	/*                                         <CJK> */,/* 4849 */
/* U+B1F2 */	0x6883	/*                                         <CJK> */,/* 4850 */
/* U+B1F3 */	0x68C4	/*                                         <CJK> */,/* 4851 */
/* U+B1F4 */	0x68AD	/*                                         <CJK> */,/* 4852 */
/* U+B1F5 */	0x6886	/*                                         <CJK> */,/* 4853 */
/* U+B1F6 */	0x6885	/*                                         <CJK> */,/* 4854 */
/* U+B1F7 */	0x6894	/*                                         <CJK> */,/* 4855 */
/* U+B1F8 */	0x689D	/*                                         <CJK> */,/* 4856 */
/* U+B1F9 */	0x68A8	/*                                         <CJK> */,/* 4857 */
/* U+B1FA */	0x689F	/*                                         <CJK> */,/* 4858 */
/* U+B1FB */	0x68A1	/*                                         <CJK> */,/* 4859 */
/* U+B1FC */	0x6882	/*                                         <CJK> */,/* 4860 */
/* U+B1FD */	0x6B32	/*                                         <CJK> */,/* 4861 */
/* U+B1FE */	0x6BBA	/*                                         <CJK> */,/* 4862 */
/* U+B1FF */	UNICODE_REPLACEMENT_CHARACTER,	/* 4863 */
/* U+B200 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4864 */
/* U+B201 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4865 */
/* U+B202 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4866 */
/* U+B203 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4867 */
/* U+B204 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4868 */
/* U+B205 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4869 */
/* U+B206 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4870 */
/* U+B207 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4871 */
/* U+B208 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4872 */
/* U+B209 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4873 */
/* U+B20A */	UNICODE_REPLACEMENT_CHARACTER,	/* 4874 */
/* U+B20B */	UNICODE_REPLACEMENT_CHARACTER,	/* 4875 */
/* U+B20C */	UNICODE_REPLACEMENT_CHARACTER,	/* 4876 */
/* U+B20D */	UNICODE_REPLACEMENT_CHARACTER,	/* 4877 */
/* U+B20E */	UNICODE_REPLACEMENT_CHARACTER,	/* 4878 */
/* U+B20F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4879 */
/* U+B210 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4880 */
/* U+B211 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4881 */
/* U+B212 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4882 */
/* U+B213 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4883 */
/* U+B214 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4884 */
/* U+B215 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4885 */
/* U+B216 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4886 */
/* U+B217 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4887 */
/* U+B218 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4888 */
/* U+B219 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4889 */
/* U+B21A */	UNICODE_REPLACEMENT_CHARACTER,	/* 4890 */
/* U+B21B */	UNICODE_REPLACEMENT_CHARACTER,	/* 4891 */
/* U+B21C */	UNICODE_REPLACEMENT_CHARACTER,	/* 4892 */
/* U+B21D */	UNICODE_REPLACEMENT_CHARACTER,	/* 4893 */
/* U+B21E */	UNICODE_REPLACEMENT_CHARACTER,	/* 4894 */
/* U+B21F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4895 */
/* U+B220 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4896 */
/* U+B221 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4897 */
/* U+B222 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4898 */
/* U+B223 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4899 */
/* U+B224 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4900 */
/* U+B225 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4901 */
/* U+B226 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4902 */
/* U+B227 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4903 */
/* U+B228 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4904 */
/* U+B229 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4905 */
/* U+B22A */	UNICODE_REPLACEMENT_CHARACTER,	/* 4906 */
/* U+B22B */	UNICODE_REPLACEMENT_CHARACTER,	/* 4907 */
/* U+B22C */	UNICODE_REPLACEMENT_CHARACTER,	/* 4908 */
/* U+B22D */	UNICODE_REPLACEMENT_CHARACTER,	/* 4909 */
/* U+B22E */	UNICODE_REPLACEMENT_CHARACTER,	/* 4910 */
/* U+B22F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4911 */
/* U+B230 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4912 */
/* U+B231 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4913 */
/* U+B232 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4914 */
/* U+B233 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4915 */
/* U+B234 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4916 */
/* U+B235 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4917 */
/* U+B236 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4918 */
/* U+B237 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4919 */
/* U+B238 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4920 */
/* U+B239 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4921 */
/* U+B23A */	UNICODE_REPLACEMENT_CHARACTER,	/* 4922 */
/* U+B23B */	UNICODE_REPLACEMENT_CHARACTER,	/* 4923 */
/* U+B23C */	UNICODE_REPLACEMENT_CHARACTER,	/* 4924 */
/* U+B23D */	UNICODE_REPLACEMENT_CHARACTER,	/* 4925 */
/* U+B23E */	UNICODE_REPLACEMENT_CHARACTER,	/* 4926 */
/* U+B23F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4927 */
/* U+B240 */	0x6BEB	/*                                         <CJK> */,/* 4928 */
/* U+B241 */	0x6BEC	/*                                         <CJK> */,/* 4929 */
/* U+B242 */	0x6C2B	/*                                         <CJK> */,/* 4930 */
/* U+B243 */	0x6D8E	/*                                         <CJK> */,/* 4931 */
/* U+B244 */	0x6DBC	/*                                         <CJK> */,/* 4932 */
/* U+B245 */	0x6DF3	/*                                         <CJK> */,/* 4933 */
/* U+B246 */	0x6DD9	/*                                         <CJK> */,/* 4934 */
/* U+B247 */	0x6DB2	/*                                         <CJK> */,/* 4935 */
/* U+B248 */	0x6DE1	/*                                         <CJK> */,/* 4936 */
/* U+B249 */	0x6DCC	/*                                         <CJK> */,/* 4937 */
/* U+B24A */	0x6DE4	/*                                         <CJK> */,/* 4938 */
/* U+B24B */	0x6DFB	/*                                         <CJK> */,/* 4939 */
/* U+B24C */	0x6DFA	/*                                         <CJK> */,/* 4940 */
/* U+B24D */	0x6E05	/*                                         <CJK> */,/* 4941 */
/* U+B24E */	0x6DC7	/*                                         <CJK> */,/* 4942 */
/* U+B24F */	0x6DCB	/*                                         <CJK> */,/* 4943 */
/* U+B250 */	0x6DAF	/*                                         <CJK> */,/* 4944 */
/* U+B251 */	0x6DD1	/*                                         <CJK> */,/* 4945 */
/* U+B252 */	0x6DAE	/*                                         <CJK> */,/* 4946 */
/* U+B253 */	0x6DDE	/*                                         <CJK> */,/* 4947 */
/* U+B254 */	0x6DF9	/*                                         <CJK> */,/* 4948 */
/* U+B255 */	0x6DB8	/*                                         <CJK> */,/* 4949 */
/* U+B256 */	0x6DF7	/*                                         <CJK> */,/* 4950 */
/* U+B257 */	0x6DF5	/*                                         <CJK> */,/* 4951 */
/* U+B258 */	0x6DC5	/*                                         <CJK> */,/* 4952 */
/* U+B259 */	0x6DD2	/*                                         <CJK> */,/* 4953 */
/* U+B25A */	0x6E1A	/*                                         <CJK> */,/* 4954 */
/* U+B25B */	0x6DB5	/*                                         <CJK> */,/* 4955 */
/* U+B25C */	0x6DDA	/*                                         <CJK> */,/* 4956 */
/* U+B25D */	0x6DEB	/*                                         <CJK> */,/* 4957 */
/* U+B25E */	0x6DD8	/*                                         <CJK> */,/* 4958 */
/* U+B25F */	0x6DEA	/*                                         <CJK> */,/* 4959 */
/* U+B260 */	0x6DF1	/*                                         <CJK> */,/* 4960 */
/* U+B261 */	0x6DEE	/*                                         <CJK> */,/* 4961 */
/* U+B262 */	0x6DE8	/*                                         <CJK> */,/* 4962 */
/* U+B263 */	0x6DC6	/*                                         <CJK> */,/* 4963 */
/* U+B264 */	0x6DC4	/*                                         <CJK> */,/* 4964 */
/* U+B265 */	0x6DAA	/*                                         <CJK> */,/* 4965 */
/* U+B266 */	0x6DEC	/*                                         <CJK> */,/* 4966 */
/* U+B267 */	0x6DBF	/*                                         <CJK> */,/* 4967 */
/* U+B268 */	0x6DE6	/*                                         <CJK> */,/* 4968 */
/* U+B269 */	0x70F9	/*                                         <CJK> */,/* 4969 */
/* U+B26A */	0x7109	/*                                         <CJK> */,/* 4970 */
/* U+B26B */	0x710A	/*                                         <CJK> */,/* 4971 */
/* U+B26C */	0x70FD	/*                                         <CJK> */,/* 4972 */
/* U+B26D */	0x70EF	/*                                         <CJK> */,/* 4973 */
/* U+B26E */	0x723D	/*                                         <CJK> */,/* 4974 */
/* U+B26F */	0x727D	/*                                         <CJK> */,/* 4975 */
/* U+B270 */	0x7281	/*                                         <CJK> */,/* 4976 */
/* U+B271 */	0x731C	/*                                         <CJK> */,/* 4977 */
/* U+B272 */	0x731B	/*                                         <CJK> */,/* 4978 */
/* U+B273 */	0x7316	/*                                         <CJK> */,/* 4979 */
/* U+B274 */	0x7313	/*                                         <CJK> */,/* 4980 */
/* U+B275 */	0x7319	/*                                         <CJK> */,/* 4981 */
/* U+B276 */	0x7387	/*                                         <CJK> */,/* 4982 */
/* U+B277 */	0x7405	/*                                         <CJK> */,/* 4983 */
/* U+B278 */	0x740A	/*                                         <CJK> */,/* 4984 */
/* U+B279 */	0x7403	/*                                         <CJK> */,/* 4985 */
/* U+B27A */	0x7406	/*                                         <CJK> */,/* 4986 */
/* U+B27B */	0x73FE	/*                                         <CJK> */,/* 4987 */
/* U+B27C */	0x740D	/*                                         <CJK> */,/* 4988 */
/* U+B27D */	0x74E0	/*                                         <CJK> */,/* 4989 */
/* U+B27E */	0x74F6	/*                                         <CJK> */,/* 4990 */
/* U+B27F */	UNICODE_REPLACEMENT_CHARACTER,	/* 4991 */
/* U+B280 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4992 */
/* U+B281 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4993 */
/* U+B282 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4994 */
/* U+B283 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4995 */
/* U+B284 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4996 */
/* U+B285 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4997 */
/* U+B286 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4998 */
/* U+B287 */	UNICODE_REPLACEMENT_CHARACTER,	/* 4999 */
/* U+B288 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5000 */
/* U+B289 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5001 */
/* U+B28A */	UNICODE_REPLACEMENT_CHARACTER,	/* 5002 */
/* U+B28B */	UNICODE_REPLACEMENT_CHARACTER,	/* 5003 */
/* U+B28C */	UNICODE_REPLACEMENT_CHARACTER,	/* 5004 */
/* U+B28D */	UNICODE_REPLACEMENT_CHARACTER,	/* 5005 */
/* U+B28E */	UNICODE_REPLACEMENT_CHARACTER,	/* 5006 */
/* U+B28F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5007 */
/* U+B290 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5008 */
/* U+B291 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5009 */
/* U+B292 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5010 */
/* U+B293 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5011 */
/* U+B294 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5012 */
/* U+B295 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5013 */
/* U+B296 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5014 */
/* U+B297 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5015 */
/* U+B298 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5016 */
/* U+B299 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5017 */
/* U+B29A */	UNICODE_REPLACEMENT_CHARACTER,	/* 5018 */
/* U+B29B */	UNICODE_REPLACEMENT_CHARACTER,	/* 5019 */
/* U+B29C */	UNICODE_REPLACEMENT_CHARACTER,	/* 5020 */
/* U+B29D */	UNICODE_REPLACEMENT_CHARACTER,	/* 5021 */
/* U+B29E */	UNICODE_REPLACEMENT_CHARACTER,	/* 5022 */
/* U+B29F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5023 */
/* U+B2A0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5024 */
/* U+B2A1 */	0x74F7	/*                                         <CJK> */,/* 5025 */
/* U+B2A2 */	0x751C	/*                                         <CJK> */,/* 5026 */
/* U+B2A3 */	0x7522	/*                                         <CJK> */,/* 5027 */
/* U+B2A4 */	0x7565	/*                                         <CJK> */,/* 5028 */
/* U+B2A5 */	0x7566	/*                                         <CJK> */,/* 5029 */
/* U+B2A6 */	0x7562	/*                                         <CJK> */,/* 5030 */
/* U+B2A7 */	0x7570	/*                                         <CJK> */,/* 5031 */
/* U+B2A8 */	0x758F	/*                                         <CJK> */,/* 5032 */
/* U+B2A9 */	0x75D4	/*                                         <CJK> */,/* 5033 */
/* U+B2AA */	0x75D5	/*                                         <CJK> */,/* 5034 */
/* U+B2AB */	0x75B5	/*                                         <CJK> */,/* 5035 */
/* U+B2AC */	0x75CA	/*                                         <CJK> */,/* 5036 */
/* U+B2AD */	0x75CD	/*                                         <CJK> */,/* 5037 */
/* U+B2AE */	0x768E	/*                                         <CJK> */,/* 5038 */
/* U+B2AF */	0x76D4	/*                                         <CJK> */,/* 5039 */
/* U+B2B0 */	0x76D2	/*                                         <CJK> */,/* 5040 */
/* U+B2B1 */	0x76DB	/*                                         <CJK> */,/* 5041 */
/* U+B2B2 */	0x7737	/*                                         <CJK> */,/* 5042 */
/* U+B2B3 */	0x773E	/*                                         <CJK> */,/* 5043 */
/* U+B2B4 */	0x773C	/*                                         <CJK> */,/* 5044 */
/* U+B2B5 */	0x7736	/*                                         <CJK> */,/* 5045 */
/* U+B2B6 */	0x7738	/*                                         <CJK> */,/* 5046 */
/* U+B2B7 */	0x773A	/*                                         <CJK> */,/* 5047 */
/* U+B2B8 */	0x786B	/*                                         <CJK> */,/* 5048 */
/* U+B2B9 */	0x7843	/*                                         <CJK> */,/* 5049 */
/* U+B2BA */	0x784E	/*                                         <CJK> */,/* 5050 */
/* U+B2BB */	0x7965	/*                                         <CJK> */,/* 5051 */
/* U+B2BC */	0x7968	/*                                         <CJK> */,/* 5052 */
/* U+B2BD */	0x796D	/*                                         <CJK> */,/* 5053 */
/* U+B2BE */	0x79FB	/*                                         <CJK> */,/* 5054 */
/* U+B2BF */	0x7A92	/*                                         <CJK> */,/* 5055 */
/* U+B2C0 */	0x7A95	/*                                         <CJK> */,/* 5056 */
/* U+B2C1 */	0x7B20	/*                                         <CJK> */,/* 5057 */
/* U+B2C2 */	0x7B28	/*                                         <CJK> */,/* 5058 */
/* U+B2C3 */	0x7B1B	/*                                         <CJK> */,/* 5059 */
/* U+B2C4 */	0x7B2C	/*                                         <CJK> */,/* 5060 */
/* U+B2C5 */	0x7B26	/*                                         <CJK> */,/* 5061 */
/* U+B2C6 */	0x7B19	/*                                         <CJK> */,/* 5062 */
/* U+B2C7 */	0x7B1E	/*                                         <CJK> */,/* 5063 */
/* U+B2C8 */	0x7B2E	/*                                         <CJK> */,/* 5064 */
/* U+B2C9 */	0x7C92	/*                                         <CJK> */,/* 5065 */
/* U+B2CA */	0x7C97	/*                                         <CJK> */,/* 5066 */
/* U+B2CB */	0x7C95	/*                                         <CJK> */,/* 5067 */
/* U+B2CC */	0x7D46	/*                                         <CJK> */,/* 5068 */
/* U+B2CD */	0x7D43	/*                                         <CJK> */,/* 5069 */
/* U+B2CE */	0x7D71	/*                                         <CJK> */,/* 5070 */
/* U+B2CF */	0x7D2E	/*                                         <CJK> */,/* 5071 */
/* U+B2D0 */	0x7D39	/*                                         <CJK> */,/* 5072 */
/* U+B2D1 */	0x7D3C	/*                                         <CJK> */,/* 5073 */
/* U+B2D2 */	0x7D40	/*                                         <CJK> */,/* 5074 */
/* U+B2D3 */	0x7D30	/*                                         <CJK> */,/* 5075 */
/* U+B2D4 */	0x7D33	/*                                         <CJK> */,/* 5076 */
/* U+B2D5 */	0x7D44	/*                                         <CJK> */,/* 5077 */
/* U+B2D6 */	0x7D2F	/*                                         <CJK> */,/* 5078 */
/* U+B2D7 */	0x7D42	/*                                         <CJK> */,/* 5079 */
/* U+B2D8 */	0x7D32	/*                                         <CJK> */,/* 5080 */
/* U+B2D9 */	0x7D31	/*                                         <CJK> */,/* 5081 */
/* U+B2DA */	0x7F3D	/*                                         <CJK> */,/* 5082 */
/* U+B2DB */	0x7F9E	/*                                         <CJK> */,/* 5083 */
/* U+B2DC */	0x7F9A	/*                                         <CJK> */,/* 5084 */
/* U+B2DD */	0x7FCC	/*                                         <CJK> */,/* 5085 */
/* U+B2DE */	0x7FCE	/*                                         <CJK> */,/* 5086 */
/* U+B2DF */	0x7FD2	/*                                         <CJK> */,/* 5087 */
/* U+B2E0 */	0x801C	/*                                         <CJK> */,/* 5088 */
/* U+B2E1 */	0x804A	/*                                         <CJK> */,/* 5089 */
/* U+B2E2 */	0x8046	/*                                         <CJK> */,/* 5090 */
/* U+B2E3 */	0x812F	/*                                         <CJK> */,/* 5091 */
/* U+B2E4 */	0x8116	/*                                         <CJK> */,/* 5092 */
/* U+B2E5 */	0x8123	/*                                         <CJK> */,/* 5093 */
/* U+B2E6 */	0x812B	/*                                         <CJK> */,/* 5094 */
/* U+B2E7 */	0x8129	/*                                         <CJK> */,/* 5095 */
/* U+B2E8 */	0x8130	/*                                         <CJK> */,/* 5096 */
/* U+B2E9 */	0x8124	/*                                         <CJK> */,/* 5097 */
/* U+B2EA */	0x8202	/*                                         <CJK> */,/* 5098 */
/* U+B2EB */	0x8235	/*                                         <CJK> */,/* 5099 */
/* U+B2EC */	0x8237	/*                                         <CJK> */,/* 5100 */
/* U+B2ED */	0x8236	/*                                         <CJK> */,/* 5101 */
/* U+B2EE */	0x8239	/*                                         <CJK> */,/* 5102 */
/* U+B2EF */	0x838E	/*                                         <CJK> */,/* 5103 */
/* U+B2F0 */	0x839E	/*                                         <CJK> */,/* 5104 */
/* U+B2F1 */	0x8398	/*                                         <CJK> */,/* 5105 */
/* U+B2F2 */	0x8378	/*                                         <CJK> */,/* 5106 */
/* U+B2F3 */	0x83A2	/*                                         <CJK> */,/* 5107 */
/* U+B2F4 */	0x8396	/*                                         <CJK> */,/* 5108 */
/* U+B2F5 */	0x83BD	/*                                         <CJK> */,/* 5109 */
/* U+B2F6 */	0x83AB	/*                                         <CJK> */,/* 5110 */
/* U+B2F7 */	0x8392	/*                                         <CJK> */,/* 5111 */
/* U+B2F8 */	0x838A	/*                                         <CJK> */,/* 5112 */
/* U+B2F9 */	0x8393	/*                                         <CJK> */,/* 5113 */
/* U+B2FA */	0x8389	/*                                         <CJK> */,/* 5114 */
/* U+B2FB */	0x83A0	/*                                         <CJK> */,/* 5115 */
/* U+B2FC */	0x8377	/*                                         <CJK> */,/* 5116 */
/* U+B2FD */	0x837B	/*                                         <CJK> */,/* 5117 */
/* U+B2FE */	0x837C	/*                                         <CJK> */,/* 5118 */
/* U+B2FF */	UNICODE_REPLACEMENT_CHARACTER,	/* 5119 */
/* U+B300 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5120 */
/* U+B301 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5121 */
/* U+B302 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5122 */
/* U+B303 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5123 */
/* U+B304 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5124 */
/* U+B305 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5125 */
/* U+B306 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5126 */
/* U+B307 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5127 */
/* U+B308 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5128 */
/* U+B309 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5129 */
/* U+B30A */	UNICODE_REPLACEMENT_CHARACTER,	/* 5130 */
/* U+B30B */	UNICODE_REPLACEMENT_CHARACTER,	/* 5131 */
/* U+B30C */	UNICODE_REPLACEMENT_CHARACTER,	/* 5132 */
/* U+B30D */	UNICODE_REPLACEMENT_CHARACTER,	/* 5133 */
/* U+B30E */	UNICODE_REPLACEMENT_CHARACTER,	/* 5134 */
/* U+B30F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5135 */
/* U+B310 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5136 */
/* U+B311 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5137 */
/* U+B312 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5138 */
/* U+B313 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5139 */
/* U+B314 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5140 */
/* U+B315 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5141 */
/* U+B316 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5142 */
/* U+B317 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5143 */
/* U+B318 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5144 */
/* U+B319 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5145 */
/* U+B31A */	UNICODE_REPLACEMENT_CHARACTER,	/* 5146 */
/* U+B31B */	UNICODE_REPLACEMENT_CHARACTER,	/* 5147 */
/* U+B31C */	UNICODE_REPLACEMENT_CHARACTER,	/* 5148 */
/* U+B31D */	UNICODE_REPLACEMENT_CHARACTER,	/* 5149 */
/* U+B31E */	UNICODE_REPLACEMENT_CHARACTER,	/* 5150 */
/* U+B31F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5151 */
/* U+B320 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5152 */
/* U+B321 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5153 */
/* U+B322 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5154 */
/* U+B323 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5155 */
/* U+B324 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5156 */
/* U+B325 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5157 */
/* U+B326 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5158 */
/* U+B327 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5159 */
/* U+B328 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5160 */
/* U+B329 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5161 */
/* U+B32A */	UNICODE_REPLACEMENT_CHARACTER,	/* 5162 */
/* U+B32B */	UNICODE_REPLACEMENT_CHARACTER,	/* 5163 */
/* U+B32C */	UNICODE_REPLACEMENT_CHARACTER,	/* 5164 */
/* U+B32D */	UNICODE_REPLACEMENT_CHARACTER,	/* 5165 */
/* U+B32E */	UNICODE_REPLACEMENT_CHARACTER,	/* 5166 */
/* U+B32F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5167 */
/* U+B330 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5168 */
/* U+B331 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5169 */
/* U+B332 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5170 */
/* U+B333 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5171 */
/* U+B334 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5172 */
/* U+B335 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5173 */
/* U+B336 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5174 */
/* U+B337 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5175 */
/* U+B338 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5176 */
/* U+B339 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5177 */
/* U+B33A */	UNICODE_REPLACEMENT_CHARACTER,	/* 5178 */
/* U+B33B */	UNICODE_REPLACEMENT_CHARACTER,	/* 5179 */
/* U+B33C */	UNICODE_REPLACEMENT_CHARACTER,	/* 5180 */
/* U+B33D */	UNICODE_REPLACEMENT_CHARACTER,	/* 5181 */
/* U+B33E */	UNICODE_REPLACEMENT_CHARACTER,	/* 5182 */
/* U+B33F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5183 */
/* U+B340 */	0x8386	/*                                         <CJK> */,/* 5184 */
/* U+B341 */	0x83A7	/*                                         <CJK> */,/* 5185 */
/* U+B342 */	0x8655	/*                                         <CJK> */,/* 5186 */
/* U+B343 */	0x5F6A	/*                                         <CJK> */,/* 5187 */
/* U+B344 */	0x86C7	/*                                         <CJK> */,/* 5188 */
/* U+B345 */	0x86C0	/*                                         <CJK> */,/* 5189 */
/* U+B346 */	0x86B6	/*                                         <CJK> */,/* 5190 */
/* U+B347 */	0x86C4	/*                                         <CJK> */,/* 5191 */
/* U+B348 */	0x86B5	/*                                         <CJK> */,/* 5192 */
/* U+B349 */	0x86C6	/*                                         <CJK> */,/* 5193 */
/* U+B34A */	0x86CB	/*                                         <CJK> */,/* 5194 */
/* U+B34B */	0x86B1	/*                                         <CJK> */,/* 5195 */
/* U+B34C */	0x86AF	/*                                         <CJK> */,/* 5196 */
/* U+B34D */	0x86C9	/*                                         <CJK> */,/* 5197 */
/* U+B34E */	0x8853	/*                                         <CJK> */,/* 5198 */
/* U+B34F */	0x889E	/*                                         <CJK> */,/* 5199 */
/* U+B350 */	0x8888	/*                                         <CJK> */,/* 5200 */
/* U+B351 */	0x88AB	/*                                         <CJK> */,/* 5201 */
/* U+B352 */	0x8892	/*                                         <CJK> */,/* 5202 */
/* U+B353 */	0x8896	/*                                         <CJK> */,/* 5203 */
/* U+B354 */	0x888D	/*                                         <CJK> */,/* 5204 */
/* U+B355 */	0x888B	/*                                         <CJK> */,/* 5205 */
/* U+B356 */	0x8993	/*                                         <CJK> */,/* 5206 */
/* U+B357 */	0x898F	/*                                         <CJK> */,/* 5207 */
/* U+B358 */	0x8A2A	/*                                         <CJK> */,/* 5208 */
/* U+B359 */	0x8A1D	/*                                         <CJK> */,/* 5209 */
/* U+B35A */	0x8A23	/*                                         <CJK> */,/* 5210 */
/* U+B35B */	0x8A25	/*                                         <CJK> */,/* 5211 */
/* U+B35C */	0x8A31	/*                                         <CJK> */,/* 5212 */
/* U+B35D */	0x8A2D	/*                                         <CJK> */,/* 5213 */
/* U+B35E */	0x8A1F	/*                                         <CJK> */,/* 5214 */
/* U+B35F */	0x8A1B	/*                                         <CJK> */,/* 5215 */
/* U+B360 */	0x8A22	/*                                         <CJK> */,/* 5216 */
/* U+B361 */	0x8C49	/*                                         <CJK> */,/* 5217 */
/* U+B362 */	0x8C5A	/*                                         <CJK> */,/* 5218 */
/* U+B363 */	0x8CA9	/*                                         <CJK> */,/* 5219 */
/* U+B364 */	0x8CAC	/*                                         <CJK> */,/* 5220 */
/* U+B365 */	0x8CAB	/*                                         <CJK> */,/* 5221 */
/* U+B366 */	0x8CA8	/*                                         <CJK> */,/* 5222 */
/* U+B367 */	0x8CAA	/*                                         <CJK> */,/* 5223 */
/* U+B368 */	0x8CA7	/*                                         <CJK> */,/* 5224 */
/* U+B369 */	0x8D67	/*                                         <CJK> */,/* 5225 */
/* U+B36A */	0x8D66	/*                                         <CJK> */,/* 5226 */
/* U+B36B */	0x8DBE	/*                                         <CJK> */,/* 5227 */
/* U+B36C */	0x8DBA	/*                                         <CJK> */,/* 5228 */
/* U+B36D */	0x8EDB	/*                                         <CJK> */,/* 5229 */
/* U+B36E */	0x8EDF	/*                                         <CJK> */,/* 5230 */
/* U+B36F */	0x9019	/*                                         <CJK> */,/* 5231 */
/* U+B370 */	0x900D	/*                                         <CJK> */,/* 5232 */
/* U+B371 */	0x901A	/*                                         <CJK> */,/* 5233 */
/* U+B372 */	0x9017	/*                                         <CJK> */,/* 5234 */
/* U+B373 */	0x9023	/*                                         <CJK> */,/* 5235 */
/* U+B374 */	0x901F	/*                                         <CJK> */,/* 5236 */
/* U+B375 */	0x901D	/*                                         <CJK> */,/* 5237 */
/* U+B376 */	0x9010	/*                                         <CJK> */,/* 5238 */
/* U+B377 */	0x9015	/*                                         <CJK> */,/* 5239 */
/* U+B378 */	0x901E	/*                                         <CJK> */,/* 5240 */
/* U+B379 */	0x9020	/*                                         <CJK> */,/* 5241 */
/* U+B37A */	0x900F	/*                                         <CJK> */,/* 5242 */
/* U+B37B */	0x9022	/*                                         <CJK> */,/* 5243 */
/* U+B37C */	0x9016	/*                                         <CJK> */,/* 5244 */
/* U+B37D */	0x901B	/*                                         <CJK> */,/* 5245 */
/* U+B37E */	0x9014	/*                                         <CJK> */,/* 5246 */
/* U+B37F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5247 */
/* U+B380 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5248 */
/* U+B381 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5249 */
/* U+B382 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5250 */
/* U+B383 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5251 */
/* U+B384 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5252 */
/* U+B385 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5253 */
/* U+B386 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5254 */
/* U+B387 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5255 */
/* U+B388 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5256 */
/* U+B389 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5257 */
/* U+B38A */	UNICODE_REPLACEMENT_CHARACTER,	/* 5258 */
/* U+B38B */	UNICODE_REPLACEMENT_CHARACTER,	/* 5259 */
/* U+B38C */	UNICODE_REPLACEMENT_CHARACTER,	/* 5260 */
/* U+B38D */	UNICODE_REPLACEMENT_CHARACTER,	/* 5261 */
/* U+B38E */	UNICODE_REPLACEMENT_CHARACTER,	/* 5262 */
/* U+B38F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5263 */
/* U+B390 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5264 */
/* U+B391 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5265 */
/* U+B392 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5266 */
/* U+B393 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5267 */
/* U+B394 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5268 */
/* U+B395 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5269 */
/* U+B396 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5270 */
/* U+B397 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5271 */
/* U+B398 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5272 */
/* U+B399 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5273 */
/* U+B39A */	UNICODE_REPLACEMENT_CHARACTER,	/* 5274 */
/* U+B39B */	UNICODE_REPLACEMENT_CHARACTER,	/* 5275 */
/* U+B39C */	UNICODE_REPLACEMENT_CHARACTER,	/* 5276 */
/* U+B39D */	UNICODE_REPLACEMENT_CHARACTER,	/* 5277 */
/* U+B39E */	UNICODE_REPLACEMENT_CHARACTER,	/* 5278 */
/* U+B39F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5279 */
/* U+B3A0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5280 */
/* U+B3A1 */	0x90E8	/*                                         <CJK> */,/* 5281 */
/* U+B3A2 */	0x90ED	/*                                         <CJK> */,/* 5282 */
/* U+B3A3 */	0x90FD	/*                                         <CJK> */,/* 5283 */
/* U+B3A4 */	0x9157	/*                                         <CJK> */,/* 5284 */
/* U+B3A5 */	0x91CE	/*                                         <CJK> */,/* 5285 */
/* U+B3A6 */	0x91F5	/*                                         <CJK> */,/* 5286 */
/* U+B3A7 */	0x91E6	/*                                         <CJK> */,/* 5287 */
/* U+B3A8 */	0x91E3	/*                                         <CJK> */,/* 5288 */
/* U+B3A9 */	0x91E7	/*                                         <CJK> */,/* 5289 */
/* U+B3AA */	0x91ED	/*                                         <CJK> */,/* 5290 */
/* U+B3AB */	0x91E9	/*                                         <CJK> */,/* 5291 */
/* U+B3AC */	0x9589	/*                                         <CJK> */,/* 5292 */
/* U+B3AD */	0x966A	/*                                         <CJK> */,/* 5293 */
/* U+B3AE */	0x9675	/*                                         <CJK> */,/* 5294 */
/* U+B3AF */	0x9673	/*                                         <CJK> */,/* 5295 */
/* U+B3B0 */	0x9678	/*                                         <CJK> */,/* 5296 */
/* U+B3B1 */	0x9670	/*                                         <CJK> */,/* 5297 */
/* U+B3B2 */	0x9674	/*                                         <CJK> */,/* 5298 */
/* U+B3B3 */	0x9676	/*                                         <CJK> */,/* 5299 */
/* U+B3B4 */	0x9677	/*                                         <CJK> */,/* 5300 */
/* U+B3B5 */	0x966C	/*                                         <CJK> */,/* 5301 */
/* U+B3B6 */	0x96C0	/*                                         <CJK> */,/* 5302 */
/* U+B3B7 */	0x96EA	/*                                         <CJK> */,/* 5303 */
/* U+B3B8 */	0x96E9	/*                                         <CJK> */,/* 5304 */
/* U+B3B9 */	0x7AE0	/*                                         <CJK> */,/* 5305 */
/* U+B3BA */	0x7ADF	/*                                         <CJK> */,/* 5306 */
/* U+B3BB */	0x9802	/*                                         <CJK> */,/* 5307 */
/* U+B3BC */	0x9803	/*                                         <CJK> */,/* 5308 */
/* U+B3BD */	0x9B5A	/*                                         <CJK> */,/* 5309 */
/* U+B3BE */	0x9CE5	/*                                         <CJK> */,/* 5310 */
/* U+B3BF */	0x9E75	/*                                         <CJK> */,/* 5311 */
/* U+B3C0 */	0x9E7F	/*                                         <CJK> */,/* 5312 */
/* U+B3C1 */	0x9EA5	/*                                         <CJK> */,/* 5313 */
/* U+B3C2 */	0x9EBB	/*                                         <CJK> */,/* 5314 */
/* U+B3C3 */	0x50A2	/*                                         <CJK> */,/* 5315 */
/* U+B3C4 */	0x508D	/*                                         <CJK> */,/* 5316 */
/* U+B3C5 */	0x5085	/*                                         <CJK> */,/* 5317 */
/* U+B3C6 */	0x5099	/*                                         <CJK> */,/* 5318 */
/* U+B3C7 */	0x5091	/*                                         <CJK> */,/* 5319 */
/* U+B3C8 */	0x5080	/*                                         <CJK> */,/* 5320 */
/* U+B3C9 */	0x5096	/*                                         <CJK> */,/* 5321 */
/* U+B3CA */	0x5098	/*                                         <CJK> */,/* 5322 */
/* U+B3CB */	0x509A	/*                                         <CJK> */,/* 5323 */
/* U+B3CC */	0x6700	/*                                         <CJK> */,/* 5324 */
/* U+B3CD */	0x51F1	/*                                         <CJK> */,/* 5325 */
/* U+B3CE */	0x5272	/*                                         <CJK> */,/* 5326 */
/* U+B3CF */	0x5274	/*                                         <CJK> */,/* 5327 */
/* U+B3D0 */	0x5275	/*                                         <CJK> */,/* 5328 */
/* U+B3D1 */	0x5269	/*                                         <CJK> */,/* 5329 */
/* U+B3D2 */	0x52DE	/*                                         <CJK> */,/* 5330 */
/* U+B3D3 */	0x52DD	/*                                         <CJK> */,/* 5331 */
/* U+B3D4 */	0x52DB	/*                                         <CJK> */,/* 5332 */
/* U+B3D5 */	0x535A	/*                                         <CJK> */,/* 5333 */
/* U+B3D6 */	0x53A5	/*                                         <CJK> */,/* 5334 */
/* U+B3D7 */	0x557B	/*                                         <CJK> */,/* 5335 */
/* U+B3D8 */	0x5580	/*                                         <CJK> */,/* 5336 */
/* U+B3D9 */	0x55A7	/*                                         <CJK> */,/* 5337 */
/* U+B3DA */	0x557C	/*                                         <CJK> */,/* 5338 */
/* U+B3DB */	0x558A	/*                                         <CJK> */,/* 5339 */
/* U+B3DC */	0x559D	/*                                         <CJK> */,/* 5340 */
/* U+B3DD */	0x5598	/*                                         <CJK> */,/* 5341 */
/* U+B3DE */	0x5582	/*                                         <CJK> */,/* 5342 */
/* U+B3DF */	0x559C	/*                                         <CJK> */,/* 5343 */
/* U+B3E0 */	0x55AA	/*                                         <CJK> */,/* 5344 */
/* U+B3E1 */	0x5594	/*                                         <CJK> */,/* 5345 */
/* U+B3E2 */	0x5587	/*                                         <CJK> */,/* 5346 */
/* U+B3E3 */	0x558B	/*                                         <CJK> */,/* 5347 */
/* U+B3E4 */	0x5583	/*                                         <CJK> */,/* 5348 */
/* U+B3E5 */	0x55B3	/*                                         <CJK> */,/* 5349 */
/* U+B3E6 */	0x55AE	/*                                         <CJK> */,/* 5350 */
/* U+B3E7 */	0x559F	/*                                         <CJK> */,/* 5351 */
/* U+B3E8 */	0x553E	/*                                         <CJK> */,/* 5352 */
/* U+B3E9 */	0x55B2	/*                                         <CJK> */,/* 5353 */
/* U+B3EA */	0x559A	/*                                         <CJK> */,/* 5354 */
/* U+B3EB */	0x55BB	/*                                         <CJK> */,/* 5355 */
/* U+B3EC */	0x55AC	/*                                         <CJK> */,/* 5356 */
/* U+B3ED */	0x55B1	/*                                         <CJK> */,/* 5357 */
/* U+B3EE */	0x557E	/*                                         <CJK> */,/* 5358 */
/* U+B3EF */	0x5589	/*                                         <CJK> */,/* 5359 */
/* U+B3F0 */	0x55AB	/*                                         <CJK> */,/* 5360 */
/* U+B3F1 */	0x5599	/*                                         <CJK> */,/* 5361 */
/* U+B3F2 */	0x570D	/*                                         <CJK> */,/* 5362 */
/* U+B3F3 */	0x582F	/*                                         <CJK> */,/* 5363 */
/* U+B3F4 */	0x582A	/*                                         <CJK> */,/* 5364 */
/* U+B3F5 */	0x5834	/*                                         <CJK> */,/* 5365 */
/* U+B3F6 */	0x5824	/*                                         <CJK> */,/* 5366 */
/* U+B3F7 */	0x5830	/*                                         <CJK> */,/* 5367 */
/* U+B3F8 */	0x5831	/*                                         <CJK> */,/* 5368 */
/* U+B3F9 */	0x5821	/*                                         <CJK> */,/* 5369 */
/* U+B3FA */	0x581D	/*                                         <CJK> */,/* 5370 */
/* U+B3FB */	0x5820	/*                                         <CJK> */,/* 5371 */
/* U+B3FC */	0x58F9	/*                                         <CJK> */,/* 5372 */
/* U+B3FD */	0x58FA	/*                                         <CJK> */,/* 5373 */
/* U+B3FE */	0x5960	/*                                         <CJK> */,/* 5374 */
/* U+B3FF */	UNICODE_REPLACEMENT_CHARACTER,	/* 5375 */
/* U+B400 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5376 */
/* U+B401 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5377 */
/* U+B402 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5378 */
/* U+B403 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5379 */
/* U+B404 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5380 */
/* U+B405 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5381 */
/* U+B406 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5382 */
/* U+B407 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5383 */
/* U+B408 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5384 */
/* U+B409 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5385 */
/* U+B40A */	UNICODE_REPLACEMENT_CHARACTER,	/* 5386 */
/* U+B40B */	UNICODE_REPLACEMENT_CHARACTER,	/* 5387 */
/* U+B40C */	UNICODE_REPLACEMENT_CHARACTER,	/* 5388 */
/* U+B40D */	UNICODE_REPLACEMENT_CHARACTER,	/* 5389 */
/* U+B40E */	UNICODE_REPLACEMENT_CHARACTER,	/* 5390 */
/* U+B40F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5391 */
/* U+B410 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5392 */
/* U+B411 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5393 */
/* U+B412 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5394 */
/* U+B413 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5395 */
/* U+B414 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5396 */
/* U+B415 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5397 */
/* U+B416 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5398 */
/* U+B417 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5399 */
/* U+B418 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5400 */
/* U+B419 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5401 */
/* U+B41A */	UNICODE_REPLACEMENT_CHARACTER,	/* 5402 */
/* U+B41B */	UNICODE_REPLACEMENT_CHARACTER,	/* 5403 */
/* U+B41C */	UNICODE_REPLACEMENT_CHARACTER,	/* 5404 */
/* U+B41D */	UNICODE_REPLACEMENT_CHARACTER,	/* 5405 */
/* U+B41E */	UNICODE_REPLACEMENT_CHARACTER,	/* 5406 */
/* U+B41F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5407 */
/* U+B420 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5408 */
/* U+B421 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5409 */
/* U+B422 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5410 */
/* U+B423 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5411 */
/* U+B424 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5412 */
/* U+B425 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5413 */
/* U+B426 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5414 */
/* U+B427 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5415 */
/* U+B428 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5416 */
/* U+B429 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5417 */
/* U+B42A */	UNICODE_REPLACEMENT_CHARACTER,	/* 5418 */
/* U+B42B */	UNICODE_REPLACEMENT_CHARACTER,	/* 5419 */
/* U+B42C */	UNICODE_REPLACEMENT_CHARACTER,	/* 5420 */
/* U+B42D */	UNICODE_REPLACEMENT_CHARACTER,	/* 5421 */
/* U+B42E */	UNICODE_REPLACEMENT_CHARACTER,	/* 5422 */
/* U+B42F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5423 */
/* U+B430 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5424 */
/* U+B431 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5425 */
/* U+B432 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5426 */
/* U+B433 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5427 */
/* U+B434 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5428 */
/* U+B435 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5429 */
/* U+B436 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5430 */
/* U+B437 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5431 */
/* U+B438 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5432 */
/* U+B439 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5433 */
/* U+B43A */	UNICODE_REPLACEMENT_CHARACTER,	/* 5434 */
/* U+B43B */	UNICODE_REPLACEMENT_CHARACTER,	/* 5435 */
/* U+B43C */	UNICODE_REPLACEMENT_CHARACTER,	/* 5436 */
/* U+B43D */	UNICODE_REPLACEMENT_CHARACTER,	/* 5437 */
/* U+B43E */	UNICODE_REPLACEMENT_CHARACTER,	/* 5438 */
/* U+B43F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5439 */
/* U+B440 */	0x5A77	/*                                         <CJK> */,/* 5440 */
/* U+B441 */	0x5A9A	/*                                         <CJK> */,/* 5441 */
/* U+B442 */	0x5A7F	/*                                         <CJK> */,/* 5442 */
/* U+B443 */	0x5A92	/*                                         <CJK> */,/* 5443 */
/* U+B444 */	0x5A9B	/*                                         <CJK> */,/* 5444 */
/* U+B445 */	0x5AA7	/*                                         <CJK> */,/* 5445 */
/* U+B446 */	0x5B73	/*                                         <CJK> */,/* 5446 */
/* U+B447 */	0x5B71	/*                                         <CJK> */,/* 5447 */
/* U+B448 */	0x5BD2	/*                                         <CJK> */,/* 5448 */
/* U+B449 */	0x5BCC	/*                                         <CJK> */,/* 5449 */
/* U+B44A */	0x5BD3	/*                                         <CJK> */,/* 5450 */
/* U+B44B */	0x5BD0	/*                                         <CJK> */,/* 5451 */
/* U+B44C */	0x5C0A	/*                                         <CJK> */,/* 5452 */
/* U+B44D */	0x5C0B	/*                                         <CJK> */,/* 5453 */
/* U+B44E */	0x5C31	/*                                         <CJK> */,/* 5454 */
/* U+B44F */	0x5D4C	/*                                         <CJK> */,/* 5455 */
/* U+B450 */	0x5D50	/*                                         <CJK> */,/* 5456 */
/* U+B451 */	0x5D34	/*                                         <CJK> */,/* 5457 */
/* U+B452 */	0x5D47	/*                                         <CJK> */,/* 5458 */
/* U+B453 */	0x5DFD	/*                                         <CJK> */,/* 5459 */
/* U+B454 */	0x5E45	/*                                         <CJK> */,/* 5460 */
/* U+B455 */	0x5E3D	/*                                         <CJK> */,/* 5461 */
/* U+B456 */	0x5E40	/*                                         <CJK> */,/* 5462 */
/* U+B457 */	0x5E43	/*                                         <CJK> */,/* 5463 */
/* U+B458 */	0x5E7E	/*                                         <CJK> */,/* 5464 */
/* U+B459 */	0x5ECA	/*                                         <CJK> */,/* 5465 */
/* U+B45A */	0x5EC1	/*                                         <CJK> */,/* 5466 */
/* U+B45B */	0x5EC2	/*                                         <CJK> */,/* 5467 */
/* U+B45C */	0x5EC4	/*                                         <CJK> */,/* 5468 */
/* U+B45D */	0x5F3C	/*                                         <CJK> */,/* 5469 */
/* U+B45E */	0x5F6D	/*                                         <CJK> */,/* 5470 */
/* U+B45F */	0x5FA9	/*                                         <CJK> */,/* 5471 */
/* U+B460 */	0x5FAA	/*                                         <CJK> */,/* 5472 */
/* U+B461 */	0x5FA8	/*                                         <CJK> */,/* 5473 */
/* U+B462 */	0x60D1	/*                                         <CJK> */,/* 5474 */
/* U+B463 */	0x60E1	/*                                         <CJK> */,/* 5475 */
/* U+B464 */	0x60B2	/*                                         <CJK> */,/* 5476 */
/* U+B465 */	0x60B6	/*                                         <CJK> */,/* 5477 */
/* U+B466 */	0x60E0	/*                                         <CJK> */,/* 5478 */
/* U+B467 */	0x611C	/*                                         <CJK> */,/* 5479 */
/* U+B468 */	0x6123	/*                                         <CJK> */,/* 5480 */
/* U+B469 */	0x60FA	/*                                         <CJK> */,/* 5481 */
/* U+B46A */	0x6115	/*                                         <CJK> */,/* 5482 */
/* U+B46B */	0x60F0	/*                                         <CJK> */,/* 5483 */
/* U+B46C */	0x60FB	/*                                         <CJK> */,/* 5484 */
/* U+B46D */	0x60F4	/*                                         <CJK> */,/* 5485 */
/* U+B46E */	0x6168	/*                                         <CJK> */,/* 5486 */
/* U+B46F */	0x60F1	/*                                         <CJK> */,/* 5487 */
/* U+B470 */	0x610E	/*                                         <CJK> */,/* 5488 */
/* U+B471 */	0x60F6	/*                                         <CJK> */,/* 5489 */
/* U+B472 */	0x6109	/*                                         <CJK> */,/* 5490 */
/* U+B473 */	0x6100	/*                                         <CJK> */,/* 5491 */
/* U+B474 */	0x6112	/*                                         <CJK> */,/* 5492 */
/* U+B475 */	0x621F	/*                                         <CJK> */,/* 5493 */
/* U+B476 */	0x6249	/*                                         <CJK> */,/* 5494 */
/* U+B477 */	0x63A3	/*                                         <CJK> */,/* 5495 */
/* U+B478 */	0x638C	/*                                         <CJK> */,/* 5496 */
/* U+B479 */	0x63CF	/*                                         <CJK> */,/* 5497 */
/* U+B47A */	0x63C0	/*                                         <CJK> */,/* 5498 */
/* U+B47B */	0x63E9	/*                                         <CJK> */,/* 5499 */
/* U+B47C */	0x63C9	/*                                         <CJK> */,/* 5500 */
/* U+B47D */	0x63C6	/*                                         <CJK> */,/* 5501 */
/* U+B47E */	0x63CD	/*                                         <CJK> */,/* 5502 */
/* U+B47F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5503 */
/* U+B480 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5504 */
/* U+B481 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5505 */
/* U+B482 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5506 */
/* U+B483 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5507 */
/* U+B484 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5508 */
/* U+B485 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5509 */
/* U+B486 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5510 */
/* U+B487 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5511 */
/* U+B488 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5512 */
/* U+B489 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5513 */
/* U+B48A */	UNICODE_REPLACEMENT_CHARACTER,	/* 5514 */
/* U+B48B */	UNICODE_REPLACEMENT_CHARACTER,	/* 5515 */
/* U+B48C */	UNICODE_REPLACEMENT_CHARACTER,	/* 5516 */
/* U+B48D */	UNICODE_REPLACEMENT_CHARACTER,	/* 5517 */
/* U+B48E */	UNICODE_REPLACEMENT_CHARACTER,	/* 5518 */
/* U+B48F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5519 */
/* U+B490 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5520 */
/* U+B491 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5521 */
/* U+B492 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5522 */
/* U+B493 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5523 */
/* U+B494 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5524 */
/* U+B495 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5525 */
/* U+B496 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5526 */
/* U+B497 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5527 */
/* U+B498 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5528 */
/* U+B499 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5529 */
/* U+B49A */	UNICODE_REPLACEMENT_CHARACTER,	/* 5530 */
/* U+B49B */	UNICODE_REPLACEMENT_CHARACTER,	/* 5531 */
/* U+B49C */	UNICODE_REPLACEMENT_CHARACTER,	/* 5532 */
/* U+B49D */	UNICODE_REPLACEMENT_CHARACTER,	/* 5533 */
/* U+B49E */	UNICODE_REPLACEMENT_CHARACTER,	/* 5534 */
/* U+B49F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5535 */
/* U+B4A0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5536 */
/* U+B4A1 */	0x63D2	/*                                         <CJK> */,/* 5537 */
/* U+B4A2 */	0x63E3	/*                                         <CJK> */,/* 5538 */
/* U+B4A3 */	0x63D0	/*                                         <CJK> */,/* 5539 */
/* U+B4A4 */	0x63E1	/*                                         <CJK> */,/* 5540 */
/* U+B4A5 */	0x63D6	/*                                         <CJK> */,/* 5541 */
/* U+B4A6 */	0x63ED	/*                                         <CJK> */,/* 5542 */
/* U+B4A7 */	0x63EE	/*                                         <CJK> */,/* 5543 */
/* U+B4A8 */	0x6376	/*                                         <CJK> */,/* 5544 */
/* U+B4A9 */	0x63F4	/*                                         <CJK> */,/* 5545 */
/* U+B4AA */	0x63EA	/*                                         <CJK> */,/* 5546 */
/* U+B4AB */	0x63DB	/*                                         <CJK> */,/* 5547 */
/* U+B4AC */	0x6452	/*                                         <CJK> */,/* 5548 */
/* U+B4AD */	0x63DA	/*                                         <CJK> */,/* 5549 */
/* U+B4AE */	0x63F9	/*                                         <CJK> */,/* 5550 */
/* U+B4AF */	0x655E	/*                                         <CJK> */,/* 5551 */
/* U+B4B0 */	0x6566	/*                                         <CJK> */,/* 5552 */
/* U+B4B1 */	0x6562	/*                                         <CJK> */,/* 5553 */
/* U+B4B2 */	0x6563	/*                                         <CJK> */,/* 5554 */
/* U+B4B3 */	0x6591	/*                                         <CJK> */,/* 5555 */
/* U+B4B4 */	0x6590	/*                                         <CJK> */,/* 5556 */
/* U+B4B5 */	0x65AF	/*                                         <CJK> */,/* 5557 */
/* U+B4B6 */	0x666E	/*                                         <CJK> */,/* 5558 */
/* U+B4B7 */	0x6670	/*                                         <CJK> */,/* 5559 */
/* U+B4B8 */	0x6674	/*                                         <CJK> */,/* 5560 */
/* U+B4B9 */	0x6676	/*                                         <CJK> */,/* 5561 */
/* U+B4BA */	0x666F	/*                                         <CJK> */,/* 5562 */
/* U+B4BB */	0x6691	/*                                         <CJK> */,/* 5563 */
/* U+B4BC */	0x667A	/*                                         <CJK> */,/* 5564 */
/* U+B4BD */	0x667E	/*                                         <CJK> */,/* 5565 */
/* U+B4BE */	0x6677	/*                                         <CJK> */,/* 5566 */
/* U+B4BF */	0x66FE	/*                                         <CJK> */,/* 5567 */
/* U+B4C0 */	0x66FF	/*                                         <CJK> */,/* 5568 */
/* U+B4C1 */	0x671F	/*                                         <CJK> */,/* 5569 */
/* U+B4C2 */	0x671D	/*                                         <CJK> */,/* 5570 */
/* U+B4C3 */	0x68FA	/*                                         <CJK> */,/* 5571 */
/* U+B4C4 */	0x68D5	/*                                         <CJK> */,/* 5572 */
/* U+B4C5 */	0x68E0	/*                                         <CJK> */,/* 5573 */
/* U+B4C6 */	0x68D8	/*                                         <CJK> */,/* 5574 */
/* U+B4C7 */	0x68D7	/*                                         <CJK> */,/* 5575 */
/* U+B4C8 */	0x6905	/*                                         <CJK> */,/* 5576 */
/* U+B4C9 */	0x68DF	/*                                         <CJK> */,/* 5577 */
/* U+B4CA */	0x68F5	/*                                         <CJK> */,/* 5578 */
/* U+B4CB */	0x68EE	/*                                         <CJK> */,/* 5579 */
/* U+B4CC */	0x68E7	/*                                         <CJK> */,/* 5580 */
/* U+B4CD */	0x68F9	/*                                         <CJK> */,/* 5581 */
/* U+B4CE */	0x68D2	/*                                         <CJK> */,/* 5582 */
/* U+B4CF */	0x68F2	/*                                         <CJK> */,/* 5583 */
/* U+B4D0 */	0x68E3	/*                                         <CJK> */,/* 5584 */
/* U+B4D1 */	0x68CB	/*                                         <CJK> */,/* 5585 */
/* U+B4D2 */	0x68CD	/*                                         <CJK> */,/* 5586 */
/* U+B4D3 */	0x690D	/*                                         <CJK> */,/* 5587 */
/* U+B4D4 */	0x6912	/*                                         <CJK> */,/* 5588 */
/* U+B4D5 */	0x690E	/*                                         <CJK> */,/* 5589 */
/* U+B4D6 */	0x68C9	/*                                         <CJK> */,/* 5590 */
/* U+B4D7 */	0x68DA	/*                                         <CJK> */,/* 5591 */
/* U+B4D8 */	0x696E	/*                                         <CJK> */,/* 5592 */
/* U+B4D9 */	0x68FB	/*                                         <CJK> */,/* 5593 */
/* U+B4DA */	0x6B3E	/*                                         <CJK> */,/* 5594 */
/* U+B4DB */	0x6B3A	/*                                         <CJK> */,/* 5595 */
/* U+B4DC */	0x6B3D	/*                                         <CJK> */,/* 5596 */
/* U+B4DD */	0x6B98	/*                                         <CJK> */,/* 5597 */
/* U+B4DE */	0x6B96	/*                                         <CJK> */,/* 5598 */
/* U+B4DF */	0x6BBC	/*                                         <CJK> */,/* 5599 */
/* U+B4E0 */	0x6BEF	/*                                         <CJK> */,/* 5600 */
/* U+B4E1 */	0x6C2E	/*                                         <CJK> */,/* 5601 */
/* U+B4E2 */	0x6C2F	/*                                         <CJK> */,/* 5602 */
/* U+B4E3 */	0x6C2C	/*                                         <CJK> */,/* 5603 */
/* U+B4E4 */	0x6E2F	/*                                         <CJK> */,/* 5604 */
/* U+B4E5 */	0x6E38	/*                                         <CJK> */,/* 5605 */
/* U+B4E6 */	0x6E54	/*                                         <CJK> */,/* 5606 */
/* U+B4E7 */	0x6E21	/*                                         <CJK> */,/* 5607 */
/* U+B4E8 */	0x6E32	/*                                         <CJK> */,/* 5608 */
/* U+B4E9 */	0x6E67	/*                                         <CJK> */,/* 5609 */
/* U+B4EA */	0x6E4A	/*                                         <CJK> */,/* 5610 */
/* U+B4EB */	0x6E20	/*                                         <CJK> */,/* 5611 */
/* U+B4EC */	0x6E25	/*                                         <CJK> */,/* 5612 */
/* U+B4ED */	0x6E23	/*                                         <CJK> */,/* 5613 */
/* U+B4EE */	0x6E1B	/*                                         <CJK> */,/* 5614 */
/* U+B4EF */	0x6E5B	/*                                         <CJK> */,/* 5615 */
/* U+B4F0 */	0x6E58	/*                                         <CJK> */,/* 5616 */
/* U+B4F1 */	0x6E24	/*                                         <CJK> */,/* 5617 */
/* U+B4F2 */	0x6E56	/*                                         <CJK> */,/* 5618 */
/* U+B4F3 */	0x6E6E	/*                                         <CJK> */,/* 5619 */
/* U+B4F4 */	0x6E2D	/*                                         <CJK> */,/* 5620 */
/* U+B4F5 */	0x6E26	/*                                         <CJK> */,/* 5621 */
/* U+B4F6 */	0x6E6F	/*                                         <CJK> */,/* 5622 */
/* U+B4F7 */	0x6E34	/*                                         <CJK> */,/* 5623 */
/* U+B4F8 */	0x6E4D	/*                                         <CJK> */,/* 5624 */
/* U+B4F9 */	0x6E3A	/*                                         <CJK> */,/* 5625 */
/* U+B4FA */	0x6E2C	/*                                         <CJK> */,/* 5626 */
/* U+B4FB */	0x6E43	/*                                         <CJK> */,/* 5627 */
/* U+B4FC */	0x6E1D	/*                                         <CJK> */,/* 5628 */
/* U+B4FD */	0x6E3E	/*                                         <CJK> */,/* 5629 */
/* U+B4FE */	0x6ECB	/*                                         <CJK> */,/* 5630 */
/* U+B4FF */	UNICODE_REPLACEMENT_CHARACTER,	/* 5631 */
/* U+B500 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5632 */
/* U+B501 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5633 */
/* U+B502 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5634 */
/* U+B503 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5635 */
/* U+B504 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5636 */
/* U+B505 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5637 */
/* U+B506 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5638 */
/* U+B507 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5639 */
/* U+B508 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5640 */
/* U+B509 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5641 */
/* U+B50A */	UNICODE_REPLACEMENT_CHARACTER,	/* 5642 */
/* U+B50B */	UNICODE_REPLACEMENT_CHARACTER,	/* 5643 */
/* U+B50C */	UNICODE_REPLACEMENT_CHARACTER,	/* 5644 */
/* U+B50D */	UNICODE_REPLACEMENT_CHARACTER,	/* 5645 */
/* U+B50E */	UNICODE_REPLACEMENT_CHARACTER,	/* 5646 */
/* U+B50F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5647 */
/* U+B510 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5648 */
/* U+B511 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5649 */
/* U+B512 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5650 */
/* U+B513 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5651 */
/* U+B514 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5652 */
/* U+B515 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5653 */
/* U+B516 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5654 */
/* U+B517 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5655 */
/* U+B518 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5656 */
/* U+B519 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5657 */
/* U+B51A */	UNICODE_REPLACEMENT_CHARACTER,	/* 5658 */
/* U+B51B */	UNICODE_REPLACEMENT_CHARACTER,	/* 5659 */
/* U+B51C */	UNICODE_REPLACEMENT_CHARACTER,	/* 5660 */
/* U+B51D */	UNICODE_REPLACEMENT_CHARACTER,	/* 5661 */
/* U+B51E */	UNICODE_REPLACEMENT_CHARACTER,	/* 5662 */
/* U+B51F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5663 */
/* U+B520 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5664 */
/* U+B521 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5665 */
/* U+B522 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5666 */
/* U+B523 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5667 */
/* U+B524 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5668 */
/* U+B525 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5669 */
/* U+B526 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5670 */
/* U+B527 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5671 */
/* U+B528 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5672 */
/* U+B529 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5673 */
/* U+B52A */	UNICODE_REPLACEMENT_CHARACTER,	/* 5674 */
/* U+B52B */	UNICODE_REPLACEMENT_CHARACTER,	/* 5675 */
/* U+B52C */	UNICODE_REPLACEMENT_CHARACTER,	/* 5676 */
/* U+B52D */	UNICODE_REPLACEMENT_CHARACTER,	/* 5677 */
/* U+B52E */	UNICODE_REPLACEMENT_CHARACTER,	/* 5678 */
/* U+B52F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5679 */
/* U+B530 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5680 */
/* U+B531 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5681 */
/* U+B532 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5682 */
/* U+B533 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5683 */
/* U+B534 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5684 */
/* U+B535 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5685 */
/* U+B536 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5686 */
/* U+B537 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5687 */
/* U+B538 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5688 */
/* U+B539 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5689 */
/* U+B53A */	UNICODE_REPLACEMENT_CHARACTER,	/* 5690 */
/* U+B53B */	UNICODE_REPLACEMENT_CHARACTER,	/* 5691 */
/* U+B53C */	UNICODE_REPLACEMENT_CHARACTER,	/* 5692 */
/* U+B53D */	UNICODE_REPLACEMENT_CHARACTER,	/* 5693 */
/* U+B53E */	UNICODE_REPLACEMENT_CHARACTER,	/* 5694 */
/* U+B53F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5695 */
/* U+B540 */	0x6E89	/*                                         <CJK> */,/* 5696 */
/* U+B541 */	0x6E19	/*                                         <CJK> */,/* 5697 */
/* U+B542 */	0x6E4E	/*                                         <CJK> */,/* 5698 */
/* U+B543 */	0x6E63	/*                                         <CJK> */,/* 5699 */
/* U+B544 */	0x6E44	/*                                         <CJK> */,/* 5700 */
/* U+B545 */	0x6E72	/*                                         <CJK> */,/* 5701 */
/* U+B546 */	0x6E69	/*                                         <CJK> */,/* 5702 */
/* U+B547 */	0x6E5F	/*                                         <CJK> */,/* 5703 */
/* U+B548 */	0x7119	/*                                         <CJK> */,/* 5704 */
/* U+B549 */	0x711A	/*                                         <CJK> */,/* 5705 */
/* U+B54A */	0x7126	/*                                         <CJK> */,/* 5706 */
/* U+B54B */	0x7130	/*                                         <CJK> */,/* 5707 */
/* U+B54C */	0x7121	/*                                         <CJK> */,/* 5708 */
/* U+B54D */	0x7136	/*                                         <CJK> */,/* 5709 */
/* U+B54E */	0x716E	/*                                         <CJK> */,/* 5710 */
/* U+B54F */	0x711C	/*                                         <CJK> */,/* 5711 */
/* U+B550 */	0x724C	/*                                         <CJK> */,/* 5712 */
/* U+B551 */	0x7284	/*                                         <CJK> */,/* 5713 */
/* U+B552 */	0x7280	/*                                         <CJK> */,/* 5714 */
/* U+B553 */	0x7336	/*                                         <CJK> */,/* 5715 */
/* U+B554 */	0x7325	/*                                         <CJK> */,/* 5716 */
/* U+B555 */	0x7334	/*                                         <CJK> */,/* 5717 */
/* U+B556 */	0x7329	/*                                         <CJK> */,/* 5718 */
/* U+B557 */	0x743A	/*                                         <CJK> */,/* 5719 */
/* U+B558 */	0x742A	/*                                         <CJK> */,/* 5720 */
/* U+B559 */	0x7433	/*                                         <CJK> */,/* 5721 */
/* U+B55A */	0x7422	/*                                         <CJK> */,/* 5722 */
/* U+B55B */	0x7425	/*                                         <CJK> */,/* 5723 */
/* U+B55C */	0x7435	/*                                         <CJK> */,/* 5724 */
/* U+B55D */	0x7436	/*                                         <CJK> */,/* 5725 */
/* U+B55E */	0x7434	/*                                         <CJK> */,/* 5726 */
/* U+B55F */	0x742F	/*                                         <CJK> */,/* 5727 */
/* U+B560 */	0x741B	/*                                         <CJK> */,/* 5728 */
/* U+B561 */	0x7426	/*                                         <CJK> */,/* 5729 */
/* U+B562 */	0x7428	/*                                         <CJK> */,/* 5730 */
/* U+B563 */	0x7525	/*                                         <CJK> */,/* 5731 */
/* U+B564 */	0x7526	/*                                         <CJK> */,/* 5732 */
/* U+B565 */	0x756B	/*                                         <CJK> */,/* 5733 */
/* U+B566 */	0x756A	/*                                         <CJK> */,/* 5734 */
/* U+B567 */	0x75E2	/*                                         <CJK> */,/* 5735 */
/* U+B568 */	0x75DB	/*                                         <CJK> */,/* 5736 */
/* U+B569 */	0x75E3	/*                                         <CJK> */,/* 5737 */
/* U+B56A */	0x75D9	/*                                         <CJK> */,/* 5738 */
/* U+B56B */	0x75D8	/*                                         <CJK> */,/* 5739 */
/* U+B56C */	0x75DE	/*                                         <CJK> */,/* 5740 */
/* U+B56D */	0x75E0	/*                                         <CJK> */,/* 5741 */
/* U+B56E */	0x767B	/*                                         <CJK> */,/* 5742 */
/* U+B56F */	0x767C	/*                                         <CJK> */,/* 5743 */
/* U+B570 */	0x7696	/*                                         <CJK> */,/* 5744 */
/* U+B571 */	0x7693	/*                                         <CJK> */,/* 5745 */
/* U+B572 */	0x76B4	/*                                         <CJK> */,/* 5746 */
/* U+B573 */	0x76DC	/*                                         <CJK> */,/* 5747 */
/* U+B574 */	0x774F	/*                                         <CJK> */,/* 5748 */
/* U+B575 */	0x77ED	/*                                         <CJK> */,/* 5749 */
/* U+B576 */	0x785D	/*                                         <CJK> */,/* 5750 */
/* U+B577 */	0x786C	/*                                         <CJK> */,/* 5751 */
/* U+B578 */	0x786F	/*                                         <CJK> */,/* 5752 */
/* U+B579 */	0x7A0D	/*                                         <CJK> */,/* 5753 */
/* U+B57A */	0x7A08	/*                                         <CJK> */,/* 5754 */
/* U+B57B */	0x7A0B	/*                                         <CJK> */,/* 5755 */
/* U+B57C */	0x7A05	/*                                         <CJK> */,/* 5756 */
/* U+B57D */	0x7A00	/*                                         <CJK> */,/* 5757 */
/* U+B57E */	0x7A98	/*                                         <CJK> */,/* 5758 */
/* U+B57F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5759 */
/* U+B580 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5760 */
/* U+B581 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5761 */
/* U+B582 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5762 */
/* U+B583 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5763 */
/* U+B584 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5764 */
/* U+B585 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5765 */
/* U+B586 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5766 */
/* U+B587 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5767 */
/* U+B588 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5768 */
/* U+B589 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5769 */
/* U+B58A */	UNICODE_REPLACEMENT_CHARACTER,	/* 5770 */
/* U+B58B */	UNICODE_REPLACEMENT_CHARACTER,	/* 5771 */
/* U+B58C */	UNICODE_REPLACEMENT_CHARACTER,	/* 5772 */
/* U+B58D */	UNICODE_REPLACEMENT_CHARACTER,	/* 5773 */
/* U+B58E */	UNICODE_REPLACEMENT_CHARACTER,	/* 5774 */
/* U+B58F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5775 */
/* U+B590 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5776 */
/* U+B591 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5777 */
/* U+B592 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5778 */
/* U+B593 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5779 */
/* U+B594 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5780 */
/* U+B595 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5781 */
/* U+B596 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5782 */
/* U+B597 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5783 */
/* U+B598 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5784 */
/* U+B599 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5785 */
/* U+B59A */	UNICODE_REPLACEMENT_CHARACTER,	/* 5786 */
/* U+B59B */	UNICODE_REPLACEMENT_CHARACTER,	/* 5787 */
/* U+B59C */	UNICODE_REPLACEMENT_CHARACTER,	/* 5788 */
/* U+B59D */	UNICODE_REPLACEMENT_CHARACTER,	/* 5789 */
/* U+B59E */	UNICODE_REPLACEMENT_CHARACTER,	/* 5790 */
/* U+B59F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5791 */
/* U+B5A0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5792 */
/* U+B5A1 */	0x7A97	/*                                         <CJK> */,/* 5793 */
/* U+B5A2 */	0x7A96	/*                                         <CJK> */,/* 5794 */
/* U+B5A3 */	0x7AE5	/*                                         <CJK> */,/* 5795 */
/* U+B5A4 */	0x7AE3	/*                                         <CJK> */,/* 5796 */
/* U+B5A5 */	0x7B49	/*                                         <CJK> */,/* 5797 */
/* U+B5A6 */	0x7B56	/*                                         <CJK> */,/* 5798 */
/* U+B5A7 */	0x7B46	/*                                         <CJK> */,/* 5799 */
/* U+B5A8 */	0x7B50	/*                                         <CJK> */,/* 5800 */
/* U+B5A9 */	0x7B52	/*                                         <CJK> */,/* 5801 */
/* U+B5AA */	0x7B54	/*                                         <CJK> */,/* 5802 */
/* U+B5AB */	0x7B4D	/*                                         <CJK> */,/* 5803 */
/* U+B5AC */	0x7B4B	/*                                         <CJK> */,/* 5804 */
/* U+B5AD */	0x7B4F	/*                                         <CJK> */,/* 5805 */
/* U+B5AE */	0x7B51	/*                                         <CJK> */,/* 5806 */
/* U+B5AF */	0x7C9F	/*                                         <CJK> */,/* 5807 */
/* U+B5B0 */	0x7CA5	/*                                         <CJK> */,/* 5808 */
/* U+B5B1 */	0x7D5E	/*                                         <CJK> */,/* 5809 */
/* U+B5B2 */	0x7D50	/*                                         <CJK> */,/* 5810 */
/* U+B5B3 */	0x7D68	/*                                         <CJK> */,/* 5811 */
/* U+B5B4 */	0x7D55	/*                                         <CJK> */,/* 5812 */
/* U+B5B5 */	0x7D2B	/*                                         <CJK> */,/* 5813 */
/* U+B5B6 */	0x7D6E	/*                                         <CJK> */,/* 5814 */
/* U+B5B7 */	0x7D72	/*                                         <CJK> */,/* 5815 */
/* U+B5B8 */	0x7D61	/*                                         <CJK> */,/* 5816 */
/* U+B5B9 */	0x7D66	/*                                         <CJK> */,/* 5817 */
/* U+B5BA */	0x7D62	/*                                         <CJK> */,/* 5818 */
/* U+B5BB */	0x7D70	/*                                         <CJK> */,/* 5819 */
/* U+B5BC */	0x7D73	/*                                         <CJK> */,/* 5820 */
/* U+B5BD */	0x5584	/*                                         <CJK> */,/* 5821 */
/* U+B5BE */	0x7FD4	/*                                         <CJK> */,/* 5822 */
/* U+B5BF */	0x7FD5	/*                                         <CJK> */,/* 5823 */
/* U+B5C0 */	0x800B	/*                                         <CJK> */,/* 5824 */
/* U+B5C1 */	0x8052	/*                                         <CJK> */,/* 5825 */
/* U+B5C2 */	0x8085	/*                                         <CJK> */,/* 5826 */
/* U+B5C3 */	0x8155	/*                                         <CJK> */,/* 5827 */
/* U+B5C4 */	0x8154	/*                                         <CJK> */,/* 5828 */
/* U+B5C5 */	0x814B	/*                                         <CJK> */,/* 5829 */
/* U+B5C6 */	0x8151	/*                                         <CJK> */,/* 5830 */
/* U+B5C7 */	0x814E	/*                                         <CJK> */,/* 5831 */
/* U+B5C8 */	0x8139	/*                                         <CJK> */,/* 5832 */
/* U+B5C9 */	0x8146	/*                                         <CJK> */,/* 5833 */
/* U+B5CA */	0x813E	/*                                         <CJK> */,/* 5834 */
/* U+B5CB */	0x814C	/*                                         <CJK> */,/* 5835 */
/* U+B5CC */	0x8153	/*                                         <CJK> */,/* 5836 */
/* U+B5CD */	0x8174	/*                                         <CJK> */,/* 5837 */
/* U+B5CE */	0x8212	/*                                         <CJK> */,/* 5838 */
/* U+B5CF */	0x821C	/*                                         <CJK> */,/* 5839 */
/* U+B5D0 */	0x83E9	/*                                         <CJK> */,/* 5840 */
/* U+B5D1 */	0x8403	/*                                         <CJK> */,/* 5841 */
/* U+B5D2 */	0x83F8	/*                                         <CJK> */,/* 5842 */
/* U+B5D3 */	0x840D	/*                                         <CJK> */,/* 5843 */
/* U+B5D4 */	0x83E0	/*                                         <CJK> */,/* 5844 */
/* U+B5D5 */	0x83C5	/*                                         <CJK> */,/* 5845 */
/* U+B5D6 */	0x840B	/*                                         <CJK> */,/* 5846 */
/* U+B5D7 */	0x83C1	/*                                         <CJK> */,/* 5847 */
/* U+B5D8 */	0x83EF	/*                                         <CJK> */,/* 5848 */
/* U+B5D9 */	0x83F1	/*                                         <CJK> */,/* 5849 */
/* U+B5DA */	0x83F4	/*                                         <CJK> */,/* 5850 */
/* U+B5DB */	0x8457	/*                                         <CJK> */,/* 5851 */
/* U+B5DC */	0x840A	/*                                         <CJK> */,/* 5852 */
/* U+B5DD */	0x83F0	/*                                         <CJK> */,/* 5853 */
/* U+B5DE */	0x840C	/*                                         <CJK> */,/* 5854 */
/* U+B5DF */	0x83CC	/*                                         <CJK> */,/* 5855 */
/* U+B5E0 */	0x83FD	/*                                         <CJK> */,/* 5856 */
/* U+B5E1 */	0x83F2	/*                                         <CJK> */,/* 5857 */
/* U+B5E2 */	0x83CA	/*                                         <CJK> */,/* 5858 */
/* U+B5E3 */	0x8438	/*                                         <CJK> */,/* 5859 */
/* U+B5E4 */	0x840E	/*                                         <CJK> */,/* 5860 */
/* U+B5E5 */	0x8404	/*                                         <CJK> */,/* 5861 */
/* U+B5E6 */	0x83DC	/*                                         <CJK> */,/* 5862 */
/* U+B5E7 */	0x8407	/*                                         <CJK> */,/* 5863 */
/* U+B5E8 */	0x83D4	/*                                         <CJK> */,/* 5864 */
/* U+B5E9 */	0x83DF	/*                                         <CJK> */,/* 5865 */
/* U+B5EA */	0x865B	/*                                         <CJK> */,/* 5866 */
/* U+B5EB */	0x86DF	/*                                         <CJK> */,/* 5867 */
/* U+B5EC */	0x86D9	/*                                         <CJK> */,/* 5868 */
/* U+B5ED */	0x86ED	/*                                         <CJK> */,/* 5869 */
/* U+B5EE */	0x86D4	/*                                         <CJK> */,/* 5870 */
/* U+B5EF */	0x86DB	/*                                         <CJK> */,/* 5871 */
/* U+B5F0 */	0x86E4	/*                                         <CJK> */,/* 5872 */
/* U+B5F1 */	0x86D0	/*                                         <CJK> */,/* 5873 */
/* U+B5F2 */	0x86DE	/*                                         <CJK> */,/* 5874 */
/* U+B5F3 */	0x8857	/*                                         <CJK> */,/* 5875 */
/* U+B5F4 */	0x88C1	/*                                         <CJK> */,/* 5876 */
/* U+B5F5 */	0x88C2	/*                                         <CJK> */,/* 5877 */
/* U+B5F6 */	0x88B1	/*                                         <CJK> */,/* 5878 */
/* U+B5F7 */	0x8983	/*                                         <CJK> */,/* 5879 */
/* U+B5F8 */	0x8996	/*                                         <CJK> */,/* 5880 */
/* U+B5F9 */	0x8A3B	/*                                         <CJK> */,/* 5881 */
/* U+B5FA */	0x8A60	/*                                         <CJK> */,/* 5882 */
/* U+B5FB */	0x8A55	/*                                         <CJK> */,/* 5883 */
/* U+B5FC */	0x8A5E	/*                                         <CJK> */,/* 5884 */
/* U+B5FD */	0x8A3C	/*                                         <CJK> */,/* 5885 */
/* U+B5FE */	0x8A41	/*                                         <CJK> */,/* 5886 */
/* U+B5FF */	UNICODE_REPLACEMENT_CHARACTER,	/* 5887 */
/* U+B600 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5888 */
/* U+B601 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5889 */
/* U+B602 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5890 */
/* U+B603 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5891 */
/* U+B604 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5892 */
/* U+B605 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5893 */
/* U+B606 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5894 */
/* U+B607 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5895 */
/* U+B608 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5896 */
/* U+B609 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5897 */
/* U+B60A */	UNICODE_REPLACEMENT_CHARACTER,	/* 5898 */
/* U+B60B */	UNICODE_REPLACEMENT_CHARACTER,	/* 5899 */
/* U+B60C */	UNICODE_REPLACEMENT_CHARACTER,	/* 5900 */
/* U+B60D */	UNICODE_REPLACEMENT_CHARACTER,	/* 5901 */
/* U+B60E */	UNICODE_REPLACEMENT_CHARACTER,	/* 5902 */
/* U+B60F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5903 */
/* U+B610 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5904 */
/* U+B611 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5905 */
/* U+B612 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5906 */
/* U+B613 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5907 */
/* U+B614 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5908 */
/* U+B615 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5909 */
/* U+B616 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5910 */
/* U+B617 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5911 */
/* U+B618 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5912 */
/* U+B619 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5913 */
/* U+B61A */	UNICODE_REPLACEMENT_CHARACTER,	/* 5914 */
/* U+B61B */	UNICODE_REPLACEMENT_CHARACTER,	/* 5915 */
/* U+B61C */	UNICODE_REPLACEMENT_CHARACTER,	/* 5916 */
/* U+B61D */	UNICODE_REPLACEMENT_CHARACTER,	/* 5917 */
/* U+B61E */	UNICODE_REPLACEMENT_CHARACTER,	/* 5918 */
/* U+B61F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5919 */
/* U+B620 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5920 */
/* U+B621 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5921 */
/* U+B622 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5922 */
/* U+B623 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5923 */
/* U+B624 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5924 */
/* U+B625 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5925 */
/* U+B626 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5926 */
/* U+B627 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5927 */
/* U+B628 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5928 */
/* U+B629 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5929 */
/* U+B62A */	UNICODE_REPLACEMENT_CHARACTER,	/* 5930 */
/* U+B62B */	UNICODE_REPLACEMENT_CHARACTER,	/* 5931 */
/* U+B62C */	UNICODE_REPLACEMENT_CHARACTER,	/* 5932 */
/* U+B62D */	UNICODE_REPLACEMENT_CHARACTER,	/* 5933 */
/* U+B62E */	UNICODE_REPLACEMENT_CHARACTER,	/* 5934 */
/* U+B62F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5935 */
/* U+B630 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5936 */
/* U+B631 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5937 */
/* U+B632 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5938 */
/* U+B633 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5939 */
/* U+B634 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5940 */
/* U+B635 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5941 */
/* U+B636 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5942 */
/* U+B637 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5943 */
/* U+B638 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5944 */
/* U+B639 */	UNICODE_REPLACEMENT_CHARACTER,	/* 5945 */
/* U+B63A */	UNICODE_REPLACEMENT_CHARACTER,	/* 5946 */
/* U+B63B */	UNICODE_REPLACEMENT_CHARACTER,	/* 5947 */
/* U+B63C */	UNICODE_REPLACEMENT_CHARACTER,	/* 5948 */
/* U+B63D */	UNICODE_REPLACEMENT_CHARACTER,	/* 5949 */
/* U+B63E */	UNICODE_REPLACEMENT_CHARACTER,	/* 5950 */
/* U+B63F */	UNICODE_REPLACEMENT_CHARACTER,	/* 5951 */
/* U+B640 */	0x8A54	/*                                         <CJK> */,/* 5952 */
/* U+B641 */	0x8A5B	/*                                         <CJK> */,/* 5953 */
/* U+B642 */	0x8A50	/*                                         <CJK> */,/* 5954 */
/* U+B643 */	0x8A46	/*                                         <CJK> */,/* 5955 */
/* U+B644 */	0x8A34	/*                                         <CJK> */,/* 5956 */
/* U+B645 */	0x8A3A	/*                                         <CJK> */,/* 5957 */
/* U+B646 */	0x8A36	/*                                         <CJK> */,/* 5958 */
/* U+B647 */	0x8A56	/*                                         <CJK> */,/* 5959 */
/* U+B648 */	0x8C61	/*                                         <CJK> */,/* 5960 */
/* U+B649 */	0x8C82	/*                                         <CJK> */,/* 5961 */
/* U+B64A */	0x8CAF	/*                                         <CJK> */,/* 5962 */
/* U+B64B */	0x8CBC	/*                                         <CJK> */,/* 5963 */
/* U+B64C */	0x8CB3	/*                                         <CJK> */,/* 5964 */
/* U+B64D */	0x8CBD	/*                                         <CJK> */,/* 5965 */
/* U+B64E */	0x8CC1	/*                                         <CJK> */,/* 5966 */
/* U+B64F */	0x8CBB	/*                                         <CJK> */,/* 5967 */
/* U+B650 */	0x8CC0	/*                                         <CJK> */,/* 5968 */
/* U+B651 */	0x8CB4	/*                                         <CJK> */,/* 5969 */
/* U+B652 */	0x8CB7	/*                                         <CJK> */,/* 5970 */
/* U+B653 */	0x8CB6	/*                                         <CJK> */,/* 5971 */
/* U+B654 */	0x8CBF	/*                                         <CJK> */,/* 5972 */
/* U+B655 */	0x8CB8	/*                                         <CJK> */,/* 5973 */
/* U+B656 */	0x8D8A	/*                                         <CJK> */,/* 5974 */
/* U+B657 */	0x8D85	/*                                         <CJK> */,/* 5975 */
/* U+B658 */	0x8D81	/*                                         <CJK> */,/* 5976 */
/* U+B659 */	0x8DCE	/*                                         <CJK> */,/* 5977 */
/* U+B65A */	0x8DDD	/*                                         <CJK> */,/* 5978 */
/* U+B65B */	0x8DCB	/*                                         <CJK> */,/* 5979 */
/* U+B65C */	0x8DDA	/*                                         <CJK> */,/* 5980 */
/* U+B65D */	0x8DD1	/*                                         <CJK> */,/* 5981 */
/* U+B65E */	0x8DCC	/*                                         <CJK> */,/* 5982 */
/* U+B65F */	0x8DDB	/*                                         <CJK> */,/* 5983 */
/* U+B660 */	0x8DC6	/*                                         <CJK> */,/* 5984 */
/* U+B661 */	0x8EFB	/*                                         <CJK> */,/* 5985 */
/* U+B662 */	0x8EF8	/*                                         <CJK> */,/* 5986 */
/* U+B663 */	0x8EFC	/*                                         <CJK> */,/* 5987 */
/* U+B664 */	0x8F9C	/*                                         <CJK> */,/* 5988 */
/* U+B665 */	0x902E	/*                                         <CJK> */,/* 5989 */
/* U+B666 */	0x9035	/*                                         <CJK> */,/* 5990 */
/* U+B667 */	0x9031	/*                                         <CJK> */,/* 5991 */
/* U+B668 */	0x9038	/*                                         <CJK> */,/* 5992 */
/* U+B669 */	0x9032	/*                                         <CJK> */,/* 5993 */
/* U+B66A */	0x9036	/*                                         <CJK> */,/* 5994 */
/* U+B66B */	0x9102	/*                                         <CJK> */,/* 5995 */
/* U+B66C */	0x90F5	/*                                         <CJK> */,/* 5996 */
/* U+B66D */	0x9109	/*                                         <CJK> */,/* 5997 */
/* U+B66E */	0x90FE	/*                                         <CJK> */,/* 5998 */
/* U+B66F */	0x9163	/*                                         <CJK> */,/* 5999 */
/* U+B670 */	0x9165	/*                                         <CJK> */,/* 6000 */
/* U+B671 */	0x91CF	/*                                         <CJK> */,/* 6001 */
/* U+B672 */	0x9214	/*                                         <CJK> */,/* 6002 */
/* U+B673 */	0x9215	/*                                         <CJK> */,/* 6003 */
/* U+B674 */	0x9223	/*                                         <CJK> */,/* 6004 */
/* U+B675 */	0x9209	/*                                         <CJK> */,/* 6005 */
/* U+B676 */	0x921E	/*                                         <CJK> */,/* 6006 */
/* U+B677 */	0x920D	/*                                         <CJK> */,/* 6007 */
/* U+B678 */	0x9210	/*                                         <CJK> */,/* 6008 */
/* U+B679 */	0x9207	/*                                         <CJK> */,/* 6009 */
/* U+B67A */	0x9211	/*                                         <CJK> */,/* 6010 */
/* U+B67B */	0x9594	/*                                         <CJK> */,/* 6011 */
/* U+B67C */	0x958F	/*                                         <CJK> */,/* 6012 */
/* U+B67D */	0x958B	/*                                         <CJK> */,/* 6013 */
/* U+B67E */	0x9591	/*                                         <CJK> */,/* 6014 */
/* U+B67F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6015 */
/* U+B680 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6016 */
/* U+B681 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6017 */
/* U+B682 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6018 */
/* U+B683 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6019 */
/* U+B684 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6020 */
/* U+B685 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6021 */
/* U+B686 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6022 */
/* U+B687 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6023 */
/* U+B688 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6024 */
/* U+B689 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6025 */
/* U+B68A */	UNICODE_REPLACEMENT_CHARACTER,	/* 6026 */
/* U+B68B */	UNICODE_REPLACEMENT_CHARACTER,	/* 6027 */
/* U+B68C */	UNICODE_REPLACEMENT_CHARACTER,	/* 6028 */
/* U+B68D */	UNICODE_REPLACEMENT_CHARACTER,	/* 6029 */
/* U+B68E */	UNICODE_REPLACEMENT_CHARACTER,	/* 6030 */
/* U+B68F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6031 */
/* U+B690 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6032 */
/* U+B691 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6033 */
/* U+B692 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6034 */
/* U+B693 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6035 */
/* U+B694 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6036 */
/* U+B695 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6037 */
/* U+B696 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6038 */
/* U+B697 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6039 */
/* U+B698 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6040 */
/* U+B699 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6041 */
/* U+B69A */	UNICODE_REPLACEMENT_CHARACTER,	/* 6042 */
/* U+B69B */	UNICODE_REPLACEMENT_CHARACTER,	/* 6043 */
/* U+B69C */	UNICODE_REPLACEMENT_CHARACTER,	/* 6044 */
/* U+B69D */	UNICODE_REPLACEMENT_CHARACTER,	/* 6045 */
/* U+B69E */	UNICODE_REPLACEMENT_CHARACTER,	/* 6046 */
/* U+B69F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6047 */
/* U+B6A0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6048 */
/* U+B6A1 */	0x9593	/*                                         <CJK> */,/* 6049 */
/* U+B6A2 */	0x9592	/*                                         <CJK> */,/* 6050 */
/* U+B6A3 */	0x958E	/*                                         <CJK> */,/* 6051 */
/* U+B6A4 */	0x968A	/*                                         <CJK> */,/* 6052 */
/* U+B6A5 */	0x968E	/*                                         <CJK> */,/* 6053 */
/* U+B6A6 */	0x968B	/*                                         <CJK> */,/* 6054 */
/* U+B6A7 */	0x967D	/*                                         <CJK> */,/* 6055 */
/* U+B6A8 */	0x9685	/*                                         <CJK> */,/* 6056 */
/* U+B6A9 */	0x9686	/*                                         <CJK> */,/* 6057 */
/* U+B6AA */	0x968D	/*                                         <CJK> */,/* 6058 */
/* U+B6AB */	0x9672	/*                                         <CJK> */,/* 6059 */
/* U+B6AC */	0x9684	/*                                         <CJK> */,/* 6060 */
/* U+B6AD */	0x96C1	/*                                         <CJK> */,/* 6061 */
/* U+B6AE */	0x96C5	/*                                         <CJK> */,/* 6062 */
/* U+B6AF */	0x96C4	/*                                         <CJK> */,/* 6063 */
/* U+B6B0 */	0x96C6	/*                                         <CJK> */,/* 6064 */
/* U+B6B1 */	0x96C7	/*                                         <CJK> */,/* 6065 */
/* U+B6B2 */	0x96EF	/*                                         <CJK> */,/* 6066 */
/* U+B6B3 */	0x96F2	/*                                         <CJK> */,/* 6067 */
/* U+B6B4 */	0x97CC	/*                                         <CJK> */,/* 6068 */
/* U+B6B5 */	0x9805	/*                                         <CJK> */,/* 6069 */
/* U+B6B6 */	0x9806	/*                                         <CJK> */,/* 6070 */
/* U+B6B7 */	0x9808	/*                                         <CJK> */,/* 6071 */
/* U+B6B8 */	0x98E7	/*                                         <CJK> */,/* 6072 */
/* U+B6B9 */	0x98EA	/*                                         <CJK> */,/* 6073 */
/* U+B6BA */	0x98EF	/*                                         <CJK> */,/* 6074 */
/* U+B6BB */	0x98E9	/*                                         <CJK> */,/* 6075 */
/* U+B6BC */	0x98F2	/*                                         <CJK> */,/* 6076 */
/* U+B6BD */	0x98ED	/*                                         <CJK> */,/* 6077 */
/* U+B6BE */	0x99AE	/*                                         <CJK> */,/* 6078 */
/* U+B6BF */	0x99AD	/*                                         <CJK> */,/* 6079 */
/* U+B6C0 */	0x9EC3	/*                                         <CJK> */,/* 6080 */
/* U+B6C1 */	0x9ECD	/*                                         <CJK> */,/* 6081 */
/* U+B6C2 */	0x9ED1	/*                                         <CJK> */,/* 6082 */
/* U+B6C3 */	0x4E82	/*                                         <CJK> */,/* 6083 */
/* U+B6C4 */	0x50AD	/*                                         <CJK> */,/* 6084 */
/* U+B6C5 */	0x50B5	/*                                         <CJK> */,/* 6085 */
/* U+B6C6 */	0x50B2	/*                                         <CJK> */,/* 6086 */
/* U+B6C7 */	0x50B3	/*                                         <CJK> */,/* 6087 */
/* U+B6C8 */	0x50C5	/*                                         <CJK> */,/* 6088 */
/* U+B6C9 */	0x50BE	/*                                         <CJK> */,/* 6089 */
/* U+B6CA */	0x50AC	/*                                         <CJK> */,/* 6090 */
/* U+B6CB */	0x50B7	/*                                         <CJK> */,/* 6091 */
/* U+B6CC */	0x50BB	/*                                         <CJK> */,/* 6092 */
/* U+B6CD */	0x50AF	/*                                         <CJK> */,/* 6093 */
/* U+B6CE */	0x50C7	/*                                         <CJK> */,/* 6094 */
/* U+B6CF */	0x527F	/*                                         <CJK> */,/* 6095 */
/* U+B6D0 */	0x5277	/*                                         <CJK> */,/* 6096 */
/* U+B6D1 */	0x527D	/*                                         <CJK> */,/* 6097 */
/* U+B6D2 */	0x52DF	/*                                         <CJK> */,/* 6098 */
/* U+B6D3 */	0x52E6	/*                                         <CJK> */,/* 6099 */
/* U+B6D4 */	0x52E4	/*                                         <CJK> */,/* 6100 */
/* U+B6D5 */	0x52E2	/*                                         <CJK> */,/* 6101 */
/* U+B6D6 */	0x52E3	/*                                         <CJK> */,/* 6102 */
/* U+B6D7 */	0x532F	/*                                         <CJK> */,/* 6103 */
/* U+B6D8 */	0x55DF	/*                                         <CJK> */,/* 6104 */
/* U+B6D9 */	0x55E8	/*                                         <CJK> */,/* 6105 */
/* U+B6DA */	0x55D3	/*                                         <CJK> */,/* 6106 */
/* U+B6DB */	0x55E6	/*                                         <CJK> */,/* 6107 */
/* U+B6DC */	0x55CE	/*                                         <CJK> */,/* 6108 */
/* U+B6DD */	0x55DC	/*                                         <CJK> */,/* 6109 */
/* U+B6DE */	0x55C7	/*                                         <CJK> */,/* 6110 */
/* U+B6DF */	0x55D1	/*                                         <CJK> */,/* 6111 */
/* U+B6E0 */	0x55E3	/*                                         <CJK> */,/* 6112 */
/* U+B6E1 */	0x55E4	/*                                         <CJK> */,/* 6113 */
/* U+B6E2 */	0x55EF	/*                                         <CJK> */,/* 6114 */
/* U+B6E3 */	0x55DA	/*                                         <CJK> */,/* 6115 */
/* U+B6E4 */	0x55E1	/*                                         <CJK> */,/* 6116 */
/* U+B6E5 */	0x55C5	/*                                         <CJK> */,/* 6117 */
/* U+B6E6 */	0x55C6	/*                                         <CJK> */,/* 6118 */
/* U+B6E7 */	0x55E5	/*                                         <CJK> */,/* 6119 */
/* U+B6E8 */	0x55C9	/*                                         <CJK> */,/* 6120 */
/* U+B6E9 */	0x5712	/*                                         <CJK> */,/* 6121 */
/* U+B6EA */	0x5713	/*                                         <CJK> */,/* 6122 */
/* U+B6EB */	0x585E	/*                                         <CJK> */,/* 6123 */
/* U+B6EC */	0x5851	/*                                         <CJK> */,/* 6124 */
/* U+B6ED */	0x5858	/*                                         <CJK> */,/* 6125 */
/* U+B6EE */	0x5857	/*                                         <CJK> */,/* 6126 */
/* U+B6EF */	0x585A	/*                                         <CJK> */,/* 6127 */
/* U+B6F0 */	0x5854	/*                                         <CJK> */,/* 6128 */
/* U+B6F1 */	0x586B	/*                                         <CJK> */,/* 6129 */
/* U+B6F2 */	0x584C	/*                                         <CJK> */,/* 6130 */
/* U+B6F3 */	0x586D	/*                                         <CJK> */,/* 6131 */
/* U+B6F4 */	0x584A	/*                                         <CJK> */,/* 6132 */
/* U+B6F5 */	0x5862	/*                                         <CJK> */,/* 6133 */
/* U+B6F6 */	0x5852	/*                                         <CJK> */,/* 6134 */
/* U+B6F7 */	0x584B	/*                                         <CJK> */,/* 6135 */
/* U+B6F8 */	0x5967	/*                                         <CJK> */,/* 6136 */
/* U+B6F9 */	0x5AC1	/*                                         <CJK> */,/* 6137 */
/* U+B6FA */	0x5AC9	/*                                         <CJK> */,/* 6138 */
/* U+B6FB */	0x5ACC	/*                                         <CJK> */,/* 6139 */
/* U+B6FC */	0x5ABE	/*                                         <CJK> */,/* 6140 */
/* U+B6FD */	0x5ABD	/*                                         <CJK> */,/* 6141 */
/* U+B6FE */	0x5ABC	/*                                         <CJK> */,/* 6142 */
/* U+B6FF */	UNICODE_REPLACEMENT_CHARACTER,	/* 6143 */
/* U+B700 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6144 */
/* U+B701 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6145 */
/* U+B702 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6146 */
/* U+B703 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6147 */
/* U+B704 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6148 */
/* U+B705 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6149 */
/* U+B706 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6150 */
/* U+B707 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6151 */
/* U+B708 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6152 */
/* U+B709 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6153 */
/* U+B70A */	UNICODE_REPLACEMENT_CHARACTER,	/* 6154 */
/* U+B70B */	UNICODE_REPLACEMENT_CHARACTER,	/* 6155 */
/* U+B70C */	UNICODE_REPLACEMENT_CHARACTER,	/* 6156 */
/* U+B70D */	UNICODE_REPLACEMENT_CHARACTER,	/* 6157 */
/* U+B70E */	UNICODE_REPLACEMENT_CHARACTER,	/* 6158 */
/* U+B70F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6159 */
/* U+B710 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6160 */
/* U+B711 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6161 */
/* U+B712 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6162 */
/* U+B713 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6163 */
/* U+B714 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6164 */
/* U+B715 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6165 */
/* U+B716 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6166 */
/* U+B717 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6167 */
/* U+B718 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6168 */
/* U+B719 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6169 */
/* U+B71A */	UNICODE_REPLACEMENT_CHARACTER,	/* 6170 */
/* U+B71B */	UNICODE_REPLACEMENT_CHARACTER,	/* 6171 */
/* U+B71C */	UNICODE_REPLACEMENT_CHARACTER,	/* 6172 */
/* U+B71D */	UNICODE_REPLACEMENT_CHARACTER,	/* 6173 */
/* U+B71E */	UNICODE_REPLACEMENT_CHARACTER,	/* 6174 */
/* U+B71F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6175 */
/* U+B720 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6176 */
/* U+B721 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6177 */
/* U+B722 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6178 */
/* U+B723 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6179 */
/* U+B724 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6180 */
/* U+B725 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6181 */
/* U+B726 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6182 */
/* U+B727 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6183 */
/* U+B728 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6184 */
/* U+B729 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6185 */
/* U+B72A */	UNICODE_REPLACEMENT_CHARACTER,	/* 6186 */
/* U+B72B */	UNICODE_REPLACEMENT_CHARACTER,	/* 6187 */
/* U+B72C */	UNICODE_REPLACEMENT_CHARACTER,	/* 6188 */
/* U+B72D */	UNICODE_REPLACEMENT_CHARACTER,	/* 6189 */
/* U+B72E */	UNICODE_REPLACEMENT_CHARACTER,	/* 6190 */
/* U+B72F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6191 */
/* U+B730 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6192 */
/* U+B731 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6193 */
/* U+B732 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6194 */
/* U+B733 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6195 */
/* U+B734 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6196 */
/* U+B735 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6197 */
/* U+B736 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6198 */
/* U+B737 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6199 */
/* U+B738 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6200 */
/* U+B739 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6201 */
/* U+B73A */	UNICODE_REPLACEMENT_CHARACTER,	/* 6202 */
/* U+B73B */	UNICODE_REPLACEMENT_CHARACTER,	/* 6203 */
/* U+B73C */	UNICODE_REPLACEMENT_CHARACTER,	/* 6204 */
/* U+B73D */	UNICODE_REPLACEMENT_CHARACTER,	/* 6205 */
/* U+B73E */	UNICODE_REPLACEMENT_CHARACTER,	/* 6206 */
/* U+B73F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6207 */
/* U+B740 */	0x5AB3	/*                                         <CJK> */,/* 6208 */
/* U+B741 */	0x5AC2	/*                                         <CJK> */,/* 6209 */
/* U+B742 */	0x5AB2	/*                                         <CJK> */,/* 6210 */
/* U+B743 */	0x5D69	/*                                         <CJK> */,/* 6211 */
/* U+B744 */	0x5D6F	/*                                         <CJK> */,/* 6212 */
/* U+B745 */	0x5E4C	/*                                         <CJK> */,/* 6213 */
/* U+B746 */	0x5E79	/*                                         <CJK> */,/* 6214 */
/* U+B747 */	0x5EC9	/*                                         <CJK> */,/* 6215 */
/* U+B748 */	0x5EC8	/*                                         <CJK> */,/* 6216 */
/* U+B749 */	0x5F12	/*                                         <CJK> */,/* 6217 */
/* U+B74A */	0x5F59	/*                                         <CJK> */,/* 6218 */
/* U+B74B */	0x5FAC	/*                                         <CJK> */,/* 6219 */
/* U+B74C */	0x5FAE	/*                                         <CJK> */,/* 6220 */
/* U+B74D */	0x611A	/*                                         <CJK> */,/* 6221 */
/* U+B74E */	0x610F	/*                                         <CJK> */,/* 6222 */
/* U+B74F */	0x6148	/*                                         <CJK> */,/* 6223 */
/* U+B750 */	0x611F	/*                                         <CJK> */,/* 6224 */
/* U+B751 */	0x60F3	/*                                         <CJK> */,/* 6225 */
/* U+B752 */	0x611B	/*                                         <CJK> */,/* 6226 */
/* U+B753 */	0x60F9	/*                                         <CJK> */,/* 6227 */
/* U+B754 */	0x6101	/*                                         <CJK> */,/* 6228 */
/* U+B755 */	0x6108	/*                                         <CJK> */,/* 6229 */
/* U+B756 */	0x614E	/*                                         <CJK> */,/* 6230 */
/* U+B757 */	0x614C	/*                                         <CJK> */,/* 6231 */
/* U+B758 */	0x6144	/*                                         <CJK> */,/* 6232 */
/* U+B759 */	0x614D	/*                                         <CJK> */,/* 6233 */
/* U+B75A */	0x613E	/*                                         <CJK> */,/* 6234 */
/* U+B75B */	0x6134	/*                                         <CJK> */,/* 6235 */
/* U+B75C */	0x6127	/*                                         <CJK> */,/* 6236 */
/* U+B75D */	0x610D	/*                                         <CJK> */,/* 6237 */
/* U+B75E */	0x6106	/*                                         <CJK> */,/* 6238 */
/* U+B75F */	0x6137	/*                                         <CJK> */,/* 6239 */
/* U+B760 */	0x6221	/*                                         <CJK> */,/* 6240 */
/* U+B761 */	0x6222	/*                                         <CJK> */,/* 6241 */
/* U+B762 */	0x6413	/*                                         <CJK> */,/* 6242 */
/* U+B763 */	0x643E	/*                                         <CJK> */,/* 6243 */
/* U+B764 */	0x641E	/*                                         <CJK> */,/* 6244 */
/* U+B765 */	0x642A	/*                                         <CJK> */,/* 6245 */
/* U+B766 */	0x642D	/*                                         <CJK> */,/* 6246 */
/* U+B767 */	0x643D	/*                                         <CJK> */,/* 6247 */
/* U+B768 */	0x642C	/*                                         <CJK> */,/* 6248 */
/* U+B769 */	0x640F	/*                                         <CJK> */,/* 6249 */
/* U+B76A */	0x641C	/*                                         <CJK> */,/* 6250 */
/* U+B76B */	0x6414	/*                                         <CJK> */,/* 6251 */
/* U+B76C */	0x640D	/*                                         <CJK> */,/* 6252 */
/* U+B76D */	0x6436	/*                                         <CJK> */,/* 6253 */
/* U+B76E */	0x6416	/*                                         <CJK> */,/* 6254 */
/* U+B76F */	0x6417	/*                                         <CJK> */,/* 6255 */
/* U+B770 */	0x6406	/*                                         <CJK> */,/* 6256 */
/* U+B771 */	0x656C	/*                                         <CJK> */,/* 6257 */
/* U+B772 */	0x659F	/*                                         <CJK> */,/* 6258 */
/* U+B773 */	0x65B0	/*                                         <CJK> */,/* 6259 */
/* U+B774 */	0x6697	/*                                         <CJK> */,/* 6260 */
/* U+B775 */	0x6689	/*                                         <CJK> */,/* 6261 */
/* U+B776 */	0x6687	/*                                         <CJK> */,/* 6262 */
/* U+B777 */	0x6688	/*                                         <CJK> */,/* 6263 */
/* U+B778 */	0x6696	/*                                         <CJK> */,/* 6264 */
/* U+B779 */	0x6684	/*                                         <CJK> */,/* 6265 */
/* U+B77A */	0x6698	/*                                         <CJK> */,/* 6266 */
/* U+B77B */	0x668D	/*                                         <CJK> */,/* 6267 */
/* U+B77C */	0x6703	/*                                         <CJK> */,/* 6268 */
/* U+B77D */	0x6994	/*                                         <CJK> */,/* 6269 */
/* U+B77E */	0x696D	/*                                         <CJK> */,/* 6270 */
/* U+B77F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6271 */
/* U+B780 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6272 */
/* U+B781 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6273 */
/* U+B782 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6274 */
/* U+B783 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6275 */
/* U+B784 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6276 */
/* U+B785 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6277 */
/* U+B786 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6278 */
/* U+B787 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6279 */
/* U+B788 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6280 */
/* U+B789 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6281 */
/* U+B78A */	UNICODE_REPLACEMENT_CHARACTER,	/* 6282 */
/* U+B78B */	UNICODE_REPLACEMENT_CHARACTER,	/* 6283 */
/* U+B78C */	UNICODE_REPLACEMENT_CHARACTER,	/* 6284 */
/* U+B78D */	UNICODE_REPLACEMENT_CHARACTER,	/* 6285 */
/* U+B78E */	UNICODE_REPLACEMENT_CHARACTER,	/* 6286 */
/* U+B78F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6287 */
/* U+B790 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6288 */
/* U+B791 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6289 */
/* U+B792 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6290 */
/* U+B793 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6291 */
/* U+B794 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6292 */
/* U+B795 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6293 */
/* U+B796 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6294 */
/* U+B797 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6295 */
/* U+B798 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6296 */
/* U+B799 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6297 */
/* U+B79A */	UNICODE_REPLACEMENT_CHARACTER,	/* 6298 */
/* U+B79B */	UNICODE_REPLACEMENT_CHARACTER,	/* 6299 */
/* U+B79C */	UNICODE_REPLACEMENT_CHARACTER,	/* 6300 */
/* U+B79D */	UNICODE_REPLACEMENT_CHARACTER,	/* 6301 */
/* U+B79E */	UNICODE_REPLACEMENT_CHARACTER,	/* 6302 */
/* U+B79F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6303 */
/* U+B7A0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6304 */
/* U+B7A1 */	0x695A	/*                                         <CJK> */,/* 6305 */
/* U+B7A2 */	0x6977	/*                                         <CJK> */,/* 6306 */
/* U+B7A3 */	0x6960	/*                                         <CJK> */,/* 6307 */
/* U+B7A4 */	0x6954	/*                                         <CJK> */,/* 6308 */
/* U+B7A5 */	0x6975	/*                                         <CJK> */,/* 6309 */
/* U+B7A6 */	0x6930	/*                                         <CJK> */,/* 6310 */
/* U+B7A7 */	0x6982	/*                                         <CJK> */,/* 6311 */
/* U+B7A8 */	0x694A	/*                                         <CJK> */,/* 6312 */
/* U+B7A9 */	0x6968	/*                                         <CJK> */,/* 6313 */
/* U+B7AA */	0x696B	/*                                         <CJK> */,/* 6314 */
/* U+B7AB */	0x695E	/*                                         <CJK> */,/* 6315 */
/* U+B7AC */	0x6953	/*                                         <CJK> */,/* 6316 */
/* U+B7AD */	0x6979	/*                                         <CJK> */,/* 6317 */
/* U+B7AE */	0x6986	/*                                         <CJK> */,/* 6318 */
/* U+B7AF */	0x695D	/*                                         <CJK> */,/* 6319 */
/* U+B7B0 */	0x6963	/*                                         <CJK> */,/* 6320 */
/* U+B7B1 */	0x695B	/*                                         <CJK> */,/* 6321 */
/* U+B7B2 */	0x6B47	/*                                         <CJK> */,/* 6322 */
/* U+B7B3 */	0x6B72	/*                                         <CJK> */,/* 6323 */
/* U+B7B4 */	0x6BC0	/*                                         <CJK> */,/* 6324 */
/* U+B7B5 */	0x6BBF	/*                                         <CJK> */,/* 6325 */
/* U+B7B6 */	0x6BD3	/*                                         <CJK> */,/* 6326 */
/* U+B7B7 */	0x6BFD	/*                                         <CJK> */,/* 6327 */
/* U+B7B8 */	0x6EA2	/*                                         <CJK> */,/* 6328 */
/* U+B7B9 */	0x6EAF	/*                                         <CJK> */,/* 6329 */
/* U+B7BA */	0x6ED3	/*                                         <CJK> */,/* 6330 */
/* U+B7BB */	0x6EB6	/*                                         <CJK> */,/* 6331 */
/* U+B7BC */	0x6EC2	/*                                         <CJK> */,/* 6332 */
/* U+B7BD */	0x6E90	/*                                         <CJK> */,/* 6333 */
/* U+B7BE */	0x6E9D	/*                                         <CJK> */,/* 6334 */
/* U+B7BF */	0x6EC7	/*                                         <CJK> */,/* 6335 */
/* U+B7C0 */	0x6EC5	/*                                         <CJK> */,/* 6336 */
/* U+B7C1 */	0x6EA5	/*                                         <CJK> */,/* 6337 */
/* U+B7C2 */	0x6E98	/*                                         <CJK> */,/* 6338 */
/* U+B7C3 */	0x6EBC	/*                                         <CJK> */,/* 6339 */
/* U+B7C4 */	0x6EBA	/*                                         <CJK> */,/* 6340 */
/* U+B7C5 */	0x6EAB	/*                                         <CJK> */,/* 6341 */
/* U+B7C6 */	0x6ED1	/*                                         <CJK> */,/* 6342 */
/* U+B7C7 */	0x6E96	/*                                         <CJK> */,/* 6343 */
/* U+B7C8 */	0x6E9C	/*                                         <CJK> */,/* 6344 */
/* U+B7C9 */	0x6EC4	/*                                         <CJK> */,/* 6345 */
/* U+B7CA */	0x6ED4	/*                                         <CJK> */,/* 6346 */
/* U+B7CB */	0x6EAA	/*                                         <CJK> */,/* 6347 */
/* U+B7CC */	0x6EA7	/*                                         <CJK> */,/* 6348 */
/* U+B7CD */	0x6EB4	/*                                         <CJK> */,/* 6349 */
/* U+B7CE */	0x714E	/*                                         <CJK> */,/* 6350 */
/* U+B7CF */	0x7159	/*                                         <CJK> */,/* 6351 */
/* U+B7D0 */	0x7169	/*                                         <CJK> */,/* 6352 */
/* U+B7D1 */	0x7164	/*                                         <CJK> */,/* 6353 */
/* U+B7D2 */	0x7149	/*                                         <CJK> */,/* 6354 */
/* U+B7D3 */	0x7167	/*                                         <CJK> */,/* 6355 */
/* U+B7D4 */	0x715C	/*                                         <CJK> */,/* 6356 */
/* U+B7D5 */	0x716C	/*                                         <CJK> */,/* 6357 */
/* U+B7D6 */	0x7166	/*                                         <CJK> */,/* 6358 */
/* U+B7D7 */	0x714C	/*                                         <CJK> */,/* 6359 */
/* U+B7D8 */	0x7165	/*                                         <CJK> */,/* 6360 */
/* U+B7D9 */	0x715E	/*                                         <CJK> */,/* 6361 */
/* U+B7DA */	0x7146	/*                                         <CJK> */,/* 6362 */
/* U+B7DB */	0x7168	/*                                         <CJK> */,/* 6363 */
/* U+B7DC */	0x7156	/*                                         <CJK> */,/* 6364 */
/* U+B7DD */	0x723A	/*                                         <CJK> */,/* 6365 */
/* U+B7DE */	0x7252	/*                                         <CJK> */,/* 6366 */
/* U+B7DF */	0x7337	/*                                         <CJK> */,/* 6367 */
/* U+B7E0 */	0x7345	/*                                         <CJK> */,/* 6368 */
/* U+B7E1 */	0x733F	/*                                         <CJK> */,/* 6369 */
/* U+B7E2 */	0x733E	/*                                         <CJK> */,/* 6370 */
/* U+B7E3 */	0x746F	/*                                         <CJK> */,/* 6371 */
/* U+B7E4 */	0x745A	/*                                         <CJK> */,/* 6372 */
/* U+B7E5 */	0x7455	/*                                         <CJK> */,/* 6373 */
/* U+B7E6 */	0x745F	/*                                         <CJK> */,/* 6374 */
/* U+B7E7 */	0x745E	/*                                         <CJK> */,/* 6375 */
/* U+B7E8 */	0x7441	/*                                         <CJK> */,/* 6376 */
/* U+B7E9 */	0x743F	/*                                         <CJK> */,/* 6377 */
/* U+B7EA */	0x7459	/*                                         <CJK> */,/* 6378 */
/* U+B7EB */	0x745B	/*                                         <CJK> */,/* 6379 */
/* U+B7EC */	0x745C	/*                                         <CJK> */,/* 6380 */
/* U+B7ED */	0x7576	/*                                         <CJK> */,/* 6381 */
/* U+B7EE */	0x7578	/*                                         <CJK> */,/* 6382 */
/* U+B7EF */	0x7600	/*                                         <CJK> */,/* 6383 */
/* U+B7F0 */	0x75F0	/*                                         <CJK> */,/* 6384 */
/* U+B7F1 */	0x7601	/*                                         <CJK> */,/* 6385 */
/* U+B7F2 */	0x75F2	/*                                         <CJK> */,/* 6386 */
/* U+B7F3 */	0x75F1	/*                                         <CJK> */,/* 6387 */
/* U+B7F4 */	0x75FA	/*                                         <CJK> */,/* 6388 */
/* U+B7F5 */	0x75FF	/*                                         <CJK> */,/* 6389 */
/* U+B7F6 */	0x75F4	/*                                         <CJK> */,/* 6390 */
/* U+B7F7 */	0x75F3	/*                                         <CJK> */,/* 6391 */
/* U+B7F8 */	0x76DE	/*                                         <CJK> */,/* 6392 */
/* U+B7F9 */	0x76DF	/*                                         <CJK> */,/* 6393 */
/* U+B7FA */	0x775B	/*                                         <CJK> */,/* 6394 */
/* U+B7FB */	0x776B	/*                                         <CJK> */,/* 6395 */
/* U+B7FC */	0x7766	/*                                         <CJK> */,/* 6396 */
/* U+B7FD */	0x775E	/*                                         <CJK> */,/* 6397 */
/* U+B7FE */	0x7763	/*                                         <CJK> */,/* 6398 */
/* U+B7FF */	UNICODE_REPLACEMENT_CHARACTER,	/* 6399 */
/* U+B800 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6400 */
/* U+B801 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6401 */
/* U+B802 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6402 */
/* U+B803 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6403 */
/* U+B804 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6404 */
/* U+B805 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6405 */
/* U+B806 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6406 */
/* U+B807 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6407 */
/* U+B808 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6408 */
/* U+B809 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6409 */
/* U+B80A */	UNICODE_REPLACEMENT_CHARACTER,	/* 6410 */
/* U+B80B */	UNICODE_REPLACEMENT_CHARACTER,	/* 6411 */
/* U+B80C */	UNICODE_REPLACEMENT_CHARACTER,	/* 6412 */
/* U+B80D */	UNICODE_REPLACEMENT_CHARACTER,	/* 6413 */
/* U+B80E */	UNICODE_REPLACEMENT_CHARACTER,	/* 6414 */
/* U+B80F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6415 */
/* U+B810 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6416 */
/* U+B811 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6417 */
/* U+B812 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6418 */
/* U+B813 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6419 */
/* U+B814 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6420 */
/* U+B815 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6421 */
/* U+B816 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6422 */
/* U+B817 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6423 */
/* U+B818 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6424 */
/* U+B819 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6425 */
/* U+B81A */	UNICODE_REPLACEMENT_CHARACTER,	/* 6426 */
/* U+B81B */	UNICODE_REPLACEMENT_CHARACTER,	/* 6427 */
/* U+B81C */	UNICODE_REPLACEMENT_CHARACTER,	/* 6428 */
/* U+B81D */	UNICODE_REPLACEMENT_CHARACTER,	/* 6429 */
/* U+B81E */	UNICODE_REPLACEMENT_CHARACTER,	/* 6430 */
/* U+B81F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6431 */
/* U+B820 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6432 */
/* U+B821 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6433 */
/* U+B822 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6434 */
/* U+B823 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6435 */
/* U+B824 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6436 */
/* U+B825 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6437 */
/* U+B826 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6438 */
/* U+B827 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6439 */
/* U+B828 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6440 */
/* U+B829 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6441 */
/* U+B82A */	UNICODE_REPLACEMENT_CHARACTER,	/* 6442 */
/* U+B82B */	UNICODE_REPLACEMENT_CHARACTER,	/* 6443 */
/* U+B82C */	UNICODE_REPLACEMENT_CHARACTER,	/* 6444 */
/* U+B82D */	UNICODE_REPLACEMENT_CHARACTER,	/* 6445 */
/* U+B82E */	UNICODE_REPLACEMENT_CHARACTER,	/* 6446 */
/* U+B82F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6447 */
/* U+B830 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6448 */
/* U+B831 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6449 */
/* U+B832 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6450 */
/* U+B833 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6451 */
/* U+B834 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6452 */
/* U+B835 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6453 */
/* U+B836 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6454 */
/* U+B837 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6455 */
/* U+B838 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6456 */
/* U+B839 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6457 */
/* U+B83A */	UNICODE_REPLACEMENT_CHARACTER,	/* 6458 */
/* U+B83B */	UNICODE_REPLACEMENT_CHARACTER,	/* 6459 */
/* U+B83C */	UNICODE_REPLACEMENT_CHARACTER,	/* 6460 */
/* U+B83D */	UNICODE_REPLACEMENT_CHARACTER,	/* 6461 */
/* U+B83E */	UNICODE_REPLACEMENT_CHARACTER,	/* 6462 */
/* U+B83F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6463 */
/* U+B840 */	0x7779	/*                                         <CJK> */,/* 6464 */
/* U+B841 */	0x776A	/*                                         <CJK> */,/* 6465 */
/* U+B842 */	0x776C	/*                                         <CJK> */,/* 6466 */
/* U+B843 */	0x775C	/*                                         <CJK> */,/* 6467 */
/* U+B844 */	0x7765	/*                                         <CJK> */,/* 6468 */
/* U+B845 */	0x7768	/*                                         <CJK> */,/* 6469 */
/* U+B846 */	0x7762	/*                                         <CJK> */,/* 6470 */
/* U+B847 */	0x77EE	/*                                         <CJK> */,/* 6471 */
/* U+B848 */	0x788E	/*                                         <CJK> */,/* 6472 */
/* U+B849 */	0x78B0	/*                                         <CJK> */,/* 6473 */
/* U+B84A */	0x7897	/*                                         <CJK> */,/* 6474 */
/* U+B84B */	0x7898	/*                                         <CJK> */,/* 6475 */
/* U+B84C */	0x788C	/*                                         <CJK> */,/* 6476 */
/* U+B84D */	0x7889	/*                                         <CJK> */,/* 6477 */
/* U+B84E */	0x787C	/*                                         <CJK> */,/* 6478 */
/* U+B84F */	0x7891	/*                                         <CJK> */,/* 6479 */
/* U+B850 */	0x7893	/*                                         <CJK> */,/* 6480 */
/* U+B851 */	0x787F	/*                                         <CJK> */,/* 6481 */
/* U+B852 */	0x797A	/*                                         <CJK> */,/* 6482 */
/* U+B853 */	0x797F	/*                                         <CJK> */,/* 6483 */
/* U+B854 */	0x7981	/*                                         <CJK> */,/* 6484 */
/* U+B855 */	0x842C	/*                                         <CJK> */,/* 6485 */
/* U+B856 */	0x79BD	/*                                         <CJK> */,/* 6486 */
/* U+B857 */	0x7A1C	/*                                         <CJK> */,/* 6487 */
/* U+B858 */	0x7A1A	/*                                         <CJK> */,/* 6488 */
/* U+B859 */	0x7A20	/*                                         <CJK> */,/* 6489 */
/* U+B85A */	0x7A14	/*                                         <CJK> */,/* 6490 */
/* U+B85B */	0x7A1F	/*                                         <CJK> */,/* 6491 */
/* U+B85C */	0x7A1E	/*                                         <CJK> */,/* 6492 */
/* U+B85D */	0x7A9F	/*                                         <CJK> */,/* 6493 */
/* U+B85E */	0x7AA0	/*                                         <CJK> */,/* 6494 */
/* U+B85F */	0x7B77	/*                                         <CJK> */,/* 6495 */
/* U+B860 */	0x7BC0	/*                                         <CJK> */,/* 6496 */
/* U+B861 */	0x7B60	/*                                         <CJK> */,/* 6497 */
/* U+B862 */	0x7B6E	/*                                         <CJK> */,/* 6498 */
/* U+B863 */	0x7B67	/*                                         <CJK> */,/* 6499 */
/* U+B864 */	0x7CB1	/*                                         <CJK> */,/* 6500 */
/* U+B865 */	0x7CB3	/*                                         <CJK> */,/* 6501 */
/* U+B866 */	0x7CB5	/*                                         <CJK> */,/* 6502 */
/* U+B867 */	0x7D93	/*                                         <CJK> */,/* 6503 */
/* U+B868 */	0x7D79	/*                                         <CJK> */,/* 6504 */
/* U+B869 */	0x7D91	/*                                         <CJK> */,/* 6505 */
/* U+B86A */	0x7D81	/*                                         <CJK> */,/* 6506 */
/* U+B86B */	0x7D8F	/*                                         <CJK> */,/* 6507 */
/* U+B86C */	0x7D5B	/*                                         <CJK> */,/* 6508 */
/* U+B86D */	0x7F6E	/*                                         <CJK> */,/* 6509 */
/* U+B86E */	0x7F69	/*                                         <CJK> */,/* 6510 */
/* U+B86F */	0x7F6A	/*                                         <CJK> */,/* 6511 */
/* U+B870 */	0x7F72	/*                                         <CJK> */,/* 6512 */
/* U+B871 */	0x7FA9	/*                                         <CJK> */,/* 6513 */
/* U+B872 */	0x7FA8	/*                                         <CJK> */,/* 6514 */
/* U+B873 */	0x7FA4	/*                                         <CJK> */,/* 6515 */
/* U+B874 */	0x8056	/*                                         <CJK> */,/* 6516 */
/* U+B875 */	0x8058	/*                                         <CJK> */,/* 6517 */
/* U+B876 */	0x8086	/*                                         <CJK> */,/* 6518 */
/* U+B877 */	0x8084	/*                                         <CJK> */,/* 6519 */
/* U+B878 */	0x8171	/*                                         <CJK> */,/* 6520 */
/* U+B879 */	0x8170	/*                                         <CJK> */,/* 6521 */
/* U+B87A */	0x8178	/*                                         <CJK> */,/* 6522 */
/* U+B87B */	0x8165	/*                                         <CJK> */,/* 6523 */
/* U+B87C */	0x816E	/*                                         <CJK> */,/* 6524 */
/* U+B87D */	0x8173	/*                                         <CJK> */,/* 6525 */
/* U+B87E */	0x816B	/*                                         <CJK> */,/* 6526 */
/* U+B87F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6527 */
/* U+B880 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6528 */
/* U+B881 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6529 */
/* U+B882 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6530 */
/* U+B883 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6531 */
/* U+B884 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6532 */
/* U+B885 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6533 */
/* U+B886 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6534 */
/* U+B887 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6535 */
/* U+B888 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6536 */
/* U+B889 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6537 */
/* U+B88A */	UNICODE_REPLACEMENT_CHARACTER,	/* 6538 */
/* U+B88B */	UNICODE_REPLACEMENT_CHARACTER,	/* 6539 */
/* U+B88C */	UNICODE_REPLACEMENT_CHARACTER,	/* 6540 */
/* U+B88D */	UNICODE_REPLACEMENT_CHARACTER,	/* 6541 */
/* U+B88E */	UNICODE_REPLACEMENT_CHARACTER,	/* 6542 */
/* U+B88F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6543 */
/* U+B890 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6544 */
/* U+B891 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6545 */
/* U+B892 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6546 */
/* U+B893 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6547 */
/* U+B894 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6548 */
/* U+B895 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6549 */
/* U+B896 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6550 */
/* U+B897 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6551 */
/* U+B898 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6552 */
/* U+B899 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6553 */
/* U+B89A */	UNICODE_REPLACEMENT_CHARACTER,	/* 6554 */
/* U+B89B */	UNICODE_REPLACEMENT_CHARACTER,	/* 6555 */
/* U+B89C */	UNICODE_REPLACEMENT_CHARACTER,	/* 6556 */
/* U+B89D */	UNICODE_REPLACEMENT_CHARACTER,	/* 6557 */
/* U+B89E */	UNICODE_REPLACEMENT_CHARACTER,	/* 6558 */
/* U+B89F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6559 */
/* U+B8A0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6560 */
/* U+B8A1 */	0x8179	/*                                         <CJK> */,/* 6561 */
/* U+B8A2 */	0x817A	/*                                         <CJK> */,/* 6562 */
/* U+B8A3 */	0x8166	/*                                         <CJK> */,/* 6563 */
/* U+B8A4 */	0x8205	/*                                         <CJK> */,/* 6564 */
/* U+B8A5 */	0x8247	/*                                         <CJK> */,/* 6565 */
/* U+B8A6 */	0x8482	/*                                         <CJK> */,/* 6566 */
/* U+B8A7 */	0x8477	/*                                         <CJK> */,/* 6567 */
/* U+B8A8 */	0x843D	/*                                         <CJK> */,/* 6568 */
/* U+B8A9 */	0x8431	/*                                         <CJK> */,/* 6569 */
/* U+B8AA */	0x8475	/*                                         <CJK> */,/* 6570 */
/* U+B8AB */	0x8466	/*                                         <CJK> */,/* 6571 */
/* U+B8AC */	0x846B	/*                                         <CJK> */,/* 6572 */
/* U+B8AD */	0x8449	/*                                         <CJK> */,/* 6573 */
/* U+B8AE */	0x846C	/*                                         <CJK> */,/* 6574 */
/* U+B8AF */	0x845B	/*                                         <CJK> */,/* 6575 */
/* U+B8B0 */	0x843C	/*                                         <CJK> */,/* 6576 */
/* U+B8B1 */	0x8435	/*                                         <CJK> */,/* 6577 */
/* U+B8B2 */	0x8461	/*                                         <CJK> */,/* 6578 */
/* U+B8B3 */	0x8463	/*                                         <CJK> */,/* 6579 */
/* U+B8B4 */	0x8469	/*                                         <CJK> */,/* 6580 */
/* U+B8B5 */	0x846D	/*                                         <CJK> */,/* 6581 */
/* U+B8B6 */	0x8446	/*                                         <CJK> */,/* 6582 */
/* U+B8B7 */	0x865E	/*                                         <CJK> */,/* 6583 */
/* U+B8B8 */	0x865C	/*                                         <CJK> */,/* 6584 */
/* U+B8B9 */	0x865F	/*                                         <CJK> */,/* 6585 */
/* U+B8BA */	0x86F9	/*                                         <CJK> */,/* 6586 */
/* U+B8BB */	0x8713	/*                                         <CJK> */,/* 6587 */
/* U+B8BC */	0x8708	/*                                         <CJK> */,/* 6588 */
/* U+B8BD */	0x8707	/*                                         <CJK> */,/* 6589 */
/* U+B8BE */	0x8700	/*                                         <CJK> */,/* 6590 */
/* U+B8BF */	0x86FE	/*                                         <CJK> */,/* 6591 */
/* U+B8C0 */	0x86FB	/*                                         <CJK> */,/* 6592 */
/* U+B8C1 */	0x8702	/*                                         <CJK> */,/* 6593 */
/* U+B8C2 */	0x8703	/*                                         <CJK> */,/* 6594 */
/* U+B8C3 */	0x8706	/*                                         <CJK> */,/* 6595 */
/* U+B8C4 */	0x870A	/*                                         <CJK> */,/* 6596 */
/* U+B8C5 */	0x8859	/*                                         <CJK> */,/* 6597 */
/* U+B8C6 */	0x88DF	/*                                         <CJK> */,/* 6598 */
/* U+B8C7 */	0x88D4	/*                                         <CJK> */,/* 6599 */
/* U+B8C8 */	0x88D9	/*                                         <CJK> */,/* 6600 */
/* U+B8C9 */	0x88DC	/*                                         <CJK> */,/* 6601 */
/* U+B8CA */	0x88D8	/*                                         <CJK> */,/* 6602 */
/* U+B8CB */	0x88DD	/*                                         <CJK> */,/* 6603 */
/* U+B8CC */	0x88E1	/*                                         <CJK> */,/* 6604 */
/* U+B8CD */	0x88CA	/*                                         <CJK> */,/* 6605 */
/* U+B8CE */	0x88D5	/*                                         <CJK> */,/* 6606 */
/* U+B8CF */	0x88D2	/*                                         <CJK> */,/* 6607 */
/* U+B8D0 */	0x899C	/*                                         <CJK> */,/* 6608 */
/* U+B8D1 */	0x89E3	/*                                         <CJK> */,/* 6609 */
/* U+B8D2 */	0x8A6B	/*                                         <CJK> */,/* 6610 */
/* U+B8D3 */	0x8A72	/*                                         <CJK> */,/* 6611 */
/* U+B8D4 */	0x8A73	/*                                         <CJK> */,/* 6612 */
/* U+B8D5 */	0x8A66	/*                                         <CJK> */,/* 6613 */
/* U+B8D6 */	0x8A69	/*                                         <CJK> */,/* 6614 */
/* U+B8D7 */	0x8A70	/*                                         <CJK> */,/* 6615 */
/* U+B8D8 */	0x8A87	/*                                         <CJK> */,/* 6616 */
/* U+B8D9 */	0x8A7C	/*                                         <CJK> */,/* 6617 */
/* U+B8DA */	0x8A63	/*                                         <CJK> */,/* 6618 */
/* U+B8DB */	0x8AA0	/*                                         <CJK> */,/* 6619 */
/* U+B8DC */	0x8A71	/*                                         <CJK> */,/* 6620 */
/* U+B8DD */	0x8A85	/*                                         <CJK> */,/* 6621 */
/* U+B8DE */	0x8A6D	/*                                         <CJK> */,/* 6622 */
/* U+B8DF */	0x8A62	/*                                         <CJK> */,/* 6623 */
/* U+B8E0 */	0x8A6E	/*                                         <CJK> */,/* 6624 */
/* U+B8E1 */	0x8A6C	/*                                         <CJK> */,/* 6625 */
/* U+B8E2 */	0x8A79	/*                                         <CJK> */,/* 6626 */
/* U+B8E3 */	0x8A7B	/*                                         <CJK> */,/* 6627 */
/* U+B8E4 */	0x8A3E	/*                                         <CJK> */,/* 6628 */
/* U+B8E5 */	0x8A68	/*                                         <CJK> */,/* 6629 */
/* U+B8E6 */	0x8C62	/*                                         <CJK> */,/* 6630 */
/* U+B8E7 */	0x8C8A	/*                                         <CJK> */,/* 6631 */
/* U+B8E8 */	0x8C89	/*                                         <CJK> */,/* 6632 */
/* U+B8E9 */	0x8CCA	/*                                         <CJK> */,/* 6633 */
/* U+B8EA */	0x8CC7	/*                                         <CJK> */,/* 6634 */
/* U+B8EB */	0x8CC8	/*                                         <CJK> */,/* 6635 */
/* U+B8EC */	0x8CC4	/*                                         <CJK> */,/* 6636 */
/* U+B8ED */	0x8CB2	/*                                         <CJK> */,/* 6637 */
/* U+B8EE */	0x8CC3	/*                                         <CJK> */,/* 6638 */
/* U+B8EF */	0x8CC2	/*                                         <CJK> */,/* 6639 */
/* U+B8F0 */	0x8CC5	/*                                         <CJK> */,/* 6640 */
/* U+B8F1 */	0x8DE1	/*                                         <CJK> */,/* 6641 */
/* U+B8F2 */	0x8DDF	/*                                         <CJK> */,/* 6642 */
/* U+B8F3 */	0x8DE8	/*                                         <CJK> */,/* 6643 */
/* U+B8F4 */	0x8DEF	/*                                         <CJK> */,/* 6644 */
/* U+B8F5 */	0x8DF3	/*                                         <CJK> */,/* 6645 */
/* U+B8F6 */	0x8DFA	/*                                         <CJK> */,/* 6646 */
/* U+B8F7 */	0x8DEA	/*                                         <CJK> */,/* 6647 */
/* U+B8F8 */	0x8DE4	/*                                         <CJK> */,/* 6648 */
/* U+B8F9 */	0x8DE6	/*                                         <CJK> */,/* 6649 */
/* U+B8FA */	0x8EB2	/*                                         <CJK> */,/* 6650 */
/* U+B8FB */	0x8F03	/*                                         <CJK> */,/* 6651 */
/* U+B8FC */	0x8F09	/*                                         <CJK> */,/* 6652 */
/* U+B8FD */	0x8EFE	/*                                         <CJK> */,/* 6653 */
/* U+B8FE */	0x8F0A	/*                                         <CJK> */,/* 6654 */
/* U+B8FF */	UNICODE_REPLACEMENT_CHARACTER,	/* 6655 */
/* U+B900 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6656 */
/* U+B901 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6657 */
/* U+B902 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6658 */
/* U+B903 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6659 */
/* U+B904 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6660 */
/* U+B905 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6661 */
/* U+B906 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6662 */
/* U+B907 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6663 */
/* U+B908 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6664 */
/* U+B909 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6665 */
/* U+B90A */	UNICODE_REPLACEMENT_CHARACTER,	/* 6666 */
/* U+B90B */	UNICODE_REPLACEMENT_CHARACTER,	/* 6667 */
/* U+B90C */	UNICODE_REPLACEMENT_CHARACTER,	/* 6668 */
/* U+B90D */	UNICODE_REPLACEMENT_CHARACTER,	/* 6669 */
/* U+B90E */	UNICODE_REPLACEMENT_CHARACTER,	/* 6670 */
/* U+B90F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6671 */
/* U+B910 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6672 */
/* U+B911 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6673 */
/* U+B912 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6674 */
/* U+B913 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6675 */
/* U+B914 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6676 */
/* U+B915 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6677 */
/* U+B916 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6678 */
/* U+B917 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6679 */
/* U+B918 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6680 */
/* U+B919 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6681 */
/* U+B91A */	UNICODE_REPLACEMENT_CHARACTER,	/* 6682 */
/* U+B91B */	UNICODE_REPLACEMENT_CHARACTER,	/* 6683 */
/* U+B91C */	UNICODE_REPLACEMENT_CHARACTER,	/* 6684 */
/* U+B91D */	UNICODE_REPLACEMENT_CHARACTER,	/* 6685 */
/* U+B91E */	UNICODE_REPLACEMENT_CHARACTER,	/* 6686 */
/* U+B91F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6687 */
/* U+B920 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6688 */
/* U+B921 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6689 */
/* U+B922 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6690 */
/* U+B923 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6691 */
/* U+B924 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6692 */
/* U+B925 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6693 */
/* U+B926 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6694 */
/* U+B927 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6695 */
/* U+B928 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6696 */
/* U+B929 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6697 */
/* U+B92A */	UNICODE_REPLACEMENT_CHARACTER,	/* 6698 */
/* U+B92B */	UNICODE_REPLACEMENT_CHARACTER,	/* 6699 */
/* U+B92C */	UNICODE_REPLACEMENT_CHARACTER,	/* 6700 */
/* U+B92D */	UNICODE_REPLACEMENT_CHARACTER,	/* 6701 */
/* U+B92E */	UNICODE_REPLACEMENT_CHARACTER,	/* 6702 */
/* U+B92F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6703 */
/* U+B930 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6704 */
/* U+B931 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6705 */
/* U+B932 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6706 */
/* U+B933 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6707 */
/* U+B934 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6708 */
/* U+B935 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6709 */
/* U+B936 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6710 */
/* U+B937 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6711 */
/* U+B938 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6712 */
/* U+B939 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6713 */
/* U+B93A */	UNICODE_REPLACEMENT_CHARACTER,	/* 6714 */
/* U+B93B */	UNICODE_REPLACEMENT_CHARACTER,	/* 6715 */
/* U+B93C */	UNICODE_REPLACEMENT_CHARACTER,	/* 6716 */
/* U+B93D */	UNICODE_REPLACEMENT_CHARACTER,	/* 6717 */
/* U+B93E */	UNICODE_REPLACEMENT_CHARACTER,	/* 6718 */
/* U+B93F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6719 */
/* U+B940 */	0x8F9F	/*                                         <CJK> */,/* 6720 */
/* U+B941 */	0x8FB2	/*                                         <CJK> */,/* 6721 */
/* U+B942 */	0x904B	/*                                         <CJK> */,/* 6722 */
/* U+B943 */	0x904A	/*                                         <CJK> */,/* 6723 */
/* U+B944 */	0x9053	/*                                         <CJK> */,/* 6724 */
/* U+B945 */	0x9042	/*                                         <CJK> */,/* 6725 */
/* U+B946 */	0x9054	/*                                         <CJK> */,/* 6726 */
/* U+B947 */	0x903C	/*                                         <CJK> */,/* 6727 */
/* U+B948 */	0x9055	/*                                         <CJK> */,/* 6728 */
/* U+B949 */	0x9050	/*                                         <CJK> */,/* 6729 */
/* U+B94A */	0x9047	/*                                         <CJK> */,/* 6730 */
/* U+B94B */	0x904F	/*                                         <CJK> */,/* 6731 */
/* U+B94C */	0x904E	/*                                         <CJK> */,/* 6732 */
/* U+B94D */	0x904D	/*                                         <CJK> */,/* 6733 */
/* U+B94E */	0x9051	/*                                         <CJK> */,/* 6734 */
/* U+B94F */	0x903E	/*                                         <CJK> */,/* 6735 */
/* U+B950 */	0x9041	/*                                         <CJK> */,/* 6736 */
/* U+B951 */	0x9112	/*                                         <CJK> */,/* 6737 */
/* U+B952 */	0x9117	/*                                         <CJK> */,/* 6738 */
/* U+B953 */	0x916C	/*                                         <CJK> */,/* 6739 */
/* U+B954 */	0x916A	/*                                         <CJK> */,/* 6740 */
/* U+B955 */	0x9169	/*                                         <CJK> */,/* 6741 */
/* U+B956 */	0x91C9	/*                                         <CJK> */,/* 6742 */
/* U+B957 */	0x9237	/*                                         <CJK> */,/* 6743 */
/* U+B958 */	0x9257	/*                                         <CJK> */,/* 6744 */
/* U+B959 */	0x9238	/*                                         <CJK> */,/* 6745 */
/* U+B95A */	0x923D	/*                                         <CJK> */,/* 6746 */
/* U+B95B */	0x9240	/*                                         <CJK> */,/* 6747 */
/* U+B95C */	0x923E	/*                                         <CJK> */,/* 6748 */
/* U+B95D */	0x925B	/*                                         <CJK> */,/* 6749 */
/* U+B95E */	0x924B	/*                                         <CJK> */,/* 6750 */
/* U+B95F */	0x9264	/*                                         <CJK> */,/* 6751 */
/* U+B960 */	0x9251	/*                                         <CJK> */,/* 6752 */
/* U+B961 */	0x9234	/*                                         <CJK> */,/* 6753 */
/* U+B962 */	0x9249	/*                                         <CJK> */,/* 6754 */
/* U+B963 */	0x924D	/*                                         <CJK> */,/* 6755 */
/* U+B964 */	0x9245	/*                                         <CJK> */,/* 6756 */
/* U+B965 */	0x9239	/*                                         <CJK> */,/* 6757 */
/* U+B966 */	0x923F	/*                                         <CJK> */,/* 6758 */
/* U+B967 */	0x925A	/*                                         <CJK> */,/* 6759 */
/* U+B968 */	0x9598	/*                                         <CJK> */,/* 6760 */
/* U+B969 */	0x9698	/*                                         <CJK> */,/* 6761 */
/* U+B96A */	0x9694	/*                                         <CJK> */,/* 6762 */
/* U+B96B */	0x9695	/*                                         <CJK> */,/* 6763 */
/* U+B96C */	0x96CD	/*                                         <CJK> */,/* 6764 */
/* U+B96D */	0x96CB	/*                                         <CJK> */,/* 6765 */
/* U+B96E */	0x96C9	/*                                         <CJK> */,/* 6766 */
/* U+B96F */	0x96CA	/*                                         <CJK> */,/* 6767 */
/* U+B970 */	0x96F7	/*                                         <CJK> */,/* 6768 */
/* U+B971 */	0x96FB	/*                                         <CJK> */,/* 6769 */
/* U+B972 */	0x96F9	/*                                         <CJK> */,/* 6770 */
/* U+B973 */	0x96F6	/*                                         <CJK> */,/* 6771 */
/* U+B974 */	0x9756	/*                                         <CJK> */,/* 6772 */
/* U+B975 */	0x9774	/*                                         <CJK> */,/* 6773 */
/* U+B976 */	0x9776	/*                                         <CJK> */,/* 6774 */
/* U+B977 */	0x9810	/*                                         <CJK> */,/* 6775 */
/* U+B978 */	0x9811	/*                                         <CJK> */,/* 6776 */
/* U+B979 */	0x9813	/*                                         <CJK> */,/* 6777 */
/* U+B97A */	0x980A	/*                                         <CJK> */,/* 6778 */
/* U+B97B */	0x9812	/*                                         <CJK> */,/* 6779 */
/* U+B97C */	0x980C	/*                                         <CJK> */,/* 6780 */
/* U+B97D */	0x98FC	/*                                         <CJK> */,/* 6781 */
/* U+B97E */	0x98F4	/*                                         <CJK> */,/* 6782 */
/* U+B97F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6783 */
/* U+B980 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6784 */
/* U+B981 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6785 */
/* U+B982 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6786 */
/* U+B983 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6787 */
/* U+B984 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6788 */
/* U+B985 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6789 */
/* U+B986 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6790 */
/* U+B987 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6791 */
/* U+B988 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6792 */
/* U+B989 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6793 */
/* U+B98A */	UNICODE_REPLACEMENT_CHARACTER,	/* 6794 */
/* U+B98B */	UNICODE_REPLACEMENT_CHARACTER,	/* 6795 */
/* U+B98C */	UNICODE_REPLACEMENT_CHARACTER,	/* 6796 */
/* U+B98D */	UNICODE_REPLACEMENT_CHARACTER,	/* 6797 */
/* U+B98E */	UNICODE_REPLACEMENT_CHARACTER,	/* 6798 */
/* U+B98F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6799 */
/* U+B990 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6800 */
/* U+B991 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6801 */
/* U+B992 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6802 */
/* U+B993 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6803 */
/* U+B994 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6804 */
/* U+B995 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6805 */
/* U+B996 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6806 */
/* U+B997 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6807 */
/* U+B998 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6808 */
/* U+B999 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6809 */
/* U+B99A */	UNICODE_REPLACEMENT_CHARACTER,	/* 6810 */
/* U+B99B */	UNICODE_REPLACEMENT_CHARACTER,	/* 6811 */
/* U+B99C */	UNICODE_REPLACEMENT_CHARACTER,	/* 6812 */
/* U+B99D */	UNICODE_REPLACEMENT_CHARACTER,	/* 6813 */
/* U+B99E */	UNICODE_REPLACEMENT_CHARACTER,	/* 6814 */
/* U+B99F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6815 */
/* U+B9A0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6816 */
/* U+B9A1 */	0x98FD	/*                                         <CJK> */,/* 6817 */
/* U+B9A2 */	0x98FE	/*                                         <CJK> */,/* 6818 */
/* U+B9A3 */	0x99B3	/*                                         <CJK> */,/* 6819 */
/* U+B9A4 */	0x99B1	/*                                         <CJK> */,/* 6820 */
/* U+B9A5 */	0x99B4	/*                                         <CJK> */,/* 6821 */
/* U+B9A6 */	0x9AE1	/*                                         <CJK> */,/* 6822 */
/* U+B9A7 */	0x9CE9	/*                                         <CJK> */,/* 6823 */
/* U+B9A8 */	0x9E82	/*                                         <CJK> */,/* 6824 */
/* U+B9A9 */	0x9F0E	/*                                         <CJK> */,/* 6825 */
/* U+B9AA */	0x9F13	/*                                         <CJK> */,/* 6826 */
/* U+B9AB */	0x9F20	/*                                         <CJK> */,/* 6827 */
/* U+B9AC */	0x50E7	/*                                         <CJK> */,/* 6828 */
/* U+B9AD */	0x50EE	/*                                         <CJK> */,/* 6829 */
/* U+B9AE */	0x50E5	/*                                         <CJK> */,/* 6830 */
/* U+B9AF */	0x50D6	/*                                         <CJK> */,/* 6831 */
/* U+B9B0 */	0x50ED	/*                                         <CJK> */,/* 6832 */
/* U+B9B1 */	0x50DA	/*                                         <CJK> */,/* 6833 */
/* U+B9B2 */	0x50D5	/*                                         <CJK> */,/* 6834 */
/* U+B9B3 */	0x50CF	/*                                         <CJK> */,/* 6835 */
/* U+B9B4 */	0x50D1	/*                                         <CJK> */,/* 6836 */
/* U+B9B5 */	0x50F1	/*                                         <CJK> */,/* 6837 */
/* U+B9B6 */	0x50CE	/*                                         <CJK> */,/* 6838 */
/* U+B9B7 */	0x50E9	/*                                         <CJK> */,/* 6839 */
/* U+B9B8 */	0x5162	/*                                         <CJK> */,/* 6840 */
/* U+B9B9 */	0x51F3	/*                                         <CJK> */,/* 6841 */
/* U+B9BA */	0x5283	/*                                         <CJK> */,/* 6842 */
/* U+B9BB */	0x5282	/*                                         <CJK> */,/* 6843 */
/* U+B9BC */	0x5331	/*                                         <CJK> */,/* 6844 */
/* U+B9BD */	0x53AD	/*                                         <CJK> */,/* 6845 */
/* U+B9BE */	0x55FE	/*                                         <CJK> */,/* 6846 */
/* U+B9BF */	0x5600	/*                                         <CJK> */,/* 6847 */
/* U+B9C0 */	0x561B	/*                                         <CJK> */,/* 6848 */
/* U+B9C1 */	0x5617	/*                                         <CJK> */,/* 6849 */
/* U+B9C2 */	0x55FD	/*                                         <CJK> */,/* 6850 */
/* U+B9C3 */	0x5614	/*                                         <CJK> */,/* 6851 */
/* U+B9C4 */	0x5606	/*                                         <CJK> */,/* 6852 */
/* U+B9C5 */	0x5609	/*                                         <CJK> */,/* 6853 */
/* U+B9C6 */	0x560D	/*                                         <CJK> */,/* 6854 */
/* U+B9C7 */	0x560E	/*                                         <CJK> */,/* 6855 */
/* U+B9C8 */	0x55F7	/*                                         <CJK> */,/* 6856 */
/* U+B9C9 */	0x5616	/*                                         <CJK> */,/* 6857 */
/* U+B9CA */	0x561F	/*                                         <CJK> */,/* 6858 */
/* U+B9CB */	0x5608	/*                                         <CJK> */,/* 6859 */
/* U+B9CC */	0x5610	/*                                         <CJK> */,/* 6860 */
/* U+B9CD */	0x55F6	/*                                         <CJK> */,/* 6861 */
/* U+B9CE */	0x5718	/*                                         <CJK> */,/* 6862 */
/* U+B9CF */	0x5716	/*                                         <CJK> */,/* 6863 */
/* U+B9D0 */	0x5875	/*                                         <CJK> */,/* 6864 */
/* U+B9D1 */	0x587E	/*                                         <CJK> */,/* 6865 */
/* U+B9D2 */	0x5883	/*                                         <CJK> */,/* 6866 */
/* U+B9D3 */	0x5893	/*                                         <CJK> */,/* 6867 */
/* U+B9D4 */	0x588A	/*                                         <CJK> */,/* 6868 */
/* U+B9D5 */	0x5879	/*                                         <CJK> */,/* 6869 */
/* U+B9D6 */	0x5885	/*                                         <CJK> */,/* 6870 */
/* U+B9D7 */	0x587D	/*                                         <CJK> */,/* 6871 */
/* U+B9D8 */	0x58FD	/*                                         <CJK> */,/* 6872 */
/* U+B9D9 */	0x5925	/*                                         <CJK> */,/* 6873 */
/* U+B9DA */	0x5922	/*                                         <CJK> */,/* 6874 */
/* U+B9DB */	0x5924	/*                                         <CJK> */,/* 6875 */
/* U+B9DC */	0x596A	/*                                         <CJK> */,/* 6876 */
/* U+B9DD */	0x5969	/*                                         <CJK> */,/* 6877 */
/* U+B9DE */	0x5AE1	/*                                         <CJK> */,/* 6878 */
/* U+B9DF */	0x5AE6	/*                                         <CJK> */,/* 6879 */
/* U+B9E0 */	0x5AE9	/*                                         <CJK> */,/* 6880 */
/* U+B9E1 */	0x5AD7	/*                                         <CJK> */,/* 6881 */
/* U+B9E2 */	0x5AD6	/*                                         <CJK> */,/* 6882 */
/* U+B9E3 */	0x5AD8	/*                                         <CJK> */,/* 6883 */
/* U+B9E4 */	0x5AE3	/*                                         <CJK> */,/* 6884 */
/* U+B9E5 */	0x5B75	/*                                         <CJK> */,/* 6885 */
/* U+B9E6 */	0x5BDE	/*                                         <CJK> */,/* 6886 */
/* U+B9E7 */	0x5BE7	/*                                         <CJK> */,/* 6887 */
/* U+B9E8 */	0x5BE1	/*                                         <CJK> */,/* 6888 */
/* U+B9E9 */	0x5BE5	/*                                         <CJK> */,/* 6889 */
/* U+B9EA */	0x5BE6	/*                                         <CJK> */,/* 6890 */
/* U+B9EB */	0x5BE8	/*                                         <CJK> */,/* 6891 */
/* U+B9EC */	0x5BE2	/*                                         <CJK> */,/* 6892 */
/* U+B9ED */	0x5BE4	/*                                         <CJK> */,/* 6893 */
/* U+B9EE */	0x5BDF	/*                                         <CJK> */,/* 6894 */
/* U+B9EF */	0x5C0D	/*                                         <CJK> */,/* 6895 */
/* U+B9F0 */	0x5C62	/*                                         <CJK> */,/* 6896 */
/* U+B9F1 */	0x5D84	/*                                         <CJK> */,/* 6897 */
/* U+B9F2 */	0x5D87	/*                                         <CJK> */,/* 6898 */
/* U+B9F3 */	0x5E5B	/*                                         <CJK> */,/* 6899 */
/* U+B9F4 */	0x5E63	/*                                         <CJK> */,/* 6900 */
/* U+B9F5 */	0x5E55	/*                                         <CJK> */,/* 6901 */
/* U+B9F6 */	0x5E57	/*                                         <CJK> */,/* 6902 */
/* U+B9F7 */	0x5E54	/*                                         <CJK> */,/* 6903 */
/* U+B9F8 */	0x5ED3	/*                                         <CJK> */,/* 6904 */
/* U+B9F9 */	0x5ED6	/*                                         <CJK> */,/* 6905 */
/* U+B9FA */	0x5F0A	/*                                         <CJK> */,/* 6906 */
/* U+B9FB */	0x5F46	/*                                         <CJK> */,/* 6907 */
/* U+B9FC */	0x5F70	/*                                         <CJK> */,/* 6908 */
/* U+B9FD */	0x5FB9	/*                                         <CJK> */,/* 6909 */
/* U+B9FE */	0x6147	/*                                         <CJK> */,/* 6910 */
/* U+B9FF */	UNICODE_REPLACEMENT_CHARACTER,	/* 6911 */
/* U+BA00 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6912 */
/* U+BA01 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6913 */
/* U+BA02 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6914 */
/* U+BA03 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6915 */
/* U+BA04 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6916 */
/* U+BA05 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6917 */
/* U+BA06 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6918 */
/* U+BA07 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6919 */
/* U+BA08 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6920 */
/* U+BA09 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6921 */
/* U+BA0A */	UNICODE_REPLACEMENT_CHARACTER,	/* 6922 */
/* U+BA0B */	UNICODE_REPLACEMENT_CHARACTER,	/* 6923 */
/* U+BA0C */	UNICODE_REPLACEMENT_CHARACTER,	/* 6924 */
/* U+BA0D */	UNICODE_REPLACEMENT_CHARACTER,	/* 6925 */
/* U+BA0E */	UNICODE_REPLACEMENT_CHARACTER,	/* 6926 */
/* U+BA0F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6927 */
/* U+BA10 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6928 */
/* U+BA11 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6929 */
/* U+BA12 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6930 */
/* U+BA13 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6931 */
/* U+BA14 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6932 */
/* U+BA15 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6933 */
/* U+BA16 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6934 */
/* U+BA17 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6935 */
/* U+BA18 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6936 */
/* U+BA19 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6937 */
/* U+BA1A */	UNICODE_REPLACEMENT_CHARACTER,	/* 6938 */
/* U+BA1B */	UNICODE_REPLACEMENT_CHARACTER,	/* 6939 */
/* U+BA1C */	UNICODE_REPLACEMENT_CHARACTER,	/* 6940 */
/* U+BA1D */	UNICODE_REPLACEMENT_CHARACTER,	/* 6941 */
/* U+BA1E */	UNICODE_REPLACEMENT_CHARACTER,	/* 6942 */
/* U+BA1F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6943 */
/* U+BA20 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6944 */
/* U+BA21 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6945 */
/* U+BA22 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6946 */
/* U+BA23 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6947 */
/* U+BA24 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6948 */
/* U+BA25 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6949 */
/* U+BA26 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6950 */
/* U+BA27 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6951 */
/* U+BA28 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6952 */
/* U+BA29 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6953 */
/* U+BA2A */	UNICODE_REPLACEMENT_CHARACTER,	/* 6954 */
/* U+BA2B */	UNICODE_REPLACEMENT_CHARACTER,	/* 6955 */
/* U+BA2C */	UNICODE_REPLACEMENT_CHARACTER,	/* 6956 */
/* U+BA2D */	UNICODE_REPLACEMENT_CHARACTER,	/* 6957 */
/* U+BA2E */	UNICODE_REPLACEMENT_CHARACTER,	/* 6958 */
/* U+BA2F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6959 */
/* U+BA30 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6960 */
/* U+BA31 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6961 */
/* U+BA32 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6962 */
/* U+BA33 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6963 */
/* U+BA34 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6964 */
/* U+BA35 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6965 */
/* U+BA36 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6966 */
/* U+BA37 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6967 */
/* U+BA38 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6968 */
/* U+BA39 */	UNICODE_REPLACEMENT_CHARACTER,	/* 6969 */
/* U+BA3A */	UNICODE_REPLACEMENT_CHARACTER,	/* 6970 */
/* U+BA3B */	UNICODE_REPLACEMENT_CHARACTER,	/* 6971 */
/* U+BA3C */	UNICODE_REPLACEMENT_CHARACTER,	/* 6972 */
/* U+BA3D */	UNICODE_REPLACEMENT_CHARACTER,	/* 6973 */
/* U+BA3E */	UNICODE_REPLACEMENT_CHARACTER,	/* 6974 */
/* U+BA3F */	UNICODE_REPLACEMENT_CHARACTER,	/* 6975 */
/* U+BA40 */	0x613F	/*                                         <CJK> */,/* 6976 */
/* U+BA41 */	0x614B	/*                                         <CJK> */,/* 6977 */
/* U+BA42 */	0x6177	/*                                         <CJK> */,/* 6978 */
/* U+BA43 */	0x6162	/*                                         <CJK> */,/* 6979 */
/* U+BA44 */	0x6163	/*                                         <CJK> */,/* 6980 */
/* U+BA45 */	0x615F	/*                                         <CJK> */,/* 6981 */
/* U+BA46 */	0x615A	/*                                         <CJK> */,/* 6982 */
/* U+BA47 */	0x6158	/*                                         <CJK> */,/* 6983 */
/* U+BA48 */	0x6175	/*                                         <CJK> */,/* 6984 */
/* U+BA49 */	0x622A	/*                                         <CJK> */,/* 6985 */
/* U+BA4A */	0x6487	/*                                         <CJK> */,/* 6986 */
/* U+BA4B */	0x6458	/*                                         <CJK> */,/* 6987 */
/* U+BA4C */	0x6454	/*                                         <CJK> */,/* 6988 */
/* U+BA4D */	0x64A4	/*                                         <CJK> */,/* 6989 */
/* U+BA4E */	0x6478	/*                                         <CJK> */,/* 6990 */
/* U+BA4F */	0x645F	/*                                         <CJK> */,/* 6991 */
/* U+BA50 */	0x647A	/*                                         <CJK> */,/* 6992 */
/* U+BA51 */	0x6451	/*                                         <CJK> */,/* 6993 */
/* U+BA52 */	0x6467	/*                                         <CJK> */,/* 6994 */
/* U+BA53 */	0x6434	/*                                         <CJK> */,/* 6995 */
/* U+BA54 */	0x646D	/*                                         <CJK> */,/* 6996 */
/* U+BA55 */	0x647B	/*                                         <CJK> */,/* 6997 */
/* U+BA56 */	0x6572	/*                                         <CJK> */,/* 6998 */
/* U+BA57 */	0x65A1	/*                                         <CJK> */,/* 6999 */
/* U+BA58 */	0x65D7	/*                                         <CJK> */,/* 7000 */
/* U+BA59 */	0x65D6	/*                                         <CJK> */,/* 7001 */
/* U+BA5A */	0x66A2	/*                                         <CJK> */,/* 7002 */
/* U+BA5B */	0x66A8	/*                                         <CJK> */,/* 7003 */
/* U+BA5C */	0x669D	/*                                         <CJK> */,/* 7004 */
/* U+BA5D */	0x699C	/*                                         <CJK> */,/* 7005 */
/* U+BA5E */	0x69A8	/*                                         <CJK> */,/* 7006 */
/* U+BA5F */	0x6995	/*                                         <CJK> */,/* 7007 */
/* U+BA60 */	0x69C1	/*                                         <CJK> */,/* 7008 */
/* U+BA61 */	0x69AE	/*                                         <CJK> */,/* 7009 */
/* U+BA62 */	0x69D3	/*                                         <CJK> */,/* 7010 */
/* U+BA63 */	0x69CB	/*                                         <CJK> */,/* 7011 */
/* U+BA64 */	0x699B	/*                                         <CJK> */,/* 7012 */
/* U+BA65 */	0x69B7	/*                                         <CJK> */,/* 7013 */
/* U+BA66 */	0x69BB	/*                                         <CJK> */,/* 7014 */
/* U+BA67 */	0x69AB	/*                                         <CJK> */,/* 7015 */
/* U+BA68 */	0x69B4	/*                                         <CJK> */,/* 7016 */
/* U+BA69 */	0x69D0	/*                                         <CJK> */,/* 7017 */
/* U+BA6A */	0x69CD	/*                                         <CJK> */,/* 7018 */
/* U+BA6B */	0x69AD	/*                                         <CJK> */,/* 7019 */
/* U+BA6C */	0x69CC	/*                                         <CJK> */,/* 7020 */
/* U+BA6D */	0x69A6	/*                                         <CJK> */,/* 7021 */
/* U+BA6E */	0x69C3	/*                                         <CJK> */,/* 7022 */
/* U+BA6F */	0x69A3	/*                                         <CJK> */,/* 7023 */
/* U+BA70 */	0x6B49	/*                                         <CJK> */,/* 7024 */
/* U+BA71 */	0x6B4C	/*                                         <CJK> */,/* 7025 */
/* U+BA72 */	0x6C33	/*                                         <CJK> */,/* 7026 */
/* U+BA73 */	0x6F33	/*                                         <CJK> */,/* 7027 */
/* U+BA74 */	0x6F14	/*                                         <CJK> */,/* 7028 */
/* U+BA75 */	0x6EFE	/*                                         <CJK> */,/* 7029 */
/* U+BA76 */	0x6F13	/*                                         <CJK> */,/* 7030 */
/* U+BA77 */	0x6EF4	/*                                         <CJK> */,/* 7031 */
/* U+BA78 */	0x6F29	/*                                         <CJK> */,/* 7032 */
/* U+BA79 */	0x6F3E	/*                                         <CJK> */,/* 7033 */
/* U+BA7A */	0x6F20	/*                                         <CJK> */,/* 7034 */
/* U+BA7B */	0x6F2C	/*                                         <CJK> */,/* 7035 */
/* U+BA7C */	0x6F0F	/*                                         <CJK> */,/* 7036 */
/* U+BA7D */	0x6F02	/*                                         <CJK> */,/* 7037 */
/* U+BA7E */	0x6F22	/*                                         <CJK> */,/* 7038 */
/* U+BA7F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7039 */
/* U+BA80 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7040 */
/* U+BA81 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7041 */
/* U+BA82 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7042 */
/* U+BA83 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7043 */
/* U+BA84 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7044 */
/* U+BA85 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7045 */
/* U+BA86 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7046 */
/* U+BA87 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7047 */
/* U+BA88 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7048 */
/* U+BA89 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7049 */
/* U+BA8A */	UNICODE_REPLACEMENT_CHARACTER,	/* 7050 */
/* U+BA8B */	UNICODE_REPLACEMENT_CHARACTER,	/* 7051 */
/* U+BA8C */	UNICODE_REPLACEMENT_CHARACTER,	/* 7052 */
/* U+BA8D */	UNICODE_REPLACEMENT_CHARACTER,	/* 7053 */
/* U+BA8E */	UNICODE_REPLACEMENT_CHARACTER,	/* 7054 */
/* U+BA8F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7055 */
/* U+BA90 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7056 */
/* U+BA91 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7057 */
/* U+BA92 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7058 */
/* U+BA93 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7059 */
/* U+BA94 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7060 */
/* U+BA95 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7061 */
/* U+BA96 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7062 */
/* U+BA97 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7063 */
/* U+BA98 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7064 */
/* U+BA99 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7065 */
/* U+BA9A */	UNICODE_REPLACEMENT_CHARACTER,	/* 7066 */
/* U+BA9B */	UNICODE_REPLACEMENT_CHARACTER,	/* 7067 */
/* U+BA9C */	UNICODE_REPLACEMENT_CHARACTER,	/* 7068 */
/* U+BA9D */	UNICODE_REPLACEMENT_CHARACTER,	/* 7069 */
/* U+BA9E */	UNICODE_REPLACEMENT_CHARACTER,	/* 7070 */
/* U+BA9F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7071 */
/* U+BAA0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7072 */
/* U+BAA1 */	0x6EFF	/*                                         <CJK> */,/* 7073 */
/* U+BAA2 */	0x6EEF	/*                                         <CJK> */,/* 7074 */
/* U+BAA3 */	0x6F06	/*                                         <CJK> */,/* 7075 */
/* U+BAA4 */	0x6F31	/*                                         <CJK> */,/* 7076 */
/* U+BAA5 */	0x6F38	/*                                         <CJK> */,/* 7077 */
/* U+BAA6 */	0x6F32	/*                                         <CJK> */,/* 7078 */
/* U+BAA7 */	0x6F23	/*                                         <CJK> */,/* 7079 */
/* U+BAA8 */	0x6F15	/*                                         <CJK> */,/* 7080 */
/* U+BAA9 */	0x6F2B	/*                                         <CJK> */,/* 7081 */
/* U+BAAA */	0x6F2F	/*                                         <CJK> */,/* 7082 */
/* U+BAAB */	0x6F88	/*                                         <CJK> */,/* 7083 */
/* U+BAAC */	0x6F2A	/*                                         <CJK> */,/* 7084 */
/* U+BAAD */	0x6EEC	/*                                         <CJK> */,/* 7085 */
/* U+BAAE */	0x6F01	/*                                         <CJK> */,/* 7086 */
/* U+BAAF */	0x6EF2	/*                                         <CJK> */,/* 7087 */
/* U+BAB0 */	0x6ECC	/*                                         <CJK> */,/* 7088 */
/* U+BAB1 */	0x6EF7	/*                                         <CJK> */,/* 7089 */
/* U+BAB2 */	0x7194	/*                                         <CJK> */,/* 7090 */
/* U+BAB3 */	0x7199	/*                                         <CJK> */,/* 7091 */
/* U+BAB4 */	0x717D	/*                                         <CJK> */,/* 7092 */
/* U+BAB5 */	0x718A	/*                                         <CJK> */,/* 7093 */
/* U+BAB6 */	0x7184	/*                                         <CJK> */,/* 7094 */
/* U+BAB7 */	0x7192	/*                                         <CJK> */,/* 7095 */
/* U+BAB8 */	0x723E	/*                                         <CJK> */,/* 7096 */
/* U+BAB9 */	0x7292	/*                                         <CJK> */,/* 7097 */
/* U+BABA */	0x7296	/*                                         <CJK> */,/* 7098 */
/* U+BABB */	0x7344	/*                                         <CJK> */,/* 7099 */
/* U+BABC */	0x7350	/*                                         <CJK> */,/* 7100 */
/* U+BABD */	0x7464	/*                                         <CJK> */,/* 7101 */
/* U+BABE */	0x7463	/*                                         <CJK> */,/* 7102 */
/* U+BABF */	0x746A	/*                                         <CJK> */,/* 7103 */
/* U+BAC0 */	0x7470	/*                                         <CJK> */,/* 7104 */
/* U+BAC1 */	0x746D	/*                                         <CJK> */,/* 7105 */
/* U+BAC2 */	0x7504	/*                                         <CJK> */,/* 7106 */
/* U+BAC3 */	0x7591	/*                                         <CJK> */,/* 7107 */
/* U+BAC4 */	0x7627	/*                                         <CJK> */,/* 7108 */
/* U+BAC5 */	0x760D	/*                                         <CJK> */,/* 7109 */
/* U+BAC6 */	0x760B	/*                                         <CJK> */,/* 7110 */
/* U+BAC7 */	0x7609	/*                                         <CJK> */,/* 7111 */
/* U+BAC8 */	0x7613	/*                                         <CJK> */,/* 7112 */
/* U+BAC9 */	0x76E1	/*                                         <CJK> */,/* 7113 */
/* U+BACA */	0x76E3	/*                                         <CJK> */,/* 7114 */
/* U+BACB */	0x7784	/*                                         <CJK> */,/* 7115 */
/* U+BACC */	0x777D	/*                                         <CJK> */,/* 7116 */
/* U+BACD */	0x777F	/*                                         <CJK> */,/* 7117 */
/* U+BACE */	0x7761	/*                                         <CJK> */,/* 7118 */
/* U+BACF */	0x78C1	/*                                         <CJK> */,/* 7119 */
/* U+BAD0 */	0x789F	/*                                         <CJK> */,/* 7120 */
/* U+BAD1 */	0x78A7	/*                                         <CJK> */,/* 7121 */
/* U+BAD2 */	0x78B3	/*                                         <CJK> */,/* 7122 */
/* U+BAD3 */	0x78A9	/*                                         <CJK> */,/* 7123 */
/* U+BAD4 */	0x78A3	/*                                         <CJK> */,/* 7124 */
/* U+BAD5 */	0x798E	/*                                         <CJK> */,/* 7125 */
/* U+BAD6 */	0x798F	/*                                         <CJK> */,/* 7126 */
/* U+BAD7 */	0x798D	/*                                         <CJK> */,/* 7127 */
/* U+BAD8 */	0x7A2E	/*                                         <CJK> */,/* 7128 */
/* U+BAD9 */	0x7A31	/*                                         <CJK> */,/* 7129 */
/* U+BADA */	0x7AAA	/*                                         <CJK> */,/* 7130 */
/* U+BADB */	0x7AA9	/*                                         <CJK> */,/* 7131 */
/* U+BADC */	0x7AED	/*                                         <CJK> */,/* 7132 */
/* U+BADD */	0x7AEF	/*                                         <CJK> */,/* 7133 */
/* U+BADE */	0x7BA1	/*                                         <CJK> */,/* 7134 */
/* U+BADF */	0x7B95	/*                                         <CJK> */,/* 7135 */
/* U+BAE0 */	0x7B8B	/*                                         <CJK> */,/* 7136 */
/* U+BAE1 */	0x7B75	/*                                         <CJK> */,/* 7137 */
/* U+BAE2 */	0x7B97	/*                                         <CJK> */,/* 7138 */
/* U+BAE3 */	0x7B9D	/*                                         <CJK> */,/* 7139 */
/* U+BAE4 */	0x7B94	/*                                         <CJK> */,/* 7140 */
/* U+BAE5 */	0x7B8F	/*                                         <CJK> */,/* 7141 */
/* U+BAE6 */	0x7BB8	/*                                         <CJK> */,/* 7142 */
/* U+BAE7 */	0x7B87	/*                                         <CJK> */,/* 7143 */
/* U+BAE8 */	0x7B84	/*                                         <CJK> */,/* 7144 */
/* U+BAE9 */	0x7CB9	/*                                         <CJK> */,/* 7145 */
/* U+BAEA */	0x7CBD	/*                                         <CJK> */,/* 7146 */
/* U+BAEB */	0x7CBE	/*                                         <CJK> */,/* 7147 */
/* U+BAEC */	0x7DBB	/*                                         <CJK> */,/* 7148 */
/* U+BAED */	0x7DB0	/*                                         <CJK> */,/* 7149 */
/* U+BAEE */	0x7D9C	/*                                         <CJK> */,/* 7150 */
/* U+BAEF */	0x7DBD	/*                                         <CJK> */,/* 7151 */
/* U+BAF0 */	0x7DBE	/*                                         <CJK> */,/* 7152 */
/* U+BAF1 */	0x7DA0	/*                                         <CJK> */,/* 7153 */
/* U+BAF2 */	0x7DCA	/*                                         <CJK> */,/* 7154 */
/* U+BAF3 */	0x7DB4	/*                                         <CJK> */,/* 7155 */
/* U+BAF4 */	0x7DB2	/*                                         <CJK> */,/* 7156 */
/* U+BAF5 */	0x7DB1	/*                                         <CJK> */,/* 7157 */
/* U+BAF6 */	0x7DBA	/*                                         <CJK> */,/* 7158 */
/* U+BAF7 */	0x7DA2	/*                                         <CJK> */,/* 7159 */
/* U+BAF8 */	0x7DBF	/*                                         <CJK> */,/* 7160 */
/* U+BAF9 */	0x7DB5	/*                                         <CJK> */,/* 7161 */
/* U+BAFA */	0x7DB8	/*                                         <CJK> */,/* 7162 */
/* U+BAFB */	0x7DAD	/*                                         <CJK> */,/* 7163 */
/* U+BAFC */	0x7DD2	/*                                         <CJK> */,/* 7164 */
/* U+BAFD */	0x7DC7	/*                                         <CJK> */,/* 7165 */
/* U+BAFE */	0x7DAC	/*                                         <CJK> */,/* 7166 */
/* U+BAFF */	UNICODE_REPLACEMENT_CHARACTER,	/* 7167 */
/* U+BB00 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7168 */
/* U+BB01 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7169 */
/* U+BB02 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7170 */
/* U+BB03 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7171 */
/* U+BB04 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7172 */
/* U+BB05 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7173 */
/* U+BB06 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7174 */
/* U+BB07 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7175 */
/* U+BB08 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7176 */
/* U+BB09 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7177 */
/* U+BB0A */	UNICODE_REPLACEMENT_CHARACTER,	/* 7178 */
/* U+BB0B */	UNICODE_REPLACEMENT_CHARACTER,	/* 7179 */
/* U+BB0C */	UNICODE_REPLACEMENT_CHARACTER,	/* 7180 */
/* U+BB0D */	UNICODE_REPLACEMENT_CHARACTER,	/* 7181 */
/* U+BB0E */	UNICODE_REPLACEMENT_CHARACTER,	/* 7182 */
/* U+BB0F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7183 */
/* U+BB10 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7184 */
/* U+BB11 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7185 */
/* U+BB12 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7186 */
/* U+BB13 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7187 */
/* U+BB14 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7188 */
/* U+BB15 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7189 */
/* U+BB16 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7190 */
/* U+BB17 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7191 */
/* U+BB18 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7192 */
/* U+BB19 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7193 */
/* U+BB1A */	UNICODE_REPLACEMENT_CHARACTER,	/* 7194 */
/* U+BB1B */	UNICODE_REPLACEMENT_CHARACTER,	/* 7195 */
/* U+BB1C */	UNICODE_REPLACEMENT_CHARACTER,	/* 7196 */
/* U+BB1D */	UNICODE_REPLACEMENT_CHARACTER,	/* 7197 */
/* U+BB1E */	UNICODE_REPLACEMENT_CHARACTER,	/* 7198 */
/* U+BB1F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7199 */
/* U+BB20 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7200 */
/* U+BB21 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7201 */
/* U+BB22 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7202 */
/* U+BB23 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7203 */
/* U+BB24 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7204 */
/* U+BB25 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7205 */
/* U+BB26 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7206 */
/* U+BB27 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7207 */
/* U+BB28 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7208 */
/* U+BB29 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7209 */
/* U+BB2A */	UNICODE_REPLACEMENT_CHARACTER,	/* 7210 */
/* U+BB2B */	UNICODE_REPLACEMENT_CHARACTER,	/* 7211 */
/* U+BB2C */	UNICODE_REPLACEMENT_CHARACTER,	/* 7212 */
/* U+BB2D */	UNICODE_REPLACEMENT_CHARACTER,	/* 7213 */
/* U+BB2E */	UNICODE_REPLACEMENT_CHARACTER,	/* 7214 */
/* U+BB2F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7215 */
/* U+BB30 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7216 */
/* U+BB31 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7217 */
/* U+BB32 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7218 */
/* U+BB33 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7219 */
/* U+BB34 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7220 */
/* U+BB35 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7221 */
/* U+BB36 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7222 */
/* U+BB37 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7223 */
/* U+BB38 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7224 */
/* U+BB39 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7225 */
/* U+BB3A */	UNICODE_REPLACEMENT_CHARACTER,	/* 7226 */
/* U+BB3B */	UNICODE_REPLACEMENT_CHARACTER,	/* 7227 */
/* U+BB3C */	UNICODE_REPLACEMENT_CHARACTER,	/* 7228 */
/* U+BB3D */	UNICODE_REPLACEMENT_CHARACTER,	/* 7229 */
/* U+BB3E */	UNICODE_REPLACEMENT_CHARACTER,	/* 7230 */
/* U+BB3F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7231 */
/* U+BB40 */	0x7F70	/*                                         <CJK> */,/* 7232 */
/* U+BB41 */	0x7FE0	/*                                         <CJK> */,/* 7233 */
/* U+BB42 */	0x7FE1	/*                                         <CJK> */,/* 7234 */
/* U+BB43 */	0x7FDF	/*                                         <CJK> */,/* 7235 */
/* U+BB44 */	0x805E	/*                                         <CJK> */,/* 7236 */
/* U+BB45 */	0x805A	/*                                         <CJK> */,/* 7237 */
/* U+BB46 */	0x8087	/*                                         <CJK> */,/* 7238 */
/* U+BB47 */	0x8150	/*                                         <CJK> */,/* 7239 */
/* U+BB48 */	0x8180	/*                                         <CJK> */,/* 7240 */
/* U+BB49 */	0x818F	/*                                         <CJK> */,/* 7241 */
/* U+BB4A */	0x8188	/*                                         <CJK> */,/* 7242 */
/* U+BB4B */	0x818A	/*                                         <CJK> */,/* 7243 */
/* U+BB4C */	0x817F	/*                                         <CJK> */,/* 7244 */
/* U+BB4D */	0x8182	/*                                         <CJK> */,/* 7245 */
/* U+BB4E */	0x81E7	/*                                         <CJK> */,/* 7246 */
/* U+BB4F */	0x81FA	/*                                         <CJK> */,/* 7247 */
/* U+BB50 */	0x8207	/*                                         <CJK> */,/* 7248 */
/* U+BB51 */	0x8214	/*                                         <CJK> */,/* 7249 */
/* U+BB52 */	0x821E	/*                                         <CJK> */,/* 7250 */
/* U+BB53 */	0x824B	/*                                         <CJK> */,/* 7251 */
/* U+BB54 */	0x84C9	/*                                         <CJK> */,/* 7252 */
/* U+BB55 */	0x84BF	/*                                         <CJK> */,/* 7253 */
/* U+BB56 */	0x84C6	/*                                         <CJK> */,/* 7254 */
/* U+BB57 */	0x84C4	/*                                         <CJK> */,/* 7255 */
/* U+BB58 */	0x8499	/*                                         <CJK> */,/* 7256 */
/* U+BB59 */	0x849E	/*                                         <CJK> */,/* 7257 */
/* U+BB5A */	0x84B2	/*                                         <CJK> */,/* 7258 */
/* U+BB5B */	0x849C	/*                                         <CJK> */,/* 7259 */
/* U+BB5C */	0x84CB	/*                                         <CJK> */,/* 7260 */
/* U+BB5D */	0x84B8	/*                                         <CJK> */,/* 7261 */
/* U+BB5E */	0x84C0	/*                                         <CJK> */,/* 7262 */
/* U+BB5F */	0x84D3	/*                                         <CJK> */,/* 7263 */
/* U+BB60 */	0x8490	/*                                         <CJK> */,/* 7264 */
/* U+BB61 */	0x84BC	/*                                         <CJK> */,/* 7265 */
/* U+BB62 */	0x84D1	/*                                         <CJK> */,/* 7266 */
/* U+BB63 */	0x84CA	/*                                         <CJK> */,/* 7267 */
/* U+BB64 */	0x873F	/*                                         <CJK> */,/* 7268 */
/* U+BB65 */	0x871C	/*                                         <CJK> */,/* 7269 */
/* U+BB66 */	0x873B	/*                                         <CJK> */,/* 7270 */
/* U+BB67 */	0x8722	/*                                         <CJK> */,/* 7271 */
/* U+BB68 */	0x8725	/*                                         <CJK> */,/* 7272 */
/* U+BB69 */	0x8734	/*                                         <CJK> */,/* 7273 */
/* U+BB6A */	0x8718	/*                                         <CJK> */,/* 7274 */
/* U+BB6B */	0x8755	/*                                         <CJK> */,/* 7275 */
/* U+BB6C */	0x8737	/*                                         <CJK> */,/* 7276 */
/* U+BB6D */	0x8729	/*                                         <CJK> */,/* 7277 */
/* U+BB6E */	0x88F3	/*                                         <CJK> */,/* 7278 */
/* U+BB6F */	0x8902	/*                                         <CJK> */,/* 7279 */
/* U+BB70 */	0x88F4	/*                                         <CJK> */,/* 7280 */
/* U+BB71 */	0x88F9	/*                                         <CJK> */,/* 7281 */
/* U+BB72 */	0x88F8	/*                                         <CJK> */,/* 7282 */
/* U+BB73 */	0x88FD	/*                                         <CJK> */,/* 7283 */
/* U+BB74 */	0x88E8	/*                                         <CJK> */,/* 7284 */
/* U+BB75 */	0x891A	/*                                         <CJK> */,/* 7285 */
/* U+BB76 */	0x88EF	/*                                         <CJK> */,/* 7286 */
/* U+BB77 */	0x8AA6	/*                                         <CJK> */,/* 7287 */
/* U+BB78 */	0x8A8C	/*                                         <CJK> */,/* 7288 */
/* U+BB79 */	0x8A9E	/*                                         <CJK> */,/* 7289 */
/* U+BB7A */	0x8AA3	/*                                         <CJK> */,/* 7290 */
/* U+BB7B */	0x8A8D	/*                                         <CJK> */,/* 7291 */
/* U+BB7C */	0x8AA1	/*                                         <CJK> */,/* 7292 */
/* U+BB7D */	0x8A93	/*                                         <CJK> */,/* 7293 */
/* U+BB7E */	0x8AA4	/*                                         <CJK> */,/* 7294 */
/* U+BB7F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7295 */
/* U+BB80 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7296 */
/* U+BB81 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7297 */
/* U+BB82 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7298 */
/* U+BB83 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7299 */
/* U+BB84 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7300 */
/* U+BB85 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7301 */
/* U+BB86 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7302 */
/* U+BB87 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7303 */
/* U+BB88 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7304 */
/* U+BB89 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7305 */
/* U+BB8A */	UNICODE_REPLACEMENT_CHARACTER,	/* 7306 */
/* U+BB8B */	UNICODE_REPLACEMENT_CHARACTER,	/* 7307 */
/* U+BB8C */	UNICODE_REPLACEMENT_CHARACTER,	/* 7308 */
/* U+BB8D */	UNICODE_REPLACEMENT_CHARACTER,	/* 7309 */
/* U+BB8E */	UNICODE_REPLACEMENT_CHARACTER,	/* 7310 */
/* U+BB8F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7311 */
/* U+BB90 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7312 */
/* U+BB91 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7313 */
/* U+BB92 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7314 */
/* U+BB93 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7315 */
/* U+BB94 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7316 */
/* U+BB95 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7317 */
/* U+BB96 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7318 */
/* U+BB97 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7319 */
/* U+BB98 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7320 */
/* U+BB99 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7321 */
/* U+BB9A */	UNICODE_REPLACEMENT_CHARACTER,	/* 7322 */
/* U+BB9B */	UNICODE_REPLACEMENT_CHARACTER,	/* 7323 */
/* U+BB9C */	UNICODE_REPLACEMENT_CHARACTER,	/* 7324 */
/* U+BB9D */	UNICODE_REPLACEMENT_CHARACTER,	/* 7325 */
/* U+BB9E */	UNICODE_REPLACEMENT_CHARACTER,	/* 7326 */
/* U+BB9F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7327 */
/* U+BBA0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7328 */
/* U+BBA1 */	0x8AAA	/*                                         <CJK> */,/* 7329 */
/* U+BBA2 */	0x8AA5	/*                                         <CJK> */,/* 7330 */
/* U+BBA3 */	0x8AA8	/*                                         <CJK> */,/* 7331 */
/* U+BBA4 */	0x8A98	/*                                         <CJK> */,/* 7332 */
/* U+BBA5 */	0x8A91	/*                                         <CJK> */,/* 7333 */
/* U+BBA6 */	0x8A9A	/*                                         <CJK> */,/* 7334 */
/* U+BBA7 */	0x8AA7	/*                                         <CJK> */,/* 7335 */
/* U+BBA8 */	0x8C6A	/*                                         <CJK> */,/* 7336 */
/* U+BBA9 */	0x8C8D	/*                                         <CJK> */,/* 7337 */
/* U+BBAA */	0x8C8C	/*                                         <CJK> */,/* 7338 */
/* U+BBAB */	0x8CD3	/*                                         <CJK> */,/* 7339 */
/* U+BBAC */	0x8CD1	/*                                         <CJK> */,/* 7340 */
/* U+BBAD */	0x8CD2	/*                                         <CJK> */,/* 7341 */
/* U+BBAE */	0x8D6B	/*                                         <CJK> */,/* 7342 */
/* U+BBAF */	0x8D99	/*                                         <CJK> */,/* 7343 */
/* U+BBB0 */	0x8D95	/*                                         <CJK> */,/* 7344 */
/* U+BBB1 */	0x8DFC	/*                                         <CJK> */,/* 7345 */
/* U+BBB2 */	0x8F14	/*                                         <CJK> */,/* 7346 */
/* U+BBB3 */	0x8F12	/*                                         <CJK> */,/* 7347 */
/* U+BBB4 */	0x8F15	/*                                         <CJK> */,/* 7348 */
/* U+BBB5 */	0x8F13	/*                                         <CJK> */,/* 7349 */
/* U+BBB6 */	0x8FA3	/*                                         <CJK> */,/* 7350 */
/* U+BBB7 */	0x9060	/*                                         <CJK> */,/* 7351 */
/* U+BBB8 */	0x9058	/*                                         <CJK> */,/* 7352 */
/* U+BBB9 */	0x905C	/*                                         <CJK> */,/* 7353 */
/* U+BBBA */	0x9063	/*                                         <CJK> */,/* 7354 */
/* U+BBBB */	0x9059	/*                                         <CJK> */,/* 7355 */
/* U+BBBC */	0x905E	/*                                         <CJK> */,/* 7356 */
/* U+BBBD */	0x9062	/*                                         <CJK> */,/* 7357 */
/* U+BBBE */	0x905D	/*                                         <CJK> */,/* 7358 */
/* U+BBBF */	0x905B	/*                                         <CJK> */,/* 7359 */
/* U+BBC0 */	0x9119	/*                                         <CJK> */,/* 7360 */
/* U+BBC1 */	0x9118	/*                                         <CJK> */,/* 7361 */
/* U+BBC2 */	0x911E	/*                                         <CJK> */,/* 7362 */
/* U+BBC3 */	0x9175	/*                                         <CJK> */,/* 7363 */
/* U+BBC4 */	0x9178	/*                                         <CJK> */,/* 7364 */
/* U+BBC5 */	0x9177	/*                                         <CJK> */,/* 7365 */
/* U+BBC6 */	0x9174	/*                                         <CJK> */,/* 7366 */
/* U+BBC7 */	0x9278	/*                                         <CJK> */,/* 7367 */
/* U+BBC8 */	0x9280	/*                                         <CJK> */,/* 7368 */
/* U+BBC9 */	0x9285	/*                                         <CJK> */,/* 7369 */
/* U+BBCA */	0x9298	/*                                         <CJK> */,/* 7370 */
/* U+BBCB */	0x9296	/*                                         <CJK> */,/* 7371 */
/* U+BBCC */	0x927B	/*                                         <CJK> */,/* 7372 */
/* U+BBCD */	0x9293	/*                                         <CJK> */,/* 7373 */
/* U+BBCE */	0x929C	/*                                         <CJK> */,/* 7374 */
/* U+BBCF */	0x92A8	/*                                         <CJK> */,/* 7375 */
/* U+BBD0 */	0x927C	/*                                         <CJK> */,/* 7376 */
/* U+BBD1 */	0x9291	/*                                         <CJK> */,/* 7377 */
/* U+BBD2 */	0x95A1	/*                                         <CJK> */,/* 7378 */
/* U+BBD3 */	0x95A8	/*                                         <CJK> */,/* 7379 */
/* U+BBD4 */	0x95A9	/*                                         <CJK> */,/* 7380 */
/* U+BBD5 */	0x95A3	/*                                         <CJK> */,/* 7381 */
/* U+BBD6 */	0x95A5	/*                                         <CJK> */,/* 7382 */
/* U+BBD7 */	0x95A4	/*                                         <CJK> */,/* 7383 */
/* U+BBD8 */	0x9699	/*                                         <CJK> */,/* 7384 */
/* U+BBD9 */	0x969C	/*                                         <CJK> */,/* 7385 */
/* U+BBDA */	0x969B	/*                                         <CJK> */,/* 7386 */
/* U+BBDB */	0x96CC	/*                                         <CJK> */,/* 7387 */
/* U+BBDC */	0x96D2	/*                                         <CJK> */,/* 7388 */
/* U+BBDD */	0x9700	/*                                         <CJK> */,/* 7389 */
/* U+BBDE */	0x977C	/*                                         <CJK> */,/* 7390 */
/* U+BBDF */	0x9785	/*                                         <CJK> */,/* 7391 */
/* U+BBE0 */	0x97F6	/*                                         <CJK> */,/* 7392 */
/* U+BBE1 */	0x9817	/*                                         <CJK> */,/* 7393 */
/* U+BBE2 */	0x9818	/*                                         <CJK> */,/* 7394 */
/* U+BBE3 */	0x98AF	/*                                         <CJK> */,/* 7395 */
/* U+BBE4 */	0x98B1	/*                                         <CJK> */,/* 7396 */
/* U+BBE5 */	0x9903	/*                                         <CJK> */,/* 7397 */
/* U+BBE6 */	0x9905	/*                                         <CJK> */,/* 7398 */
/* U+BBE7 */	0x990C	/*                                         <CJK> */,/* 7399 */
/* U+BBE8 */	0x9909	/*                                         <CJK> */,/* 7400 */
/* U+BBE9 */	0x99C1	/*                                         <CJK> */,/* 7401 */
/* U+BBEA */	0x9AAF	/*                                         <CJK> */,/* 7402 */
/* U+BBEB */	0x9AB0	/*                                         <CJK> */,/* 7403 */
/* U+BBEC */	0x9AE6	/*                                         <CJK> */,/* 7404 */
/* U+BBED */	0x9B41	/*                                         <CJK> */,/* 7405 */
/* U+BBEE */	0x9B42	/*                                         <CJK> */,/* 7406 */
/* U+BBEF */	0x9CF4	/*                                         <CJK> */,/* 7407 */
/* U+BBF0 */	0x9CF6	/*                                         <CJK> */,/* 7408 */
/* U+BBF1 */	0x9CF3	/*                                         <CJK> */,/* 7409 */
/* U+BBF2 */	0x9EBC	/*                                         <CJK> */,/* 7410 */
/* U+BBF3 */	0x9F3B	/*                                         <CJK> */,/* 7411 */
/* U+BBF4 */	0x9F4A	/*                                         <CJK> */,/* 7412 */
/* U+BBF5 */	0x5104	/*                                         <CJK> */,/* 7413 */
/* U+BBF6 */	0x5100	/*                                         <CJK> */,/* 7414 */
/* U+BBF7 */	0x50FB	/*                                         <CJK> */,/* 7415 */
/* U+BBF8 */	0x50F5	/*                                         <CJK> */,/* 7416 */
/* U+BBF9 */	0x50F9	/*                                         <CJK> */,/* 7417 */
/* U+BBFA */	0x5102	/*                                         <CJK> */,/* 7418 */
/* U+BBFB */	0x5108	/*                                         <CJK> */,/* 7419 */
/* U+BBFC */	0x5109	/*                                         <CJK> */,/* 7420 */
/* U+BBFD */	0x5105	/*                                         <CJK> */,/* 7421 */
/* U+BBFE */	0x51DC	/*                                         <CJK> */,/* 7422 */
/* U+BBFF */	UNICODE_REPLACEMENT_CHARACTER,	/* 7423 */
/* U+BC00 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7424 */
/* U+BC01 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7425 */
/* U+BC02 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7426 */
/* U+BC03 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7427 */
/* U+BC04 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7428 */
/* U+BC05 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7429 */
/* U+BC06 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7430 */
/* U+BC07 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7431 */
/* U+BC08 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7432 */
/* U+BC09 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7433 */
/* U+BC0A */	UNICODE_REPLACEMENT_CHARACTER,	/* 7434 */
/* U+BC0B */	UNICODE_REPLACEMENT_CHARACTER,	/* 7435 */
/* U+BC0C */	UNICODE_REPLACEMENT_CHARACTER,	/* 7436 */
/* U+BC0D */	UNICODE_REPLACEMENT_CHARACTER,	/* 7437 */
/* U+BC0E */	UNICODE_REPLACEMENT_CHARACTER,	/* 7438 */
/* U+BC0F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7439 */
/* U+BC10 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7440 */
/* U+BC11 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7441 */
/* U+BC12 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7442 */
/* U+BC13 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7443 */
/* U+BC14 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7444 */
/* U+BC15 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7445 */
/* U+BC16 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7446 */
/* U+BC17 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7447 */
/* U+BC18 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7448 */
/* U+BC19 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7449 */
/* U+BC1A */	UNICODE_REPLACEMENT_CHARACTER,	/* 7450 */
/* U+BC1B */	UNICODE_REPLACEMENT_CHARACTER,	/* 7451 */
/* U+BC1C */	UNICODE_REPLACEMENT_CHARACTER,	/* 7452 */
/* U+BC1D */	UNICODE_REPLACEMENT_CHARACTER,	/* 7453 */
/* U+BC1E */	UNICODE_REPLACEMENT_CHARACTER,	/* 7454 */
/* U+BC1F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7455 */
/* U+BC20 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7456 */
/* U+BC21 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7457 */
/* U+BC22 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7458 */
/* U+BC23 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7459 */
/* U+BC24 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7460 */
/* U+BC25 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7461 */
/* U+BC26 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7462 */
/* U+BC27 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7463 */
/* U+BC28 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7464 */
/* U+BC29 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7465 */
/* U+BC2A */	UNICODE_REPLACEMENT_CHARACTER,	/* 7466 */
/* U+BC2B */	UNICODE_REPLACEMENT_CHARACTER,	/* 7467 */
/* U+BC2C */	UNICODE_REPLACEMENT_CHARACTER,	/* 7468 */
/* U+BC2D */	UNICODE_REPLACEMENT_CHARACTER,	/* 7469 */
/* U+BC2E */	UNICODE_REPLACEMENT_CHARACTER,	/* 7470 */
/* U+BC2F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7471 */
/* U+BC30 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7472 */
/* U+BC31 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7473 */
/* U+BC32 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7474 */
/* U+BC33 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7475 */
/* U+BC34 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7476 */
/* U+BC35 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7477 */
/* U+BC36 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7478 */
/* U+BC37 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7479 */
/* U+BC38 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7480 */
/* U+BC39 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7481 */
/* U+BC3A */	UNICODE_REPLACEMENT_CHARACTER,	/* 7482 */
/* U+BC3B */	UNICODE_REPLACEMENT_CHARACTER,	/* 7483 */
/* U+BC3C */	UNICODE_REPLACEMENT_CHARACTER,	/* 7484 */
/* U+BC3D */	UNICODE_REPLACEMENT_CHARACTER,	/* 7485 */
/* U+BC3E */	UNICODE_REPLACEMENT_CHARACTER,	/* 7486 */
/* U+BC3F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7487 */
/* U+BC40 */	0x5287	/*                                         <CJK> */,/* 7488 */
/* U+BC41 */	0x5288	/*                                         <CJK> */,/* 7489 */
/* U+BC42 */	0x5289	/*                                         <CJK> */,/* 7490 */
/* U+BC43 */	0x528D	/*                                         <CJK> */,/* 7491 */
/* U+BC44 */	0x528A	/*                                         <CJK> */,/* 7492 */
/* U+BC45 */	0x52F0	/*                                         <CJK> */,/* 7493 */
/* U+BC46 */	0x53B2	/*                                         <CJK> */,/* 7494 */
/* U+BC47 */	0x562E	/*                                         <CJK> */,/* 7495 */
/* U+BC48 */	0x563B	/*                                         <CJK> */,/* 7496 */
/* U+BC49 */	0x5639	/*                                         <CJK> */,/* 7497 */
/* U+BC4A */	0x5632	/*                                         <CJK> */,/* 7498 */
/* U+BC4B */	0x563F	/*                                         <CJK> */,/* 7499 */
/* U+BC4C */	0x5634	/*                                         <CJK> */,/* 7500 */
/* U+BC4D */	0x5629	/*                                         <CJK> */,/* 7501 */
/* U+BC4E */	0x5653	/*                                         <CJK> */,/* 7502 */
/* U+BC4F */	0x564E	/*                                         <CJK> */,/* 7503 */
/* U+BC50 */	0x5657	/*                                         <CJK> */,/* 7504 */
/* U+BC51 */	0x5674	/*                                         <CJK> */,/* 7505 */
/* U+BC52 */	0x5636	/*                                         <CJK> */,/* 7506 */
/* U+BC53 */	0x562F	/*                                         <CJK> */,/* 7507 */
/* U+BC54 */	0x5630	/*                                         <CJK> */,/* 7508 */
/* U+BC55 */	0x5880	/*                                         <CJK> */,/* 7509 */
/* U+BC56 */	0x589F	/*                                         <CJK> */,/* 7510 */
/* U+BC57 */	0x589E	/*                                         <CJK> */,/* 7511 */
/* U+BC58 */	0x58B3	/*                                         <CJK> */,/* 7512 */
/* U+BC59 */	0x589C	/*                                         <CJK> */,/* 7513 */
/* U+BC5A */	0x58AE	/*                                         <CJK> */,/* 7514 */
/* U+BC5B */	0x58A9	/*                                         <CJK> */,/* 7515 */
/* U+BC5C */	0x58A6	/*                                         <CJK> */,/* 7516 */
/* U+BC5D */	0x596D	/*                                         <CJK> */,/* 7517 */
/* U+BC5E */	0x5B09	/*                                         <CJK> */,/* 7518 */
/* U+BC5F */	0x5AFB	/*                                         <CJK> */,/* 7519 */
/* U+BC60 */	0x5B0B	/*                                         <CJK> */,/* 7520 */
/* U+BC61 */	0x5AF5	/*                                         <CJK> */,/* 7521 */
/* U+BC62 */	0x5B0C	/*                                         <CJK> */,/* 7522 */
/* U+BC63 */	0x5B08	/*                                         <CJK> */,/* 7523 */
/* U+BC64 */	0x5BEE	/*                                         <CJK> */,/* 7524 */
/* U+BC65 */	0x5BEC	/*                                         <CJK> */,/* 7525 */
/* U+BC66 */	0x5BE9	/*                                         <CJK> */,/* 7526 */
/* U+BC67 */	0x5BEB	/*                                         <CJK> */,/* 7527 */
/* U+BC68 */	0x5C64	/*                                         <CJK> */,/* 7528 */
/* U+BC69 */	0x5C65	/*                                         <CJK> */,/* 7529 */
/* U+BC6A */	0x5D9D	/*                                         <CJK> */,/* 7530 */
/* U+BC6B */	0x5D94	/*                                         <CJK> */,/* 7531 */
/* U+BC6C */	0x5E62	/*                                         <CJK> */,/* 7532 */
/* U+BC6D */	0x5E5F	/*                                         <CJK> */,/* 7533 */
/* U+BC6E */	0x5E61	/*                                         <CJK> */,/* 7534 */
/* U+BC6F */	0x5EE2	/*                                         <CJK> */,/* 7535 */
/* U+BC70 */	0x5EDA	/*                                         <CJK> */,/* 7536 */
/* U+BC71 */	0x5EDF	/*                                         <CJK> */,/* 7537 */
/* U+BC72 */	0x5EDD	/*                                         <CJK> */,/* 7538 */
/* U+BC73 */	0x5EE3	/*                                         <CJK> */,/* 7539 */
/* U+BC74 */	0x5EE0	/*                                         <CJK> */,/* 7540 */
/* U+BC75 */	0x5F48	/*                                         <CJK> */,/* 7541 */
/* U+BC76 */	0x5F71	/*                                         <CJK> */,/* 7542 */
/* U+BC77 */	0x5FB7	/*                                         <CJK> */,/* 7543 */
/* U+BC78 */	0x5FB5	/*                                         <CJK> */,/* 7544 */
/* U+BC79 */	0x6176	/*                                         <CJK> */,/* 7545 */
/* U+BC7A */	0x6167	/*                                         <CJK> */,/* 7546 */
/* U+BC7B */	0x616E	/*                                         <CJK> */,/* 7547 */
/* U+BC7C */	0x615D	/*                                         <CJK> */,/* 7548 */
/* U+BC7D */	0x6155	/*                                         <CJK> */,/* 7549 */
/* U+BC7E */	0x6182	/*                                         <CJK> */,/* 7550 */
/* U+BC7F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7551 */
/* U+BC80 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7552 */
/* U+BC81 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7553 */
/* U+BC82 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7554 */
/* U+BC83 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7555 */
/* U+BC84 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7556 */
/* U+BC85 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7557 */
/* U+BC86 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7558 */
/* U+BC87 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7559 */
/* U+BC88 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7560 */
/* U+BC89 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7561 */
/* U+BC8A */	UNICODE_REPLACEMENT_CHARACTER,	/* 7562 */
/* U+BC8B */	UNICODE_REPLACEMENT_CHARACTER,	/* 7563 */
/* U+BC8C */	UNICODE_REPLACEMENT_CHARACTER,	/* 7564 */
/* U+BC8D */	UNICODE_REPLACEMENT_CHARACTER,	/* 7565 */
/* U+BC8E */	UNICODE_REPLACEMENT_CHARACTER,	/* 7566 */
/* U+BC8F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7567 */
/* U+BC90 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7568 */
/* U+BC91 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7569 */
/* U+BC92 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7570 */
/* U+BC93 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7571 */
/* U+BC94 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7572 */
/* U+BC95 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7573 */
/* U+BC96 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7574 */
/* U+BC97 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7575 */
/* U+BC98 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7576 */
/* U+BC99 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7577 */
/* U+BC9A */	UNICODE_REPLACEMENT_CHARACTER,	/* 7578 */
/* U+BC9B */	UNICODE_REPLACEMENT_CHARACTER,	/* 7579 */
/* U+BC9C */	UNICODE_REPLACEMENT_CHARACTER,	/* 7580 */
/* U+BC9D */	UNICODE_REPLACEMENT_CHARACTER,	/* 7581 */
/* U+BC9E */	UNICODE_REPLACEMENT_CHARACTER,	/* 7582 */
/* U+BC9F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7583 */
/* U+BCA0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7584 */
/* U+BCA1 */	0x617C	/*                                         <CJK> */,/* 7585 */
/* U+BCA2 */	0x6170	/*                                         <CJK> */,/* 7586 */
/* U+BCA3 */	0x616B	/*                                         <CJK> */,/* 7587 */
/* U+BCA4 */	0x617E	/*                                         <CJK> */,/* 7588 */
/* U+BCA5 */	0x61A7	/*                                         <CJK> */,/* 7589 */
/* U+BCA6 */	0x6190	/*                                         <CJK> */,/* 7590 */
/* U+BCA7 */	0x61AB	/*                                         <CJK> */,/* 7591 */
/* U+BCA8 */	0x618E	/*                                         <CJK> */,/* 7592 */
/* U+BCA9 */	0x61AC	/*                                         <CJK> */,/* 7593 */
/* U+BCAA */	0x619A	/*                                         <CJK> */,/* 7594 */
/* U+BCAB */	0x61A4	/*                                         <CJK> */,/* 7595 */
/* U+BCAC */	0x6194	/*                                         <CJK> */,/* 7596 */
/* U+BCAD */	0x61AE	/*                                         <CJK> */,/* 7597 */
/* U+BCAE */	0x622E	/*                                         <CJK> */,/* 7598 */
/* U+BCAF */	0x6469	/*                                         <CJK> */,/* 7599 */
/* U+BCB0 */	0x646F	/*                                         <CJK> */,/* 7600 */
/* U+BCB1 */	0x6479	/*                                         <CJK> */,/* 7601 */
/* U+BCB2 */	0x649E	/*                                         <CJK> */,/* 7602 */
/* U+BCB3 */	0x64B2	/*                                         <CJK> */,/* 7603 */
/* U+BCB4 */	0x6488	/*                                         <CJK> */,/* 7604 */
/* U+BCB5 */	0x6490	/*                                         <CJK> */,/* 7605 */
/* U+BCB6 */	0x64B0	/*                                         <CJK> */,/* 7606 */
/* U+BCB7 */	0x64A5	/*                                         <CJK> */,/* 7607 */
/* U+BCB8 */	0x6493	/*                                         <CJK> */,/* 7608 */
/* U+BCB9 */	0x6495	/*                                         <CJK> */,/* 7609 */
/* U+BCBA */	0x64A9	/*                                         <CJK> */,/* 7610 */
/* U+BCBB */	0x6492	/*                                         <CJK> */,/* 7611 */
/* U+BCBC */	0x64AE	/*                                         <CJK> */,/* 7612 */
/* U+BCBD */	0x64AD	/*                                         <CJK> */,/* 7613 */
/* U+BCBE */	0x64AB	/*                                         <CJK> */,/* 7614 */
/* U+BCBF */	0x649A	/*                                         <CJK> */,/* 7615 */
/* U+BCC0 */	0x64AC	/*                                         <CJK> */,/* 7616 */
/* U+BCC1 */	0x6499	/*                                         <CJK> */,/* 7617 */
/* U+BCC2 */	0x64A2	/*                                         <CJK> */,/* 7618 */
/* U+BCC3 */	0x64B3	/*                                         <CJK> */,/* 7619 */
/* U+BCC4 */	0x6575	/*                                         <CJK> */,/* 7620 */
/* U+BCC5 */	0x6577	/*                                         <CJK> */,/* 7621 */
/* U+BCC6 */	0x6578	/*                                         <CJK> */,/* 7622 */
/* U+BCC7 */	0x66AE	/*                                         <CJK> */,/* 7623 */
/* U+BCC8 */	0x66AB	/*                                         <CJK> */,/* 7624 */
/* U+BCC9 */	0x66B4	/*                                         <CJK> */,/* 7625 */
/* U+BCCA */	0x66B1	/*                                         <CJK> */,/* 7626 */
/* U+BCCB */	0x6A23	/*                                         <CJK> */,/* 7627 */
/* U+BCCC */	0x6A1F	/*                                         <CJK> */,/* 7628 */
/* U+BCCD */	0x69E8	/*                                         <CJK> */,/* 7629 */
/* U+BCCE */	0x6A01	/*                                         <CJK> */,/* 7630 */
/* U+BCCF */	0x6A1E	/*                                         <CJK> */,/* 7631 */
/* U+BCD0 */	0x6A19	/*                                         <CJK> */,/* 7632 */
/* U+BCD1 */	0x69FD	/*                                         <CJK> */,/* 7633 */
/* U+BCD2 */	0x6A21	/*                                         <CJK> */,/* 7634 */
/* U+BCD3 */	0x6A13	/*                                         <CJK> */,/* 7635 */
/* U+BCD4 */	0x6A0A	/*                                         <CJK> */,/* 7636 */
/* U+BCD5 */	0x69F3	/*                                         <CJK> */,/* 7637 */
/* U+BCD6 */	0x6A02	/*                                         <CJK> */,/* 7638 */
/* U+BCD7 */	0x6A05	/*                                         <CJK> */,/* 7639 */
/* U+BCD8 */	0x69ED	/*                                         <CJK> */,/* 7640 */
/* U+BCD9 */	0x6A11	/*                                         <CJK> */,/* 7641 */
/* U+BCDA */	0x6B50	/*                                         <CJK> */,/* 7642 */
/* U+BCDB */	0x6B4E	/*                                         <CJK> */,/* 7643 */
/* U+BCDC */	0x6BA4	/*                                         <CJK> */,/* 7644 */
/* U+BCDD */	0x6BC5	/*                                         <CJK> */,/* 7645 */
/* U+BCDE */	0x6BC6	/*                                         <CJK> */,/* 7646 */
/* U+BCDF */	0x6F3F	/*                                         <CJK> */,/* 7647 */
/* U+BCE0 */	0x6F7C	/*                                         <CJK> */,/* 7648 */
/* U+BCE1 */	0x6F84	/*                                         <CJK> */,/* 7649 */
/* U+BCE2 */	0x6F51	/*                                         <CJK> */,/* 7650 */
/* U+BCE3 */	0x6F66	/*                                         <CJK> */,/* 7651 */
/* U+BCE4 */	0x6F54	/*                                         <CJK> */,/* 7652 */
/* U+BCE5 */	0x6F86	/*                                         <CJK> */,/* 7653 */
/* U+BCE6 */	0x6F6D	/*                                         <CJK> */,/* 7654 */
/* U+BCE7 */	0x6F5B	/*                                         <CJK> */,/* 7655 */
/* U+BCE8 */	0x6F78	/*                                         <CJK> */,/* 7656 */
/* U+BCE9 */	0x6F6E	/*                                         <CJK> */,/* 7657 */
/* U+BCEA */	0x6F8E	/*                                         <CJK> */,/* 7658 */
/* U+BCEB */	0x6F7A	/*                                         <CJK> */,/* 7659 */
/* U+BCEC */	0x6F70	/*                                         <CJK> */,/* 7660 */
/* U+BCED */	0x6F64	/*                                         <CJK> */,/* 7661 */
/* U+BCEE */	0x6F97	/*                                         <CJK> */,/* 7662 */
/* U+BCEF */	0x6F58	/*                                         <CJK> */,/* 7663 */
/* U+BCF0 */	0x6ED5	/*                                         <CJK> */,/* 7664 */
/* U+BCF1 */	0x6F6F	/*                                         <CJK> */,/* 7665 */
/* U+BCF2 */	0x6F60	/*                                         <CJK> */,/* 7666 */
/* U+BCF3 */	0x6F5F	/*                                         <CJK> */,/* 7667 */
/* U+BCF4 */	0x719F	/*                                         <CJK> */,/* 7668 */
/* U+BCF5 */	0x71AC	/*                                         <CJK> */,/* 7669 */
/* U+BCF6 */	0x71B1	/*                                         <CJK> */,/* 7670 */
/* U+BCF7 */	0x71A8	/*                                         <CJK> */,/* 7671 */
/* U+BCF8 */	0x7256	/*                                         <CJK> */,/* 7672 */
/* U+BCF9 */	0x729B	/*                                         <CJK> */,/* 7673 */
/* U+BCFA */	0x734E	/*                                         <CJK> */,/* 7674 */
/* U+BCFB */	0x7357	/*                                         <CJK> */,/* 7675 */
/* U+BCFC */	0x7469	/*                                         <CJK> */,/* 7676 */
/* U+BCFD */	0x748B	/*                                         <CJK> */,/* 7677 */
/* U+BCFE */	0x7483	/*                                         <CJK> */,/* 7678 */
/* U+BCFF */	UNICODE_REPLACEMENT_CHARACTER,	/* 7679 */
/* U+BD00 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7680 */
/* U+BD01 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7681 */
/* U+BD02 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7682 */
/* U+BD03 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7683 */
/* U+BD04 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7684 */
/* U+BD05 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7685 */
/* U+BD06 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7686 */
/* U+BD07 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7687 */
/* U+BD08 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7688 */
/* U+BD09 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7689 */
/* U+BD0A */	UNICODE_REPLACEMENT_CHARACTER,	/* 7690 */
/* U+BD0B */	UNICODE_REPLACEMENT_CHARACTER,	/* 7691 */
/* U+BD0C */	UNICODE_REPLACEMENT_CHARACTER,	/* 7692 */
/* U+BD0D */	UNICODE_REPLACEMENT_CHARACTER,	/* 7693 */
/* U+BD0E */	UNICODE_REPLACEMENT_CHARACTER,	/* 7694 */
/* U+BD0F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7695 */
/* U+BD10 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7696 */
/* U+BD11 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7697 */
/* U+BD12 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7698 */
/* U+BD13 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7699 */
/* U+BD14 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7700 */
/* U+BD15 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7701 */
/* U+BD16 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7702 */
/* U+BD17 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7703 */
/* U+BD18 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7704 */
/* U+BD19 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7705 */
/* U+BD1A */	UNICODE_REPLACEMENT_CHARACTER,	/* 7706 */
/* U+BD1B */	UNICODE_REPLACEMENT_CHARACTER,	/* 7707 */
/* U+BD1C */	UNICODE_REPLACEMENT_CHARACTER,	/* 7708 */
/* U+BD1D */	UNICODE_REPLACEMENT_CHARACTER,	/* 7709 */
/* U+BD1E */	UNICODE_REPLACEMENT_CHARACTER,	/* 7710 */
/* U+BD1F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7711 */
/* U+BD20 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7712 */
/* U+BD21 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7713 */
/* U+BD22 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7714 */
/* U+BD23 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7715 */
/* U+BD24 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7716 */
/* U+BD25 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7717 */
/* U+BD26 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7718 */
/* U+BD27 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7719 */
/* U+BD28 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7720 */
/* U+BD29 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7721 */
/* U+BD2A */	UNICODE_REPLACEMENT_CHARACTER,	/* 7722 */
/* U+BD2B */	UNICODE_REPLACEMENT_CHARACTER,	/* 7723 */
/* U+BD2C */	UNICODE_REPLACEMENT_CHARACTER,	/* 7724 */
/* U+BD2D */	UNICODE_REPLACEMENT_CHARACTER,	/* 7725 */
/* U+BD2E */	UNICODE_REPLACEMENT_CHARACTER,	/* 7726 */
/* U+BD2F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7727 */
/* U+BD30 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7728 */
/* U+BD31 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7729 */
/* U+BD32 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7730 */
/* U+BD33 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7731 */
/* U+BD34 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7732 */
/* U+BD35 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7733 */
/* U+BD36 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7734 */
/* U+BD37 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7735 */
/* U+BD38 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7736 */
/* U+BD39 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7737 */
/* U+BD3A */	UNICODE_REPLACEMENT_CHARACTER,	/* 7738 */
/* U+BD3B */	UNICODE_REPLACEMENT_CHARACTER,	/* 7739 */
/* U+BD3C */	UNICODE_REPLACEMENT_CHARACTER,	/* 7740 */
/* U+BD3D */	UNICODE_REPLACEMENT_CHARACTER,	/* 7741 */
/* U+BD3E */	UNICODE_REPLACEMENT_CHARACTER,	/* 7742 */
/* U+BD3F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7743 */
/* U+BD40 */	0x747E	/*                                         <CJK> */,/* 7744 */
/* U+BD41 */	0x7480	/*                                         <CJK> */,/* 7745 */
/* U+BD42 */	0x757F	/*                                         <CJK> */,/* 7746 */
/* U+BD43 */	0x7620	/*                                         <CJK> */,/* 7747 */
/* U+BD44 */	0x7629	/*                                         <CJK> */,/* 7748 */
/* U+BD45 */	0x761F	/*                                         <CJK> */,/* 7749 */
/* U+BD46 */	0x7624	/*                                         <CJK> */,/* 7750 */
/* U+BD47 */	0x7626	/*                                         <CJK> */,/* 7751 */
/* U+BD48 */	0x7621	/*                                         <CJK> */,/* 7752 */
/* U+BD49 */	0x7622	/*                                         <CJK> */,/* 7753 */
/* U+BD4A */	0x769A	/*                                         <CJK> */,/* 7754 */
/* U+BD4B */	0x76BA	/*                                         <CJK> */,/* 7755 */
/* U+BD4C */	0x76E4	/*                                         <CJK> */,/* 7756 */
/* U+BD4D */	0x778E	/*                                         <CJK> */,/* 7757 */
/* U+BD4E */	0x7787	/*                                         <CJK> */,/* 7758 */
/* U+BD4F */	0x778C	/*                                         <CJK> */,/* 7759 */
/* U+BD50 */	0x7791	/*                                         <CJK> */,/* 7760 */
/* U+BD51 */	0x778B	/*                                         <CJK> */,/* 7761 */
/* U+BD52 */	0x78CB	/*                                         <CJK> */,/* 7762 */
/* U+BD53 */	0x78C5	/*                                         <CJK> */,/* 7763 */
/* U+BD54 */	0x78BA	/*                                         <CJK> */,/* 7764 */
/* U+BD55 */	0x78CA	/*                                         <CJK> */,/* 7765 */
/* U+BD56 */	0x78BE	/*                                         <CJK> */,/* 7766 */
/* U+BD57 */	0x78D5	/*                                         <CJK> */,/* 7767 */
/* U+BD58 */	0x78BC	/*                                         <CJK> */,/* 7768 */
/* U+BD59 */	0x78D0	/*                                         <CJK> */,/* 7769 */
/* U+BD5A */	0x7A3F	/*                                         <CJK> */,/* 7770 */
/* U+BD5B */	0x7A3C	/*                                         <CJK> */,/* 7771 */
/* U+BD5C */	0x7A40	/*                                         <CJK> */,/* 7772 */
/* U+BD5D */	0x7A3D	/*                                         <CJK> */,/* 7773 */
/* U+BD5E */	0x7A37	/*                                         <CJK> */,/* 7774 */
/* U+BD5F */	0x7A3B	/*                                         <CJK> */,/* 7775 */
/* U+BD60 */	0x7AAF	/*                                         <CJK> */,/* 7776 */
/* U+BD61 */	0x7AAE	/*                                         <CJK> */,/* 7777 */
/* U+BD62 */	0x7BAD	/*                                         <CJK> */,/* 7778 */
/* U+BD63 */	0x7BB1	/*                                         <CJK> */,/* 7779 */
/* U+BD64 */	0x7BC4	/*                                         <CJK> */,/* 7780 */
/* U+BD65 */	0x7BB4	/*                                         <CJK> */,/* 7781 */
/* U+BD66 */	0x7BC6	/*                                         <CJK> */,/* 7782 */
/* U+BD67 */	0x7BC7	/*                                         <CJK> */,/* 7783 */
/* U+BD68 */	0x7BC1	/*                                         <CJK> */,/* 7784 */
/* U+BD69 */	0x7BA0	/*                                         <CJK> */,/* 7785 */
/* U+BD6A */	0x7BCC	/*                                         <CJK> */,/* 7786 */
/* U+BD6B */	0x7CCA	/*                                         <CJK> */,/* 7787 */
/* U+BD6C */	0x7DE0	/*                                         <CJK> */,/* 7788 */
/* U+BD6D */	0x7DF4	/*                                         <CJK> */,/* 7789 */
/* U+BD6E */	0x7DEF	/*                                         <CJK> */,/* 7790 */
/* U+BD6F */	0x7DFB	/*                                         <CJK> */,/* 7791 */
/* U+BD70 */	0x7DD8	/*                                         <CJK> */,/* 7792 */
/* U+BD71 */	0x7DEC	/*                                         <CJK> */,/* 7793 */
/* U+BD72 */	0x7DDD	/*                                         <CJK> */,/* 7794 */
/* U+BD73 */	0x7DE8	/*                                         <CJK> */,/* 7795 */
/* U+BD74 */	0x7DE3	/*                                         <CJK> */,/* 7796 */
/* U+BD75 */	0x7DDA	/*                                         <CJK> */,/* 7797 */
/* U+BD76 */	0x7DDE	/*                                         <CJK> */,/* 7798 */
/* U+BD77 */	0x7DE9	/*                                         <CJK> */,/* 7799 */
/* U+BD78 */	0x7D9E	/*                                         <CJK> */,/* 7800 */
/* U+BD79 */	0x7DD9	/*                                         <CJK> */,/* 7801 */
/* U+BD7A */	0x7DF2	/*                                         <CJK> */,/* 7802 */
/* U+BD7B */	0x7DF9	/*                                         <CJK> */,/* 7803 */
/* U+BD7C */	0x7F75	/*                                         <CJK> */,/* 7804 */
/* U+BD7D */	0x7F77	/*                                         <CJK> */,/* 7805 */
/* U+BD7E */	0x7FAF	/*                                         <CJK> */,/* 7806 */
/* U+BD7F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7807 */
/* U+BD80 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7808 */
/* U+BD81 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7809 */
/* U+BD82 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7810 */
/* U+BD83 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7811 */
/* U+BD84 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7812 */
/* U+BD85 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7813 */
/* U+BD86 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7814 */
/* U+BD87 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7815 */
/* U+BD88 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7816 */
/* U+BD89 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7817 */
/* U+BD8A */	UNICODE_REPLACEMENT_CHARACTER,	/* 7818 */
/* U+BD8B */	UNICODE_REPLACEMENT_CHARACTER,	/* 7819 */
/* U+BD8C */	UNICODE_REPLACEMENT_CHARACTER,	/* 7820 */
/* U+BD8D */	UNICODE_REPLACEMENT_CHARACTER,	/* 7821 */
/* U+BD8E */	UNICODE_REPLACEMENT_CHARACTER,	/* 7822 */
/* U+BD8F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7823 */
/* U+BD90 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7824 */
/* U+BD91 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7825 */
/* U+BD92 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7826 */
/* U+BD93 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7827 */
/* U+BD94 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7828 */
/* U+BD95 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7829 */
/* U+BD96 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7830 */
/* U+BD97 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7831 */
/* U+BD98 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7832 */
/* U+BD99 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7833 */
/* U+BD9A */	UNICODE_REPLACEMENT_CHARACTER,	/* 7834 */
/* U+BD9B */	UNICODE_REPLACEMENT_CHARACTER,	/* 7835 */
/* U+BD9C */	UNICODE_REPLACEMENT_CHARACTER,	/* 7836 */
/* U+BD9D */	UNICODE_REPLACEMENT_CHARACTER,	/* 7837 */
/* U+BD9E */	UNICODE_REPLACEMENT_CHARACTER,	/* 7838 */
/* U+BD9F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7839 */
/* U+BDA0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7840 */
/* U+BDA1 */	0x7FE9	/*                                         <CJK> */,/* 7841 */
/* U+BDA2 */	0x8026	/*                                         <CJK> */,/* 7842 */
/* U+BDA3 */	0x819B	/*                                         <CJK> */,/* 7843 */
/* U+BDA4 */	0x819C	/*                                         <CJK> */,/* 7844 */
/* U+BDA5 */	0x819D	/*                                         <CJK> */,/* 7845 */
/* U+BDA6 */	0x81A0	/*                                         <CJK> */,/* 7846 */
/* U+BDA7 */	0x819A	/*                                         <CJK> */,/* 7847 */
/* U+BDA8 */	0x8198	/*                                         <CJK> */,/* 7848 */
/* U+BDA9 */	0x8517	/*                                         <CJK> */,/* 7849 */
/* U+BDAA */	0x853D	/*                                         <CJK> */,/* 7850 */
/* U+BDAB */	0x851A	/*                                         <CJK> */,/* 7851 */
/* U+BDAC */	0x84EE	/*                                         <CJK> */,/* 7852 */
/* U+BDAD */	0x852C	/*                                         <CJK> */,/* 7853 */
/* U+BDAE */	0x852D	/*                                         <CJK> */,/* 7854 */
/* U+BDAF */	0x8513	/*                                         <CJK> */,/* 7855 */
/* U+BDB0 */	0x8511	/*                                         <CJK> */,/* 7856 */
/* U+BDB1 */	0x8523	/*                                         <CJK> */,/* 7857 */
/* U+BDB2 */	0x8521	/*                                         <CJK> */,/* 7858 */
/* U+BDB3 */	0x8514	/*                                         <CJK> */,/* 7859 */
/* U+BDB4 */	0x84EC	/*                                         <CJK> */,/* 7860 */
/* U+BDB5 */	0x8525	/*                                         <CJK> */,/* 7861 */
/* U+BDB6 */	0x84FF	/*                                         <CJK> */,/* 7862 */
/* U+BDB7 */	0x8506	/*                                         <CJK> */,/* 7863 */
/* U+BDB8 */	0x8782	/*                                         <CJK> */,/* 7864 */
/* U+BDB9 */	0x8774	/*                                         <CJK> */,/* 7865 */
/* U+BDBA */	0x8776	/*                                         <CJK> */,/* 7866 */
/* U+BDBB */	0x8760	/*                                         <CJK> */,/* 7867 */
/* U+BDBC */	0x8766	/*                                         <CJK> */,/* 7868 */
/* U+BDBD */	0x8778	/*                                         <CJK> */,/* 7869 */
/* U+BDBE */	0x8768	/*                                         <CJK> */,/* 7870 */
/* U+BDBF */	0x8759	/*                                         <CJK> */,/* 7871 */
/* U+BDC0 */	0x8757	/*                                         <CJK> */,/* 7872 */
/* U+BDC1 */	0x874C	/*                                         <CJK> */,/* 7873 */
/* U+BDC2 */	0x8753	/*                                         <CJK> */,/* 7874 */
/* U+BDC3 */	0x885B	/*                                         <CJK> */,/* 7875 */
/* U+BDC4 */	0x885D	/*                                         <CJK> */,/* 7876 */
/* U+BDC5 */	0x8910	/*                                         <CJK> */,/* 7877 */
/* U+BDC6 */	0x8907	/*                                         <CJK> */,/* 7878 */
/* U+BDC7 */	0x8912	/*                                         <CJK> */,/* 7879 */
/* U+BDC8 */	0x8913	/*                                         <CJK> */,/* 7880 */
/* U+BDC9 */	0x8915	/*                                         <CJK> */,/* 7881 */
/* U+BDCA */	0x890A	/*                                         <CJK> */,/* 7882 */
/* U+BDCB */	0x8ABC	/*                                         <CJK> */,/* 7883 */
/* U+BDCC */	0x8AD2	/*                                         <CJK> */,/* 7884 */
/* U+BDCD */	0x8AC7	/*                                         <CJK> */,/* 7885 */
/* U+BDCE */	0x8AC4	/*                                         <CJK> */,/* 7886 */
/* U+BDCF */	0x8A95	/*                                         <CJK> */,/* 7887 */
/* U+BDD0 */	0x8ACB	/*                                         <CJK> */,/* 7888 */
/* U+BDD1 */	0x8AF8	/*                                         <CJK> */,/* 7889 */
/* U+BDD2 */	0x8AB2	/*                                         <CJK> */,/* 7890 */
/* U+BDD3 */	0x8AC9	/*                                         <CJK> */,/* 7891 */
/* U+BDD4 */	0x8AC2	/*                                         <CJK> */,/* 7892 */
/* U+BDD5 */	0x8ABF	/*                                         <CJK> */,/* 7893 */
/* U+BDD6 */	0x8AB0	/*                                         <CJK> */,/* 7894 */
/* U+BDD7 */	0x8AD6	/*                                         <CJK> */,/* 7895 */
/* U+BDD8 */	0x8ACD	/*                                         <CJK> */,/* 7896 */
/* U+BDD9 */	0x8AB6	/*                                         <CJK> */,/* 7897 */
/* U+BDDA */	0x8AB9	/*                                         <CJK> */,/* 7898 */
/* U+BDDB */	0x8ADB	/*                                         <CJK> */,/* 7899 */
/* U+BDDC */	0x8C4C	/*                                         <CJK> */,/* 7900 */
/* U+BDDD */	0x8C4E	/*                                         <CJK> */,/* 7901 */
/* U+BDDE */	0x8C6C	/*                                         <CJK> */,/* 7902 */
/* U+BDDF */	0x8CE0	/*                                         <CJK> */,/* 7903 */
/* U+BDE0 */	0x8CDE	/*                                         <CJK> */,/* 7904 */
/* U+BDE1 */	0x8CE6	/*                                         <CJK> */,/* 7905 */
/* U+BDE2 */	0x8CE4	/*                                         <CJK> */,/* 7906 */
/* U+BDE3 */	0x8CEC	/*                                         <CJK> */,/* 7907 */
/* U+BDE4 */	0x8CED	/*                                         <CJK> */,/* 7908 */
/* U+BDE5 */	0x8CE2	/*                                         <CJK> */,/* 7909 */
/* U+BDE6 */	0x8CE3	/*                                         <CJK> */,/* 7910 */
/* U+BDE7 */	0x8CDC	/*                                         <CJK> */,/* 7911 */
/* U+BDE8 */	0x8CEA	/*                                         <CJK> */,/* 7912 */
/* U+BDE9 */	0x8CE1	/*                                         <CJK> */,/* 7913 */
/* U+BDEA */	0x8D6D	/*                                         <CJK> */,/* 7914 */
/* U+BDEB */	0x8D9F	/*                                         <CJK> */,/* 7915 */
/* U+BDEC */	0x8DA3	/*                                         <CJK> */,/* 7916 */
/* U+BDED */	0x8E2B	/*                                         <CJK> */,/* 7917 */
/* U+BDEE */	0x8E10	/*                                         <CJK> */,/* 7918 */
/* U+BDEF */	0x8E1D	/*                                         <CJK> */,/* 7919 */
/* U+BDF0 */	0x8E22	/*                                         <CJK> */,/* 7920 */
/* U+BDF1 */	0x8E0F	/*                                         <CJK> */,/* 7921 */
/* U+BDF2 */	0x8E29	/*                                         <CJK> */,/* 7922 */
/* U+BDF3 */	0x8E1F	/*                                         <CJK> */,/* 7923 */
/* U+BDF4 */	0x8E21	/*                                         <CJK> */,/* 7924 */
/* U+BDF5 */	0x8E1E	/*                                         <CJK> */,/* 7925 */
/* U+BDF6 */	0x8EBA	/*                                         <CJK> */,/* 7926 */
/* U+BDF7 */	0x8F1D	/*                                         <CJK> */,/* 7927 */
/* U+BDF8 */	0x8F1B	/*                                         <CJK> */,/* 7928 */
/* U+BDF9 */	0x8F1F	/*                                         <CJK> */,/* 7929 */
/* U+BDFA */	0x8F29	/*                                         <CJK> */,/* 7930 */
/* U+BDFB */	0x8F26	/*                                         <CJK> */,/* 7931 */
/* U+BDFC */	0x8F2A	/*                                         <CJK> */,/* 7932 */
/* U+BDFD */	0x8F1C	/*                                         <CJK> */,/* 7933 */
/* U+BDFE */	0x8F1E	/*                                         <CJK> */,/* 7934 */
/* U+BDFF */	UNICODE_REPLACEMENT_CHARACTER,	/* 7935 */
/* U+BE00 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7936 */
/* U+BE01 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7937 */
/* U+BE02 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7938 */
/* U+BE03 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7939 */
/* U+BE04 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7940 */
/* U+BE05 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7941 */
/* U+BE06 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7942 */
/* U+BE07 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7943 */
/* U+BE08 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7944 */
/* U+BE09 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7945 */
/* U+BE0A */	UNICODE_REPLACEMENT_CHARACTER,	/* 7946 */
/* U+BE0B */	UNICODE_REPLACEMENT_CHARACTER,	/* 7947 */
/* U+BE0C */	UNICODE_REPLACEMENT_CHARACTER,	/* 7948 */
/* U+BE0D */	UNICODE_REPLACEMENT_CHARACTER,	/* 7949 */
/* U+BE0E */	UNICODE_REPLACEMENT_CHARACTER,	/* 7950 */
/* U+BE0F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7951 */
/* U+BE10 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7952 */
/* U+BE11 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7953 */
/* U+BE12 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7954 */
/* U+BE13 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7955 */
/* U+BE14 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7956 */
/* U+BE15 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7957 */
/* U+BE16 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7958 */
/* U+BE17 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7959 */
/* U+BE18 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7960 */
/* U+BE19 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7961 */
/* U+BE1A */	UNICODE_REPLACEMENT_CHARACTER,	/* 7962 */
/* U+BE1B */	UNICODE_REPLACEMENT_CHARACTER,	/* 7963 */
/* U+BE1C */	UNICODE_REPLACEMENT_CHARACTER,	/* 7964 */
/* U+BE1D */	UNICODE_REPLACEMENT_CHARACTER,	/* 7965 */
/* U+BE1E */	UNICODE_REPLACEMENT_CHARACTER,	/* 7966 */
/* U+BE1F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7967 */
/* U+BE20 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7968 */
/* U+BE21 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7969 */
/* U+BE22 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7970 */
/* U+BE23 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7971 */
/* U+BE24 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7972 */
/* U+BE25 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7973 */
/* U+BE26 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7974 */
/* U+BE27 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7975 */
/* U+BE28 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7976 */
/* U+BE29 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7977 */
/* U+BE2A */	UNICODE_REPLACEMENT_CHARACTER,	/* 7978 */
/* U+BE2B */	UNICODE_REPLACEMENT_CHARACTER,	/* 7979 */
/* U+BE2C */	UNICODE_REPLACEMENT_CHARACTER,	/* 7980 */
/* U+BE2D */	UNICODE_REPLACEMENT_CHARACTER,	/* 7981 */
/* U+BE2E */	UNICODE_REPLACEMENT_CHARACTER,	/* 7982 */
/* U+BE2F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7983 */
/* U+BE30 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7984 */
/* U+BE31 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7985 */
/* U+BE32 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7986 */
/* U+BE33 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7987 */
/* U+BE34 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7988 */
/* U+BE35 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7989 */
/* U+BE36 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7990 */
/* U+BE37 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7991 */
/* U+BE38 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7992 */
/* U+BE39 */	UNICODE_REPLACEMENT_CHARACTER,	/* 7993 */
/* U+BE3A */	UNICODE_REPLACEMENT_CHARACTER,	/* 7994 */
/* U+BE3B */	UNICODE_REPLACEMENT_CHARACTER,	/* 7995 */
/* U+BE3C */	UNICODE_REPLACEMENT_CHARACTER,	/* 7996 */
/* U+BE3D */	UNICODE_REPLACEMENT_CHARACTER,	/* 7997 */
/* U+BE3E */	UNICODE_REPLACEMENT_CHARACTER,	/* 7998 */
/* U+BE3F */	UNICODE_REPLACEMENT_CHARACTER,	/* 7999 */
/* U+BE40 */	0x8F25	/*                                         <CJK> */,/* 8000 */
/* U+BE41 */	0x9069	/*                                         <CJK> */,/* 8001 */
/* U+BE42 */	0x906E	/*                                         <CJK> */,/* 8002 */
/* U+BE43 */	0x9068	/*                                         <CJK> */,/* 8003 */
/* U+BE44 */	0x906D	/*                                         <CJK> */,/* 8004 */
/* U+BE45 */	0x9077	/*                                         <CJK> */,/* 8005 */
/* U+BE46 */	0x9130	/*                                         <CJK> */,/* 8006 */
/* U+BE47 */	0x912D	/*                                         <CJK> */,/* 8007 */
/* U+BE48 */	0x9127	/*                                         <CJK> */,/* 8008 */
/* U+BE49 */	0x9131	/*                                         <CJK> */,/* 8009 */
/* U+BE4A */	0x9187	/*                                         <CJK> */,/* 8010 */
/* U+BE4B */	0x9189	/*                                         <CJK> */,/* 8011 */
/* U+BE4C */	0x918B	/*                                         <CJK> */,/* 8012 */
/* U+BE4D */	0x9183	/*                                         <CJK> */,/* 8013 */
/* U+BE4E */	0x92C5	/*                                         <CJK> */,/* 8014 */
/* U+BE4F */	0x92BB	/*                                         <CJK> */,/* 8015 */
/* U+BE50 */	0x92B7	/*                                         <CJK> */,/* 8016 */
/* U+BE51 */	0x92EA	/*                                         <CJK> */,/* 8017 */
/* U+BE52 */	0x92AC	/*                                         <CJK> */,/* 8018 */
/* U+BE53 */	0x92E4	/*                                         <CJK> */,/* 8019 */
/* U+BE54 */	0x92C1	/*                                         <CJK> */,/* 8020 */
/* U+BE55 */	0x92B3	/*                                         <CJK> */,/* 8021 */
/* U+BE56 */	0x92BC	/*                                         <CJK> */,/* 8022 */
/* U+BE57 */	0x92D2	/*                                         <CJK> */,/* 8023 */
/* U+BE58 */	0x92C7	/*                                         <CJK> */,/* 8024 */
/* U+BE59 */	0x92F0	/*                                         <CJK> */,/* 8025 */
/* U+BE5A */	0x92B2	/*                                         <CJK> */,/* 8026 */
/* U+BE5B */	0x95AD	/*                                         <CJK> */,/* 8027 */
/* U+BE5C */	0x95B1	/*                                         <CJK> */,/* 8028 */
/* U+BE5D */	0x9704	/*                                         <CJK> */,/* 8029 */
/* U+BE5E */	0x9706	/*                                         <CJK> */,/* 8030 */
/* U+BE5F */	0x9707	/*                                         <CJK> */,/* 8031 */
/* U+BE60 */	0x9709	/*                                         <CJK> */,/* 8032 */
/* U+BE61 */	0x9760	/*                                         <CJK> */,/* 8033 */
/* U+BE62 */	0x978D	/*                                         <CJK> */,/* 8034 */
/* U+BE63 */	0x978B	/*                                         <CJK> */,/* 8035 */
/* U+BE64 */	0x978F	/*                                         <CJK> */,/* 8036 */
/* U+BE65 */	0x9821	/*                                         <CJK> */,/* 8037 */
/* U+BE66 */	0x982B	/*                                         <CJK> */,/* 8038 */
/* U+BE67 */	0x981C	/*                                         <CJK> */,/* 8039 */
/* U+BE68 */	0x98B3	/*                                         <CJK> */,/* 8040 */
/* U+BE69 */	0x990A	/*                                         <CJK> */,/* 8041 */
/* U+BE6A */	0x9913	/*                                         <CJK> */,/* 8042 */
/* U+BE6B */	0x9912	/*                                         <CJK> */,/* 8043 */
/* U+BE6C */	0x9918	/*                                         <CJK> */,/* 8044 */
/* U+BE6D */	0x99DD	/*                                         <CJK> */,/* 8045 */
/* U+BE6E */	0x99D0	/*                                         <CJK> */,/* 8046 */
/* U+BE6F */	0x99DF	/*                                         <CJK> */,/* 8047 */
/* U+BE70 */	0x99DB	/*                                         <CJK> */,/* 8048 */
/* U+BE71 */	0x99D1	/*                                         <CJK> */,/* 8049 */
/* U+BE72 */	0x99D5	/*                                         <CJK> */,/* 8050 */
/* U+BE73 */	0x99D2	/*                                         <CJK> */,/* 8051 */
/* U+BE74 */	0x99D9	/*                                         <CJK> */,/* 8052 */
/* U+BE75 */	0x9AB7	/*                                         <CJK> */,/* 8053 */
/* U+BE76 */	0x9AEE	/*                                         <CJK> */,/* 8054 */
/* U+BE77 */	0x9AEF	/*                                         <CJK> */,/* 8055 */
/* U+BE78 */	0x9B27	/*                                         <CJK> */,/* 8056 */
/* U+BE79 */	0x9B45	/*                                         <CJK> */,/* 8057 */
/* U+BE7A */	0x9B44	/*                                         <CJK> */,/* 8058 */
/* U+BE7B */	0x9B77	/*                                         <CJK> */,/* 8059 */
/* U+BE7C */	0x9B6F	/*                                         <CJK> */,/* 8060 */
/* U+BE7D */	0x9D06	/*                                         <CJK> */,/* 8061 */
/* U+BE7E */	0x9D09	/*                                         <CJK> */,/* 8062 */
/* U+BE7F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8063 */
/* U+BE80 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8064 */
/* U+BE81 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8065 */
/* U+BE82 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8066 */
/* U+BE83 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8067 */
/* U+BE84 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8068 */
/* U+BE85 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8069 */
/* U+BE86 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8070 */
/* U+BE87 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8071 */
/* U+BE88 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8072 */
/* U+BE89 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8073 */
/* U+BE8A */	UNICODE_REPLACEMENT_CHARACTER,	/* 8074 */
/* U+BE8B */	UNICODE_REPLACEMENT_CHARACTER,	/* 8075 */
/* U+BE8C */	UNICODE_REPLACEMENT_CHARACTER,	/* 8076 */
/* U+BE8D */	UNICODE_REPLACEMENT_CHARACTER,	/* 8077 */
/* U+BE8E */	UNICODE_REPLACEMENT_CHARACTER,	/* 8078 */
/* U+BE8F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8079 */
/* U+BE90 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8080 */
/* U+BE91 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8081 */
/* U+BE92 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8082 */
/* U+BE93 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8083 */
/* U+BE94 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8084 */
/* U+BE95 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8085 */
/* U+BE96 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8086 */
/* U+BE97 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8087 */
/* U+BE98 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8088 */
/* U+BE99 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8089 */
/* U+BE9A */	UNICODE_REPLACEMENT_CHARACTER,	/* 8090 */
/* U+BE9B */	UNICODE_REPLACEMENT_CHARACTER,	/* 8091 */
/* U+BE9C */	UNICODE_REPLACEMENT_CHARACTER,	/* 8092 */
/* U+BE9D */	UNICODE_REPLACEMENT_CHARACTER,	/* 8093 */
/* U+BE9E */	UNICODE_REPLACEMENT_CHARACTER,	/* 8094 */
/* U+BE9F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8095 */
/* U+BEA0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8096 */
/* U+BEA1 */	0x9D03	/*                                         <CJK> */,/* 8097 */
/* U+BEA2 */	0x9EA9	/*                                         <CJK> */,/* 8098 */
/* U+BEA3 */	0x9EBE	/*                                         <CJK> */,/* 8099 */
/* U+BEA4 */	0x9ECE	/*                                         <CJK> */,/* 8100 */
/* U+BEA5 */	0x58A8	/*                                         <CJK> */,/* 8101 */
/* U+BEA6 */	0x9F52	/*                                         <CJK> */,/* 8102 */
/* U+BEA7 */	0x5112	/*                                         <CJK> */,/* 8103 */
/* U+BEA8 */	0x5118	/*                                         <CJK> */,/* 8104 */
/* U+BEA9 */	0x5114	/*                                         <CJK> */,/* 8105 */
/* U+BEAA */	0x5110	/*                                         <CJK> */,/* 8106 */
/* U+BEAB */	0x5115	/*                                         <CJK> */,/* 8107 */
/* U+BEAC */	0x5180	/*                                         <CJK> */,/* 8108 */
/* U+BEAD */	0x51AA	/*                                         <CJK> */,/* 8109 */
/* U+BEAE */	0x51DD	/*                                         <CJK> */,/* 8110 */
/* U+BEAF */	0x5291	/*                                         <CJK> */,/* 8111 */
/* U+BEB0 */	0x5293	/*                                         <CJK> */,/* 8112 */
/* U+BEB1 */	0x52F3	/*                                         <CJK> */,/* 8113 */
/* U+BEB2 */	0x5659	/*                                         <CJK> */,/* 8114 */
/* U+BEB3 */	0x566B	/*                                         <CJK> */,/* 8115 */
/* U+BEB4 */	0x5679	/*                                         <CJK> */,/* 8116 */
/* U+BEB5 */	0x5669	/*                                         <CJK> */,/* 8117 */
/* U+BEB6 */	0x5664	/*                                         <CJK> */,/* 8118 */
/* U+BEB7 */	0x5678	/*                                         <CJK> */,/* 8119 */
/* U+BEB8 */	0x566A	/*                                         <CJK> */,/* 8120 */
/* U+BEB9 */	0x5668	/*                                         <CJK> */,/* 8121 */
/* U+BEBA */	0x5665	/*                                         <CJK> */,/* 8122 */
/* U+BEBB */	0x5671	/*                                         <CJK> */,/* 8123 */
/* U+BEBC */	0x566F	/*                                         <CJK> */,/* 8124 */
/* U+BEBD */	0x566C	/*                                         <CJK> */,/* 8125 */
/* U+BEBE */	0x5662	/*                                         <CJK> */,/* 8126 */
/* U+BEBF */	0x5676	/*                                         <CJK> */,/* 8127 */
/* U+BEC0 */	0x58C1	/*                                         <CJK> */,/* 8128 */
/* U+BEC1 */	0x58BE	/*                                         <CJK> */,/* 8129 */
/* U+BEC2 */	0x58C7	/*                                         <CJK> */,/* 8130 */
/* U+BEC3 */	0x58C5	/*                                         <CJK> */,/* 8131 */
/* U+BEC4 */	0x596E	/*                                         <CJK> */,/* 8132 */
/* U+BEC5 */	0x5B1D	/*                                         <CJK> */,/* 8133 */
/* U+BEC6 */	0x5B34	/*                                         <CJK> */,/* 8134 */
/* U+BEC7 */	0x5B78	/*                                         <CJK> */,/* 8135 */
/* U+BEC8 */	0x5BF0	/*                                         <CJK> */,/* 8136 */
/* U+BEC9 */	0x5C0E	/*                                         <CJK> */,/* 8137 */
/* U+BECA */	0x5F4A	/*                                         <CJK> */,/* 8138 */
/* U+BECB */	0x61B2	/*                                         <CJK> */,/* 8139 */
/* U+BECC */	0x6191	/*                                         <CJK> */,/* 8140 */
/* U+BECD */	0x61A9	/*                                         <CJK> */,/* 8141 */
/* U+BECE */	0x618A	/*                                         <CJK> */,/* 8142 */
/* U+BECF */	0x61CD	/*                                         <CJK> */,/* 8143 */
/* U+BED0 */	0x61B6	/*                                         <CJK> */,/* 8144 */
/* U+BED1 */	0x61BE	/*                                         <CJK> */,/* 8145 */
/* U+BED2 */	0x61CA	/*                                         <CJK> */,/* 8146 */
/* U+BED3 */	0x61C8	/*                                         <CJK> */,/* 8147 */
/* U+BED4 */	0x6230	/*                                         <CJK> */,/* 8148 */
/* U+BED5 */	0x64C5	/*                                         <CJK> */,/* 8149 */
/* U+BED6 */	0x64C1	/*                                         <CJK> */,/* 8150 */
/* U+BED7 */	0x64CB	/*                                         <CJK> */,/* 8151 */
/* U+BED8 */	0x64BB	/*                                         <CJK> */,/* 8152 */
/* U+BED9 */	0x64BC	/*                                         <CJK> */,/* 8153 */
/* U+BEDA */	0x64DA	/*                                         <CJK> */,/* 8154 */
/* U+BEDB */	0x64C4	/*                                         <CJK> */,/* 8155 */
/* U+BEDC */	0x64C7	/*                                         <CJK> */,/* 8156 */
/* U+BEDD */	0x64C2	/*                                         <CJK> */,/* 8157 */
/* U+BEDE */	0x64CD	/*                                         <CJK> */,/* 8158 */
/* U+BEDF */	0x64BF	/*                                         <CJK> */,/* 8159 */
/* U+BEE0 */	0x64D2	/*                                         <CJK> */,/* 8160 */
/* U+BEE1 */	0x64D4	/*                                         <CJK> */,/* 8161 */
/* U+BEE2 */	0x64BE	/*                                         <CJK> */,/* 8162 */
/* U+BEE3 */	0x6574	/*                                         <CJK> */,/* 8163 */
/* U+BEE4 */	0x66C6	/*                                         <CJK> */,/* 8164 */
/* U+BEE5 */	0x66C9	/*                                         <CJK> */,/* 8165 */
/* U+BEE6 */	0x66B9	/*                                         <CJK> */,/* 8166 */
/* U+BEE7 */	0x66C4	/*                                         <CJK> */,/* 8167 */
/* U+BEE8 */	0x66C7	/*                                         <CJK> */,/* 8168 */
/* U+BEE9 */	0x66B8	/*                                         <CJK> */,/* 8169 */
/* U+BEEA */	0x6A3D	/*                                         <CJK> */,/* 8170 */
/* U+BEEB */	0x6A38	/*                                         <CJK> */,/* 8171 */
/* U+BEEC */	0x6A3A	/*                                         <CJK> */,/* 8172 */
/* U+BEED */	0x6A59	/*                                         <CJK> */,/* 8173 */
/* U+BEEE */	0x6A6B	/*                                         <CJK> */,/* 8174 */
/* U+BEEF */	0x6A58	/*                                         <CJK> */,/* 8175 */
/* U+BEF0 */	0x6A39	/*                                         <CJK> */,/* 8176 */
/* U+BEF1 */	0x6A44	/*                                         <CJK> */,/* 8177 */
/* U+BEF2 */	0x6A62	/*                                         <CJK> */,/* 8178 */
/* U+BEF3 */	0x6A61	/*                                         <CJK> */,/* 8179 */
/* U+BEF4 */	0x6A4B	/*                                         <CJK> */,/* 8180 */
/* U+BEF5 */	0x6A47	/*                                         <CJK> */,/* 8181 */
/* U+BEF6 */	0x6A35	/*                                         <CJK> */,/* 8182 */
/* U+BEF7 */	0x6A5F	/*                                         <CJK> */,/* 8183 */
/* U+BEF8 */	0x6A48	/*                                         <CJK> */,/* 8184 */
/* U+BEF9 */	0x6B59	/*                                         <CJK> */,/* 8185 */
/* U+BEFA */	0x6B77	/*                                         <CJK> */,/* 8186 */
/* U+BEFB */	0x6C05	/*                                         <CJK> */,/* 8187 */
/* U+BEFC */	0x6FC2	/*                                         <CJK> */,/* 8188 */
/* U+BEFD */	0x6FB1	/*                                         <CJK> */,/* 8189 */
/* U+BEFE */	0x6FA1	/*                                         <CJK> */,/* 8190 */
/* U+BEFF */	UNICODE_REPLACEMENT_CHARACTER,	/* 8191 */
/* U+BF00 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8192 */
/* U+BF01 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8193 */
/* U+BF02 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8194 */
/* U+BF03 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8195 */
/* U+BF04 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8196 */
/* U+BF05 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8197 */
/* U+BF06 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8198 */
/* U+BF07 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8199 */
/* U+BF08 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8200 */
/* U+BF09 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8201 */
/* U+BF0A */	UNICODE_REPLACEMENT_CHARACTER,	/* 8202 */
/* U+BF0B */	UNICODE_REPLACEMENT_CHARACTER,	/* 8203 */
/* U+BF0C */	UNICODE_REPLACEMENT_CHARACTER,	/* 8204 */
/* U+BF0D */	UNICODE_REPLACEMENT_CHARACTER,	/* 8205 */
/* U+BF0E */	UNICODE_REPLACEMENT_CHARACTER,	/* 8206 */
/* U+BF0F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8207 */
/* U+BF10 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8208 */
/* U+BF11 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8209 */
/* U+BF12 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8210 */
/* U+BF13 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8211 */
/* U+BF14 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8212 */
/* U+BF15 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8213 */
/* U+BF16 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8214 */
/* U+BF17 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8215 */
/* U+BF18 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8216 */
/* U+BF19 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8217 */
/* U+BF1A */	UNICODE_REPLACEMENT_CHARACTER,	/* 8218 */
/* U+BF1B */	UNICODE_REPLACEMENT_CHARACTER,	/* 8219 */
/* U+BF1C */	UNICODE_REPLACEMENT_CHARACTER,	/* 8220 */
/* U+BF1D */	UNICODE_REPLACEMENT_CHARACTER,	/* 8221 */
/* U+BF1E */	UNICODE_REPLACEMENT_CHARACTER,	/* 8222 */
/* U+BF1F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8223 */
/* U+BF20 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8224 */
/* U+BF21 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8225 */
/* U+BF22 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8226 */
/* U+BF23 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8227 */
/* U+BF24 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8228 */
/* U+BF25 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8229 */
/* U+BF26 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8230 */
/* U+BF27 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8231 */
/* U+BF28 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8232 */
/* U+BF29 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8233 */
/* U+BF2A */	UNICODE_REPLACEMENT_CHARACTER,	/* 8234 */
/* U+BF2B */	UNICODE_REPLACEMENT_CHARACTER,	/* 8235 */
/* U+BF2C */	UNICODE_REPLACEMENT_CHARACTER,	/* 8236 */
/* U+BF2D */	UNICODE_REPLACEMENT_CHARACTER,	/* 8237 */
/* U+BF2E */	UNICODE_REPLACEMENT_CHARACTER,	/* 8238 */
/* U+BF2F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8239 */
/* U+BF30 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8240 */
/* U+BF31 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8241 */
/* U+BF32 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8242 */
/* U+BF33 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8243 */
/* U+BF34 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8244 */
/* U+BF35 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8245 */
/* U+BF36 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8246 */
/* U+BF37 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8247 */
/* U+BF38 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8248 */
/* U+BF39 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8249 */
/* U+BF3A */	UNICODE_REPLACEMENT_CHARACTER,	/* 8250 */
/* U+BF3B */	UNICODE_REPLACEMENT_CHARACTER,	/* 8251 */
/* U+BF3C */	UNICODE_REPLACEMENT_CHARACTER,	/* 8252 */
/* U+BF3D */	UNICODE_REPLACEMENT_CHARACTER,	/* 8253 */
/* U+BF3E */	UNICODE_REPLACEMENT_CHARACTER,	/* 8254 */
/* U+BF3F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8255 */
/* U+BF40 */	0x6FC3	/*                                         <CJK> */,/* 8256 */
/* U+BF41 */	0x6FA4	/*                                         <CJK> */,/* 8257 */
/* U+BF42 */	0x6FC1	/*                                         <CJK> */,/* 8258 */
/* U+BF43 */	0x6FA7	/*                                         <CJK> */,/* 8259 */
/* U+BF44 */	0x6FB3	/*                                         <CJK> */,/* 8260 */
/* U+BF45 */	0x6FC0	/*                                         <CJK> */,/* 8261 */
/* U+BF46 */	0x6FB9	/*                                         <CJK> */,/* 8262 */
/* U+BF47 */	0x6FB6	/*                                         <CJK> */,/* 8263 */
/* U+BF48 */	0x6FA6	/*                                         <CJK> */,/* 8264 */
/* U+BF49 */	0x6FA0	/*                                         <CJK> */,/* 8265 */
/* U+BF4A */	0x6FB4	/*                                         <CJK> */,/* 8266 */
/* U+BF4B */	0x71BE	/*                                         <CJK> */,/* 8267 */
/* U+BF4C */	0x71C9	/*                                         <CJK> */,/* 8268 */
/* U+BF4D */	0x71D0	/*                                         <CJK> */,/* 8269 */
/* U+BF4E */	0x71D2	/*                                         <CJK> */,/* 8270 */
/* U+BF4F */	0x71C8	/*                                         <CJK> */,/* 8271 */
/* U+BF50 */	0x71D5	/*                                         <CJK> */,/* 8272 */
/* U+BF51 */	0x71B9	/*                                         <CJK> */,/* 8273 */
/* U+BF52 */	0x71CE	/*                                         <CJK> */,/* 8274 */
/* U+BF53 */	0x71D9	/*                                         <CJK> */,/* 8275 */
/* U+BF54 */	0x71DC	/*                                         <CJK> */,/* 8276 */
/* U+BF55 */	0x71C3	/*                                         <CJK> */,/* 8277 */
/* U+BF56 */	0x71C4	/*                                         <CJK> */,/* 8278 */
/* U+BF57 */	0x7368	/*                                         <CJK> */,/* 8279 */
/* U+BF58 */	0x749C	/*                                         <CJK> */,/* 8280 */
/* U+BF59 */	0x74A3	/*                                         <CJK> */,/* 8281 */
/* U+BF5A */	0x7498	/*                                         <CJK> */,/* 8282 */
/* U+BF5B */	0x749F	/*                                         <CJK> */,/* 8283 */
/* U+BF5C */	0x749E	/*                                         <CJK> */,/* 8284 */
/* U+BF5D */	0x74E2	/*                                         <CJK> */,/* 8285 */
/* U+BF5E */	0x750C	/*                                         <CJK> */,/* 8286 */
/* U+BF5F */	0x750D	/*                                         <CJK> */,/* 8287 */
/* U+BF60 */	0x7634	/*                                         <CJK> */,/* 8288 */
/* U+BF61 */	0x7638	/*                                         <CJK> */,/* 8289 */
/* U+BF62 */	0x763A	/*                                         <CJK> */,/* 8290 */
/* U+BF63 */	0x76E7	/*                                         <CJK> */,/* 8291 */
/* U+BF64 */	0x76E5	/*                                         <CJK> */,/* 8292 */
/* U+BF65 */	0x77A0	/*                                         <CJK> */,/* 8293 */
/* U+BF66 */	0x779E	/*                                         <CJK> */,/* 8294 */
/* U+BF67 */	0x779F	/*                                         <CJK> */,/* 8295 */
/* U+BF68 */	0x77A5	/*                                         <CJK> */,/* 8296 */
/* U+BF69 */	0x78E8	/*                                         <CJK> */,/* 8297 */
/* U+BF6A */	0x78DA	/*                                         <CJK> */,/* 8298 */
/* U+BF6B */	0x78EC	/*                                         <CJK> */,/* 8299 */
/* U+BF6C */	0x78E7	/*                                         <CJK> */,/* 8300 */
/* U+BF6D */	0x79A6	/*                                         <CJK> */,/* 8301 */
/* U+BF6E */	0x7A4D	/*                                         <CJK> */,/* 8302 */
/* U+BF6F */	0x7A4E	/*                                         <CJK> */,/* 8303 */
/* U+BF70 */	0x7A46	/*                                         <CJK> */,/* 8304 */
/* U+BF71 */	0x7A4C	/*                                         <CJK> */,/* 8305 */
/* U+BF72 */	0x7A4B	/*                                         <CJK> */,/* 8306 */
/* U+BF73 */	0x7ABA	/*                                         <CJK> */,/* 8307 */
/* U+BF74 */	0x7BD9	/*                                         <CJK> */,/* 8308 */
/* U+BF75 */	0x7C11	/*                                         <CJK> */,/* 8309 */
/* U+BF76 */	0x7BC9	/*                                         <CJK> */,/* 8310 */
/* U+BF77 */	0x7BE4	/*                                         <CJK> */,/* 8311 */
/* U+BF78 */	0x7BDB	/*                                         <CJK> */,/* 8312 */
/* U+BF79 */	0x7BE1	/*                                         <CJK> */,/* 8313 */
/* U+BF7A */	0x7BE9	/*                                         <CJK> */,/* 8314 */
/* U+BF7B */	0x7BE6	/*                                         <CJK> */,/* 8315 */
/* U+BF7C */	0x7CD5	/*                                         <CJK> */,/* 8316 */
/* U+BF7D */	0x7CD6	/*                                         <CJK> */,/* 8317 */
/* U+BF7E */	0x7E0A	/*                                         <CJK> */,/* 8318 */
/* U+BF7F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8319 */
/* U+BF80 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8320 */
/* U+BF81 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8321 */
/* U+BF82 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8322 */
/* U+BF83 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8323 */
/* U+BF84 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8324 */
/* U+BF85 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8325 */
/* U+BF86 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8326 */
/* U+BF87 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8327 */
/* U+BF88 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8328 */
/* U+BF89 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8329 */
/* U+BF8A */	UNICODE_REPLACEMENT_CHARACTER,	/* 8330 */
/* U+BF8B */	UNICODE_REPLACEMENT_CHARACTER,	/* 8331 */
/* U+BF8C */	UNICODE_REPLACEMENT_CHARACTER,	/* 8332 */
/* U+BF8D */	UNICODE_REPLACEMENT_CHARACTER,	/* 8333 */
/* U+BF8E */	UNICODE_REPLACEMENT_CHARACTER,	/* 8334 */
/* U+BF8F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8335 */
/* U+BF90 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8336 */
/* U+BF91 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8337 */
/* U+BF92 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8338 */
/* U+BF93 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8339 */
/* U+BF94 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8340 */
/* U+BF95 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8341 */
/* U+BF96 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8342 */
/* U+BF97 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8343 */
/* U+BF98 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8344 */
/* U+BF99 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8345 */
/* U+BF9A */	UNICODE_REPLACEMENT_CHARACTER,	/* 8346 */
/* U+BF9B */	UNICODE_REPLACEMENT_CHARACTER,	/* 8347 */
/* U+BF9C */	UNICODE_REPLACEMENT_CHARACTER,	/* 8348 */
/* U+BF9D */	UNICODE_REPLACEMENT_CHARACTER,	/* 8349 */
/* U+BF9E */	UNICODE_REPLACEMENT_CHARACTER,	/* 8350 */
/* U+BF9F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8351 */
/* U+BFA0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8352 */
/* U+BFA1 */	0x7E11	/*                                         <CJK> */,/* 8353 */
/* U+BFA2 */	0x7E08	/*                                         <CJK> */,/* 8354 */
/* U+BFA3 */	0x7E1B	/*                                         <CJK> */,/* 8355 */
/* U+BFA4 */	0x7E23	/*                                         <CJK> */,/* 8356 */
/* U+BFA5 */	0x7E1E	/*                                         <CJK> */,/* 8357 */
/* U+BFA6 */	0x7E1D	/*                                         <CJK> */,/* 8358 */
/* U+BFA7 */	0x7E09	/*                                         <CJK> */,/* 8359 */
/* U+BFA8 */	0x7E10	/*                                         <CJK> */,/* 8360 */
/* U+BFA9 */	0x7F79	/*                                         <CJK> */,/* 8361 */
/* U+BFAA */	0x7FB2	/*                                         <CJK> */,/* 8362 */
/* U+BFAB */	0x7FF0	/*                                         <CJK> */,/* 8363 */
/* U+BFAC */	0x7FF1	/*                                         <CJK> */,/* 8364 */
/* U+BFAD */	0x7FEE	/*                                         <CJK> */,/* 8365 */
/* U+BFAE */	0x8028	/*                                         <CJK> */,/* 8366 */
/* U+BFAF */	0x81B3	/*                                         <CJK> */,/* 8367 */
/* U+BFB0 */	0x81A9	/*                                         <CJK> */,/* 8368 */
/* U+BFB1 */	0x81A8	/*                                         <CJK> */,/* 8369 */
/* U+BFB2 */	0x81FB	/*                                         <CJK> */,/* 8370 */
/* U+BFB3 */	0x8208	/*                                         <CJK> */,/* 8371 */
/* U+BFB4 */	0x8258	/*                                         <CJK> */,/* 8372 */
/* U+BFB5 */	0x8259	/*                                         <CJK> */,/* 8373 */
/* U+BFB6 */	0x854A	/*                                         <CJK> */,/* 8374 */
/* U+BFB7 */	0x8559	/*                                         <CJK> */,/* 8375 */
/* U+BFB8 */	0x8548	/*                                         <CJK> */,/* 8376 */
/* U+BFB9 */	0x8568	/*                                         <CJK> */,/* 8377 */
/* U+BFBA */	0x8569	/*                                         <CJK> */,/* 8378 */
/* U+BFBB */	0x8543	/*                                         <CJK> */,/* 8379 */
/* U+BFBC */	0x8549	/*                                         <CJK> */,/* 8380 */
/* U+BFBD */	0x856D	/*                                         <CJK> */,/* 8381 */
/* U+BFBE */	0x856A	/*                                         <CJK> */,/* 8382 */
/* U+BFBF */	0x855E	/*                                         <CJK> */,/* 8383 */
/* U+BFC0 */	0x8783	/*                                         <CJK> */,/* 8384 */
/* U+BFC1 */	0x879F	/*                                         <CJK> */,/* 8385 */
/* U+BFC2 */	0x879E	/*                                         <CJK> */,/* 8386 */
/* U+BFC3 */	0x87A2	/*                                         <CJK> */,/* 8387 */
/* U+BFC4 */	0x878D	/*                                         <CJK> */,/* 8388 */
/* U+BFC5 */	0x8861	/*                                         <CJK> */,/* 8389 */
/* U+BFC6 */	0x892A	/*                                         <CJK> */,/* 8390 */
/* U+BFC7 */	0x8932	/*                                         <CJK> */,/* 8391 */
/* U+BFC8 */	0x8925	/*                                         <CJK> */,/* 8392 */
/* U+BFC9 */	0x892B	/*                                         <CJK> */,/* 8393 */
/* U+BFCA */	0x8921	/*                                         <CJK> */,/* 8394 */
/* U+BFCB */	0x89AA	/*                                         <CJK> */,/* 8395 */
/* U+BFCC */	0x89A6	/*                                         <CJK> */,/* 8396 */
/* U+BFCD */	0x8AE6	/*                                         <CJK> */,/* 8397 */
/* U+BFCE */	0x8AFA	/*                                         <CJK> */,/* 8398 */
/* U+BFCF */	0x8AEB	/*                                         <CJK> */,/* 8399 */
/* U+BFD0 */	0x8AF1	/*                                         <CJK> */,/* 8400 */
/* U+BFD1 */	0x8B00	/*                                         <CJK> */,/* 8401 */
/* U+BFD2 */	0x8ADC	/*                                         <CJK> */,/* 8402 */
/* U+BFD3 */	0x8AE7	/*                                         <CJK> */,/* 8403 */
/* U+BFD4 */	0x8AEE	/*                                         <CJK> */,/* 8404 */
/* U+BFD5 */	0x8AFE	/*                                         <CJK> */,/* 8405 */
/* U+BFD6 */	0x8B01	/*                                         <CJK> */,/* 8406 */
/* U+BFD7 */	0x8B02	/*                                         <CJK> */,/* 8407 */
/* U+BFD8 */	0x8AF7	/*                                         <CJK> */,/* 8408 */
/* U+BFD9 */	0x8AED	/*                                         <CJK> */,/* 8409 */
/* U+BFDA */	0x8AF3	/*                                         <CJK> */,/* 8410 */
/* U+BFDB */	0x8AF6	/*                                         <CJK> */,/* 8411 */
/* U+BFDC */	0x8AFC	/*                                         <CJK> */,/* 8412 */
/* U+BFDD */	0x8C6B	/*                                         <CJK> */,/* 8413 */
/* U+BFDE */	0x8C6D	/*                                         <CJK> */,/* 8414 */
/* U+BFDF */	0x8C93	/*                                         <CJK> */,/* 8415 */
/* U+BFE0 */	0x8CF4	/*                                         <CJK> */,/* 8416 */
/* U+BFE1 */	0x8E44	/*                                         <CJK> */,/* 8417 */
/* U+BFE2 */	0x8E31	/*                                         <CJK> */,/* 8418 */
/* U+BFE3 */	0x8E34	/*                                         <CJK> */,/* 8419 */
/* U+BFE4 */	0x8E42	/*                                         <CJK> */,/* 8420 */
/* U+BFE5 */	0x8E39	/*                                         <CJK> */,/* 8421 */
/* U+BFE6 */	0x8E35	/*                                         <CJK> */,/* 8422 */
/* U+BFE7 */	0x8F3B	/*                                         <CJK> */,/* 8423 */
/* U+BFE8 */	0x8F2F	/*                                         <CJK> */,/* 8424 */
/* U+BFE9 */	0x8F38	/*                                         <CJK> */,/* 8425 */
/* U+BFEA */	0x8F33	/*                                         <CJK> */,/* 8426 */
/* U+BFEB */	0x8FA8	/*                                         <CJK> */,/* 8427 */
/* U+BFEC */	0x8FA6	/*                                         <CJK> */,/* 8428 */
/* U+BFED */	0x9075	/*                                         <CJK> */,/* 8429 */
/* U+BFEE */	0x9074	/*                                         <CJK> */,/* 8430 */
/* U+BFEF */	0x9078	/*                                         <CJK> */,/* 8431 */
/* U+BFF0 */	0x9072	/*                                         <CJK> */,/* 8432 */
/* U+BFF1 */	0x907C	/*                                         <CJK> */,/* 8433 */
/* U+BFF2 */	0x907A	/*                                         <CJK> */,/* 8434 */
/* U+BFF3 */	0x9134	/*                                         <CJK> */,/* 8435 */
/* U+BFF4 */	0x9192	/*                                         <CJK> */,/* 8436 */
/* U+BFF5 */	0x9320	/*                                         <CJK> */,/* 8437 */
/* U+BFF6 */	0x9336	/*                                         <CJK> */,/* 8438 */
/* U+BFF7 */	0x92F8	/*                                         <CJK> */,/* 8439 */
/* U+BFF8 */	0x9333	/*                                         <CJK> */,/* 8440 */
/* U+BFF9 */	0x932F	/*                                         <CJK> */,/* 8441 */
/* U+BFFA */	0x9322	/*                                         <CJK> */,/* 8442 */
/* U+BFFB */	0x92FC	/*                                         <CJK> */,/* 8443 */
/* U+BFFC */	0x932B	/*                                         <CJK> */,/* 8444 */
/* U+BFFD */	0x9304	/*                                         <CJK> */,/* 8445 */
/* U+BFFE */	0x931A	/*                                         <CJK> */,/* 8446 */
/* U+BFFF */	UNICODE_REPLACEMENT_CHARACTER,	/* 8447 */
/* U+C000 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8448 */
/* U+C001 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8449 */
/* U+C002 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8450 */
/* U+C003 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8451 */
/* U+C004 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8452 */
/* U+C005 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8453 */
/* U+C006 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8454 */
/* U+C007 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8455 */
/* U+C008 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8456 */
/* U+C009 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8457 */
/* U+C00A */	UNICODE_REPLACEMENT_CHARACTER,	/* 8458 */
/* U+C00B */	UNICODE_REPLACEMENT_CHARACTER,	/* 8459 */
/* U+C00C */	UNICODE_REPLACEMENT_CHARACTER,	/* 8460 */
/* U+C00D */	UNICODE_REPLACEMENT_CHARACTER,	/* 8461 */
/* U+C00E */	UNICODE_REPLACEMENT_CHARACTER,	/* 8462 */
/* U+C00F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8463 */
/* U+C010 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8464 */
/* U+C011 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8465 */
/* U+C012 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8466 */
/* U+C013 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8467 */
/* U+C014 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8468 */
/* U+C015 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8469 */
/* U+C016 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8470 */
/* U+C017 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8471 */
/* U+C018 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8472 */
/* U+C019 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8473 */
/* U+C01A */	UNICODE_REPLACEMENT_CHARACTER,	/* 8474 */
/* U+C01B */	UNICODE_REPLACEMENT_CHARACTER,	/* 8475 */
/* U+C01C */	UNICODE_REPLACEMENT_CHARACTER,	/* 8476 */
/* U+C01D */	UNICODE_REPLACEMENT_CHARACTER,	/* 8477 */
/* U+C01E */	UNICODE_REPLACEMENT_CHARACTER,	/* 8478 */
/* U+C01F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8479 */
/* U+C020 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8480 */
/* U+C021 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8481 */
/* U+C022 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8482 */
/* U+C023 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8483 */
/* U+C024 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8484 */
/* U+C025 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8485 */
/* U+C026 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8486 */
/* U+C027 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8487 */
/* U+C028 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8488 */
/* U+C029 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8489 */
/* U+C02A */	UNICODE_REPLACEMENT_CHARACTER,	/* 8490 */
/* U+C02B */	UNICODE_REPLACEMENT_CHARACTER,	/* 8491 */
/* U+C02C */	UNICODE_REPLACEMENT_CHARACTER,	/* 8492 */
/* U+C02D */	UNICODE_REPLACEMENT_CHARACTER,	/* 8493 */
/* U+C02E */	UNICODE_REPLACEMENT_CHARACTER,	/* 8494 */
/* U+C02F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8495 */
/* U+C030 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8496 */
/* U+C031 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8497 */
/* U+C032 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8498 */
/* U+C033 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8499 */
/* U+C034 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8500 */
/* U+C035 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8501 */
/* U+C036 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8502 */
/* U+C037 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8503 */
/* U+C038 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8504 */
/* U+C039 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8505 */
/* U+C03A */	UNICODE_REPLACEMENT_CHARACTER,	/* 8506 */
/* U+C03B */	UNICODE_REPLACEMENT_CHARACTER,	/* 8507 */
/* U+C03C */	UNICODE_REPLACEMENT_CHARACTER,	/* 8508 */
/* U+C03D */	UNICODE_REPLACEMENT_CHARACTER,	/* 8509 */
/* U+C03E */	UNICODE_REPLACEMENT_CHARACTER,	/* 8510 */
/* U+C03F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8511 */
/* U+C040 */	0x9310	/*                                         <CJK> */,/* 8512 */
/* U+C041 */	0x9326	/*                                         <CJK> */,/* 8513 */
/* U+C042 */	0x9321	/*                                         <CJK> */,/* 8514 */
/* U+C043 */	0x9315	/*                                         <CJK> */,/* 8515 */
/* U+C044 */	0x932E	/*                                         <CJK> */,/* 8516 */
/* U+C045 */	0x9319	/*                                         <CJK> */,/* 8517 */
/* U+C046 */	0x95BB	/*                                         <CJK> */,/* 8518 */
/* U+C047 */	0x96A7	/*                                         <CJK> */,/* 8519 */
/* U+C048 */	0x96A8	/*                                         <CJK> */,/* 8520 */
/* U+C049 */	0x96AA	/*                                         <CJK> */,/* 8521 */
/* U+C04A */	0x96D5	/*                                         <CJK> */,/* 8522 */
/* U+C04B */	0x970E	/*                                         <CJK> */,/* 8523 */
/* U+C04C */	0x9711	/*                                         <CJK> */,/* 8524 */
/* U+C04D */	0x9716	/*                                         <CJK> */,/* 8525 */
/* U+C04E */	0x970D	/*                                         <CJK> */,/* 8526 */
/* U+C04F */	0x9713	/*                                         <CJK> */,/* 8527 */
/* U+C050 */	0x970F	/*                                         <CJK> */,/* 8528 */
/* U+C051 */	0x975B	/*                                         <CJK> */,/* 8529 */
/* U+C052 */	0x975C	/*                                         <CJK> */,/* 8530 */
/* U+C053 */	0x9766	/*                                         <CJK> */,/* 8531 */
/* U+C054 */	0x9798	/*                                         <CJK> */,/* 8532 */
/* U+C055 */	0x9830	/*                                         <CJK> */,/* 8533 */
/* U+C056 */	0x9838	/*                                         <CJK> */,/* 8534 */
/* U+C057 */	0x983B	/*                                         <CJK> */,/* 8535 */
/* U+C058 */	0x9837	/*                                         <CJK> */,/* 8536 */
/* U+C059 */	0x982D	/*                                         <CJK> */,/* 8537 */
/* U+C05A */	0x9839	/*                                         <CJK> */,/* 8538 */
/* U+C05B */	0x9824	/*                                         <CJK> */,/* 8539 */
/* U+C05C */	0x9910	/*                                         <CJK> */,/* 8540 */
/* U+C05D */	0x9928	/*                                         <CJK> */,/* 8541 */
/* U+C05E */	0x991E	/*                                         <CJK> */,/* 8542 */
/* U+C05F */	0x991B	/*                                         <CJK> */,/* 8543 */
/* U+C060 */	0x9921	/*                                         <CJK> */,/* 8544 */
/* U+C061 */	0x991A	/*                                         <CJK> */,/* 8545 */
/* U+C062 */	0x99ED	/*                                         <CJK> */,/* 8546 */
/* U+C063 */	0x99E2	/*                                         <CJK> */,/* 8547 */
/* U+C064 */	0x99F1	/*                                         <CJK> */,/* 8548 */
/* U+C065 */	0x9AB8	/*                                         <CJK> */,/* 8549 */
/* U+C066 */	0x9ABC	/*                                         <CJK> */,/* 8550 */
/* U+C067 */	0x9AFB	/*                                         <CJK> */,/* 8551 */
/* U+C068 */	0x9AED	/*                                         <CJK> */,/* 8552 */
/* U+C069 */	0x9B28	/*                                         <CJK> */,/* 8553 */
/* U+C06A */	0x9B91	/*                                         <CJK> */,/* 8554 */
/* U+C06B */	0x9D15	/*                                         <CJK> */,/* 8555 */
/* U+C06C */	0x9D23	/*                                         <CJK> */,/* 8556 */
/* U+C06D */	0x9D26	/*                                         <CJK> */,/* 8557 */
/* U+C06E */	0x9D28	/*                                         <CJK> */,/* 8558 */
/* U+C06F */	0x9D12	/*                                         <CJK> */,/* 8559 */
/* U+C070 */	0x9D1B	/*                                         <CJK> */,/* 8560 */
/* U+C071 */	0x9ED8	/*                                         <CJK> */,/* 8561 */
/* U+C072 */	0x9ED4	/*                                         <CJK> */,/* 8562 */
/* U+C073 */	0x9F8D	/*                                         <CJK> */,/* 8563 */
/* U+C074 */	0x9F9C	/*                                         <CJK> */,/* 8564 */
/* U+C075 */	0x512A	/*                                         <CJK> */,/* 8565 */
/* U+C076 */	0x511F	/*                                         <CJK> */,/* 8566 */
/* U+C077 */	0x5121	/*                                         <CJK> */,/* 8567 */
/* U+C078 */	0x5132	/*                                         <CJK> */,/* 8568 */
/* U+C079 */	0x52F5	/*                                         <CJK> */,/* 8569 */
/* U+C07A */	0x568E	/*                                         <CJK> */,/* 8570 */
/* U+C07B */	0x5680	/*                                         <CJK> */,/* 8571 */
/* U+C07C */	0x5690	/*                                         <CJK> */,/* 8572 */
/* U+C07D */	0x5685	/*                                         <CJK> */,/* 8573 */
/* U+C07E */	0x5687	/*                                         <CJK> */,/* 8574 */
/* U+C07F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8575 */
/* U+C080 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8576 */
/* U+C081 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8577 */
/* U+C082 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8578 */
/* U+C083 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8579 */
/* U+C084 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8580 */
/* U+C085 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8581 */
/* U+C086 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8582 */
/* U+C087 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8583 */
/* U+C088 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8584 */
/* U+C089 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8585 */
/* U+C08A */	UNICODE_REPLACEMENT_CHARACTER,	/* 8586 */
/* U+C08B */	UNICODE_REPLACEMENT_CHARACTER,	/* 8587 */
/* U+C08C */	UNICODE_REPLACEMENT_CHARACTER,	/* 8588 */
/* U+C08D */	UNICODE_REPLACEMENT_CHARACTER,	/* 8589 */
/* U+C08E */	UNICODE_REPLACEMENT_CHARACTER,	/* 8590 */
/* U+C08F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8591 */
/* U+C090 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8592 */
/* U+C091 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8593 */
/* U+C092 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8594 */
/* U+C093 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8595 */
/* U+C094 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8596 */
/* U+C095 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8597 */
/* U+C096 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8598 */
/* U+C097 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8599 */
/* U+C098 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8600 */
/* U+C099 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8601 */
/* U+C09A */	UNICODE_REPLACEMENT_CHARACTER,	/* 8602 */
/* U+C09B */	UNICODE_REPLACEMENT_CHARACTER,	/* 8603 */
/* U+C09C */	UNICODE_REPLACEMENT_CHARACTER,	/* 8604 */
/* U+C09D */	UNICODE_REPLACEMENT_CHARACTER,	/* 8605 */
/* U+C09E */	UNICODE_REPLACEMENT_CHARACTER,	/* 8606 */
/* U+C09F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8607 */
/* U+C0A0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8608 */
/* U+C0A1 */	0x568F	/*                                         <CJK> */,/* 8609 */
/* U+C0A2 */	0x58D5	/*                                         <CJK> */,/* 8610 */
/* U+C0A3 */	0x58D3	/*                                         <CJK> */,/* 8611 */
/* U+C0A4 */	0x58D1	/*                                         <CJK> */,/* 8612 */
/* U+C0A5 */	0x58CE	/*                                         <CJK> */,/* 8613 */
/* U+C0A6 */	0x5B30	/*                                         <CJK> */,/* 8614 */
/* U+C0A7 */	0x5B2A	/*                                         <CJK> */,/* 8615 */
/* U+C0A8 */	0x5B24	/*                                         <CJK> */,/* 8616 */
/* U+C0A9 */	0x5B7A	/*                                         <CJK> */,/* 8617 */
/* U+C0AA */	0x5C37	/*                                         <CJK> */,/* 8618 */
/* U+C0AB */	0x5C68	/*                                         <CJK> */,/* 8619 */
/* U+C0AC */	0x5DBC	/*                                         <CJK> */,/* 8620 */
/* U+C0AD */	0x5DBA	/*                                         <CJK> */,/* 8621 */
/* U+C0AE */	0x5DBD	/*                                         <CJK> */,/* 8622 */
/* U+C0AF */	0x5DB8	/*                                         <CJK> */,/* 8623 */
/* U+C0B0 */	0x5E6B	/*                                         <CJK> */,/* 8624 */
/* U+C0B1 */	0x5F4C	/*                                         <CJK> */,/* 8625 */
/* U+C0B2 */	0x5FBD	/*                                         <CJK> */,/* 8626 */
/* U+C0B3 */	0x61C9	/*                                         <CJK> */,/* 8627 */
/* U+C0B4 */	0x61C2	/*                                         <CJK> */,/* 8628 */
/* U+C0B5 */	0x61C7	/*                                         <CJK> */,/* 8629 */
/* U+C0B6 */	0x61E6	/*                                         <CJK> */,/* 8630 */
/* U+C0B7 */	0x61CB	/*                                         <CJK> */,/* 8631 */
/* U+C0B8 */	0x6232	/*                                         <CJK> */,/* 8632 */
/* U+C0B9 */	0x6234	/*                                         <CJK> */,/* 8633 */
/* U+C0BA */	0x64CE	/*                                         <CJK> */,/* 8634 */
/* U+C0BB */	0x64CA	/*                                         <CJK> */,/* 8635 */
/* U+C0BC */	0x64D8	/*                                         <CJK> */,/* 8636 */
/* U+C0BD */	0x64E0	/*                                         <CJK> */,/* 8637 */
/* U+C0BE */	0x64F0	/*                                         <CJK> */,/* 8638 */
/* U+C0BF */	0x64E6	/*                                         <CJK> */,/* 8639 */
/* U+C0C0 */	0x64EC	/*                                         <CJK> */,/* 8640 */
/* U+C0C1 */	0x64F1	/*                                         <CJK> */,/* 8641 */
/* U+C0C2 */	0x64E2	/*                                         <CJK> */,/* 8642 */
/* U+C0C3 */	0x64ED	/*                                         <CJK> */,/* 8643 */
/* U+C0C4 */	0x6582	/*                                         <CJK> */,/* 8644 */
/* U+C0C5 */	0x6583	/*                                         <CJK> */,/* 8645 */
/* U+C0C6 */	0x66D9	/*                                         <CJK> */,/* 8646 */
/* U+C0C7 */	0x66D6	/*                                         <CJK> */,/* 8647 */
/* U+C0C8 */	0x6A80	/*                                         <CJK> */,/* 8648 */
/* U+C0C9 */	0x6A94	/*                                         <CJK> */,/* 8649 */
/* U+C0CA */	0x6A84	/*                                         <CJK> */,/* 8650 */
/* U+C0CB */	0x6AA2	/*                                         <CJK> */,/* 8651 */
/* U+C0CC */	0x6A9C	/*                                         <CJK> */,/* 8652 */
/* U+C0CD */	0x6ADB	/*                                         <CJK> */,/* 8653 */
/* U+C0CE */	0x6AA3	/*                                         <CJK> */,/* 8654 */
/* U+C0CF */	0x6A7E	/*                                         <CJK> */,/* 8655 */
/* U+C0D0 */	0x6A97	/*                                         <CJK> */,/* 8656 */
/* U+C0D1 */	0x6A90	/*                                         <CJK> */,/* 8657 */
/* U+C0D2 */	0x6AA0	/*                                         <CJK> */,/* 8658 */
/* U+C0D3 */	0x6B5C	/*                                         <CJK> */,/* 8659 */
/* U+C0D4 */	0x6BAE	/*                                         <CJK> */,/* 8660 */
/* U+C0D5 */	0x6BDA	/*                                         <CJK> */,/* 8661 */
/* U+C0D6 */	0x6C08	/*                                         <CJK> */,/* 8662 */
/* U+C0D7 */	0x6FD8	/*                                         <CJK> */,/* 8663 */
/* U+C0D8 */	0x6FF1	/*                                         <CJK> */,/* 8664 */
/* U+C0D9 */	0x6FDF	/*                                         <CJK> */,/* 8665 */
/* U+C0DA */	0x6FE0	/*                                         <CJK> */,/* 8666 */
/* U+C0DB */	0x6FDB	/*                                         <CJK> */,/* 8667 */
/* U+C0DC */	0x6FE4	/*                                         <CJK> */,/* 8668 */
/* U+C0DD */	0x6FEB	/*                                         <CJK> */,/* 8669 */
/* U+C0DE */	0x6FEF	/*                                         <CJK> */,/* 8670 */
/* U+C0DF */	0x6F80	/*                                         <CJK> */,/* 8671 */
/* U+C0E0 */	0x6FEC	/*                                         <CJK> */,/* 8672 */
/* U+C0E1 */	0x6FE1	/*                                         <CJK> */,/* 8673 */
/* U+C0E2 */	0x6FE9	/*                                         <CJK> */,/* 8674 */
/* U+C0E3 */	0x6FD5	/*                                         <CJK> */,/* 8675 */
/* U+C0E4 */	0x6FEE	/*                                         <CJK> */,/* 8676 */
/* U+C0E5 */	0x6FF0	/*                                         <CJK> */,/* 8677 */
/* U+C0E6 */	0x71E7	/*                                         <CJK> */,/* 8678 */
/* U+C0E7 */	0x71DF	/*                                         <CJK> */,/* 8679 */
/* U+C0E8 */	0x71EE	/*                                         <CJK> */,/* 8680 */
/* U+C0E9 */	0x71E6	/*                                         <CJK> */,/* 8681 */
/* U+C0EA */	0x71E5	/*                                         <CJK> */,/* 8682 */
/* U+C0EB */	0x71ED	/*                                         <CJK> */,/* 8683 */
/* U+C0EC */	0x71EC	/*                                         <CJK> */,/* 8684 */
/* U+C0ED */	0x71F4	/*                                         <CJK> */,/* 8685 */
/* U+C0EE */	0x71E0	/*                                         <CJK> */,/* 8686 */
/* U+C0EF */	0x7235	/*                                         <CJK> */,/* 8687 */
/* U+C0F0 */	0x7246	/*                                         <CJK> */,/* 8688 */
/* U+C0F1 */	0x7370	/*                                         <CJK> */,/* 8689 */
/* U+C0F2 */	0x7372	/*                                         <CJK> */,/* 8690 */
/* U+C0F3 */	0x74A9	/*                                         <CJK> */,/* 8691 */
/* U+C0F4 */	0x74B0	/*                                         <CJK> */,/* 8692 */
/* U+C0F5 */	0x74A6	/*                                         <CJK> */,/* 8693 */
/* U+C0F6 */	0x74A8	/*                                         <CJK> */,/* 8694 */
/* U+C0F7 */	0x7646	/*                                         <CJK> */,/* 8695 */
/* U+C0F8 */	0x7642	/*                                         <CJK> */,/* 8696 */
/* U+C0F9 */	0x764C	/*                                         <CJK> */,/* 8697 */
/* U+C0FA */	0x76EA	/*                                         <CJK> */,/* 8698 */
/* U+C0FB */	0x77B3	/*                                         <CJK> */,/* 8699 */
/* U+C0FC */	0x77AA	/*                                         <CJK> */,/* 8700 */
/* U+C0FD */	0x77B0	/*                                         <CJK> */,/* 8701 */
/* U+C0FE */	0x77AC	/*                                         <CJK> */,/* 8702 */
/* U+C0FF */	UNICODE_REPLACEMENT_CHARACTER,	/* 8703 */
/* U+C100 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8704 */
/* U+C101 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8705 */
/* U+C102 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8706 */
/* U+C103 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8707 */
/* U+C104 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8708 */
/* U+C105 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8709 */
/* U+C106 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8710 */
/* U+C107 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8711 */
/* U+C108 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8712 */
/* U+C109 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8713 */
/* U+C10A */	UNICODE_REPLACEMENT_CHARACTER,	/* 8714 */
/* U+C10B */	UNICODE_REPLACEMENT_CHARACTER,	/* 8715 */
/* U+C10C */	UNICODE_REPLACEMENT_CHARACTER,	/* 8716 */
/* U+C10D */	UNICODE_REPLACEMENT_CHARACTER,	/* 8717 */
/* U+C10E */	UNICODE_REPLACEMENT_CHARACTER,	/* 8718 */
/* U+C10F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8719 */
/* U+C110 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8720 */
/* U+C111 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8721 */
/* U+C112 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8722 */
/* U+C113 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8723 */
/* U+C114 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8724 */
/* U+C115 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8725 */
/* U+C116 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8726 */
/* U+C117 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8727 */
/* U+C118 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8728 */
/* U+C119 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8729 */
/* U+C11A */	UNICODE_REPLACEMENT_CHARACTER,	/* 8730 */
/* U+C11B */	UNICODE_REPLACEMENT_CHARACTER,	/* 8731 */
/* U+C11C */	UNICODE_REPLACEMENT_CHARACTER,	/* 8732 */
/* U+C11D */	UNICODE_REPLACEMENT_CHARACTER,	/* 8733 */
/* U+C11E */	UNICODE_REPLACEMENT_CHARACTER,	/* 8734 */
/* U+C11F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8735 */
/* U+C120 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8736 */
/* U+C121 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8737 */
/* U+C122 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8738 */
/* U+C123 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8739 */
/* U+C124 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8740 */
/* U+C125 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8741 */
/* U+C126 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8742 */
/* U+C127 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8743 */
/* U+C128 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8744 */
/* U+C129 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8745 */
/* U+C12A */	UNICODE_REPLACEMENT_CHARACTER,	/* 8746 */
/* U+C12B */	UNICODE_REPLACEMENT_CHARACTER,	/* 8747 */
/* U+C12C */	UNICODE_REPLACEMENT_CHARACTER,	/* 8748 */
/* U+C12D */	UNICODE_REPLACEMENT_CHARACTER,	/* 8749 */
/* U+C12E */	UNICODE_REPLACEMENT_CHARACTER,	/* 8750 */
/* U+C12F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8751 */
/* U+C130 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8752 */
/* U+C131 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8753 */
/* U+C132 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8754 */
/* U+C133 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8755 */
/* U+C134 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8756 */
/* U+C135 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8757 */
/* U+C136 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8758 */
/* U+C137 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8759 */
/* U+C138 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8760 */
/* U+C139 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8761 */
/* U+C13A */	UNICODE_REPLACEMENT_CHARACTER,	/* 8762 */
/* U+C13B */	UNICODE_REPLACEMENT_CHARACTER,	/* 8763 */
/* U+C13C */	UNICODE_REPLACEMENT_CHARACTER,	/* 8764 */
/* U+C13D */	UNICODE_REPLACEMENT_CHARACTER,	/* 8765 */
/* U+C13E */	UNICODE_REPLACEMENT_CHARACTER,	/* 8766 */
/* U+C13F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8767 */
/* U+C140 */	0x77A7	/*                                         <CJK> */,/* 8768 */
/* U+C141 */	0x77AD	/*                                         <CJK> */,/* 8769 */
/* U+C142 */	0x77EF	/*                                         <CJK> */,/* 8770 */
/* U+C143 */	0x78F7	/*                                         <CJK> */,/* 8771 */
/* U+C144 */	0x78FA	/*                                         <CJK> */,/* 8772 */
/* U+C145 */	0x78F4	/*                                         <CJK> */,/* 8773 */
/* U+C146 */	0x78EF	/*                                         <CJK> */,/* 8774 */
/* U+C147 */	0x7901	/*                                         <CJK> */,/* 8775 */
/* U+C148 */	0x79A7	/*                                         <CJK> */,/* 8776 */
/* U+C149 */	0x79AA	/*                                         <CJK> */,/* 8777 */
/* U+C14A */	0x7A57	/*                                         <CJK> */,/* 8778 */
/* U+C14B */	0x7ABF	/*                                         <CJK> */,/* 8779 */
/* U+C14C */	0x7C07	/*                                         <CJK> */,/* 8780 */
/* U+C14D */	0x7C0D	/*                                         <CJK> */,/* 8781 */
/* U+C14E */	0x7BFE	/*                                         <CJK> */,/* 8782 */
/* U+C14F */	0x7BF7	/*                                         <CJK> */,/* 8783 */
/* U+C150 */	0x7C0C	/*                                         <CJK> */,/* 8784 */
/* U+C151 */	0x7BE0	/*                                         <CJK> */,/* 8785 */
/* U+C152 */	0x7CE0	/*                                         <CJK> */,/* 8786 */
/* U+C153 */	0x7CDC	/*                                         <CJK> */,/* 8787 */
/* U+C154 */	0x7CDE	/*                                         <CJK> */,/* 8788 */
/* U+C155 */	0x7CE2	/*                                         <CJK> */,/* 8789 */
/* U+C156 */	0x7CDF	/*                                         <CJK> */,/* 8790 */
/* U+C157 */	0x7CD9	/*                                         <CJK> */,/* 8791 */
/* U+C158 */	0x7CDD	/*                                         <CJK> */,/* 8792 */
/* U+C159 */	0x7E2E	/*                                         <CJK> */,/* 8793 */
/* U+C15A */	0x7E3E	/*                                         <CJK> */,/* 8794 */
/* U+C15B */	0x7E46	/*                                         <CJK> */,/* 8795 */
/* U+C15C */	0x7E37	/*                                         <CJK> */,/* 8796 */
/* U+C15D */	0x7E32	/*                                         <CJK> */,/* 8797 */
/* U+C15E */	0x7E43	/*                                         <CJK> */,/* 8798 */
/* U+C15F */	0x7E2B	/*                                         <CJK> */,/* 8799 */
/* U+C160 */	0x7E3D	/*                                         <CJK> */,/* 8800 */
/* U+C161 */	0x7E31	/*                                         <CJK> */,/* 8801 */
/* U+C162 */	0x7E45	/*                                         <CJK> */,/* 8802 */
/* U+C163 */	0x7E41	/*                                         <CJK> */,/* 8803 */
/* U+C164 */	0x7E34	/*                                         <CJK> */,/* 8804 */
/* U+C165 */	0x7E39	/*                                         <CJK> */,/* 8805 */
/* U+C166 */	0x7E48	/*                                         <CJK> */,/* 8806 */
/* U+C167 */	0x7E35	/*                                         <CJK> */,/* 8807 */
/* U+C168 */	0x7E3F	/*                                         <CJK> */,/* 8808 */
/* U+C169 */	0x7E2F	/*                                         <CJK> */,/* 8809 */
/* U+C16A */	0x7F44	/*                                         <CJK> */,/* 8810 */
/* U+C16B */	0x7FF3	/*                                         <CJK> */,/* 8811 */
/* U+C16C */	0x7FFC	/*                                         <CJK> */,/* 8812 */
/* U+C16D */	0x8071	/*                                         <CJK> */,/* 8813 */
/* U+C16E */	0x8072	/*                                         <CJK> */,/* 8814 */
/* U+C16F */	0x8070	/*                                         <CJK> */,/* 8815 */
/* U+C170 */	0x806F	/*                                         <CJK> */,/* 8816 */
/* U+C171 */	0x8073	/*                                         <CJK> */,/* 8817 */
/* U+C172 */	0x81C6	/*                                         <CJK> */,/* 8818 */
/* U+C173 */	0x81C3	/*                                         <CJK> */,/* 8819 */
/* U+C174 */	0x81BA	/*                                         <CJK> */,/* 8820 */
/* U+C175 */	0x81C2	/*                                         <CJK> */,/* 8821 */
/* U+C176 */	0x81C0	/*                                         <CJK> */,/* 8822 */
/* U+C177 */	0x81BF	/*                                         <CJK> */,/* 8823 */
/* U+C178 */	0x81BD	/*                                         <CJK> */,/* 8824 */
/* U+C179 */	0x81C9	/*                                         <CJK> */,/* 8825 */
/* U+C17A */	0x81BE	/*                                         <CJK> */,/* 8826 */
/* U+C17B */	0x81E8	/*                                         <CJK> */,/* 8827 */
/* U+C17C */	0x8209	/*                                         <CJK> */,/* 8828 */
/* U+C17D */	0x8271	/*                                         <CJK> */,/* 8829 */
/* U+C17E */	0x85AA	/*                                         <CJK> */,/* 8830 */
/* U+C17F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8831 */
/* U+C180 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8832 */
/* U+C181 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8833 */
/* U+C182 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8834 */
/* U+C183 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8835 */
/* U+C184 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8836 */
/* U+C185 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8837 */
/* U+C186 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8838 */
/* U+C187 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8839 */
/* U+C188 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8840 */
/* U+C189 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8841 */
/* U+C18A */	UNICODE_REPLACEMENT_CHARACTER,	/* 8842 */
/* U+C18B */	UNICODE_REPLACEMENT_CHARACTER,	/* 8843 */
/* U+C18C */	UNICODE_REPLACEMENT_CHARACTER,	/* 8844 */
/* U+C18D */	UNICODE_REPLACEMENT_CHARACTER,	/* 8845 */
/* U+C18E */	UNICODE_REPLACEMENT_CHARACTER,	/* 8846 */
/* U+C18F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8847 */
/* U+C190 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8848 */
/* U+C191 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8849 */
/* U+C192 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8850 */
/* U+C193 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8851 */
/* U+C194 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8852 */
/* U+C195 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8853 */
/* U+C196 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8854 */
/* U+C197 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8855 */
/* U+C198 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8856 */
/* U+C199 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8857 */
/* U+C19A */	UNICODE_REPLACEMENT_CHARACTER,	/* 8858 */
/* U+C19B */	UNICODE_REPLACEMENT_CHARACTER,	/* 8859 */
/* U+C19C */	UNICODE_REPLACEMENT_CHARACTER,	/* 8860 */
/* U+C19D */	UNICODE_REPLACEMENT_CHARACTER,	/* 8861 */
/* U+C19E */	UNICODE_REPLACEMENT_CHARACTER,	/* 8862 */
/* U+C19F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8863 */
/* U+C1A0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8864 */
/* U+C1A1 */	0x8584	/*                                         <CJK> */,/* 8865 */
/* U+C1A2 */	0x857E	/*                                         <CJK> */,/* 8866 */
/* U+C1A3 */	0x859C	/*                                         <CJK> */,/* 8867 */
/* U+C1A4 */	0x8591	/*                                         <CJK> */,/* 8868 */
/* U+C1A5 */	0x8594	/*                                         <CJK> */,/* 8869 */
/* U+C1A6 */	0x85AF	/*                                         <CJK> */,/* 8870 */
/* U+C1A7 */	0x859B	/*                                         <CJK> */,/* 8871 */
/* U+C1A8 */	0x8587	/*                                         <CJK> */,/* 8872 */
/* U+C1A9 */	0x85A8	/*                                         <CJK> */,/* 8873 */
/* U+C1AA */	0x858A	/*                                         <CJK> */,/* 8874 */
/* U+C1AB */	0x8667	/*                                         <CJK> */,/* 8875 */
/* U+C1AC */	0x87C0	/*                                         <CJK> */,/* 8876 */
/* U+C1AD */	0x87D1	/*                                         <CJK> */,/* 8877 */
/* U+C1AE */	0x87B3	/*                                         <CJK> */,/* 8878 */
/* U+C1AF */	0x87D2	/*                                         <CJK> */,/* 8879 */
/* U+C1B0 */	0x87C6	/*                                         <CJK> */,/* 8880 */
/* U+C1B1 */	0x87AB	/*                                         <CJK> */,/* 8881 */
/* U+C1B2 */	0x87BB	/*                                         <CJK> */,/* 8882 */
/* U+C1B3 */	0x87BA	/*                                         <CJK> */,/* 8883 */
/* U+C1B4 */	0x87C8	/*                                         <CJK> */,/* 8884 */
/* U+C1B5 */	0x87CB	/*                                         <CJK> */,/* 8885 */
/* U+C1B6 */	0x893B	/*                                         <CJK> */,/* 8886 */
/* U+C1B7 */	0x8936	/*                                         <CJK> */,/* 8887 */
/* U+C1B8 */	0x8944	/*                                         <CJK> */,/* 8888 */
/* U+C1B9 */	0x8938	/*                                         <CJK> */,/* 8889 */
/* U+C1BA */	0x893D	/*                                         <CJK> */,/* 8890 */
/* U+C1BB */	0x89AC	/*                                         <CJK> */,/* 8891 */
/* U+C1BC */	0x8B0E	/*                                         <CJK> */,/* 8892 */
/* U+C1BD */	0x8B17	/*                                         <CJK> */,/* 8893 */
/* U+C1BE */	0x8B19	/*                                         <CJK> */,/* 8894 */
/* U+C1BF */	0x8B1B	/*                                         <CJK> */,/* 8895 */
/* U+C1C0 */	0x8B0A	/*                                         <CJK> */,/* 8896 */
/* U+C1C1 */	0x8B20	/*                                         <CJK> */,/* 8897 */
/* U+C1C2 */	0x8B1D	/*                                         <CJK> */,/* 8898 */
/* U+C1C3 */	0x8B04	/*                                         <CJK> */,/* 8899 */
/* U+C1C4 */	0x8B10	/*                                         <CJK> */,/* 8900 */
/* U+C1C5 */	0x8C41	/*                                         <CJK> */,/* 8901 */
/* U+C1C6 */	0x8C3F	/*                                         <CJK> */,/* 8902 */
/* U+C1C7 */	0x8C73	/*                                         <CJK> */,/* 8903 */
/* U+C1C8 */	0x8CFA	/*                                         <CJK> */,/* 8904 */
/* U+C1C9 */	0x8CFD	/*                                         <CJK> */,/* 8905 */
/* U+C1CA */	0x8CFC	/*                                         <CJK> */,/* 8906 */
/* U+C1CB */	0x8CF8	/*                                         <CJK> */,/* 8907 */
/* U+C1CC */	0x8CFB	/*                                         <CJK> */,/* 8908 */
/* U+C1CD */	0x8DA8	/*                                         <CJK> */,/* 8909 */
/* U+C1CE */	0x8E49	/*                                         <CJK> */,/* 8910 */
/* U+C1CF */	0x8E4B	/*                                         <CJK> */,/* 8911 */
/* U+C1D0 */	0x8E48	/*                                         <CJK> */,/* 8912 */
/* U+C1D1 */	0x8E4A	/*                                         <CJK> */,/* 8913 */
/* U+C1D2 */	0x8F44	/*                                         <CJK> */,/* 8914 */
/* U+C1D3 */	0x8F3E	/*                                         <CJK> */,/* 8915 */
/* U+C1D4 */	0x8F42	/*                                         <CJK> */,/* 8916 */
/* U+C1D5 */	0x8F45	/*                                         <CJK> */,/* 8917 */
/* U+C1D6 */	0x8F3F	/*                                         <CJK> */,/* 8918 */
/* U+C1D7 */	0x907F	/*                                         <CJK> */,/* 8919 */
/* U+C1D8 */	0x907D	/*                                         <CJK> */,/* 8920 */
/* U+C1D9 */	0x9084	/*                                         <CJK> */,/* 8921 */
/* U+C1DA */	0x9081	/*                                         <CJK> */,/* 8922 */
/* U+C1DB */	0x9082	/*                                         <CJK> */,/* 8923 */
/* U+C1DC */	0x9080	/*                                         <CJK> */,/* 8924 */
/* U+C1DD */	0x9139	/*                                         <CJK> */,/* 8925 */
/* U+C1DE */	0x91A3	/*                                         <CJK> */,/* 8926 */
/* U+C1DF */	0x919E	/*                                         <CJK> */,/* 8927 */
/* U+C1E0 */	0x919C	/*                                         <CJK> */,/* 8928 */
/* U+C1E1 */	0x934D	/*                                         <CJK> */,/* 8929 */
/* U+C1E2 */	0x9382	/*                                         <CJK> */,/* 8930 */
/* U+C1E3 */	0x9328	/*                                         <CJK> */,/* 8931 */
/* U+C1E4 */	0x9375	/*                                         <CJK> */,/* 8932 */
/* U+C1E5 */	0x934A	/*                                         <CJK> */,/* 8933 */
/* U+C1E6 */	0x9365	/*                                         <CJK> */,/* 8934 */
/* U+C1E7 */	0x934B	/*                                         <CJK> */,/* 8935 */
/* U+C1E8 */	0x9318	/*                                         <CJK> */,/* 8936 */
/* U+C1E9 */	0x937E	/*                                         <CJK> */,/* 8937 */
/* U+C1EA */	0x936C	/*                                         <CJK> */,/* 8938 */
/* U+C1EB */	0x935B	/*                                         <CJK> */,/* 8939 */
/* U+C1EC */	0x9370	/*                                         <CJK> */,/* 8940 */
/* U+C1ED */	0x935A	/*                                         <CJK> */,/* 8941 */
/* U+C1EE */	0x9354	/*                                         <CJK> */,/* 8942 */
/* U+C1EF */	0x95CA	/*                                         <CJK> */,/* 8943 */
/* U+C1F0 */	0x95CB	/*                                         <CJK> */,/* 8944 */
/* U+C1F1 */	0x95CC	/*                                         <CJK> */,/* 8945 */
/* U+C1F2 */	0x95C8	/*                                         <CJK> */,/* 8946 */
/* U+C1F3 */	0x95C6	/*                                         <CJK> */,/* 8947 */
/* U+C1F4 */	0x96B1	/*                                         <CJK> */,/* 8948 */
/* U+C1F5 */	0x96B8	/*                                         <CJK> */,/* 8949 */
/* U+C1F6 */	0x96D6	/*                                         <CJK> */,/* 8950 */
/* U+C1F7 */	0x971C	/*                                         <CJK> */,/* 8951 */
/* U+C1F8 */	0x971E	/*                                         <CJK> */,/* 8952 */
/* U+C1F9 */	0x97A0	/*                                         <CJK> */,/* 8953 */
/* U+C1FA */	0x97D3	/*                                         <CJK> */,/* 8954 */
/* U+C1FB */	0x9846	/*                                         <CJK> */,/* 8955 */
/* U+C1FC */	0x98B6	/*                                         <CJK> */,/* 8956 */
/* U+C1FD */	0x9935	/*                                         <CJK> */,/* 8957 */
/* U+C1FE */	0x9A01	/*                                         <CJK> */,/* 8958 */
/* U+C1FF */	UNICODE_REPLACEMENT_CHARACTER,	/* 8959 */
/* U+C200 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8960 */
/* U+C201 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8961 */
/* U+C202 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8962 */
/* U+C203 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8963 */
/* U+C204 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8964 */
/* U+C205 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8965 */
/* U+C206 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8966 */
/* U+C207 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8967 */
/* U+C208 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8968 */
/* U+C209 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8969 */
/* U+C20A */	UNICODE_REPLACEMENT_CHARACTER,	/* 8970 */
/* U+C20B */	UNICODE_REPLACEMENT_CHARACTER,	/* 8971 */
/* U+C20C */	UNICODE_REPLACEMENT_CHARACTER,	/* 8972 */
/* U+C20D */	UNICODE_REPLACEMENT_CHARACTER,	/* 8973 */
/* U+C20E */	UNICODE_REPLACEMENT_CHARACTER,	/* 8974 */
/* U+C20F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8975 */
/* U+C210 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8976 */
/* U+C211 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8977 */
/* U+C212 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8978 */
/* U+C213 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8979 */
/* U+C214 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8980 */
/* U+C215 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8981 */
/* U+C216 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8982 */
/* U+C217 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8983 */
/* U+C218 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8984 */
/* U+C219 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8985 */
/* U+C21A */	UNICODE_REPLACEMENT_CHARACTER,	/* 8986 */
/* U+C21B */	UNICODE_REPLACEMENT_CHARACTER,	/* 8987 */
/* U+C21C */	UNICODE_REPLACEMENT_CHARACTER,	/* 8988 */
/* U+C21D */	UNICODE_REPLACEMENT_CHARACTER,	/* 8989 */
/* U+C21E */	UNICODE_REPLACEMENT_CHARACTER,	/* 8990 */
/* U+C21F */	UNICODE_REPLACEMENT_CHARACTER,	/* 8991 */
/* U+C220 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8992 */
/* U+C221 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8993 */
/* U+C222 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8994 */
/* U+C223 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8995 */
/* U+C224 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8996 */
/* U+C225 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8997 */
/* U+C226 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8998 */
/* U+C227 */	UNICODE_REPLACEMENT_CHARACTER,	/* 8999 */
/* U+C228 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9000 */
/* U+C229 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9001 */
/* U+C22A */	UNICODE_REPLACEMENT_CHARACTER,	/* 9002 */
/* U+C22B */	UNICODE_REPLACEMENT_CHARACTER,	/* 9003 */
/* U+C22C */	UNICODE_REPLACEMENT_CHARACTER,	/* 9004 */
/* U+C22D */	UNICODE_REPLACEMENT_CHARACTER,	/* 9005 */
/* U+C22E */	UNICODE_REPLACEMENT_CHARACTER,	/* 9006 */
/* U+C22F */	UNICODE_REPLACEMENT_CHARACTER,	/* 9007 */
/* U+C230 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9008 */
/* U+C231 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9009 */
/* U+C232 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9010 */
/* U+C233 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9011 */
/* U+C234 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9012 */
/* U+C235 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9013 */
/* U+C236 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9014 */
/* U+C237 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9015 */
/* U+C238 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9016 */
/* U+C239 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9017 */
/* U+C23A */	UNICODE_REPLACEMENT_CHARACTER,	/* 9018 */
/* U+C23B */	UNICODE_REPLACEMENT_CHARACTER,	/* 9019 */
/* U+C23C */	UNICODE_REPLACEMENT_CHARACTER,	/* 9020 */
/* U+C23D */	UNICODE_REPLACEMENT_CHARACTER,	/* 9021 */
/* U+C23E */	UNICODE_REPLACEMENT_CHARACTER,	/* 9022 */
/* U+C23F */	UNICODE_REPLACEMENT_CHARACTER,	/* 9023 */
/* U+C240 */	0x99FF	/*                                         <CJK> */,/* 9024 */
/* U+C241 */	0x9BAE	/*                                         <CJK> */,/* 9025 */
/* U+C242 */	0x9BAB	/*                                         <CJK> */,/* 9026 */
/* U+C243 */	0x9BAA	/*                                         <CJK> */,/* 9027 */
/* U+C244 */	0x9BAD	/*                                         <CJK> */,/* 9028 */
/* U+C245 */	0x9D3B	/*                                         <CJK> */,/* 9029 */
/* U+C246 */	0x9D3F	/*                                         <CJK> */,/* 9030 */
/* U+C247 */	0x9E8B	/*                                         <CJK> */,/* 9031 */
/* U+C248 */	0x9ECF	/*                                         <CJK> */,/* 9032 */
/* U+C249 */	0x9EDE	/*                                         <CJK> */,/* 9033 */
/* U+C24A */	0x9EDC	/*                                         <CJK> */,/* 9034 */
/* U+C24B */	0x9EDD	/*                                         <CJK> */,/* 9035 */
/* U+C24C */	0x9EDB	/*                                         <CJK> */,/* 9036 */
/* U+C24D */	0x9F3E	/*                                         <CJK> */,/* 9037 */
/* U+C24E */	0x9F4B	/*                                         <CJK> */,/* 9038 */
/* U+C24F */	0x53E2	/*                                         <CJK> */,/* 9039 */
/* U+C250 */	0x5695	/*                                         <CJK> */,/* 9040 */
/* U+C251 */	0x56AE	/*                                         <CJK> */,/* 9041 */
/* U+C252 */	0x58D9	/*                                         <CJK> */,/* 9042 */
/* U+C253 */	0x58D8	/*                                         <CJK> */,/* 9043 */
/* U+C254 */	0x5B38	/*                                         <CJK> */,/* 9044 */
/* U+C255 */	0x5F5D	/*                                         <CJK> */,/* 9045 */
/* U+C256 */	0x61E3	/*                                         <CJK> */,/* 9046 */
/* U+C257 */	0x6233	/*                                         <CJK> */,/* 9047 */
/* U+C258 */	0x64F4	/*                                         <CJK> */,/* 9048 */
/* U+C259 */	0x64F2	/*                                         <CJK> */,/* 9049 */
/* U+C25A */	0x64FE	/*                                         <CJK> */,/* 9050 */
/* U+C25B */	0x6506	/*                                         <CJK> */,/* 9051 */
/* U+C25C */	0x64FA	/*                                         <CJK> */,/* 9052 */
/* U+C25D */	0x64FB	/*                                         <CJK> */,/* 9053 */
/* U+C25E */	0x64F7	/*                                         <CJK> */,/* 9054 */
/* U+C25F */	0x65B7	/*                                         <CJK> */,/* 9055 */
/* U+C260 */	0x66DC	/*                                         <CJK> */,/* 9056 */
/* U+C261 */	0x6726	/*                                         <CJK> */,/* 9057 */
/* U+C262 */	0x6AB3	/*                                         <CJK> */,/* 9058 */
/* U+C263 */	0x6AAC	/*                                         <CJK> */,/* 9059 */
/* U+C264 */	0x6AC3	/*                                         <CJK> */,/* 9060 */
/* U+C265 */	0x6ABB	/*                                         <CJK> */,/* 9061 */
/* U+C266 */	0x6AB8	/*                                         <CJK> */,/* 9062 */
/* U+C267 */	0x6AC2	/*                                         <CJK> */,/* 9063 */
/* U+C268 */	0x6AAE	/*                                         <CJK> */,/* 9064 */
/* U+C269 */	0x6AAF	/*                                         <CJK> */,/* 9065 */
/* U+C26A */	0x6B5F	/*                                         <CJK> */,/* 9066 */
/* U+C26B */	0x6B78	/*                                         <CJK> */,/* 9067 */
/* U+C26C */	0x6BAF	/*                                         <CJK> */,/* 9068 */
/* U+C26D */	0x7009	/*                                         <CJK> */,/* 9069 */
/* U+C26E */	0x700B	/*                                         <CJK> */,/* 9070 */
/* U+C26F */	0x6FFE	/*                                         <CJK> */,/* 9071 */
/* U+C270 */	0x7006	/*                                         <CJK> */,/* 9072 */
/* U+C271 */	0x6FFA	/*                                         <CJK> */,/* 9073 */
/* U+C272 */	0x7011	/*                                         <CJK> */,/* 9074 */
/* U+C273 */	0x700F	/*                                         <CJK> */,/* 9075 */
/* U+C274 */	0x71FB	/*                                         <CJK> */,/* 9076 */
/* U+C275 */	0x71FC	/*                                         <CJK> */,/* 9077 */
/* U+C276 */	0x71FE	/*                                         <CJK> */,/* 9078 */
/* U+C277 */	0x71F8	/*                                         <CJK> */,/* 9079 */
/* U+C278 */	0x7377	/*                                         <CJK> */,/* 9080 */
/* U+C279 */	0x7375	/*                                         <CJK> */,/* 9081 */
/* U+C27A */	0x74A7	/*                                         <CJK> */,/* 9082 */
/* U+C27B */	0x74BF	/*                                         <CJK> */,/* 9083 */
/* U+C27C */	0x7515	/*                                         <CJK> */,/* 9084 */
/* U+C27D */	0x7656	/*                                         <CJK> */,/* 9085 */
/* U+C27E */	0x7658	/*                                         <CJK> */,/* 9086 */
/* U+C27F */	UNICODE_REPLACEMENT_CHARACTER,	/* 9087 */
/* U+C280 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9088 */
/* U+C281 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9089 */
/* U+C282 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9090 */
/* U+C283 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9091 */
/* U+C284 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9092 */
/* U+C285 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9093 */
/* U+C286 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9094 */
/* U+C287 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9095 */
/* U+C288 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9096 */
/* U+C289 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9097 */
/* U+C28A */	UNICODE_REPLACEMENT_CHARACTER,	/* 9098 */
/* U+C28B */	UNICODE_REPLACEMENT_CHARACTER,	/* 9099 */
/* U+C28C */	UNICODE_REPLACEMENT_CHARACTER,	/* 9100 */
/* U+C28D */	UNICODE_REPLACEMENT_CHARACTER,	/* 9101 */
/* U+C28E */	UNICODE_REPLACEMENT_CHARACTER,	/* 9102 */
/* U+C28F */	UNICODE_REPLACEMENT_CHARACTER,	/* 9103 */
/* U+C290 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9104 */
/* U+C291 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9105 */
/* U+C292 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9106 */
/* U+C293 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9107 */
/* U+C294 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9108 */
/* U+C295 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9109 */
/* U+C296 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9110 */
/* U+C297 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9111 */
/* U+C298 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9112 */
/* U+C299 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9113 */
/* U+C29A */	UNICODE_REPLACEMENT_CHARACTER,	/* 9114 */
/* U+C29B */	UNICODE_REPLACEMENT_CHARACTER,	/* 9115 */
/* U+C29C */	UNICODE_REPLACEMENT_CHARACTER,	/* 9116 */
/* U+C29D */	UNICODE_REPLACEMENT_CHARACTER,	/* 9117 */
/* U+C29E */	UNICODE_REPLACEMENT_CHARACTER,	/* 9118 */
/* U+C29F */	UNICODE_REPLACEMENT_CHARACTER,	/* 9119 */
/* U+C2A0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9120 */
/* U+C2A1 */	0x7652	/*                                         <CJK> */,/* 9121 */
/* U+C2A2 */	0x77BD	/*                                         <CJK> */,/* 9122 */
/* U+C2A3 */	0x77BF	/*                                         <CJK> */,/* 9123 */
/* U+C2A4 */	0x77BB	/*                                         <CJK> */,/* 9124 */
/* U+C2A5 */	0x77BC	/*                                         <CJK> */,/* 9125 */
/* U+C2A6 */	0x790E	/*                                         <CJK> */,/* 9126 */
/* U+C2A7 */	0x79AE	/*                                         <CJK> */,/* 9127 */
/* U+C2A8 */	0x7A61	/*                                         <CJK> */,/* 9128 */
/* U+C2A9 */	0x7A62	/*                                         <CJK> */,/* 9129 */
/* U+C2AA */	0x7A60	/*                                         <CJK> */,/* 9130 */
/* U+C2AB */	0x7AC4	/*                                         <CJK> */,/* 9131 */
/* U+C2AC */	0x7AC5	/*                                         <CJK> */,/* 9132 */
/* U+C2AD */	0x7C2B	/*                                         <CJK> */,/* 9133 */
/* U+C2AE */	0x7C27	/*                                         <CJK> */,/* 9134 */
/* U+C2AF */	0x7C2A	/*                                         <CJK> */,/* 9135 */
/* U+C2B0 */	0x7C1E	/*                                         <CJK> */,/* 9136 */
/* U+C2B1 */	0x7C23	/*                                         <CJK> */,/* 9137 */
/* U+C2B2 */	0x7C21	/*                                         <CJK> */,/* 9138 */
/* U+C2B3 */	0x7CE7	/*                                         <CJK> */,/* 9139 */
/* U+C2B4 */	0x7E54	/*                                         <CJK> */,/* 9140 */
/* U+C2B5 */	0x7E55	/*                                         <CJK> */,/* 9141 */
/* U+C2B6 */	0x7E5E	/*                                         <CJK> */,/* 9142 */
/* U+C2B7 */	0x7E5A	/*                                         <CJK> */,/* 9143 */
/* U+C2B8 */	0x7E61	/*                                         <CJK> */,/* 9144 */
/* U+C2B9 */	0x7E52	/*                                         <CJK> */,/* 9145 */
/* U+C2BA */	0x7E59	/*                                         <CJK> */,/* 9146 */
/* U+C2BB */	0x7F48	/*                                         <CJK> */,/* 9147 */
/* U+C2BC */	0x7FF9	/*                                         <CJK> */,/* 9148 */
/* U+C2BD */	0x7FFB	/*                                         <CJK> */,/* 9149 */
/* U+C2BE */	0x8077	/*                                         <CJK> */,/* 9150 */
/* U+C2BF */	0x8076	/*                                         <CJK> */,/* 9151 */
/* U+C2C0 */	0x81CD	/*                                         <CJK> */,/* 9152 */
/* U+C2C1 */	0x81CF	/*                                         <CJK> */,/* 9153 */
/* U+C2C2 */	0x820A	/*                                         <CJK> */,/* 9154 */
/* U+C2C3 */	0x85CF	/*                                         <CJK> */,/* 9155 */
/* U+C2C4 */	0x85A9	/*                                         <CJK> */,/* 9156 */
/* U+C2C5 */	0x85CD	/*                                         <CJK> */,/* 9157 */
/* U+C2C6 */	0x85D0	/*                                         <CJK> */,/* 9158 */
/* U+C2C7 */	0x85C9	/*                                         <CJK> */,/* 9159 */
/* U+C2C8 */	0x85B0	/*                                         <CJK> */,/* 9160 */
/* U+C2C9 */	0x85BA	/*                                         <CJK> */,/* 9161 */
/* U+C2CA */	0x85B9	/*                                         <CJK> */,/* 9162 */
/* U+C2CB */	0x85A6	/*                                         <CJK> */,/* 9163 */
/* U+C2CC */	0x87EF	/*                                         <CJK> */,/* 9164 */
/* U+C2CD */	0x87EC	/*                                         <CJK> */,/* 9165 */
/* U+C2CE */	0x87F2	/*                                         <CJK> */,/* 9166 */
/* U+C2CF */	0x87E0	/*                                         <CJK> */,/* 9167 */
/* U+C2D0 */	0x8986	/*                                         <CJK> */,/* 9168 */
/* U+C2D1 */	0x89B2	/*                                         <CJK> */,/* 9169 */
/* U+C2D2 */	0x89F4	/*                                         <CJK> */,/* 9170 */
/* U+C2D3 */	0x8B28	/*                                         <CJK> */,/* 9171 */
/* U+C2D4 */	0x8B39	/*                                         <CJK> */,/* 9172 */
/* U+C2D5 */	0x8B2C	/*                                         <CJK> */,/* 9173 */
/* U+C2D6 */	0x8B2B	/*                                         <CJK> */,/* 9174 */
/* U+C2D7 */	0x8C50	/*                                         <CJK> */,/* 9175 */
/* U+C2D8 */	0x8D05	/*                                         <CJK> */,/* 9176 */
/* U+C2D9 */	0x8E59	/*                                         <CJK> */,/* 9177 */
/* U+C2DA */	0x8E63	/*                                         <CJK> */,/* 9178 */
/* U+C2DB */	0x8E66	/*                                         <CJK> */,/* 9179 */
/* U+C2DC */	0x8E64	/*                                         <CJK> */,/* 9180 */
/* U+C2DD */	0x8E5F	/*                                         <CJK> */,/* 9181 */
/* U+C2DE */	0x8E55	/*                                         <CJK> */,/* 9182 */
/* U+C2DF */	0x8EC0	/*                                         <CJK> */,/* 9183 */
/* U+C2E0 */	0x8F49	/*                                         <CJK> */,/* 9184 */
/* U+C2E1 */	0x8F4D	/*                                         <CJK> */,/* 9185 */
/* U+C2E2 */	0x9087	/*                                         <CJK> */,/* 9186 */
/* U+C2E3 */	0x9083	/*                                         <CJK> */,/* 9187 */
/* U+C2E4 */	0x9088	/*                                         <CJK> */,/* 9188 */
/* U+C2E5 */	0x91AB	/*                                         <CJK> */,/* 9189 */
/* U+C2E6 */	0x91AC	/*                                         <CJK> */,/* 9190 */
/* U+C2E7 */	0x91D0	/*                                         <CJK> */,/* 9191 */
/* U+C2E8 */	0x9394	/*                                         <CJK> */,/* 9192 */
/* U+C2E9 */	0x938A	/*                                         <CJK> */,/* 9193 */
/* U+C2EA */	0x9396	/*                                         <CJK> */,/* 9194 */
/* U+C2EB */	0x93A2	/*                                         <CJK> */,/* 9195 */
/* U+C2EC */	0x93B3	/*                                         <CJK> */,/* 9196 */
/* U+C2ED */	0x93AE	/*                                         <CJK> */,/* 9197 */
/* U+C2EE */	0x93AC	/*                                         <CJK> */,/* 9198 */
/* U+C2EF */	0x93B0	/*                                         <CJK> */,/* 9199 */
/* U+C2F0 */	0x9398	/*                                         <CJK> */,/* 9200 */
/* U+C2F1 */	0x939A	/*                                         <CJK> */,/* 9201 */
/* U+C2F2 */	0x9397	/*                                         <CJK> */,/* 9202 */
/* U+C2F3 */	0x95D4	/*                                         <CJK> */,/* 9203 */
/* U+C2F4 */	0x95D6	/*                                         <CJK> */,/* 9204 */
/* U+C2F5 */	0x95D0	/*                                         <CJK> */,/* 9205 */
/* U+C2F6 */	0x95D5	/*                                         <CJK> */,/* 9206 */
/* U+C2F7 */	0x96E2	/*                                         <CJK> */,/* 9207 */
/* U+C2F8 */	0x96DC	/*                                         <CJK> */,/* 9208 */
/* U+C2F9 */	0x96D9	/*                                         <CJK> */,/* 9209 */
/* U+C2FA */	0x96DB	/*                                         <CJK> */,/* 9210 */
/* U+C2FB */	0x96DE	/*                                         <CJK> */,/* 9211 */
/* U+C2FC */	0x9724	/*                                         <CJK> */,/* 9212 */
/* U+C2FD */	0x97A3	/*                                         <CJK> */,/* 9213 */
/* U+C2FE */	0x97A6	/*                                         <CJK> */,/* 9214 */
/* U+C2FF */	UNICODE_REPLACEMENT_CHARACTER,	/* 9215 */
/* U+C300 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9216 */
/* U+C301 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9217 */
/* U+C302 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9218 */
/* U+C303 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9219 */
/* U+C304 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9220 */
/* U+C305 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9221 */
/* U+C306 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9222 */
/* U+C307 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9223 */
/* U+C308 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9224 */
/* U+C309 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9225 */
/* U+C30A */	UNICODE_REPLACEMENT_CHARACTER,	/* 9226 */
/* U+C30B */	UNICODE_REPLACEMENT_CHARACTER,	/* 9227 */
/* U+C30C */	UNICODE_REPLACEMENT_CHARACTER,	/* 9228 */
/* U+C30D */	UNICODE_REPLACEMENT_CHARACTER,	/* 9229 */
/* U+C30E */	UNICODE_REPLACEMENT_CHARACTER,	/* 9230 */
/* U+C30F */	UNICODE_REPLACEMENT_CHARACTER,	/* 9231 */
/* U+C310 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9232 */
/* U+C311 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9233 */
/* U+C312 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9234 */
/* U+C313 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9235 */
/* U+C314 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9236 */
/* U+C315 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9237 */
/* U+C316 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9238 */
/* U+C317 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9239 */
/* U+C318 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9240 */
/* U+C319 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9241 */
/* U+C31A */	UNICODE_REPLACEMENT_CHARACTER,	/* 9242 */
/* U+C31B */	UNICODE_REPLACEMENT_CHARACTER,	/* 9243 */
/* U+C31C */	UNICODE_REPLACEMENT_CHARACTER,	/* 9244 */
/* U+C31D */	UNICODE_REPLACEMENT_CHARACTER,	/* 9245 */
/* U+C31E */	UNICODE_REPLACEMENT_CHARACTER,	/* 9246 */
/* U+C31F */	UNICODE_REPLACEMENT_CHARACTER,	/* 9247 */
/* U+C320 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9248 */
/* U+C321 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9249 */
/* U+C322 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9250 */
/* U+C323 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9251 */
/* U+C324 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9252 */
/* U+C325 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9253 */
/* U+C326 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9254 */
/* U+C327 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9255 */
/* U+C328 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9256 */
/* U+C329 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9257 */
/* U+C32A */	UNICODE_REPLACEMENT_CHARACTER,	/* 9258 */
/* U+C32B */	UNICODE_REPLACEMENT_CHARACTER,	/* 9259 */
/* U+C32C */	UNICODE_REPLACEMENT_CHARACTER,	/* 9260 */
/* U+C32D */	UNICODE_REPLACEMENT_CHARACTER,	/* 9261 */
/* U+C32E */	UNICODE_REPLACEMENT_CHARACTER,	/* 9262 */
/* U+C32F */	UNICODE_REPLACEMENT_CHARACTER,	/* 9263 */
/* U+C330 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9264 */
/* U+C331 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9265 */
/* U+C332 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9266 */
/* U+C333 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9267 */
/* U+C334 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9268 */
/* U+C335 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9269 */
/* U+C336 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9270 */
/* U+C337 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9271 */
/* U+C338 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9272 */
/* U+C339 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9273 */
/* U+C33A */	UNICODE_REPLACEMENT_CHARACTER,	/* 9274 */
/* U+C33B */	UNICODE_REPLACEMENT_CHARACTER,	/* 9275 */
/* U+C33C */	UNICODE_REPLACEMENT_CHARACTER,	/* 9276 */
/* U+C33D */	UNICODE_REPLACEMENT_CHARACTER,	/* 9277 */
/* U+C33E */	UNICODE_REPLACEMENT_CHARACTER,	/* 9278 */
/* U+C33F */	UNICODE_REPLACEMENT_CHARACTER,	/* 9279 */
/* U+C340 */	0x97AD	/*                                         <CJK> */,/* 9280 */
/* U+C341 */	0x97F9	/*                                         <CJK> */,/* 9281 */
/* U+C342 */	0x984D	/*                                         <CJK> */,/* 9282 */
/* U+C343 */	0x984F	/*                                         <CJK> */,/* 9283 */
/* U+C344 */	0x984C	/*                                         <CJK> */,/* 9284 */
/* U+C345 */	0x984E	/*                                         <CJK> */,/* 9285 */
/* U+C346 */	0x9853	/*                                         <CJK> */,/* 9286 */
/* U+C347 */	0x98BA	/*                                         <CJK> */,/* 9287 */
/* U+C348 */	0x993E	/*                                         <CJK> */,/* 9288 */
/* U+C349 */	0x993F	/*                                         <CJK> */,/* 9289 */
/* U+C34A */	0x993D	/*                                         <CJK> */,/* 9290 */
/* U+C34B */	0x992E	/*                                         <CJK> */,/* 9291 */
/* U+C34C */	0x99A5	/*                                         <CJK> */,/* 9292 */
/* U+C34D */	0x9A0E	/*                                         <CJK> */,/* 9293 */
/* U+C34E */	0x9AC1	/*                                         <CJK> */,/* 9294 */
/* U+C34F */	0x9B03	/*                                         <CJK> */,/* 9295 */
/* U+C350 */	0x9B06	/*                                         <CJK> */,/* 9296 */
/* U+C351 */	0x9B4F	/*                                         <CJK> */,/* 9297 */
/* U+C352 */	0x9B4E	/*                                         <CJK> */,/* 9298 */
/* U+C353 */	0x9B4D	/*                                         <CJK> */,/* 9299 */
/* U+C354 */	0x9BCA	/*                                         <CJK> */,/* 9300 */
/* U+C355 */	0x9BC9	/*                                         <CJK> */,/* 9301 */
/* U+C356 */	0x9BFD	/*                                         <CJK> */,/* 9302 */
/* U+C357 */	0x9BC8	/*                                         <CJK> */,/* 9303 */
/* U+C358 */	0x9BC0	/*                                         <CJK> */,/* 9304 */
/* U+C359 */	0x9D51	/*                                         <CJK> */,/* 9305 */
/* U+C35A */	0x9D5D	/*                                         <CJK> */,/* 9306 */
/* U+C35B */	0x9D60	/*                                         <CJK> */,/* 9307 */
/* U+C35C */	0x9EE0	/*                                         <CJK> */,/* 9308 */
/* U+C35D */	0x9F15	/*                                         <CJK> */,/* 9309 */
/* U+C35E */	0x9F2C	/*                                         <CJK> */,/* 9310 */
/* U+C35F */	0x5133	/*                                         <CJK> */,/* 9311 */
/* U+C360 */	0x56A5	/*                                         <CJK> */,/* 9312 */
/* U+C361 */	0x58DE	/*                                         <CJK> */,/* 9313 */
/* U+C362 */	0x58DF	/*                                         <CJK> */,/* 9314 */
/* U+C363 */	0x58E2	/*                                         <CJK> */,/* 9315 */
/* U+C364 */	0x5BF5	/*                                         <CJK> */,/* 9316 */
/* U+C365 */	0x9F90	/*                                         <CJK> */,/* 9317 */
/* U+C366 */	0x5EEC	/*                                         <CJK> */,/* 9318 */
/* U+C367 */	0x61F2	/*                                         <CJK> */,/* 9319 */
/* U+C368 */	0x61F7	/*                                         <CJK> */,/* 9320 */
/* U+C369 */	0x61F6	/*                                         <CJK> */,/* 9321 */
/* U+C36A */	0x61F5	/*                                         <CJK> */,/* 9322 */
/* U+C36B */	0x6500	/*                                         <CJK> */,/* 9323 */
/* U+C36C */	0x650F	/*                                         <CJK> */,/* 9324 */
/* U+C36D */	0x66E0	/*                                         <CJK> */,/* 9325 */
/* U+C36E */	0x66DD	/*                                         <CJK> */,/* 9326 */
/* U+C36F */	0x6AE5	/*                                         <CJK> */,/* 9327 */
/* U+C370 */	0x6ADD	/*                                         <CJK> */,/* 9328 */
/* U+C371 */	0x6ADA	/*                                         <CJK> */,/* 9329 */
/* U+C372 */	0x6AD3	/*                                         <CJK> */,/* 9330 */
/* U+C373 */	0x701B	/*                                         <CJK> */,/* 9331 */
/* U+C374 */	0x701F	/*                                         <CJK> */,/* 9332 */
/* U+C375 */	0x7028	/*                                         <CJK> */,/* 9333 */
/* U+C376 */	0x701A	/*                                         <CJK> */,/* 9334 */
/* U+C377 */	0x701D	/*                                         <CJK> */,/* 9335 */
/* U+C378 */	0x7015	/*                                         <CJK> */,/* 9336 */
/* U+C379 */	0x7018	/*                                         <CJK> */,/* 9337 */
/* U+C37A */	0x7206	/*                                         <CJK> */,/* 9338 */
/* U+C37B */	0x720D	/*                                         <CJK> */,/* 9339 */
/* U+C37C */	0x7258	/*                                         <CJK> */,/* 9340 */
/* U+C37D */	0x72A2	/*                                         <CJK> */,/* 9341 */
/* U+C37E */	0x7378	/*                                         <CJK> */,/* 9342 */
/* U+C37F */	UNICODE_REPLACEMENT_CHARACTER,	/* 9343 */
/* U+C380 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9344 */
/* U+C381 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9345 */
/* U+C382 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9346 */
/* U+C383 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9347 */
/* U+C384 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9348 */
/* U+C385 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9349 */
/* U+C386 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9350 */
/* U+C387 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9351 */
/* U+C388 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9352 */
/* U+C389 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9353 */
/* U+C38A */	UNICODE_REPLACEMENT_CHARACTER,	/* 9354 */
/* U+C38B */	UNICODE_REPLACEMENT_CHARACTER,	/* 9355 */
/* U+C38C */	UNICODE_REPLACEMENT_CHARACTER,	/* 9356 */
/* U+C38D */	UNICODE_REPLACEMENT_CHARACTER,	/* 9357 */
/* U+C38E */	UNICODE_REPLACEMENT_CHARACTER,	/* 9358 */
/* U+C38F */	UNICODE_REPLACEMENT_CHARACTER,	/* 9359 */
/* U+C390 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9360 */
/* U+C391 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9361 */
/* U+C392 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9362 */
/* U+C393 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9363 */
/* U+C394 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9364 */
/* U+C395 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9365 */
/* U+C396 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9366 */
/* U+C397 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9367 */
/* U+C398 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9368 */
/* U+C399 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9369 */
/* U+C39A */	UNICODE_REPLACEMENT_CHARACTER,	/* 9370 */
/* U+C39B */	UNICODE_REPLACEMENT_CHARACTER,	/* 9371 */
/* U+C39C */	UNICODE_REPLACEMENT_CHARACTER,	/* 9372 */
/* U+C39D */	UNICODE_REPLACEMENT_CHARACTER,	/* 9373 */
/* U+C39E */	UNICODE_REPLACEMENT_CHARACTER,	/* 9374 */
/* U+C39F */	UNICODE_REPLACEMENT_CHARACTER,	/* 9375 */
/* U+C3A0 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9376 */
/* U+C3A1 */	0x737A	/*                                         <CJK> */,/* 9377 */
/* U+C3A2 */	0x74BD	/*                                         <CJK> */,/* 9378 */
/* U+C3A3 */	0x74CA	/*                                         <CJK> */,/* 9379 */
/* U+C3A4 */	0x74E3	/*                                         <CJK> */,/* 9380 */
/* U+C3A5 */	0x7587	/*                                         <CJK> */,/* 9381 */
/* U+C3A6 */	0x7586	/*                                         <CJK> */,/* 9382 */
/* U+C3A7 */	0x765F	/*                                         <CJK> */,/* 9383 */
/* U+C3A8 */	0x7661	/*                                         <CJK> */,/* 9384 */
/* U+C3A9 */	0x77C7	/*                                         <CJK> */,/* 9385 */
/* U+C3AA */	0x7919	/*                                         <CJK> */,/* 9386 */
/* U+C3AB */	0x79B1	/*                                         <CJK> */,/* 9387 */
/* U+C3AC */	0x7A6B	/*                                         <CJK> */,/* 9388 */
/* U+C3AD */	0x7A69	/*                                         <CJK> */,/* 9389 */
/* U+C3AE */	0x7C3E	/*                                         <CJK> */,/* 9390 */
/* U+C3AF */	0x7C3F	/*                                         <CJK> */,/* 9391 */
/* U+C3B0 */	0x7C38	/*                                         <CJK> */,/* 9392 */
/* U+C3B1 */	0x7C3D	/*                                         <CJK> */,/* 9393 */
/* U+C3B2 */	0x7C37	/*                                         <CJK> */,/* 9394 */
/* U+C3B3 */	0x7C40	/*                                         <CJK> */,/* 9395 */
/* U+C3B4 */	0x7E6B	/*                                         <CJK> */,/* 9396 */
/* U+C3B5 */	0x7E6D	/*                                         <CJK> */,/* 9397 */
/* U+C3B6 */	0x7E79	/*                                         <CJK> */,/* 9398 */
/* U+C3B7 */	0x7E69	/*                                         <CJK> */,/* 9399 */
/* U+C3B8 */	0x7E6A	/*                                         <CJK> */,/* 9400 */
/* U+C3B9 */	0x7F85	/*                                         <CJK> */,/* 9401 */
/* U+C3BA */	0x7E73	/*                                         <CJK> */,/* 9402 */
/* U+C3BB */	0x7FB6	/*                                         <CJK> */,/* 9403 */
/* U+C3BC */	0x7FB9	/*                                         <CJK> */,/* 9404 */
/* U+C3BD */	0x7FB8	/*                                         <CJK> */,/* 9405 */
/* U+C3BE */	0x81D8	/*                                         <CJK> */,/* 9406 */
/* U+C3BF */	0x85E9	/*                                         <CJK> */,/* 9407 */
/* U+C3C0 */	0x85DD	/*                                         <CJK> */,/* 9408 */
/* U+C3C1 */	0x85EA	/*                                         <CJK> */,/* 9409 */
/* U+C3C2 */	0x85D5	/*                                         <CJK> */,/* 9410 */
/* U+C3C3 */	0x85E4	/*                                         <CJK> */,/* 9411 */
/* U+C3C4 */	0x85E5	/*                                         <CJK> */,/* 9412 */
/* U+C3C5 */	0x85F7	/*                                         <CJK> */,/* 9413 */
/* U+C3C6 */	0x87FB	/*                                         <CJK> */,/* 9414 */
/* U+C3C7 */	0x8805	/*                                         <CJK> */,/* 9415 */
/* U+C3C8 */	0x880D	/*                                         <CJK> */,/* 9416 */
/* U+C3C9 */	0x87F9	/*                                         <CJK> */,/* 9417 */
/* U+C3CA */	0x87FE	/*                                         <CJK> */,/* 9418 */
/* U+C3CB */	0x8960	/*                                         <CJK> */,/* 9419 */
/* U+C3CC */	0x895F	/*                                         <CJK> */,/* 9420 */
/* U+C3CD */	0x8956	/*                                         <CJK> */,/* 9421 */
/* U+C3CE */	0x895E	/*                                         <CJK> */,/* 9422 */
/* U+C3CF */	0x8B41	/*                                         <CJK> */,/* 9423 */
/* U+C3D0 */	0x8B5C	/*                                         <CJK> */,/* 9424 */
/* U+C3D1 */	0x8B58	/*                                         <CJK> */,/* 9425 */
/* U+C3D2 */	0x8B49	/*                                         <CJK> */,/* 9426 */
/* U+C3D3 */	0x8B5A	/*                                         <CJK> */,/* 9427 */
/* U+C3D4 */	0x8B4E	/*                                         <CJK> */,/* 9428 */
/* U+C3D5 */	0x8B4F	/*                                         <CJK> */,/* 9429 */
/* U+C3D6 */	0x8B46	/*                                         <CJK> */,/* 9430 */
/* U+C3D7 */	0x8B59	/*                                         <CJK> */,/* 9431 */
/* U+C3D8 */	0x8D08	/*                                         <CJK> */,/* 9432 */
/* U+C3D9 */	0x8D0A	/*                                         <CJK> */,/* 9433 */
/* U+C3DA */	0x8E7C	/*                                         <CJK> */,/* 9434 */
/* U+C3DB */	0x8E72	/*                                         <CJK> */,/* 9435 */
/* U+C3DC */	0x8E87	/*                                         <CJK> */,/* 9436 */
/* U+C3DD */	0x8E76	/*                                         <CJK> */,/* 9437 */
/* U+C3DE */	0x8E6C	/*                                         <CJK> */,/* 9438 */
/* U+C3DF */	0x8E7A	/*                                         <CJK> */,/* 9439 */
/* U+C3E0 */	0x8E74	/*                                         <CJK> */,/* 9440 */
/* U+C3E1 */	0x8F54	/*                                         <CJK> */,/* 9441 */
/* U+C3E2 */	0x8F4E	/*                                         <CJK> */,/* 9442 */
/* U+C3E3 */	0x8FAD	/*                                         <CJK> */,/* 9443 */
/* U+C3E4 */	0x908A	/*                                         <CJK> */,/* 9444 */
/* U+C3E5 */	0x908B	/*                                         <CJK> */,/* 9445 */
/* U+C3E6 */	0x91B1	/*                                         <CJK> */,/* 9446 */
/* U+C3E7 */	0x91AE	/*                                         <CJK> */,/* 9447 */
/* U+C3E8 */	0x93E1	/*                                         <CJK> */,/* 9448 */
/* U+C3E9 */	0x93D1	/*                                         <CJK> */,/* 9449 */
/* U+C3EA */	0x93DF	/*                                         <CJK> */,/* 9450 */
/* U+C3EB */	0x93C3	/*                                         <CJK> */,/* 9451 */
/* U+C3EC */	0x93C8	/*                                         <CJK> */,/* 9452 */
/* U+C3ED */	0x93DC	/*                                         <CJK> */,/* 9453 */
/* U+C3EE */	0x93DD	/*                                         <CJK> */,/* 9454 */
/* U+C3EF */	0x93D6	/*                                         <CJK> */,/* 9455 */
/* U+C3F0 */	0x93E2	/*                                         <CJK> */,/* 9456 */
/* U+C3F1 */	0x93CD	/*                                         <CJK> */,/* 9457 */
/* U+C3F2 */	0x93D8	/*                                         <CJK> */,/* 9458 */
/* U+C3F3 */	0x93E4	/*                                         <CJK> */,/* 9459 */
/* U+C3F4 */	0x93D7	/*                                         <CJK> */,/* 9460 */
/* U+C3F5 */	0x93E8	/*                                         <CJK> */,/* 9461 */
/* U+C3F6 */	0x95DC	/*                                         <CJK> */,/* 9462 */
/* U+C3F7 */	0x96B4	/*                                         <CJK> */,/* 9463 */
/* U+C3F8 */	0x96E3	/*                                         <CJK> */,/* 9464 */
/* U+C3F9 */	0x972A	/*                                         <CJK> */,/* 9465 */
/* U+C3FA */	0x9727	/*                                         <CJK> */,/* 9466 */
/* U+C3FB */	0x9761	/*                                         <CJK> */,/* 9467 */
/* U+C3FC */	0x97DC	/*                                         <CJK> */,/* 9468 */
/* U+C3FD */	0x97FB	/*                                         <CJK> */,/* 9469 */
/* U+C3FE */	0x985E	/*                                         <CJK> */,/* 9470 */
/* U+C3FF */	UNICODE_REPLACEMENT_CHARACTER,	/* 9471 */
/* U+C400 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9472 */
/* U+C401 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9473 */
/* U+C402 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9474 */
/* U+C403 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9475 */
/* U+C404 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9476 */
/* U+C405 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9477 */
/* U+C406 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9478 */
/* U+C407 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9479 */
/* U+C408 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9480 */
/* U+C409 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9481 */
/* U+C40A */	UNICODE_REPLACEMENT_CHARACTER,	/* 9482 */
/* U+C40B */	UNICODE_REPLACEMENT_CHARACTER,	/* 9483 */
/* U+C40C */	UNICODE_REPLACEMENT_CHARACTER,	/* 9484 */
/* U+C40D */	UNICODE_REPLACEMENT_CHARACTER,	/* 9485 */
/* U+C40E */	UNICODE_REPLACEMENT_CHARACTER,	/* 9486 */
/* U+C40F */	UNICODE_REPLACEMENT_CHARACTER,	/* 9487 */
/* U+C410 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9488 */
/* U+C411 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9489 */
/* U+C412 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9490 */
/* U+C413 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9491 */
/* U+C414 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9492 */
/* U+C415 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9493 */
/* U+C416 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9494 */
/* U+C417 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9495 */
/* U+C418 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9496 */
/* U+C419 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9497 */
/* U+C41A */	UNICODE_REPLACEMENT_CHARACTER,	/* 9498 */
/* U+C41B */	UNICODE_REPLACEMENT_CHARACTER,	/* 9499 */
/* U+C41C */	UNICODE_REPLACEMENT_CHARACTER,	/* 9500 */
/* U+C41D */	UNICODE_REPLACEMENT_CHARACTER,	/* 9501 */
/* U+C41E */	UNICODE_REPLACEMENT_CHARACTER,	/* 9502 */
/* U+C41F */	UNICODE_REPLACEMENT_CHARACTER,	/* 9503 */
/* U+C420 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9504 */
/* U+C421 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9505 */
/* U+C422 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9506 */
/* U+C423 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9507 */
/* U+C424 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9508 */
/* U+C425 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9509 */
/* U+C426 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9510 */
/* U+C427 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9511 */
/* U+C428 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9512 */
/* U+C429 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9513 */
/* U+C42A */	UNICODE_REPLACEMENT_CHARACTER,	/* 9514 */
/* U+C42B */	UNICODE_REPLACEMENT_CHARACTER,	/* 9515 */
/* U+C42C */	UNICODE_REPLACEMENT_CHARACTER,	/* 9516 */
/* U+C42D */	UNICODE_REPLACEMENT_CHARACTER,	/* 9517 */
/* U+C42E */	UNICODE_REPLACEMENT_CHARACTER,	/* 9518 */
/* U+C42F */	UNICODE_REPLACEMENT_CHARACTER,	/* 9519 */
/* U+C430 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9520 */
/* U+C431 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9521 */
/* U+C432 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9522 */
/* U+C433 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9523 */
/* U+C434 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9524 */
/* U+C435 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9525 */
/* U+C436 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9526 */
/* U+C437 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9527 */
/* U+C438 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9528 */
/* U+C439 */	UNICODE_REPLACEMENT_CHARACTER,	/* 9529 */
/* U+C43A */	UNICODE_REPLACEMENT_CHARACTER,	/* 9530 */
/* U+C43B */	UNICODE_REPLACEMENT_CHARACTER,	/* 9531 */
/* U+C43C */	UNICODE_REPLACEMENT_CHARACTER,	/* 9532 */
/* U+C43D */	UNICODE_REPLACEMENT_CHARACTER,	/* 9533 */
/* U+C43E */	UNICODE_REPLACEMENT_CHARACTER,	/* 9534 */
/* U+C43F */	UNICODE_REPLACEMENT_CHARACTER,	/* 9535 */
/* U+C440 */	0x9858	/*                                         <CJK> */,/* 9536 */
/* U+C441 */	0x985B	/*                                         <CJK> */,/* 9537 */
/* U+C442 */	0x98BC	/*                                         <CJK> */,/* 9538 */
/* U+C443 */	0x9945	/*                                         <CJK> */,/* 9539 */
/* U+C444 */	0x9949	/*                                         <CJK> */,/* 9540 */
/* U+C445 */	0x9A16	/*                                         <CJK> */,/* 9541 */
/* U+C446 */	0x9A19	/*                                         <CJK> */,/* 9542 */
/* U+C447 */	0x9B0D	/*                                         <CJK> */,/* 9543 */
/* U+C448 */	0x9BE8	/*                                         <CJK> */,/* 9544 */
/* U+C449 */	0x9BE7	/*                                         <CJK> */,/* 9545 */
/* U+C44A */	0x9BD6	/*                                         <CJK> */,/* 9546 */
/* U+C44B */	0x9BDB	/*                                         <CJK> */,/* 9547 */
/* U+C44C */	0x9D89	/*                                         <CJK> */,/* 9548 */
/* U+C44D */	0x9D61	/*                                         <CJK> */,/* 9549 */
/* U+C44E */	0x9D72	/*                                         <CJK> */,/* 9550 */
/* U+C44F */	0x9D6A	/*                                         <CJK> */,/* 9551 */
/* U+C450 */	0x9D6C	/*                                         <CJK> */,/* 9552 */
/* U+C451 */	0x9E92	/*                                         <CJK> */,/* 9553 */
/* U+C452 */	0x9E97	/*                                         <CJK> */,/* 9554 */
/* U+C453 */	0x9E93	/*                                         <CJK> */,/* 9555 */
/* U+C454 */	0x9EB4	/*                                         <CJK> */,/* 9556 */
/* U+C455 */	0x52F8	/*                                         <CJK> */,/* 9557 */
/* U+C456 */	0x56A8	/*                                         <CJK> */,/* 9558 */
/* U+C457 */	0x56B7	/*                                         <CJK> */,/* 9559 */
/* U+C458 */	0x56B6	/*                                         <CJK> */,/* 9560 */
/* U+C459 */	0x56B4	/*                                         <CJK> */,/* 9561 */
/* U+C45A */	0x56BC	/*                                         <CJK> */,/* 9562 */
/* U+C45B */	0x58E4	/*                                         <CJK> */,/* 9563 */
/* U+C45C */	0x5B40	/*                                         <CJK> */,/* 9564 */
/* U+C45D */	0x5B43	/*                                         <CJK> */,/* 9565 */
/* U+C45E */	0x5B7D	/*                                         <CJK> */,/* 9566 */
/* U+C45F */	0x5BF6	/*                                         <CJK> */,/* 9567 */
/* U+C460 */	0x5DC9	/*                                         <CJK> */,/* 9568 */
/* U+C461 */	0x61F8	/*                                         <CJK> */,/* 9569 */
/* U+C462 */	0x61FA	/*                              